\NeedsTeXFormat{LaTeX2e}[1995/12/01]
\ProvidesClass{ACSM}[2023/07/19 v1.0 Istat template LaTeX document class for Advisory Committee on Statistical Methods]

\newcommand{\headlinecolor}{\normalcolor}

\LoadClassWithOptions{article}

\linespread{0.9}

% Page
% \setlength{\paperheight}{280mm}%
% \setlength{\paperwidth}{210mm}
% \setlength{\textwidth}{130.19mm}
% \setlength{\textheight}{195.43mm}

\newdimen\bibindent
\setlength\bibindent{\parindent}

%to avoid line breaks
% \tolerance=1000
% \setlength{\skip\footins}{0.5cm}
% \predisplaypenalty=0
% \clubpenalty=10000
% \widowpenalty=10000
% \setlength\footnotesep{5\p@}
% \interfootnotelinepenalty =10000

% Font
\makeatletter 
\renewcommand{\rmdefault}{ptm}

\let\@fnsymbol\@arabic

\renewenvironment{thebibliography}[1]
     {\chapter{\begin{center}\fontsize{14pt}{0pt}\fontfamily{phv}\bfseries{\bibname}\end{center}}%
      \@mkboth{\MakeUppercase\bibname}{\MakeUppercase\bibname}%
      \list{}%
           {\settowidth\labelwidth{\@biblabel{#1}}%
            \leftmargin\labelwidth
            \advance\leftmargin\labelsep
            \itemindent=-\leftmargin
            \@openbib@code
            \usecounter{enumiv}%
            \let\p@enumiv\@empty
            \renewcommand\theenumiv{\@arabic\c@enumiv}}%
      \sloppy
      \clubpenalty4000
      \@clubpenalty \clubpenalty
      \widowpenalty4000%
      \sfcode`\.\@m}
     {\def\@noitemerr
       {\@latex@warning{Empty `thebibliography' environment}%
      \endlist}}

%
\newcommand\indexstyle{\fontfamily{phv}\bfseries\fontsize{11}{0}\selectfont}

\renewcommand\contentsname{TABLE OF CONTENTS} 

\renewcommand\tableofcontents{% \ev is used for temporary storage of \parskip 
\blankpage
\newlength\ev 
\setlength{\ev}{\parskip} 
\parskip0pt 
% A line as 'TABLE OF CONTENTS' must not appear in the 
% Table of Contents. Hence we reproduce the \chapter* here except that 
% no entry is put into the toc file.      \clearpage  \global\@topnum\z@ 
     \@afterindenttrue 
     \begin{center} 
      {\indexstyle
             \interlinepenalty\@M 
       \large \bfseries  \contentsname\par\nobreak 
       \vskip21pt \vskip0.8\baselineskip 
      }\end{center} 
     \@afterheading 
     \@starttoc{toc}% 
\parskip\ev
\pagebreak
\blankpage} 

% Section Title and Number
\renewcommand*\l@section{\@dottedtocline{1}{1.5em}{2.3em}} 
\let\stdl@section\l@section 
\renewcommand*{\l@section}[2]{\vskip 1.3em 
  \stdl@section{\bf{#1}}{{#2}}} 
 
\renewcommand*\l@subsubsection{\@dottedtocline{1}{3.9em}{3.em}} 
\let\stdl@subsubsection\l@subsubsection 
\renewcommand*{\l@subsubsection}[2]{ 
  \stdl@subsubsection{\it{#1}}{{#2}}}   
  
% Section and List 
\let\Otemize =\itemize  
\let\Onumerate =\enumerate
\let\Oescription =\description % Zero the vertical spacing parameters
\def\Nospacing{\itemsep=2pt\topsep=0pt\partopsep=0pt\parskip=0pt\parsep=0pt}
% Redefine the environments in terms of the original values
\renewenvironment{itemize}{\vspace*{-1mm}\Otemize\Nospacing}%
                               {\endlist\vspace*{-1mm}}
\renewenvironment{enumerate}{\vspace*{-1mm}\Onumerate\Nospacing}
                               {\endlist\vspace*{-1mm}}

% Author
\newcommand{\authstyle}{\itshape\unboldmath\raggedright}

% Title

\newcommand{\TheTitle}{}
\newcommand{\Titleint}{}
\newcommand{\Title}[2][]{\renewcommand{\TheTitle}{#2}\renewcommand{\Titleint}{#1}}


% Number of Working Paper
\newcommand{\TheNumber}{}
\newcommand{\Number}[1]{\renewcommand{\TheNumber}{#1}}
         
% Abstract and Keywords          
\newcommand{\sommario}[1]{
\section*{Sommario}
{\noindent\itshape{#1}
\vskip 1.47em}}

\renewcommand{\abstract}[1]{
\section*{Abstract}
 {\noindent\itshape{#1}}
 \vskip 1.47em}

\newcommand{\keywordsit}[1]{\noindent
{\textbf{Parole Chiave:}}
{\normalsize{#1}
\hskip -2.0em \vskip 2.0em}}

\newcommand{\keywordseng}[1]{\noindent
{\textbf{Keywords:}}
{\normalsize{#1}
\vskip 2.0em}}

\newcommand{\source}[1]{\vskip 0.1em
{\fontfamily{phv}\itshape\fontsize{7pt}{0pt}\mdseries{Source:}}
{\fontfamily{phv}\fontsize{7pt}{0pt}\mdseries{#1}}}

% Section and Subsection
\newcommand\@sectitlestyle{\fontfamily{phv}\bfseries\fontsize{12}{0}\selectfont}
\newcommand\@subsectitlestyle{\fontfamily{phv}\fontsize{12}{0pt}\selectfont}
\newcommand\@subsubsectitlestyle{\fontfamily{phv}\itshape\fontsize{11}{0pt}\selectfont}

\renewcommand\section{\@startsection {section}{1}{\z@}%
  {-3.5ex \@plus -1ex \@minus -.2ex}%
  {2.3ex \@plus.2ex}%
  {\@sectitlestyle}}
  
\renewcommand{\thesection}{\arabic{section}.}


 
\renewcommand\subsection{\@startsection{subsection}{2}{\z@}%
{-3.5ex \@plus -1ex \@minus -.2ex}%
{2.3ex \@plus .2ex}%
{\@subsectitlestyle}}

\renewcommand{\thesubsection}{\arabic{section}.\arabic{subsection}}

\renewcommand\subsubsection{\@startsection{subsubsection}{3}{\z@}%
{-3.5ex \@plus -1ex \@minus -.2ex}%
{2.3ex \@plus .2ex}%
{\@subsubsectitlestyle}}
                   
% Title and Author Font                   
\renewcommand{\@maketitle}
{{\begin{center}\fontsize{14}{0pt}\fontfamily{phv}\fontseries{b}
\selectfont\headlinecolor\TheTitle\end{center}}
\vskip 1.24em 
{\begin{center}\fontsize{10}{0pt}\fontfamily{phv}\fontshape{it}
\selectfont\headlinecolor \begin{tabular}[c]{@{}c@{}}\@author\end{tabular}
\end{center}
\vskip -0.025em }
}


% Header and Footer
\DeclareOption{twoside}{\@twosidetrue} 
\ExecuteOptions{twoside}
\ProcessOptions

\RequirePackage{fancyhdr}
\RequirePackage[T1]{fontenc} 
\pagestyle{fancyplain} 

\newcommand{\blankpage}[1][fancyplain]{\clearpage\null\thispagestyle{#1}\clearpage}

\fancyhf{}
\newcommand{\intsize}{\fontsize{7}{0}\selectfont}  %8mm e 6 mm originale
%\newcommand{\carint}{\fontfamily{phv}\fontseries{n}\intsize\scriptsize\selectfont}
\newcommand{\carint}{\fontfamily{phv}\mdseries\fontsize{7}{0}\selectfont}

\newcommand{\intsizenum}{\fontsize{7}{0}\selectfont} %3mm e 5 mm originale
%\newcommand{\carintnum}{\fontfamily{phv}\fontseries{n}\intsizenum\selectfont}
\newcommand{\carintnum}{\fontfamily{phv}\mdseries\fontsize{7}{0}\selectfont}
% Layout Odd and Even Pages
%\fancyhead[LE]{\carint{SECOND WORKSHOP ON METHODOLOGIES FOR OFFICIAL STATISTICS | PROCEEDINGS}}
%\fancyhead[LO]{\carint{SESSION XXX| NAME OF THE SESSION}}
\fancyfoot{} % clear all footer fields
\fancyfoot[LE,RO]{\rule[1.5ex]{0pt}{1ex}\carintnum\thepage}
\fancyfoot[RE,LO]{\fontfamily{phv}\bfseries\fontsize{8}{0}\selectfont \carint {ISTITUTO NAZIONALE DI STATISTICA}}

% set headrule and footrule for every page
\renewcommand{\footruleskip}{-2.5pt} %space between line and text (header or footer)
\renewcommand{\headruleskip}{2.5pt} %space between line and text (header or footer)
\renewcommand{\plainheadrulewidth}{0.5pt}
\renewcommand{\plainfootrulewidth}{0.5pt}
\renewcommand{\headrulewidth}{\plainheadrulewidth}
\renewcommand{\footrulewidth}{\plainfootrulewidth}
\fancyheadoffset[RE, RO, LE,LO]{0cm} % 0 to have length of footrole and headrule equal to the text width
\makeatletter
%\newcommand\@sectitlestyle{\fontfamily{phv}\bfseries\fontsize{12}{0}\selectfont}
% \ohead{}% clear the outer head
% \addtokomafont{pagehead}{\fontfamily{phv}\bfseries\fontsize{8}{0}\selectfont}
% %\addtokomafont{pagehead}{\fontfamily{phv}\bfseries\fontsize{8}{0}\selectfont}
% \addtokomafont{pagefoot}{\fontfamily{phv}\bfseries\fontsize{8}{0}\selectfont}% Making the foot extra tiny to demonstrate
% \addtokomafont{pagenumber}{\fontfamily{phv}\bfseries\fontsize{8}{0}\selectfont}% that the page number can be controlled on its own. 
% \makeatother
%\renewcommand{\headruleskip}{0.4pt}%0.4
%\renewcommand{\footruleskip}{0.4pt}%0.4
% \renewcommand{\footrulewidth}{0.4pt}

% Footnote Space

\newif\iffnp@bottom \fnp@bottomtrue
\newif\iffnp@below \fnp@belowtrue

\def\@makecol{\setbox\@outputbox\box\@cclv
        \xdef\@freelist{\@freelist\@midlist}\global\let\@midlist\@empty
        \iffnp@below \@combinefloats \fi
        \let\fnp@textbottom\@textbottom
        \ifvoid\footins\else
                \setbox\@outputbox\vbox{\boxmaxdepth\maxdepth
                        \unvbox\@outputbox
                        \iffnp@bottom \@textbottom \fi
                        \vskip\skip\footins
                        \csname color@begingroup \endcsname
                        \csname normalcolor \endcsname
                        \footnoterule \unvbox\footins
                        \csname color@endgroup \endcsname}%
                \iffnp@bottom \let\@textbottom\relax \fi \fi
        \iffnp@below\else \@combinefloats \fi
        \ifvbox\@kludgeins \@makespecialcolbox
        \else \setbox\@outputbox\vbox to\@colht{\@texttop
                \dimen@\dp\@outputbox \unvbox\@outputbox
                \vskip-\dimen@ \@textbottom}\fi
        \let\@textbottom\fnp@textbottom
        \global \maxdepth \@maxdepth}
\ifx\@kludgeins\undefined \let\@kludgeins\voidb@x \fi


%%%%%%%%%% TABLE %%%%%%%%%%%%%%%%%%%%%%%%%

\newcounter{tavola} 
\setcounter{tavola}{0}
\newcommand{\captiontavfonts}{\fontfamily{phv}\fontsize{9}{5pt}\selectfont}
\newenvironment{captiontav}[2][]{\refstepcounter{tavola}\par\raggedright\medskip\noindent% 
\captiontavfonts\textbf {Tavola~\thetavola - #1#2}}{\medskip} 

\newcounter{prospetto} 
\setcounter{prospetto}{0}
\newcommand{\captionprofonts}{\fontfamily{phv}\fontsize{9}{5pt}\selectfont}
\newenvironment{captionpro}[2][]{\refstepcounter{prospetto}\par\raggedright\medskip\noindent% 
\captiontavfonts\textbf {Prospetto~\theprospetto - #1#2}}{\medskip} 

% Bullocks

\renewcommand{\labelitemi}{\scriptsize{$\bullet$}} 

% Table Style 

% \renewcommand{\thefigure}{\arabic{figure}}
% \renewcommand{\thetable}{\arabic{table}}


\def\tablestring{table}
\def\figurestring{figure}


\counterwithin{figure}{section}
\counterwithin{table}{section}
\renewcommand{\thefigure}{\arabic{section}.\arabic{figure}}
\renewcommand{\thetable}{\arabic{section}.\arabic{table}}


\newcommand{\captionfonts}{\fontfamily{phv}\bfseries\fontsize{8}{5pt}\selectfont}

\newcommand{\tabularfonts}{\fontfamily{phv}\fontsize{7}{10.5pt}\selectfont}%%%%%

\makeatletter 
\long\def\@makecaption#1#2{
  \vskip\abovecaptionskip\setbox\z@=\hbox{\count@=\number0#1}%
  {\captionfonts #1 - #2}    
  \vskip\belowcaptionskip
  \medskip
  }
\makeatother

\expandafter\edef\csname TPT@catcodes\endcsname
  {\catcode`\noexpand\@=\the\catcode`\@\catcode`\noexpand\*=\the\catcode`\*
  \let \csname TPT@catcode\endcsname \noexpand\UndeFyneD}
\catcode`\@=11
\catcode`\*=11

\@ifundefined{@tempboxb}{\@nameuse{newbox}\@tempboxb}{}

% Threepartable Package
 
\def\threeparttable{%
\vbox\bgroup\sloppy
\def\@captype{table}%
\topsep\z@
\let\fontfamily{phv}\small\@caption\TPT@caption
\let\fontfamily{phv}\scriptsize\LA@tabular\tabular 
\let\fontfamily{phv}\scriptsize\LA@tabular*\tabular*

\def\tabular\begin{tabular*}{\everyhbox{\aftergroup\TPT@endtab\everyhbox{}}\LA@tabular}

\def\tabular*{\everyhbox{\aftergroup\TPT@endtab \everyhbox{}}\LA@tabular*}}

\let\oldtabular\tabular* 
\let\endoldtabular\endtabular
\renewenvironment{tabular*}{\bgroup\tabularfonts\oldtabular}% 
                          {\endoldtabular\egroup}

\def\endthreeparttable{\egroup\global\@ignoretrue}

\def\TPT@endtab{\everyhbox{}%
\setbox\@tempboxb\lastbox   % Misura dell'ambiente tabular
\xdef\TPT@hsize{\hsize\the\wd\@tempboxb \linewidth\hsize}\TPT@hsize
\ifx\TPT@docapt\@und*fined\else
  \TPT@docapt \global\let\TPT@docapt\@und*fined \vskip.2\baselineskip
\fi \par \box\@tempboxb \parindent=1em}

\gdef\TPT@hsize{}

\def\TPT@caption#1[#2]#3{\gdef\TPT@docapt{\LA@caption{#1}[#2]{#3}}\ignorespaces}
\def\ftnotes{\TPT@hsize\list{}{\fontfamily{phv}\fontsize{7}{0pt}\mdseries
\topsep.1\baselineskip \partopsep\z@
\itemsep.1\baselineskip \parsep\z@ \itemindent2em\leftmargin\z@
\labelwidth2em\labelsep\z@}
\renewcommand{\makelabel}[1]{\mbox{{\fontfamily{phv}{##1}}}}
}

\newcommand{\superscript}[1]{\ensuremath{^{\fontfamily{phv}\text{#1}}}}

\def\ftnote#1{\rlap{{\superscript{#1}}}}% cambio del font
\let\endftenotes\endlist
\let\LA@caption\@caption

\TPT@catcodes 
\endinput

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%