/* Declinazione di responsabilità. 
I file rilasciati in formato testo sono provvisti anche dei programmi di importazione per STATA, SAS e R. 
L'Istat non garantisce che le funzioni contenute nei suddetti programmi siano esenti da errore e non si assume alcuna responsabilità sull’output ottenuto dal loro utilizzo.               
%macro grabpath;
%qsubstr(%sysget(SAS_EXECFILEPATH),1,%length(%sysget(SAS_EXECFILEPATH))-%length(%sysget(SAS_EXECFILEname)))
%mend grabpath;
%let path = %grabpath;
%let nomeFile =ISTAT_MFR_EUSILC_Cross_Microdata_2018_PERSONAL_REGISTER_(R-FILE)_Cross-Sectional_FILE_STRUCTURE_EXAMPLE.txt;
LIBNAME ISTAT "&path";
DATA ISTAT.EUSILC_Cross_A2018_PERSONAL_REG;

INFILE "&path&nomeFile" DLM='09'x  LRECL=32767 TRUNCOVER FIRSTOBS=2 IGNOREDOSEOF;
INPUT 
RB010 :5.   /*  YEAR OF THE SURVEY */
RB020 : $3.   /*  COUNTRY */
RB030 :9.   /*  PERSONAL ID */
RB031 :5.   /*  YEAR OF IMMIGRATION */
RB031_F :2.   /*  FLAG OF RB031 */
RB050 :16.   /*  PERSONAL CROSS-SECTIONAL WEIGHT */
RB050_F :2.   /*  FLAG OF RB050 */
RB070 :2.   /*  MONTH OF BIRTH */
RB070_F :2.   /*  FLAG OF RB070 */
RB080 :5.   /*  YEAR OF BIRTH */
RB080_F :2.   /*  FLAG OF RB080 */
RB090 :2.   /*  SEX */
RB090_F :2.   /*  FLAG OF RB090 */
RB200 :2.   /*  RESIDENTIAL STATUS */
RB200_F :2.   /*  FLAG OF RB200 */
RB210 :2.   /*  BASIC ACTIVITY STATUS */
RB210_F :2.   /*  FLAG OF RB210 */
RB220 :9.   /*  FATHER ID */
RB220_F :2.   /*  FLAG OF RB220 */
RB230 :9.   /*  MOTHER ID */
RB230_F :2.   /*  FLAG OF RB230 */
RB240 :9.   /*  SPOUSE/PARTNER ID */
RB240_F :2.   /*  FLAG OF RB240 */
RB245 :2.   /*  RESPONDENT STATUS */
RB245_F :2.   /*  FLAG OF RB245 */
RB250 :3.   /*  DATA STATUS */
RB250_F :2.   /*  FLAG OF RB250 */
RB260 :2.   /*  TYPE OF INTERVIEW */
RB260_F :2.   /*  FLAG OF RB260 */
RB270 :9.   /*  PERSONAL ID OF PROXY */
RB270_F :2.   /*  FLAG OF RB270 */
RL010 :3.   /*  EDUCATION AT PRE-SCHOOL */
RL010_F :2.   /*  FLAG OF RL010 */
RL020 :3.   /*  EDUCATION AT COMPULSORY SCHOOL */
RL020_F :2.   /*  FLAG OF RL020 */
RL030 :3.   /*  CHILDCARE AT CENTRE-BASED SERVICES */
RL030_F :2.   /*  FLAG OF RL030 */
RL040 :3.   /*  CHILDCARE AT DAY-CARE CENTRE */
RL040_F :2.   /*  FLAG OF RL040 */
RL050 :3.   /*  CHILDCARE BY A PROFESSIONAL CHILD-MINDER AT CHILD'S HOME OR AT CHILD-MINDER'S HOME */
RL050_F :2.   /*  FLAG OF RL050 */
RL060 :3.   /*  CHILDCARE BY GRAND-PARENTS, OTHER HOUSEHOLD MEMBERS (OUTSIDE PARENTS), OTHER RELATIVES, FRIENDS OR NEIGHBOURS */
RL060_F :2.   /*  FLAG OF RL060 */
RL070 :16.   /*  CHILDRENS' CROSS-SECTIONAL WEIGHT FOR CHILDCARE */
RL070_F :2.   /*  FLAG OF RL070 */
RX010 :3.   /*  AGE AT THE TIME OF INTERVIEW */
RX020 :3.   /*  AGE AT THE END OF INCOME REFERENCE PERIOD */
RX030 :6.   /*  HOUSEHOLD IDENTIFICATION NUMBER */
RX040 :14.   /*  WORK INTENSITY */
RX050 :2.   /*  LOW WORK INTENSITY STATUS */
RX060 :2.   /*  SEVERELY MATERIALLY DEPRIVED */
RX070 : $4.   /*  AT RISK OF POVERTY OR SOCIAL EXCLUSION */
;
LABEL 
RB010 = "YEAR OF THE SURVEY"
RB020 = "COUNTRY"
RB030 = "PERSONAL ID"
RB031 = "YEAR OF IMMIGRATION"
RB031_F = "FLAG OF RB031"
RB050 = "PERSONAL CROSS-SECTIONAL WEIGHT"
RB050_F = "FLAG OF RB050"
RB070 = "MONTH OF BIRTH"
RB070_F = "FLAG OF RB070"
RB080 = "YEAR OF BIRTH"
RB080_F = "FLAG OF RB080"
RB090 = "SEX"
RB090_F = "FLAG OF RB090"
RB200 = "RESIDENTIAL STATUS"
RB200_F = "FLAG OF RB200"
RB210 = "BASIC ACTIVITY STATUS"
RB210_F = "FLAG OF RB210"
RB220 = "FATHER ID"
RB220_F = "FLAG OF RB220"
RB230 = "MOTHER ID"
RB230_F = "FLAG OF RB230"
RB240 = "SPOUSE/PARTNER ID"
RB240_F = "FLAG OF RB240"
RB245 = "RESPONDENT STATUS"
RB245_F = "FLAG OF RB245"
RB250 = "DATA STATUS"
RB250_F = "FLAG OF RB250"
RB260 = "TYPE OF INTERVIEW"
RB260_F = "FLAG OF RB260"
RB270 = "PERSONAL ID OF PROXY"
RB270_F = "FLAG OF RB270"
RL010 = "EDUCATION AT PRE-SCHOOL"
RL010_F = "FLAG OF RL010"
RL020 = "EDUCATION AT COMPULSORY SCHOOL"
RL020_F = "FLAG OF RL020"
RL030 = "CHILDCARE AT CENTRE-BASED SERVICES"
RL030_F = "FLAG OF RL030"
RL040 = "CHILDCARE AT DAY-CARE CENTRE"
RL040_F = "FLAG OF RL040"
RL050 = "CHILDCARE BY A PROFESSIONAL CHILD-MINDER AT CHILD'S HOME OR AT CHILD-MINDER'S HOME"
RL050_F = "FLAG OF RL050"
RL060 = "CHILDCARE BY GRAND-PARENTS, OTHER HOUSEHOLD MEMBERS (OUTSIDE PARENTS), OTHER RELATIVES, FRIENDS OR NEIGHBOURS"
RL060_F = "FLAG OF RL060"
RL070 = "CHILDRENS' CROSS-SECTIONAL WEIGHT FOR CHILDCARE"
RL070_F = "FLAG OF RL070"
RX010 = "AGE AT THE TIME OF INTERVIEW"
RX020 = "AGE AT THE END OF INCOME REFERENCE PERIOD"
RX030 = "HOUSEHOLD IDENTIFICATION NUMBER"
RX040 = "WORK INTENSITY"
RX050 = "LOW WORK INTENSITY STATUS"
RX060 = "SEVERELY MATERIALLY DEPRIVED"
RX070 = "AT RISK OF POVERTY OR SOCIAL EXCLUSION"
;
RUN;
PROC FORMAT;
VALUE $RB01F /* RB020 */
"AT" = "¿sterreich
"BE" = "Belgique/Belg¿e
"BG" = "Bulgaria"
"CH" = "Switzerland"
"CY" = "Cyprus"
"CZ" = "Czech republic"
"DE" = "Deutschland"
"DK" = "Denmark"
"EE" = "Estonia"
"EL" = "Ell¿da
"ES" = "Espa¿a
"FI" = "Suomi"
"FR" = "France"
"HR" = "Croatia"
"HU" = "Hungary"
"IE" = "Ireland"
"IS" = "Iceland"
"IT" = "Italia"
"LT" = "Lithuania"
"LU" = "Luxembourg"
"LV" = "Latvia"
"ME" = "Montenegro"
"MK" = "The Former Yugoslav Republic of Macedonia (FYROM)"
"MT" = "Malta"
"NL" = "Nederland"
"NO" = "Norway"
"PL" = "Poland"
"PT" = "Portugal"
"RO" = "Romania"
"RS" = "Serbia"
"SE" = "Sverige"
"SI" = "Slovenia"
"SK" = "Slovak republic"
"TR" = "Turkey"
"UK" = "United Kingdom"
;
VALUE RB03F /* RB031 */
1938= "<=1938"
1943= "1943 - 1939"
1948= "1948 - 1944"
1953= "1953 - 1949"
1958= "1958 - 1954"
1963= "1963 - 1959"
1968= "1968 - 1964"
1973= "1973 - 1969"
1978= "1978 - 1974"
1983= "1983 - 1979"
1988= "1988 - 1984"
1993= "1993 - 1989"
1998= "1998 - 1994"
2003= "2003 - 1999"
2008= "2008 - 2004"
2013= "2013 - 2009"
2018= "2018 - 2014"
;
VALUE RB04F /* RB031_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable (no immigration for the person)"
;
VALUE RB06F /* RB050_F */
1= "Filled"
-2= "Not applicable (RB110 not equal to 1, 2, 3 or 4)"
-7= "Not applicable RB010 ne last year"
;
VALUE RB07F /* RB070 */
1= "January"
2= "February"
3= "March"
4= "April"
5= "May"
6= "June"
7= "July"
8= "August"
9= "September"
10= "October"
11= "November"
12= "December"
;
VALUE RB08F /* RB070_F */
1= "Filled"
-1= "Missing"
;
VALUE RB010F /* RB080_F */
1= "Filled"
-1= "Missing"
;
VALUE RB011F /* RB090 */
1= "Male"
2= "Female"
;
VALUE RB012F /* RB090_F */
1= "Filled"
-1= "Missing"
;
VALUE RB213F /* RB200 */
1= "Currently living in the household"
2= "Temporarily absent"
;
VALUE RB214F /* RB200_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable (RB110 not equal to 1, 2, 3 or 4)"
;
VALUE RB215F /* RB210 */
1= "At work"
2= "Unemployed"
3= "In retirement or early retirement or has given up business"
4= "Other inactive person"
;
VALUE RB216F /* RB210_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable (RB110 not equal to 1, 2, 3 or 4)"
;
VALUE RB218F /* RB220_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable ((father is not a household member) OR (RB110 not equal to 1, 2, 3 or 4))"
;
VALUE RB220F /* RB230_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable ((mother is not a household member) OR (RB110 not equal to 1, 2, 3 or 4))"
;
VALUE RB222F /* RB240_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable ((spouse/partner is not a household member) OR (RB110 not equal to 1, 2, 3 or 4))"
;
VALUE RB223F /* RB245 */
1= "Current household member aged 16 and over"
2= "Selected respondent"
3= "Non-selected respondent"
4= "Ineligible person"
;
VALUE RB224F /* RB245_F */
1= "Filled"
-2= "Not applicable (RB110 not equal to 1, 2, 3 or 4))"
;
VALUE RB225F /* RB250 */
11= "Information completed only from interview"
12= "Information completed only from registers"
13= "Information completed from both: interview and registers"
14= "Information completed from full-record imputation"
21= "Individual unable to respond (illness, incapacity, etc) and no proxy possible"
22= "Failed to return self-completed questionnaire"
23= "Refusal to co-operate"
31= "Person temporarily away and no proxy possible"
32= "No contact for other reasons"
33= "Information not completed: reason unknown"
;
VALUE RB226F /* RB250_F */
1= "Filled"
-2= "Not applicable (RB245 not equal to 1, 2 or 3)"
;
VALUE RB227F /* RB260 */
1= "Face to face interview-PAPI"
2= "Face to face interview-CAPI"
3= "CATI, telephone interview"
4= "Self-administered by respondent"
5= "Computer assisted web interviewing-CAWI"
6= "Face to face interview-PAPI with proxy"
7= "Face to face interview-CAPI with proxy"
8= "CATI, telephone interview with proxy"
9= "Self-administered by respondent with proxy"
10= "Computer assisted web interviewing-CAWI with proxy"
;
VALUE RB228F /* RB260_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable (RB250 not equal to 11 or 13) or RB245 eq 3"
;
VALUE RB230F /* RB270_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable (RB260 not equal to 6, 7, 8, 9, 10)"
;
VALUE RL032F /* RL010_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable ((RB110 not equal to 1, 2, 3 or 4) OR (person is not admitted to pre-school because of his or her age, is at compulsory school, or is more than 12 years old))"
;
VALUE RL034F /* RL020_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable ((RB110 not equal to 1, 2, 3 or 4) OR (person is not admitted to compulsory school because of his or her age, or is more than 12 years))"
;
VALUE RL036F /* RL030_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable ((RB110 not equal to 1, 2, 3 or 4) OR (person is neither at pre-school nor at school or is more than 12 years old))"
;
VALUE RL038F /* RL040_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable ((RB110 not equal to 1, 2, 3 or 4) OR (person is more than 12 years old))"
;
VALUE RL040F /* RL050_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable ((RB110 not equal to 1, 2, 3 or 4) OR (person is more than 12 years old))"
;
VALUE RL042F /* RL060_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable ((RB110 not equal to 1, 2, 3 or 4) OR (person is more than 12 years old))"
;
VALUE RL044F /* RL070_F */
1= "Filled"
-2= "Not applicable ((RB110 not equal to 1, 2, 3 or 4) OR (persons aged more than 12 years old at the date of interview))"
-7= "Not applicable RB010 ne last year"
;
VALUE RX049F /* RX050 */
0= "No Low Work Intensity"
1= "Low Work Intensity"
2= "Not Applicable"
;
VALUE RX050F /* RX060 */
0= "Not Severely materially deprived"
1= "Severely materially deprived"
;
format RB020 $RB01F.;
format RB031 RB03F.;
format RB031_F RB04F.;
format RB050_F RB06F.;
format RB070 RB07F.;
format RB070_F RB08F.;
format RB080_F RB010F.;
format RB090 RB011F.;
format RB090_F RB012F.;
format RB200 RB213F.;
format RB200_F RB214F.;
format RB210 RB215F.;
format RB210_F RB216F.;
format RB220_F RB218F.;
format RB230_F RB220F.;
format RB240_F RB222F.;
format RB245 RB223F.;
format RB245_F RB224F.;
format RB250 RB225F.;
format RB250_F RB226F.;
format RB260 RB227F.;
format RB260_F RB228F.;
format RB270_F RB230F.;
format RL010_F RL032F.;
format RL020_F RL034F.;
format RL030_F RL036F.;
format RL040_F RL038F.;
format RL050_F RL040F.;
format RL060_F RL042F.;
format RL070_F RL044F.;
format RX050 RX049F.;
format RX060 RX050F.;
RUN;
