#Declinazione di responsabilità. 
#I file rilasciati in formato testo sono provvisti anche dei programmi di importazione per STATA, SAS e R. 
#L'Istat non garantisce che le funzioni contenute nei suddetti programmi siano esenti da errore e non si assume alcuna responsabilità sull’output ottenuto dal loro utilizz
setwd(choose.dir(default = "", caption = "WHERE ARE MICRODATA?"))
direttorio = getwd()
fileInput = paste (direttorio, "/ISTAT_MFR_EUSILC_Cross_Microdata_2018_PERSONAL_REGISTER_(R-FILE)_Cross-Sectional_FILE_STRUCTURE_EXAMPLE.txt", sep="")
DF_EUSILC_Cross_A2018_PERSONAL_<- read.delim2 (fileInput,  header=T, sep="	",  quote="",  na.strings = ".")
attr(DF_EUSILC_Cross_A2018_PERSONAL_, "label") <- c(
"YEAR OF THE SURVEY",
"COUNTRY",
"PERSONAL ID",
"YEAR OF IMMIGRATION",
"FLAG OF RB031",
"PERSONAL CROSS-SECTIONAL WEIGHT",
"FLAG OF RB050",
"MONTH OF BIRTH",
"FLAG OF RB070",
"YEAR OF BIRTH",
"FLAG OF RB080",
"SEX",
"FLAG OF RB090",
"RESIDENTIAL STATUS",
"FLAG OF RB200",
"BASIC ACTIVITY STATUS",
"FLAG OF RB210",
"FATHER ID",
"FLAG OF RB220",
"MOTHER ID",
"FLAG OF RB230",
"SPOUSE/PARTNER ID",
"FLAG OF RB240",
"RESPONDENT STATUS",
"FLAG OF RB245",
"DATA STATUS",
"FLAG OF RB250",
"TYPE OF INTERVIEW",
"FLAG OF RB260",
"PERSONAL ID OF PROXY",
"FLAG OF RB270",
"EDUCATION AT PRE-SCHOOL",
"FLAG OF RL010",
"EDUCATION AT COMPULSORY SCHOOL",
"FLAG OF RL020",
"CHILDCARE AT CENTRE-BASED SERVICES",
"FLAG OF RL030",
"CHILDCARE AT DAY-CARE CENTRE",
"FLAG OF RL040",
"CHILDCARE BY A PROFESSIONAL CHILD-MINDER AT CHILD'S HOME OR AT CHILD-MINDER'S HOME",
"FLAG OF RL050",
"CHILDCARE BY GRAND-PARENTS, OTHER HOUSEHOLD MEMBERS (OUTSIDE PARENTS), OTHER RELATIVES, FRIENDS OR NEIGHBOURS",
"FLAG OF RL060",
"CHILDRENS' CROSS-SECTIONAL WEIGHT FOR CHILDCARE",
"FLAG OF RL070",
"AGE AT THE TIME OF INTERVIEW",
"AGE AT THE END OF INCOME REFERENCE PERIOD",
"HOUSEHOLD IDENTIFICATION NUMBER",
"WORK INTENSITY",
"LOW WORK INTENSITY STATUS",
"SEVERELY MATERIALLY DEPRIVED",
"AT RISK OF POVERTY OR SOCIAL EXCLUSION")

RB020_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$RB020, 
levels=c("AT", 
"BE", 
"BG", 
"CH", 
"CY", 
"CZ", 
"DE", 
"DK", 
"EE", 
"EL", 
"ES", 
"FI", 
"FR", 
"HR", 
"HU", 
"IE", 
"IS", 
"IT", 
"LT", 
"LU", 
"LV", 
"ME", 
"MK", 
"MT", 
"NL", 
"NO", 
"PL", 
"PT", 
"RO", 
"RS", 
"SE", 
"SI", 
"SK", 
"TR", 
"UK"), 
labels=c("¿sterreich", 
"Belgique/Belg¿e", 
"Bulgaria", 
"Switzerland", 
"Cyprus", 
"Czech republic", 
"Deutschland", 
"Denmark", 
"Estonia", 
"Ell¿da", 
"Espa¿a", 
"Suomi", 
"France", 
"Croatia", 
"Hungary", 
"Ireland", 
"Iceland", 
"Italia", 
"Lithuania", 
"Luxembourg", 
"Latvia", 
"Montenegro", 
"The Former Yugoslav Republic of Macedonia (FYROM)", 
"Malta", 
"Nederland", 
"Norway", 
"Poland", 
"Portugal", 
"Romania", 
"Serbia", 
"Sverige", 
"Slovenia", 
"Slovak republic", 
"Turkey", 
"United Kingdom"

RB031_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$RB031, 
levels=c(1938, 
1943, 
1948, 
1953, 
1958, 
1963, 
1968, 
1973, 
1978, 
1983, 
1988, 
1993, 
1998, 
2003, 
2008, 
2013, 
2018), 
labels=c("<=1938", 
"1943 - 1939", 
"1948 - 1944", 
"1953 - 1949", 
"1958 - 1954", 
"1963 - 1959", 
"1968 - 1964", 
"1973 - 1969", 
"1978 - 1974", 
"1983 - 1979", 
"1988 - 1984", 
"1993 - 1989", 
"1998 - 1994", 
"2003 - 1999", 
"2008 - 2004", 
"2013 - 2009", 
"2018 - 2014")) 


RB031_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$RB031_F, 
levels=c(1, 
-1, 
-2), 
labels=c("Filled", 
"Missing", 
"Not applicable (no immigration for the person)")) 


RB050_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$RB050_F, 
levels=c(1, 
-2, 
-7), 
labels=c("Filled", 
"Not applicable (RB110 not equal to 1, 2, 3 or 4)", 
"Not applicable RB010 ne last year")) 


RB070_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$RB070, 
levels=c(1, 
2, 
3, 
4, 
5, 
6, 
7, 
8, 
9, 
10, 
11, 
12), 
labels=c("January", 
"February", 
"March", 
"April", 
"May", 
"June", 
"July", 
"August", 
"September", 
"October", 
"November", 
"December")) 


RB070_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$RB070_F, 
levels=c(1, 
-1), 
labels=c("Filled", 
"Missing")) 


RB080_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$RB080_F, 
levels=c(1, 
-1), 
labels=c("Filled", 
"Missing")) 


RB090_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$RB090, 
levels=c(1, 
2), 
labels=c("Male", 
"Female")) 


RB090_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$RB090_F, 
levels=c(1, 
-1), 
labels=c("Filled", 
"Missing")) 


RB200_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$RB200, 
levels=c(1, 
2), 
labels=c("Currently living in the household", 
"Temporarily absent")) 


RB200_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$RB200_F, 
levels=c(1, 
-1, 
-2), 
labels=c("Filled", 
"Missing", 
"Not applicable (RB110 not equal to 1, 2, 3 or 4)")) 


RB210_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$RB210, 
levels=c(1, 
2, 
3, 
4), 
labels=c("At work", 
"Unemployed", 
"In retirement or early retirement or has given up business", 
"Other inactive person")) 


RB210_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$RB210_F, 
levels=c(1, 
-1, 
-2), 
labels=c("Filled", 
"Missing", 
"Not applicable (RB110 not equal to 1, 2, 3 or 4)")) 


RB220_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$RB220_F, 
levels=c(1, 
-1, 
-2), 
labels=c("Filled", 
"Missing", 
"Not applicable ((father is not a household member) OR (RB110 not equal to 1, 2, 3 or 4))")) 


RB230_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$RB230_F, 
levels=c(1, 
-1, 
-2), 
labels=c("Filled", 
"Missing", 
"Not applicable ((mother is not a household member) OR (RB110 not equal to 1, 2, 3 or 4))")) 


RB240_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$RB240_F, 
levels=c(1, 
-1, 
-2), 
labels=c("Filled", 
"Missing", 
"Not applicable ((spouse/partner is not a household member) OR (RB110 not equal to 1, 2, 3 or 4))")) 


RB245_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$RB245, 
levels=c(1, 
2, 
3, 
4), 
labels=c("Current household member aged 16 and over", 
"Selected respondent", 
"Non-selected respondent", 
"Ineligible person")) 


RB245_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$RB245_F, 
levels=c(1, 
-2), 
labels=c("Filled", 
"Not applicable (RB110 not equal to 1, 2, 3 or 4))")) 


RB250_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$RB250, 
levels=c(11, 
12, 
13, 
14, 
21, 
22, 
23, 
31, 
32, 
33), 
labels=c("Information completed only from interview", 
"Information completed only from registers", 
"Information completed from both: interview and registers", 
"Information completed from full-record imputation", 
"Individual unable to respond (illness, incapacity, etc) and no proxy possible", 
"Failed to return self-completed questionnaire", 
"Refusal to co-operate", 
"Person temporarily away and no proxy possible", 
"No contact for other reasons", 
"Information not completed: reason unknown")) 


RB250_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$RB250_F, 
levels=c(1, 
-2), 
labels=c("Filled", 
"Not applicable (RB245 not equal to 1, 2 or 3)")) 


RB260_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$RB260, 
levels=c(1, 
2, 
3, 
4, 
5, 
6, 
7, 
8, 
9, 
10), 
labels=c("Face to face interview-PAPI", 
"Face to face interview-CAPI", 
"CATI, telephone interview", 
"Self-administered by respondent", 
"Computer assisted web interviewing-CAWI", 
"Face to face interview-PAPI with proxy", 
"Face to face interview-CAPI with proxy", 
"CATI, telephone interview with proxy", 
"Self-administered by respondent with proxy", 
"Computer assisted web interviewing-CAWI with proxy")) 


RB260_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$RB260_F, 
levels=c(1, 
-1, 
-2), 
labels=c("Filled", 
"Missing", 
"Not applicable (RB250 not equal to 11 or 13) or RB245 eq 3")) 


RB270_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$RB270_F, 
levels=c(1, 
-1, 
-2), 
labels=c("Filled", 
"Missing", 
"Not applicable (RB260 not equal to 6, 7, 8, 9, 10)")) 


RL010_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$RL010_F, 
levels=c(1, 
-1, 
-2), 
labels=c("Filled", 
"Missing", 
"Not applicable ((RB110 not equal to 1, 2, 3 or 4) OR (person is not admitted to pre-school because of his or her age, is at compulsory school, or is more than 12 years old))")) 


RL020_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$RL020_F, 
levels=c(1, 
-1, 
-2), 
labels=c("Filled", 
"Missing", 
"Not applicable ((RB110 not equal to 1, 2, 3 or 4) OR (person is not admitted to compulsory school because of his or her age, or is more than 12 years))")) 


RL030_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$RL030_F, 
levels=c(1, 
-1, 
-2), 
labels=c("Filled", 
"Missing", 
"Not applicable ((RB110 not equal to 1, 2, 3 or 4) OR (person is neither at pre-school nor at school or is more than 12 years old))")) 


RL040_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$RL040_F, 
levels=c(1, 
-1, 
-2), 
labels=c("Filled", 
"Missing", 
"Not applicable ((RB110 not equal to 1, 2, 3 or 4) OR (person is more than 12 years old))")) 


RL050_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$RL050_F, 
levels=c(1, 
-1, 
-2), 
labels=c("Filled", 
"Missing", 
"Not applicable ((RB110 not equal to 1, 2, 3 or 4) OR (person is more than 12 years old))")) 


RL060_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$RL060_F, 
levels=c(1, 
-1, 
-2), 
labels=c("Filled", 
"Missing", 
"Not applicable ((RB110 not equal to 1, 2, 3 or 4) OR (person is more than 12 years old))")) 


RL070_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$RL070_F, 
levels=c(1, 
-2, 
-7), 
labels=c("Filled", 
"Not applicable ((RB110 not equal to 1, 2, 3 or 4) OR (persons aged more than 12 years old at the date of interview))", 
"Not applicable RB010 ne last year")) 


RX050_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$RX050, 
levels=c(0, 
1, 
2), 
labels=c("No Low Work Intensity", 
"Low Work Intensity", 
"Not Applicable")) 


RX060_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$RX060, 
levels=c(0, 
1), 
labels=c("Not Severely materially deprived", 
"Severely materially deprived")) 

save.image (file="DF_EUSILC_Cross_A2018_PERSONAL_.RData")
