/* Declinazione di responsabilità. 
I file rilasciati in formato testo sono provvisti anche dei programmi di importazione per STATA, SAS e R. 
L'Istat non garantisce che le funzioni contenute nei suddetti programmi siano esenti da errore e non si assume alcuna responsabilità sull’output ottenuto dal loro utilizzo.               
%macro grabpath;
%qsubstr(%sysget(SAS_EXECFILEPATH),1,%length(%sysget(SAS_EXECFILEPATH))-%length(%sysget(SAS_EXECFILEname)))
%mend grabpath;
%let path = %grabpath;
%let nomeFile =ISTAT_MFR_EUSILC_Cross_Microdata_2018_PERSONAL_DATA_(P-FILE)_Cross-Sectional_FILE_STRUCTURE_EXAMPLE.txt;
LIBNAME ISTAT "&path";
DATA ISTAT.EUSILC_Cross_A2018_PERSONAL_DAT;

INFILE "&path&nomeFile" DLM='09'x  LRECL=32767 TRUNCOVER FIRSTOBS=2 IGNOREDOSEOF;
INPUT 
PB010 :5.   /*  YEAR OF THE SURVEY */
PB020 : $3.   /*  COUNTRY */
PB030 :9.   /*  PERSONAL ID */
PB040 :16.   /*  PERSONAL CROSS-SECTIONAL WEIGHT */
PB040_F :2.   /*  FLAG OF PB040 */
PB060 :16.   /*  PERSONAL CROSS-SECTIONAL WEIGHT FOR SELECTED RESPONDENT */
PB060_F :3.   /*  FLAG OF PB060 */
PB100 :2.   /*  MONTH OF THE PERSONAL INTERVIEW */
PB100_F :2.   /*  FLAG OF PB100 */
PB110 :5.   /*  YEAR OF THE PERSONAL INTERVIEW */
PB110_F :2.   /*  FLAG OF PB110 */
PB120 :3.   /*  MINUTES TO COMPLETE THE PERSONAL QUESTIONNAIRE */
PB120_F :2.   /*  FLAG OF PB120 */
PB130 :2.   /*  MONTH OF BIRTH */
PB130_F :2.   /*  FLAG OF PB130 */
PB140 :5.   /*  YEAR OF BIRTH */
PB140_F :2.   /*  FLAG OF PB140 */
PB150 :2.   /*  SEX */
PB150_F :2.   /*  FLAG OF PB150 */
PB160 :9.   /*  FATHER ID */
PB160_F :2.   /*  FLAG OF PB160 */
PB170 :9.   /*  MOTHER ID */
PB170_F :2.   /*  FLAG OF PB170 */
PB180 :9.   /*  SPOUSE/PARTNER ID */
PB180_F :2.   /*  FLAG OF PB180 */
PB190 :2.   /*  MARITAL STATUS */
PB190_F :2.   /*  FLAG OF PB190 */
PB200 :2.   /*  CONSENSUAL UNION */
PB200_F :2.   /*  FLAG OF PB200 */
PB210 : $4.   /*  COUNTRY OF BIRTH */
PB210_F :2.   /*  FLAG OF PB210 */
PB220A : $4.   /*  CITIZENSHIP 1 */
PB220A_F :2.   /*  FLAG OF PB220A */
PE010 :2.   /*  CURRENT EDUCATION ACTIVITY */
PE010_F :2.   /*  FLAG OF PE010 */
PE020 :3.   /*  ISCED LEVEL CURRENTLY ATTENDED */
PE020_F :2.   /*  FLAG OF PE020 */
PE030 :5.   /*  YEAR WHEN HIGHEST LEVEL OF EDUCATION WAS ATTAINED */
PE030_F :2.   /*  FLAG OF PE030 */
PE040 :4.   /*  HIGHEST ISCED LEVEL ATTAINED */
PE040_F :2.   /*  FLAG OF PE040 */
PH010 :2.   /*  GENERAL HEALTH */
PH010_F :2.   /*  FLAG OF PH010 */
PH020 :2.   /*  SUFFER FROM ANY CHRONIC (LONG-STANDING) ILLNESS OR CONDITION */
PH020_F :2.   /*  FLAG OF PH020 */
PH030 :2.   /*  LIMITATION IN ACTIVITIES BECAUSE OF HEALTH PROBLEMS */
PH030_F :2.   /*  FLAG OF PH030 */
PH040 :2.   /*  UNMET NEED FOR MEDICAL EXAMINATION OR TREATMENT */
PH040_F :2.   /*  FLAG OF PH040 */
PH050 :2.   /*  MAIN REASON FOR UNMET NEED FOR MEDICAL EXAMINATION OR TREATMENT */
PH050_F :2.   /*  FLAG OF PH050 */
PH060 :2.   /*  UNMET NEED FOR DENTAL EXAMINATION OR TREATMENT */
PH060_F :2.   /*  FLAG OF PH060 */
PH070 :2.   /*  MAIN REASON FOR UNMET NEED FOR DENTAL EXAMINATION OR TREATMENT */
PH070_F :2.   /*  FLAG OF PH070 */
PL015 :2.   /*  WHETHER PERSON HAS EVER WORKED */
PL015_F :2.   /*  FLAG OF PL015 */
PL020 :2.   /*  ACTIVELY LOOKING FOR A JOB */
PL020_F :2.   /*  FLAG OF PL020 */
PL025 :2.   /*  AVAILABLE FOR WORK */
PL025_F :2.   /*  FLAG OF PL025 */
PL031 :3.   /*  SELF-DEFINED CURRENT ECONOMIC STATUS */
PL031_F :2.   /*  FLAG OF PL031 */
PL035 :2.   /*  WORKED AT LEAST ONE HOUR DURING THE PREVIOUS WEEK */
PL035_F :2.   /*  FLAG OF PL035 */
PL040 :2.   /*  STATUS IN EMPLOYMENT */
PL040_F :2.   /*  FLAG OF PL040 */
PL051 :3.   /*  OCCUPATION (ISCO-08 (COM)) */
PL051_F :2.   /*  FLAG OF PL051 */
PL060 :3.   /*  NUMBER OF HOURS USUALLY WORKED PER WEEK IN MAIN JOB */
PL060_F :2.   /*  FLAG OF PL060 */
PL073 :3.   /*  NUMBER OF MONTHS SPENT AT FULL-TIME WORK AS EMPLOYEE */
PL073_F :2.   /*  FLAG OF PL073 */
PL074 :3.   /*  NUMBER OF MONTHS SPENT AT PART-TIME WORK AS EMPLOYEE */
PL074_F :2.   /*  FLAG OF PL074 */
PL075 :3.   /*  NUMBER OF MONTHS SPENT AT FULL-TIME WORK AS SELF-EMPLOYED (INCLUDING FAMILY WORKER) */
PL075_F :2.   /*  FLAG OF PL075 */
PL076 :3.   /*  NUMBER OF MONTHS SPENT AT PART-TIME WORK AS SELF-EMPLOYED (INCLUDING FAMILY WORKER) */
PL076_F :2.   /*  FLAG OF PL076 */
PL080 :3.   /*  NUMBER OF MONTHS SPENT IN UNEMPLOYMENT */
PL080_F :2.   /*  FLAG OF PL080 */
PL085 :3.   /*  NUMBER OF MONTHS SPENT IN RETIREMENT OR EARLY RETIREMENT */
PL085_F :2.   /*  FLAG OF PL085 */
PL086 :3.   /*  NUMBER OF MONTHS SPENT AS DISABLED OR/AND UNFIT TO WORK */
PL086_F :2.   /*  FLAG OF PL086 */
PL087 :3.   /*  NUMBER OF MONTHS SPENT STUDYING */
PL087_F :2.   /*  FLAG OF PL087 */
PL088 :4.   /*  NUMBER OF MONTHS SPENT IN COMPULSORY MILITARY SERVICE */
PL088_F :3.   /*  FLAG OF PL088 */
PL089 :3.   /*  NUMBER OF MONTHS SPENT FULFILLING DOMESTIC TASKS AND CARE RESPONSIBILITIES */
PL089_F :2.   /*  FLAG OF PL089 */
PL090 :3.   /*  NUMBER OF MONTHS SPENT IN OTHER INACTIVITY */
PL090_F :2.   /*  FLAG OF PL090 */
PL100 :3.   /*  TOTAL NUMBER OF HOURS USUALLY WORKED IN SECOND, THIRD, ... JOBS */
PL100_F :2.   /*  FLAG OF PL100 */
PL111 : $6.   /*  NACE REV.2 */
PL111_F :2.   /*  FLAG OF PL111 */
PL120 :2.   /*  REASON FOR WORKING LESS THAN 30 HOURS */
PL120_F :2.   /*  FLAG OF PL120 */
PL130 :3.   /*  NUMBER OF PERSONS WORKING AT THE LOCAL UNIT */
PL130_F :2.   /*  FLAG OF PL130 */
PL140 :2.   /*  TYPE OF CONTRACT */
PL140_F :2.   /*  FLAG OF PL140 */
PL150 :2.   /*  MANAGERIAL POSITION */
PL150_F :2.   /*  FLAG OF PL150 */
PL160 :2.   /*  CHANGE OF JOB SINCE LAST YEAR */
PL160_F :2.   /*  FLAG OF PL160 */
PL170 :2.   /*  REASON TO CHANGE */
PL170_F :2.   /*  FLAG OF PL170 */
PL180 :3.   /*  MOST RECENT CHANGE IN THE INDIVIDUAL�S ACTIVITY STATUS 
PL180_F :2.   /*  FLAG OF PL180 */
PL190 :3.   /*  WHEN BEGAN FIRST REGULAR JOB */
PL190_F :2.   /*  FLAG OF PL190 */
PL200 :3.   /*  NUMBER OF YEARS SPENT IN PAID WORK */
PL200_F :2.   /*  FLAG OF PL200 */
PL211A :3.   /*  MAIN ACTIVITY IN JANUARY */
PL211A_F :2.   /*  FLAG OF PL211A */
PL211B :3.   /*  MAIN ACTIVITY IN FEBRUARY */
PL211B_F :2.   /*  FLAG OF PL211B */
PL211C :3.   /*  MAIN ACTIVITY IN MARCH */
PL211C_F :2.   /*  FLAG OF PL211C */
PL211D :3.   /*  MAIN ACTIVITY IN APRIL */
PL211D_F :2.   /*  FLAG OF PL211D */
PL211E :3.   /*  MAIN ACTIVITY IN MAY */
PL211E_F :2.   /*  FLAG OF PL211E */
PL211F :3.   /*  MAIN ACTIVITY IN JUNE */
PL211F_F :2.   /*  FLAG OF PL211F */
PL211G :3.   /*  MAIN ACTIVITY IN JULY */
PL211G_F :2.   /*  FLAG OF PL211G */
PL211H :3.   /*  MAIN ACTIVITY IN AUGUST */
PL211H_F :2.   /*  FLAG OF PL211H */
PL211I :3.   /*  MAIN ACTIVITY IN SEPTEMBER */
PL211I_F :2.   /*  FLAG OF PL211I */
PL211J :3.   /*  MAIN ACTIVITY IN OCTOBER */
PL211J_F :2.   /*  FLAG OF PL211J */
PL211K :3.   /*  MAIN ACTIVITY IN NOVEMBER */
PL211K_F :2.   /*  FLAG OF PL211K */
PL211L :3.   /*  MAIN ACTIVITY IN DECEMBER */
PL211L_F :2.   /*  FLAG OF PL211L */
PY010N :7.   /*  EMPLOYEE CASH OR NEAR CASH INCOME */
PY010N_F :2.   /*  FLAG OF PY010N */
PY010N_I :16.   /*  IMPUTATION FACTOR OF PY010N */
PY020N :7.   /*  NON-CASH EMPLOYEE INCOME */
PY020N_F :2.   /*  FLAG OF PY020N */
PY020N_I :16.   /*  IMPUTATION FACTOR OF PY020N */
PY021N :7.   /*  COMPANY CAR */
PY021N_F :2.   /*  FLAG OF PY021N */
PY021N_I :16.   /*  IMPUTATION FACTOR OF PY021N */
PY035N :7.   /*  CONTRIBUTIONS TO INDIVIDUAL PRIVATE PENSION PLANS */
PY035N_F :2.   /*  FLAG OF PY035N */
PY035N_I :16.   /*  IMPUTATION FACTOR OF PY035N */
PY050N :7.   /*  CASH PROFITS OR LOSSES FROM SELF-EMPLOYMENT */
PY050N_F :2.   /*  FLAG OF PY050N */
PY050N_I :16.   /*  IMPUTATION FACTOR OF PY050N */
PY080N :7.   /*  PENSION FROM INDIVIDUAL PRIVATE PLANS */
PY080N_F :2.   /*  FLAG OF PY080N */
PY080N_I :16.   /*  IMPUTATION FACTOR OF PY080N */
PY090N :7.   /*  UNEMPLOYMENT BENEFITS */
PY090N_F :2.   /*  FLAG OF PY090N */
PY090N_I :16.   /*  IMPUTATION FACTOR OF PY090N */
PY100N :7.   /*  OLD-AGE BENEFITS */
PY100N_F :2.   /*  FLAG OF PY100N */
PY100N_I :16.   /*  IMPUTATION FACTOR OF PY100N */
PY110N :7.   /*  SURVIVOR' BENEFITS */
PY110N_F :2.   /*  FLAG OF PY110N */
PY110N_I :16.   /*  IMPUTATION FACTOR OF PY110N */
PY120N :7.   /*  SICKNESS BENEFITS */
PY120N_F :2.   /*  FLAG OF PY120N */
PY120N_I :16.   /*  IMPUTATION FACTOR OF PY120N */
PY130N :7.   /*  DISABILITY BENEFITS */
PY130N_F :2.   /*  FLAG OF PY130N */
PY130N_I :16.   /*  IMPUTATION FACTOR OF PY130N */
PY140N :7.   /*  EDUCATION-RELATED ALLOWANCES */
PY140N_F :2.   /*  FLAG OF PY140N */
PY140N_I :16.   /*  IMPUTATION FACTOR OF PY140N */
PY010G :7.   /*  EMPLOYEE CASH OR NEAR CASH INCOME */
PY010G_F :2.   /*  FLAG OF PY010G */
PY010G_I :16.   /*  IMPUTATION FACTOR OF PY010G */
PY020G :7.   /*  NON-CASH EMPLOYEE INCOME */
PY020G_F :2.   /*  FLAG OF PY020G */
PY020G_I :16.   /*  IMPUTATION FACTOR OF PY020G */
PY021G :7.   /*  COMPANY CAR */
PY021G_F :2.   /*  FLAG OF PY021G */
PY021G_I :16.   /*  IMPUTATION FACTOR OF PY021G */
PY030G :7.   /*  EMPLOYER'S SOCIAL INSURANCE CONTRIBUTION */
PY030G_F :2.   /*  FLAG OF PY030G */
PY030G_I :16.   /*  IMPUTATION FACTOR OF PY030G */
PY031G :7.   /*  OPTIONAL EMPLOYER'S SOCIAL INSURANCE CONTRIBUTIONS */
PY031G_F :2.   /*  FLAG OF PY031G */
PY031G_I :16.   /*  IMPUTATION FACTOR OF PY031G */
PY035G :7.   /*  CONTRIBUTIONS TO INDIVIDUAL PRIVATE PENSION PLANS */
PY035G_F :2.   /*  FLAG OF PY035G */
PY035G_I :16.   /*  IMPUTATION FACTOR OF PY035G */
PY050G :7.   /*  CASH PROFITS OR LOSSES FROM SELF-EMPLOYMENT */
PY050G_F :2.   /*  FLAG OF PY050G */
PY050G_I :16.   /*  IMPUTATION FACTOR OF PY050G */
PY080G :7.   /*  PENSION FROM INDIVIDUAL PRIVATE PLANS */
PY080G_F :2.   /*  FLAG OF PY080G */
PY080G_I :16.   /*  IMPUTATION FACTOR OF PY080G */
PY090G :7.   /*  UNEMPLOYMENT BENEFITS */
PY090G_F :2.   /*  FLAG OF PY090G */
PY090G_I :16.   /*  IMPUTATION FACTOR OF PY090G */
PY091G :7.   /*  UNEMPLOYMENT BENEFITS (CONTRIBUTORY AND MEANS-TESTED) */
PY091G_F :2.   /*  FLAG OF PY091G */
PY092G :7.   /*  UNEMPLOYMENT BENEFITS (CONTRIBUTORY AND NON MEANS-TESTED) */
PY092G_F :2.   /*  FLAG OF PY092G */
PY093G :7.   /*  UNEMPLOYMENT BENEFITS (NON-CONTRIBUTORY AND MEANS-TESTED) */
PY093G_F :2.   /*  FLAG OF PY093G */
PY094G :7.   /*  UNEMPLOYMENT BENEFITS (NON-CONTRIBUTORY AND NON MEANS-TESTED) */
PY094G_F :2.   /*  FLAG OF PY094G */
PY100G :7.   /*  OLD-AGE BENEFITS */
PY100G_F :2.   /*  FLAG OF PY100G */
PY100G_I :16.   /*  IMPUTATION FACTOR OF PY100G */
PY101G :7.   /*  OLD-AGE BENEFITS (CONTRIBUTORY AND MEANS-TESTED) */
PY101G_F :2.   /*  FLAG OF PY101G */
PY102G :7.   /*  OLD-AGE BENEFITS (CONTRIBUTORY AND NON MEANS-TESTED) */
PY102G_F :2.   /*  FLAG OF PY102G */
PY103G :7.   /*  OLD-AGE BENEFITS (NON-CONTRIBUTORY AND MEANS-TESTED) */
PY103G_F :2.   /*  FLAG OF PY103G */
PY104G :7.   /*  OLD-AGE BENEFITS (NON-CONTRIBUTORY AND NON MEANS-TESTED) */
PY104G_F :2.   /*  FLAG OF PY104G */
PY110G :7.   /*  SURVIVOR' BENEFITS */
PY110G_F :2.   /*  FLAG OF PY110G */
PY110G_I :16.   /*  IMPUTATION FACTOR OF PY110G */
PY111G :7.   /*  SURVIVOR� BENEFITS (CONTRIBUTORY AND MEANS-TESTED) 
PY111G_F :2.   /*  FLAG OF PY111G */
PY112G :7.   /*  SURVIVOR� BENEFITS (CONTRIBUTORY AND NON MEANS-TESTED) 
PY112G_F :2.   /*  FLAG OF PY112G */
PY113G :7.   /*  SURVIVOR� BENEFITS (NON-CONTRIBUTORY AND MEANS-TESTED) 
PY113G_F :2.   /*  FLAG OF PY113G */
PY114G :7.   /*  SURVIVOR� BENEFITS (NON-CONTRIBUTORY AND NON MEANS-TESTED) 
PY114G_F :2.   /*  FLAG OF PY114G */
PY120G :7.   /*  SICKNESS BENEFITS */
PY120G_F :2.   /*  FLAG OF PY120G */
PY120G_I :16.   /*  IMPUTATION FACTOR OF PY120G */
PY121G :7.   /*  SICKNESS BENEFITS (CONTRIBUTORY AND MEANS-TESTED) */
PY121G_F :2.   /*  FLAG OF PY121G */
PY122G :7.   /*  SICKNESS BENEFITS (CONTRIBUTORY AND NON MEANS-TESTED) */
PY122G_F :2.   /*  FLAG OF PY122G */
PY123G :7.   /*  SICKNESS BENEFITS (NON-CONTRIBUTORY AND MEANS-TESTED) */
PY123G_F :2.   /*  FLAG OF PY123G */
PY124G :7.   /*  SICKNESS BENEFITS (NON-CONTRIBUTORY AND NON MEANS-TESTED) */
PY124G_F :2.   /*  FLAG OF PY124G */
PY130G :7.   /*  DISABILITY BENEFITS */
PY130G_F :2.   /*  FLAG OF PY130G */
PY130G_I :16.   /*  IMPUTATION FACTOR OF PY130G */
PY131G :7.   /*  DISABILITY BENEFITS (CONTRIBUTORY AND MEANS-TESTED) */
PY131G_F :2.   /*  FLAG OF PY131G */
PY132G :7.   /*  DISABILITY BENEFITS (CONTRIBUTORY AND NON MEANS-TESTED) */
PY132G_F :2.   /*  FLAG OF PY132G */
PY133G :7.   /*  DISABILITY BENEFITS (NON-CONTRIBUTORY AND MEANS-TESTED) */
PY133G_F :2.   /*  FLAG OF PY133G */
PY134G :7.   /*  DISABILITY BENEFITS (NON-CONTRIBUTORY AND NON MEANS-TESTED) */
PY134G_F :2.   /*  FLAG OF PY134G */
PY140G :7.   /*  EDUCATION-RELATED ALLOWANCES */
PY140G_F :2.   /*  FLAG OF PY140G */
PY140G_I :16.   /*  IMPUTATION FACTOR OF PY140G */
PY141G :7.   /*  EDUCATION-RELATED ALLOWANCES (CONTRIBUTORY AND MEANS-TESTED) */
PY141G_F :2.   /*  FLAG OF PY141G */
PY142G :7.   /*  EDUCATION-RELATED ALLOWANCES (CONTRIBUTORY AND NON MEANS-TESTED) */
PY142G_F :2.   /*  FLAG OF PY142G */
PY143G :7.   /*  EDUCATION-RELATED ALLOWANCES (NON-CONTRIBUTORY AND MEANS-TESTED) */
PY143G_F :2.   /*  FLAG OF PY143G */
PY144G :7.   /*  EDUCATION-RELATED ALLOWANCES (NON-CONTRIBUTORY AND NON MEANS-TESTED) */
PY144G_F :2.   /*  FLAG OF PY144G */
PY200G :7.   /*  GROSS MONTHLY EARNINGS FOR EMPLOYEES */
PY200G_F :2.   /*  FLAG OF PY200G */
PY200G_I :16.   /*  IMPUTATION FACTOR OF PY200G */
PD020 :2.   /*  REPLACE WORN-OUT CLOTHES BY SOME NEW (NOT SECOND-HAND) ONES */
PD020_F :2.   /*  FLAG OF PD020 */
PD030 :2.   /*  TWO PAIRS OF PROPERLY FITTING SHOES (INCLUDING A PAIR OF ALL-WEATHER SHOES) */
PD030_F :2.   /*  FLAG OF PD030 */
PD050 :2.   /*  GET-TOGETHER WITH FRIENDS/FAMILY (RELATIVES) FOR A DRINK/MEAL AT LEAST ONCE A MONTH */
PD050_F :2.   /*  FLAG OF PD050 */
PD060 :2.   /*  REGULARLY PARTICIPATE IN A LEISURE ACTIVITY */
PD060_F :2.   /*  FLAG OF PD060 */
PD070 :2.   /*  SPEND A SMALL AMOUNT OF MONEY EACH WEEK ON YOURSELF */
PD070_F :2.   /*  FLAG OF PD070 */
PD080 :2.   /*  INTERNET CONNECTION FOR PERSONAL USE AT HOME */
PD080_F :2.   /*  FLAG OF PD080 */
PW005T :16.   /*  MODULE ON WELL-BEING WEIGHT */
PW005T_F :2.   /*  FLAG OF PW005T */
PW010T :3.   /*  OVERALL LIFE SATISFACTION */
PW010T_F :2.   /*  FLAG OF PW010T */
PW240T :3.   /*  PERCEIVED SOCIAL EXCLUSION */
PW240T_F :2.   /*  FLAG OF PW240T */
PW040T :2.   /*  MATERIAL HELP */
PW040T_F :2.   /*  FLAG OF PW040T */
PW110T :2.   /*  NON-MATERIAL HELP */
PW110T_F :2.   /*  FLAG OF PW110T */
PW030T :3.   /*  SATISFACTION WITH FINANCIAL SITUATION */
PW030T_F :2.   /*  FLAG OF PW030T */
PW160T :3.   /*  SATISFACTION WITH PERSONAL RELATIONSHIPS */
PW160T_F :2.   /*  FLAG OF PW160T */
PW120T :3.   /*  SATISFACTION WITH TIME USE (AMOUNT OF LEISURE TIME) */
PW120T_F :2.   /*  FLAG OF PW120T */
PW100T :3.   /*  SATISFACTION WITH JOB */
PW100T_F :2.   /*  FLAG OF PW100T */
PW190T :3.   /*  TRUST IN OTHERS */
PW190T_F :2.   /*  FLAG OF PW190T */
PW230T :3.   /*  FEELING LONELY */
PW230T_F :2.   /*  FLAG OF PW230T */
PW050T :3.   /*  BEING VERY NERVOUS */
PW050T_F :2.   /*  FLAG OF PW050T */
PW060T :3.   /*  FEELING DOWN IN THE DUMPS */
PW060T_F :2.   /*  FLAG OF PW060T */
PW070T :3.   /*  FEELING CALM AND PEACEFUL */
PW070T_F :2.   /*  FLAG OF PW070T */
PW080T :3.   /*  FEELING DOWNHEARTED OR DEPRESSED */
PW080T_F :2.   /*  FLAG OF PW080T */
PW090T :3.   /*  BEING HAPPY */
PW090T_F :2.   /*  FLAG OF PW090T */
PX010 :2.   /*  CHANGE RATE */
PX020 :3.   /*  AGE AT THE END OF THE INCOME REFERENCE PERIOD */
PX030 :7.   /*  HOUSEHOLD IDENTIFICATION NUMBER */
PX040 :2.   /*  SELECTED RESPONDENT STATUS */
PX050 :2.   /*  ACTIVITY STATUS */
;
LABEL 
PB010 = "YEAR OF THE SURVEY"
PB020 = "COUNTRY"
PB030 = "PERSONAL ID"
PB040 = "PERSONAL CROSS-SECTIONAL WEIGHT"
PB040_F = "FLAG OF PB040"
PB060 = "PERSONAL CROSS-SECTIONAL WEIGHT FOR SELECTED RESPONDENT"
PB060_F = "FLAG OF PB060"
PB100 = "MONTH OF THE PERSONAL INTERVIEW"
PB100_F = "FLAG OF PB100"
PB110 = "YEAR OF THE PERSONAL INTERVIEW"
PB110_F = "FLAG OF PB110"
PB120 = "MINUTES TO COMPLETE THE PERSONAL QUESTIONNAIRE"
PB120_F = "FLAG OF PB120"
PB130 = "MONTH OF BIRTH"
PB130_F = "FLAG OF PB130"
PB140 = "YEAR OF BIRTH"
PB140_F = "FLAG OF PB140"
PB150 = "SEX"
PB150_F = "FLAG OF PB150"
PB160 = "FATHER ID"
PB160_F = "FLAG OF PB160"
PB170 = "MOTHER ID"
PB170_F = "FLAG OF PB170"
PB180 = "SPOUSE/PARTNER ID"
PB180_F = "FLAG OF PB180"
PB190 = "MARITAL STATUS"
PB190_F = "FLAG OF PB190"
PB200 = "CONSENSUAL UNION"
PB200_F = "FLAG OF PB200"
PB210 = "COUNTRY OF BIRTH"
PB210_F = "FLAG OF PB210"
PB220A = "CITIZENSHIP 1"
PB220A_F = "FLAG OF PB220A"
PE010 = "CURRENT EDUCATION ACTIVITY"
PE010_F = "FLAG OF PE010"
PE020 = "ISCED LEVEL CURRENTLY ATTENDED"
PE020_F = "FLAG OF PE020"
PE030 = "YEAR WHEN HIGHEST LEVEL OF EDUCATION WAS ATTAINED"
PE030_F = "FLAG OF PE030"
PE040 = "HIGHEST ISCED LEVEL ATTAINED"
PE040_F = "FLAG OF PE040"
PH010 = "GENERAL HEALTH"
PH010_F = "FLAG OF PH010"
PH020 = "SUFFER FROM ANY CHRONIC (LONG-STANDING) ILLNESS OR CONDITION"
PH020_F = "FLAG OF PH020"
PH030 = "LIMITATION IN ACTIVITIES BECAUSE OF HEALTH PROBLEMS"
PH030_F = "FLAG OF PH030"
PH040 = "UNMET NEED FOR MEDICAL EXAMINATION OR TREATMENT"
PH040_F = "FLAG OF PH040"
PH050 = "MAIN REASON FOR UNMET NEED FOR MEDICAL EXAMINATION OR TREATMENT"
PH050_F = "FLAG OF PH050"
PH060 = "UNMET NEED FOR DENTAL EXAMINATION OR TREATMENT"
PH060_F = "FLAG OF PH060"
PH070 = "MAIN REASON FOR UNMET NEED FOR DENTAL EXAMINATION OR TREATMENT"
PH070_F = "FLAG OF PH070"
PL015 = "WHETHER PERSON HAS EVER WORKED"
PL015_F = "FLAG OF PL015"
PL020 = "ACTIVELY LOOKING FOR A JOB"
PL020_F = "FLAG OF PL020"
PL025 = "AVAILABLE FOR WORK"
PL025_F = "FLAG OF PL025"
PL031 = "SELF-DEFINED CURRENT ECONOMIC STATUS"
PL031_F = "FLAG OF PL031"
PL035 = "WORKED AT LEAST ONE HOUR DURING THE PREVIOUS WEEK"
PL035_F = "FLAG OF PL035"
PL040 = "STATUS IN EMPLOYMENT"
PL040_F = "FLAG OF PL040"
PL051 = "OCCUPATION (ISCO-08 (COM))"
PL051_F = "FLAG OF PL051"
PL060 = "NUMBER OF HOURS USUALLY WORKED PER WEEK IN MAIN JOB"
PL060_F = "FLAG OF PL060"
PL073 = "NUMBER OF MONTHS SPENT AT FULL-TIME WORK AS EMPLOYEE"
PL073_F = "FLAG OF PL073"
PL074 = "NUMBER OF MONTHS SPENT AT PART-TIME WORK AS EMPLOYEE"
PL074_F = "FLAG OF PL074"
PL075 = "NUMBER OF MONTHS SPENT AT FULL-TIME WORK AS SELF-EMPLOYED (INCLUDING FAMILY WORKER)"
PL075_F = "FLAG OF PL075"
PL076 = "NUMBER OF MONTHS SPENT AT PART-TIME WORK AS SELF-EMPLOYED (INCLUDING FAMILY WORKER)"
PL076_F = "FLAG OF PL076"
PL080 = "NUMBER OF MONTHS SPENT IN UNEMPLOYMENT"
PL080_F = "FLAG OF PL080"
PL085 = "NUMBER OF MONTHS SPENT IN RETIREMENT OR EARLY RETIREMENT"
PL085_F = "FLAG OF PL085"
PL086 = "NUMBER OF MONTHS SPENT AS DISABLED OR/AND UNFIT TO WORK"
PL086_F = "FLAG OF PL086"
PL087 = "NUMBER OF MONTHS SPENT STUDYING"
PL087_F = "FLAG OF PL087"
PL088 = "NUMBER OF MONTHS SPENT IN COMPULSORY MILITARY SERVICE"
PL088_F = "FLAG OF PL088"
PL089 = "NUMBER OF MONTHS SPENT FULFILLING DOMESTIC TASKS AND CARE RESPONSIBILITIES"
PL089_F = "FLAG OF PL089"
PL090 = "NUMBER OF MONTHS SPENT IN OTHER INACTIVITY"
PL090_F = "FLAG OF PL090"
PL100 = "TOTAL NUMBER OF HOURS USUALLY WORKED IN SECOND, THIRD, ... JOBS"
PL100_F = "FLAG OF PL100"
PL111 = "NACE REV.2"
PL111_F = "FLAG OF PL111"
PL120 = "REASON FOR WORKING LESS THAN 30 HOURS"
PL120_F = "FLAG OF PL120"
PL130 = "NUMBER OF PERSONS WORKING AT THE LOCAL UNIT"
PL130_F = "FLAG OF PL130"
PL140 = "TYPE OF CONTRACT"
PL140_F = "FLAG OF PL140"
PL150 = "MANAGERIAL POSITION"
PL150_F = "FLAG OF PL150"
PL160 = "CHANGE OF JOB SINCE LAST YEAR"
PL160_F = "FLAG OF PL160"
PL170 = "REASON TO CHANGE"
PL170_F = "FLAG OF PL170"
PL180 = "MOST RECENT CHANGE IN THE INDIVIDUAL�S ACTIVITY STATU
PL180_F = "FLAG OF PL180"
PL190 = "WHEN BEGAN FIRST REGULAR JOB"
PL190_F = "FLAG OF PL190"
PL200 = "NUMBER OF YEARS SPENT IN PAID WORK"
PL200_F = "FLAG OF PL200"
PL211A = "MAIN ACTIVITY IN JANUARY"
PL211A_F = "FLAG OF PL211A"
PL211B = "MAIN ACTIVITY IN FEBRUARY"
PL211B_F = "FLAG OF PL211B"
PL211C = "MAIN ACTIVITY IN MARCH"
PL211C_F = "FLAG OF PL211C"
PL211D = "MAIN ACTIVITY IN APRIL"
PL211D_F = "FLAG OF PL211D"
PL211E = "MAIN ACTIVITY IN MAY"
PL211E_F = "FLAG OF PL211E"
PL211F = "MAIN ACTIVITY IN JUNE"
PL211F_F = "FLAG OF PL211F"
PL211G = "MAIN ACTIVITY IN JULY"
PL211G_F = "FLAG OF PL211G"
PL211H = "MAIN ACTIVITY IN AUGUST"
PL211H_F = "FLAG OF PL211H"
PL211I = "MAIN ACTIVITY IN SEPTEMBER"
PL211I_F = "FLAG OF PL211I"
PL211J = "MAIN ACTIVITY IN OCTOBER"
PL211J_F = "FLAG OF PL211J"
PL211K = "MAIN ACTIVITY IN NOVEMBER"
PL211K_F = "FLAG OF PL211K"
PL211L = "MAIN ACTIVITY IN DECEMBER"
PL211L_F = "FLAG OF PL211L"
PY010N = "EMPLOYEE CASH OR NEAR CASH INCOME"
PY010N_F = "FLAG OF PY010N"
PY010N_I = "IMPUTATION FACTOR OF PY010N"
PY020N = "NON-CASH EMPLOYEE INCOME"
PY020N_F = "FLAG OF PY020N"
PY020N_I = "IMPUTATION FACTOR OF PY020N"
PY021N = "COMPANY CAR"
PY021N_F = "FLAG OF PY021N"
PY021N_I = "IMPUTATION FACTOR OF PY021N"
PY035N = "CONTRIBUTIONS TO INDIVIDUAL PRIVATE PENSION PLANS"
PY035N_F = "FLAG OF PY035N"
PY035N_I = "IMPUTATION FACTOR OF PY035N"
PY050N = "CASH PROFITS OR LOSSES FROM SELF-EMPLOYMENT"
PY050N_F = "FLAG OF PY050N"
PY050N_I = "IMPUTATION FACTOR OF PY050N"
PY080N = "PENSION FROM INDIVIDUAL PRIVATE PLANS"
PY080N_F = "FLAG OF PY080N"
PY080N_I = "IMPUTATION FACTOR OF PY080N"
PY090N = "UNEMPLOYMENT BENEFITS"
PY090N_F = "FLAG OF PY090N"
PY090N_I = "IMPUTATION FACTOR OF PY090N"
PY100N = "OLD-AGE BENEFITS"
PY100N_F = "FLAG OF PY100N"
PY100N_I = "IMPUTATION FACTOR OF PY100N"
PY110N = "SURVIVOR' BENEFITS"
PY110N_F = "FLAG OF PY110N"
PY110N_I = "IMPUTATION FACTOR OF PY110N"
PY120N = "SICKNESS BENEFITS"
PY120N_F = "FLAG OF PY120N"
PY120N_I = "IMPUTATION FACTOR OF PY120N"
PY130N = "DISABILITY BENEFITS"
PY130N_F = "FLAG OF PY130N"
PY130N_I = "IMPUTATION FACTOR OF PY130N"
PY140N = "EDUCATION-RELATED ALLOWANCES"
PY140N_F = "FLAG OF PY140N"
PY140N_I = "IMPUTATION FACTOR OF PY140N"
PY010G = "EMPLOYEE CASH OR NEAR CASH INCOME"
PY010G_F = "FLAG OF PY010G"
PY010G_I = "IMPUTATION FACTOR OF PY010G"
PY020G = "NON-CASH EMPLOYEE INCOME"
PY020G_F = "FLAG OF PY020G"
PY020G_I = "IMPUTATION FACTOR OF PY020G"
PY021G = "COMPANY CAR"
PY021G_F = "FLAG OF PY021G"
PY021G_I = "IMPUTATION FACTOR OF PY021G"
PY030G = "EMPLOYER'S SOCIAL INSURANCE CONTRIBUTION"
PY030G_F = "FLAG OF PY030G"
PY030G_I = "IMPUTATION FACTOR OF PY030G"
PY031G = "OPTIONAL EMPLOYER'S SOCIAL INSURANCE CONTRIBUTIONS"
PY031G_F = "FLAG OF PY031G"
PY031G_I = "IMPUTATION FACTOR OF PY031G"
PY035G = "CONTRIBUTIONS TO INDIVIDUAL PRIVATE PENSION PLANS"
PY035G_F = "FLAG OF PY035G"
PY035G_I = "IMPUTATION FACTOR OF PY035G"
PY050G = "CASH PROFITS OR LOSSES FROM SELF-EMPLOYMENT"
PY050G_F = "FLAG OF PY050G"
PY050G_I = "IMPUTATION FACTOR OF PY050G"
PY080G = "PENSION FROM INDIVIDUAL PRIVATE PLANS"
PY080G_F = "FLAG OF PY080G"
PY080G_I = "IMPUTATION FACTOR OF PY080G"
PY090G = "UNEMPLOYMENT BENEFITS"
PY090G_F = "FLAG OF PY090G"
PY090G_I = "IMPUTATION FACTOR OF PY090G"
PY091G = "UNEMPLOYMENT BENEFITS (CONTRIBUTORY AND MEANS-TESTED)"
PY091G_F = "FLAG OF PY091G"
PY092G = "UNEMPLOYMENT BENEFITS (CONTRIBUTORY AND NON MEANS-TESTED)"
PY092G_F = "FLAG OF PY092G"
PY093G = "UNEMPLOYMENT BENEFITS (NON-CONTRIBUTORY AND MEANS-TESTED)"
PY093G_F = "FLAG OF PY093G"
PY094G = "UNEMPLOYMENT BENEFITS (NON-CONTRIBUTORY AND NON MEANS-TESTED)"
PY094G_F = "FLAG OF PY094G"
PY100G = "OLD-AGE BENEFITS"
PY100G_F = "FLAG OF PY100G"
PY100G_I = "IMPUTATION FACTOR OF PY100G"
PY101G = "OLD-AGE BENEFITS (CONTRIBUTORY AND MEANS-TESTED)"
PY101G_F = "FLAG OF PY101G"
PY102G = "OLD-AGE BENEFITS (CONTRIBUTORY AND NON MEANS-TESTED)"
PY102G_F = "FLAG OF PY102G"
PY103G = "OLD-AGE BENEFITS (NON-CONTRIBUTORY AND MEANS-TESTED)"
PY103G_F = "FLAG OF PY103G"
PY104G = "OLD-AGE BENEFITS (NON-CONTRIBUTORY AND NON MEANS-TESTED)"
PY104G_F = "FLAG OF PY104G"
PY110G = "SURVIVOR' BENEFITS"
PY110G_F = "FLAG OF PY110G"
PY110G_I = "IMPUTATION FACTOR OF PY110G"
PY111G = "SURVIVOR� BENEFITS (CONTRIBUTORY AND MEANS-TESTED
PY111G_F = "FLAG OF PY111G"
PY112G = "SURVIVOR� BENEFITS (CONTRIBUTORY AND NON MEANS-TESTED
PY112G_F = "FLAG OF PY112G"
PY113G = "SURVIVOR� BENEFITS (NON-CONTRIBUTORY AND MEANS-TESTED
PY113G_F = "FLAG OF PY113G"
PY114G = "SURVIVOR� BENEFITS (NON-CONTRIBUTORY AND NON MEANS-TESTED
PY114G_F = "FLAG OF PY114G"
PY120G = "SICKNESS BENEFITS"
PY120G_F = "FLAG OF PY120G"
PY120G_I = "IMPUTATION FACTOR OF PY120G"
PY121G = "SICKNESS BENEFITS (CONTRIBUTORY AND MEANS-TESTED)"
PY121G_F = "FLAG OF PY121G"
PY122G = "SICKNESS BENEFITS (CONTRIBUTORY AND NON MEANS-TESTED)"
PY122G_F = "FLAG OF PY122G"
PY123G = "SICKNESS BENEFITS (NON-CONTRIBUTORY AND MEANS-TESTED)"
PY123G_F = "FLAG OF PY123G"
PY124G = "SICKNESS BENEFITS (NON-CONTRIBUTORY AND NON MEANS-TESTED)"
PY124G_F = "FLAG OF PY124G"
PY130G = "DISABILITY BENEFITS"
PY130G_F = "FLAG OF PY130G"
PY130G_I = "IMPUTATION FACTOR OF PY130G"
PY131G = "DISABILITY BENEFITS (CONTRIBUTORY AND MEANS-TESTED)"
PY131G_F = "FLAG OF PY131G"
PY132G = "DISABILITY BENEFITS (CONTRIBUTORY AND NON MEANS-TESTED)"
PY132G_F = "FLAG OF PY132G"
PY133G = "DISABILITY BENEFITS (NON-CONTRIBUTORY AND MEANS-TESTED)"
PY133G_F = "FLAG OF PY133G"
PY134G = "DISABILITY BENEFITS (NON-CONTRIBUTORY AND NON MEANS-TESTED)"
PY134G_F = "FLAG OF PY134G"
PY140G = "EDUCATION-RELATED ALLOWANCES"
PY140G_F = "FLAG OF PY140G"
PY140G_I = "IMPUTATION FACTOR OF PY140G"
PY141G = "EDUCATION-RELATED ALLOWANCES (CONTRIBUTORY AND MEANS-TESTED)"
PY141G_F = "FLAG OF PY141G"
PY142G = "EDUCATION-RELATED ALLOWANCES (CONTRIBUTORY AND NON MEANS-TESTED)"
PY142G_F = "FLAG OF PY142G"
PY143G = "EDUCATION-RELATED ALLOWANCES (NON-CONTRIBUTORY AND MEANS-TESTED)"
PY143G_F = "FLAG OF PY143G"
PY144G = "EDUCATION-RELATED ALLOWANCES (NON-CONTRIBUTORY AND NON MEANS-TESTED)"
PY144G_F = "FLAG OF PY144G"
PY200G = "GROSS MONTHLY EARNINGS FOR EMPLOYEES"
PY200G_F = "FLAG OF PY200G"
PY200G_I = "IMPUTATION FACTOR OF PY200G"
PD020 = "REPLACE WORN-OUT CLOTHES BY SOME NEW (NOT SECOND-HAND) ONES"
PD020_F = "FLAG OF PD020"
PD030 = "TWO PAIRS OF PROPERLY FITTING SHOES (INCLUDING A PAIR OF ALL-WEATHER SHOES)"
PD030_F = "FLAG OF PD030"
PD050 = "GET-TOGETHER WITH FRIENDS/FAMILY (RELATIVES) FOR A DRINK/MEAL AT LEAST ONCE A MONTH"
PD050_F = "FLAG OF PD050"
PD060 = "REGULARLY PARTICIPATE IN A LEISURE ACTIVITY"
PD060_F = "FLAG OF PD060"
PD070 = "SPEND A SMALL AMOUNT OF MONEY EACH WEEK ON YOURSELF"
PD070_F = "FLAG OF PD070"
PD080 = "INTERNET CONNECTION FOR PERSONAL USE AT HOME"
PD080_F = "FLAG OF PD080"
PW005T = "MODULE ON WELL-BEING WEIGHT"
PW005T_F = "FLAG OF PW005T"
PW010T = "OVERALL LIFE SATISFACTION"
PW010T_F = "FLAG OF PW010T"
PW240T = "PERCEIVED SOCIAL EXCLUSION"
PW240T_F = "FLAG OF PW240T"
PW040T = "MATERIAL HELP"
PW040T_F = "FLAG OF PW040T"
PW110T = "NON-MATERIAL HELP"
PW110T_F = "FLAG OF PW110T"
PW030T = "SATISFACTION WITH FINANCIAL SITUATION"
PW030T_F = "FLAG OF PW030T"
PW160T = "SATISFACTION WITH PERSONAL RELATIONSHIPS"
PW160T_F = "FLAG OF PW160T"
PW120T = "SATISFACTION WITH TIME USE (AMOUNT OF LEISURE TIME)"
PW120T_F = "FLAG OF PW120T"
PW100T = "SATISFACTION WITH JOB"
PW100T_F = "FLAG OF PW100T"
PW190T = "TRUST IN OTHERS"
PW190T_F = "FLAG OF PW190T"
PW230T = "FEELING LONELY"
PW230T_F = "FLAG OF PW230T"
PW050T = "BEING VERY NERVOUS"
PW050T_F = "FLAG OF PW050T"
PW060T = "FEELING DOWN IN THE DUMPS"
PW060T_F = "FLAG OF PW060T"
PW070T = "FEELING CALM AND PEACEFUL"
PW070T_F = "FLAG OF PW070T"
PW080T = "FEELING DOWNHEARTED OR DEPRESSED"
PW080T_F = "FLAG OF PW080T"
PW090T = "BEING HAPPY"
PW090T_F = "FLAG OF PW090T"
PX010 = "CHANGE RATE"
PX020 = "AGE AT THE END OF THE INCOME REFERENCE PERIOD"
PX030 = "HOUSEHOLD IDENTIFICATION NUMBER"
PX040 = "SELECTED RESPONDENT STATUS"
PX050 = "ACTIVITY STATUS"
;
RUN;
PROC FORMAT;
VALUE $PB01F /* PB020 */
"AT" = "¿sterreich
"BE" = "Belgique/Belg¿e
"BG" = "Bulgaria"
"CH" = "Switzerland"
"CY" = "Cyprus"
"CZ" = "Czech republic"
"DE" = "Deutschland"
"DK" = "Denmark"
"EE" = "Estonia"
"EL" = "Ell¿da
"ES" = "Espa¿a
"FI" = "Suomi"
"FR" = "France"
"HR" = "Croatia"
"HU" = "Hungary"
"IE" = "Ireland"
"IS" = "Iceland"
"IT" = "Italia"
"LT" = "Lithuania"
"LU" = "Luxembourg"
"LV" = "Latvia"
"ME" = "Montenegro"
"MK" = "The Former Yugoslav Republic of Macedonia (FYROM)"
"MT" = "Malta"
"NL" = "Nederland"
"NO" = "Norway"
"PL" = "Poland"
"PT" = "Portugal"
"RO" = "Romania"
"RS" = "Serbia"
"SE" = "Sverige"
"SI" = "Slovenia"
"SK" = "Slovak republic"
"TR" = "Turkey"
"UK" = "United Kingdom"
;
VALUE PB04F /* PB040_F */
1= "Filled"
-7= "Not applicable: PB010 ne last year"
;
VALUE PB06F /* PB060_F */
1= "Filled"
-2= "Not applicable (country does not use the selected respondent model)"
-3= "Non-selected respondent"
-7= "Not applicable: PB010 ne last year"
;
VALUE PB17F /* PB100 */
1= "January-March"
2= "April-June"
3= "July-September"
4= "October-December"
;
VALUE PB18F /* PB100_F */
1= "Filled"
-1= "Missing"
;
VALUE PB110F /* PB110_F */
1= "Filled"
-1= "Missing"
;
VALUE PB112F /* PB120_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable (information only extracted from registers)"
;
VALUE PB113F /* PB130 */
1= "January-March"
2= "April-June"
3= "July-September"
4= "October-December"
;
VALUE PB114F /* PB130_F */
1= "Filled"
-1= "Missing"
;
VALUE PB116F /* PB140_F */
1= "Filled"
-1= "Missing"
;
VALUE PB117F /* PB150 */
1= "Male"
2= "Female"
;
VALUE PB118F /* PB150_F */
1= "Filled"
-1= "Missing"
;
VALUE PB120F /* PB160_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable (father is not a household member)"
;
VALUE PB122F /* PB170_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable (mother is not a household member)"
;
VALUE PB124F /* PB180_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable (person has no spouse/partner or spouse/partner is not a household member)"
;
VALUE PB125F /* PB190 */
1= "Never married"
2= "Married"
3= "Separated"
4= "Widowed"
5= "Divorced"
;
VALUE PB126F /* PB190_F */
1= "Filled"
-1= "Missing"
;
VALUE PB227F /* PB200 */
1= "Yes, on a legal basis"
2= "Yes, without a legal basis"
3= "No"
;
VALUE PB228F /* PB200_F */
1= "Filled"
-1= "Missing"
;
VALUE $PB229F /* PB210 */
"EU" = "European Countries"
"LOC" = "Italy"
"OTH" = "Other"
;
VALUE PB230F /* PB210_F */
1= "Filled"
-1= "Missing"
;
VALUE $PB231F /* PB220A */
"EU" = "European Countries"
"LOC" = "Italy"
"OTH" = "Other"
;
VALUE PB232F /* PB220A_F */
1= "Filled"
-1= "Missing"
;
VALUE PE033F /* PE010 */
1= "In education"
2= "Not in education"
;
VALUE PE034F /* PE010_F */
1= "Filled"
-1= "Missing"
;
VALUE PE035F /* PE020 */
00= "Early childhood education"
10= "Primary education"
20= "Lower secondary education"
30= "Upper secondary education (not further specified)"
40= "Post-secondary non tertiary education (not further specified)"
50= "Tertiary education"
;
VALUE PE036F /* PE020_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable (PE010 not equal to 1)"
;
VALUE PE038F /* PE030_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable (PE040 eq 000)"
;
VALUE PE039F /* PE040 */
000= "Less than primary education"
100= "Primary education"
200= "Lower secondary education"
300= "Upper secondary education (not further specified)"
400= "Post-secondary non-tertiary education (not further specified)"
500= "Tertiary education"
;
VALUE PE040F /* PE040_F */
1= "Filled"
-1= "Missing"
;
VALUE PH041F /* PH010 */
1= "Very good"
2= "Good"
3= "Fair"
4= "Bad"
5= "Very bad"
;
VALUE PH042F /* PH010_F */
1= "Filled"
-1= "Missing"
-3= "Non-selected respondent"
;
VALUE PH043F /* PH020 */
1= "Yes"
2= "No"
;
VALUE PH044F /* PH020_F */
1= "Filled"
-1= "Missing"
-3= "Non-selected respondent"
;
VALUE PH045F /* PH030 */
1= "Yes, strongly limited"
2= "Yes, limited"
3= "No, not limited"
;
VALUE PH046F /* PH030_F */
1= "Filled"
-1= "Missing"
-3= "Non-selected respondent"
;
VALUE PH047F /* PH040 */
1= "Yes, there was at least one occasion when the person really needed examination or treatment but did not receive it"
2= "No, there was no occasion when the person really needed examination or treatment but did not receive it"
;
VALUE PH048F /* PH040_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable: the person did not really need any medical examination or treatment"
-3= "Non-selected respondent"
;
VALUE PH049F /* PH050 */
1= "Could not afford to (too expensive)"
2= "Waiting list"
3= "Could not take time because of work, care for children or for others"
4= "Too far to travel/no means of transportation"
5= "Fear of doctor/hospitals/examination/ treatment"
6= "Wanted to wait and see if problem got better on its own"
7= "Didn¿t know any good doctor or specialist
8= "Other reasons"
;
VALUE PH050F /* PH050_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable (PH040 not equal to 1)"
-3= "Non-selected respondent"
;
VALUE PH051F /* PH060 */
1= "Yes, there was at least one occasion when the person really needed dental examination or treatment but did not receive it"
2= "No, there was no occasion when the person really needed dental examination or treatment but did not receive it"
;
VALUE PH052F /* PH060_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable: the person did not really need any dental examination or treatment"
-3= "Non-selected respondent"
;
VALUE PH053F /* PH070 */
1= "Could not afford to (too expensive)"
2= "Waiting list"
3= "Could not take time because of work, care for children or for others"
4= "Too far to travel/no means of transportation"
5= "Fear of doctor(dentist)/hospitals/examination/ treatment"
6= "Wanted to wait and see if problem got better on its own"
7= "Didn¿t know any good dentist
8= "Other reasons"
;
VALUE PH054F /* PH070_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable (PH060 not equal to 1)"
-3= "Non-selected respondent"
;
VALUE PL055F /* PL015 */
1= "Yes"
2= "No"
;
VALUE PL056F /* PL015_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable (PL031 eq 1, 2, 3 or 4)"
;
VALUE PL057F /* PL020 */
1= "Yes"
2= "No"
;
VALUE PL058F /* PL020_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable (PL031 eq 1, 2, 3 or 4 or older than the standard retirement age)"
;
VALUE PL059F /* PL025 */
1= "Yes"
2= "No"
;
VALUE PL060F /* PL025_F */
1= "filled"
-1= "Missing"
-2= "Not applicable (PL020 not equal to 1)"
;
VALUE PL061F /* PL031 */
1= "Employee working full-time"
2= "Employee working part-time"
3= "Self-employed working full-time (including family worker)"
4= "Self-employed working part-time (including family worker)"
5= "Unemployed"
6= "Pupil, student, further training, unpaid work experience"
7= "In retirement or in early retirement or has given up business"
8= "Permanently disabled or/and unfit to work"
9= "In compulsory military or community service"
10= "Fulfilling domestic tasks and care responsibilities"
11= "Other inactive person"
;
VALUE PL062F /* PL031_F */
1= "Filled"
-1= "Missing"
;
VALUE PL063F /* PL035 */
1= "Yes"
2= "No"
;
VALUE PL064F /* PL035_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable (person is not employee or MS has other source to calculate the gender pay gap)"
-3= "Non-selected respondent"
;
VALUE PL065F /* PL040 */
1= "Self-employed with employees"
2= "Self-employed without employees"
3= "Employee"
4= "Family worker"
;
VALUE PL066F /* PL040_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable (PL015 not equal to 1 and PL031 not equal to 1,2,3 or 4)"
;
VALUE PL067F /* PL051 */
1= "Commissioned Armed Forces Officers"
2= "Non-commissioned Armed Forces Officers"
3= "Armed Forces Occupations, Other Ranks"
11= "Chief Executives, Senior Officials and Legislators"
12= "Administrative and Commercial Managers"
13= "Production and Specialized Services Managers"
14= "Hospitality, Retail and Other Services Managers"
21= "Science and Engineering Professionals"
22= "Health Professionals"
23= "Teaching Professionals"
24= "Business and Administration Professionals"
25= "Information and Communications Technology Professionals"
26= "Legal, Social and Cultural Professionals"
31= "Science and Engineering Associate Professionals"
32= "Health Associate Professionals"
33= "Business and Administration Associate Professionals"
34= "Legal, Social, Cultural and Related Associate Professionals"
35= "Information and Communications Technicians"
41= "General and Keyboard Clerks"
42= "Customer Services Clerks"
43= "Numerical and Material Recording Clerks"
44= "Other Clerical Support Workers"
51= "Personal Services Workers"
52= "Sales Workers"
53= "Personal Care Workers"
54= "Protective Services Workers"
61= "Market-oriented Skilled Agricultural Workers"
62= "Market-oriented Skilled Forestry, Fishery and Hunting Workers"
63= "Subsistence Farmers, Fishers, Hunters and Gatherers"
71= "Building and Related Trades Workers (excluding Electricians)"
72= "Metal, Machinery and Related Trades Workers"
73= "Handicraft and Printing Workers"
74= "Electrical and Electronic Trades Workers"
75= "Food Processing, Woodworking, Garment and Other Craft and Related Trades Workers"
81= "Stationary Plant and Machine Operators"
82= "Assemblers"
83= "Drivers and Mobile Plant Operators"
91= "Cleaners and Helpers"
92= "Agricultural, Forestry and Fishery Labourers"
93= "Labourers in Mining, Construction, Manufacturing and Transport"
94= "Food Preparation Assistants"
95= "Street and Related Sales and Services Workers"
96= "Refuse Workers and Other Elementary Workers"
;
VALUE PL068F /* PL051_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable (PL031 not eq 1, 2, 3 or 4 and PL015 not eq 1)"
;
VALUE PL070F /* PL060_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable (PL031 not eq 1, 2, 3 or 4)"
-6= "Hours varying (when an average for over four weeks is not possible)"
;
VALUE PL072F /* PL073_F */
1= "Filled"
-1= "Missing"
-5= "Missing value because the definition of this variable is not used (PL088 and PL089 only)"
;
VALUE PL074F /* PL074_F */
1= "Filled"
-1= "Missing"
-5= "Missing value because the definition of this variable is not used (PL088 and PL089 only)"
;
VALUE PL076F /* PL075_F */
1= "Filled"
-1= "Missing"
-5= "Missing value because the definition of this variable is not used (PL088 and PL089 only)"
;
VALUE PL078F /* PL076_F */
1= "Filled"
-1= "Missing"
-5= "Missing value because the definition of this variable is not used (PL088 and PL089 only)"
;
VALUE PL080F /* PL080_F */
1= "Filled"
-1= "Missing"
-5= "Missing value because the definition of this variable is not used (PL088 and PL089 only)"
;
VALUE PL082F /* PL085_F */
1= "Filled"
-1= "Missing"
-5= "Missing value because the definition of this variable is not used (PL088 and PL089 only)"
;
VALUE PL084F /* PL086_F */
1= "Filled"
-1= "Missing"
-5= "Missing value because the definition of this variable is not used (PL088 and PL089 only)"
;
VALUE PL086F /* PL087_F */
1= "Filled"
-1= "Missing"
-5= "Missing value because the definition of this variable is not used (PL088 and PL089 only)"
;
VALUE PL088F /* PL088_F */
1= "Filled"
-1= "Missing"
-5= "Missing value because the definition of this variable is not used (PL088 and PL089 only)"
;
VALUE PL090F /* PL089_F */
1= "Filled"
-1= "Missing"
-5= "Missing value because the definition of this variable is not used (PL088 and PL089 only)"
;
VALUE PL092F /* PL090_F */
1= "Filled"
-1= "Missing"
-5= "Missing value because the definition of this variable is not used (PL088 and PL089 only)"
;
VALUE PL194F /* PL100_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable (person does not have a second job or PL031 not equal to 1, 2, 3 or 4)"
;
VALUE $PL195F /* PL111 */
"a" = "Agriculture, forestry and fishing"
"f" = "Construction"
"g" = "Wholesale retail"
"h" = "Transportation and storage"
"i" = "Accommodation and food service activities"
"j" = "Information and communication"
"k" = "Financial and insurance activities"
"o" = "Public administration and defence, compulsory social security"
"p" = "Education"
"q" = "Human health and social work activities"
"b - e" = "Mining and quarrying, Manufacturing, Electricity, gas, steam and air conditioning supply, Water supply"
"l - n" = "Real estate activities, Professional, scientific and technical activities, Administrative and support service activities"
"r - u" = "Arts, entertainment and recreation, Other service activities, Activities as household as employer..., Activities of extraterritorial organisations and bodies"
;
VALUE PL196F /* PL111_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable (PL031 not equal to 1, 2, 3 or 4)"
-3= "Non-selected respondent"
;
VALUE PL197F /* PL120 */
1= "Undergoing education or training"
2= "Personal illness or disability"
3= "Wants to work more hours but cannot find a job(s) or work(s) of more hours"
4= "Do not want to work more hours"
5= "Number of hours in all job(s) are considered as a full-time job"
6= "Housework, looking after children or other persons"
7= "Other reasons"
;
VALUE PL198F /* PL120_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable (Not (PL031 eq 1, 2 , 3 or 4, and PL060 + PL100 < 30))"
-3= "Non-selected respondent"
;
VALUE PL199F /* PL130 */
1= "1 person"
2= "2 persons"
3= "3 persons"
4= "4 persons"
5= "5 persons"
6= "6 persons"
7= "7 persons"
8= "8 persons"
9= "9 persons"
10= "10 persons"
11= "Between 11 and 19 persons"
12= "Between 20 and 49 persons"
13= "50 persons and more"
14= "Do not know but less than 11 persons"
15= "Do not know but more than 10 persons"
;
VALUE PL1100F /* PL130_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable (PL031 not equal to 1, 2, 3 or 4)"
-3= "Non-selected respondent"
;
VALUE PL1101F /* PL140 */
1= "Permanent job/work contract of unlimited duration"
2= "Temporary job/work contract of limited duration"
;
VALUE PL1102F /* PL140_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable (PL040 not equal to 3)"
-3= "Non-selected respondent"
-4= "Not applicable because the person is employee (PL040 eq 3) but does not have a contract"
;
VALUE PL1103F /* PL150 */
1= "Supervisory"
2= "Non-supervisory"
;
VALUE PL1104F /* PL150_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable (PL040 not equal to 3)"
-3= "Non-selected respondent"
;
VALUE PL1105F /* PL160 */
1= "Yes"
2= "No"
;
VALUE PL1106F /* PL160_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable (PL031 not equal to 1, 2, 3 or 4)"
-3= "Non-selected respondent"
;
VALUE PL1107F /* PL170 */
1= "To take up or seek better job"
2= "End of temporary contract"
3= "Obliged to stop by employer (business closure, redundancy, early retirement, dismissal etc.)"
4= "Sale or closure of own/family business"
5= "Childcare and care for other dependents"
6= "Partner¿s job required us to move to another area or marriage
7= "Other reasons"
;
VALUE PL1108F /* PL170_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable (PL160 not equal to 1)"
-3= "Non-selected respondent"
;
VALUE PL1109F /* PL180 */
1= "Employed - unemployed"
2= "Employed - retired"
3= "Employed - other inactive"
4= "Unemployed - employed"
5= "Unemployed - retired"
6= "Unemployed - other inactive"
7= "Retired - employed"
8= "Retired - unemployed"
9= "Retired - other inactive"
10= "Other inactive - employed"
11= "Other inactive - unemployed"
12= "Other inactive - retired"
;
VALUE PL1110F /* PL180_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable (no change since last year)"
-3= "Non-selected respondent"
;
VALUE PL1112F /* PL190_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable (person never worked i.e. (PL031 not equal to 1, 2, 3 or 4 AND PL015 not equal to 1))"
-3= "Non-selected respondent"
;
VALUE PL2114F /* PL200_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable (person never worked i.e. (PL031 not equal to 1, 2, 3 or 4 AND PL015 not equal to 1))"
-3= "Non-selected respondent"
;
VALUE PL2115F /* PL211A */
1= "Employee working full-time"
2= "Employee working part-time"
3= "Self-employed working full-time (including family worker)"
4= "Self-employed working part-time (including family worker)"
5= "Unemployed"
6= "Pupil, student, further training, unpaid work experience"
7= "In retirement or in early retirement or has given up business"
8= "Permanently disabled or/and unfit to work"
9= "In compulsory military or community service"
10= "Fulfilling domestic tasks and care responsibilities"
11= "Other inactive person"
;
VALUE PL2116F /* PL211A_F */
1= "Filled"
-1= "Missing"
-3= "Non-selected respondent"
;
VALUE PL2117F /* PL211B */
1= "Employee working full-time"
2= "Employee working part-time"
3= "Self-employed working full-time (including family worker)"
4= "Self-employed working part-time (including family worker)"
5= "Unemployed"
6= "Pupil, student, further training, unpaid work experience"
7= "In retirement or in early retirement or has given up business"
8= "Permanently disabled or/and unfit to work"
9= "In compulsory military or community service"
10= "Fulfilling domestic tasks and care responsibilities"
11= "Other inactive person"
;
VALUE PL2118F /* PL211B_F */
1= "Filled"
-1= "Missing"
-3= "Non-selected respondent"
;
VALUE PL2119F /* PL211C */
1= "Employee working full-time"
2= "Employee working part-time"
3= "Self-employed working full-time (including family worker)"
4= "Self-employed working part-time (including family worker)"
5= "Unemployed"
6= "Pupil, student, further training, unpaid work experience"
7= "In retirement or in early retirement or has given up business"
8= "Permanently disabled or/and unfit to work"
9= "In compulsory military or community service"
10= "Fulfilling domestic tasks and care responsibilities"
11= "Other inactive person"
;
VALUE PL2120F /* PL211C_F */
1= "Filled"
-1= "Missing"
-3= "Non-selected respondent"
;
VALUE PL2121F /* PL211D */
1= "Employee working full-time"
2= "Employee working part-time"
3= "Self-employed working full-time (including family worker)"
4= "Self-employed working part-time (including family worker)"
5= "Unemployed"
6= "Pupil, student, further training, unpaid work experience"
7= "In retirement or in early retirement or has given up business"
8= "Permanently disabled or/and unfit to work"
9= "In compulsory military or community service"
10= "Fulfilling domestic tasks and care responsibilities"
11= "Other inactive person"
;
VALUE PL2122F /* PL211D_F */
1= "Filled"
-1= "Missing"
-3= "Non-selected respondent"
;
VALUE PL2123F /* PL211E */
1= "Employee working full-time"
2= "Employee working part-time"
3= "Self-employed working full-time (including family worker)"
4= "Self-employed working part-time (including family worker)"
5= "Unemployed"
6= "Pupil, student, further training, unpaid work experience"
7= "In retirement or in early retirement or has given up business"
8= "Permanently disabled or/and unfit to work"
9= "In compulsory military or community service"
10= "Fulfilling domestic tasks and care responsibilities"
11= "Other inactive person"
;
VALUE PL2124F /* PL211E_F */
1= "Filled"
-1= "Missing"
-3= "Non-selected respondent"
;
VALUE PL2125F /* PL211F */
1= "Employee working full-time"
2= "Employee working part-time"
3= "Self-employed working full-time (including family worker)"
4= "Self-employed working part-time (including family worker)"
5= "Unemployed"
6= "Pupil, student, further training, unpaid work experience"
7= "In retirement or in early retirement or has given up business"
8= "Permanently disabled or/and unfit to work"
9= "In compulsory military or community service"
10= "Fulfilling domestic tasks and care responsibilities"
11= "Other inactive person"
;
VALUE PL2126F /* PL211F_F */
1= "Filled"
-1= "Missing"
-3= "Non-selected respondent"
;
VALUE PL2127F /* PL211G */
1= "Employee working full-time"
2= "Employee working part-time"
3= "Self-employed working full-time (including family worker)"
4= "Self-employed working part-time (including family worker)"
5= "Unemployed"
6= "Pupil, student, further training, unpaid work experience"
7= "In retirement or in early retirement or has given up business"
8= "Permanently disabled or/and unfit to work"
9= "In compulsory military or community service"
10= "Fulfilling domestic tasks and care responsibilities"
11= "Other inactive person"
;
VALUE PL2128F /* PL211G_F */
1= "Filled"
-1= "Missing"
-3= "Non-selected respondent"
;
VALUE PL2129F /* PL211H */
1= "Employee working full-time"
2= "Employee working part-time"
3= "Self-employed working full-time (including family worker)"
4= "Self-employed working part-time (including family worker)"
5= "Unemployed"
6= "Pupil, student, further training, unpaid work experience"
7= "In retirement or in early retirement or has given up business"
8= "Permanently disabled or/and unfit to work"
9= "In compulsory military or community service"
10= "Fulfilling domestic tasks and care responsibilities"
11= "Other inactive person"
;
VALUE PL2130F /* PL211H_F */
1= "Filled"
-1= "Missing"
-3= "Non-selected respondent"
;
VALUE PL2131F /* PL211I */
1= "Employee working full-time"
2= "Employee working part-time"
3= "Self-employed working full-time (including family worker)"
4= "Self-employed working part-time (including family worker)"
5= "Unemployed"
6= "Pupil, student, further training, unpaid work experience"
7= "In retirement or in early retirement or has given up business"
8= "Permanently disabled or/and unfit to work"
9= "In compulsory military or community service"
10= "Fulfilling domestic tasks and care responsibilities"
11= "Other inactive person"
;
VALUE PL2132F /* PL211I_F */
1= "Filled"
-1= "Missing"
-3= "Non-selected respondent"
;
VALUE PL2133F /* PL211J */
1= "Employee working full-time"
2= "Employee working part-time"
3= "Self-employed working full-time (including family worker)"
4= "Self-employed working part-time (including family worker)"
5= "Unemployed"
6= "Pupil, student, further training, unpaid work experience"
7= "In retirement or in early retirement or has given up business"
8= "Permanently disabled or/and unfit to work"
9= "In compulsory military or community service"
10= "Fulfilling domestic tasks and care responsibilities"
11= "Other inactive person"
;
VALUE PL2134F /* PL211J_F */
1= "Filled"
-1= "Missing"
-3= "Non-selected respondent"
;
VALUE PL2135F /* PL211K */
1= "Employee working full-time"
2= "Employee working part-time"
3= "Self-employed working full-time (including family worker)"
4= "Self-employed working part-time (including family worker)"
5= "Unemployed"
6= "Pupil, student, further training, unpaid work experience"
7= "In retirement or in early retirement or has given up business"
8= "Permanently disabled or/and unfit to work"
9= "In compulsory military or community service"
10= "Fulfilling domestic tasks and care responsibilities"
11= "Other inactive person"
;
VALUE PL2136F /* PL211K_F */
1= "Filled"
-1= "Missing"
-3= "Non-selected respondent"
;
VALUE PL2137F /* PL211L */
1= "Employee working full-time"
2= "Employee working part-time"
3= "Self-employed working full-time (including family worker)"
4= "Self-employed working part-time (including family worker)"
5= "Unemployed"
6= "Pupil, student, further training, unpaid work experience"
7= "In retirement or in early retirement or has given up business"
8= "Permanently disabled or/and unfit to work"
9= "In compulsory military or community service"
10= "Fulfilling domestic tasks and care responsibilities"
11= "Other inactive person"
;
VALUE PL2138F /* PL211L_F */
1= "Filled"
-1= "Missing"
-3= "Non-selected respondent"
;
VALUE PY0185F /* PY030G_F */
0= "No income"
1= "Income (variable is filled)"
-1= "Missing"
;
VALUE PY0188F /* PY031G_F */
0= "No income"
1= "Income (variable is filled)"
-1= "Missing"
;
VALUE PY0203F /* PY091G_F */
0= "No income"
1= "Filled with only Contributory and means-tested components"
2= "Filled with mixed components"
-1= "Missing"
-2= "Not applicable (This scheme doesn't exist at national level)"
-7= "Not applicable (PB010 ne last year)"
;
VALUE PY0205F /* PY092G_F */
0= "No income"
1= "Filled with only Contributory and non means-tested components"
2= "Filled with mixed components"
-1= "Missing"
-2= "Not applicable (This scheme doesn't exist at national level)"
-7= "Not applicable (PB010 ne last year)"
;
VALUE PY0207F /* PY093G_F */
0= "No income"
1= "Filled with only Non-contributory and means-tested components"
2= "Filled with mixed components"
-1= "Missing"
-2= "Not applicable (This scheme doesn't exist at national level)"
-7= "Not applicable (PB010 ne last year)"
;
VALUE PY0209F /* PY094G_F */
0= "No income"
1= "Filled with only Non-contributory and non means-tested components"
2= "Filled with mixed components"
-1= "Missing"
-2= "Not applicable (This scheme doesn't exist at national level)"
-7= "Not applicable (PB010 ne last year)"
;
VALUE PY1214F /* PY101G_F */
0= "No income"
1= "Filled with only Contributory and means-tested components"
2= "Filled with mixed components"
-1= "Missing"
-2= "Not applicable (This scheme doesn't exist at national level)"
-7= "Not applicable (PB010 ne last year)"
;
VALUE PY1216F /* PY102G_F */
0= "No income"
1= "Filled with only Contributory and non means-tested components"
2= "Filled with mixed components"
-1= "Missing"
-2= "Not applicable (This scheme doesn't exist at national level)"
-7= "Not applicable (PB010 ne last year)"
;
VALUE PY1218F /* PY103G_F */
0= "No income"
1= "Filled with only Non-contributory and means-tested components"
2= "Filled with mixed components"
-1= "Missing"
-2= "Not applicable (This scheme doesn't exist at national level)"
-7= "Not applicable (PB010 ne last year)"
;
VALUE PY1220F /* PY104G_F */
0= "No income"
1= "Filled with only Non-contributory and non means-tested components"
2= "Filled with mixed components"
-1= "Missing"
-2= "Not applicable (This scheme doesn't exist at national level)"
-7= "Not applicable (PB010 ne last year)"
;
VALUE PY1225F /* PY111G_F */
0= "No income"
1= "Filled with only Contributory and means-tested components"
2= "Filled with mixed components"
-1= "Missing"
-2= "Not applicable (This scheme doesn't exist at national level)"
-7= "Not applicable (PB010 ne last year)"
;
VALUE PY1227F /* PY112G_F */
0= "No income"
1= "Filled with only Contributory and non means-tested components"
2= "Filled with mixed components"
-1= "Missing"
-2= "Not applicable (This scheme doesn't exist at national level)"
-7= "Not applicable (PB010 ne last year)"
;
VALUE PY1229F /* PY113G_F */
0= "No income"
1= "Filled with only Non-contributory and means-tested components"
2= "Filled with mixed components"
-1= "Missing"
-2= "Not applicable (This scheme doesn't exist at national level)"
-7= "Not applicable (PB010 ne last year)"
;
VALUE PY1231F /* PY114G_F */
0= "No income"
1= "Filled with only Non-contributory and non means-tested components"
2= "Filled with mixed components"
-1= "Missing"
-2= "Not applicable (This scheme doesn't exist at national level)"
-7= "Not applicable (PB010 ne last year)"
;
VALUE PY1236F /* PY121G_F */
0= "No income"
1= "Filled with only Contributory and means-tested components"
2= "Filled with mixed components"
-1= "Missing"
-2= "Not applicable (This scheme doesn't exist at national level)"
-7= "Not applicable (PB010 ne last year)"
;
VALUE PY1238F /* PY122G_F */
0= "No income"
1= "Filled with only Contributory and non means-tested components"
2= "Filled with mixed components"
-1= "Missing"
-2= "Not applicable (This scheme doesn't exist at national level)"
-7= "Not applicable (PB010 ne last year)"
;
VALUE PY1240F /* PY123G_F */
0= "No income"
1= "Filled with only Non-contributory and means-tested components"
2= "Filled with mixed components"
-1= "Missing"
-2= "Not applicable (This scheme doesn't exist at national level)"
-7= "Not applicable (PB010 ne last year)"
;
VALUE PY1242F /* PY124G_F */
0= "No income"
1= "Filled with only Non-contributory and non means-tested components"
2= "Filled with mixed components"
-1= "Missing"
-2= "Not applicable (This scheme doesn't exist at national level)"
-7= "Not applicable (PB010 ne last year)"
;
VALUE PY1247F /* PY131G_F */
0= "No income"
1= "Filled with only Contributory and means-tested components"
2= "Filled with mixed components"
-1= "Missing"
-2= "Not applicable (This scheme doesn't exist at national level)"
-7= "Not applicable (PB010 ne last year)"
;
VALUE PY1249F /* PY132G_F */
0= "No income"
1= "Filled with only Contributory and non means-tested components"
2= "Filled with mixed components"
-1= "Missing"
-2= "Not applicable (This scheme doesn't exist at national level)"
-7= "Not applicable (PB010 ne last year)"
;
VALUE PY1251F /* PY133G_F */
0= "No income"
1= "Filled with only Non-contributory and means-tested components"
2= "Filled with mixed components"
-1= "Missing"
-2= "Not applicable (This scheme doesn't exist at national level)"
-7= "Not applicable (PB010 ne last year)"
;
VALUE PY1253F /* PY134G_F */
0= "No income"
1= "Filled with only Non-contributory and non means-tested components"
2= "Filled with mixed components"
-1= "Missing"
-2= "Not applicable (This scheme doesn't exist at national level)"
-7= "Not applicable (PB010 ne last year)"
;
VALUE PY1258F /* PY141G_F */
0= "No income"
1= "Filled with only Contributory and means-tested components"
2= "Filled with mixed components"
-1= "Missing"
-2= "Not applicable (This scheme doesn't exist at national level)"
-7= "Not applicable (PB010 ne last year)"
;
VALUE PY1260F /* PY142G_F */
0= "No income"
1= "Filled with only Contributory and non means-tested components"
2= "Filled with mixed components"
-1= "Missing"
-2= "Not applicable (This scheme doesn't exist at national level)"
-7= "Not applicable (PB010 ne last year)"
;
VALUE PY1262F /* PY143G_F */
0= "No income"
1= "Filled with only Non-contributory and means-tested components"
2= "Filled with mixed components"
-1= "Missing"
-2= "Not applicable (This scheme doesn't exist at national level)"
-7= "Not applicable (PB010 ne last year)"
;
VALUE PY1264F /* PY144G_F */
0= "No income"
1= "Filled with only Non-contributory and non means-tested components"
2= "Filled with mixed components"
-1= "Missing"
-2= "Not applicable (This scheme doesn't exist at national level)"
-7= "Not applicable (PB010 ne last year)"
;
VALUE PD0268F /* PD020 */
1= "Yes"
2= "No - cannot afford it"
3= "No - other reason"
;
VALUE PD0269F /* PD020_F */
1= "Filled"
-1= "Missing"
-3= "Not selected respondent"
;
VALUE PD0270F /* PD030 */
1= "Yes"
2= "No - cannot afford it"
3= "No - other reason"
;
VALUE PD0271F /* PD030_F */
1= "Filled"
-1= "Missing"
-3= "Not selected respondent"
;
VALUE PD0272F /* PD050 */
1= "Yes"
2= "No - cannot afford it"
3= "No - other reason"
;
VALUE PD0273F /* PD050_F */
1= "Filled"
-1= "Missing"
-3= "Not selected respondent"
;
VALUE PD0274F /* PD060 */
1= "Yes"
2= "No - cannot afford it"
3= "No - other reason"
;
VALUE PD0275F /* PD060_F */
1= "Filled"
-1= "Missing"
-3= "Not selected respondent"
;
VALUE PD0276F /* PD070 */
1= "Yes"
2= "No - cannot afford it"
3= "No - other reason"
;
VALUE PD0277F /* PD070_F */
1= "Filled"
-1= "Missing"
-3= "Not selected respondent"
;
VALUE PD0278F /* PD080 */
1= "Yes"
2= "No - cannot afford it"
3= "No - other reason"
;
VALUE PD0279F /* PD080_F */
1= "Filled"
-1= "Missing"
-3= "Not selected respondent"
;
VALUE PW0281F /* PW005T_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable (proxy interview)"
-3= "Non-selected respondent"
-7= "Not applicable (PB010 ne 2018)"
-8= "Not applicable (variable not constructed)"
;
VALUE PW0282F /* PW010T */
0= "0 (Not at all satisfied)"
1= "1"
2= "2"
3= "3"
4= "4"
5= "5"
6= "6"
7= "7"
8= "8"
9= "9"
10= "10 (Completely satisfied)"
99= "Do not know"
;
VALUE PW0283F /* PW010T_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable (proxy interview)"
-3= "Non-selected respondent"
-7= "Not applicable (PB010 ne 2018)"
;
VALUE PW2284F /* PW240T */
0= "0 (Not at all satisfied)"
1= "1"
2= "2"
3= "3"
4= "4"
5= "5"
6= "6"
7= "7"
8= "8"
9= "9"
10= "10 (Completely satisfied)"
99= "Do not know"
;
VALUE PW2285F /* PW240T_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable (proxy interview)"
-3= "Non-selected respondent"
-7= "Not applicable (PB010 ne 2018)"
;
VALUE PW0286F /* PW040T */
1= "Yes"
2= "No"
;
VALUE PW0287F /* PW040T_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable (proxy interview)"
-3= "Non-selected respondent"
-7= "Not applicable (PB010 ne 2018)"
;
VALUE PW1288F /* PW110T */
1= "Yes"
2= "No"
;
VALUE PW1289F /* PW110T_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable (proxy interview)"
-3= "Non-selected respondent"
-7= "Not applicable (PB010 ne 2018)"
;
VALUE PW0290F /* PW030T */
0= "0 (Not at all satisfied)"
1= "1"
2= "2"
3= "3"
4= "4"
5= "5"
6= "6"
7= "7"
8= "8"
9= "9"
10= "10 (Completely satisfied)"
99= "Do not know"
;
VALUE PW0291F /* PW030T_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable (proxy interview)"
-3= "Non-selected respondent"
-7= "Not applicable (PB010 ne 2018)"
;
VALUE PW1292F /* PW160T */
0= "0 (Not at all satisfied)"
1= "1"
2= "2"
3= "3"
4= "4"
5= "5"
6= "6"
7= "7"
8= "8"
9= "9"
10= "10 (Completely satisfied)"
99= "Do not know"
;
VALUE PW1293F /* PW160T_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable (proxy interview)"
-3= "Non-selected respondent"
-7= "Not applicable (PB010 ne 2018)"
;
VALUE PW1294F /* PW120T */
0= "0 (Not at all satisfied)"
1= "1"
2= "2"
3= "3"
4= "4"
5= "5"
6= "6"
7= "7"
8= "8"
9= "9"
10= "10 (Completely satisfied)"
99= "Do not know"
;
VALUE PW1295F /* PW120T_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable (proxy interview)"
-3= "Non-selected respondent"
-7= "Not applicable (PB010 ne 2018)"
;
VALUE PW1296F /* PW100T */
0= "0 (Not at all satisfied)"
1= "1"
2= "2"
3= "3"
4= "4"
5= "5"
6= "6"
7= "7"
8= "8"
9= "9"
10= "10 (Completely satisfied)"
99= "Do not know"
;
VALUE PW1297F /* PW100T_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable ((proxy interview) OR (PL031 ne 1,2,3,4))"
-3= "Non-selected respondent"
-7= "Not applicable (PB010 ne 2018)"
;
VALUE PW1298F /* PW190T */
0= "0 (Not at all satisfied)"
1= "1"
2= "2"
3= "3"
4= "4"
5= "5"
6= "6"
7= "7"
8= "8"
9= "9"
10= "10 (Completely satisfied)"
99= "Do not know"
;
VALUE PW1299F /* PW190T_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable (proxy interview)"
-3= "Non-selected respondent"
-7= "Not applicable (PB010 ne 2018)"
;
VALUE PW2300F /* PW230T */
1= "All of the time"
2= "Most of the time"
3= "Some of the time"
4= "A little of the time"
5= "None of the time"
99= "Do not know"
;
VALUE PW2301F /* PW230T_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable (proxy interview)"
-3= "Non-selected respondent"
-7= "Not applicable (PB010 ne 2018)"
;
VALUE PW0302F /* PW050T */
1= "All of the time"
2= "Most of the time"
3= "Some of the time"
4= "A little of the time"
5= "None of the time"
99= "Do not know"
;
VALUE PW0303F /* PW050T_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable (proxy interview)"
-3= "Non-selected respondent"
-7= "Not applicable (PB010 ne 2018)"
;
VALUE PW0304F /* PW060T */
1= "All of the time"
2= "Most of the time"
3= "Some of the time"
4= "A little of the time"
5= "None of the time"
99= "Do not know"
;
VALUE PW0305F /* PW060T_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable (proxy interview)"
-3= "Non-selected respondent"
-7= "Not applicable (PB010 ne 2018)"
;
VALUE PW0306F /* PW070T */
1= "All of the time"
2= "Most of the time"
3= "Some of the time"
4= "A little of the time"
5= "None of the time"
99= "Do not know"
;
VALUE PW0307F /* PW070T_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable (proxy interview)"
-3= "Non-selected respondent"
-7= "Not applicable (PB010 ne 2018)"
;
VALUE PW0308F /* PW080T */
1= "All of the time"
2= "Most of the time"
3= "Some of the time"
4= "A little of the time"
5= "None of the time"
99= "Do not know"
;
VALUE PW0309F /* PW080T_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable (proxy interview)"
-3= "Non-selected respondent"
-7= "Not applicable (PB010 ne 2018)"
;
VALUE PW0310F /* PW090T */
1= "All of the time"
2= "Most of the time"
3= "Some of the time"
4= "A little of the time"
5= "None of the time"
99= "Do not know"
;
VALUE PW0311F /* PW090T_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable (proxy interview)"
-3= "Non-selected respondent"
-7= "Not applicable (PB010 ne 2018)"
;
VALUE PX0315F /* PX040 */
1= "Current household member aged 16 and over"
2= "Selected respondent"
3= "Non-selected respondent"
4= "Ineligible person"
;
VALUE PX0316F /* PX050 */
2= "Employees (SAL)"
3= "Employed persons except employees (NSAL)"
4= "Other employed (when time of SAL and NSAL is > ¿ of total time calendar)
5= "Unemployed"
6= "Retired"
7= "Inactive"
8= "Other inactive (when time of unemployed, retirement and inactivity is > ¿ of total time calendar)
;
format PB020 $PB01F.;
format PB040_F PB04F.;
format PB060_F PB06F.;
format PB100 PB17F.;
format PB100_F PB18F.;
format PB110_F PB110F.;
format PB120_F PB112F.;
format PB130 PB113F.;
format PB130_F PB114F.;
format PB140_F PB116F.;
format PB150 PB117F.;
format PB150_F PB118F.;
format PB160_F PB120F.;
format PB170_F PB122F.;
format PB180_F PB124F.;
format PB190 PB125F.;
format PB190_F PB126F.;
format PB200 PB227F.;
format PB200_F PB228F.;
format PB210 $PB229F.;
format PB210_F PB230F.;
format PB220A $PB231F.;
format PB220A_F PB232F.;
format PE010 PE033F.;
format PE010_F PE034F.;
format PE020 PE035F.;
format PE020_F PE036F.;
format PE030_F PE038F.;
format PE040 PE039F.;
format PE040_F PE040F.;
format PH010 PH041F.;
format PH010_F PH042F.;
format PH020 PH043F.;
format PH020_F PH044F.;
format PH030 PH045F.;
format PH030_F PH046F.;
format PH040 PH047F.;
format PH040_F PH048F.;
format PH050 PH049F.;
format PH050_F PH050F.;
format PH060 PH051F.;
format PH060_F PH052F.;
format PH070 PH053F.;
format PH070_F PH054F.;
format PL015 PL055F.;
format PL015_F PL056F.;
format PL020 PL057F.;
format PL020_F PL058F.;
format PL025 PL059F.;
format PL025_F PL060F.;
format PL031 PL061F.;
format PL031_F PL062F.;
format PL035 PL063F.;
format PL035_F PL064F.;
format PL040 PL065F.;
format PL040_F PL066F.;
format PL051 PL067F.;
format PL051_F PL068F.;
format PL060_F PL070F.;
format PL073_F PL072F.;
format PL074_F PL074F.;
format PL075_F PL076F.;
format PL076_F PL078F.;
format PL080_F PL080F.;
format PL085_F PL082F.;
format PL086_F PL084F.;
format PL087_F PL086F.;
format PL088_F PL088F.;
format PL089_F PL090F.;
format PL090_F PL092F.;
format PL100_F PL194F.;
format PL111 $PL195F.;
format PL111_F PL196F.;
format PL120 PL197F.;
format PL120_F PL198F.;
format PL130 PL199F.;
format PL130_F PL1100F.;
format PL140 PL1101F.;
format PL140_F PL1102F.;
format PL150 PL1103F.;
format PL150_F PL1104F.;
format PL160 PL1105F.;
format PL160_F PL1106F.;
format PL170 PL1107F.;
format PL170_F PL1108F.;
format PL180 PL1109F.;
format PL180_F PL1110F.;
format PL190_F PL1112F.;
format PL200_F PL2114F.;
format PL211A PL2115F.;
format PL211A_F PL2116F.;
format PL211B PL2117F.;
format PL211B_F PL2118F.;
format PL211C PL2119F.;
format PL211C_F PL2120F.;
format PL211D PL2121F.;
format PL211D_F PL2122F.;
format PL211E PL2123F.;
format PL211E_F PL2124F.;
format PL211F PL2125F.;
format PL211F_F PL2126F.;
format PL211G PL2127F.;
format PL211G_F PL2128F.;
format PL211H PL2129F.;
format PL211H_F PL2130F.;
format PL211I PL2131F.;
format PL211I_F PL2132F.;
format PL211J PL2133F.;
format PL211J_F PL2134F.;
format PL211K PL2135F.;
format PL211K_F PL2136F.;
format PL211L PL2137F.;
format PL211L_F PL2138F.;
format PY030G_F PY0185F.;
format PY031G_F PY0188F.;
format PY091G_F PY0203F.;
format PY092G_F PY0205F.;
format PY093G_F PY0207F.;
format PY094G_F PY0209F.;
format PY101G_F PY1214F.;
format PY102G_F PY1216F.;
format PY103G_F PY1218F.;
format PY104G_F PY1220F.;
format PY111G_F PY1225F.;
format PY112G_F PY1227F.;
format PY113G_F PY1229F.;
format PY114G_F PY1231F.;
format PY121G_F PY1236F.;
format PY122G_F PY1238F.;
format PY123G_F PY1240F.;
format PY124G_F PY1242F.;
format PY131G_F PY1247F.;
format PY132G_F PY1249F.;
format PY133G_F PY1251F.;
format PY134G_F PY1253F.;
format PY141G_F PY1258F.;
format PY142G_F PY1260F.;
format PY143G_F PY1262F.;
format PY144G_F PY1264F.;
format PD020 PD0268F.;
format PD020_F PD0269F.;
format PD030 PD0270F.;
format PD030_F PD0271F.;
format PD050 PD0272F.;
format PD050_F PD0273F.;
format PD060 PD0274F.;
format PD060_F PD0275F.;
format PD070 PD0276F.;
format PD070_F PD0277F.;
format PD080 PD0278F.;
format PD080_F PD0279F.;
format PW005T_F PW0281F.;
format PW010T PW0282F.;
format PW010T_F PW0283F.;
format PW240T PW2284F.;
format PW240T_F PW2285F.;
format PW040T PW0286F.;
format PW040T_F PW0287F.;
format PW110T PW1288F.;
format PW110T_F PW1289F.;
format PW030T PW0290F.;
format PW030T_F PW0291F.;
format PW160T PW1292F.;
format PW160T_F PW1293F.;
format PW120T PW1294F.;
format PW120T_F PW1295F.;
format PW100T PW1296F.;
format PW100T_F PW1297F.;
format PW190T PW1298F.;
format PW190T_F PW1299F.;
format PW230T PW2300F.;
format PW230T_F PW2301F.;
format PW050T PW0302F.;
format PW050T_F PW0303F.;
format PW060T PW0304F.;
format PW060T_F PW0305F.;
format PW070T PW0306F.;
format PW070T_F PW0307F.;
format PW080T PW0308F.;
format PW080T_F PW0309F.;
format PW090T PW0310F.;
format PW090T_F PW0311F.;
format PX040 PX0315F.;
format PX050 PX0316F.;
RUN;
