#Declinazione di responsabilità. 
#I file rilasciati in formato testo sono provvisti anche dei programmi di importazione per STATA, SAS e R. 
#L'Istat non garantisce che le funzioni contenute nei suddetti programmi siano esenti da errore e non si assume alcuna responsabilità sull’output ottenuto dal loro utilizz
setwd(choose.dir(default = "", caption = "WHERE ARE MICRODATA?"))
direttorio = getwd()
fileInput = paste (direttorio, "/ISTAT_MFR_EUSILC_Cross_Microdata_2018_PERSONAL_DATA_(P-FILE)_Cross-Sectional_FILE_STRUCTURE_EXAMPLE.txt", sep="")
DF_EUSILC_Cross_A2018_PERSONAL_<- read.delim2 (fileInput,  header=T, sep="	",  quote="",  na.strings = ".")
attr(DF_EUSILC_Cross_A2018_PERSONAL_, "label") <- c(
"YEAR OF THE SURVEY",
"COUNTRY",
"PERSONAL ID",
"PERSONAL CROSS-SECTIONAL WEIGHT",
"FLAG OF PB040",
"PERSONAL CROSS-SECTIONAL WEIGHT FOR SELECTED RESPONDENT",
"FLAG OF PB060",
"MONTH OF THE PERSONAL INTERVIEW",
"FLAG OF PB100",
"YEAR OF THE PERSONAL INTERVIEW",
"FLAG OF PB110",
"MINUTES TO COMPLETE THE PERSONAL QUESTIONNAIRE",
"FLAG OF PB120",
"MONTH OF BIRTH",
"FLAG OF PB130",
"YEAR OF BIRTH",
"FLAG OF PB140",
"SEX",
"FLAG OF PB150",
"FATHER ID",
"FLAG OF PB160",
"MOTHER ID",
"FLAG OF PB170",
"SPOUSE/PARTNER ID",
"FLAG OF PB180",
"MARITAL STATUS",
"FLAG OF PB190",
"CONSENSUAL UNION",
"FLAG OF PB200",
"COUNTRY OF BIRTH",
"FLAG OF PB210",
"CITIZENSHIP 1",
"FLAG OF PB220A",
"CURRENT EDUCATION ACTIVITY",
"FLAG OF PE010",
"ISCED LEVEL CURRENTLY ATTENDED",
"FLAG OF PE020",
"YEAR WHEN HIGHEST LEVEL OF EDUCATION WAS ATTAINED",
"FLAG OF PE030",
"HIGHEST ISCED LEVEL ATTAINED",
"FLAG OF PE040",
"GENERAL HEALTH",
"FLAG OF PH010",
"SUFFER FROM ANY CHRONIC (LONG-STANDING) ILLNESS OR CONDITION",
"FLAG OF PH020",
"LIMITATION IN ACTIVITIES BECAUSE OF HEALTH PROBLEMS",
"FLAG OF PH030",
"UNMET NEED FOR MEDICAL EXAMINATION OR TREATMENT",
"FLAG OF PH040",
"MAIN REASON FOR UNMET NEED FOR MEDICAL EXAMINATION OR TREATMENT",
"FLAG OF PH050",
"UNMET NEED FOR DENTAL EXAMINATION OR TREATMENT",
"FLAG OF PH060",
"MAIN REASON FOR UNMET NEED FOR DENTAL EXAMINATION OR TREATMENT",
"FLAG OF PH070",
"WHETHER PERSON HAS EVER WORKED",
"FLAG OF PL015",
"ACTIVELY LOOKING FOR A JOB",
"FLAG OF PL020",
"AVAILABLE FOR WORK",
"FLAG OF PL025",
"SELF-DEFINED CURRENT ECONOMIC STATUS",
"FLAG OF PL031",
"WORKED AT LEAST ONE HOUR DURING THE PREVIOUS WEEK",
"FLAG OF PL035",
"STATUS IN EMPLOYMENT",
"FLAG OF PL040",
"OCCUPATION (ISCO-08 (COM))",
"FLAG OF PL051",
"NUMBER OF HOURS USUALLY WORKED PER WEEK IN MAIN JOB",
"FLAG OF PL060",
"NUMBER OF MONTHS SPENT AT FULL-TIME WORK AS EMPLOYEE",
"FLAG OF PL073",
"NUMBER OF MONTHS SPENT AT PART-TIME WORK AS EMPLOYEE",
"FLAG OF PL074",
"NUMBER OF MONTHS SPENT AT FULL-TIME WORK AS SELF-EMPLOYED (INCLUDING FAMILY WORKER)",
"FLAG OF PL075",
"NUMBER OF MONTHS SPENT AT PART-TIME WORK AS SELF-EMPLOYED (INCLUDING FAMILY WORKER)",
"FLAG OF PL076",
"NUMBER OF MONTHS SPENT IN UNEMPLOYMENT",
"FLAG OF PL080",
"NUMBER OF MONTHS SPENT IN RETIREMENT OR EARLY RETIREMENT",
"FLAG OF PL085",
"NUMBER OF MONTHS SPENT AS DISABLED OR/AND UNFIT TO WORK",
"FLAG OF PL086",
"NUMBER OF MONTHS SPENT STUDYING",
"FLAG OF PL087",
"NUMBER OF MONTHS SPENT IN COMPULSORY MILITARY SERVICE",
"FLAG OF PL088",
"NUMBER OF MONTHS SPENT FULFILLING DOMESTIC TASKS AND CARE RESPONSIBILITIES",
"FLAG OF PL089",
"NUMBER OF MONTHS SPENT IN OTHER INACTIVITY",
"FLAG OF PL090",
"TOTAL NUMBER OF HOURS USUALLY WORKED IN SECOND, THIRD, ... JOBS",
"FLAG OF PL100",
"NACE REV.2",
"FLAG OF PL111",
"REASON FOR WORKING LESS THAN 30 HOURS",
"FLAG OF PL120",
"NUMBER OF PERSONS WORKING AT THE LOCAL UNIT",
"FLAG OF PL130",
"TYPE OF CONTRACT",
"FLAG OF PL140",
"MANAGERIAL POSITION",
"FLAG OF PL150",
"CHANGE OF JOB SINCE LAST YEAR",
"FLAG OF PL160",
"REASON TO CHANGE",
"FLAG OF PL170",
"MOST RECENT CHANGE IN THE INDIVIDUAL�S ACTIVITY STATUS
"FLAG OF PL180",
"WHEN BEGAN FIRST REGULAR JOB",
"FLAG OF PL190",
"NUMBER OF YEARS SPENT IN PAID WORK",
"FLAG OF PL200",
"MAIN ACTIVITY IN JANUARY",
"FLAG OF PL211A",
"MAIN ACTIVITY IN FEBRUARY",
"FLAG OF PL211B",
"MAIN ACTIVITY IN MARCH",
"FLAG OF PL211C",
"MAIN ACTIVITY IN APRIL",
"FLAG OF PL211D",
"MAIN ACTIVITY IN MAY",
"FLAG OF PL211E",
"MAIN ACTIVITY IN JUNE",
"FLAG OF PL211F",
"MAIN ACTIVITY IN JULY",
"FLAG OF PL211G",
"MAIN ACTIVITY IN AUGUST",
"FLAG OF PL211H",
"MAIN ACTIVITY IN SEPTEMBER",
"FLAG OF PL211I",
"MAIN ACTIVITY IN OCTOBER",
"FLAG OF PL211J",
"MAIN ACTIVITY IN NOVEMBER",
"FLAG OF PL211K",
"MAIN ACTIVITY IN DECEMBER",
"FLAG OF PL211L",
"EMPLOYEE CASH OR NEAR CASH INCOME",
"FLAG OF PY010N",
"IMPUTATION FACTOR OF PY010N",
"NON-CASH EMPLOYEE INCOME",
"FLAG OF PY020N",
"IMPUTATION FACTOR OF PY020N",
"COMPANY CAR",
"FLAG OF PY021N",
"IMPUTATION FACTOR OF PY021N",
"CONTRIBUTIONS TO INDIVIDUAL PRIVATE PENSION PLANS",
"FLAG OF PY035N",
"IMPUTATION FACTOR OF PY035N",
"CASH PROFITS OR LOSSES FROM SELF-EMPLOYMENT",
"FLAG OF PY050N",
"IMPUTATION FACTOR OF PY050N",
"PENSION FROM INDIVIDUAL PRIVATE PLANS",
"FLAG OF PY080N",
"IMPUTATION FACTOR OF PY080N",
"UNEMPLOYMENT BENEFITS",
"FLAG OF PY090N",
"IMPUTATION FACTOR OF PY090N",
"OLD-AGE BENEFITS",
"FLAG OF PY100N",
"IMPUTATION FACTOR OF PY100N",
"SURVIVOR' BENEFITS",
"FLAG OF PY110N",
"IMPUTATION FACTOR OF PY110N",
"SICKNESS BENEFITS",
"FLAG OF PY120N",
"IMPUTATION FACTOR OF PY120N",
"DISABILITY BENEFITS",
"FLAG OF PY130N",
"IMPUTATION FACTOR OF PY130N",
"EDUCATION-RELATED ALLOWANCES",
"FLAG OF PY140N",
"IMPUTATION FACTOR OF PY140N",
"EMPLOYEE CASH OR NEAR CASH INCOME",
"FLAG OF PY010G",
"IMPUTATION FACTOR OF PY010G",
"NON-CASH EMPLOYEE INCOME",
"FLAG OF PY020G",
"IMPUTATION FACTOR OF PY020G",
"COMPANY CAR",
"FLAG OF PY021G",
"IMPUTATION FACTOR OF PY021G",
"EMPLOYER'S SOCIAL INSURANCE CONTRIBUTION",
"FLAG OF PY030G",
"IMPUTATION FACTOR OF PY030G",
"OPTIONAL EMPLOYER'S SOCIAL INSURANCE CONTRIBUTIONS",
"FLAG OF PY031G",
"IMPUTATION FACTOR OF PY031G",
"CONTRIBUTIONS TO INDIVIDUAL PRIVATE PENSION PLANS",
"FLAG OF PY035G",
"IMPUTATION FACTOR OF PY035G",
"CASH PROFITS OR LOSSES FROM SELF-EMPLOYMENT",
"FLAG OF PY050G",
"IMPUTATION FACTOR OF PY050G",
"PENSION FROM INDIVIDUAL PRIVATE PLANS",
"FLAG OF PY080G",
"IMPUTATION FACTOR OF PY080G",
"UNEMPLOYMENT BENEFITS",
"FLAG OF PY090G",
"IMPUTATION FACTOR OF PY090G",
"UNEMPLOYMENT BENEFITS (CONTRIBUTORY AND MEANS-TESTED)",
"FLAG OF PY091G",
"UNEMPLOYMENT BENEFITS (CONTRIBUTORY AND NON MEANS-TESTED)",
"FLAG OF PY092G",
"UNEMPLOYMENT BENEFITS (NON-CONTRIBUTORY AND MEANS-TESTED)",
"FLAG OF PY093G",
"UNEMPLOYMENT BENEFITS (NON-CONTRIBUTORY AND NON MEANS-TESTED)",
"FLAG OF PY094G",
"OLD-AGE BENEFITS",
"FLAG OF PY100G",
"IMPUTATION FACTOR OF PY100G",
"OLD-AGE BENEFITS (CONTRIBUTORY AND MEANS-TESTED)",
"FLAG OF PY101G",
"OLD-AGE BENEFITS (CONTRIBUTORY AND NON MEANS-TESTED)",
"FLAG OF PY102G",
"OLD-AGE BENEFITS (NON-CONTRIBUTORY AND MEANS-TESTED)",
"FLAG OF PY103G",
"OLD-AGE BENEFITS (NON-CONTRIBUTORY AND NON MEANS-TESTED)",
"FLAG OF PY104G",
"SURVIVOR' BENEFITS",
"FLAG OF PY110G",
"IMPUTATION FACTOR OF PY110G",
"SURVIVOR� BENEFITS (CONTRIBUTORY AND MEANS-TESTED)
"FLAG OF PY111G",
"SURVIVOR� BENEFITS (CONTRIBUTORY AND NON MEANS-TESTED)
"FLAG OF PY112G",
"SURVIVOR� BENEFITS (NON-CONTRIBUTORY AND MEANS-TESTED)
"FLAG OF PY113G",
"SURVIVOR� BENEFITS (NON-CONTRIBUTORY AND NON MEANS-TESTED)
"FLAG OF PY114G",
"SICKNESS BENEFITS",
"FLAG OF PY120G",
"IMPUTATION FACTOR OF PY120G",
"SICKNESS BENEFITS (CONTRIBUTORY AND MEANS-TESTED)",
"FLAG OF PY121G",
"SICKNESS BENEFITS (CONTRIBUTORY AND NON MEANS-TESTED)",
"FLAG OF PY122G",
"SICKNESS BENEFITS (NON-CONTRIBUTORY AND MEANS-TESTED)",
"FLAG OF PY123G",
"SICKNESS BENEFITS (NON-CONTRIBUTORY AND NON MEANS-TESTED)",
"FLAG OF PY124G",
"DISABILITY BENEFITS",
"FLAG OF PY130G",
"IMPUTATION FACTOR OF PY130G",
"DISABILITY BENEFITS (CONTRIBUTORY AND MEANS-TESTED)",
"FLAG OF PY131G",
"DISABILITY BENEFITS (CONTRIBUTORY AND NON MEANS-TESTED)",
"FLAG OF PY132G",
"DISABILITY BENEFITS (NON-CONTRIBUTORY AND MEANS-TESTED)",
"FLAG OF PY133G",
"DISABILITY BENEFITS (NON-CONTRIBUTORY AND NON MEANS-TESTED)",
"FLAG OF PY134G",
"EDUCATION-RELATED ALLOWANCES",
"FLAG OF PY140G",
"IMPUTATION FACTOR OF PY140G",
"EDUCATION-RELATED ALLOWANCES (CONTRIBUTORY AND MEANS-TESTED)",
"FLAG OF PY141G",
"EDUCATION-RELATED ALLOWANCES (CONTRIBUTORY AND NON MEANS-TESTED)",
"FLAG OF PY142G",
"EDUCATION-RELATED ALLOWANCES (NON-CONTRIBUTORY AND MEANS-TESTED)",
"FLAG OF PY143G",
"EDUCATION-RELATED ALLOWANCES (NON-CONTRIBUTORY AND NON MEANS-TESTED)",
"FLAG OF PY144G",
"GROSS MONTHLY EARNINGS FOR EMPLOYEES",
"FLAG OF PY200G",
"IMPUTATION FACTOR OF PY200G",
"REPLACE WORN-OUT CLOTHES BY SOME NEW (NOT SECOND-HAND) ONES",
"FLAG OF PD020",
"TWO PAIRS OF PROPERLY FITTING SHOES (INCLUDING A PAIR OF ALL-WEATHER SHOES)",
"FLAG OF PD030",
"GET-TOGETHER WITH FRIENDS/FAMILY (RELATIVES) FOR A DRINK/MEAL AT LEAST ONCE A MONTH",
"FLAG OF PD050",
"REGULARLY PARTICIPATE IN A LEISURE ACTIVITY",
"FLAG OF PD060",
"SPEND A SMALL AMOUNT OF MONEY EACH WEEK ON YOURSELF",
"FLAG OF PD070",
"INTERNET CONNECTION FOR PERSONAL USE AT HOME",
"FLAG OF PD080",
"MODULE ON WELL-BEING WEIGHT",
"FLAG OF PW005T",
"OVERALL LIFE SATISFACTION",
"FLAG OF PW010T",
"PERCEIVED SOCIAL EXCLUSION",
"FLAG OF PW240T",
"MATERIAL HELP",
"FLAG OF PW040T",
"NON-MATERIAL HELP",
"FLAG OF PW110T",
"SATISFACTION WITH FINANCIAL SITUATION",
"FLAG OF PW030T",
"SATISFACTION WITH PERSONAL RELATIONSHIPS",
"FLAG OF PW160T",
"SATISFACTION WITH TIME USE (AMOUNT OF LEISURE TIME)",
"FLAG OF PW120T",
"SATISFACTION WITH JOB",
"FLAG OF PW100T",
"TRUST IN OTHERS",
"FLAG OF PW190T",
"FEELING LONELY",
"FLAG OF PW230T",
"BEING VERY NERVOUS",
"FLAG OF PW050T",
"FEELING DOWN IN THE DUMPS",
"FLAG OF PW060T",
"FEELING CALM AND PEACEFUL",
"FLAG OF PW070T",
"FEELING DOWNHEARTED OR DEPRESSED",
"FLAG OF PW080T",
"BEING HAPPY",
"FLAG OF PW090T",
"CHANGE RATE",
"AGE AT THE END OF THE INCOME REFERENCE PERIOD",
"HOUSEHOLD IDENTIFICATION NUMBER",
"SELECTED RESPONDENT STATUS",
"ACTIVITY STATUS")

PB020_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PB020, 
levels=c("AT", 
"BE", 
"BG", 
"CH", 
"CY", 
"CZ", 
"DE", 
"DK", 
"EE", 
"EL", 
"ES", 
"FI", 
"FR", 
"HR", 
"HU", 
"IE", 
"IS", 
"IT", 
"LT", 
"LU", 
"LV", 
"ME", 
"MK", 
"MT", 
"NL", 
"NO", 
"PL", 
"PT", 
"RO", 
"RS", 
"SE", 
"SI", 
"SK", 
"TR", 
"UK"), 
labels=c("¿sterreich", 
"Belgique/Belg¿e", 
"Bulgaria", 
"Switzerland", 
"Cyprus", 
"Czech republic", 
"Deutschland", 
"Denmark", 
"Estonia", 
"Ell¿da", 
"Espa¿a", 
"Suomi", 
"France", 
"Croatia", 
"Hungary", 
"Ireland", 
"Iceland", 
"Italia", 
"Lithuania", 
"Luxembourg", 
"Latvia", 
"Montenegro", 
"The Former Yugoslav Republic of Macedonia (FYROM)", 
"Malta", 
"Nederland", 
"Norway", 
"Poland", 
"Portugal", 
"Romania", 
"Serbia", 
"Sverige", 
"Slovenia", 
"Slovak republic", 
"Turkey", 
"United Kingdom"

PB040_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PB040_F, 
levels=c(1, 
-7), 
labels=c("Filled", 
"Not applicable: PB010 ne last year")) 


PB060_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PB060_F, 
levels=c(1, 
-2, 
-3, 
-7), 
labels=c("Filled", 
"Not applicable (country does not use the selected respondent model)", 
"Non-selected respondent", 
"Not applicable: PB010 ne last year")) 


PB100_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PB100, 
levels=c(1, 
2, 
3, 
4), 
labels=c("January-March", 
"April-June", 
"July-September", 
"October-December")) 


PB100_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PB100_F, 
levels=c(1, 
-1), 
labels=c("Filled", 
"Missing")) 


PB110_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PB110_F, 
levels=c(1, 
-1), 
labels=c("Filled", 
"Missing")) 


PB120_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PB120_F, 
levels=c(1, 
-1, 
-2), 
labels=c("Filled", 
"Missing", 
"Not applicable (information only extracted from registers)")) 


PB130_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PB130, 
levels=c(1, 
2, 
3, 
4), 
labels=c("January-March", 
"April-June", 
"July-September", 
"October-December")) 


PB130_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PB130_F, 
levels=c(1, 
-1), 
labels=c("Filled", 
"Missing")) 


PB140_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PB140_F, 
levels=c(1, 
-1), 
labels=c("Filled", 
"Missing")) 


PB150_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PB150, 
levels=c(1, 
2), 
labels=c("Male", 
"Female")) 


PB150_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PB150_F, 
levels=c(1, 
-1), 
labels=c("Filled", 
"Missing")) 


PB160_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PB160_F, 
levels=c(1, 
-1, 
-2), 
labels=c("Filled", 
"Missing", 
"Not applicable (father is not a household member)")) 


PB170_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PB170_F, 
levels=c(1, 
-1, 
-2), 
labels=c("Filled", 
"Missing", 
"Not applicable (mother is not a household member)")) 


PB180_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PB180_F, 
levels=c(1, 
-1, 
-2), 
labels=c("Filled", 
"Missing", 
"Not applicable (person has no spouse/partner or spouse/partner is not a household member)")) 


PB190_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PB190, 
levels=c(1, 
2, 
3, 
4, 
5), 
labels=c("Never married", 
"Married", 
"Separated", 
"Widowed", 
"Divorced")) 


PB190_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PB190_F, 
levels=c(1, 
-1), 
labels=c("Filled", 
"Missing")) 


PB200_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PB200, 
levels=c(1, 
2, 
3), 
labels=c("Yes, on a legal basis", 
"Yes, without a legal basis", 
"No")) 


PB200_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PB200_F, 
levels=c(1, 
-1), 
labels=c("Filled", 
"Missing")) 


PB210_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PB210, 
levels=c("EU", 
"LOC", 
"OTH"), 
labels=c("European Countries", 
"Italy", 
"Other")) 


PB210_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PB210_F, 
levels=c(1, 
-1), 
labels=c("Filled", 
"Missing")) 


PB220A_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PB220A, 
levels=c("EU", 
"LOC", 
"OTH"), 
labels=c("European Countries", 
"Italy", 
"Other")) 


PB220A_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PB220A_F, 
levels=c(1, 
-1), 
labels=c("Filled", 
"Missing")) 


PE010_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PE010, 
levels=c(1, 
2), 
labels=c("In education", 
"Not in education")) 


PE010_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PE010_F, 
levels=c(1, 
-1), 
labels=c("Filled", 
"Missing")) 


PE020_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PE020, 
levels=c(00, 
10, 
20, 
30, 
40, 
50), 
labels=c("Early childhood education", 
"Primary education", 
"Lower secondary education", 
"Upper secondary education (not further specified)", 
"Post-secondary non tertiary education (not further specified)", 
"Tertiary education")) 


PE020_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PE020_F, 
levels=c(1, 
-1, 
-2), 
labels=c("Filled", 
"Missing", 
"Not applicable (PE010 not equal to 1)")) 


PE030_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PE030_F, 
levels=c(1, 
-1, 
-2), 
labels=c("Filled", 
"Missing", 
"Not applicable (PE040 eq 000)")) 


PE040_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PE040, 
levels=c(000, 
100, 
200, 
300, 
400, 
500), 
labels=c("Less than primary education", 
"Primary education", 
"Lower secondary education", 
"Upper secondary education (not further specified)", 
"Post-secondary non-tertiary education (not further specified)", 
"Tertiary education")) 


PE040_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PE040_F, 
levels=c(1, 
-1), 
labels=c("Filled", 
"Missing")) 


PH010_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PH010, 
levels=c(1, 
2, 
3, 
4, 
5), 
labels=c("Very good", 
"Good", 
"Fair", 
"Bad", 
"Very bad")) 


PH010_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PH010_F, 
levels=c(1, 
-1, 
-3), 
labels=c("Filled", 
"Missing", 
"Non-selected respondent")) 


PH020_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PH020, 
levels=c(1, 
2), 
labels=c("Yes", 
"No")) 


PH020_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PH020_F, 
levels=c(1, 
-1, 
-3), 
labels=c("Filled", 
"Missing", 
"Non-selected respondent")) 


PH030_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PH030, 
levels=c(1, 
2, 
3), 
labels=c("Yes, strongly limited", 
"Yes, limited", 
"No, not limited")) 


PH030_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PH030_F, 
levels=c(1, 
-1, 
-3), 
labels=c("Filled", 
"Missing", 
"Non-selected respondent")) 


PH040_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PH040, 
levels=c(1, 
2), 
labels=c("Yes, there was at least one occasion when the person really needed examination or treatment but did not receive it", 
"No, there was no occasion when the person really needed examination or treatment but did not receive it")) 


PH040_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PH040_F, 
levels=c(1, 
-1, 
-2, 
-3), 
labels=c("Filled", 
"Missing", 
"Not applicable: the person did not really need any medical examination or treatment", 
"Non-selected respondent")) 


PH050_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PH050, 
levels=c(1, 
2, 
3, 
4, 
5, 
6, 
7, 
8), 
labels=c("Could not afford to (too expensive)", 
"Waiting list", 
"Could not take time because of work, care for children or for others", 
"Too far to travel/no means of transportation", 
"Fear of doctor/hospitals/examination/ treatment", 
"Wanted to wait and see if problem got better on its own", 
"Didn¿t know any good doctor or specialist", 
"Other reasons")) 

PH050_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PH050_F, 
levels=c(1, 
-1, 
-2, 
-3), 
labels=c("Filled", 
"Missing", 
"Not applicable (PH040 not equal to 1)", 
"Non-selected respondent")) 


PH060_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PH060, 
levels=c(1, 
2), 
labels=c("Yes, there was at least one occasion when the person really needed dental examination or treatment but did not receive it", 
"No, there was no occasion when the person really needed dental examination or treatment but did not receive it")) 


PH060_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PH060_F, 
levels=c(1, 
-1, 
-2, 
-3), 
labels=c("Filled", 
"Missing", 
"Not applicable: the person did not really need any dental examination or treatment", 
"Non-selected respondent")) 


PH070_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PH070, 
levels=c(1, 
2, 
3, 
4, 
5, 
6, 
7, 
8), 
labels=c("Could not afford to (too expensive)", 
"Waiting list", 
"Could not take time because of work, care for children or for others", 
"Too far to travel/no means of transportation", 
"Fear of doctor(dentist)/hospitals/examination/ treatment", 
"Wanted to wait and see if problem got better on its own", 
"Didn¿t know any good dentist", 
"Other reasons")) 

PH070_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PH070_F, 
levels=c(1, 
-1, 
-2, 
-3), 
labels=c("Filled", 
"Missing", 
"Not applicable (PH060 not equal to 1)", 
"Non-selected respondent")) 


PL015_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PL015, 
levels=c(1, 
2), 
labels=c("Yes", 
"No")) 


PL015_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PL015_F, 
levels=c(1, 
-1, 
-2), 
labels=c("Filled", 
"Missing", 
"Not applicable (PL031 eq 1, 2, 3 or 4)")) 


PL020_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PL020, 
levels=c(1, 
2), 
labels=c("Yes", 
"No")) 


PL020_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PL020_F, 
levels=c(1, 
-1, 
-2), 
labels=c("Filled", 
"Missing", 
"Not applicable (PL031 eq 1, 2, 3 or 4 or older than the standard retirement age)")) 


PL025_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PL025, 
levels=c(1, 
2), 
labels=c("Yes", 
"No")) 


PL025_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PL025_F, 
levels=c(1, 
-1, 
-2), 
labels=c("filled", 
"Missing", 
"Not applicable (PL020 not equal to 1)")) 


PL031_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PL031, 
levels=c(1, 
2, 
3, 
4, 
5, 
6, 
7, 
8, 
9, 
10, 
11), 
labels=c("Employee working full-time", 
"Employee working part-time", 
"Self-employed working full-time (including family worker)", 
"Self-employed working part-time (including family worker)", 
"Unemployed", 
"Pupil, student, further training, unpaid work experience", 
"In retirement or in early retirement or has given up business", 
"Permanently disabled or/and unfit to work", 
"In compulsory military or community service", 
"Fulfilling domestic tasks and care responsibilities", 
"Other inactive person")) 


PL031_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PL031_F, 
levels=c(1, 
-1), 
labels=c("Filled", 
"Missing")) 


PL035_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PL035, 
levels=c(1, 
2), 
labels=c("Yes", 
"No")) 


PL035_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PL035_F, 
levels=c(1, 
-1, 
-2, 
-3), 
labels=c("Filled", 
"Missing", 
"Not applicable (person is not employee or MS has other source to calculate the gender pay gap)", 
"Non-selected respondent")) 


PL040_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PL040, 
levels=c(1, 
2, 
3, 
4), 
labels=c("Self-employed with employees", 
"Self-employed without employees", 
"Employee", 
"Family worker")) 


PL040_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PL040_F, 
levels=c(1, 
-1, 
-2), 
labels=c("Filled", 
"Missing", 
"Not applicable (PL015 not equal to 1 and PL031 not equal to 1,2,3 or 4)")) 


PL051_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PL051, 
levels=c(1, 
2, 
3, 
11, 
12, 
13, 
14, 
21, 
22, 
23, 
24, 
25, 
26, 
31, 
32, 
33, 
34, 
35, 
41, 
42, 
43, 
44, 
51, 
52, 
53, 
54, 
61, 
62, 
63, 
71, 
72, 
73, 
74, 
75, 
81, 
82, 
83, 
91, 
92, 
93, 
94, 
95, 
96), 
labels=c("Commissioned Armed Forces Officers", 
"Non-commissioned Armed Forces Officers", 
"Armed Forces Occupations, Other Ranks", 
"Chief Executives, Senior Officials and Legislators", 
"Administrative and Commercial Managers", 
"Production and Specialized Services Managers", 
"Hospitality, Retail and Other Services Managers", 
"Science and Engineering Professionals", 
"Health Professionals", 
"Teaching Professionals", 
"Business and Administration Professionals", 
"Information and Communications Technology Professionals", 
"Legal, Social and Cultural Professionals", 
"Science and Engineering Associate Professionals", 
"Health Associate Professionals", 
"Business and Administration Associate Professionals", 
"Legal, Social, Cultural and Related Associate Professionals", 
"Information and Communications Technicians", 
"General and Keyboard Clerks", 
"Customer Services Clerks", 
"Numerical and Material Recording Clerks", 
"Other Clerical Support Workers", 
"Personal Services Workers", 
"Sales Workers", 
"Personal Care Workers", 
"Protective Services Workers", 
"Market-oriented Skilled Agricultural Workers", 
"Market-oriented Skilled Forestry, Fishery and Hunting Workers", 
"Subsistence Farmers, Fishers, Hunters and Gatherers", 
"Building and Related Trades Workers (excluding Electricians)", 
"Metal, Machinery and Related Trades Workers", 
"Handicraft and Printing Workers", 
"Electrical and Electronic Trades Workers", 
"Food Processing, Woodworking, Garment and Other Craft and Related Trades Workers", 
"Stationary Plant and Machine Operators", 
"Assemblers", 
"Drivers and Mobile Plant Operators", 
"Cleaners and Helpers", 
"Agricultural, Forestry and Fishery Labourers", 
"Labourers in Mining, Construction, Manufacturing and Transport", 
"Food Preparation Assistants", 
"Street and Related Sales and Services Workers", 
"Refuse Workers and Other Elementary Workers")) 


PL051_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PL051_F, 
levels=c(1, 
-1, 
-2), 
labels=c("Filled", 
"Missing", 
"Not applicable (PL031 not eq 1, 2, 3 or 4 and PL015 not eq 1)")) 


PL060_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PL060_F, 
levels=c(1, 
-1, 
-2, 
-6), 
labels=c("Filled", 
"Missing", 
"Not applicable (PL031 not eq 1, 2, 3 or 4)", 
"Hours varying (when an average for over four weeks is not possible)")) 


PL073_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PL073_F, 
levels=c(1, 
-1, 
-5), 
labels=c("Filled", 
"Missing", 
"Missing value because the definition of this variable is not used (PL088 and PL089 only)")) 


PL074_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PL074_F, 
levels=c(1, 
-1, 
-5), 
labels=c("Filled", 
"Missing", 
"Missing value because the definition of this variable is not used (PL088 and PL089 only)")) 


PL075_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PL075_F, 
levels=c(1, 
-1, 
-5), 
labels=c("Filled", 
"Missing", 
"Missing value because the definition of this variable is not used (PL088 and PL089 only)")) 


PL076_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PL076_F, 
levels=c(1, 
-1, 
-5), 
labels=c("Filled", 
"Missing", 
"Missing value because the definition of this variable is not used (PL088 and PL089 only)")) 


PL080_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PL080_F, 
levels=c(1, 
-1, 
-5), 
labels=c("Filled", 
"Missing", 
"Missing value because the definition of this variable is not used (PL088 and PL089 only)")) 


PL085_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PL085_F, 
levels=c(1, 
-1, 
-5), 
labels=c("Filled", 
"Missing", 
"Missing value because the definition of this variable is not used (PL088 and PL089 only)")) 


PL086_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PL086_F, 
levels=c(1, 
-1, 
-5), 
labels=c("Filled", 
"Missing", 
"Missing value because the definition of this variable is not used (PL088 and PL089 only)")) 


PL087_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PL087_F, 
levels=c(1, 
-1, 
-5), 
labels=c("Filled", 
"Missing", 
"Missing value because the definition of this variable is not used (PL088 and PL089 only)")) 


PL088_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PL088_F, 
levels=c(1, 
-1, 
-5), 
labels=c("Filled", 
"Missing", 
"Missing value because the definition of this variable is not used (PL088 and PL089 only)")) 


PL089_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PL089_F, 
levels=c(1, 
-1, 
-5), 
labels=c("Filled", 
"Missing", 
"Missing value because the definition of this variable is not used (PL088 and PL089 only)")) 


PL090_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PL090_F, 
levels=c(1, 
-1, 
-5), 
labels=c("Filled", 
"Missing", 
"Missing value because the definition of this variable is not used (PL088 and PL089 only)")) 


PL100_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PL100_F, 
levels=c(1, 
-1, 
-2), 
labels=c("Filled", 
"Missing", 
"Not applicable (person does not have a second job or PL031 not equal to 1, 2, 3 or 4)")) 


PL111_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PL111, 
levels=c("a", 
"f", 
"g", 
"h", 
"i", 
"j", 
"k", 
"o", 
"p", 
"q", 
"b - e", 
"l - n", 
"r - u"), 
labels=c("Agriculture, forestry and fishing", 
"Construction", 
"Wholesale retail", 
"Transportation and storage", 
"Accommodation and food service activities", 
"Information and communication", 
"Financial and insurance activities", 
"Public administration and defence, compulsory social security", 
"Education", 
"Human health and social work activities", 
"Mining and quarrying, Manufacturing, Electricity, gas, steam and air conditioning supply, Water supply", 
"Real estate activities, Professional, scientific and technical activities, Administrative and support service activities", 
"Arts, entertainment and recreation, Other service activities, Activities as household as employer..., Activities of extraterritorial organisations and bodies")) 


PL111_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PL111_F, 
levels=c(1, 
-1, 
-2, 
-3), 
labels=c("Filled", 
"Missing", 
"Not applicable (PL031 not equal to 1, 2, 3 or 4)", 
"Non-selected respondent")) 


PL120_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PL120, 
levels=c(1, 
2, 
3, 
4, 
5, 
6, 
7), 
labels=c("Undergoing education or training", 
"Personal illness or disability", 
"Wants to work more hours but cannot find a job(s) or work(s) of more hours", 
"Do not want to work more hours", 
"Number of hours in all job(s) are considered as a full-time job", 
"Housework, looking after children or other persons", 
"Other reasons")) 


PL120_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PL120_F, 
levels=c(1, 
-1, 
-2, 
-3), 
labels=c("Filled", 
"Missing", 
"Not applicable (Not (PL031 eq 1, 2 , 3 or 4, and PL060 + PL100 < 30))", 
"Non-selected respondent")) 


PL130_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PL130, 
levels=c(1, 
2, 
3, 
4, 
5, 
6, 
7, 
8, 
9, 
10, 
11, 
12, 
13, 
14, 
15), 
labels=c("1 person", 
"2 persons", 
"3 persons", 
"4 persons", 
"5 persons", 
"6 persons", 
"7 persons", 
"8 persons", 
"9 persons", 
"10 persons", 
"Between 11 and 19 persons", 
"Between 20 and 49 persons", 
"50 persons and more", 
"Do not know but less than 11 persons", 
"Do not know but more than 10 persons")) 


PL130_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PL130_F, 
levels=c(1, 
-1, 
-2, 
-3), 
labels=c("Filled", 
"Missing", 
"Not applicable (PL031 not equal to 1, 2, 3 or 4)", 
"Non-selected respondent")) 


PL140_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PL140, 
levels=c(1, 
2), 
labels=c("Permanent job/work contract of unlimited duration", 
"Temporary job/work contract of limited duration")) 


PL140_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PL140_F, 
levels=c(1, 
-1, 
-2, 
-3, 
-4), 
labels=c("Filled", 
"Missing", 
"Not applicable (PL040 not equal to 3)", 
"Non-selected respondent", 
"Not applicable because the person is employee (PL040 eq 3) but does not have a contract")) 


PL150_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PL150, 
levels=c(1, 
2), 
labels=c("Supervisory", 
"Non-supervisory")) 


PL150_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PL150_F, 
levels=c(1, 
-1, 
-2, 
-3), 
labels=c("Filled", 
"Missing", 
"Not applicable (PL040 not equal to 3)", 
"Non-selected respondent")) 


PL160_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PL160, 
levels=c(1, 
2), 
labels=c("Yes", 
"No")) 


PL160_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PL160_F, 
levels=c(1, 
-1, 
-2, 
-3), 
labels=c("Filled", 
"Missing", 
"Not applicable (PL031 not equal to 1, 2, 3 or 4)", 
"Non-selected respondent")) 


PL170_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PL170, 
levels=c(1, 
2, 
3, 
4, 
5, 
6, 
7), 
labels=c("To take up or seek better job", 
"End of temporary contract", 
"Obliged to stop by employer (business closure, redundancy, early retirement, dismissal etc.)", 
"Sale or closure of own/family business", 
"Childcare and care for other dependents", 
"Partner¿s job required us to move to another area or marriage", 
"Other reasons")) 

PL170_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PL170_F, 
levels=c(1, 
-1, 
-2, 
-3), 
labels=c("Filled", 
"Missing", 
"Not applicable (PL160 not equal to 1)", 
"Non-selected respondent")) 


PL180_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PL180, 
levels=c(1, 
2, 
3, 
4, 
5, 
6, 
7, 
8, 
9, 
10, 
11, 
12), 
labels=c("Employed - unemployed", 
"Employed - retired", 
"Employed - other inactive", 
"Unemployed - employed", 
"Unemployed - retired", 
"Unemployed - other inactive", 
"Retired - employed", 
"Retired - unemployed", 
"Retired - other inactive", 
"Other inactive - employed", 
"Other inactive - unemployed", 
"Other inactive - retired")) 


PL180_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PL180_F, 
levels=c(1, 
-1, 
-2, 
-3), 
labels=c("Filled", 
"Missing", 
"Not applicable (no change since last year)", 
"Non-selected respondent")) 


PL190_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PL190_F, 
levels=c(1, 
-1, 
-2, 
-3), 
labels=c("Filled", 
"Missing", 
"Not applicable (person never worked i.e. (PL031 not equal to 1, 2, 3 or 4 AND PL015 not equal to 1))", 
"Non-selected respondent")) 


PL200_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PL200_F, 
levels=c(1, 
-1, 
-2, 
-3), 
labels=c("Filled", 
"Missing", 
"Not applicable (person never worked i.e. (PL031 not equal to 1, 2, 3 or 4 AND PL015 not equal to 1))", 
"Non-selected respondent")) 


PL211A_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PL211A, 
levels=c(1, 
2, 
3, 
4, 
5, 
6, 
7, 
8, 
9, 
10, 
11), 
labels=c("Employee working full-time", 
"Employee working part-time", 
"Self-employed working full-time (including family worker)", 
"Self-employed working part-time (including family worker)", 
"Unemployed", 
"Pupil, student, further training, unpaid work experience", 
"In retirement or in early retirement or has given up business", 
"Permanently disabled or/and unfit to work", 
"In compulsory military or community service", 
"Fulfilling domestic tasks and care responsibilities", 
"Other inactive person")) 


PL211A_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PL211A_F, 
levels=c(1, 
-1, 
-3), 
labels=c("Filled", 
"Missing", 
"Non-selected respondent")) 


PL211B_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PL211B, 
levels=c(1, 
2, 
3, 
4, 
5, 
6, 
7, 
8, 
9, 
10, 
11), 
labels=c("Employee working full-time", 
"Employee working part-time", 
"Self-employed working full-time (including family worker)", 
"Self-employed working part-time (including family worker)", 
"Unemployed", 
"Pupil, student, further training, unpaid work experience", 
"In retirement or in early retirement or has given up business", 
"Permanently disabled or/and unfit to work", 
"In compulsory military or community service", 
"Fulfilling domestic tasks and care responsibilities", 
"Other inactive person")) 


PL211B_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PL211B_F, 
levels=c(1, 
-1, 
-3), 
labels=c("Filled", 
"Missing", 
"Non-selected respondent")) 


PL211C_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PL211C, 
levels=c(1, 
2, 
3, 
4, 
5, 
6, 
7, 
8, 
9, 
10, 
11), 
labels=c("Employee working full-time", 
"Employee working part-time", 
"Self-employed working full-time (including family worker)", 
"Self-employed working part-time (including family worker)", 
"Unemployed", 
"Pupil, student, further training, unpaid work experience", 
"In retirement or in early retirement or has given up business", 
"Permanently disabled or/and unfit to work", 
"In compulsory military or community service", 
"Fulfilling domestic tasks and care responsibilities", 
"Other inactive person")) 


PL211C_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PL211C_F, 
levels=c(1, 
-1, 
-3), 
labels=c("Filled", 
"Missing", 
"Non-selected respondent")) 


PL211D_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PL211D, 
levels=c(1, 
2, 
3, 
4, 
5, 
6, 
7, 
8, 
9, 
10, 
11), 
labels=c("Employee working full-time", 
"Employee working part-time", 
"Self-employed working full-time (including family worker)", 
"Self-employed working part-time (including family worker)", 
"Unemployed", 
"Pupil, student, further training, unpaid work experience", 
"In retirement or in early retirement or has given up business", 
"Permanently disabled or/and unfit to work", 
"In compulsory military or community service", 
"Fulfilling domestic tasks and care responsibilities", 
"Other inactive person")) 


PL211D_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PL211D_F, 
levels=c(1, 
-1, 
-3), 
labels=c("Filled", 
"Missing", 
"Non-selected respondent")) 


PL211E_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PL211E, 
levels=c(1, 
2, 
3, 
4, 
5, 
6, 
7, 
8, 
9, 
10, 
11), 
labels=c("Employee working full-time", 
"Employee working part-time", 
"Self-employed working full-time (including family worker)", 
"Self-employed working part-time (including family worker)", 
"Unemployed", 
"Pupil, student, further training, unpaid work experience", 
"In retirement or in early retirement or has given up business", 
"Permanently disabled or/and unfit to work", 
"In compulsory military or community service", 
"Fulfilling domestic tasks and care responsibilities", 
"Other inactive person")) 


PL211E_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PL211E_F, 
levels=c(1, 
-1, 
-3), 
labels=c("Filled", 
"Missing", 
"Non-selected respondent")) 


PL211F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PL211F, 
levels=c(1, 
2, 
3, 
4, 
5, 
6, 
7, 
8, 
9, 
10, 
11), 
labels=c("Employee working full-time", 
"Employee working part-time", 
"Self-employed working full-time (including family worker)", 
"Self-employed working part-time (including family worker)", 
"Unemployed", 
"Pupil, student, further training, unpaid work experience", 
"In retirement or in early retirement or has given up business", 
"Permanently disabled or/and unfit to work", 
"In compulsory military or community service", 
"Fulfilling domestic tasks and care responsibilities", 
"Other inactive person")) 


PL211F_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PL211F_F, 
levels=c(1, 
-1, 
-3), 
labels=c("Filled", 
"Missing", 
"Non-selected respondent")) 


PL211G_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PL211G, 
levels=c(1, 
2, 
3, 
4, 
5, 
6, 
7, 
8, 
9, 
10, 
11), 
labels=c("Employee working full-time", 
"Employee working part-time", 
"Self-employed working full-time (including family worker)", 
"Self-employed working part-time (including family worker)", 
"Unemployed", 
"Pupil, student, further training, unpaid work experience", 
"In retirement or in early retirement or has given up business", 
"Permanently disabled or/and unfit to work", 
"In compulsory military or community service", 
"Fulfilling domestic tasks and care responsibilities", 
"Other inactive person")) 


PL211G_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PL211G_F, 
levels=c(1, 
-1, 
-3), 
labels=c("Filled", 
"Missing", 
"Non-selected respondent")) 


PL211H_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PL211H, 
levels=c(1, 
2, 
3, 
4, 
5, 
6, 
7, 
8, 
9, 
10, 
11), 
labels=c("Employee working full-time", 
"Employee working part-time", 
"Self-employed working full-time (including family worker)", 
"Self-employed working part-time (including family worker)", 
"Unemployed", 
"Pupil, student, further training, unpaid work experience", 
"In retirement or in early retirement or has given up business", 
"Permanently disabled or/and unfit to work", 
"In compulsory military or community service", 
"Fulfilling domestic tasks and care responsibilities", 
"Other inactive person")) 


PL211H_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PL211H_F, 
levels=c(1, 
-1, 
-3), 
labels=c("Filled", 
"Missing", 
"Non-selected respondent")) 


PL211I_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PL211I, 
levels=c(1, 
2, 
3, 
4, 
5, 
6, 
7, 
8, 
9, 
10, 
11), 
labels=c("Employee working full-time", 
"Employee working part-time", 
"Self-employed working full-time (including family worker)", 
"Self-employed working part-time (including family worker)", 
"Unemployed", 
"Pupil, student, further training, unpaid work experience", 
"In retirement or in early retirement or has given up business", 
"Permanently disabled or/and unfit to work", 
"In compulsory military or community service", 
"Fulfilling domestic tasks and care responsibilities", 
"Other inactive person")) 


PL211I_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PL211I_F, 
levels=c(1, 
-1, 
-3), 
labels=c("Filled", 
"Missing", 
"Non-selected respondent")) 


PL211J_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PL211J, 
levels=c(1, 
2, 
3, 
4, 
5, 
6, 
7, 
8, 
9, 
10, 
11), 
labels=c("Employee working full-time", 
"Employee working part-time", 
"Self-employed working full-time (including family worker)", 
"Self-employed working part-time (including family worker)", 
"Unemployed", 
"Pupil, student, further training, unpaid work experience", 
"In retirement or in early retirement or has given up business", 
"Permanently disabled or/and unfit to work", 
"In compulsory military or community service", 
"Fulfilling domestic tasks and care responsibilities", 
"Other inactive person")) 


PL211J_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PL211J_F, 
levels=c(1, 
-1, 
-3), 
labels=c("Filled", 
"Missing", 
"Non-selected respondent")) 


PL211K_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PL211K, 
levels=c(1, 
2, 
3, 
4, 
5, 
6, 
7, 
8, 
9, 
10, 
11), 
labels=c("Employee working full-time", 
"Employee working part-time", 
"Self-employed working full-time (including family worker)", 
"Self-employed working part-time (including family worker)", 
"Unemployed", 
"Pupil, student, further training, unpaid work experience", 
"In retirement or in early retirement or has given up business", 
"Permanently disabled or/and unfit to work", 
"In compulsory military or community service", 
"Fulfilling domestic tasks and care responsibilities", 
"Other inactive person")) 


PL211K_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PL211K_F, 
levels=c(1, 
-1, 
-3), 
labels=c("Filled", 
"Missing", 
"Non-selected respondent")) 


PL211L_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PL211L, 
levels=c(1, 
2, 
3, 
4, 
5, 
6, 
7, 
8, 
9, 
10, 
11), 
labels=c("Employee working full-time", 
"Employee working part-time", 
"Self-employed working full-time (including family worker)", 
"Self-employed working part-time (including family worker)", 
"Unemployed", 
"Pupil, student, further training, unpaid work experience", 
"In retirement or in early retirement or has given up business", 
"Permanently disabled or/and unfit to work", 
"In compulsory military or community service", 
"Fulfilling domestic tasks and care responsibilities", 
"Other inactive person")) 


PL211L_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PL211L_F, 
levels=c(1, 
-1, 
-3), 
labels=c("Filled", 
"Missing", 
"Non-selected respondent")) 


PY030G_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PY030G_F, 
levels=c(0, 
1, 
-1), 
labels=c("No income", 
"Income (variable is filled)", 
"Missing")) 


PY031G_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PY031G_F, 
levels=c(0, 
1, 
-1), 
labels=c("No income", 
"Income (variable is filled)", 
"Missing")) 


PY091G_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PY091G_F, 
levels=c(0, 
1, 
2, 
-1, 
-2, 
-7), 
labels=c("No income", 
"Filled with only Contributory and means-tested components", 
"Filled with mixed components", 
"Missing", 
"Not applicable (This scheme doesn't exist at national level)", 
"Not applicable (PB010 ne last year)")) 


PY092G_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PY092G_F, 
levels=c(0, 
1, 
2, 
-1, 
-2, 
-7), 
labels=c("No income", 
"Filled with only Contributory and non means-tested components", 
"Filled with mixed components", 
"Missing", 
"Not applicable (This scheme doesn't exist at national level)", 
"Not applicable (PB010 ne last year)")) 


PY093G_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PY093G_F, 
levels=c(0, 
1, 
2, 
-1, 
-2, 
-7), 
labels=c("No income", 
"Filled with only Non-contributory and means-tested components", 
"Filled with mixed components", 
"Missing", 
"Not applicable (This scheme doesn't exist at national level)", 
"Not applicable (PB010 ne last year)")) 


PY094G_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PY094G_F, 
levels=c(0, 
1, 
2, 
-1, 
-2, 
-7), 
labels=c("No income", 
"Filled with only Non-contributory and non means-tested components", 
"Filled with mixed components", 
"Missing", 
"Not applicable (This scheme doesn't exist at national level)", 
"Not applicable (PB010 ne last year)")) 


PY101G_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PY101G_F, 
levels=c(0, 
1, 
2, 
-1, 
-2, 
-7), 
labels=c("No income", 
"Filled with only Contributory and means-tested components", 
"Filled with mixed components", 
"Missing", 
"Not applicable (This scheme doesn't exist at national level)", 
"Not applicable (PB010 ne last year)")) 


PY102G_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PY102G_F, 
levels=c(0, 
1, 
2, 
-1, 
-2, 
-7), 
labels=c("No income", 
"Filled with only Contributory and non means-tested components", 
"Filled with mixed components", 
"Missing", 
"Not applicable (This scheme doesn't exist at national level)", 
"Not applicable (PB010 ne last year)")) 


PY103G_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PY103G_F, 
levels=c(0, 
1, 
2, 
-1, 
-2, 
-7), 
labels=c("No income", 
"Filled with only Non-contributory and means-tested components", 
"Filled with mixed components", 
"Missing", 
"Not applicable (This scheme doesn't exist at national level)", 
"Not applicable (PB010 ne last year)")) 


PY104G_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PY104G_F, 
levels=c(0, 
1, 
2, 
-1, 
-2, 
-7), 
labels=c("No income", 
"Filled with only Non-contributory and non means-tested components", 
"Filled with mixed components", 
"Missing", 
"Not applicable (This scheme doesn't exist at national level)", 
"Not applicable (PB010 ne last year)")) 


PY111G_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PY111G_F, 
levels=c(0, 
1, 
2, 
-1, 
-2, 
-7), 
labels=c("No income", 
"Filled with only Contributory and means-tested components", 
"Filled with mixed components", 
"Missing", 
"Not applicable (This scheme doesn't exist at national level)", 
"Not applicable (PB010 ne last year)")) 


PY112G_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PY112G_F, 
levels=c(0, 
1, 
2, 
-1, 
-2, 
-7), 
labels=c("No income", 
"Filled with only Contributory and non means-tested components", 
"Filled with mixed components", 
"Missing", 
"Not applicable (This scheme doesn't exist at national level)", 
"Not applicable (PB010 ne last year)")) 


PY113G_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PY113G_F, 
levels=c(0, 
1, 
2, 
-1, 
-2, 
-7), 
labels=c("No income", 
"Filled with only Non-contributory and means-tested components", 
"Filled with mixed components", 
"Missing", 
"Not applicable (This scheme doesn't exist at national level)", 
"Not applicable (PB010 ne last year)")) 


PY114G_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PY114G_F, 
levels=c(0, 
1, 
2, 
-1, 
-2, 
-7), 
labels=c("No income", 
"Filled with only Non-contributory and non means-tested components", 
"Filled with mixed components", 
"Missing", 
"Not applicable (This scheme doesn't exist at national level)", 
"Not applicable (PB010 ne last year)")) 


PY121G_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PY121G_F, 
levels=c(0, 
1, 
2, 
-1, 
-2, 
-7), 
labels=c("No income", 
"Filled with only Contributory and means-tested components", 
"Filled with mixed components", 
"Missing", 
"Not applicable (This scheme doesn't exist at national level)", 
"Not applicable (PB010 ne last year)")) 


PY122G_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PY122G_F, 
levels=c(0, 
1, 
2, 
-1, 
-2, 
-7), 
labels=c("No income", 
"Filled with only Contributory and non means-tested components", 
"Filled with mixed components", 
"Missing", 
"Not applicable (This scheme doesn't exist at national level)", 
"Not applicable (PB010 ne last year)")) 


PY123G_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PY123G_F, 
levels=c(0, 
1, 
2, 
-1, 
-2, 
-7), 
labels=c("No income", 
"Filled with only Non-contributory and means-tested components", 
"Filled with mixed components", 
"Missing", 
"Not applicable (This scheme doesn't exist at national level)", 
"Not applicable (PB010 ne last year)")) 


PY124G_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PY124G_F, 
levels=c(0, 
1, 
2, 
-1, 
-2, 
-7), 
labels=c("No income", 
"Filled with only Non-contributory and non means-tested components", 
"Filled with mixed components", 
"Missing", 
"Not applicable (This scheme doesn't exist at national level)", 
"Not applicable (PB010 ne last year)")) 


PY131G_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PY131G_F, 
levels=c(0, 
1, 
2, 
-1, 
-2, 
-7), 
labels=c("No income", 
"Filled with only Contributory and means-tested components", 
"Filled with mixed components", 
"Missing", 
"Not applicable (This scheme doesn't exist at national level)", 
"Not applicable (PB010 ne last year)")) 


PY132G_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PY132G_F, 
levels=c(0, 
1, 
2, 
-1, 
-2, 
-7), 
labels=c("No income", 
"Filled with only Contributory and non means-tested components", 
"Filled with mixed components", 
"Missing", 
"Not applicable (This scheme doesn't exist at national level)", 
"Not applicable (PB010 ne last year)")) 


PY133G_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PY133G_F, 
levels=c(0, 
1, 
2, 
-1, 
-2, 
-7), 
labels=c("No income", 
"Filled with only Non-contributory and means-tested components", 
"Filled with mixed components", 
"Missing", 
"Not applicable (This scheme doesn't exist at national level)", 
"Not applicable (PB010 ne last year)")) 


PY134G_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PY134G_F, 
levels=c(0, 
1, 
2, 
-1, 
-2, 
-7), 
labels=c("No income", 
"Filled with only Non-contributory and non means-tested components", 
"Filled with mixed components", 
"Missing", 
"Not applicable (This scheme doesn't exist at national level)", 
"Not applicable (PB010 ne last year)")) 


PY141G_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PY141G_F, 
levels=c(0, 
1, 
2, 
-1, 
-2, 
-7), 
labels=c("No income", 
"Filled with only Contributory and means-tested components", 
"Filled with mixed components", 
"Missing", 
"Not applicable (This scheme doesn't exist at national level)", 
"Not applicable (PB010 ne last year)")) 


PY142G_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PY142G_F, 
levels=c(0, 
1, 
2, 
-1, 
-2, 
-7), 
labels=c("No income", 
"Filled with only Contributory and non means-tested components", 
"Filled with mixed components", 
"Missing", 
"Not applicable (This scheme doesn't exist at national level)", 
"Not applicable (PB010 ne last year)")) 


PY143G_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PY143G_F, 
levels=c(0, 
1, 
2, 
-1, 
-2, 
-7), 
labels=c("No income", 
"Filled with only Non-contributory and means-tested components", 
"Filled with mixed components", 
"Missing", 
"Not applicable (This scheme doesn't exist at national level)", 
"Not applicable (PB010 ne last year)")) 


PY144G_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PY144G_F, 
levels=c(0, 
1, 
2, 
-1, 
-2, 
-7), 
labels=c("No income", 
"Filled with only Non-contributory and non means-tested components", 
"Filled with mixed components", 
"Missing", 
"Not applicable (This scheme doesn't exist at national level)", 
"Not applicable (PB010 ne last year)")) 


PD020_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PD020, 
levels=c(1, 
2, 
3), 
labels=c("Yes", 
"No - cannot afford it", 
"No - other reason")) 


PD020_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PD020_F, 
levels=c(1, 
-1, 
-3), 
labels=c("Filled", 
"Missing", 
"Not selected respondent")) 


PD030_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PD030, 
levels=c(1, 
2, 
3), 
labels=c("Yes", 
"No - cannot afford it", 
"No - other reason")) 


PD030_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PD030_F, 
levels=c(1, 
-1, 
-3), 
labels=c("Filled", 
"Missing", 
"Not selected respondent")) 


PD050_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PD050, 
levels=c(1, 
2, 
3), 
labels=c("Yes", 
"No - cannot afford it", 
"No - other reason")) 


PD050_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PD050_F, 
levels=c(1, 
-1, 
-3), 
labels=c("Filled", 
"Missing", 
"Not selected respondent")) 


PD060_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PD060, 
levels=c(1, 
2, 
3), 
labels=c("Yes", 
"No - cannot afford it", 
"No - other reason")) 


PD060_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PD060_F, 
levels=c(1, 
-1, 
-3), 
labels=c("Filled", 
"Missing", 
"Not selected respondent")) 


PD070_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PD070, 
levels=c(1, 
2, 
3), 
labels=c("Yes", 
"No - cannot afford it", 
"No - other reason")) 


PD070_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PD070_F, 
levels=c(1, 
-1, 
-3), 
labels=c("Filled", 
"Missing", 
"Not selected respondent")) 


PD080_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PD080, 
levels=c(1, 
2, 
3), 
labels=c("Yes", 
"No - cannot afford it", 
"No - other reason")) 


PD080_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PD080_F, 
levels=c(1, 
-1, 
-3), 
labels=c("Filled", 
"Missing", 
"Not selected respondent")) 


PW005T_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PW005T_F, 
levels=c(1, 
-1, 
-2, 
-3, 
-7, 
-8), 
labels=c("Filled", 
"Missing", 
"Not applicable (proxy interview)", 
"Non-selected respondent", 
"Not applicable (PB010 ne 2018)", 
"Not applicable (variable not constructed)")) 


PW010T_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PW010T, 
levels=c(0, 
1, 
2, 
3, 
4, 
5, 
6, 
7, 
8, 
9, 
10, 
99), 
labels=c("0 (Not at all satisfied)", 
"1", 
"2", 
"3", 
"4", 
"5", 
"6", 
"7", 
"8", 
"9", 
"10 (Completely satisfied)", 
"Do not know")) 


PW010T_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PW010T_F, 
levels=c(1, 
-1, 
-2, 
-3, 
-7), 
labels=c("Filled", 
"Missing", 
"Not applicable (proxy interview)", 
"Non-selected respondent", 
"Not applicable (PB010 ne 2018)")) 


PW240T_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PW240T, 
levels=c(0, 
1, 
2, 
3, 
4, 
5, 
6, 
7, 
8, 
9, 
10, 
99), 
labels=c("0 (Not at all satisfied)", 
"1", 
"2", 
"3", 
"4", 
"5", 
"6", 
"7", 
"8", 
"9", 
"10 (Completely satisfied)", 
"Do not know")) 


PW240T_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PW240T_F, 
levels=c(1, 
-1, 
-2, 
-3, 
-7), 
labels=c("Filled", 
"Missing", 
"Not applicable (proxy interview)", 
"Non-selected respondent", 
"Not applicable (PB010 ne 2018)")) 


PW040T_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PW040T, 
levels=c(1, 
2), 
labels=c("Yes", 
"No")) 


PW040T_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PW040T_F, 
levels=c(1, 
-1, 
-2, 
-3, 
-7), 
labels=c("Filled", 
"Missing", 
"Not applicable (proxy interview)", 
"Non-selected respondent", 
"Not applicable (PB010 ne 2018)")) 


PW110T_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PW110T, 
levels=c(1, 
2), 
labels=c("Yes", 
"No")) 


PW110T_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PW110T_F, 
levels=c(1, 
-1, 
-2, 
-3, 
-7), 
labels=c("Filled", 
"Missing", 
"Not applicable (proxy interview)", 
"Non-selected respondent", 
"Not applicable (PB010 ne 2018)")) 


PW030T_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PW030T, 
levels=c(0, 
1, 
2, 
3, 
4, 
5, 
6, 
7, 
8, 
9, 
10, 
99), 
labels=c("0 (Not at all satisfied)", 
"1", 
"2", 
"3", 
"4", 
"5", 
"6", 
"7", 
"8", 
"9", 
"10 (Completely satisfied)", 
"Do not know")) 


PW030T_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PW030T_F, 
levels=c(1, 
-1, 
-2, 
-3, 
-7), 
labels=c("Filled", 
"Missing", 
"Not applicable (proxy interview)", 
"Non-selected respondent", 
"Not applicable (PB010 ne 2018)")) 


PW160T_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PW160T, 
levels=c(0, 
1, 
2, 
3, 
4, 
5, 
6, 
7, 
8, 
9, 
10, 
99), 
labels=c("0 (Not at all satisfied)", 
"1", 
"2", 
"3", 
"4", 
"5", 
"6", 
"7", 
"8", 
"9", 
"10 (Completely satisfied)", 
"Do not know")) 


PW160T_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PW160T_F, 
levels=c(1, 
-1, 
-2, 
-3, 
-7), 
labels=c("Filled", 
"Missing", 
"Not applicable (proxy interview)", 
"Non-selected respondent", 
"Not applicable (PB010 ne 2018)")) 


PW120T_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PW120T, 
levels=c(0, 
1, 
2, 
3, 
4, 
5, 
6, 
7, 
8, 
9, 
10, 
99), 
labels=c("0 (Not at all satisfied)", 
"1", 
"2", 
"3", 
"4", 
"5", 
"6", 
"7", 
"8", 
"9", 
"10 (Completely satisfied)", 
"Do not know")) 


PW120T_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PW120T_F, 
levels=c(1, 
-1, 
-2, 
-3, 
-7), 
labels=c("Filled", 
"Missing", 
"Not applicable (proxy interview)", 
"Non-selected respondent", 
"Not applicable (PB010 ne 2018)")) 


PW100T_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PW100T, 
levels=c(0, 
1, 
2, 
3, 
4, 
5, 
6, 
7, 
8, 
9, 
10, 
99), 
labels=c("0 (Not at all satisfied)", 
"1", 
"2", 
"3", 
"4", 
"5", 
"6", 
"7", 
"8", 
"9", 
"10 (Completely satisfied)", 
"Do not know")) 


PW100T_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PW100T_F, 
levels=c(1, 
-1, 
-2, 
-3, 
-7), 
labels=c("Filled", 
"Missing", 
"Not applicable ((proxy interview) OR (PL031 ne 1,2,3,4))", 
"Non-selected respondent", 
"Not applicable (PB010 ne 2018)")) 


PW190T_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PW190T, 
levels=c(0, 
1, 
2, 
3, 
4, 
5, 
6, 
7, 
8, 
9, 
10, 
99), 
labels=c("0 (Not at all satisfied)", 
"1", 
"2", 
"3", 
"4", 
"5", 
"6", 
"7", 
"8", 
"9", 
"10 (Completely satisfied)", 
"Do not know")) 


PW190T_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PW190T_F, 
levels=c(1, 
-1, 
-2, 
-3, 
-7), 
labels=c("Filled", 
"Missing", 
"Not applicable (proxy interview)", 
"Non-selected respondent", 
"Not applicable (PB010 ne 2018)")) 


PW230T_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PW230T, 
levels=c(1, 
2, 
3, 
4, 
5, 
99), 
labels=c("All of the time", 
"Most of the time", 
"Some of the time", 
"A little of the time", 
"None of the time", 
"Do not know")) 


PW230T_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PW230T_F, 
levels=c(1, 
-1, 
-2, 
-3, 
-7), 
labels=c("Filled", 
"Missing", 
"Not applicable (proxy interview)", 
"Non-selected respondent", 
"Not applicable (PB010 ne 2018)")) 


PW050T_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PW050T, 
levels=c(1, 
2, 
3, 
4, 
5, 
99), 
labels=c("All of the time", 
"Most of the time", 
"Some of the time", 
"A little of the time", 
"None of the time", 
"Do not know")) 


PW050T_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PW050T_F, 
levels=c(1, 
-1, 
-2, 
-3, 
-7), 
labels=c("Filled", 
"Missing", 
"Not applicable (proxy interview)", 
"Non-selected respondent", 
"Not applicable (PB010 ne 2018)")) 


PW060T_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PW060T, 
levels=c(1, 
2, 
3, 
4, 
5, 
99), 
labels=c("All of the time", 
"Most of the time", 
"Some of the time", 
"A little of the time", 
"None of the time", 
"Do not know")) 


PW060T_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PW060T_F, 
levels=c(1, 
-1, 
-2, 
-3, 
-7), 
labels=c("Filled", 
"Missing", 
"Not applicable (proxy interview)", 
"Non-selected respondent", 
"Not applicable (PB010 ne 2018)")) 


PW070T_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PW070T, 
levels=c(1, 
2, 
3, 
4, 
5, 
99), 
labels=c("All of the time", 
"Most of the time", 
"Some of the time", 
"A little of the time", 
"None of the time", 
"Do not know")) 


PW070T_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PW070T_F, 
levels=c(1, 
-1, 
-2, 
-3, 
-7), 
labels=c("Filled", 
"Missing", 
"Not applicable (proxy interview)", 
"Non-selected respondent", 
"Not applicable (PB010 ne 2018)")) 


PW080T_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PW080T, 
levels=c(1, 
2, 
3, 
4, 
5, 
99), 
labels=c("All of the time", 
"Most of the time", 
"Some of the time", 
"A little of the time", 
"None of the time", 
"Do not know")) 


PW080T_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PW080T_F, 
levels=c(1, 
-1, 
-2, 
-3, 
-7), 
labels=c("Filled", 
"Missing", 
"Not applicable (proxy interview)", 
"Non-selected respondent", 
"Not applicable (PB010 ne 2018)")) 


PW090T_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PW090T, 
levels=c(1, 
2, 
3, 
4, 
5, 
99), 
labels=c("All of the time", 
"Most of the time", 
"Some of the time", 
"A little of the time", 
"None of the time", 
"Do not know")) 


PW090T_F_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PW090T_F, 
levels=c(1, 
-1, 
-2, 
-3, 
-7), 
labels=c("Filled", 
"Missing", 
"Not applicable (proxy interview)", 
"Non-selected respondent", 
"Not applicable (PB010 ne 2018)")) 


PX040_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PX040, 
levels=c(1, 
2, 
3, 
4), 
labels=c("Current household member aged 16 and over", 
"Selected respondent", 
"Non-selected respondent", 
"Ineligible person")) 


PX050_Fact <- factor(DF_EUSILC_Cross_A2018_PERSONAL_$PX050, 
levels=c(2, 
3, 
4, 
5, 
6, 
7, 
8), 
labels=c("Employees (SAL)", 
"Employed persons except employees (NSAL)", 
"Other employed (when time of SAL and NSAL is > ¿ of total time calendar)", 
"Unemployed", 
"Retired", 
"Inactive", 
"Other inactive (when time of unemployed, retirement and inactivity is > ¿ of total time calendar)"))
save.image (file="DF_EUSILC_Cross_A2018_PERSONAL_.RData")
