/* #Declinazione di responsabilità. 
#I file rilasciati in formato testo sono provvisti anche dei programmi di importazione per STATA, SAS e R. 
#L'Istat non garantisce che le funzioni contenute nei suddetti programmi siano esenti da errore e non si assume alcuna responsabilità sull’output ottenuto dal loro utilizzo.     
/*  I valori delle label nelle variabili categoriche sono commentati a causa della presenza di codici non esclusivamente numerici. Comunque sono completamente documentati.  */
clear all
infile  using  PGM_2018_PERSONAL_DATA_(P-FILE)_Cross-Sectional_EN_DELIMITED.dct, clear
/*
label define  pb020_cl1 AT   "¿sterreich BE   "Belgique/Belg¿e BG   "Bulgaria" CH   "Switzerland" CY   "Cyprus" CZ   "Czech republic" DE   "Deutschland" DK   "Denmark" EE   "Estonia" EL   "Ell¿da ES   "Espa¿a FI   "Suomi" FR   "France" HR   "Croatia" HU   "Hungary" IE   "Ireland" IS   "Iceland" IT   "Italia" LT   "Lithuania" LU   "Luxembourg" LV   "Latvia" ME   "Montenegro" MK   "The Former Yugoslav Republic of Macedonia (FYROM)" MT   "Malta" NL   "Nederland" NO   "Norway" PL   "Poland" PT   "Portugal" RO   "Romania" RS   "Serbia" SE   "Sverige" SI   "Slovenia" SK   "Slovak republic" TR   "Turkey" UK   "United Kingdom"  
label define  pb040_f_cl4 1   "Filled" -7   "Not applicable: PB010 ne last year"  
label define  pb060_f_cl6 1   "Filled" -2   "Not applicable (country does not use the selected respondent model)" -3   "Non-selected respondent" -7   "Not applicable: PB010 ne last year"  
label define  pb100_cl7 1   "January-March" 2   "April-June" 3   "July-September" 4   "October-December"  
label define  pb100_f_cl8 1   "Filled" -1   "Missing"  
label define  pb110_f_cl10 1   "Filled" -1   "Missing"  
label define  pb120_f_cl12 1   "Filled" -1   "Missing" -2   "Not applicable (information only extracted from registers)"  
label define  pb130_cl13 1   "January-March" 2   "April-June" 3   "July-September" 4   "October-December"  
label define  pb130_f_cl14 1   "Filled" -1   "Missing"  
label define  pb140_f_cl16 1   "Filled" -1   "Missing"  
label define  pb150_cl17 1   "Male" 2   "Female"  
label define  pb150_f_cl18 1   "Filled" -1   "Missing"  
label define  pb160_f_cl20 1   "Filled" -1   "Missing" -2   "Not applicable (father is not a household member)"  
label define  pb170_f_cl22 1   "Filled" -1   "Missing" -2   "Not applicable (mother is not a household member)"  
label define  pb180_f_cl24 1   "Filled" -1   "Missing" -2   "Not applicable (person has no spouse/partner or spouse/partner is not a household member)"  
label define  pb190_cl25 1   "Never married" 2   "Married" 3   "Separated" 4   "Widowed" 5   "Divorced"  
label define  pb190_f_cl26 1   "Filled" -1   "Missing"  
label define  pb200_cl27 1   "Yes, on a legal basis" 2   "Yes, without a legal basis" 3   "No"  
label define  pb200_f_cl28 1   "Filled" -1   "Missing"  
label define  pb210_cl29 EU   "European Countries" LOC   "Italy" OTH   "Other"  
label define  pb210_f_cl30 1   "Filled" -1   "Missing"  
label define  pb220a_cl31 EU   "European Countries" LOC   "Italy" OTH   "Other"  
label define  pb220a_f_cl32 1   "Filled" -1   "Missing"  
label define  pe010_cl33 1   "In education" 2   "Not in education"  
label define  pe010_f_cl34 1   "Filled" -1   "Missing"  
label define  pe020_cl35 00   "Early childhood education" 10   "Primary education" 20   "Lower secondary education" 30   "Upper secondary education (not further specified)" 40   "Post-secondary non tertiary education (not further specified)" 50   "Tertiary education"  
label define  pe020_f_cl36 1   "Filled" -1   "Missing" -2   "Not applicable (PE010 not equal to 1)"  
label define  pe030_f_cl38 1   "Filled" -1   "Missing" -2   "Not applicable (PE040 eq 000)"  
label define  pe040_cl39 000   "Less than primary education" 100   "Primary education" 200   "Lower secondary education" 300   "Upper secondary education (not further specified)" 400   "Post-secondary non-tertiary education (not further specified)" 500   "Tertiary education"  
label define  pe040_f_cl40 1   "Filled" -1   "Missing"  
label define  ph010_cl41 1   "Very good" 2   "Good" 3   "Fair" 4   "Bad" 5   "Very bad"  
label define  ph010_f_cl42 1   "Filled" -1   "Missing" -3   "Non-selected respondent"  
label define  ph020_cl43 1   "Yes" 2   "No"  
label define  ph020_f_cl44 1   "Filled" -1   "Missing" -3   "Non-selected respondent"  
label define  ph030_cl45 1   "Yes, strongly limited" 2   "Yes, limited" 3   "No, not limited"  
label define  ph030_f_cl46 1   "Filled" -1   "Missing" -3   "Non-selected respondent"  
label define  ph040_cl47 1   "Yes, there was at least one occasion when the person really needed examination or treatment but did not receive it" 2   "No, there was no occasion when the person really needed examination or treatment but did not receive it"  
label define  ph040_f_cl48 1   "Filled" -1   "Missing" -2   "Not applicable: the person did not really need any medical examination or treatment" -3   "Non-selected respondent"  
label define  ph050_cl49 1   "Could not afford to (too expensive)" 2   "Waiting list" 3   "Could not take time because of work, care for children or for others" 4   "Too far to travel/no means of transportation" 5   "Fear of doctor/hospitals/examination/ treatment" 6   "Wanted to wait and see if problem got better on its own" 7   "Didn¿t know any good doctor or specialist 8   "Other reasons"  
label define  ph050_f_cl50 1   "Filled" -1   "Missing" -2   "Not applicable (PH040 not equal to 1)" -3   "Non-selected respondent"  
label define  ph060_cl51 1   "Yes, there was at least one occasion when the person really needed dental examination or treatment but did not receive it" 2   "No, there was no occasion when the person really needed dental examination or treatment but did not receive it"  
label define  ph060_f_cl52 1   "Filled" -1   "Missing" -2   "Not applicable: the person did not really need any dental examination or treatment" -3   "Non-selected respondent"  
label define  ph070_cl53 1   "Could not afford to (too expensive)" 2   "Waiting list" 3   "Could not take time because of work, care for children or for others" 4   "Too far to travel/no means of transportation" 5   "Fear of doctor(dentist)/hospitals/examination/ treatment" 6   "Wanted to wait and see if problem got better on its own" 7   "Didn¿t know any good dentist 8   "Other reasons"  
label define  ph070_f_cl54 1   "Filled" -1   "Missing" -2   "Not applicable (PH060 not equal to 1)" -3   "Non-selected respondent"  
label define  pl015_cl55 1   "Yes" 2   "No"  
label define  pl015_f_cl56 1   "Filled" -1   "Missing" -2   "Not applicable (PL031 eq 1, 2, 3 or 4)"  
label define  pl020_cl57 1   "Yes" 2   "No"  
label define  pl020_f_cl58 1   "Filled" -1   "Missing" -2   "Not applicable (PL031 eq 1, 2, 3 or 4 or older than the standard retirement age)"  
label define  pl025_cl59 1   "Yes" 2   "No"  
label define  pl025_f_cl60 1   "filled" -1   "Missing" -2   "Not applicable (PL020 not equal to 1)"  
label define  pl031_cl61 1   "Employee working full-time" 2   "Employee working part-time" 3   "Self-employed working full-time (including family worker)" 4   "Self-employed working part-time (including family worker)" 5   "Unemployed" 6   "Pupil, student, further training, unpaid work experience" 7   "In retirement or in early retirement or has given up business" 8   "Permanently disabled or/and unfit to work" 9   "In compulsory military or community service" 10   "Fulfilling domestic tasks and care responsibilities" 11   "Other inactive person"  
label define  pl031_f_cl62 1   "Filled" -1   "Missing"  
label define  pl035_cl63 1   "Yes" 2   "No"  
label define  pl035_f_cl64 1   "Filled" -1   "Missing" -2   "Not applicable (person is not employee or MS has other source to calculate the gender pay gap)" -3   "Non-selected respondent"  
label define  pl040_cl65 1   "Self-employed with employees" 2   "Self-employed without employees" 3   "Employee" 4   "Family worker"  
label define  pl040_f_cl66 1   "Filled" -1   "Missing" -2   "Not applicable (PL015 not equal to 1 and PL031 not equal to 1,2,3 or 4)"  
label define  pl051_cl67 1   "Commissioned Armed Forces Officers" 2   "Non-commissioned Armed Forces Officers" 3   "Armed Forces Occupations, Other Ranks" 11   "Chief Executives, Senior Officials and Legislators" 12   "Administrative and Commercial Managers" 13   "Production and Specialized Services Managers" 14   "Hospitality, Retail and Other Services Managers" 21   "Science and Engineering Professionals" 22   "Health Professionals" 23   "Teaching Professionals" 24   "Business and Administration Professionals" 25   "Information and Communications Technology Professionals" 26   "Legal, Social and Cultural Professionals" 31   "Science and Engineering Associate Professionals" 32   "Health Associate Professionals" 33   "Business and Administration Associate Professionals" 34   "Legal, Social, Cultural and Related Associate Professionals" 35   "Information and Communications Technicians" 41   "General and Keyboard Clerks" 42   "Customer Services Clerks" 43   "Numerical and Material Recording Clerks" 44   "Other Clerical Support Workers" 51   "Personal Services Workers" 52   "Sales Workers" 53   "Personal Care Workers" 54   "Protective Services Workers" 61   "Market-oriented Skilled Agricultural Workers" 62   "Market-oriented Skilled Forestry, Fishery and Hunting Workers" 63   "Subsistence Farmers, Fishers, Hunters and Gatherers" 71   "Building and Related Trades Workers (excluding Electricians)" 72   "Metal, Machinery and Related Trades Workers" 73   "Handicraft and Printing Workers" 74   "Electrical and Electronic Trades Workers" 75   "Food Processing, Woodworking, Garment and Other Craft and Related Trades Workers" 81   "Stationary Plant and Machine Operators" 82   "Assemblers" 83   "Drivers and Mobile Plant Operators" 91   "Cleaners and Helpers" 92   "Agricultural, Forestry and Fishery Labourers" 93   "Labourers in Mining, Construction, Manufacturing and Transport" 94   "Food Preparation Assistants" 95   "Street and Related Sales and Services Workers" 96   "Refuse Workers and Other Elementary Workers"  
label define  pl051_f_cl68 1   "Filled" -1   "Missing" -2   "Not applicable (PL031 not eq 1, 2, 3 or 4 and PL015 not eq 1)"  
label define  pl060_f_cl70 1   "Filled" -1   "Missing" -2   "Not applicable (PL031 not eq 1, 2, 3 or 4)" -6   "Hours varying (when an average for over four weeks is not possible)"  
label define  pl073_f_cl72 1   "Filled" -1   "Missing" -5   "Missing value because the definition of this variable is not used (PL088 and PL089 only)"  
label define  pl074_f_cl74 1   "Filled" -1   "Missing" -5   "Missing value because the definition of this variable is not used (PL088 and PL089 only)"  
label define  pl075_f_cl76 1   "Filled" -1   "Missing" -5   "Missing value because the definition of this variable is not used (PL088 and PL089 only)"  
label define  pl076_f_cl78 1   "Filled" -1   "Missing" -5   "Missing value because the definition of this variable is not used (PL088 and PL089 only)"  
label define  pl080_f_cl80 1   "Filled" -1   "Missing" -5   "Missing value because the definition of this variable is not used (PL088 and PL089 only)"  
label define  pl085_f_cl82 1   "Filled" -1   "Missing" -5   "Missing value because the definition of this variable is not used (PL088 and PL089 only)"  
label define  pl086_f_cl84 1   "Filled" -1   "Missing" -5   "Missing value because the definition of this variable is not used (PL088 and PL089 only)"  
label define  pl087_f_cl86 1   "Filled" -1   "Missing" -5   "Missing value because the definition of this variable is not used (PL088 and PL089 only)"  
label define  pl088_f_cl88 1   "Filled" -1   "Missing" -5   "Missing value because the definition of this variable is not used (PL088 and PL089 only)"  
label define  pl089_f_cl90 1   "Filled" -1   "Missing" -5   "Missing value because the definition of this variable is not used (PL088 and PL089 only)"  
label define  pl090_f_cl92 1   "Filled" -1   "Missing" -5   "Missing value because the definition of this variable is not used (PL088 and PL089 only)"  
label define  pl100_f_cl94 1   "Filled" -1   "Missing" -2   "Not applicable (person does not have a second job or PL031 not equal to 1, 2, 3 or 4)"  
label define  pl111_cl95 a   "Agriculture, forestry and fishing" f   "Construction" g   "Wholesale retail" h   "Transportation and storage" i   "Accommodation and food service activities" j   "Information and communication" k   "Financial and insurance activities" o   "Public administration and defence, compulsory social security" p   "Education" q   "Human health and social work activities" b - e   "Mining and quarrying, Manufacturing, Electricity, gas, steam and air conditioning supply, Water supply" l - n   "Real estate activities, Professional, scientific and technical activities, Administrative and support service activities" r - u   "Arts, entertainment and recreation, Other service activities, Activities as household as employer..., Activities of extraterritorial organisations and bodies"  
label define  pl111_f_cl96 1   "Filled" -1   "Missing" -2   "Not applicable (PL031 not equal to 1, 2, 3 or 4)" -3   "Non-selected respondent"  
label define  pl120_cl97 1   "Undergoing education or training" 2   "Personal illness or disability" 3   "Wants to work more hours but cannot find a job(s) or work(s) of more hours" 4   "Do not want to work more hours" 5   "Number of hours in all job(s) are considered as a full-time job" 6   "Housework, looking after children or other persons" 7   "Other reasons"  
label define  pl120_f_cl98 1   "Filled" -1   "Missing" -2   "Not applicable (Not (PL031 eq 1, 2 , 3 or 4, and PL060 + PL100 < 30))" -3   "Non-selected respondent"  
label define  pl130_cl99 1   "1 person" 2   "2 persons" 3   "3 persons" 4   "4 persons" 5   "5 persons" 6   "6 persons" 7   "7 persons" 8   "8 persons" 9   "9 persons" 10   "10 persons" 11   "Between 11 and 19 persons" 12   "Between 20 and 49 persons" 13   "50 persons and more" 14   "Do not know but less than 11 persons" 15   "Do not know but more than 10 persons"  
label define  pl130_f_cl100 1   "Filled" -1   "Missing" -2   "Not applicable (PL031 not equal to 1, 2, 3 or 4)" -3   "Non-selected respondent"  
label define  pl140_cl101 1   "Permanent job/work contract of unlimited duration" 2   "Temporary job/work contract of limited duration"  
label define  pl140_f_cl102 1   "Filled" -1   "Missing" -2   "Not applicable (PL040 not equal to 3)" -3   "Non-selected respondent" -4   "Not applicable because the person is employee (PL040 eq 3) but does not have a contract"  
label define  pl150_cl103 1   "Supervisory" 2   "Non-supervisory"  
label define  pl150_f_cl104 1   "Filled" -1   "Missing" -2   "Not applicable (PL040 not equal to 3)" -3   "Non-selected respondent"  
label define  pl160_cl105 1   "Yes" 2   "No"  
label define  pl160_f_cl106 1   "Filled" -1   "Missing" -2   "Not applicable (PL031 not equal to 1, 2, 3 or 4)" -3   "Non-selected respondent"  
label define  pl170_cl107 1   "To take up or seek better job" 2   "End of temporary contract" 3   "Obliged to stop by employer (business closure, redundancy, early retirement, dismissal etc.)" 4   "Sale or closure of own/family business" 5   "Childcare and care for other dependents" 6   "Partner¿s job required us to move to another area or marriage 7   "Other reasons"  
label define  pl170_f_cl108 1   "Filled" -1   "Missing" -2   "Not applicable (PL160 not equal to 1)" -3   "Non-selected respondent"  
label define  pl180_cl109 1   "Employed - unemployed" 2   "Employed - retired" 3   "Employed - other inactive" 4   "Unemployed - employed" 5   "Unemployed - retired" 6   "Unemployed - other inactive" 7   "Retired - employed" 8   "Retired - unemployed" 9   "Retired - other inactive" 10   "Other inactive - employed" 11   "Other inactive - unemployed" 12   "Other inactive - retired"  
label define  pl180_f_cl110 1   "Filled" -1   "Missing" -2   "Not applicable (no change since last year)" -3   "Non-selected respondent"  
label define  pl190_f_cl112 1   "Filled" -1   "Missing" -2   "Not applicable (person never worked i.e. (PL031 not equal to 1, 2, 3 or 4 AND PL015 not equal to 1))" -3   "Non-selected respondent"  
label define  pl200_f_cl114 1   "Filled" -1   "Missing" -2   "Not applicable (person never worked i.e. (PL031 not equal to 1, 2, 3 or 4 AND PL015 not equal to 1))" -3   "Non-selected respondent"  
label define  pl211a_cl115 1   "Employee working full-time" 2   "Employee working part-time" 3   "Self-employed working full-time (including family worker)" 4   "Self-employed working part-time (including family worker)" 5   "Unemployed" 6   "Pupil, student, further training, unpaid work experience" 7   "In retirement or in early retirement or has given up business" 8   "Permanently disabled or/and unfit to work" 9   "In compulsory military or community service" 10   "Fulfilling domestic tasks and care responsibilities" 11   "Other inactive person"  
label define  pl211a_f_cl116 1   "Filled" -1   "Missing" -3   "Non-selected respondent"  
label define  pl211b_cl117 1   "Employee working full-time" 2   "Employee working part-time" 3   "Self-employed working full-time (including family worker)" 4   "Self-employed working part-time (including family worker)" 5   "Unemployed" 6   "Pupil, student, further training, unpaid work experience" 7   "In retirement or in early retirement or has given up business" 8   "Permanently disabled or/and unfit to work" 9   "In compulsory military or community service" 10   "Fulfilling domestic tasks and care responsibilities" 11   "Other inactive person"  
label define  pl211b_f_cl118 1   "Filled" -1   "Missing" -3   "Non-selected respondent"  
label define  pl211c_cl119 1   "Employee working full-time" 2   "Employee working part-time" 3   "Self-employed working full-time (including family worker)" 4   "Self-employed working part-time (including family worker)" 5   "Unemployed" 6   "Pupil, student, further training, unpaid work experience" 7   "In retirement or in early retirement or has given up business" 8   "Permanently disabled or/and unfit to work" 9   "In compulsory military or community service" 10   "Fulfilling domestic tasks and care responsibilities" 11   "Other inactive person"  
label define  pl211c_f_cl120 1   "Filled" -1   "Missing" -3   "Non-selected respondent"  
label define  pl211d_cl121 1   "Employee working full-time" 2   "Employee working part-time" 3   "Self-employed working full-time (including family worker)" 4   "Self-employed working part-time (including family worker)" 5   "Unemployed" 6   "Pupil, student, further training, unpaid work experience" 7   "In retirement or in early retirement or has given up business" 8   "Permanently disabled or/and unfit to work" 9   "In compulsory military or community service" 10   "Fulfilling domestic tasks and care responsibilities" 11   "Other inactive person"  
label define  pl211d_f_cl122 1   "Filled" -1   "Missing" -3   "Non-selected respondent"  
label define  pl211e_cl123 1   "Employee working full-time" 2   "Employee working part-time" 3   "Self-employed working full-time (including family worker)" 4   "Self-employed working part-time (including family worker)" 5   "Unemployed" 6   "Pupil, student, further training, unpaid work experience" 7   "In retirement or in early retirement or has given up business" 8   "Permanently disabled or/and unfit to work" 9   "In compulsory military or community service" 10   "Fulfilling domestic tasks and care responsibilities" 11   "Other inactive person"  
label define  pl211e_f_cl124 1   "Filled" -1   "Missing" -3   "Non-selected respondent"  
label define  pl211f_cl125 1   "Employee working full-time" 2   "Employee working part-time" 3   "Self-employed working full-time (including family worker)" 4   "Self-employed working part-time (including family worker)" 5   "Unemployed" 6   "Pupil, student, further training, unpaid work experience" 7   "In retirement or in early retirement or has given up business" 8   "Permanently disabled or/and unfit to work" 9   "In compulsory military or community service" 10   "Fulfilling domestic tasks and care responsibilities" 11   "Other inactive person"  
label define  pl211f_f_cl126 1   "Filled" -1   "Missing" -3   "Non-selected respondent"  
label define  pl211g_cl127 1   "Employee working full-time" 2   "Employee working part-time" 3   "Self-employed working full-time (including family worker)" 4   "Self-employed working part-time (including family worker)" 5   "Unemployed" 6   "Pupil, student, further training, unpaid work experience" 7   "In retirement or in early retirement or has given up business" 8   "Permanently disabled or/and unfit to work" 9   "In compulsory military or community service" 10   "Fulfilling domestic tasks and care responsibilities" 11   "Other inactive person"  
label define  pl211g_f_cl128 1   "Filled" -1   "Missing" -3   "Non-selected respondent"  
label define  pl211h_cl129 1   "Employee working full-time" 2   "Employee working part-time" 3   "Self-employed working full-time (including family worker)" 4   "Self-employed working part-time (including family worker)" 5   "Unemployed" 6   "Pupil, student, further training, unpaid work experience" 7   "In retirement or in early retirement or has given up business" 8   "Permanently disabled or/and unfit to work" 9   "In compulsory military or community service" 10   "Fulfilling domestic tasks and care responsibilities" 11   "Other inactive person"  
label define  pl211h_f_cl130 1   "Filled" -1   "Missing" -3   "Non-selected respondent"  
label define  pl211i_cl131 1   "Employee working full-time" 2   "Employee working part-time" 3   "Self-employed working full-time (including family worker)" 4   "Self-employed working part-time (including family worker)" 5   "Unemployed" 6   "Pupil, student, further training, unpaid work experience" 7   "In retirement or in early retirement or has given up business" 8   "Permanently disabled or/and unfit to work" 9   "In compulsory military or community service" 10   "Fulfilling domestic tasks and care responsibilities" 11   "Other inactive person"  
label define  pl211i_f_cl132 1   "Filled" -1   "Missing" -3   "Non-selected respondent"  
label define  pl211j_cl133 1   "Employee working full-time" 2   "Employee working part-time" 3   "Self-employed working full-time (including family worker)" 4   "Self-employed working part-time (including family worker)" 5   "Unemployed" 6   "Pupil, student, further training, unpaid work experience" 7   "In retirement or in early retirement or has given up business" 8   "Permanently disabled or/and unfit to work" 9   "In compulsory military or community service" 10   "Fulfilling domestic tasks and care responsibilities" 11   "Other inactive person"  
label define  pl211j_f_cl134 1   "Filled" -1   "Missing" -3   "Non-selected respondent"  
label define  pl211k_cl135 1   "Employee working full-time" 2   "Employee working part-time" 3   "Self-employed working full-time (including family worker)" 4   "Self-employed working part-time (including family worker)" 5   "Unemployed" 6   "Pupil, student, further training, unpaid work experience" 7   "In retirement or in early retirement or has given up business" 8   "Permanently disabled or/and unfit to work" 9   "In compulsory military or community service" 10   "Fulfilling domestic tasks and care responsibilities" 11   "Other inactive person"  
label define  pl211k_f_cl136 1   "Filled" -1   "Missing" -3   "Non-selected respondent"  
label define  pl211l_cl137 1   "Employee working full-time" 2   "Employee working part-time" 3   "Self-employed working full-time (including family worker)" 4   "Self-employed working part-time (including family worker)" 5   "Unemployed" 6   "Pupil, student, further training, unpaid work experience" 7   "In retirement or in early retirement or has given up business" 8   "Permanently disabled or/and unfit to work" 9   "In compulsory military or community service" 10   "Fulfilling domestic tasks and care responsibilities" 11   "Other inactive person"  
label define  pl211l_f_cl138 1   "Filled" -1   "Missing" -3   "Non-selected respondent"  
label define  py030g_f_cl185 0   "No income" 1   "Income (variable is filled)" -1   "Missing"  
label define  py031g_f_cl188 0   "No income" 1   "Income (variable is filled)" -1   "Missing"  
label define  py091g_f_cl203 0   "No income" 1   "Filled with only Contributory and means-tested components" 2   "Filled with mixed components" -1   "Missing" -2   "Not applicable (This scheme doesn't exist at national level)" -7   "Not applicable (PB010 ne last year)"  
label define  py092g_f_cl205 0   "No income" 1   "Filled with only Contributory and non means-tested components" 2   "Filled with mixed components" -1   "Missing" -2   "Not applicable (This scheme doesn't exist at national level)" -7   "Not applicable (PB010 ne last year)"  
label define  py093g_f_cl207 0   "No income" 1   "Filled with only Non-contributory and means-tested components" 2   "Filled with mixed components" -1   "Missing" -2   "Not applicable (This scheme doesn't exist at national level)" -7   "Not applicable (PB010 ne last year)"  
label define  py094g_f_cl209 0   "No income" 1   "Filled with only Non-contributory and non means-tested components" 2   "Filled with mixed components" -1   "Missing" -2   "Not applicable (This scheme doesn't exist at national level)" -7   "Not applicable (PB010 ne last year)"  
label define  py101g_f_cl214 0   "No income" 1   "Filled with only Contributory and means-tested components" 2   "Filled with mixed components" -1   "Missing" -2   "Not applicable (This scheme doesn't exist at national level)" -7   "Not applicable (PB010 ne last year)"  
label define  py102g_f_cl216 0   "No income" 1   "Filled with only Contributory and non means-tested components" 2   "Filled with mixed components" -1   "Missing" -2   "Not applicable (This scheme doesn't exist at national level)" -7   "Not applicable (PB010 ne last year)"  
label define  py103g_f_cl218 0   "No income" 1   "Filled with only Non-contributory and means-tested components" 2   "Filled with mixed components" -1   "Missing" -2   "Not applicable (This scheme doesn't exist at national level)" -7   "Not applicable (PB010 ne last year)"  
label define  py104g_f_cl220 0   "No income" 1   "Filled with only Non-contributory and non means-tested components" 2   "Filled with mixed components" -1   "Missing" -2   "Not applicable (This scheme doesn't exist at national level)" -7   "Not applicable (PB010 ne last year)"  
label define  py111g_f_cl225 0   "No income" 1   "Filled with only Contributory and means-tested components" 2   "Filled with mixed components" -1   "Missing" -2   "Not applicable (This scheme doesn't exist at national level)" -7   "Not applicable (PB010 ne last year)"  
label define  py112g_f_cl227 0   "No income" 1   "Filled with only Contributory and non means-tested components" 2   "Filled with mixed components" -1   "Missing" -2   "Not applicable (This scheme doesn't exist at national level)" -7   "Not applicable (PB010 ne last year)"  
label define  py113g_f_cl229 0   "No income" 1   "Filled with only Non-contributory and means-tested components" 2   "Filled with mixed components" -1   "Missing" -2   "Not applicable (This scheme doesn't exist at national level)" -7   "Not applicable (PB010 ne last year)"  
label define  py114g_f_cl231 0   "No income" 1   "Filled with only Non-contributory and non means-tested components" 2   "Filled with mixed components" -1   "Missing" -2   "Not applicable (This scheme doesn't exist at national level)" -7   "Not applicable (PB010 ne last year)"  
label define  py121g_f_cl236 0   "No income" 1   "Filled with only Contributory and means-tested components" 2   "Filled with mixed components" -1   "Missing" -2   "Not applicable (This scheme doesn't exist at national level)" -7   "Not applicable (PB010 ne last year)"  
label define  py122g_f_cl238 0   "No income" 1   "Filled with only Contributory and non means-tested components" 2   "Filled with mixed components" -1   "Missing" -2   "Not applicable (This scheme doesn't exist at national level)" -7   "Not applicable (PB010 ne last year)"  
label define  py123g_f_cl240 0   "No income" 1   "Filled with only Non-contributory and means-tested components" 2   "Filled with mixed components" -1   "Missing" -2   "Not applicable (This scheme doesn't exist at national level)" -7   "Not applicable (PB010 ne last year)"  
label define  py124g_f_cl242 0   "No income" 1   "Filled with only Non-contributory and non means-tested components" 2   "Filled with mixed components" -1   "Missing" -2   "Not applicable (This scheme doesn't exist at national level)" -7   "Not applicable (PB010 ne last year)"  
label define  py131g_f_cl247 0   "No income" 1   "Filled with only Contributory and means-tested components" 2   "Filled with mixed components" -1   "Missing" -2   "Not applicable (This scheme doesn't exist at national level)" -7   "Not applicable (PB010 ne last year)"  
label define  py132g_f_cl249 0   "No income" 1   "Filled with only Contributory and non means-tested components" 2   "Filled with mixed components" -1   "Missing" -2   "Not applicable (This scheme doesn't exist at national level)" -7   "Not applicable (PB010 ne last year)"  
label define  py133g_f_cl251 0   "No income" 1   "Filled with only Non-contributory and means-tested components" 2   "Filled with mixed components" -1   "Missing" -2   "Not applicable (This scheme doesn't exist at national level)" -7   "Not applicable (PB010 ne last year)"  
label define  py134g_f_cl253 0   "No income" 1   "Filled with only Non-contributory and non means-tested components" 2   "Filled with mixed components" -1   "Missing" -2   "Not applicable (This scheme doesn't exist at national level)" -7   "Not applicable (PB010 ne last year)"  
label define  py141g_f_cl258 0   "No income" 1   "Filled with only Contributory and means-tested components" 2   "Filled with mixed components" -1   "Missing" -2   "Not applicable (This scheme doesn't exist at national level)" -7   "Not applicable (PB010 ne last year)"  
label define  py142g_f_cl260 0   "No income" 1   "Filled with only Contributory and non means-tested components" 2   "Filled with mixed components" -1   "Missing" -2   "Not applicable (This scheme doesn't exist at national level)" -7   "Not applicable (PB010 ne last year)"  
label define  py143g_f_cl262 0   "No income" 1   "Filled with only Non-contributory and means-tested components" 2   "Filled with mixed components" -1   "Missing" -2   "Not applicable (This scheme doesn't exist at national level)" -7   "Not applicable (PB010 ne last year)"  
label define  py144g_f_cl264 0   "No income" 1   "Filled with only Non-contributory and non means-tested components" 2   "Filled with mixed components" -1   "Missing" -2   "Not applicable (This scheme doesn't exist at national level)" -7   "Not applicable (PB010 ne last year)"  
label define  pd020_cl268 1   "Yes" 2   "No - cannot afford it" 3   "No - other reason"  
label define  pd020_f_cl269 1   "Filled" -1   "Missing" -3   "Not selected respondent"  
label define  pd030_cl270 1   "Yes" 2   "No - cannot afford it" 3   "No - other reason"  
label define  pd030_f_cl271 1   "Filled" -1   "Missing" -3   "Not selected respondent"  
label define  pd050_cl272 1   "Yes" 2   "No - cannot afford it" 3   "No - other reason"  
label define  pd050_f_cl273 1   "Filled" -1   "Missing" -3   "Not selected respondent"  
label define  pd060_cl274 1   "Yes" 2   "No - cannot afford it" 3   "No - other reason"  
label define  pd060_f_cl275 1   "Filled" -1   "Missing" -3   "Not selected respondent"  
label define  pd070_cl276 1   "Yes" 2   "No - cannot afford it" 3   "No - other reason"  
label define  pd070_f_cl277 1   "Filled" -1   "Missing" -3   "Not selected respondent"  
label define  pd080_cl278 1   "Yes" 2   "No - cannot afford it" 3   "No - other reason"  
label define  pd080_f_cl279 1   "Filled" -1   "Missing" -3   "Not selected respondent"  
label define  pw005t_f_cl281 1   "Filled" -1   "Missing" -2   "Not applicable (proxy interview)" -3   "Non-selected respondent" -7   "Not applicable (PB010 ne 2018)" -8   "Not applicable (variable not constructed)"  
label define  pw010t_cl282 0   "0 (Not at all satisfied)" 1   "1" 2   "2" 3   "3" 4   "4" 5   "5" 6   "6" 7   "7" 8   "8" 9   "9" 10   "10 (Completely satisfied)" 99   "Do not know"  
label define  pw010t_f_cl283 1   "Filled" -1   "Missing" -2   "Not applicable (proxy interview)" -3   "Non-selected respondent" -7   "Not applicable (PB010 ne 2018)"  
label define  pw240t_cl284 0   "0 (Not at all satisfied)" 1   "1" 2   "2" 3   "3" 4   "4" 5   "5" 6   "6" 7   "7" 8   "8" 9   "9" 10   "10 (Completely satisfied)" 99   "Do not know"  
label define  pw240t_f_cl285 1   "Filled" -1   "Missing" -2   "Not applicable (proxy interview)" -3   "Non-selected respondent" -7   "Not applicable (PB010 ne 2018)"  
label define  pw040t_cl286 1   "Yes" 2   "No"  
label define  pw040t_f_cl287 1   "Filled" -1   "Missing" -2   "Not applicable (proxy interview)" -3   "Non-selected respondent" -7   "Not applicable (PB010 ne 2018)"  
label define  pw110t_cl288 1   "Yes" 2   "No"  
label define  pw110t_f_cl289 1   "Filled" -1   "Missing" -2   "Not applicable (proxy interview)" -3   "Non-selected respondent" -7   "Not applicable (PB010 ne 2018)"  
label define  pw030t_cl290 0   "0 (Not at all satisfied)" 1   "1" 2   "2" 3   "3" 4   "4" 5   "5" 6   "6" 7   "7" 8   "8" 9   "9" 10   "10 (Completely satisfied)" 99   "Do not know"  
label define  pw030t_f_cl291 1   "Filled" -1   "Missing" -2   "Not applicable (proxy interview)" -3   "Non-selected respondent" -7   "Not applicable (PB010 ne 2018)"  
label define  pw160t_cl292 0   "0 (Not at all satisfied)" 1   "1" 2   "2" 3   "3" 4   "4" 5   "5" 6   "6" 7   "7" 8   "8" 9   "9" 10   "10 (Completely satisfied)" 99   "Do not know"  
label define  pw160t_f_cl293 1   "Filled" -1   "Missing" -2   "Not applicable (proxy interview)" -3   "Non-selected respondent" -7   "Not applicable (PB010 ne 2018)"  
label define  pw120t_cl294 0   "0 (Not at all satisfied)" 1   "1" 2   "2" 3   "3" 4   "4" 5   "5" 6   "6" 7   "7" 8   "8" 9   "9" 10   "10 (Completely satisfied)" 99   "Do not know"  
label define  pw120t_f_cl295 1   "Filled" -1   "Missing" -2   "Not applicable (proxy interview)" -3   "Non-selected respondent" -7   "Not applicable (PB010 ne 2018)"  
label define  pw100t_cl296 0   "0 (Not at all satisfied)" 1   "1" 2   "2" 3   "3" 4   "4" 5   "5" 6   "6" 7   "7" 8   "8" 9   "9" 10   "10 (Completely satisfied)" 99   "Do not know"  
label define  pw100t_f_cl297 1   "Filled" -1   "Missing" -2   "Not applicable ((proxy interview) OR (PL031 ne 1,2,3,4))" -3   "Non-selected respondent" -7   "Not applicable (PB010 ne 2018)"  
label define  pw190t_cl298 0   "0 (Not at all satisfied)" 1   "1" 2   "2" 3   "3" 4   "4" 5   "5" 6   "6" 7   "7" 8   "8" 9   "9" 10   "10 (Completely satisfied)" 99   "Do not know"  
label define  pw190t_f_cl299 1   "Filled" -1   "Missing" -2   "Not applicable (proxy interview)" -3   "Non-selected respondent" -7   "Not applicable (PB010 ne 2018)"  
label define  pw230t_cl300 1   "All of the time" 2   "Most of the time" 3   "Some of the time" 4   "A little of the time" 5   "None of the time" 99   "Do not know"  
label define  pw230t_f_cl301 1   "Filled" -1   "Missing" -2   "Not applicable (proxy interview)" -3   "Non-selected respondent" -7   "Not applicable (PB010 ne 2018)"  
label define  pw050t_cl302 1   "All of the time" 2   "Most of the time" 3   "Some of the time" 4   "A little of the time" 5   "None of the time" 99   "Do not know"  
label define  pw050t_f_cl303 1   "Filled" -1   "Missing" -2   "Not applicable (proxy interview)" -3   "Non-selected respondent" -7   "Not applicable (PB010 ne 2018)"  
label define  pw060t_cl304 1   "All of the time" 2   "Most of the time" 3   "Some of the time" 4   "A little of the time" 5   "None of the time" 99   "Do not know"  
label define  pw060t_f_cl305 1   "Filled" -1   "Missing" -2   "Not applicable (proxy interview)" -3   "Non-selected respondent" -7   "Not applicable (PB010 ne 2018)"  
label define  pw070t_cl306 1   "All of the time" 2   "Most of the time" 3   "Some of the time" 4   "A little of the time" 5   "None of the time" 99   "Do not know"  
label define  pw070t_f_cl307 1   "Filled" -1   "Missing" -2   "Not applicable (proxy interview)" -3   "Non-selected respondent" -7   "Not applicable (PB010 ne 2018)"  
label define  pw080t_cl308 1   "All of the time" 2   "Most of the time" 3   "Some of the time" 4   "A little of the time" 5   "None of the time" 99   "Do not know"  
label define  pw080t_f_cl309 1   "Filled" -1   "Missing" -2   "Not applicable (proxy interview)" -3   "Non-selected respondent" -7   "Not applicable (PB010 ne 2018)"  
label define  pw090t_cl310 1   "All of the time" 2   "Most of the time" 3   "Some of the time" 4   "A little of the time" 5   "None of the time" 99   "Do not know"  
label define  pw090t_f_cl311 1   "Filled" -1   "Missing" -2   "Not applicable (proxy interview)" -3   "Non-selected respondent" -7   "Not applicable (PB010 ne 2018)"  
label define  px040_cl315 1   "Current household member aged 16 and over" 2   "Selected respondent" 3   "Non-selected respondent" 4   "Ineligible person"  
label define  px050_cl316 2   "Employees (SAL)" 3   "Employed persons except employees (NSAL)" 4   "Other employed (when time of SAL and NSAL is > ¿ of total time calendar) 5   "Unemployed" 6   "Retired" 7   "Inactive" 8   "Other inactive (when time of unemployed, retirement and inactivity is > ¿ of total time calendar)  
label values  pb020 pb020_cl1
label values  pb040_f pb040_f_cl4
label values  pb060_f pb060_f_cl6
label values  pb100 pb100_cl7
label values  pb100_f pb100_f_cl8
label values  pb110_f pb110_f_cl10
label values  pb120_f pb120_f_cl12
label values  pb130 pb130_cl13
label values  pb130_f pb130_f_cl14
label values  pb140_f pb140_f_cl16
label values  pb150 pb150_cl17
label values  pb150_f pb150_f_cl18
label values  pb160_f pb160_f_cl20
label values  pb170_f pb170_f_cl22
label values  pb180_f pb180_f_cl24
label values  pb190 pb190_cl25
label values  pb190_f pb190_f_cl26
label values  pb200 pb200_cl27
label values  pb200_f pb200_f_cl28
label values  pb210 pb210_cl29
label values  pb210_f pb210_f_cl30
label values  pb220a pb220a_cl31
label values  pb220a_f pb220a_f_cl32
label values  pe010 pe010_cl33
label values  pe010_f pe010_f_cl34
label values  pe020 pe020_cl35
label values  pe020_f pe020_f_cl36
label values  pe030_f pe030_f_cl38
label values  pe040 pe040_cl39
label values  pe040_f pe040_f_cl40
label values  ph010 ph010_cl41
label values  ph010_f ph010_f_cl42
label values  ph020 ph020_cl43
label values  ph020_f ph020_f_cl44
label values  ph030 ph030_cl45
label values  ph030_f ph030_f_cl46
label values  ph040 ph040_cl47
label values  ph040_f ph040_f_cl48
label values  ph050 ph050_cl49
label values  ph050_f ph050_f_cl50
label values  ph060 ph060_cl51
label values  ph060_f ph060_f_cl52
label values  ph070 ph070_cl53
label values  ph070_f ph070_f_cl54
label values  pl015 pl015_cl55
label values  pl015_f pl015_f_cl56
label values  pl020 pl020_cl57
label values  pl020_f pl020_f_cl58
label values  pl025 pl025_cl59
label values  pl025_f pl025_f_cl60
label values  pl031 pl031_cl61
label values  pl031_f pl031_f_cl62
label values  pl035 pl035_cl63
label values  pl035_f pl035_f_cl64
label values  pl040 pl040_cl65
label values  pl040_f pl040_f_cl66
label values  pl051 pl051_cl67
label values  pl051_f pl051_f_cl68
label values  pl060_f pl060_f_cl70
label values  pl073_f pl073_f_cl72
label values  pl074_f pl074_f_cl74
label values  pl075_f pl075_f_cl76
label values  pl076_f pl076_f_cl78
label values  pl080_f pl080_f_cl80
label values  pl085_f pl085_f_cl82
label values  pl086_f pl086_f_cl84
label values  pl087_f pl087_f_cl86
label values  pl088_f pl088_f_cl88
label values  pl089_f pl089_f_cl90
label values  pl090_f pl090_f_cl92
label values  pl100_f pl100_f_cl94
label values  pl111 pl111_cl95
label values  pl111_f pl111_f_cl96
label values  pl120 pl120_cl97
label values  pl120_f pl120_f_cl98
label values  pl130 pl130_cl99
label values  pl130_f pl130_f_cl100
label values  pl140 pl140_cl101
label values  pl140_f pl140_f_cl102
label values  pl150 pl150_cl103
label values  pl150_f pl150_f_cl104
label values  pl160 pl160_cl105
label values  pl160_f pl160_f_cl106
label values  pl170 pl170_cl107
label values  pl170_f pl170_f_cl108
label values  pl180 pl180_cl109
label values  pl180_f pl180_f_cl110
label values  pl190_f pl190_f_cl112
label values  pl200_f pl200_f_cl114
label values  pl211a pl211a_cl115
label values  pl211a_f pl211a_f_cl116
label values  pl211b pl211b_cl117
label values  pl211b_f pl211b_f_cl118
label values  pl211c pl211c_cl119
label values  pl211c_f pl211c_f_cl120
label values  pl211d pl211d_cl121
label values  pl211d_f pl211d_f_cl122
label values  pl211e pl211e_cl123
label values  pl211e_f pl211e_f_cl124
label values  pl211f pl211f_cl125
label values  pl211f_f pl211f_f_cl126
label values  pl211g pl211g_cl127
label values  pl211g_f pl211g_f_cl128
label values  pl211h pl211h_cl129
label values  pl211h_f pl211h_f_cl130
label values  pl211i pl211i_cl131
label values  pl211i_f pl211i_f_cl132
label values  pl211j pl211j_cl133
label values  pl211j_f pl211j_f_cl134
label values  pl211k pl211k_cl135
label values  pl211k_f pl211k_f_cl136
label values  pl211l pl211l_cl137
label values  pl211l_f pl211l_f_cl138
label values  py030g_f py030g_f_cl185
label values  py031g_f py031g_f_cl188
label values  py091g_f py091g_f_cl203
label values  py092g_f py092g_f_cl205
label values  py093g_f py093g_f_cl207
label values  py094g_f py094g_f_cl209
label values  py101g_f py101g_f_cl214
label values  py102g_f py102g_f_cl216
label values  py103g_f py103g_f_cl218
label values  py104g_f py104g_f_cl220
label values  py111g_f py111g_f_cl225
label values  py112g_f py112g_f_cl227
label values  py113g_f py113g_f_cl229
label values  py114g_f py114g_f_cl231
label values  py121g_f py121g_f_cl236
label values  py122g_f py122g_f_cl238
label values  py123g_f py123g_f_cl240
label values  py124g_f py124g_f_cl242
label values  py131g_f py131g_f_cl247
label values  py132g_f py132g_f_cl249
label values  py133g_f py133g_f_cl251
label values  py134g_f py134g_f_cl253
label values  py141g_f py141g_f_cl258
label values  py142g_f py142g_f_cl260
label values  py143g_f py143g_f_cl262
label values  py144g_f py144g_f_cl264
label values  pd020 pd020_cl268
label values  pd020_f pd020_f_cl269
label values  pd030 pd030_cl270
label values  pd030_f pd030_f_cl271
label values  pd050 pd050_cl272
label values  pd050_f pd050_f_cl273
label values  pd060 pd060_cl274
label values  pd060_f pd060_f_cl275
label values  pd070 pd070_cl276
label values  pd070_f pd070_f_cl277
label values  pd080 pd080_cl278
label values  pd080_f pd080_f_cl279
label values  pw005t_f pw005t_f_cl281
label values  pw010t pw010t_cl282
label values  pw010t_f pw010t_f_cl283
label values  pw240t pw240t_cl284
label values  pw240t_f pw240t_f_cl285
label values  pw040t pw040t_cl286
label values  pw040t_f pw040t_f_cl287
label values  pw110t pw110t_cl288
label values  pw110t_f pw110t_f_cl289
label values  pw030t pw030t_cl290
label values  pw030t_f pw030t_f_cl291
label values  pw160t pw160t_cl292
label values  pw160t_f pw160t_f_cl293
label values  pw120t pw120t_cl294
label values  pw120t_f pw120t_f_cl295
label values  pw100t pw100t_cl296
label values  pw100t_f pw100t_f_cl297
label values  pw190t pw190t_cl298
label values  pw190t_f pw190t_f_cl299
label values  pw230t pw230t_cl300
label values  pw230t_f pw230t_f_cl301
label values  pw050t pw050t_cl302
label values  pw050t_f pw050t_f_cl303
label values  pw060t pw060t_cl304
label values  pw060t_f pw060t_f_cl305
label values  pw070t pw070t_cl306
label values  pw070t_f pw070t_f_cl307
label values  pw080t pw080t_cl308
label values  pw080t_f pw080t_f_cl309
label values  pw090t pw090t_cl310
label values  pw090t_f pw090t_f_cl311
label values  px040 px040_cl315
label values  px050 px050_cl316
*/
save  EUSILC_Cross_A2018_PERSONAL_DATA.dta, replace
