#Declinazione di responsabilità. 
#I file rilasciati in formato testo sono provvisti anche dei programmi di importazione per STATA, SAS e R. 
#L'Istat non garantisce che le funzioni contenute nei suddetti programmi siano esenti da errore e non si assume alcuna responsabilità sull’output ottenuto dal loro utilizz
setwd(choose.dir(default = "", caption = "WHERE ARE MICRODATA?"))
direttorio = getwd()
fileInput = paste (direttorio, "/ISTAT_MFR_EUSILC_Cross_Microdata_2018_HOUSEHOLD_REGISTER_(D-FILE)_Cross-Sectional_FILE_STRUCTURE_EXAMPLE.txt", sep="")
DF_EUSILC_Cross_A2018_HOUSEHOLD<- read.delim2 (fileInput,  header=T, sep="	",  quote="",  na.strings = ".")
attr(DF_EUSILC_Cross_A2018_HOUSEHOLD, "label") <- c(
"YEAR OF THE SURVEY",
"COUNTRY",
"HOUSEHOLD ID",
"REGION",
"FLAG OF DB040",
"PRIMARY SAMPLING UNITS (PSU)",
"FLAG OF DB060",
"SECONDARY SAMPLING UNITS (SSU)",
"FLAG OF DB062",
"ORDER OF SELECTION OF PSU",
"FLAG OF DB070",
"ROTATION GROUP",
"FLAG OF DB075",
"HOUSEHOLD CROSS-SECTIONAL WEIGHT",
"FLAG OF DB090",
"DEGREE OF URBANISATION",
"FLAG OF DB100")

DB020_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$DB020, 
levels=c("AT", 
"BE", 
"BG", 
"CH", 
"CY", 
"CZ", 
"DE", 
"DK", 
"EE", 
"EL", 
"ES", 
"FI", 
"FR", 
"HR", 
"HU", 
"IE", 
"IS", 
"IT", 
"LT", 
"LU", 
"LV", 
"ME", 
"MK", 
"MT", 
"NL", 
"NO", 
"PL", 
"PT", 
"RO", 
"RS", 
"SE", 
"SI", 
"SK", 
"TR", 
"UK"), 
labels=c("¿sterreich", 
"Belgique/Belg¿e", 
"Bulgaria", 
"Switzerland", 
"Cyprus", 
"Czech republic", 
"Deutschland", 
"Denmark", 
"Estonia", 
"Ell¿da", 
"Espa¿a", 
"Suomi", 
"France", 
"Croatia", 
"Hungary", 
"Ireland", 
"Iceland", 
"Italia", 
"Lithuania", 
"Luxembourg", 
"Latvia", 
"Montenegro", 
"The Former Yugoslav Republic of Macedonia (FYROM)", 
"Malta", 
"Nederland", 
"Norway", 
"Poland", 
"Portugal", 
"Romania", 
"Serbia", 
"Sverige", 
"Slovenia", 
"Slovak republic", 
"Turkey", 
"United Kingdom"

DB040_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$DB040, 
levels=c("ITC", 
"ITF", 
"ITG", 
"ITH", 
"ITI"), 
labels=c("Northwest Italy", 
"Northeast Italy", 
"Central Italy", 
"South Italy", 
"Insular Italy")) 


DB040_F_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$DB040_F, 
levels=c(1, 
-1), 
labels=c("Filled according to NUTS-10", 
"Missing")) 


DB060_F_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$DB060_F, 
levels=c(1, 
2, 
-2), 
labels=c("Rotation is implemented at PSU level (the PSU rotates in and out of the sample)", 
"Rotation is implemented at SSU or household level (The PSU remains in the sample for the entire duration of EU-SILC)", 
"Not applicable (no first or second sampling stage)")) 


DB062_F_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$DB062_F, 
levels=c(1, 
2, 
-2), 
labels=c("Rotation is implemented at PSU level (the PSU rotates in and out of the sample)", 
"Rotation is implemented at SSU or household level (The PSU remains in the sample for the entire duration of EU-SILC)", 
"Not applicable (no first or second sampling stage)")) 


DB070_F_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$DB070_F, 
levels=c(-2), 
labels=c("Not applicable (no systematic selection)")) 


DB075_F_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$DB075_F, 
levels=c(1, 
-2), 
labels=c("Filled", 
"Not applicable (no rotational design used)")) 


DB090_F_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$DB090_F, 
levels=c(1, 
-7), 
labels=c("Filled", 
"Not applicable: DB010 ne last year")) 


DB100_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$DB100, 
levels=c(1, 
2, 
3), 
labels=c("Densely-populated area", 
"Intermediate area", 
"Thinly-populated area")) 


DB100_F_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$DB100_F, 
levels=c(1, 
-1), 
labels=c("Filled", 
"Missing (allowed only from wave 2 onwards)")) 

save.image (file="DF_EUSILC_Cross_A2018_HOUSEHOLD.RData")
