#Declinazione di responsabilità. 
#I file rilasciati in formato testo sono provvisti anche dei programmi di importazione per STATA, SAS e R. 
#L'Istat non garantisce che le funzioni contenute nei suddetti programmi siano esenti da errore e non si assume alcuna responsabilità sull’output ottenuto dal loro utilizz
setwd(choose.dir(default = "", caption = "WHERE ARE MICRODATA?"))
direttorio = getwd()
fileInput = paste (direttorio, "/ISTAT_MFR_EUSILC_Cross_Microdata_2018_HOUSEHOLD_DATA_(H-FILE)_Cross-Sectional_FILE_STRUCTURE_EXAMPLE.txt", sep="")
DF_EUSILC_Cross_A2018_HOUSEHOLD<- read.delim2 (fileInput,  header=T, sep="	",  quote="",  na.strings = ".")
attr(DF_EUSILC_Cross_A2018_HOUSEHOLD, "label") <- c(
"YEAR OF THE SURVEY",
"COUNTRY",
"HOUSEHOLD ID",
"MONTH OF HOUSEHOLD INTERVIEW",
"FLAG OF HB050",
"YEAR OF HOUSEHOLD INTERVIEW",
"FLAG OF HB060",
"PERSON RESPONDING THE HOUSEHOLD QUESTIONNAIRE",
"FLAG OF HB070",
"PERSON 1 RESPONSIBLE FOR THE ACCOMMODATION",
"FLAG OF HB080",
"PERSON 2 RESPONSIBLE FOR THE ACCOMMODATION",
"FLAG OF HB090",
"NUMBER OF MINUTES TO COMPLETE THE HOUSEHOLD QUESTIONNAIRE",
"FLAG OF HB100",
"DWELLING TYPE",
"FLAG OF HH010",
"TENURE STATUS",
"FLAG OF HH021",
"NUMBER OF ROOMS AVAILABLE TO THE HOUSEHOLD",
"FLAG OF HH030",
"YEAR OF CONTRACT OR PURCHASING OR INSTALLATION",
"FLAG OF HH031",
"LEAKING ROOF, DAMP WALLS/FLOORS/FOUNDATION, OR ROT IN WINDOW FRAMES OR FLOOR",
"FLAG OF HH040",
"ABILITY TO KEEP HOME ADEQUATELY WARM",
"FLAG OF HH050",
"CURRENT RENT RELATED TO OCCUPIED DWELLING",
"FLAG OF HH060",
"SUBJECTIVE RENT",
"FLAG OF HH061",
"TOTAL HOUSING COST",
"FLAG OF HH070",
"MORTGAGE PRINCIPAL REPAYMENT",
"FLAG OF HH071",
"BATH OR SHOWER IN DWELLING",
"FLAG OF HH081",
"INDOOR FLUSHING TOILET FOR SOLE USE OF HOUSEHOLD",
"FLAG OF HH091",
"ARREARS ON MORTGAGE OR RENTAL PAYMENTS",
"FLAG OF HS011",
"ARREARS ON UTILITY BILLS",
"FLAG OF HS021",
"ARREARS ON HIRE PURCHASE INSTALLMENTS OR OTHER LOAN PAYMENTS",
"FLAG OF HS031",
"CAPACITY TO AFFORD PAYING FOR ONE WEEK ANNUAL HOLIDAY AWAY FROM HOME",
"FLAG OF HS040",
"CAPACITY TO AFFORD A MEAL WITH MEAT, CHICKEN, FISH (OR VEGETARIAN EQUIVALENT) EVERY SECOND DAY",
"FLAG OF HS050",
"CAPACITY TO FACE UNEXPECTED FINANCIAL EXPENSES",
"FLAG OF HS060",
"DO YOU HAVE A TELEPHONE (INCLUDING MOBILE PHONE)?",
"FLAG OF HS070",
"DO YOU HAVE A COLOUR TV?",
"FLAG OF HS080",
"DO YOU HAVE A COMPUTER?",
"FLAG OF HS090",
"DO YOU HAVE A WASHING MACHINE?",
"FLAG OF HS100",
"DO YOU HAVE A CAR?",
"FLAG OF HS110",
"ABILITY TO MAKE ENDS MEET",
"FLAG OF HS120",
"LOWEST MONTHLY INCOME TO MAKE ENDS MEET",
"FLAG OF HS130",
"FINANCIAL BURDEN OF THE TOTAL HOUSING COST",
"FLAG OF HS140",
"FINANCIAL BURDEN OF THE REPAYMENT OF DEBTS FROM HIRE PURCHASES OR LOANS",
"FLAG OF HS150",
"PROBLEMS WITH THE DWELLING: TOO DARK, NOT ENOUGH LIGHT",
"FLAG OF HS160",
"NOISE FROM NEIGHBOURS OR FROM THE STREET",
"FLAG OF HS170",
"POLLUTION, GRIME OR OTHER ENVIRONMENTAL PROBLEMS",
"FLAG OF HS180",
"CRIME, VIOLENCE OR VANDALISM IN THE AREA",
"FLAG OF HS190",
"TOTAL HOUSEHOLD GROSS INCOME",
"FLAG OF HY010",
"IMPUTATION FACTOR OF HY010",
"TOTAL DISPOSABLE HOUSEHOLD INCOME",
"FLAG OF HY020",
"IMPUTATION FACTOR OF HY020",
"TOTAL DISPOSABLE HOUSEHOLD INCOME BEFORE SOCIAL TRANSFERS OTHER THAN OLD-AGE AND SURVIVOR'S BENEFITS",
"FLAG OF HY022",
"IMPUTATION FACTOR OF HY022",
"TOTAL DISPOSABLE HOUSEHOLD INCOME BEFORE SOCIAL TRANSFERS INCLUDING OLD-AGE AND SURVIVOR'S BENEFITS",
"FLAG OF HY023",
"IMPUTATION FACTOR OF HY023",
"IMPUTED RENT",
"FLAG OF HY030N",
"INCOME FROM RENTAL OF A PROPERTY OR LAND",
"FLAG OF HY040N",
"IMPUTATION FACTOR OF HY040N",
"FAMILY/CHILDREN-RELATED ALLOWANCES",
"FLAG OF HY050N",
"IMPUTATION FACTOR OF HY050N",
"SOCIAL EXCLUSION NOT ELSEWHERE CLASSIFIED",
"FLAG OF HY060N",
"IMPUTATION FACTOR OF HY060N",
"HOUSING ALLOWANCES",
"FLAG OF HY070N",
"IMPUTATION FACTOR OF HY070N",
"REGULAR INTER-HOUSEHOLD CASH TRANSFER RECEIVED",
"FLAG OF HY080N",
"IMPUTATION FACTOR OF HY080N",
"ALIMONIES RECEIVED (COMPULSORY + VOLUNTARY)",
"FLAG OF HY081N",
"IMPUTATION FACTOR OF HY081N",
"INTEREST, DIVIDENDS, PROFIT FROM CAPITAL INVESTMENTS IN UNINCORPORATED BUSINESS",
"FLAG OF HY090N",
"IMPUTATION FACTOR OF HY090N",
"INTEREST REPAYMENTS ON MORTGAGE",
"FLAG OF HY100N",
"IMPUTATION FACTOR OF HY100N",
"INCOME RECEIVED BY PEOPLE AGED UNDER 16",
"FLAG OF HY110N",
"IMPUTATION FACTOR OF HY110N",
"REGULAR TAXES ON WEALTH",
"FLAG OF HY120N",
"IMPUTATION FACTOR OF HY120N",
"REGULAR INTER-HOUSEHOLD CASH TRANSFER PAID",
"FLAG OF HY130N",
"IMPUTATION FACTOR OF HY130N",
"ALIMONIES PAID (COMPULSORY + VOLUNTARY)",
"FLAG OF HY131N",
"IMPUTATION FACTOR OF HY131N",
"TAX ON INCOME AND SOCIAL CONTRIBUTIONS",
"FLAG OF HY140N",
"IMPUTATION FACTOR OF HY140N",
"REPAYMENTS/RECEIPTS FOR TAX ADJUSTMENT",
"FLAG OF HY145N",
"IMPUTATION FACTOR OF HY145N",
"VALUE OF GOODS PRODUCED FOR OWN CONSUMPTION",
"FLAG OF HY170N",
"IMPUTATION FACTOR OF HY170N",
"IMPUTED RENT",
"FLAG OF HY030G",
"INCOME FROM RENTAL OF A PROPERTY OR LAND",
"FLAG OF HY040G",
"IMPUTATION FACTOR OF HY040G",
"FAMILY/CHILDREN-RELATED ALLOWANCES",
"FLAG OF HY050G",
"IMPUTATION FACTOR OF HY050G",
"FAMILY/CHILDREN-RELATED ALLOWANCES (CONTRIBUTORY AND MEANS-TESTED)",
"FLAG OF HY051G",
"FAMILY/CHILDREN-RELATED ALLOWANCES (CONTRIBUTORY AND NON MEANS-TESTED)",
"FLAG OF HY052G",
"FAMILY/CHILDREN-RELATED ALLOWANCES (NON-CONTRIBUTORY AND MEANS-TESTED)",
"FLAG OF HY053G",
"FAMILY/CHILDREN-RELATED ALLOWANCES (NON-CONTRIBUTORY AND NON MEANS-TESTED)",
"FLAG OF HY054G",
"SOCIAL EXCLUSION NOT ELSEWHERE CLASSIFIED",
"FLAG OF HY060G",
"IMPUTATION FACTOR OF HY060G",
"SOCIAL EXCLUSION NOT ELSEWHERE CLASSIFIED (CONTRIBUTORY AND MEANS-TESTED)",
"FLAG OF HY061G",
"SOCIAL EXCLUSION NOT ELSEWHERE CLASSIFIED (CONTRIBUTORY AND NON MEANS-TESTED)",
"FLAG OF HY062G",
"SOCIAL EXCLUSION NOT ELSEWHERE CLASSIFIED (NON-CONTRIBUTORY AND MEANS-TESTED)",
"FLAG OF HY063G",
"SOCIAL EXCLUSION NOT ELSEWHERE CLASSIFIED (NON-CONTRIBUTORY AND NON MEANS-TESTED)",
"FLAG OF HY064G",
"HOUSING ALLOWANCES",
"FLAG OF HY070G",
"IMPUTATION FACTOR OF HY070G",
"HOUSING ALLOWANCES (CONTRIBUTORY AND MEANS-TESTED)",
"FLAG OF HY071G",
"HOUSING ALLOWANCES (CONTRIBUTORY AND NON MEANS-TESTED)",
"FLAG OF HY072G",
"HOUSING ALLOWANCES (NON-CONTRIBUTORY AND MEANS-TESTED)",
"FLAG OF HY073G",
"HOUSING ALLOWANCES (NON-CONTRIBUTORY AND NON MEANS-TESTED)",
"FLAG OF HY074G",
"REGULAR INTER-HOUSEHOLD CASH TRANSFER RECEIVED",
"FLAG OF HY080G",
"IMPUTATION FACTOR OF HY080G",
"ALIMONIES RECEIVED (COMPULSORY + VOLUNTARY)",
"FLAG OF HY081G",
"IMPUTATION FACTOR OF HY081G",
"INTEREST, DIVIDENDS, PROFIT FROM CAPITAL INVESTMENTS IN UNINCORPORATED BUSINESS",
"FLAG OF HY090G",
"IMPUTATION FACTOR OF HY090G",
"INTEREST REPAYMENTS ON MORTGAGE",
"FLAG OF HY100G",
"IMPUTATION FACTOR OF HY100G",
"INCOME RECEIVED BY PEOPLE AGED UNDER 16",
"FLAG OF HY110G",
"IMPUTATION FACTOR OF HY110G",
"REGULAR TAXES ON WEALTH",
"FLAG OF HY120G",
"IMPUTATION FACTOR OF HY120G",
"REGULAR INTER-HOUSEHOLD CASH TRANSFER PAID",
"FLAG OF HY130G",
"IMPUTATION FACTOR OF HY130G",
"ALIMONIES PAID (COMPULSORY + VOLUNTARY)",
"FLAG OF HY131G",
"IMPUTATION FACTOR OF HY131G",
"TAX ON INCOME AND SOCIAL CONTRIBUTIONS",
"FLAG OF HY140G",
"IMPUTATION FACTOR OF HY140G",
"VALUE OF GOODS PRODUCED FOR OWN CONSUMPTION",
"FLAG OF HY170G",
"IMPUTATION FACTOR OF HY170G",
"REPLACING WORN-OUT FURNITURE",
"FLAG OF HD080",
"CHANGE RATE",
"HOUSEHOLD SIZE",
"EQUIVALISED HOUSEHOLD SIZE",
"HOUSEHOLD TYPE",
"TENURE STATUS",
"POVERTY INDICATOR",
"EQUIVALISED DISPOSABLE INCOME",
"OVERCROWDED HOUSEHOLD")

HB020_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$HB020, 
levels=c("AT", 
"BE", 
"BG", 
"CH", 
"CY", 
"CZ", 
"DE", 
"DK", 
"EE", 
"EL", 
"ES", 
"FI", 
"FR", 
"HR", 
"HU", 
"IE", 
"IS", 
"IT", 
"LT", 
"LU", 
"LV", 
"ME", 
"MK", 
"MT", 
"NL", 
"NO", 
"PL", 
"PT", 
"RO", 
"RS", 
"SE", 
"SI", 
"SK", 
"TR", 
"UK"), 
labels=c("¿sterreich", 
"Belgique/Belg¿e", 
"Bulgaria", 
"Switzerland", 
"Cyprus", 
"Czech republic", 
"Deutschland", 
"Denmark", 
"Estonia", 
"Ell¿da", 
"Espa¿a", 
"Suomi", 
"France", 
"Croatia", 
"Hungary", 
"Ireland", 
"Iceland", 
"Italia", 
"Lithuania", 
"Luxembourg", 
"Latvia", 
"Montenegro", 
"The Former Yugoslav Republic of Macedonia (FYROM)", 
"Malta", 
"Nederland", 
"Norway", 
"Poland", 
"Portugal", 
"Romania", 
"Serbia", 
"Sverige", 
"Slovenia", 
"Slovak republic", 
"Turkey", 
"United Kingdom"

HB050_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$HB050, 
levels=c(1, 
2, 
3, 
4), 
labels=c("January-March", 
"April-June", 
"July-September", 
"October-December")) 


HB050_F_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$HB050_F, 
levels=c(1, 
-1), 
labels=c("Filled", 
"Missing")) 


HB060_F_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$HB060_F, 
levels=c(1), 
labels=c("Filled")) 


HB070_F_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$HB070_F, 
levels=c(1, 
-1), 
labels=c("Filled", 
"Missing")) 


HB080_F_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$HB080_F, 
levels=c(1, 
-1), 
labels=c("Filled", 
"Missing")) 


HB090_F_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$HB090_F, 
levels=c(1, 
-1, 
-2), 
labels=c("Filled", 
"Missing", 
"Not applicable (no second person responsible for the accommodation)")) 


HB100_F_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$HB100_F, 
levels=c(1, 
-1), 
labels=c("Filled", 
"Missing")) 


HH010_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$HH010, 
levels=c(1, 
2, 
3, 
4), 
labels=c("Detached house", 
"Semi-detached or terraced house", 
"Apartment or flat in a building with less than 10 dwellings", 
"Apartment or flat in a building with 10 or more dwellings")) 


HH010_F_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$HH010_F, 
levels=c(1, 
-1), 
labels=c("Filled", 
"Missing")) 


HH021_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$HH021, 
levels=c(1, 
2, 
3, 
4, 
5), 
labels=c("Outright owner", 
"Owner paying mortgage", 
"Tenant or subtenant paying rent at prevailing or market rate", 
"Accommodation is rented at a reduced rate (lower price that the market price)", 
"Accommodation is provided free")) 


HH021_F_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$HH021_F, 
levels=c(1, 
-1), 
labels=c("Filled", 
"Missing")) 


HH030_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$HH030, 
levels=c(1, 
2, 
3, 
4, 
5, 
6), 
labels=c("1 room", 
"2 rooms", 
"3 rooms", 
"4 rooms", 
"5 rooms", 
"6 or more rooms")) 


HH030_F_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$HH030_F, 
levels=c(1, 
-1), 
labels=c("Filled", 
"Missing")) 


HH031_F_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$HH031_F, 
levels=c(1, 
-1, 
-2), 
labels=c("Filled", 
"Missing", 
"Not applicable (MS using objective national methods to calculate imputed rent)")) 


HH040_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$HH040, 
levels=c(1, 
2), 
labels=c("Yes", 
"No")) 


HH040_F_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$HH040_F, 
levels=c(1, 
-1), 
labels=c("Filled", 
"Missing")) 


HH050_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$HH050, 
levels=c(1, 
2), 
labels=c("Yes", 
"No")) 


HH050_F_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$HH050_F, 
levels=c(1, 
-1), 
labels=c("Filled", 
"Missing")) 


HH060_F_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$HH060_F, 
levels=c(1, 
-1, 
-2), 
labels=c("Filled", 
"Missing", 
"Not applicable (HH021 not equal to 3 or 4)")) 


HH061_F_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$HH061_F, 
levels=c(1, 
-1, 
-2), 
labels=c("Filled", 
"Missing", 
"Not applicable (HH021 eq 3) or (MS do not use subjective method to calculate imputed rent)")) 


HH070_F_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$HH070_F, 
levels=c(1, 
-1), 
labels=c("Filled", 
"Missing")) 


HH071_F_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$HH071_F, 
levels=c(1, 
-1, 
-2), 
labels=c("Filled", 
"Missing", 
"Not applicable (HH021 not equal 2)")) 


HH081_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$HH081, 
levels=c(1, 
2, 
3), 
labels=c("Yes, for sole use of the household", 
"Yes, shared", 
"No")) 


HH081_F_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$HH081_F, 
levels=c(1, 
-1), 
labels=c("Filled", 
"Missing")) 


HH091_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$HH091, 
levels=c(1, 
2, 
3), 
labels=c("Yes, for sole use of the household", 
"Yes, shared", 
"No")) 


HH091_F_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$HH091_F, 
levels=c(1, 
-1), 
labels=c("Filled", 
"Missing")) 


HS011_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$HS011, 
levels=c(1, 
2, 
3), 
labels=c("Yes, once", 
"Yes, twice or more", 
"No")) 


HS011_F_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$HS011_F, 
levels=c(1, 
-1, 
-2), 
labels=c("Filled", 
"Missing", 
"Not applicable (outright owner or rent free during the last 12 months)")) 


HS021_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$HS021, 
levels=c(1, 
2, 
3), 
labels=c("Yes, once", 
"Yes, twice or more", 
"No")) 


HS021_F_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$HS021_F, 
levels=c(1, 
-1, 
-2), 
labels=c("Filled", 
"Missing", 
"Not applicable (no utility bills)")) 


HS031_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$HS031, 
levels=c(1, 
2, 
3), 
labels=c("Yes, once", 
"Yes, twice or more", 
"No")) 


HS031_F_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$HS031_F, 
levels=c(1, 
-1, 
-2), 
labels=c("Filled", 
"Missing", 
"Not applicable (no hire purchase instalments and no other loan payments)")) 


HS040_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$HS040, 
levels=c(1, 
2), 
labels=c("Yes", 
"No")) 


HS040_F_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$HS040_F, 
levels=c(1, 
-1), 
labels=c("Filled", 
"Missing")) 


HS050_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$HS050, 
levels=c(1, 
2), 
labels=c("Yes", 
"No")) 


HS050_F_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$HS050_F, 
levels=c(1, 
-1), 
labels=c("Filled", 
"Missing")) 


HS060_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$HS060, 
levels=c(1, 
2), 
labels=c("Yes", 
"No")) 


HS060_F_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$HS060_F, 
levels=c(1, 
-1), 
labels=c("Filled", 
"Missing")) 


HS070_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$HS070, 
levels=c(1, 
2, 
3), 
labels=c("Yes", 
"No ¿ cannot afford", 
"No ¿ other reason"))

HS070_F_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$HS070_F, 
levels=c(1, 
-1), 
labels=c("Filled", 
"Missing")) 


HS080_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$HS080, 
levels=c(1, 
2, 
3), 
labels=c("Yes", 
"No ¿ cannot afford", 
"No ¿ other reason"))

HS080_F_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$HS080_F, 
levels=c(1, 
-1), 
labels=c("Filled", 
"Missing")) 


HS090_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$HS090, 
levels=c(1, 
2, 
3), 
labels=c("Yes", 
"No ¿ cannot afford", 
"No ¿ other reason"))

HS090_F_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$HS090_F, 
levels=c(1, 
-1), 
labels=c("Filled", 
"Missing")) 


HS100_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$HS100, 
levels=c(1, 
2, 
3), 
labels=c("Yes", 
"No ¿ cannot afford", 
"No ¿ other reason"))

HS100_F_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$HS100_F, 
levels=c(1, 
-1), 
labels=c("Filled", 
"Missing")) 


HS110_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$HS110, 
levels=c(1, 
2, 
3), 
labels=c("Yes", 
"No ¿ cannot afford", 
"No ¿ other reason"))

HS110_F_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$HS110_F, 
levels=c(1, 
-1), 
labels=c("Filled", 
"Missing")) 


HS120_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$HS120, 
levels=c(1, 
2, 
3, 
4, 
5, 
6), 
labels=c("With great difficulty", 
"With difficulty", 
"With some difficulty", 
"Fairly easily", 
"Easily", 
"Very easily")) 


HS120_F_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$HS120_F, 
levels=c(1, 
-1), 
labels=c("Filled", 
"Missing")) 


HS130_F_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$HS130_F, 
levels=c(1, 
-1), 
labels=c("Filled", 
"Missing")) 


HS140_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$HS140, 
levels=c(1, 
2, 
3), 
labels=c("A heavy burden", 
"A slight burden", 
"Not a burden at all")) 


HS140_F_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$HS140_F, 
levels=c(1, 
-1, 
-2), 
labels=c("Filled", 
"Missing", 
"Missing (no housing costs)")) 


HS150_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$HS150, 
levels=c(1, 
2, 
3), 
labels=c("Repayment is a heavy burden", 
"Repayment is somewhat a burden", 
"Repayment is not a burden at all")) 


HS150_F_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$HS150_F, 
levels=c(1, 
-1, 
-2), 
labels=c("Filled", 
"Missing", 
"Missing (no repayment of debts)")) 


HS160_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$HS160, 
levels=c(1, 
2), 
labels=c("Yes", 
"No")) 


HS160_F_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$HS160_F, 
levels=c(1, 
-1), 
labels=c("Filled", 
"Missing")) 


HS170_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$HS170, 
levels=c(1, 
2), 
labels=c("Yes", 
"No")) 


HS170_F_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$HS170_F, 
levels=c(1, 
-1), 
labels=c("Filled", 
"Missing")) 


HS180_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$HS180, 
levels=c(1, 
2), 
labels=c("Yes", 
"No")) 


HS180_F_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$HS180_F, 
levels=c(1, 
-1), 
labels=c("Filled", 
"Missing")) 


HS190_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$HS190, 
levels=c(1, 
2), 
labels=c("Yes", 
"No")) 


HS190_F_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$HS190_F, 
levels=c(1, 
-1), 
labels=c("Filled", 
"Missing")) 


HY030N_F_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$HY030N_F, 
levels=c(0, 
1, 
-1, 
-5), 
labels=c("No income", 
"Income (variable is filled)", 
"Missing (As missing values are imputed, this code is only acceptable if imputation is not possible)", 
"Not filled: variable of gross (...N) series is filled")) 


HY030G_F_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$HY030G_F, 
levels=c(0, 
1, 
-1), 
labels=c("No income", 
"Income (variable is filled)", 
"Missing (As missing values are imputed, this code is only acceptable if imputation is not possible)")) 


HY051G_F_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$HY051G_F, 
levels=c(0, 
1, 
2, 
-1, 
-2, 
-7), 
labels=c("No income", 
"Filled with only Contributory and means-tested components", 
"Filled with mixed components", 
"Missing", 
"Not applicable (This scheme doesn't exist at national level)", 
"Not applicable (HB010 ne last year)")) 


HY052G_F_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$HY052G_F, 
levels=c(0, 
1, 
2, 
-1, 
-2, 
-7), 
labels=c("No income", 
"Filled with only Contributory and non means-tested components", 
"Filled with mixed components", 
"Missing", 
"Not applicable (This scheme doesn't exist at national level)", 
"Not applicable (HB010 ne last year)")) 


HY053G_F_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$HY053G_F, 
levels=c(0, 
1, 
2, 
-1, 
-2, 
-7), 
labels=c("No income", 
"Filled with only Non-contributory and means-tested components", 
"Filled with mixed components", 
"Missing", 
"Not applicable (This scheme doesn't exist at national level)", 
"Not applicable (HB010 ne last year)")) 


HY054G_F_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$HY054G_F, 
levels=c(0, 
1, 
2, 
-1, 
-2, 
-7), 
labels=c("No income", 
"Filled with only Non-contributory and non means-tested components", 
"Filled with mixed components", 
"Missing", 
"Not applicable (This scheme doesn't exist at national level)", 
"Not applicable (HB010 ne last year)")) 


HY061G_F_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$HY061G_F, 
levels=c(0, 
1, 
2, 
-1, 
-2, 
-7), 
labels=c("No income", 
"Filled with only Contributory and means-tested components", 
"Filled with mixed components", 
"Missing", 
"Not applicable (This scheme doesn't exist at national level)", 
"Not applicable (HB010 ne last year)")) 


HY062G_F_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$HY062G_F, 
levels=c(0, 
1, 
2, 
-1, 
-2, 
-7), 
labels=c("No income", 
"Filled with only Contributory and non means-tested components", 
"Filled with mixed components", 
"Missing", 
"Not applicable (This scheme doesn't exist at national level)", 
"Not applicable (HB010 ne last year)")) 


HY063G_F_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$HY063G_F, 
levels=c(0, 
1, 
2, 
-1, 
-2, 
-7), 
labels=c("No income", 
"Filled with only Non-contributory and means-tested components", 
"Filled with mixed components", 
"Missing", 
"Not applicable (This scheme doesn't exist at national level)", 
"Not applicable (HB010 ne last year)")) 


HY064G_F_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$HY064G_F, 
levels=c(0, 
1, 
2, 
-1, 
-2, 
-7), 
labels=c("No income", 
"Filled with only Non-contributory and non means-tested components", 
"Filled with mixed components", 
"Missing", 
"Not applicable (This scheme doesn't exist at national level)", 
"Not applicable (HB010 ne last year)")) 


HY071G_F_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$HY071G_F, 
levels=c(0, 
1, 
2, 
-1, 
-2, 
-7), 
labels=c("No income", 
"Filled with only Contributory and means-tested components", 
"Filled with mixed components", 
"Missing", 
"Not applicable (This scheme doesn't exist at national level)", 
"Not applicable (HB010 ne last year)")) 


HY072G_F_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$HY072G_F, 
levels=c(0, 
1, 
2, 
-1, 
-2, 
-7), 
labels=c("No income", 
"Filled with only Contributory and non means-tested components", 
"Filled with mixed components", 
"Missing", 
"Not applicable (This scheme doesn't exist at national level)", 
"Not applicable (HB010 ne last year)")) 


HY073G_F_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$HY073G_F, 
levels=c(0, 
1, 
2, 
-1, 
-2, 
-7), 
labels=c("No income", 
"Filled with only Non-contributory and means-tested components", 
"Filled with mixed components", 
"Missing", 
"Not applicable (This scheme doesn't exist at national level)", 
"Not applicable (HB010 ne last year)")) 


HY074G_F_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$HY074G_F, 
levels=c(0, 
1, 
2, 
-1, 
-2, 
-7), 
labels=c("No income", 
"Filled with only Non-contributory and non means-tested components", 
"Filled with mixed components", 
"Missing", 
"Not applicable (This scheme doesn't exist at national level)", 
"Not applicable (HB010 ne last year)")) 


HD080_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$HD080, 
levels=c(1, 
2, 
3), 
labels=c("Yes", 
"No - household cannot afford it", 
"No - other reason")) 


HD080_F_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$HD080_F, 
levels=c(1, 
-1), 
labels=c("Filled", 
"Missing")) 


HX060_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$HX060, 
levels=c(5, 
6, 
7, 
8, 
9, 
10, 
11, 
12, 
13, 
16), 
labels=c("One person household", 
"2 adults, no dependent children, both adults under 65 years", 
"2 adults, no dependent children, at least one adult 65 years or more", 
"Other households without dependent children", 
"Single parent household, one or more dependent children", 
"2 adults, one dependent child", 
"2 adults, two dependent children", 
"2 adults, three or more dependent children", 
"Other households with dependent children", 
"Other (these household are excluded from Laeken indicators calculation)")) 


HX070_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$HX070, 
levels=c(1, 
2), 
labels=c("Owner", 
"Tenant")) 


HX080_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$HX080, 
levels=c(0, 
1), 
labels=c("Not at risk of poverty", 
"At risk of poverty")) 


HX120_Fact <- factor(DF_EUSILC_Cross_A2018_HOUSEHOLD$HX120, 
levels=c(NA, 
0, 
1), 
labels=c("Not Applicable", 
"Not overcrowded", 
"Overcrowded"), exclude=NULL) 

save.image (file="DF_EUSILC_Cross_A2018_HOUSEHOLD.RData")
