/*    LIMITAZIONE DELLA RESPONSABILITA'. 
  Il software  fornito "cos com'", senza garanzie di  sorta.               */
%macro grabpath;
%qsubstr(%sysget(SAS_EXECFILEPATH),1,%length(%sysget(SAS_EXECFILEPATH))-%length(%sysget(SAS_EXECFILEname)))
%mend grabpath;
%let path = %grabpath;
%let nomeFile =ISTAT_MFR_CensPop2011_5%_Microdati_2011_individui_ESEMPIO_STRUTTURA_FILE.txt;
LIBNAME ISTAT "&path";
DATA ISTAT.CensPop2011_5%_A2011_individui;

INFILE "&path&nomeFile" DLM='5E'x  LRECL=32767 TRUNCOVER FIRSTOBS=2 IGNOREDOSEOF;
INPUT 
ID_FAM :8.   /*  Identificativo famiglia/convivenza */
PROGR_IND :3.   /*  Identificativo dell'individuo all'interno della famiglia */
ID_IND_CONV :3.   /*  Identificativo dell'individuo in convivenza */
TIPCONV :2.   /*  Tipo di convivenza */
MOPERC :2.   /*  Motivo principale della permanenza in convivenza */
ID_ALL :8.   /*  Identificativo dell'alloggio */
REGIONE : $2.   /*  Regione di residenza (19 modalit) */
RIP_GEO : $1.   /*  Ripartizione geografica di residenza (5 modalit) */
NROCOMPO :4.   /*  Numero componenti famiglia */
TIPOLOGIA_FAM :2.   /*  Tipologia familiare */
REL_PAR :2.   /*  Relazione di parentela o di convivenza */
SESSO :1.   /*  Sesso */
ETA_CLASSI :2.   /*  Et in classi */
LUOGO_NAS :1.   /*  Luogo di nascita */
STATO_NAS :3.   /*  Codice dello stato estero di nascita */
CITTADINANZA :1.   /*  Cittadinanza */
STATO_CITT :3.   /*  Codice dello stato estero di cittadinanza */
CITT_NAS_ACQ :1.   /*  Cittadinanza italiana dalla nascita */
CITT_ITA_ACQ :1.   /*  Cittadinanza Italiana acquisita x matrimonio o altro */
LUONAS_MADRE :1.   /*  luogo di nascita della madre */
STATO_NAS_MADRE :3.   /*  Stato di nascita della madre */
LUONAS_PADRE :1.   /*  luogo di nascita del padre */
STATO_NAS_PADRE :3.   /*  Stato di nascita del padre */
RESIDENTE_ESTERO :1.   /*  E' mai stato residente all'estero */
MESE_TRASFERIMENTO :2.   /*  Mese di trasferimento */
ANNO_TRASFERIMENTO :4.   /*  Anno di trasferimento */
STATO_EST_ULT_RESID :3.   /*  Stato estero di ultima residenza */
STATO_CIV :1.   /*  Stato civile */
STATO_CIV_PREC :1.   /*  Stato civile prima dell'ultimo matrimonio */
LUOGO_PRES_CENS :1.   /*  Luogo di presenza alla data del censimento */
DIM_ANNO_PREC :1.   /*  Dimora abituale al 9 ottobre 2010 */
PROV_DIM_ANNO_PREC :1.   /*  Codice della provincia di dimora abituale al 9 ottobre 2010 */
STATO_DIM_ANNO_PREC :3.   /*  Codice dello stato estero di dimora abituale al 9 ottobre 2010 */
FREQ_SCUOLA_FIGLI :1.   /*  Tipo di frequenza scolastica del/la bambino/a */
TIT_STUD :1.   /*  Titolo di studio pi elevato */
POST_LAUREA :1.   /*  Possesso di specializzazione post laurea e/o dottorato di ricerca */
TIT_STUD_EST :1.   /*  Conseguimento all'estero del titolo di studio pi elevato */
ISCR_SCUOLA :1.   /*  Iscrizione alla scuola elementare, alla scuola media inferiore, alla scuola secondaria superiore o all'universit */
FREQ_CORSO_FORM :1.   /*  Frequenza di un corso di formazione/aggiornamento professionale */
CORSO_STAT6 :1.   /*  Tipo di corso frequentato: un corso di formazione professionale, regionale, provinciale ecc di 6 mesi. */
CORSO_STAT24 :1.   /*  Tipo di corso frequentato: un corso di formazione professionale, regionale, provinciale ecc di 24 mesi. */
COND_PROF :1.   /*  Condizione professionale o non professionale nella settimana precedente il censimento */
FATTE_ORE :1.   /*  Ore fatte */
ASSENZA_LAVORO :1.   /*  Nella settimana dal 2 all'8 ottobre aveva comunque un lavoro dal quale era assente */
CERCA_LAV :1.   /*  Nelle ultime 4 settimane, la persona ha cercato attivamente un lavoro alle dipendenze o ha predisposto i mezzi per avviare unattivit in proprio */
DISPO_LAV :1.   /*  Disponibilit ad iniziare un lavoro entro 2 settimane */
SVOLTO_LAV :1.   /*  La persona ha svolto un'attivit lavorativa retribuita, o come coadiuvante familiare, nel corso della sua vita */
CONDIZ_INATTIVI :1.   /*  Condizione degli inattivi nella settimana dal 2 all'8 ottobre */
ORE_LAV_SETT_PREC :2.   /*  Numero di ore lavorate nella settimana dal 14 al 20 ottobre 2001 */
TEMPO_PIENO :1.   /*  Tipo di attivit lavorativa */
POS_PROF :1.   /*  Posizione professionale */
HA_DIP :1.   /*  Ha dipendenti retribuiti */
LAV_A_TEMPO :1.   /*  Rapporto di lavoro a tempo indeterminato/determinato */
TIPO_LAV :2.   /*  Tipo di attivit lavorativa */
SETT_ATECO :2.   /*  Settore di attivit economica */
STUD_LAV_OGNI_G :1.   /*  La persona si reca giornalmente al luogo abituale di studio o di lavoro */
ALL_STUD_LAV :1.   /*  Da quale alloggio la persona si reca al luogo abituale di studio o di lavoro */
RIENTRA :1.   /*  La persona rientra giornalmente dal luogo abituale di studio o di lavoro */
LUOGO_STUD_LAV :1.   /*  Luogo abituale di studio o di lavoro */
REG_STUD_LAV : $2.   /*  Codice della regione di studio o di lavoro */
STATO_STUD_LAV :3.   /*  Codice dello stato estero di studio o di lavoro */
ORA_VA_STUD_LAV :2.   /*  Orario di uscita della persona per recarsi al luogo abituale di studio o di lavoro: ore */
MIN_VA_STUD_LAV :2.   /*  Orario di uscita della persona per recarsi al luogo abituale di studio o di lavoro: minuti */
TEMPO_VA_STUD_LAV :3.   /*  Tempo impiegato per recarsi al luogo abituale di studio o di lavoro */
MEZZO_TRAS_STUD_LAV :2.   /*  Mezzo di trasporto utilizzato per recarsi al luogo abituale di studio o di lavoro */
DIM_5ANNO_PREC :1.   /*  Dimora abituale al 9 ottobre 2006 */
PROV_DIM_5ANNO_PREC :1.   /*  Codice della provincia di dimora abituale al 9 ottobre 2006 */
STATO_DIM_5ANNO_PREC :3.   /*  Codice dello stato estero di dimora abituale al 9 ottobre 2006 */
IND_MODELLO : $1.   /*  Tipo modello */
;
LABEL 
ID_FAM = "Identificativo famiglia/convivenza"
PROGR_IND = "Identificativo dell'individuo all'interno della famiglia"
ID_IND_CONV = "Identificativo dell'individuo in convivenza"
TIPCONV = "Tipo di convivenza"
MOPERC = "Motivo principale della permanenza in convivenza"
ID_ALL = "Identificativo dell'alloggio"
REGIONE = "Regione di residenza (19 modalit)"
RIP_GEO = "Ripartizione geografica di residenza (5 modalit)"
NROCOMPO = "Numero componenti famiglia"
TIPOLOGIA_FAM = "Tipologia familiare"
REL_PAR = "Relazione di parentela o di convivenza"
SESSO = "Sesso"
ETA_CLASSI = "Et in classi"
LUOGO_NAS = "Luogo di nascita"
STATO_NAS = "Codice dello stato estero di nascita"
CITTADINANZA = "Cittadinanza"
STATO_CITT = "Codice dello stato estero di cittadinanza"
CITT_NAS_ACQ = "Cittadinanza italiana dalla nascita"
CITT_ITA_ACQ = "Cittadinanza Italiana acquisita x matrimonio o altro"
LUONAS_MADRE = "luogo di nascita della madre"
STATO_NAS_MADRE = "Stato di nascita della madre"
LUONAS_PADRE = "luogo di nascita del padre"
STATO_NAS_PADRE = "Stato di nascita del padre"
RESIDENTE_ESTERO = "E' mai stato residente all'estero"
MESE_TRASFERIMENTO = "Mese di trasferimento"
ANNO_TRASFERIMENTO = "Anno di trasferimento"
STATO_EST_ULT_RESID = "Stato estero di ultima residenza"
STATO_CIV = "Stato civile"
STATO_CIV_PREC = "Stato civile prima dell'ultimo matrimonio"
LUOGO_PRES_CENS = "Luogo di presenza alla data del censimento"
DIM_ANNO_PREC = "Dimora abituale al 9 ottobre 2010"
PROV_DIM_ANNO_PREC = "Codice della provincia di dimora abituale al 9 ottobre 2010"
STATO_DIM_ANNO_PREC = "Codice dello stato estero di dimora abituale al 9 ottobre 2010"
FREQ_SCUOLA_FIGLI = "Tipo di frequenza scolastica del/la bambino/a"
TIT_STUD = "Titolo di studio pi elevato"
POST_LAUREA = "Possesso di specializzazione post laurea e/o dottorato di ricerca"
TIT_STUD_EST = "Conseguimento all'estero del titolo di studio pi elevato"
ISCR_SCUOLA = "Iscrizione alla scuola elementare, alla scuola media inferiore, alla scuola secondaria superiore o all'universit"
FREQ_CORSO_FORM = "Frequenza di un corso di formazione/aggiornamento professionale"
CORSO_STAT6 = "Tipo di corso frequentato: un corso di formazione professionale, regionale, provinciale ecc di 6 mesi."
CORSO_STAT24 = "Tipo di corso frequentato: un corso di formazione professionale, regionale, provinciale ecc di 24 mesi."
COND_PROF = "Condizione professionale o non professionale nella settimana precedente il censimento"
FATTE_ORE = "Ore fatte"
ASSENZA_LAVORO = "Nella settimana dal 2 all'8 ottobre aveva comunque un lavoro dal quale era assente"
CERCA_LAV = "Nelle ultime 4 settimane, la persona ha cercato attivamente un lavoro alle dipendenze o ha predisposto i mezzi per avviare unattivit in proprio"
DISPO_LAV = "Disponibilit ad iniziare un lavoro entro 2 settimane"
SVOLTO_LAV = "La persona ha svolto un'attivit lavorativa retribuita, o come coadiuvante familiare, nel corso della sua vita"
CONDIZ_INATTIVI = "Condizione degli inattivi nella settimana dal 2 all'8 ottobre"
ORE_LAV_SETT_PREC = "Numero di ore lavorate nella settimana dal 14 al 20 ottobre 2001"
TEMPO_PIENO = "Tipo di attivit lavorativa"
POS_PROF = "Posizione professionale"
HA_DIP = "Ha dipendenti retribuiti"
LAV_A_TEMPO = "Rapporto di lavoro a tempo indeterminato/determinato"
TIPO_LAV = "Tipo di attivit lavorativa"
SETT_ATECO = "Settore di attivit economica"
STUD_LAV_OGNI_G = "La persona si reca giornalmente al luogo abituale di studio o di lavoro"
ALL_STUD_LAV = "Da quale alloggio la persona si reca al luogo abituale di studio o di lavoro"
RIENTRA = "La persona rientra giornalmente dal luogo abituale di studio o di lavoro"
LUOGO_STUD_LAV = "Luogo abituale di studio o di lavoro"
REG_STUD_LAV = "Codice della regione di studio o di lavoro"
STATO_STUD_LAV = "Codice dello stato estero di studio o di lavoro"
ORA_VA_STUD_LAV = "Orario di uscita della persona per recarsi al luogo abituale di studio o di lavoro: ore"
MIN_VA_STUD_LAV = "Orario di uscita della persona per recarsi al luogo abituale di studio o di lavoro: minuti"
TEMPO_VA_STUD_LAV = "Tempo impiegato per recarsi al luogo abituale di studio o di lavoro"
MEZZO_TRAS_STUD_LAV = "Mezzo di trasporto utilizzato per recarsi al luogo abituale di studio o di lavoro"
DIM_5ANNO_PREC = "Dimora abituale al 9 ottobre 2006"
PROV_DIM_5ANNO_PREC = "Codice della provincia di dimora abituale al 9 ottobre 2006"
STATO_DIM_5ANNO_PREC = "Codice dello stato estero di dimora abituale al 9 ottobre 2006"
IND_MODELLO = "Tipo modello"
;
RUN;
PROC FORMAT;
VALUE TIP3F /* TIPCONV */
1= "Istituti di istruzione"
2= "Presidi residenziali per minori"
3= "Istituti assistenziali per disabili fisici e psichici"
4= "Ospizi, case di riposo per adulti inabili ed anziani"
5= "Strutture di accoglienza per immigrati"
6= "Altri istituti assistenziali"
7= "Pubblici"
8= "Privati"
9= "Istituti penitenziari"
10= "Convivenze ecclesiastiche"
11= "Convivenze militari e corpi accasermati"
12= "Alberghi, pensioni, locande e simili"
14= "Altre convivenze"
;
VALUE MOP4F /* MOPERC */
1= "Responsabile o dirigente della convivenza"
2= "Addetto all'assistenza sanitaria"
3= "Addetto all'assistenza sociale o psicologica"
4= "Addetto ai servizi amministrativi o ordinari"
5= "Addetto ai servizi di manutenzione, di pulizia e altri servizi"
6= "Religioso"
7= "Militare di carriera, agente e simili"
8= "Detenuto con condanna definitiva"
9= "Assistito in un centro di accoglienza per immigrati"
10= "Ricoverato lungodegente in un istituto di cura"
11= "Assistito in istituto per anziani"
12= "Assistito in istituto per minori"
13= "Assistito in altro centro di accoglienza"
14= "Altro"
;
VALUE $REG6F /* REGIONE */
"1" = "Piemonte-Valle d'Aosta"
"3" = "Lombardia"
"4" = "Trentino-Alto Adige"
"5" = "Veneto"
"6" = "Friuli-Venezia Giulia"
"7" = "Liguria"
"8" = "Emilia-Romagna"
"9" = "Toscana"
"10" = "Umbria"
"11" = "Marche"
"12" = "Lazio"
"13" = "Abruzzo"
"14" = "Molise"
"15" = "Campania"
"16" = "Puglia"
"17" = "Basilicata"
"18" = "Calabria"
"19" = "Sicilia"
"20" = "Sardegna"
;
VALUE $RIP7F /* RIP_GEO */
"1" = "Nord-ovest"
"2" = "Nord-est"
"3" = "Centro"
"4" = "Sud"
"5" = "Isole"
;
VALUE NRO8F /* NROCOMPO */
1= "1"
2= "2"
3= "3"
4= "4"
5= "5"
6= "6"
;
VALUE TIP9F /* TIPOLOGIA_FAM */
1= "Famiglie senza nuclei"
2= "Non in coabitazione"
3= "In coabitazione"
4= "Famiglie con un solo nucleo"
5= "Coppie senza figli"
6= "Coppie con figli"
7= "Madre con figli"
8= "Padre con figli"
9= "Coppie senza figli"
10= "Coppie con figli"
11= "Madre con figli"
12= "Padre con figli"
13= "Famiglie con due o pi nuclei"
;
VALUE REL10F /* REL_PAR */
1= "Intestatario del Foglio di famiglia"
2= "Coniuge dellintestatario"
3= "Convivente in coppia con lintestatario"
4= "Figlio/a dellintestatario e del coniuge/convivente"
5= "Figlio/a del solo intestatario"
6= "Figlio/a del solo coniuge/convivente"
7= "Genitore (o coniuge/convivente del genitore) dellintestatario"
8= "Suocero/a dellintestatario"
9= "Fratello/sorella dellintestatario"
10= "Fratello/sorella del coniuge/convivente"
11= "Coniuge/convivente del fratello/sorella dellintestatario o del fratello/sorella del coniuge/convivente"
12= "Genero/nuora (coniuge/convivente del figlio/a) dellintestatario e/o del coniuge/convivente"
13= "Nipote (figlio/a di un figlio/a) dellintestatario e/o del coniuge/convivente"
14= "Nipote (figlio/a di un fratello/sorella) dellintestatario e/o del coniuge/convivente"
15= "Nonno/a dellintestatario o del coniuge/convivente"
16= "Altro parente dellintestatario e/o del coniuge/convivente"
17= "Altra persona coabitante senza legami di coppia, parentela o affinit"
;
VALUE SES11F /* SESSO */
1= "Maschio"
2= "Femmina"
;
VALUE ETA12F /* ETA_CLASSI */
1= "0-2"
2= "3-5"
3= "6-10"
4= "11-14"
5= "15"
6= "16"
7= "17"
8= "18"
9= "19"
10= "20"
11= "21"
12= "22"
13= "23"
14= "24"
15= "25"
16= "26"
17= "27"
18= "28"
19= "29"
20= "30"
21= "31"
22= "32"
23= "33"
24= "34"
25= "35"
26= "36"
27= "37"
28= "38"
29= "39"
30= "40"
31= "41"
32= "42"
33= "43"
34= "44"
35= "45"
36= "46"
37= "47"
38= "48"
39= "49"
40= "50"
41= "51"
42= "52"
43= "53"
44= "54"
45= "55"
46= "56"
47= "57"
48= "58"
49= "59"
50= "60"
51= "61"
52= "62"
53= "63"
54= "64"
55= "65"
56= "66"
57= "67"
58= "68"
59= "69"
60= "70"
61= "71"
62= "72"
63= "73"
64= "74"
65= "75+"
;
VALUE LUO13F /* LUOGO_NAS */
1= "Nello stesso Comune di residenza"
2= "In altro Comune della stessa Provincia"
3= "In altra Provincia della stessa Regione"
4= "In altre Regioni"
5= "Estero"
;
VALUE STA14F /* STATO_NAS */
11= "Ue_27"
12= "Europa centro-orientale"
13= "Altri Paesi europei"
200= "Africa"
300= "Asia"
400= "America"
500= "Oceania"
;
VALUE CIT15F /* CITTADINANZA */
1= "Italiana"
2= "Straniera"
3= "Apolide"
;
VALUE STA16F /* STATO_CITT */
11= "Ue_27"
12= "Europa centro-orientale"
13= "Altri Paesi europei"
200= "Africa"
300= "Asia"
400= "America"
500= "Oceania"
600= "Apolide"
;
VALUE CIT17F /* CITT_NAS_ACQ */
1= "Si"
2= "No"
;
VALUE CIT18F /* CITT_ITA_ACQ */
1= "Matrimonio"
2= "Altro"
;
VALUE LUO19F /* LUONAS_MADRE */
1= "Italia"
2= "Estero"
;
VALUE STA20F /* STATO_NAS_MADRE */
11= "Ue_27"
12= "Europa centro-orientale"
13= "Altri Paesi europei"
200= "Africa"
300= "Asia"
400= "America"
500= "Oceania"
;
VALUE LUO21F /* LUONAS_PADRE */
1= "Italia"
2= "Estero"
;
VALUE STA22F /* STATO_NAS_PADRE */
11= "Ue_27"
12= "Europa centro-orientale"
13= "Altri Paesi europei"
200= "Africa"
300= "Asia"
400= "America"
500= "Oceania"
;
VALUE RES23F /* RESIDENTE_ESTERO */
1= "Si"
2= "No"
;
VALUE MES24F /* MESE_TRASFERIMENTO */
1= "Gennaio"
2= "Febbraio"
3= "Marzo"
4= "Aprile"
5= "Maggio"
6= "Giugno"
7= "Luglio"
8= "Agosto"
9= "Settembre"
10= "Ottobre"
11= "Novembre"
12= "Dicembre"
;
VALUE STA26F /* STATO_EST_ULT_RESID */
11= "Ue_27"
12= "Europa centro-orientale"
13= "Altri Paesi europei"
200= "Africa"
300= "Asia"
400= "America"
500= "Oceania"
;
VALUE STA27F /* STATO_CIV */
1= "Celibe/nubile"
2= "Coniugato/a"
3= "Separato/a di fatto"
4= "Separato/a legalmente"
5= "Divorziato/a"
6= "Vedovo/a"
;
VALUE STA28F /* STATO_CIV_PREC */
1= "Celibe/nubile"
2= "Divorziato/a"
3= "Vedovo/a"
;
VALUE LUO29F /* LUOGO_PRES_CENS */
1= "In questo alloggio"
2= "In questo comune, ma in un altro alloggio o convivenza"
3= "In un altro comune italiano"
4= "All'estero"
;
VALUE DIM30F /* DIM_ANNO_PREC */
1= "In questo alloggio"
2= "In questo comune, ma in un altro alloggio o convivenza"
3= "In un altro comune italiano"
4= "All'estero"
;
VALUE PRO31F /* PROV_DIM_ANNO_PREC */
1= "Nello stesso Comune di residenza"
2= "In altro Comune della stessa Provincia"
3= "In altra Provincia della stessa Regione"
4= "In altre Regioni"
5= "Estero"
;
VALUE STA32F /* STATO_DIM_ANNO_PREC */
11= "Ue_27"
12= "Europa centro-orientale"
13= "Altri Paesi europei"
200= "Africa"
300= "Asia"
400= "America"
500= "Oceania"
;
VALUE FRE33F /* FREQ_SCUOLA_FIGLI */
1= "Asilo nido, microasilo, baby-parking, etc.(3-36 mesi)"
2= "scuola dell'infanzia"
3= "Prima elementare"
4= "n asilo, n scuola infanzia, n prima elementare"
;
VALUE TIT34F /* TIT_STUD */
1= "Analfabeti o Licenza Elementare"
2= "Licenza Media"
3= "Diploma scolastico di qualifica (corso scolastico di 2-3 anni)"
4= "Diploma di maturit (corso scolastico di 4-5 anni)"
5= "Diploma terziario di tipo non universitario"
6= "Diploma universitario"
7= "Diploma di Laurea"
;
VALUE POS35F /* POST_LAUREA */
1= "master di I livello"
2= "master di II livello"
3= "scuola di specializzazione"
4= "dottorato di ricerca"
;
VALUE TIT36F /* TIT_STUD_EST */
1= "Si"
2= "No"
;
VALUE ISC37F /* ISCR_SCUOLA */
1= "Si"
2= "No"
;
VALUE FRE38F /* FREQ_CORSO_FORM */
1= "Si"
2= "No"
;
VALUE COR39F /* CORSO_STAT6 */
1= "Si"
2= "No"
;
VALUE COR40F /* CORSO_STAT24 */
1= "Si"
2= "No"
;
VALUE CON41F /* COND_PROF */
1= "Occupato/a"
2= "In cerca di prima occupazione"
3= "Disoccupata (in cerca di nuova occupazione)"
4= "Percettore/rice di una o pi pensioni per effetto di attivit lavorativa precedente o di redditi da capitale"
5= "Studente/ssa"
6= "Casalinga/o"
7= "In altra condizione"
;
VALUE FAT42F /* FATTE_ORE */
1= "Si"
2= "No"
;
VALUE ASS43F /* ASSENZA_LAVORO */
1= "Si"
2= "No"
;
VALUE CER44F /* CERCA_LAV */
1= "Si"
2= "No"
;
VALUE DIS45F /* DISPO_LAV */
1= "Si"
2= "No"
;
VALUE SVO46F /* SVOLTO_LAV */
1= "Si"
2= "No"
;
VALUE CON47F /* CONDIZ_INATTIVI */
1= "Percettore/rice di una o pi pensioni per effetto di attivit lavorativa precedente o di redditi da capitale"
2= "Studente/ssa"
3= "Casalinga/o"
4= "In altra condizione"
;
VALUE TEM49F /* TEMPO_PIENO */
1= "Tempo pieno"
2= "Tempo parziale"
;
VALUE POS50F /* POS_PROF */
1= "Imprenditore"
2= "Libero professionista"
3= "Lavoratore in proprio"
4= "Socio di cooperativa"
5= "Coadiuvante familiare"
6= "Dipendenti"
7= "Parasubordinati"
;
VALUE HA_51F /* HA_DIP */
1= "Si"
2= "No"
;
VALUE LAV52F /* LAV_A_TEMPO */
1= "A tempo indeterminato"
2= "A tempo determinato"
;
VALUE TIP53F /* TIPO_LAV */
1= "Lavoro operaio o di servizio non qualificato"
2= "Addetto/a a impianti fissi di produzione, a macchinari, a linee di montaggio o conduzione di  veicoli"
3= "Attivit operaia qualificata"
4= "Coltivazione di piante e/o allevamento di animali"
5= "Attivit di vendita al pubblico o di servizio alle persone"
6= "Lavoro esecutivo d'ufficio"
7= "Attivit tecnica, amministrativa, sportiva o artistica a media qualificazione"
8= "Attivit organizzativa, tecnica, intellettuale, scientifica o artistica ad elevata specializzazione"
9= "Gestione di un'impresa o dirigenza di strutture organizzative complesse pubbliche o private"
10= "Militare di qualsiasi grado nelle forze armate- Esercito, Marina, Aeronautica, Carabinieri"
;
VALUE SET54F /* SETT_ATECO */
1= "Agricoltura, silvicoltura, caccia e pesca"
2= "Attivit estrattive da cave o miniere e servizi di supporto allestrazione"
3= "Attivit manifatturiere e riparazione, manutenzione e installazione di macchine e apparecchiature"
4= "Fornitura di energia elettrica, gas, vapore e aria condizionata"
5= "Fornitura di acqua, gestione delle reti fognarie, attivit di gestione dei rifiuti e attivit di risanamento"
6= "Costruzioni edili, opere pubbliche e installazione dei servizi nei fabbricati"
7= "Commercio allingrosso e al dettaglio e riparazione di autoveicoli e motocicli"
8= "Trasporti (di passeggeri o merci attraverso condotte, su strada, per via d'acqua o aereo) magazzinaggio, servizi postali e attivit di corrieri"
9= "Attivit dei servizi di alloggio e di ristorazione"
10= "Servizi di informazione e comunicazione"
11= "Attivit finanziarie e assicurative"
12= "Attivit immobiliari"
13= "Attivit professionali, scientifiche e tecniche"
14= "Noleggio, agenzie di viaggio, servizi di supporto alle imprese"
15= "Pubblica amministrazione centrale e locale, difesa e assicurazione sociale obbligatoria"
16= "Istruzione e formazione pubblica e privata"
17= "Sanit e assistenza sociale residenziale e non residenziale"
18= "Attivit artistiche, sportive, di intrattenimento e divertimento"
19= "Altre attivit di servizi e riparazioni di beni per uso personale e per la casa"
20= "Attivit di famiglie e convivenze come datori di lavoro per personale domestico"
21= "Organizzazioni e organismi extraterritoriali"
;
VALUE STU55F /* STUD_LAV_OGNI_G */
1= "Si, si reca al luogo di studio (compresi corsi di formazione professionale)"
2= "Si, si reca al luogo di lavoro"
3= "No, perch studia nel proprio alloggio"
4= "No, perch lavora nel proprio alloggio"
5= "No, perch non ha una sede fissa di lavoro (piazzisti, rappresentanti, ecc.)"
6= "No, perch non studia o non lavora o non frequenta corsi di formazione professionale"
;
VALUE ALL56F /* ALL_STUD_LAV */
1= "Da questo alloggio"
2= "Da un altro alloggio diverso da questo"
;
VALUE RIE57F /* RIENTRA */
1= "Si"
2= "No"
;
VALUE LUO58F /* LUOGO_STUD_LAV */
1= "Nello stesso Comune di residenza"
2= "In altro Comune della stessa Provincia"
3= "In altra Provincia della stessa Regione"
4= "In altre Regioni"
5= "Estero"
;
VALUE $REG59F /* REG_STUD_LAV */
"1" = "Piemonte-Valle d'Aosta"
"3" = "Lombardia"
"4" = "Trentino-Alto Adige"
"5" = "Veneto"
"6" = "Friuli-Venezia Giulia"
"7" = "Liguria"
"8" = "Emilia-Romagna"
"9" = "Toscana"
"10" = "Umbria"
"11" = "Marche"
"12" = "Lazio"
"13" = "Abruzzo"
"14" = "Molise"
"15" = "Campania"
"16" = "Puglia"
"17" = "Basilicata"
"18" = "Calabria"
"19" = "Sicilia"
"20" = "Sardegna"
;
VALUE STA60F /* STATO_STUD_LAV */
11= "Ue_27"
12= "Europa centro-orientale"
13= "Altri Paesi europei"
200= "Africa"
300= "Asia"
400= "America"
500= "Oceania"
;
VALUE MEZ64F /* MEZZO_TRAS_STUD_LAV */
1= "Treno"
2= "Tram"
3= "Metropolitana"
4= "Autobus urbano, filobus"
5= "Corriera, autobus extra-urbano"
6= "Autobus aziendale o scolastico"
7= "Auto privata (come conducente)"
8= "Auto privata (come passeggero)"
9= "Motocicletta, ciclomotore, scooter"
10= "Bicicletta"
11= "Altro mezzo (battello, funivia, ecc.)"
12= "A piedi"
;
VALUE DIM65F /* DIM_5ANNO_PREC */
1= "In questo alloggio"
2= "In questo comune, ma in altro alloggio o convivenza"
3= "In altro comune"
4= "Estero"
;
VALUE PRO66F /* PROV_DIM_5ANNO_PREC */
1= "Stesso comune di residenza"
2= "In altro comune stessa provincia"
3= "In altra provincia stessa regione"
4= "in altra regione"
5= "Estero"
;
VALUE STA67F /* STATO_DIM_5ANNO_PREC */
11= "Ue_27"
12= "Europa centro-orientale"
13= "Altri Paesi europei"
200= "Africa"
300= "Asia"
400= "America"
500= "Oceania"
;
VALUE $IND68F /* IND_MODELLO */
"C" = "Convivenze"
"L" = "Long"
;
format TIPCONV TIP3F.;
format MOPERC MOP4F.;
format REGIONE $REG6F.;
format RIP_GEO $RIP7F.;
format NROCOMPO NRO8F.;
format TIPOLOGIA_FAM TIP9F.;
format REL_PAR REL10F.;
format SESSO SES11F.;
format ETA_CLASSI ETA12F.;
format LUOGO_NAS LUO13F.;
format STATO_NAS STA14F.;
format CITTADINANZA CIT15F.;
format STATO_CITT STA16F.;
format CITT_NAS_ACQ CIT17F.;
format CITT_ITA_ACQ CIT18F.;
format LUONAS_MADRE LUO19F.;
format STATO_NAS_MADRE STA20F.;
format LUONAS_PADRE LUO21F.;
format STATO_NAS_PADRE STA22F.;
format RESIDENTE_ESTERO RES23F.;
format MESE_TRASFERIMENTO MES24F.;
format STATO_EST_ULT_RESID STA26F.;
format STATO_CIV STA27F.;
format STATO_CIV_PREC STA28F.;
format LUOGO_PRES_CENS LUO29F.;
format DIM_ANNO_PREC DIM30F.;
format PROV_DIM_ANNO_PREC PRO31F.;
format STATO_DIM_ANNO_PREC STA32F.;
format FREQ_SCUOLA_FIGLI FRE33F.;
format TIT_STUD TIT34F.;
format POST_LAUREA POS35F.;
format TIT_STUD_EST TIT36F.;
format ISCR_SCUOLA ISC37F.;
format FREQ_CORSO_FORM FRE38F.;
format CORSO_STAT6 COR39F.;
format CORSO_STAT24 COR40F.;
format COND_PROF CON41F.;
format FATTE_ORE FAT42F.;
format ASSENZA_LAVORO ASS43F.;
format CERCA_LAV CER44F.;
format DISPO_LAV DIS45F.;
format SVOLTO_LAV SVO46F.;
format CONDIZ_INATTIVI CON47F.;
format TEMPO_PIENO TEM49F.;
format POS_PROF POS50F.;
format HA_DIP HA_51F.;
format LAV_A_TEMPO LAV52F.;
format TIPO_LAV TIP53F.;
format SETT_ATECO SET54F.;
format STUD_LAV_OGNI_G STU55F.;
format ALL_STUD_LAV ALL56F.;
format RIENTRA RIE57F.;
format LUOGO_STUD_LAV LUO58F.;
format REG_STUD_LAV $REG59F.;
format STATO_STUD_LAV STA60F.;
format MEZZO_TRAS_STUD_LAV MEZ64F.;
format DIM_5ANNO_PREC DIM65F.;
format PROV_DIM_5ANNO_PREC PRO66F.;
format STATO_DIM_5ANNO_PREC STA67F.;
format IND_MODELLO $IND68F.;
RUN;
