/*    LIMITAZIONE DELLA RESPONSABILITA'. 
  Il software  fornito "cos com'", senza garanzie di  sorta.               */
%macro grabpath;
%qsubstr(%sysget(SAS_EXECFILEPATH),1,%length(%sysget(SAS_EXECFILEPATH))-%length(%sysget(SAS_EXECFILEname)))
%mend grabpath;
%let path = %grabpath;
%let nomeFile =ISTAT_MFR_CensPop2011_5%_Microdati_2011_alloggi_ESEMPIO_STRUTTURA_FILE.txt;
LIBNAME ISTAT "&path";
DATA ISTAT.CensPop2011_5%_A2011_alloggi;

INFILE "&path&nomeFile" DLM='5E'x  LRECL=32767 TRUNCOVER FIRSTOBS=2 IGNOREDOSEOF;
INPUT 
ID_ALL :8.   /*  Identificativo univoco alloggio */
TITGOD :1.   /*  Titolo di godimento dell'abitazione */
PROPR :1.   /*  Proprietario dell'abitazione */
TIPALL :1.   /*  Specie di alloggio */
NSTAN :2.   /*  Numero di stanze */
STANPROFRIC :1.   /*  Stanze ad uso professionale */
CUCSTARIC :1.   /*  Cucina con caratteristica di stanza */
CUCINI :1.   /*  L'abitazione dispone di un cucinino */
ANGCOT :1.   /*  L'abitazione dispone di un angolo cottura */
NOCUCINA :1.   /*  Non dispone di cucina, cucinino, angolo cottura */
NPIANI :1.   /*  Numero piani dell'abitazione */
SUPERF :3.   /*  Superficie in mq dell'abitazione */
ACQDOT :1.   /*  L'abitazione dispone di acqua potabile da acquedotto */
POZZO :1.   /*  L'abitazione dispone di acqua potabile da pozzo */
ALTFON :1.   /*  L'abitazione dispone di acqua potabile da altra fonte di approvvigionamento */
NONPOT :1.   /*  L'abitazione dispone di acqua non potabile */
NOACQ :1.   /*  Non dispone di acqua al suo interno */
VASDOCRIC :1.   /*  Numero di impianti doccia e vasche da  bagno disponibili */
GABINRIC :1.   /*  Numero di gabinetti disponibili nell'abitazione */
ACQCAL :1.   /*  L'abitazione dispone di acqua calda in bagno e/o in cucina */
RISACQ :1.   /*  Lacqua calda  prodotta dallo stesso impianto che  utilizzato per il riscaldamento dellabitazione */
AMETAN :1.   /*  Metano e gas naturale sono combustibili usati per riscaldare l'acqua */
AELETT :1.   /*  Energia elettrica e' il combustibile usato per riscaldare l'acqua */
ASOLAR :1.   /*  Energia solare e' il combustibile usato per riscaldare l'acqua */
AALTRO :1.   /*  Altro combustibile usato per riscaldare l'acqua */
IMPCEN :1.   /*  L'abitazione dispone di impianto centralizzato ad uso di pi abitazioni */
FISAUT :1.   /*  L'abitazione dispone di impianto fisso autonomo ad uso esclusivo dellabitazione */
SINFIS :1.   /*  L'abitazione dispone di apparecchi singoli fissi che consentono il riscaldamento di tutta o della maggior parte dellabitazione */
SIFISP :1.   /*  L'abitazione dispone di apparecchi singoli fissi che consentono il riscaldamento solo di alcune parti dellabitazione */
RMETAN :1.   /*  Metano e gas naturale sono combustibili usati per riscaldare l'abitazione */
RGASOL :1.   /*  Il gasolio e' un combustibile usato per riscaldare l'abitazione */
RGPL :1.   /*  Il GPL  e' un combustibile usato per riscaldare l'abitazione */
COMBSOL :1.   /*  Combustibile Solido */
RELETT :1.   /*  L'energia elettrica e' un combustibile usato per riscaldare l'abitazione */
ROLIO :1.   /*  L'olio e' un combustibile usato per riscaldare l'abitazione */
ALTCOM :1.   /*  E' usato altro combustibile o energia  per riscaldare l'abitazione */
ENERINN :1.   /*  Impianto ad energia rinnovabile */
ARIACON :1.   /*  Impianto fisso aria condizionata */
POSTAUTORIC :2.   /*  Posti auto privati */
AUTOMOB :1.   /*  Automobili */
TELFISSO :1.   /*  Labitazione dispone di almeno una linea telefonica fissa attiva */
CELLULAR :1.   /*  telefono cellulare */
NCOMPCELL :2.   /*  componenti famiglia con telefono cellulare */
CONN :1.   /*  Connessione Internet */
CONTRAD :1.   /*  Linea telefonica tradizionale o ISDN */
ADSL :1.   /*  ADSL */
ALTRACON :1.   /*  Altra connessione a banda larga */
INTKEY :1.   /*  Internet Key, Palmare, Cellulare */
;
LABEL 
ID_ALL = "Identificativo univoco alloggio"
TITGOD = "Titolo di godimento dell'abitazione"
PROPR = "Proprietario dell'abitazione"
TIPALL = "Specie di alloggio"
NSTAN = "Numero di stanze"
STANPROFRIC = "Stanze ad uso professionale"
CUCSTARIC = "Cucina con caratteristica di stanza"
CUCINI = "L'abitazione dispone di un cucinino"
ANGCOT = "L'abitazione dispone di un angolo cottura"
NOCUCINA = "Non dispone di cucina, cucinino, angolo cottura"
NPIANI = "Numero piani dell'abitazione"
SUPERF = "Superficie in mq dell'abitazione"
ACQDOT = "L'abitazione dispone di acqua potabile da acquedotto"
POZZO = "L'abitazione dispone di acqua potabile da pozzo"
ALTFON = "L'abitazione dispone di acqua potabile da altra fonte di approvvigionamento"
NONPOT = "L'abitazione dispone di acqua non potabile"
NOACQ = "Non dispone di acqua al suo interno"
VASDOCRIC = "Numero di impianti doccia e vasche da  bagno disponibili"
GABINRIC = "Numero di gabinetti disponibili nell'abitazione"
ACQCAL = "L'abitazione dispone di acqua calda in bagno e/o in cucina"
RISACQ = "Lacqua calda  prodotta dallo stesso impianto che  utilizzato per il riscaldamento dellabitazione"
AMETAN = "Metano e gas naturale sono combustibili usati per riscaldare l'acqua"
AELETT = "Energia elettrica e' il combustibile usato per riscaldare l'acqua"
ASOLAR = "Energia solare e' il combustibile usato per riscaldare l'acqua"
AALTRO = "Altro combustibile usato per riscaldare l'acqua"
IMPCEN = "L'abitazione dispone di impianto centralizzato ad uso di pi abitazioni"
FISAUT = "L'abitazione dispone di impianto fisso autonomo ad uso esclusivo dellabitazione"
SINFIS = "L'abitazione dispone di apparecchi singoli fissi che consentono il riscaldamento di tutta o della maggior parte dellabitazione"
SIFISP = "L'abitazione dispone di apparecchi singoli fissi che consentono il riscaldamento solo di alcune parti dellabitazione"
RMETAN = "Metano e gas naturale sono combustibili usati per riscaldare l'abitazione"
RGASOL = "Il gasolio e' un combustibile usato per riscaldare l'abitazione"
RGPL = "Il GPL  e' un combustibile usato per riscaldare l'abitazione"
COMBSOL = "Combustibile Solido"
RELETT = "L'energia elettrica e' un combustibile usato per riscaldare l'abitazione"
ROLIO = "L'olio e' un combustibile usato per riscaldare l'abitazione"
ALTCOM = "E' usato altro combustibile o energia  per riscaldare l'abitazione"
ENERINN = "Impianto ad energia rinnovabile"
ARIACON = "Impianto fisso aria condizionata"
POSTAUTORIC = "Posti auto privati"
AUTOMOB = "Automobili"
TELFISSO = "Labitazione dispone di almeno una linea telefonica fissa attiva"
CELLULAR = "telefono cellulare"
NCOMPCELL = "componenti famiglia con telefono cellulare"
CONN = "Connessione Internet"
CONTRAD = "Linea telefonica tradizionale o ISDN"
ADSL = "ADSL"
ALTRACON = "Altra connessione a banda larga"
INTKEY = "Internet Key, Palmare, Cellulare"
;
RUN;
PROC FORMAT;
VALUE TIT1F /* TITGOD */
1= "Propriet (totale o parziale), usufrutto o riscatto"
2= "Affitto"
3= "Altro Titolo"
;
VALUE PRO2F /* PROPR */
1= "persona fisica"
2= "impresa o societ"
3= "cooperativa edilizia di abitazione"
4= "stato, regione, provincia"
5= "comune"
6= "ente previdenziale"
7= "istituto autonomo case popolari"
8= "altro"
;
VALUE TIP3F /* TIPALL */
1= "Abitazione"
2= "Altro tipo di alloggio"
4= "Struttura residenziale collettiva"
;
VALUE STA5F /* STANPROFRIC */
0= "0"
1= "1"
2= "2"
3= "3"
4= "+ di 3"
;
VALUE CUC6F /* CUCSTARIC */
0= "0"
1= "1"
2= "2 o pi"
;
VALUE CUC7F /* CUCINI */
1= "Si"
2= "No"
;
VALUE ANG8F /* ANGCOT */
1= "Si"
2= "No"
;
VALUE NOC9F /* NOCUCINA */
1= "Si"
2= "No"
;
VALUE NPI10F /* NPIANI */
1= "1"
2= "2"
3= "3"
4= "pi di 3"
;
VALUE SUP11F /* SUPERF */
10= "0-14"
20= "15-24"
30= "25-34"
40= "35-44"
50= "45-54"
60= "55-64"
70= "65-74"
80= "75-84"
90= "85-94"
100= "95-104"
110= "105-114"
120= "115-124"
130= "125-134"
140= "135-144"
150= "145 +"
;
VALUE ACQ12F /* ACQDOT */
1= "Si"
2= "No"
;
VALUE POZ13F /* POZZO */
1= "Si"
2= "No"
;
VALUE ALT14F /* ALTFON */
1= "Si"
2= "No"
;
VALUE NON15F /* NONPOT */
1= "Si"
2= "No"
;
VALUE NOA16F /* NOACQ */
1= "Si"
2= "No"
;
VALUE VAS17F /* VASDOCRIC */
0= "0"
1= "1"
2= "2"
3= "3"
4= "pi di 3"
;
VALUE GAB18F /* GABINRIC */
0= "0"
1= "1"
2= "2"
3= "3"
4= "pi di 3"
;
VALUE ACQ19F /* ACQCAL */
1= "Si"
2= "No"
;
VALUE RIS20F /* RISACQ */
1= "Si"
2= "No"
;
VALUE AME21F /* AMETAN */
1= "Si"
2= "No"
;
VALUE AEL22F /* AELETT */
1= "Si"
2= "No"
;
VALUE ASO23F /* ASOLAR */
1= "Si"
2= "No"
;
VALUE AAL24F /* AALTRO */
1= "Si"
2= "No"
;
VALUE IMP25F /* IMPCEN */
1= "Si"
2= "No"
;
VALUE FIS26F /* FISAUT */
1= "Si"
2= "No"
;
VALUE SIN27F /* SINFIS */
1= "Si"
2= "No"
;
VALUE SIF28F /* SIFISP */
1= "Si"
2= "No"
;
VALUE RME29F /* RMETAN */
1= "Si"
2= "No"
;
VALUE RGA30F /* RGASOL */
1= "Si"
2= "No"
;
VALUE RGP31F /* RGPL */
1= "Si"
2= "No"
;
VALUE COM32F /* COMBSOL */
1= "Si"
2= "No"
;
VALUE REL33F /* RELETT */
1= "Si"
2= "No"
;
VALUE ROL34F /* ROLIO */
1= "Si"
2= "No"
;
VALUE ALT35F /* ALTCOM */
1= "Si"
2= "No"
;
VALUE ENE36F /* ENERINN */
1= "Si"
2= "No"
;
VALUE ARI37F /* ARIACON */
1= "Si"
2= "No"
;
VALUE AUT39F /* AUTOMOB */
1= "1"
2= "2 o pi"
3= "Nessuna"
;
VALUE TEL40F /* TELFISSO */
1= "Si"
2= "No"
;
VALUE CEL41F /* CELLULAR */
1= "Si"
2= "No"
;
VALUE CON43F /* CONN */
1= "Si"
2= "No"
;
VALUE CON44F /* CONTRAD */
1= "Si"
2= "No"
;
VALUE ADS45F /* ADSL */
1= "Si"
2= "No"
;
VALUE ALT46F /* ALTRACON */
1= "Si"
2= "No"
;
VALUE INT47F /* INTKEY */
1= "Si"
2= "No"
;
format TITGOD TIT1F.;
format PROPR PRO2F.;
format TIPALL TIP3F.;
format STANPROFRIC STA5F.;
format CUCSTARIC CUC6F.;
format CUCINI CUC7F.;
format ANGCOT ANG8F.;
format NOCUCINA NOC9F.;
format NPIANI NPI10F.;
format SUPERF SUP11F.;
format ACQDOT ACQ12F.;
format POZZO POZ13F.;
format ALTFON ALT14F.;
format NONPOT NON15F.;
format NOACQ NOA16F.;
format VASDOCRIC VAS17F.;
format GABINRIC GAB18F.;
format ACQCAL ACQ19F.;
format RISACQ RIS20F.;
format AMETAN AME21F.;
format AELETT AEL22F.;
format ASOLAR ASO23F.;
format AALTRO AAL24F.;
format IMPCEN IMP25F.;
format FISAUT FIS26F.;
format SINFIS SIN27F.;
format SIFISP SIF28F.;
format RMETAN RME29F.;
format RGASOL RGA30F.;
format RGPL RGP31F.;
format COMBSOL COM32F.;
format RELETT REL33F.;
format ROLIO ROL34F.;
format ALTCOM ALT35F.;
format ENERINN ENE36F.;
format ARIACON ARI37F.;
format AUTOMOB AUT39F.;
format TELFISSO TEL40F.;
format CELLULAR CEL41F.;
format CONN CON43F.;
format CONTRAD CON44F.;
format ADSL ADS45F.;
format ALTRACON ALT46F.;
format INTKEY INT47F.;
RUN;
