/*    LIMITAZIONE DELLA RESPONSABILITA'. 
  Il software è fornito "così com'è", senza garanzie di  sorta.              
%macro grabpath;
%qsubstr(%sysget(SAS_EXECFILEPATH),1,%length(%sysget(SAS_EXECFILEPATH))-%length(%sysget(SAS_EXECFILEname)))
%mend grabpath;
%let path = %grabpath;
%let nomeFile =ISTAT_MFR_VV_Microdati_2018_Viaggi_ESEMPIO_STRUTTURA_FILE.txt;
LIBNAME ISTAT "&path";
DATA ISTAT.VV_A2018_Viaggi;

INFILE "&path&nomeFile" DLM='09'x  LRECL=32767 TRUNCOVER FIRSTOBS=2 IGNOREDOSEOF;
INPUT 
tr : $2.   /*  tipo record */
mese : $2.   /*  mese di riferimento dei dati */
annrif : $4.   /*  anno di riferimento dei dati */
progind : $5.   /*  Numero d'ordine progressivo dell'individuo nell'anno */
sesso : $1.   /*  sesso */
eta5 : $2.   /*  classi di et� in anni compiuti 
staciv : $1.   /*  stato civile */
pnasc : $1.   /*  paese di nascita */
reg : $3.   /*  regione di residenza */
rip : $1.   /*  ripartizione geografica di residenza */
istr : $2.   /*  titolo di studio pi� alto conseguito 
condogg : $2.   /*  condizione professionale oggettiva */
posiz : $2.   /*  posizione nella professione */
ateco10 : $2.   /*  settore di attivit� economica 
cond : $2.   /*  condizione professionale soggettiva */
ORARIO : $1.   /*  tipo di orario di lavoro */
RAPP : $1.   /*  tipo di rapporto di lavoro */
CODPROF : $1.   /*  codifica della professione lavorativa (Grandi gruppi) */
progvia : $2.   /*  numero progressivo del viaggio effettuato dallo stesso individuo */
TIPOVGG : $5.   /*  tipologia, mese e anno di riferimento del viaggio */
DEST_RE : $3.   /*  regione italiana o stato estero dell'UE di destinazione principale o macro-area geografica non UE */
DEST_PR : $3.   /*  provincia italiana di destinazione principale */
DEST_IE : $1.   /*  destinazione principale: italia/estero */
GGINIZ : $2.   /*  giorno di inizio del viaggio */
MMINIZ : $2.   /*  mese di inizio del viaggio */
AAINIZ : $4.   /*  anno di inizio del viaggio */
DURATA : $3.   /*  durata del viaggio in numero di notti */
MOTVAC : $2.   /*  motivo prevalente della vacanza */
MEZZO : $2.   /*  principale mezzo di trasporto utilizzato */
ALLOG : $2.   /*  principale tipo di alloggio utilizzato */
MOTLAV : $2.   /*  motivo prevalente del viaggio di lavoro */
ORGALL : $1.   /*  organizzazione alloggio */
ORGTRA : $1.   /*  organizzazione trasporto */
ALPART : $1.   /*  filtro: se hanno partecipato al viaggio altri componenti della famiglia */
IORGALL : $1.   /*  utilizzo di internet per prenotare l'alloggio */
IORGTRA : $1.   /*  utilizzo di internet per prenotare il trasporto */
TIPOMARE : $1.   /*  tipo luogo=mare */
TIPOCROC : $1.   /*  tipo luogo=crociera */
TIPOMONT : $1.   /*  tipo luogo=montagna */
TIPOCITTA : $1.   /*  tipo luogo=citt� 
TIPOCAMP : $1.   /*  tipo luogo=campagna */
TIPOALTRO : $1.   /*  tipo luogo=altro */
W :19.7   /*  coefficiente di riporto per le stime di viaggi, escursioni e individui (turisti e non turisti) nel mese medio del trimestre */
COEV :19.7   /*  coefficiente di riporto per il calcolo dell'ammontare dei viaggi (abituali e non abituali) ed escursioni nel mese, nel trimestre e nell'anno */
TRIM : $2.   /*  trimestre di riferimento dei dati */
DOMINIO : $1.   /*  tipologia socio-demografica del comune di residenza */
npart : $2.   /*  numero componenti della famiglia di fatto partecipanti al viaggio */
TIPO : $2.   /*  tipo di attivit� principale svolta durante la vacanza 
ESPE_CO :9.   /*  Spesa media per viaggio */
ESPE_GIO :5.   /*  Spesa media giornaliera del viaggio */
;
LABEL 
tr = "tipo record"
mese = "mese di riferimento dei dati"
annrif = "anno di riferimento dei dati"
progind = "Numero d'ordine progressivo dell'individuo nell'anno"
sesso = "sesso"
eta5 = "classi di et� in anni compiut
staciv = "stato civile"
pnasc = "paese di nascita"
reg = "regione di residenza"
rip = "ripartizione geografica di residenza"
istr = "titolo di studio pi� alto conseguit
condogg = "condizione professionale oggettiva"
posiz = "posizione nella professione"
ateco10 = "settore di attivit� economic
cond = "condizione professionale soggettiva"
ORARIO = "tipo di orario di lavoro"
RAPP = "tipo di rapporto di lavoro"
CODPROF = "codifica della professione lavorativa (Grandi gruppi)"
progvia = "numero progressivo del viaggio effettuato dallo stesso individuo"
TIPOVGG = "tipologia, mese e anno di riferimento del viaggio"
DEST_RE = "regione italiana o stato estero dell'UE di destinazione principale o macro-area geografica non UE"
DEST_PR = "provincia italiana di destinazione principale"
DEST_IE = "destinazione principale: italia/estero"
GGINIZ = "giorno di inizio del viaggio"
MMINIZ = "mese di inizio del viaggio"
AAINIZ = "anno di inizio del viaggio"
DURATA = "durata del viaggio in numero di notti"
MOTVAC = "motivo prevalente della vacanza"
MEZZO = "principale mezzo di trasporto utilizzato"
ALLOG = "principale tipo di alloggio utilizzato"
MOTLAV = "motivo prevalente del viaggio di lavoro"
ORGALL = "organizzazione alloggio"
ORGTRA = "organizzazione trasporto"
ALPART = "filtro: se hanno partecipato al viaggio altri componenti della famiglia"
IORGALL = "utilizzo di internet per prenotare l'alloggio"
IORGTRA = "utilizzo di internet per prenotare il trasporto"
TIPOMARE = "tipo luogo=mare"
TIPOCROC = "tipo luogo=crociera"
TIPOMONT = "tipo luogo=montagna"
TIPOCITTA = "tipo luogo=citt
TIPOCAMP = "tipo luogo=campagna"
TIPOALTRO = "tipo luogo=altro"
W = "coefficiente di riporto per le stime di viaggi, escursioni e individui (turisti e non turisti) nel mese medio del trimestre"
COEV = "coefficiente di riporto per il calcolo dell'ammontare dei viaggi (abituali e non abituali) ed escursioni nel mese, nel trimestre e nell'anno"
TRIM = "trimestre di riferimento dei dati"
DOMINIO = "tipologia socio-demografica del comune di residenza"
npart = "numero componenti della famiglia di fatto partecipanti al viaggio"
TIPO = "tipo di attivit� principale svolta durante la vacanz
ESPE_CO = "Spesa media per viaggio"
ESPE_GIO = "Spesa media giornaliera del viaggio"
;
RUN;
PROC FORMAT;
VALUE $tr0F /* tr */
"02" = "Record individuale"
"03" = "Record viaggi"
"04" = "Record escursioni"
;
VALUE $ses4F /* sesso */
"1" = "Maschi"
"2" = "Femmine"
;
VALUE $eta5F /* eta5 */
"01" = "<=5 anni"
"02" = "6-14 anni"
"03" = "15-17 anni"
"04" = "18-24 anni"
"05" = "25-29 anni"
"06" = "30-34 anni"
"07" = "35-39 anni"
"08" = "40-44 anni"
"09" = "45-49 anni"
"10" = "50-54 anni"
"11" = "55-59 anni"
"12" = "60-64 anni"
"13" = "65-69 anni"
"14" = "70-74 anni"
"15" = ">=75 anni"
;
VALUE $sta6F /* staciv */
"1" = "Celibe/nubile'"
"2" = "Coniugato'"
"3" = "Separato di fatto"
"4" = "Separato legalmente"
"5" = "Divorziato"
"6" = "Vedovo"
;
VALUE $pna7F /* pnasc */
"1" = "Italia"
"2" = "Estero"
;
VALUE $reg8F /* reg */
"010" = "Piemonte"
"020" = "Valle d'Aosta/Vallée d'Aoste
"030" = "Lombardia"
"040" = "Trentino A.Adige/Sudtirol"
"050" = "Veneto"
"060" = "Friuli-Venezia Giulia"
"070" = "Liguria"
"080" = "Emilia-Romagna"
"090" = "Toscana"
"100" = "Umbria"
"110" = "Marche"
"120" = "Lazio"
"130" = "Abruzzo"
"140" = "Molise"
"150" = "Campania"
"160" = "Puglia"
"170" = "Basilicata"
"180" = "Calabria"
"190" = "Sicilia"
"200" = "Sardegna"
;
VALUE $rip9F /* rip */
"1" = "Nord-ovest"
"2" = "Nord-est"
"3" = "Centro"
"4" = "Sud"
"5" = "Isole"
;
VALUE $ist10F /* istr */
"01" = "Nessun titolo"
"02" = "Licenza elementare"
"03" = "Licenza media (licenza di avviamento professionale)"
"04" = "Titolo di istruzione secondaria superiore che non permette l'accesso all'università
"05" = "Diploma di istruzione secondaria superiore che permette l'accesso all'università
"06" = "Diploma terziario extra-universitario (AFAM: Accademia di belle arti, Istituto superiore di industrie artistiche,Accademia naz. di arte drammatica, Conservatorio musicale e istituto musicale pareggiat"
"07" = "Diploma universitario (corso di diploma universitario, istituto superiore di educazione fisica, scuola diretta a fini speciali, scuola parauniversitaria)"
"08" = "Laurea di primo livello - nuovo ordinamento (corsi di 3 anni)"
"09" = "Diploma di laurea - vecchio ordinamento (corsi di 4/6 anni)"
"10" = "Laurea specialistica a ciclo unico - nuovo ordinamento (corsi di 5/6 anni)"
"11" = "Laurea specialistica - nuovo ordinamento (corsi di secondo livello di 2 anni)"
"12" = "Titolo di studio post-laurea o post-AFAM (diploma di specializzazione, master universitario di 1° e di 2° livello
"13" = "Titolo di dottore di ricerca"
;
VALUE $con11F /* condogg */
"01" = "Occupato"
"02" = "In cerca di occupazione"
"03" = "Inattivo"
;
VALUE $pos12F /* posiz */
"01" = "Dirigente"
"02" = "Quadro"
"03" = "Impiegato"
"04" = "Operaio"
"05" = "Apprendista"
"06" = "Lavorante a domicilio per conto dimprese
"07" = "Imprenditore"
"08" = "Libero professionista"
"09" = "Lavoratore in proprio"
"10" = "Socio di cooperativa"
"11" = "Coadiuvante nell'azienda di un familiare"
"12" = "Collaboratore coordinato e continuativo (con o senza progetto)"
"13" = "Prestatore d'opera occasionale"
;
VALUE $ate13F /* ateco10 */
"01" = "Agricoltura, caccia e pesca'"
"02" = "Industria'"
"03" = "Costruzioni'"
"04" = "Commercio, trasporto, magazzinaggio, alberghi, ristoranti'"
"05" = "Informazione e comunicazione'"
"06" = "Attività finanziarie'
"07" = "Attività immobiliari'
"08" = "Attività professionali, scientifiche, attività amministrative, servizi di support
"09" = "Pubblica amministrazione, Difesa, Istruzione, Sanità, altri servizi sociali'
"10" = "Altri servizi'"
;
VALUE $con14F /* cond */
"01" = "Occupato"
"02" = "In cerca di prima occupazione"
"03" = "In cerca di nuova occupazione"
"04" = "Casalinga"
"05" = "Studente"
"06" = "Persona ritirata dal lavoro"
"07" = "In altra condizione"
;
VALUE $ORA15F /* ORARIO */
"1" = "A tempo pieno"
"2" = "A tempo parziale"
;
VALUE $RAP16F /* RAPP */
"1" = "A tempo determinato"
"2" = "A tempo indeterminato"
;
VALUE $COD17F /* CODPROF */
"1" = "LEGISLATORI, IMPRENDITORI E ALTA DIRIGENZA"
"2" = "PROFESSIONI INTELLETTUALI, SCIENTIFICHE E DI ELEVATA SPECIALIZZAZIONE"
"3" = "PROFESSIONI TECNICHE"
"4" = "PROFESSIONI ESECUTIVE NEL LAVORO D'UFFICIO"
"5" = "PROFESSIONI QUALIFICATE NELLE ATTIVITA COMMERCIALI E NEI SERVIZI
"6" = "ARTIGIANI, OPERAI SPECIALIZZATI E AGRICOLTORI"
"7" = "CONDUTTORI DI IMPIANTI, OPERAI DI MACCHINARI FISSI E MOBILI E CONDUCENTI DI VEICOLI"
"8" = "PROFESSIONI NON QUALIFICATE"
"9" = "FORZE ARMATE"
;
VALUE $TIP19F /* TIPOVGG */
"L0118" = "viaggio di lavoro concluso a gennaio 2018"
"L0218" = "viaggio di lavoro concluso a febbraio 2018"
"L0318" = "viaggio di lavoro concluso a marzo 2018"
"L0418" = "viaggio di lavoro concluso ad aprile 2018"
"L0518" = "viaggio di lavoro concluso a maggio 2018"
"L0618" = "viaggio di lavoro concluso a giugno 2018"
"L0718" = "viaggio di lavoro concluso a luglio 2018"
"L0818" = "viaggio di lavoro concluso ad agosto 2018"
"L0918" = "viaggio di lavoro concluso a settembre 2018"
"L1018" = "viaggio di lavoro concluso a ottobre 2018"
"L1118" = "viaggio di lavoro concluso a novembre 2018"
"L1218" = "viaggio di lavoro concluso a dicembre 20018"
"V0118" = "viaggio di vacanza concluso a gennaio 2018"
"V0218" = "viaggio di vacanza concluso a febbraio 2018"
"V0318" = "viaggio di vacanza concluso a marzo 2018"
"V0418" = "viaggio di vacanza concluso ad aprile 20018"
"V0518" = "viaggio di vacanza concluso a maggio 2018"
"V0618" = "viaggio di vacanza concluso a giugno 2018"
"V0718" = "viaggio di vacanza concluso a luglio 2018"
"V0818" = "viaggio di vacanza concluso ad agosto 20018"
"V0918" = "viaggio di vacanza concluso a settembre 2018"
"V1018" = "viaggio di vacanza concluso a ottobre 2018"
"V1118" = "viaggio di vacanza concluso a novembre 2018"
"V1218" = "viaggio di vacanza concluso a dicembre 2018"
;
VALUE $DES20F /* DEST_RE */
"001" = "Piemonte"
"002" = "Valle d'Aosta-Vallée d'Aoste
"003" = "Lombardia"
"004" = "Trentino-Alto Adige"
"005" = "Veneto"
"006" = "Friuli-Venezia Giulia"
"007" = "Liguria"
"008" = "Emilia-Romagna"
"009" = "Toscana"
"010" = "Umbria"
"011" = "Marche"
"012" = "Lazio"
"013" = "Abruzzo"
"014" = "Molise"
"015" = "Campania"
"016" = "Puglia"
"017" = "Basilicata"
"018" = "Calabria"
"019" = "Sicilia"
"020" = "Sardegna"
"121" = "Austria"
"122" = "Belgio"
"123" = "Danimarca"
"124" = "Finlandia"
"125" = "Francia"
"126" = "Germania"
"127" = "Grecia"
"128" = "Irlanda"
"130" = "Lussemburgo"
"132" = "Olanda"
"133" = "Polonia"
"134" = "Portogallo"
"135" = "Regno Unito"
"136" = "Repubblica Ceca"
"137" = "Repubblica Slovacca"
"138" = "Spagna"
"139" = "Svezia"
"142" = "Ungheria"
"159" = "Bulgaria"
"161" = "Cipro"
"163" = "Estonia"
"164" = "Latvia"
"165" = "Lituania"
"166" = "Malta"
"167" = "Romania"
"169" = "Slovenia"
"172" = "Croazia"
"200" = "Paesi non UE"
"300" = "Nord America"
"400" = "Centro-Sud America"
"500" = "Africa"
"600" = "Asia&Oceania"
;
VALUE $DES21F /* DEST_PR */
"096" = "Biella"
"001" = "Torino"
"002" = "Vercelli"
"003" = "Novara"
"004" = "Cuneo"
"005" = "Asti"
"006" = "Alessandria"
"007" = "Valle d'Aosta/Vallée d'Aoste
"008" = "Imperia"
"009" = "Savona"
"010" = "Genova"
"011" = "La Spezia"
"012" = "Varese"
"013" = "Como"
"014" = "Sondrio"
"015" = "Milano"
"016" = "Bergamo"
"017" = "Brescia"
"018" = "Pavia"
"019" = "Cremona"
"020" = "Mantova"
"021" = "Bolzano/Bozen"
"022" = "Trento"
"023" = "Verona"
"024" = "Vicenza"
"025" = "Belluno"
"026" = "Treviso"
"027" = "Venezia"
"028" = "Padova"
"029" = "Rovigo"
"030" = "Udine"
"031" = "Gorizia"
"032" = "Trieste"
"033" = "Piacenza"
"034" = "Parma"
"035" = "Reggio nell'Emilia"
"036" = "Modena"
"037" = "Bologna"
"038" = "Ferrara"
"039" = "Ravenna"
"040" = "Forlì-Cesena
"041" = "Pesaro e Urbino"
"042" = "Ancona"
"043" = "Macerata"
"044" = "Ascoli Piceno"
"045" = "Massa-Carrara"
"046" = "Lucca"
"047" = "Pistoia"
"048" = "Firenze"
"049" = "Livorno"
"050" = "Pisa"
"051" = "Arezzo"
"052" = "Siena"
"053" = "Grosseto"
"054" = "Perugia"
"055" = "Terni"
"056" = "Viterbo"
"057" = "Rieti"
"058" = "Roma"
"059" = "Latina"
"060" = "Frosinone"
"061" = "Caserta"
"062" = "Benevento"
"063" = "Napoli"
"064" = "Avellino"
"065" = "Salerno"
"066" = "L'Aquila"
"067" = "Teramo"
"068" = "Pescara"
"069" = "Chieti"
"070" = "Campobasso"
"071" = "Foggia"
"072" = "Bari"
"073" = "Taranto"
"074" = "Brindisi"
"075" = "Lecce"
"076" = "Potenza"
"077" = "Matera"
"078" = "Cosenza"
"079" = "Catanzaro"
"080" = "Reggio di Calabria"
"081" = "Trapani"
"082" = "Palermo"
"083" = "Messina"
"084" = "Agrigento"
"085" = "Caltanissetta"
"086" = "Enna"
"087" = "Catania"
"088" = "Ragusa"
"089" = "Siracusa"
"090" = "Sassari"
"091" = "Nuoro"
"092" = "Cagliari"
"093" = "Pordenone"
"094" = "Isernia"
"095" = "Oristano"
"097" = "Lecco"
"098" = "Lodi"
"099" = "Rimini"
"100" = "Prato"
"101" = "Crotone"
"102" = "Vibo Valentia"
"103" = "Verbano-Cusio-Ossola"
"104" = "Olbia-Tempio"
"105" = "Ogliastra"
"106" = "Medio Campidano"
"107" = "Carbonia-Iglesias"
"108" = "Monza e della Brianza"
"109" = "Fermo"
"110" = "Barletta-Andria-Trani"
"999" = "Non sa"
;
VALUE $DES22F /* DEST_IE */
"1" = "Italia"
"2" = "Estero"
;
VALUE $MOT27F /* MOTVAC */
"01" = "Piacere, svago, vacanza"
"02" = "Visita a parenti e/o amici"
"03" = "Motivo religiosio, pellegrinaggio"
"04" = "Trattamento di salute, cura termale"
;
VALUE $MEZ28F /* MEZZO */
"01" = "Aereo"
"02" = "Treno"
"03" = "Nave, battello, motoscafo"
"04" = "Auto a noleggio"
"05" = "Auto propria, di parenti/amici"
"06" = "Pullman turistico"
"07" = "Pullman di linea"
"08" = "Camper, autocaravan"
"09" = "Moto, Motoscooter"
"10" = "Altro"
;
VALUE $ALL29F /* ALLOG */
"01" = "Albergo/motel/pensione"
"02" = "Residenza per cure fisiche ed estetiche"
"03" = "Campo lavoro e vacanza"
"04" = "Mezzo pubblico di trasporto"
"05" = "Centro congressi e conferenze"
"06" = "Villaggio vacanza"
"07" = "Campeggio"
"08" = "Marina (Barca in porto, darsena)"
"09" = "Istituto religioso"
"10" = "Altra struttura collettiva"
"11" = "Stanza in affitto"
"12" = "Abitazione in affitto"
"13" = "Abitazione in proprieta o multiprop."
"14" = "Abitazione di parenti o amici gratuita"
"15" = "Barca in sito non organizzato"
"16" = "Altro tipo di sistemazione privata"
"17" = "Agriturismo"
"18" = "Bed&breakfast"
;
VALUE $MOT30F /* MOTLAV */
"01" = "Partecipazione a congresso, convegno, conferenza, seminario"
"02" = "Partecipazione a riunione daffari"
"03" = "Esibizione, fiera, mostra, esposizione (visita e/o partecipaz. Professionale)"
"04" = "Missione di lavoro o militare (amministrazione pubblica e/o privata, organismo internazionale, altra istituzione)"
"05" = "Viaggio o meeting dazienda per la familiarizzazione dei dipendenti e/o soci (inclusi viaggi di incentivazione)"
"06" = "Attivita di rappresentanza, vendita, acquisto, pubblicita, installazione, collaudo, manutenzione, riparazione, ecc."
"07" = "Attivita culturale, artistica, religiosa, sportiva"
"08" = "Attivita di docenza (didattica, consulenza, istruzioni)"
"09" = "Partecipazione (allievo) a corso di lingua straniera"
"10" = "Partecipazione (allievo) a corso di aggiornamento professionale (esclusa lingua straniera)"
"11" = "Attivita del personale viaggiante a bordo di mezzi per il trasporto di persone e/o merci"
"12" = "Altro motivo"
"13" = "Attività nel settore dell'edilizia e dell'artigianato
"14" = "Attività di controllo e ispezione
;
VALUE $ORG31F /* ORGALL */
"1" = "Prenot. diretta"
"2" = "Prenot. in agenzia/tour operator"
"3" = "Nessuna prenotazione"
"4" = "Non sa/non risponde"
;
VALUE $ORG32F /* ORGTRA */
"1" = "Prenot. diretta"
"2" = "Prenot. in agenzia/tour operator"
"3" = "Nessuna prenotazione"
"4" = "Non sa/non risponde"
;
VALUE $ALP33F /* ALPART */
"1" = "si"
"2" = "no"
;
VALUE $IOR34F /* IORGALL */
"1" = "SI"
"2" = "NO"
"3" = "NON SA"
;
VALUE $IOR35F /* IORGTRA */
"1" = "SI"
"2" = "NO"
"3" = "NON SA"
;
VALUE $TIP36F /* TIPOMARE */
"1" = "si"
"2" = "no"
;
VALUE $TIP37F /* TIPOCROC */
"1" = "si"
"2" = "no"
;
VALUE $TIP38F /* TIPOMONT */
"1" = "si"
"2" = "no"
;
VALUE $TIP39F /* TIPOCITTA */
"1" = "si"
"2" = "no"
;
VALUE $TIP40F /* TIPOCAMP */
"1" = "si"
"2" = "no"
;
VALUE $TIP41F /* TIPOALTRO */
"1" = "si"
"2" = "no"
;
VALUE $TRI44F /* TRIM */
"01" = "Gennaio-Marzo"
"02" = "Aprile-Giugno"
"03" = "Luglio-Settembre"
"04" = "Ottobre-Dicembre"
;
VALUE $DOM45F /* DOMINIO */
"1" = "Comuni centro dell'area metropolitana"
"2" = "Comuni periferia dell'area metropolitana e comuni con 50.001 ab. e più
"3" = "Altri comuni fino a 50.000 ab."
;
VALUE $npa46F /* npart */
"01" = "1"
"02" = "2"
"03" = "3"
"04" = "4"
"05" = "5 e più partecipanti
;
VALUE $TIP47F /* TIPO */
"01" = "Visita a patrimonio artistico/monumentale/archeologico"
"02" = "Visita a bellezze naturali del luogo"
"03" = "Trattamenti di salute/benessere/beauty farm/spa"
"04" = "Shopping"
"05" = "Vacanza studio"
"06" = "Vacanza sport (settimana bianca, caccia o pesca, scuola di vela, rafting, ballo)"
"07" = "Pratica di hobby (escluso sport)"
"08" = "Vacanza enogastronomica"
"09" = "Partecipazione a manifestazioni sportive (come spettatore)"
"10" = "Partecipazione a manifestazioni culturali/folkloristiche/spettacoli/mostre (come spettatore)"
"11" = "Parchi divertimento, parchi avventura, parchi tematici (zoo, acquario, giardino botanico, ecc)"
"12" = "Divertimento, riposo o relax"
"13" = "Volontariato"
;
format tr $tr0F.;
format sesso $ses4F.;
format eta5 $eta5F.;
format staciv $sta6F.;
format pnasc $pna7F.;
format reg $reg8F.;
format rip $rip9F.;
format istr $ist10F.;
format condogg $con11F.;
format posiz $pos12F.;
format ateco10 $ate13F.;
format cond $con14F.;
format ORARIO $ORA15F.;
format RAPP $RAP16F.;
format CODPROF $COD17F.;
format TIPOVGG $TIP19F.;
format DEST_RE $DES20F.;
format DEST_PR $DES21F.;
format DEST_IE $DES22F.;
format MOTVAC $MOT27F.;
format MEZZO $MEZ28F.;
format ALLOG $ALL29F.;
format MOTLAV $MOT30F.;
format ORGALL $ORG31F.;
format ORGTRA $ORG32F.;
format ALPART $ALP33F.;
format IORGALL $IOR34F.;
format IORGTRA $IOR35F.;
format TIPOMARE $TIP36F.;
format TIPOCROC $TIP37F.;
format TIPOMONT $TIP38F.;
format TIPOCITTA $TIP39F.;
format TIPOCAMP $TIP40F.;
format TIPOALTRO $TIP41F.;
format TRIM $TRI44F.;
format DOMINIO $DOM45F.;
format npart $npa46F.;
format TIPO $TIP47F.;
RUN;
