/*  I valori delle label nelle variabili categoriche sono commentati a causa della presenza di codici non esclusivamente numerici. Comunque sono completamente documentati.  */
clear all
infile  using  PGM_2007_Primo_trimestre_IT_DELIMITED.dct, clear
/*
label define  trim_071_cl1 1   "Primo trimestre" 2   "Secondo trimestre" 3   "Terzo trimestre" 4   "Quarto trimestre"  
label define  reg_071_cl2 01   "Piemonte" 02   "Valle d'Aosta" 03   "Lombardia" 04   "Trentino alto Adige" 05   "Veneto" 06   "Friuli Venezia Giulia" 07   "Liguria" 08   "Emilia Romagna" 09   "Toscana" 10   "Umbria" 11   "Marche" 12   "Lazio" 13   "Abruzzo" 14   "Molise" 15   "Campania" 16   "Puglia" 17   "Basilicata" 18   "Calabria" 19   "Sicilia" 20   "Sardegna"  
label define  codpro_071_cl3 001   "TORINO" 002   "VERCELLI" 003   "NOVARA" 004   "CUNEO" 005   "ASTI" 006   "ALESSANDRIA" 007   "AOSTA" 008   "IMPERIA" 009   "SAVONA" 010   "GENOVA" 011   "LA SPEZIA" 012   "VARESE" 013   "COMO" 014   "SONDRIO" 015   "MILANO" 016   "BERGAMO" 017   "BRESCIA" 018   "PAVIA" 019   "CREMONA" 020   "MANTOVA" 021   "BOLZANO" 022   "TRENTO" 023   "VERONA" 024   "VICENZA" 025   "BELLUNO" 026   "TREVISO" 027   "VENEZIA" 028   "PADOVA" 029   "ROVIGO" 030   "UDINE" 031   "GORIZIA" 032   "TRIESTE" 033   "PIACENZA" 034   "PARMA" 035   "REGGIO NELL'EMILIA" 036   "MODENA" 037   "BOLOGNA" 038   "FERRARA" 039   "RAVENNA" 040   "FORLI' - CESENA" 041   "PESARO E URBINO" 042   "ANCONA" 043   "MACERATA" 044   "ASCOLI PICENO" 045   "MASSA - CARRARA" 046   "LUCCA" 047   "PISTOIA" 048   "FIRENZE" 049   "LIVORNO" 050   "PISA" 051   "AREZZO" 052   "SIENA" 053   "GROSSETO" 054   "PERUGIA" 055   "TERNI" 056   "VITERBO" 057   "RIETI" 058   "ROMA" 059   "LATINA" 060   "FROSINONE" 061   "CASERTA" 062   "BENEVENTO" 063   "NAPOLI" 064   "AVELLINO" 065   "SALERNO" 066   "L'AQUILA" 067   "TERAMO" 068   "PESCARA" 069   "CHIETI" 070   "CAMPOBASSO" 071   "FOGGIA" 072   "BARI" 073   "TARANTO" 074   "BRINDISI" 075   "LECCE" 076   "POTENZA" 077   "MATERA" 078   "COSENZA" 079   "CATANZARO" 080   "REGGIO DI CALABRIA" 081   "TRAPANI" 082   "PALERMO" 083   "MESSINA" 084   "AGRIGENTO" 085   "CALTANISSETTA" 086   "ENNA" 087   "CATANIA" 088   "RAGUSA" 089   "SIRACUSA" 090   "SASSARI" 091   "NUORO" 092   "CAGLIARI" 093   "PORDENONE" 094   "ISERNIA" 095   "ORISTANO" 096   "BIELLA" 097   "LECCO" 098   "LODI" 099   "RIMINI" 100   "PRATO" 101   "CROTONE" 102   "VIBO VALENTIA" 103   "VERBANO-CUSIO-OSSOLA"  
label define  sg11_071_cl5 1   "Maschio" 2   "Femmina"  
label define  sg13_071_cl6 1   "In Italia" 2   "All'Estero"  
label define  sg16_071_cl7 1   "S" 2   "No"  
label define  sg24_071_cl9 01   "Nessun titolo" 02   "Licenza elementare" 03   "Licenza media (o avviamento professionale)" 04   "Diploma di scuola superiore di 2-3 anni che non permette l'iscrizione all'Universita'" 05   "Diploma di scuola superiore di 4-5 anni che permette l'iscrizione all'Universit" 06   "Accademia Belle Arti, Istituto Superiore Industrie Artistiche, Accademia di arte drammatica, Perfezionamento Accademia di Danza, Perfezionamento Conservatorio e Istituto Musica Pareggiato, Scuola Inte" 07   "Diploma universitario, Laurea breve (vecchio ordinamento), Scuola diretta a fini speciali, Scuola parauniversitaria" 08   "Laurea di 3 anni di primo livello (nuovo ordinamento)" 09   "Laurea specialistica di 2 anni di secondo livello (nuovo ordinamento)" 10   "Laurea di 4 anni o pi (vecchio ordinamento o nuova laurea specialistica" 11   "Specializzazione post-laurea (compresi master di 1 e 2 livello)" 12   "Dottorato di ricerca"  
label define  b1_071_cl10 1   "Si" 2   "No" 3   "Permanentemente inabile al lavoro"  
label define  b2_071_cl11 1   "S" 2   "No"  
label define  b3_071_cl12 001   "Cassa Integrazione Guadagni (CIG ordinaria o straordinaria)" 002   "Ridotta attivit dell'impresa per motivi economici e/o tecnici (esclusa CIG)" 003   "Sciopero" 004   "Vertenza sindacale, controversia di lavoro" 005   "Maltempo" 006   "Malattia, problemi di salute personali" 007   "Ferie" 008   "Festivit nella settimana" 009   "Orario variabile o flessibile (ad es. riposo compensativo)" 010   "Part-time verticale" 011   "Studio o Formazione non organizzata nell'ambito del proprio lavoro" 012   "Assenza obbligatoria per maternit" 013   "Assenza facoltativa fino all'ottavo anno del bambino (congedo parentale)" 014   "Motivi familiari (esclusa maternit obbligatoria e congedo parentale)" 015   "Mancanza di occasioni di maggior lavoro" 994   "Fa un lavoro occasionale" 995   "Fa un lavoro stagionale alle dipendenze" 996   "Altro motivo (specificare)"  
label define  b3bis_071_cl13 1   "Si" 2   "No" 3   "Aveva un lavoro, ma era assente" 4   "Non aveva un lavoro"  
label define  b4_071_cl14 1   "Un lavoro alle dipendenze" 2   "Un lavoro di: Collaborazione coordinata e continuativa (con o senza progetto)" 3   "Un lavoro di: Prestazione d'opera occasionale" 4   "Un lavoro autonomo come: Imprenditore" 5   "Un lavoro autonomo come: Libero professionista" 6   "Un lavoro autonomo come: Lavoratore in proprio" 7   "Un lavoro autonomo come: Coadiuvante nell'azienda di un familiare" 8   "Un lavoro autonomo come: Socio di cooperativa"  
label define  b4a_071_cl15 1   "Si,  Contratto di lavoro alle dipendenze" 2   "Si,  Contratto di collaborazione coordinata e continuativa (con o senza progetto)" 3   "No"  
label define  b4bis_071_cl16 1   "S" 2   "No"  
label define  b6_071_cl17 1   "Meno di tre mesi" 2   "Tre mesi o pi"  
label define  b7_071_cl18 1   "S, il 50% o pi" 2   "S, meno del 50%" 3   "No, non retribuito"  
label define  b8_071_cl19 001   "S" 002   "No" 997   "Non sa" 998   "Non risponde"  
label define  b9_071_cl20 1   "S" 2   "No"  
label define  b10_071_cl21 1   "S" 2   "No"  
label define  b11_071_cl22 1   "Momentaneamente sospesa" 2   "Conclusa"  
label define  c1_071_cl23 1   "Un lavoro alle dipendenze" 2   "Un lavoro di: Collaborazione coordinata e continuativa (con o senza progetto)" 3   "Un lavoro di: Prestazione d'opera occasionale" 4   "Un lavoro autonomo come: Imprenditore" 5   "Un lavoro autonomo come: Libero professionista" 6   "Un lavoro autonomo come: Lavoratore in proprio" 7   "Un lavoro autonomo come: Coadiuvante nell'azienda di un familiare" 8   "Un lavoro autonomo come: Socio di cooperativa"  
label define  c1bis_071_cl24 1   "S" 2   "No"  
label define  c1a_071_cl25 1   "Si,  Contratto di lavoro alle dipendenze" 2   "Si,  Contratto di collaborazione coordinata e continuativa (con o senza progetto)" 3   "No"  
label define  c1b_071_cl26 1   "S" 2   "No"  
label define  c1d_071_cl27 1   "S" 2   "No"  
label define  c4_071_cl28 1   "S" 2   "No"  
label define  c5_071_cl29 001   "Per un sola azienda/cliente" 002   "Per pi aziende/clienti" 997   "Non sa"  
label define  c6_071_cl30 001   "Decide dove lavorare/lavora presso il proprio ufficio" 002   "Lavora presso l'azienda/cliente/committente" 997   "Non sa"  
label define  c7_071_cl31 001   "Decide autonomamente l'orario" 002   "Non decide l'orario" 997   "Non sa"  
label define  c9_071_cl32 1   "Dirigente" 2   "Quadro" 3   "Impiegato" 4   "Operaio" 5   "Apprendista" 6   "Lavoratore presso il proprio domicilio per conto di un'impresa"  
label define  c10_071_cl33 001   "S" 002   "No" 997   "Non sa"  
label define  c14_071_cl34 001   "Solo una sede" 002   "Pi sedi" 997   "Non sa"  
label define  c18_071_cl36 1   "Fino a 10 persone" 2   "Da 11 a 15" 3   "Da 16 a 19" 4   "Da 20 a 49" 5   "Da 50 a 249" 6   "250 persone o pi" 7   "Non sa ma fino a 10" 8   "Non sa ma pi di 10"  
label define  c20_071_cl38 1   "A termine (tempo determinato)" 2   "A tempo indeterminato (senza una scadenza)"  
label define  c22_071_cl40 001   "Periodo di formazione, apprendistato" 002   "Periodo di prova" 003   "Lavoro stagionale" 004   "Lavoro occasionale (comprese supplenza nella scuola o sostituzione di un lavoratore assente compresa l'assenza per maternit)" 005   "Lavoro per la realizzazione di un progetto" 006   "Occupare un posto vacante (incarico a termine nella scuola, nella sanit, etc.)" 996   "Altro (specificare)" 997   "Non sa"  
label define  c25_071_cl41 001   "Non vuole un lavoro a tempo indeterminato" 002   "Non ha trovato un lavoro a tempo indeterminato" 997   "Non sa"  
label define  c26_071_cl42 001   "S" 002   "No" 003   "Senza preferenze" 997   "Non sa"  
label define  c27_071_cl43 1   "A tempo pieno" 2   "A tempo parziale (part-time)"  
label define  c28_071_cl44 001   "Non vuole un lavoro a tempo pieno" 002   "Non ha trovato un lavoro a tempo pieno" 003   "Altri motivi" 997   "Non sa"  
label define  c29_071_cl45 001   "Studia o sta seguendo corsi di formazione professionale" 002   "Malattia, problemi di salute personali" 003   "Per prendersi cura dei figli, di bambini e/o di altre persone non autosufficienti" 004   "Svolge un secondo lavoro" 005   "Altri motivi familiari (esclusa cura dei figli o di altre persone)" 006   "Avere a disposizione pi tempo libero" 996   "Altri motivi (specificare)"  
label define  c29b_071_cl46 001   "S, sono assenti/inadeguati i servizi per la cura di bambini" 002   "S, sono assenti/inadeguati i servizi per la cura di persone anziane, malate, disabili" 003   "S, entrambi i servizi sono assenti/inadeguati" 004   "No" 997   "Non sa"  
label define  c32_071_cl49 001   "Meno del solito" 002   "Piu' del solito" 003   "Come al solito" 997   "Non sa"  
label define  c33_071_cl50 001   "Orario variabile, flessibile" 002   "Straordinario retribuito e/o non retribuito" 004   "Maggiori impegni di lavoro" 996   "Altro (specificare)"  
label define  c34_071_cl51 001   "Cassa Integrazione Guadagni (ordinaria o straordinaria)" 002   "Ridotta attivit dell'impresa per motivi economici e/o tecnici (esclusa CIG)" 003   "Sciopero" 004   "Vertenza sindacale, controversia di lavoro" 005   "Maltempo" 006   "Malattia, problemi di salute personali" 007   "Ferie" 008   "Festivit nella settimana" 009   "Orario variabile o flessibile (ad es. riposo compensativo)" 010   "Part-time verticale" 011   "Studio o formazione non organizzata nell'ambito del proprio lavoro" 012   "Assenza obbligatoria per maternit" 013   "Assenza facoltativa fino all'ottavo anno del bambino (congedo parentale)" 014   "Motivi familiari (esclusa maternit obbligatoria e congedo parentale)" 015   "Mancanza di occasioni di maggior lavoro" 016   "Inizio o cambiamento del lavoro nella settimana" 017   "Ha concluso il lavoro nella settimana" 996   "Altro (specificare)"  
label define  c35_071_cl52 001   "S" 002   "No" 997   "Non sa"  
label define  c38_071_cl56 001   "S, meno ore" 002   "S, pi ore" 003   "No (avrebbe voluto lavorare lo stesso numero di ore)" 997   "Non sa"  
label define  c39a_071_cl58 1   "Aggiungendo un nuovo lavoro a quello che ha gi" 2   "Cambiando lavoro" 3   "Continuando a fare lo stesso lavoro" 4   "In uno qualunque dei modi precedenti"  
label define  c40_071_cl59 001   "S" 002   "No" 997   "Non sa"  
label define  c41_071_cl60 001   "Malattia, problemi di salute personali" 002   "Studio o Formazione non organizzata nell'ambito del proprio lavoro" 003   "Altri motivi personali (specificare)" 004   "Maternit, nascita di un figlio" 005   "Altri motivi familiari (esclusa cura dei figli o di altre persone)" 006   "Deve dare un preavviso" 007   "Per prendersi cura dei figli, bambini e/o di altre persone non autosufficienti" 996   "Altro motivo (specificare)" 997   "Non sa" 998   "Non risponde"  
label define  c42_071_cl61 001   "S, 2 o pi volte a settimana" 002   "S, meno di 2 volte a settimana" 003   "No" 997   "Non sa"  
label define  c43_071_cl62 001   "S, 2 o pi volte a settimana" 002   "S, meno di 2 volte a settimana" 003   "No" 997   "Non sa"  
label define  c44_071_cl63 001   "S, 2 o pi volte (nelle 4 settimane)" 002   "S, meno di 2 volte (nelle 4 settimane)" 003   "No" 997   "Non sa"  
label define  c45_071_cl64 001   "S, 2 o pi volte (nelle 4 settimane)" 002   "S, meno di 2 volte (nelle 4 settimane)" 003   "No" 997   "Non sa"  
label define  c46_071_cl65 001   "S" 002   "No" 997   "Non sa"  
label define  c47_071_cl66 001   "S" 002   "No" 997   "Non sa"  
label define  c48_071_cl67 001   "S, 2 o pi volte a settimana" 002   "S, meno di 2 volte a settimana" 003   "No" 997   "Non sa"  
label define  c51_071_cl68 001   "TORINO" 002   "VERCELLI" 003   "NOVARA" 004   "CUNEO" 005   "ASTI" 006   "ALESSANDRIA" 007   "AOSTA" 008   "IMPERIA" 009   "SAVONA" 010   "GENOVA" 011   "LA SPEZIA" 012   "VARESE" 013   "COMO" 014   "SONDRIO" 015   "MILANO" 016   "BERGAMO" 017   "BRESCIA" 018   "PAVIA" 019   "CREMONA" 020   "MANTOVA" 021   "BOLZANO" 022   "TRENTO" 023   "VERONA" 024   "VICENZA" 025   "BELLUNO" 026   "TREVISO" 027   "VENEZIA" 028   "PADOVA" 029   "ROVIGO" 030   "UDINE" 031   "GORIZIA" 032   "TRIESTE" 033   "PIACENZA" 034   "PARMA" 035   "REGGIO NELL'EMILIA" 036   "MODENA" 037   "BOLOGNA" 038   "FERRARA" 039   "RAVENNA" 040   "FORLI' - CESENA" 041   "PESARO E URBINO" 042   "ANCONA" 043   "MACERATA" 044   "ASCOLI PICENO" 045   "MASSA - CARRARA" 046   "LUCCA" 047   "PISTOIA" 048   "FIRENZE" 049   "LIVORNO" 050   "PISA" 051   "AREZZO" 052   "SIENA" 053   "GROSSETO" 054   "PERUGIA" 055   "TERNI" 056   "VITERBO" 057   "RIETI" 058   "ROMA" 059   "LATINA" 060   "FROSINONE" 061   "CASERTA" 062   "BENEVENTO" 063   "NAPOLI" 064   "AVELLINO" 065   "SALERNO" 066   "L'AQUILA" 067   "TERAMO" 068   "PESCARA" 069   "CHIETI" 070   "CAMPOBASSO" 071   "FOGGIA" 072   "BARI" 073   "TARANTO" 074   "BRINDISI" 075   "LECCE" 076   "POTENZA" 077   "MATERA" 078   "COSENZA" 079   "CATANZARO" 080   "REGGIO DI CALABRIA" 081   "TRAPANI" 082   "PALERMO" 083   "MESSINA" 084   "AGRIGENTO" 085   "CALTANISSETTA" 086   "ENNA" 087   "CATANIA" 088   "RAGUSA" 089   "SIRACUSA" 090   "SASSARI" 091   "NUORO" 092   "CAGLIARI" 093   "PORDENONE" 094   "ISERNIA" 095   "ORISTANO" 096   "BIELLA" 097   "LECCO" 098   "LODI" 099   "RIMINI" 100   "PRATO" 101   "CROTONE" 102   "VIBO VALENTIA" 103   "VERBANO-CUSIO-OSSOLA" 104   "OLBIA-TEMPIO" 105   "OGLIASTRA" 106   "MEDIO CAMPIDANO" 107   "CARBONIA-IGLESIAS"  
label define  c53_071_cl69 001   "S, da un altro comune delle stessa provincia" 002   "S, da un'altra provincia" 003   "S, dall'estero" 004   "No" 005   "S, ma poi  tornato nella provincia di residenza" 997   "Non sa"  
label define  c54_071_cl70 001   "TORINO" 002   "VERCELLI" 003   "NOVARA" 004   "CUNEO" 005   "ASTI" 006   "ALESSANDRIA" 007   "AOSTA" 008   "IMPERIA" 009   "SAVONA" 010   "GENOVA" 011   "LA SPEZIA" 012   "VARESE" 013   "COMO" 014   "SONDRIO" 015   "MILANO" 016   "BERGAMO" 017   "BRESCIA" 018   "PAVIA" 019   "CREMONA" 020   "MANTOVA" 021   "BOLZANO" 022   "TRENTO" 023   "VERONA" 024   "VICENZA" 025   "BELLUNO" 026   "TREVISO" 027   "VENEZIA" 028   "PADOVA" 029   "ROVIGO" 030   "UDINE" 031   "GORIZIA" 032   "TRIESTE" 033   "PIACENZA" 034   "PARMA" 035   "REGGIO NELL'EMILIA" 036   "MODENA" 037   "BOLOGNA" 038   "FERRARA" 039   "RAVENNA" 040   "FORLI' - CESENA" 041   "PESARO E URBINO" 042   "ANCONA" 043   "MACERATA" 044   "ASCOLI PICENO" 045   "MASSA - CARRARA" 046   "LUCCA" 047   "PISTOIA" 048   "FIRENZE" 049   "LIVORNO" 050   "PISA" 051   "AREZZO" 052   "SIENA" 053   "GROSSETO" 054   "PERUGIA" 055   "TERNI" 056   "VITERBO" 057   "RIETI" 058   "ROMA" 059   "LATINA" 060   "FROSINONE" 061   "CASERTA" 062   "BENEVENTO" 063   "NAPOLI" 064   "AVELLINO" 065   "SALERNO" 066   "L'AQUILA" 067   "TERAMO" 068   "PESCARA" 069   "CHIETI" 070   "CAMPOBASSO" 071   "FOGGIA" 072   "BARI" 073   "TARANTO" 074   "BRINDISI" 075   "LECCE" 076   "POTENZA" 077   "MATERA" 078   "COSENZA" 079   "CATANZARO" 080   "REGGIO DI CALABRIA" 081   "TRAPANI" 082   "PALERMO" 083   "MESSINA" 084   "AGRIGENTO" 085   "CALTANISSETTA" 086   "ENNA" 087   "CATANIA" 088   "RAGUSA" 089   "SIRACUSA" 090   "SASSARI" 091   "NUORO" 092   "CAGLIARI" 093   "PORDENONE" 094   "ISERNIA" 095   "ORISTANO" 096   "BIELLA" 097   "LECCO" 098   "LODI" 099   "RIMINI" 100   "PRATO" 101   "CROTONE" 102   "VIBO VALENTIA" 103   "VERBANO-CUSIO-OSSOLA" 104   "OLBIA-TEMPIO" 105   "OGLIASTRA" 106   "MEDIO CAMPIDANO" 107   "CARBONIA-IGLESIAS"  
label define  c59_071_cl71 001   "S" 002   "No" 997   "Non sa"  
label define  c60_071_cl72 001   "S" 002   "No" 997   "Non sa"  
label define  d1_071_cl73 1   "S, un altro lavoro" 2   "S, pi di uno" 3   "No"  
label define  d3_071_cl75 001   "Regolarmente" 002   "Solo in alcune stagioni (o in particolari periodi dell'anno)" 003   "Ogni tanto, quando capita" 997   "Non sa"  
label define  d4_071_cl76 1   "Un lavoro alle dipendenze" 2   "Un lavoro di: Collaborazione coordinata e continuativa (con o senza progetto)" 3   "Un lavoro di: Prestazione d'opera occasionale" 4   "Un lavoro autonomo come: Imprenditore" 5   "Un lavoro autonomo come: Libero professionista" 6   "Un lavoro autonomo come: Lavoratore in proprio" 7   "Un lavoro autonomo come: Coadiuvante nell'azienda di un familiare" 8   "Un lavoro autonomo come: Socio di cooperativa"  
label define  d5_071_cl77 1   "Si,  Contratto di lavoro alle dipendenze" 2   "Si,  Contratto di collaborazione coordinata e continuativa (con o senza progetto)" 3   "No"  
label define  d5a_071_cl78 1   "S" 2   "No"  
label define  d5bis_071_cl79 1   "S" 2   "No"  
label define  d7_071_cl80 1   "S" 2   "No"  
label define  f1_071_cl82 1   "S" 2   "No"  
label define  f2_071_cl83 1   "Un nuovo lavoro" 2   "Un secondo lavoro (da aggiungere a quello attuale)"  
label define  f3_071_cl84 001   "Lavoro attuale  a termine (lavoro a tempo determinato)" 002   "Teme di perdere l'attuale lavoro" 003   "Considera l'attuale lavoro occasionale" 004   "Guadagnare di pi" 005   "Raggiungere pi facilmente il luogo di lavoro" 006   "Orario pi adatto a prendersi cura dei figli e/o di altri familiari" 007   "Orario diverso per altri motivi" 008   "Cerca un lavoro pi qualificante per le proprie  capacit/competenze e con maggiori prospettive di carriera" 009   "Cerca un lavoro pi adatto alle proprie condizioni di salute" 996   "Altri motivi (specificare)"  
label define  f4_071_cl85 001   "Pi ore" 002   "Meno ore" 003   "Lo stesso numero di ore" 997   "Non sa"  
label define  f5_071_cl86 1   "S" 2   "No"  
label define  f6_01_071_cl87 0   "No" 1   "Si"  
label define  f6_02_071_cl88 0   "No" 1   "Si"  
label define  f6_03_071_cl89 0   "No" 1   "Si"  
label define  f6_04_071_cl90 0   "No" 1   "Si"  
label define  f6_05_071_cl91 0   "No" 1   "Si"  
label define  f6_06_071_cl92 0   "No" 1   "Si"  
label define  f6_07_071_cl93 0   "No" 1   "Si"  
label define  f6_08_071_cl94 0   "No" 1   "Si"  
label define  f6_09_071_cl95 0   "No" 1   "Si"  
label define  f6_10_071_cl96 0   "No" 1   "Si"  
label define  f6_11_071_cl97 0   "No" 1   "Si"  
label define  f6_12_071_cl98 0   "No" 1   "Si"  
label define  f6_96_071_cl99 0   "No" 1   "Si"  
label define  f7_071_cl100 1   "S" 2   "No"  
label define  f8_071_cl101 1   "S" 2   "No"  
label define  f10_071_cl103 001   "Ha gi un lavoro che inizier in futuro" 002   "Studia o segue corsi di formazione professionale" 003   "Malattia, problemi di salute personali" 004   "Per prendersi cura dei figli, di bambini e/o di altre  persone non autosufficenti" 005   "In attesa di tornare al suo posto di lavoro" 007   "Pensione da lavoro (anzianit o vecchiaia)" 008   "Ritiene di non riuscire a trovare lavoro" 009   "Non gli interessa/non ne ha bisogno (anche per motivi di et)" 010   "Sta aspettando gli esiti di passate azioni di ricerca" 011   "Inabile al lavoro" 012   "Maternit, nascita di un figlio" 013   "Altri motivi familiari (esclusa maternit, cura dei figli o di altre persone)" 996   "Altri motivi (specificare)" 997   "Non sa"  
label define  f10a_071_cl104 001   "S, sono assenti/inadeguati i servizi per la cura di bambini" 002   "S, sono assenti/inadeguati i servizi per la cura di persone anziane, malate, disabili" 003   "S, entrambi i servizi sono assenti/inadeguati" 004   "No" 997   "Non sa"  
label define  f12_071_cl105 1   "S" 2   "No"  
label define  f13_071_cl106 1   "S" 2   "No"  
label define  f14_071_cl107 001   "Studia o segue corsi di formazione professionale" 002   "Altri motivi personali" 003   "Maternit, nascita di un figlio" 004   "Altri motivi familiari (esclusa la maternit, cura dei figli o di altre persone)" 005   "Malattia, problemi di salute personali" 006   "Deve dare un preavviso" 007   "Deve o vuole concludere il lavoro gi iniziato" 009   "Per prendersi cura dei figli, di bambini e/o di altre persone non autosufficienti" 996   "Altri motivi (specificare)" 997   "Non sa" 998   "Non risponde"  
label define  f15_071_cl108 001   "S" 002   "No" 997   "Non sa"  
label define  f16_071_cl109 1   "S" 2   "No"  
label define  f17_071_cl110 1   "S" 2   "No"  
label define  f18_071_cl111 1   "S" 2   "No"  
label define  f19_071_cl112 1   "S" 2   "No"  
label define  f20_071_cl113 1   "S" 2   "No"  
label define  f21_071_cl114 1   "S" 2   "No"  
label define  f22_071_cl115 1   "S" 2   "No"  
label define  f23_071_cl116 1   "S" 2   "No"  
label define  f24_071_cl117 1   "S" 2   "No"  
label define  f25_071_cl118 1   "S" 2   "No"  
label define  f26_071_cl119 1   "S" 2   "No"  
label define  f27_071_cl120 1   "S" 2   "No"  
label define  f28_071_cl121 1   "Si (specificare)" 2   "No"  
label define  f29_01_071_cl122 0   "No" 1   "Si"  
label define  f29_02_071_cl123 0   "No" 1   "Si"  
label define  f29_03_071_cl124 0   "No" 1   "Si"  
label define  f29_04_071_cl125 0   "No" 1   "Si"  
label define  f29_97_071_cl126 0   "No" 1   "Si"  
label define  f30_071_cl127 1   "S" 2   "No"  
label define  f32_071_cl129 1   "Studiava" 2   "Era in servizio militare o in servizio civile sostitutivo" 3   "Lavorava" 4   "Si prendeva cura della casa e/o dei familiari" 5   "In altra condizione"  
label define  f33_071_cl130 1   "S" 2   "No"  
label define  f34_071_cl131 001   "Studia o segue corsi di formazione professionale" 002   "Altri motivi personali" 003   "Maternit, nascita di un figlio" 004   "Altri motivi familiari (esclusa la maternit, cura dei figli o di altre persone)" 005   "Malattia, problemi di salute personali" 006   "Deve dare un preavviso" 007   "Deve o vuole concludere il lavoro gi iniziato" 009   "Per prendersi cura dei figli, di bambini e/o di altre persone non autosufficienti" 996   "Altri motivi (specificare)" 997   "Non sa" 998   "Non risponde"  
label define  f35_071_cl132 1   "In proprio" 2   "Dipendente" 3   "Senza preferenze"  
label define  f36_071_cl133 1   "A tempo pieno" 2   "A tempo parziale (part-time)" 3   "Senza preferenze"  
label define  f37_071_cl134 1   "S" 2   "No"  
label define  f38_071_cl135 1   "S" 2   "No"  
label define  f39_071_cl136 001   "A termine" 002   "A tempo indeterminato" 997   "Non sa"  
label define  f40_071_cl137 001   "S" 002   "No" 997   "Non sa"  
label define  f41_071_cl138 001   "Soltanto nel comune di residenza" 002   "In altro comune raggiungibile giornalmente" 003   "Ovunque, in Italia" 004   "Ovunque, anche all'estero" 997   "Non sa"  
label define  f44_071_cl141 1   "Studiava" 2   "Era in servizio militare o in servizio civile sostitutivo" 3   "Lavorava" 4   "Si prendeva cura dei figli e/o di altri familiari" 5   "In altra condizione"  
label define  f45_071_cl142 1   "Entro i prossimi 3 mesi" 2   "Tra pi di 3 mesi"  
label define  f46_071_cl143 1   "S" 2   "No"  
label define  f47_071_cl144 001   "Studia o segue corsi di formazione professionale" 002   "Altri motivi personali" 003   "Maternit, nascita di un figlio" 004   "Altri motivi familiari (esclusa la maternit, cura dei figli o di altre persone)" 005   "Malattia, problemi di salute personali" 006   "Deve dare un preavviso" 007   "Deve o vuole concludere il lavoro gi iniziato" 009   "Per prendersi cura dei figli, di bambini e/o di altre persone non autosufficienti" 996   "Altri motivi (specificare)" 997   "Non sa" 998   "Non risponde"  
label define  f48_071_cl145 1   "In proprio" 2   "Alle dipendenze"  
label define  f49_071_cl146 001   "Tempo pieno" 002   "Part-time (a tempo parziale)" 997   "Non sa"  
label define  f50_071_cl147 001   "S" 002   "No" 997   "Non sa"  
label define  i1_071_cl148 1   "Occupato" 2   "Disoccupato alla ricerca di nuova occupazione" 3   "In cerca di prima occupazione" 4   "Casalinga/o" 5   "Studente" 6   "Ritirato/a dal lavoro" 7   "Inabile al lavoro" 9   "In altra condizione (specificare)"  
label define  i5_071_cl149 1   "Occupato" 2   "Disoccupato alla ricerca di nuova occupazione" 3   "In cerca di prima occupazione" 4   "Casalinga/o" 5   "Studente" 6   "Ritirato/a dal lavoro" 7   "Inabile al lavoro" 8   "In servizio di leva o servizio civile" 9   "In altra condizione (specificare)"  
label define  i6_071_cl150 1   "Un lavoro alle dipendenze" 2   "Un lavoro di: Collaborazione coordinata e continuativa (con o senza progetto)" 3   "Un lavoro di: Prestazione d'opera occasionale" 4   "Un lavoro autonomo come: Imprenditore" 5   "Un lavoro autonomo come: Libero professionista" 6   "Un lavoro autonomo come: Lavoratore in proprio" 7   "Un lavoro autonomo come: Coadiuvante nell'azienda di un familiare" 8   "Un lavoro autonomo come: Socio di cooperativa"  
label define  i7_071_cl151 1   "Si,  Contratto di lavoro alle dipendenze" 2   "Si,  Contratto di collaborazione coordinata e continuativa (con o senza progetto)" 3   "No"  
label define  i8_071_cl152 1   "S" 2   "No"  
label define  i9_071_cl153 001   "A termine (tempo determinato)" 002   "A tempo indeterminato (senza una scadenza)" 997   "Non sa"  
label define  i16b_071_cl156 1   "S" 2   "No"  
label define  rip4_071_cl158 1   "Nord ovest" 2   "Nord est" 3   "Centro" 4   "Mezzogiorno"  
label define  rip3_071_cl159 1   "Nord" 2   "Centro" 3   "Mezzogiorno"  
label define  cletad_071_cl161 1   "0-14" 2   "15-24" 3   "25-34" 4   "35-44" 5   "45-54" 6   "55-64" 7   "65-74" 8   "75 e +"  
label define  cletaq_071_cl162 01   "0-14" 02   "15-19" 03   "20-24" 04   "25-29" 05   "30-34" 06   "35-39" 07   "40-44" 08   "45-49" 09   "50-54" 10   "55-59" 11   "60-64" 12   "65-69" 13   "70-74" 14   "75 e +"  
label define  cletas_071_cl163 01   "'0-2" 02   "'3-5" 03   "'6-10" 04   "'11-14" 05   "15-19" 06   "20-24" 07   "25-29" 08   "30-34" 09   "35-39" 10   "40-44" 11   "45-49" 12   "50-54" 13   "55-59" 14   "60-64" 15   "65-69" 16   "70-74" 17   "75 e +"  
label define  cittad_071_cl164 1   "citt. italiano" 2   "citt. straniero UE" 3   "citt. straniero NON UE"  
label define  llases_071_cl165 201   "Albania" 202   "Andorra" 203   "Austria" 206   "Belgio" 209   "Bulgaria" 212   "Danimarca" 214   "Finlandia" 215   "Francia" 216   "Germania" 219   "Regno Unito" 220   "Grecia" 221   "Irlanda" 223   "Islanda" 225   "Liechtenstein" 226   "Lussemburgo" 227   "Malta" 229   "Monaco" 231   "Norvegia" 232   "Paesi Bassi" 233   "Polonia" 234   "Portogallo" 235   "Romania" 236   "San Marino" 239   "Spagna" 240   "Svezia" 241   "Svizzera" 243   "Ucraina" 244   "Ungheria" 245   "Russa, Federazione" 246   "Vaticano, Citt" 247   "Estonia" 248   "Lettonia" 249   "Lituania" 250   "Croazia" 251   "Slovenia" 252   "Bosnia-Erzegovina" 253   "Macedonia, ex-Rep. Jugoslavia" 254   "Moldavia" 255   "Slovacchia" 256   "Bielorussia" 257   "Ceca, Repubblica" 270   "Montenegro" 271   "Serbia" 301   "Afghanistan" 302   "Arabia Saudita" 304   "Bahrein" 305   "Bangladesh" 306   "Bhutan" 307   "Myanmar (Birmania)" 309   "Brunei" 310   "Cambogia" 311   "Sri Lanka (Ceylon)" 314   "Cinese, Repubblica Popolare" 315   "Cipro" 319   "Corea, Repubblica Popolare (Nord)" 320   "Corea, Repubblica (Sud)" 322   "Emirati Arabi Uniti" 323   "Filippine" 324   "Palestina" 326   "Giappone" 327   "Giordania" 330   "India" 331   "Indonesia" 332   "Iran" 333   "Iraq" 334   "Israele" 335   "Kuwait" 336   "Laos" 337   "Libano" 338   "Timor orientale" 339   "Maldive" 340   "Malaysia" 341   "Mongolia" 342   "Nepal" 343   "Oman" 344   "Pakistan" 345   "Qatar" 346   "Singapore" 348   "Siria" 349   "Thailandia" 351   "Turchia" 353   "Vietnam" 354   "Yemen" 356   "Kazakistan" 357   "Uzbekistan" 358   "Armenia" 359   "Azerbaigian" 360   "Georgia" 361   "Kirghizistan" 362   "Tagikistan" 363   "Taiwan (Formosa)" 364   "Turkmenistan" 401   "Algeria" 402   "Angola" 404   "Costa d'Avorio" 406   "Benin (Dahomey)" 408   "Botswana" 409   "Burkina Faso (Alto Volta)" 410   "Burundi" 411   "Camerun" 413   "Capo Verde" 414   "Centrafricana, Rep." 415   "Ciad" 417   "Comore" 418   "Congo" 419   "Egitto" 420   "Etiopia" 421   "Gabon" 422   "Gambia" 423   "Ghana" 424   "Gibuti" 425   "Guinea" 426   "Guinea Bissau" 427   "Guinea Equatoriale" 428   "Kenia" 429   "Lesotho" 430   "Liberia" 431   "Libia" 432   "Madagascar" 434   "Malawi" 435   "Mali" 436   "Marocco" 437   "Mauritania" 438   "Maurizio" 440   "Mozambico" 441   "Namibia" 442   "Niger" 443   "Nigeria" 446   "Ruanda" 448   "Sao Tom e Principe" 449   "Seycelles" 450   "Senegal" 451   "Sierra Leone" 453   "Somalia" 454   "Sudafricana, Rep." 455   "Sudan" 456   "Swaziland" 457   "Tanzania" 458   "Togo" 460   "Tunisia" 461   "Uganda" 463   "Congo, Rep.Dem. (Zaire)" 464   "Zambia" 465   "Zimbabwe (Rhodesia)" 466   "Eritrea" 503   "Antigua e Barbuda" 505   "Bahama" 506   "Barbados" 507   "Belize" 509   "Canada" 513   "Costarica" 514   "Cuba" 515   "Dominica" 516   "Dominicana, Rep." 517   "El Salvador" 518   "Giamaica" 519   "Grenada" 523   "Guatemala" 524   "Haiti" 525   "Honduras" 527   "Messico" 529   "Nicaragua" 530   "Panama" 532   "Saint Lucia" 533   "Saint Vincent e Grenadine" 534   "Saint Kitts e Nevis" 536   "Stati Uniti d'America" 602   "Argentina" 604   "Bolivia" 605   "Brasile" 606   "Cile" 608   "Colombia" 609   "Ecuador" 612   "Guyana" 614   "Paraguay" 615   "Per" 616   "Suriname" 617   "Trinidad e Tobago" 618   "Uruguay" 619   "Venezuela" 701   "Australia" 703   "Figi" 708   "Kiribati" 712   "Marshall, Isole" 713   "Micronesia, Stati Federati" 715   "Nauru" 719   "Nuova Zelanda" 720   "Palau" 721   "Papua Nuova Guinea" 725   "Salomone" 727   "Samoa" 730   "Tonga" 731   "Tuvalu" 732   "Vanuatu"  
label define  cond3_071_cl166 1   "occupati" 2   "persone in cerca" 3   "inattivi"  
label define  cond10_071_cl167 01   "occupati" 02   "persone in cerca, con precedenti esperienze, ex-occupati" 03   "persone in cerca, con precedenti esperienze, ex-inattivi" 04   "persone in cerca, senza precedenti esperienze" 05   "inattivi in et lav., cercano non attivamente ma disponibili" 06   "inattivi in et lav., cercano ma non disponibili" 07   "inattivi in et lav., non cercano ma disponibili" 08   "inattivi in et lav., non cercano e non disponibili (anche militari di leva e inabili al lavoro)" 09   "inattivi in et non lav., meno di 15 anni" 10   "inattivi in et non lav., pi di 64 anni"  
label define  dipaut_071_cl168 1   "dipendente" 2   "collaboratore" 3   "autonomo"  
label define  dipind_071_cl169 1   "Dipendente" 2   "Indipendente"  
label define  assocc_071_cl170 1   "S" 2   "No"  
label define  pospro_071_cl171 01   "Dirigente" 02   "Quadro" 03   "Impiegato" 04   "Operaio" 05   "Apprendista" 06   "Lavoratore presso il proprio domicilio per conto di un impresa" 07   "Imprenditore" 08   "Libero professionista" 09   "Lavoratore in proprio" 10   "Socio di cooperativa" 11   "Coadiuvante nell azienda di un familiare" 12   "Collaborazione coordinata e continuativa" 13   "Prestazione d opera occasionale"  
label define  detind_071_cl172 1   "tempo determinato" 2   "tempo indeterminato"  
label define  piepar_071_cl173 1   "tempo pieno" 2   "tempo parziale"  
label define  tipcon_071_cl174 001   "Contratto di formazione e lavoro (inquadrato in un CCNL)" 002   "Contratto di apprendistato (inquadrato in un CCNL)" 003   "Contratto Individuale di Lavoro a termine (inquadrato in un CCNL)" 004   "Contratto di lavoro interinale o di somministrazione lavoro (inquadrato in un CCNL)" 996   "Altro tipo di contratto" 997   "Non sa"  
label define  prof1_071_cl176 1   "LEGISLATORI, DIRIGENTI E IMPRENDITORI" 2   "PROFESSIONI INTELLETTUALI, SCIENTIFICHE E DI ELEVATA SPECIALIZZAZIONE" 3   "PROFESSIONI TECNICHE" 4   "IMPIEGATI" 5   "PROFESSIONI QUALIFICATE NELLE ATTIVITA" 6   "ARTIGIANI, OPERAI SPECIALIZZATI E AGRICOLTORI" 7   "CONDUTTORI DI IMPIANTI E OPERAI SEMIQUALIFICATI ADDETTI A MACCHINARI FISSI E MOBILI" 8   "PROFESSIONI NON QUALIFICATE" 9   "FORZE ARMATE"  
label define  ate2d_071_cl179 01   "agricoltura, caccia e relativi servizi" 02   "silvicoltura e utilizzazione di aree forestali e servizi connessi" 05   "pesca, piscicoltura e servizi connessi" 10   "estrazione di carbon fossile, lignite, torba" 11   "estrazione di petrolio greggio e di gas naturale e servizi connessi, esclusa la prospezione" 12   "estrazione di minerali di uranio e di torio" 13   "estrazione di minerali metalliferi" 14   "altre industrie estrattive" 15   "industrie alimentari e delle bevande" 16   "industria del tabacco" 17   "industrie tessili" 18   "confezione di articoli di abbigliamento; preparazione, tintura e confezione di pellicce" 19   "preparazione e concia del cuoio; fabbricazione di articoli da viaggio, borse, marocchineria, selleria e calzature" 20   "industria del legno e dei prodotti in legno e sughero, esclusi i mobili; fabbricazione di articoli in materiali da intreccio" 21   "fabbricazione della pasta-carta, della carta e del cartone e dei prodotti di carta" 22   "editoria, stampa e riproduzione di supporti registrati" 23   "fabbricazione di coke, raffinerie di petrolio, trattamento dei combustibili nucleari" 24   "fabbricazione di prodotti chimici e di fibre sintetiche e artificiali" 25   "fabbricazione di articoli in gomma e materie plastiche" 26   "fabbricazione di prodotti della lavorazione di minerali non metalliferi" 27   "metallurgia" 28   "fabbricazione e lavorazione dei prodotti in metallo, esclusi macchine e impianti" 29   "fabbricazione di macchine ed apparecchi meccanici" 30   "fabbricazione di macchine per ufficio, di elaboratori e sistemi informatici" 31   "fabbricazione di macchine ed apparecchi elettrici n.c.a." 32   "fabbricazione di apparecchi radiotelevisivi e di apparecchiature per le comunicazioni" 33   "fabbricazione di apparecchi medicali, di apparecchi di precisione, di strumenti ottici e di orologi" 34   "fabbricazione di autoveicoli, rimorchi e semirimorchi" 35   "fabbricazione di altri mezzi di trasporto" 36   "fabbricazione di mobili; altre industrie manifatturiere" 37   "recupero e preparazione per il riciclaggio" 40   "produzione e distribuzione di energia elettrica, di gas, di calore" 41   "raccolta, depurazione e distribuzione d'acqua" 45   "costruzioni" 50   "commercio, manutenzione e riparazione di autoveicoli e motocicli; vendita al dettaglio di carburanti per autotrazione" 51   "commercio all'ingrosso e intermediari del commercio, autoveicoli e motocicli esclusi" 52   "commercio al dettaglio (escluso quello di autoveicoli e di motocicli); riparazione di beni personali e per la casa" 55   "alberghi e ristoranti" 60   "trasporti terrestri; trasporti mediante condotte" 61   "trasporti marittimi e per vie d'acqua" 62   "trasporti aerei" 63   "attivit di supporto ed ausiliarie dei trasporti; attivit delle agenzie di viaggio" 64   "poste e telecomunicazioni" 65   "intermediazione monetaria e finanziaria (escluse le assicurazioni e i fondi pensione)" 66   "assicurazioni e fondi pensione, escluse le assicurazioni sociali obbligatorie" 67   "attivit ausiliarie dell'intermediazione finanziaria e delle assicurazioni" 70   "attivit immobiliari" 71   "noleggio di macchinari e attrezzature senza operatore e di beni per uso personale e domestico" 72   "informatica e attivit connesse" 73   "ricerca e sviluppo" 74   "attivit di servizi alle imprese" 75   "amministrazione pubblica" 80   "istruzione" 85   "sanit e assistenza sociale" 90   "smaltimento dei rifiuti solidi, delle acque di scarico e simili" 91   "attivit di organizzazioni associative" 92   "attivit ricreative, culturali e sportive" 93   "servizi alle famiglie" 95   "attivit di datore di lavoro per personale domestico svolto da famiglie e convivenze" 96   "produzione di beni per uso proprio da parte di famiglie e convivenze" 97   "produzione di servizi per uso proprio da parte di famiglie e convivenze" 99   "organizzazioni ed organismi extraterritoriali"  
label define  cat12_071_cl180 01   "Agricoltura, caccia e pesca" 02   "Industria dell energia, estrazione materiali energetici" 03   "Industria della trasformazione" 04   "Industria delle costruzioni" 05   "Altre attivit: commercio" 06   "Altre attivit: alberghi e ristoranti" 07   "Altre attivit: trasporti e comunicazioni" 08   "Altre attivit: intermediazione monetaria e finanziaria, attivit immobiliari" 09   "Altre attivit: servizi alle imprese e altre attivit professionali e imprenditoriali" 10   "Altre attivit: pubblica amministrazione, difesa, assicurazioni sociali obbligatorie" 11   "Altre attivit: istruzione, sanit ed altri servizi sociali" 12   "Altre attivit: altri servizi pubblici, sociali e alle persone"  
label define  cat5_071_cl181 1   "Agricoltura" 2   "Industria in senso stretto" 3   "Costruzioni" 4   "Commercio" 5   "Altre attivit"  
label define  cat3_071_cl182 1   "Agricoltura" 2   "Industria" 3   "Terziario"  
label define  regspe_071_cl183 01   "Piemonte" 02   "Valle d'Aosta" 03   "Lombardia" 04   "Trentino alto Adige" 05   "Veneto" 06   "Friuli Venezia Giulia" 07   "Liguria" 08   "Emilia Romagna" 09   "Toscana" 10   "Umbria" 11   "Marche" 12   "Lazio" 13   "Abruzzo" 14   "Molise" 15   "Campania" 16   "Puglia" 17   "Basilicata" 18   "Calabria" 19   "Sicilia" 20   "Sardegna"  
label define  prospe_071_cl184 001   "TORINO" 002   "VERCELLI" 003   "NOVARA" 004   "CUNEO" 005   "ASTI" 006   "ALESSANDRIA" 007   "AOSTA" 008   "IMPERIA" 009   "SAVONA" 010   "GENOVA" 011   "LA SPEZIA" 012   "VARESE" 013   "COMO" 014   "SONDRIO" 015   "MILANO" 016   "BERGAMO" 017   "BRESCIA" 018   "PAVIA" 019   "CREMONA" 020   "MANTOVA" 021   "BOLZANO" 022   "TRENTO" 023   "VERONA" 024   "VICENZA" 025   "BELLUNO" 026   "TREVISO" 027   "VENEZIA" 028   "PADOVA" 029   "ROVIGO" 030   "UDINE" 031   "GORIZIA" 032   "TRIESTE" 033   "PIACENZA" 034   "PARMA" 035   "REGGIO NELL'EMILIA" 036   "MODENA" 037   "BOLOGNA" 038   "FERRARA" 039   "RAVENNA" 040   "FORLI' - CESENA" 041   "PESARO E URBINO" 042   "ANCONA" 043   "MACERATA" 044   "ASCOLI PICENO" 045   "MASSA - CARRARA" 046   "LUCCA" 047   "PISTOIA" 048   "FIRENZE" 049   "LIVORNO" 050   "PISA" 051   "AREZZO" 052   "SIENA" 053   "GROSSETO" 054   "PERUGIA" 055   "TERNI" 056   "VITERBO" 057   "RIETI" 058   "ROMA" 059   "LATINA" 060   "FROSINONE" 061   "CASERTA" 062   "BENEVENTO" 063   "NAPOLI" 064   "AVELLINO" 065   "SALERNO" 066   "L'AQUILA" 067   "TERAMO" 068   "PESCARA" 069   "CHIETI" 070   "CAMPOBASSO" 071   "FOGGIA" 072   "BARI" 073   "TARANTO" 074   "BRINDISI" 075   "LECCE" 076   "POTENZA" 077   "MATERA" 078   "COSENZA" 079   "CATANZARO" 080   "REGGIO DI CALABRIA" 081   "TRAPANI" 082   "PALERMO" 083   "MESSINA" 084   "AGRIGENTO" 085   "CALTANISSETTA" 086   "ENNA" 087   "CATANIA" 088   "RAGUSA" 089   "SIRACUSA" 090   "SASSARI" 091   "NUORO" 092   "CAGLIARI" 093   "PORDENONE" 094   "ISERNIA" 095   "ORISTANO" 096   "BIELLA" 097   "LECCO" 098   "LODI" 099   "RIMINI" 100   "PRATO" 101   "CROTONE" 102   "VIBO VALENTIA" 103   "VERBANO-CUSIO-OSSOLA" 104   "OLBIA-TEMPIO" 105   "OGLIASTRA" 106   "MEDIO CAMPIDANO" 107   "CARBONIA-IGLESIAS"  
label define  tracom_071_cl185 001   "Si, da altro comune della stessa provincia" 002   "Si, da altra provincia della stessa regione" 003   "Si, da altra regione" 004   "Si, dall estero" 005   "No" 006   "Si, ma poi  tornato nella provincia di residenza" 997   "Non sa"  
label define  regtra_071_cl186 01   "Piemonte" 02   "Valle d'Aosta" 03   "Lombardia" 04   "Trentino alto Adige" 05   "Veneto" 06   "Friuli Venezia Giulia" 07   "Liguria" 08   "Emilia Romagna" 09   "Toscana" 10   "Umbria" 11   "Marche" 12   "Lazio" 13   "Abruzzo" 14   "Molise" 15   "Campania" 16   "Puglia" 17   "Basilicata" 18   "Calabria" 19   "Sicilia" 20   "Sardegna"  
label define  protra_071_cl187 001   "TORINO" 002   "VERCELLI" 003   "NOVARA" 004   "CUNEO" 005   "ASTI" 006   "ALESSANDRIA" 007   "AOSTA" 008   "IMPERIA" 009   "SAVONA" 010   "GENOVA" 011   "LA SPEZIA" 012   "VARESE" 013   "COMO" 014   "SONDRIO" 015   "MILANO" 016   "BERGAMO" 017   "BRESCIA" 018   "PAVIA" 019   "CREMONA" 020   "MANTOVA" 021   "BOLZANO" 022   "TRENTO" 023   "VERONA" 024   "VICENZA" 025   "BELLUNO" 026   "TREVISO" 027   "VENEZIA" 028   "PADOVA" 029   "ROVIGO" 030   "UDINE" 031   "GORIZIA" 032   "TRIESTE" 033   "PIACENZA" 034   "PARMA" 035   "REGGIO NELL'EMILIA" 036   "MODENA" 037   "BOLOGNA" 038   "FERRARA" 039   "RAVENNA" 040   "FORLI' - CESENA" 041   "PESARO E URBINO" 042   "ANCONA" 043   "MACERATA" 044   "ASCOLI PICENO" 045   "MASSA - CARRARA" 046   "LUCCA" 047   "PISTOIA" 048   "FIRENZE" 049   "LIVORNO" 050   "PISA" 051   "AREZZO" 052   "SIENA" 053   "GROSSETO" 054   "PERUGIA" 055   "TERNI" 056   "VITERBO" 057   "RIETI" 058   "ROMA" 059   "LATINA" 060   "FROSINONE" 061   "CASERTA" 062   "BENEVENTO" 063   "NAPOLI" 064   "AVELLINO" 065   "SALERNO" 066   "L'AQUILA" 067   "TERAMO" 068   "PESCARA" 069   "CHIETI" 070   "CAMPOBASSO" 071   "FOGGIA" 072   "BARI" 073   "TARANTO" 074   "BRINDISI" 075   "LECCE" 076   "POTENZA" 077   "MATERA" 078   "COSENZA" 079   "CATANZARO" 080   "REGGIO DI CALABRIA" 081   "TRAPANI" 082   "PALERMO" 083   "MESSINA" 084   "AGRIGENTO" 085   "CALTANISSETTA" 086   "ENNA" 087   "CATANIA" 088   "RAGUSA" 089   "SIRACUSA" 090   "SASSARI" 091   "NUORO" 092   "CAGLIARI" 093   "PORDENONE" 094   "ISERNIA" 095   "ORISTANO" 096   "BIELLA" 097   "LECCO" 098   "LODI" 099   "RIMINI" 100   "PRATO" 101   "CROTONE" 102   "VIBO VALENTIA" 103   "VERBANO-CUSIO-OSSOLA" 104   "OLBIA-TEMPIO" 105   "OGLIASTRA" 106   "MEDIO CAMPIDANO" 107   "CARBONIA-IGLESIAS"  
label define  dipaus_071_cl188 1   "dipendente" 2   "collaboratore" 3   "autonomo"  
label define  dipins_071_cl189 1   "Dipendente" 2   "Indipendente"  
label define  prof1s_071_cl190 1   "LEGISLATORI, DIRIGENTI E IMPRENDITORI" 2   "PROFESSIONI INTELLETTUALI, SCIENTIFICHE E DI ELEVATA SPECIALIZZAZIONE" 3   "PROFESSIONI TECNICHE" 4   "IMPIEGATI" 5   "PROFESSIONI QUALIFICATE NELLE ATTIVITA" 6   "ARTIGIANI, OPERAI SPECIALIZZATI E AGRICOLTORI" 7   "CONDUTTORI DI IMPIANTI E OPERAI SEMIQUALIFICATI ADDETTI A MACCHINARI FISSI E MOBILI" 8   "PROFESSIONI NON QUALIFICATE" 9   "FORZE ARMATE"  
label define  ate2ds_071_cl193 01   "agricoltura, caccia e relativi servizi" 02   "silvicoltura e utilizzazione di aree forestali e servizi connessi" 05   "pesca, piscicoltura e servizi connessi" 10   "estrazione di carbon fossile, lignite, torba" 11   "estrazione di petrolio greggio e di gas naturale e servizi connessi, esclusa la prospezione" 12   "estrazione di minerali di uranio e di torio" 13   "estrazione di minerali metalliferi" 14   "altre industrie estrattive" 15   "industrie alimentari e delle bevande" 16   "industria del tabacco" 17   "industrie tessili" 18   "confezione di articoli di abbigliamento; preparazione, tintura e confezione di pellicce" 19   "preparazione e concia del cuoio; fabbricazione di articoli da viaggio, borse, marocchineria, selleria e calzature" 20   "industria del legno e dei prodotti in legno e sughero, esclusi i mobili; fabbricazione di articoli in materiali da intreccio" 21   "fabbricazione della pasta-carta, della carta e del cartone e dei prodotti di carta" 22   "editoria, stampa e riproduzione di supporti registrati" 23   "fabbricazione di coke, raffinerie di petrolio, trattamento dei combustibili nucleari" 24   "fabbricazione di prodotti chimici e di fibre sintetiche e artificiali" 25   "fabbricazione di articoli in gomma e materie plastiche" 26   "fabbricazione di prodotti della lavorazione di minerali non metalliferi" 27   "metallurgia" 28   "fabbricazione e lavorazione dei prodotti in metallo, esclusi macchine e impianti" 29   "fabbricazione di macchine ed apparecchi meccanici" 30   "fabbricazione di macchine per ufficio, di elaboratori e sistemi informatici" 31   "fabbricazione di macchine ed apparecchi elettrici n.c.a." 32   "fabbricazione di apparecchi radiotelevisivi e di apparecchiature per le comunicazioni" 33   "fabbricazione di apparecchi medicali, di apparecchi di precisione, di strumenti ottici e di orologi" 34   "fabbricazione di autoveicoli, rimorchi e semirimorchi" 35   "fabbricazione di altri mezzi di trasporto" 36   "fabbricazione di mobili; altre industrie manifatturiere" 37   "recupero e preparazione per il riciclaggio" 40   "produzione e distribuzione di energia elettrica, di gas, di calore" 41   "raccolta, depurazione e distribuzione d'acqua" 45   "costruzioni" 50   "commercio, manutenzione e riparazione di autoveicoli e motocicli; vendita al dettaglio di carburanti per autotrazione" 51   "commercio all'ingrosso e intermediari del commercio, autoveicoli e motocicli esclusi" 52   "commercio al dettaglio (escluso quello di autoveicoli e di motocicli); riparazione di beni personali e per la casa" 55   "alberghi e ristoranti" 60   "trasporti terrestri; trasporti mediante condotte" 61   "trasporti marittimi e per vie d'acqua" 62   "trasporti aerei" 63   "attivit di supporto ed ausiliarie dei trasporti; attivit delle agenzie di viaggio" 64   "poste e telecomunicazioni" 65   "intermediazione monetaria e finanziaria (escluse le assicurazioni e i fondi pensione)" 66   "assicurazioni e fondi pensione, escluse le assicurazioni sociali obbligatorie" 67   "attivit ausiliarie dell'intermediazione finanziaria e delle assicurazioni" 70   "attivit immobiliari" 71   "noleggio di macchinari e attrezzature senza operatore e di beni per uso personale e domestico" 72   "informatica e attivit connesse" 73   "ricerca e sviluppo" 74   "attivit di servizi alle imprese" 75   "amministrazione pubblica" 80   "istruzione" 85   "sanit e assistenza sociale" 90   "smaltimento dei rifiuti solidi, delle acque di scarico e simili" 91   "attivit di organizzazioni associative" 92   "attivit ricreative, culturali e sportive" 93   "servizi alle famiglie" 95   "attivit di datore di lavoro per personale domestico svolto da famiglie e convivenze" 96   "produzione di beni per uso proprio da parte di famiglie e convivenze" 97   "produzione di servizi per uso proprio da parte di famiglie e convivenze" 99   "organizzazioni ed organismi extraterritoriali"  
label define  cat12s_071_cl194 01   "Agricoltura, caccia e pesca" 02   "Industria dell energia, estrazione materiali energetici" 03   "Industria della trasformazione" 04   "Industria delle costruzioni" 05   "Altre attivit: commercio" 06   "Altre attivit: alberghi e ristoranti" 07   "Altre attivit: trasporti e comunicazioni" 08   "Altre attivit: intermediazione monetaria e finanziaria, attivit immobiliari" 09   "Altre attivit: servizi alle imprese e altre attivit professionali e imprenditoriali" 10   "Altre attivit: pubblica amministrazione, difesa, assicurazioni sociali obbligatorie" 11   "Altre attivit: istruzione, sanit ed altri servizi sociali" 12   "Altre attivit: altri servizi pubblici, sociali e alle persone"  
label define  cat5s_071_cl195 1   "Agricoltura" 2   "Industria in senso stretto" 3   "Costruzioni" 4   "Commercio" 5   "Altre attivit"  
label define  cat3s_071_cl196 1   "Agricoltura" 2   "Industria" 3   "Terziario"  
label define  dipaua_071_cl197 1   "dipendente" 2   "collaboratore" 3   "autonomo"  
label define  dipina_071_cl198 1   "Dipendente" 2   "Indipendente"  
label define  dipaup_071_cl199 1   "dipendente" 2   "collaboratore" 3   "autonomo"  
label define  dipinp_071_cl200 1   "Dipendente" 2   "Indipendente"  
label define  ate2dp_071_cl201 01   "agricoltura, caccia e relativi servizi" 02   "silvicoltura e utilizzazione di aree forestali e servizi connessi" 05   "pesca, piscicoltura e servizi connessi" 10   "estrazione di carbon fossile, lignite, torba" 11   "estrazione di petrolio greggio e di gas naturale e servizi connessi, esclusa la prospezione" 12   "estrazione di minerali di uranio e di torio" 13   "estrazione di minerali metalliferi" 14   "altre industrie estrattive" 15   "industrie alimentari e delle bevande" 16   "industria del tabacco" 17   "industrie tessili" 18   "confezione di articoli di abbigliamento; preparazione, tintura e confezione di pellicce" 19   "preparazione e concia del cuoio; fabbricazione di articoli da viaggio, borse, marocchineria, selleria e calzature" 20   "industria del legno e dei prodotti in legno e sughero, esclusi i mobili; fabbricazione di articoli in materiali da intreccio" 21   "fabbricazione della pasta-carta, della carta e del cartone e dei prodotti di carta" 22   "editoria, stampa e riproduzione di supporti registrati" 23   "fabbricazione di coke, raffinerie di petrolio, trattamento dei combustibili nucleari" 24   "fabbricazione di prodotti chimici e di fibre sintetiche e artificiali" 25   "fabbricazione di articoli in gomma e materie plastiche" 26   "fabbricazione di prodotti della lavorazione di minerali non metalliferi" 27   "metallurgia" 28   "fabbricazione e lavorazione dei prodotti in metallo, esclusi macchine e impianti" 29   "fabbricazione di macchine ed apparecchi meccanici" 30   "fabbricazione di macchine per ufficio, di elaboratori e sistemi informatici" 31   "fabbricazione di macchine ed apparecchi elettrici n.c.a." 32   "fabbricazione di apparecchi radiotelevisivi e di apparecchiature per le comunicazioni" 33   "fabbricazione di apparecchi medicali, di apparecchi di precisione, di strumenti ottici e di orologi" 34   "fabbricazione di autoveicoli, rimorchi e semirimorchi" 35   "fabbricazione di altri mezzi di trasporto" 36   "fabbricazione di mobili; altre industrie manifatturiere" 37   "recupero e preparazione per il riciclaggio" 40   "produzione e distribuzione di energia elettrica, di gas, di calore" 41   "raccolta, depurazione e distribuzione d'acqua" 45   "costruzioni" 50   "commercio, manutenzione e riparazione di autoveicoli e motocicli; vendita al dettaglio di carburanti per autotrazione" 51   "commercio all'ingrosso e intermediari del commercio, autoveicoli e motocicli esclusi" 52   "commercio al dettaglio (escluso quello di autoveicoli e di motocicli); riparazione di beni personali e per la casa" 55   "alberghi e ristoranti" 60   "trasporti terrestri; trasporti mediante condotte" 61   "trasporti marittimi e per vie d'acqua" 62   "trasporti aerei" 63   "attivit di supporto ed ausiliarie dei trasporti; attivit delle agenzie di viaggio" 64   "poste e telecomunicazioni" 65   "intermediazione monetaria e finanziaria (escluse le assicurazioni e i fondi pensione)" 66   "assicurazioni e fondi pensione, escluse le assicurazioni sociali obbligatorie" 67   "attivit ausiliarie dell'intermediazione finanziaria e delle assicurazioni" 70   "attivit immobiliari" 71   "noleggio di macchinari e attrezzature senza operatore e di beni per uso personale e domestico" 72   "informatica e attivit connesse" 73   "ricerca e sviluppo" 74   "attivit di servizi alle imprese" 75   "amministrazione pubblica" 80   "istruzione" 85   "sanit e assistenza sociale" 90   "smaltimento dei rifiuti solidi, delle acque di scarico e simili" 91   "attivit di organizzazioni associative" 92   "attivit ricreative, culturali e sportive" 93   "servizi alle famiglie" 95   "attivit di datore di lavoro per personale domestico svolto da famiglie e convivenze" 96   "produzione di beni per uso proprio da parte di famiglie e convivenze" 97   "produzione di servizi per uso proprio da parte di famiglie e convivenze" 99   "organizzazioni ed organismi extraterritoriali"  
label define  cat12p_071_cl202 01   "Agricoltura, caccia e pesca" 02   "Industria dell energia, estrazione materiali energetici" 03   "Industria della trasformazione" 04   "Industria delle costruzioni" 05   "Altre attivit: commercio" 06   "Altre attivit: alberghi e ristoranti" 07   "Altre attivit: trasporti e comunicazioni" 08   "Altre attivit: intermediazione monetaria e finanziaria, attivit immobiliari" 09   "Altre attivit: servizi alle imprese e altre attivit professionali e imprenditoriali" 10   "Altre attivit: pubblica amministrazione, difesa, assicurazioni sociali obbligatorie" 11   "Altre attivit: istruzione, sanit ed altri servizi sociali" 12   "Altre attivit: altri servizi pubblici, sociali e alle persone"  
label define  cat5p_071_cl203 1   "Agricoltura" 2   "Industria in senso stretto" 3   "Costruzioni" 4   "Commercio" 5   "Altre attivit"  
label define  cat3p_071_cl204 1   "Agricoltura" 2   "Industria" 3   "Terziario"  
label define  esplav_071_cl205 1   "ha precedenti esperienze lavorative" 2   "non ha precedenti esperienze lavorative"  
label define  nasses_071_cl207 201   "Albania" 202   "Andorra" 203   "Austria" 206   "Belgio" 209   "Bulgaria" 212   "Danimarca" 214   "Finlandia" 215   "Francia" 216   "Germania" 219   "Regno Unito" 220   "Grecia" 221   "Irlanda" 223   "Islanda" 225   "Liechtenstein" 226   "Lussemburgo" 227   "Malta" 229   "Monaco" 231   "Norvegia" 232   "Paesi Bassi" 233   "Polonia" 234   "Portogallo" 235   "Romania" 236   "San Marino" 239   "Spagna" 240   "Svezia" 241   "Svizzera" 243   "Ucraina" 244   "Ungheria" 245   "Russa, Federazione" 246   "Vaticano, Citt" 247   "Estonia" 248   "Lettonia" 249   "Lituania" 250   "Croazia" 251   "Slovenia" 252   "Bosnia-Erzegovina" 253   "Macedonia, ex-Rep. Jugoslavia" 254   "Moldavia" 255   "Slovacchia" 256   "Bielorussia" 257   "Ceca, Repubblica" 270   "Montenegro" 271   "Serbia" 301   "Afghanistan" 302   "Arabia Saudita" 304   "Bahrein" 305   "Bangladesh" 306   "Bhutan" 307   "Myanmar (Birmania)" 309   "Brunei" 310   "Cambogia" 311   "Sri Lanka (Ceylon)" 314   "Cinese, Repubblica Popolare" 315   "Cipro" 319   "Corea, Repubblica Popolare (Nord)" 320   "Corea, Repubblica (Sud)" 322   "Emirati Arabi Uniti" 323   "Filippine" 324   "Palestina" 326   "Giappone" 327   "Giordania" 330   "India" 331   "Indonesia" 332   "Iran" 333   "Iraq" 334   "Israele" 335   "Kuwait" 336   "Laos" 337   "Libano" 338   "Timor orientale" 339   "Maldive" 340   "Malaysia" 341   "Mongolia" 342   "Nepal" 343   "Oman" 344   "Pakistan" 345   "Qatar" 346   "Singapore" 348   "Siria" 349   "Thailandia" 351   "Turchia" 353   "Vietnam" 354   "Yemen" 356   "Kazakistan" 357   "Uzbekistan" 358   "Armenia" 359   "Azerbaigian" 360   "Georgia" 361   "Kirghizistan" 362   "Tagikistan" 363   "Taiwan (Formosa)" 364   "Turkmenistan" 401   "Algeria" 402   "Angola" 404   "Costa d'Avorio" 406   "Benin (Dahomey)" 408   "Botswana" 409   "Burkina Faso (Alto Volta)" 410   "Burundi" 411   "Camerun" 413   "Capo Verde" 414   "Centrafricana, Rep." 415   "Ciad" 417   "Comore" 418   "Congo" 419   "Egitto" 420   "Etiopia" 421   "Gabon" 422   "Gambia" 423   "Ghana" 424   "Gibuti" 425   "Guinea" 426   "Guinea Bissau" 427   "Guinea Equatoriale" 428   "Kenia" 429   "Lesotho" 430   "Liberia" 431   "Libia" 432   "Madagascar" 434   "Malawi" 435   "Mali" 436   "Marocco" 437   "Mauritania" 438   "Maurizio" 440   "Mozambico" 441   "Namibia" 442   "Niger" 443   "Nigeria" 446   "Ruanda" 448   "Sao Tom e Principe" 449   "Seycelles" 450   "Senegal" 451   "Sierra Leone" 453   "Somalia" 454   "Sudafricana, Rep." 455   "Sudan" 456   "Swaziland" 457   "Tanzania" 458   "Togo" 460   "Tunisia" 461   "Uganda" 463   "Congo, Rep.Dem. (Zaire)" 464   "Zambia" 465   "Zimbabwe (Rhodesia)" 466   "Eritrea" 503   "Antigua e Barbuda" 505   "Bahama" 506   "Barbados" 507   "Belize" 509   "Canada" 513   "Costarica" 514   "Cuba" 515   "Dominica" 516   "Dominicana, Rep." 517   "El Salvador" 518   "Giamaica" 519   "Grenada" 523   "Guatemala" 524   "Haiti" 525   "Honduras" 527   "Messico" 529   "Nicaragua" 530   "Panama" 532   "Saint Lucia" 533   "Saint Vincent e Grenadine" 534   "Saint Kitts e Nevis" 536   "Stati Uniti d'America" 602   "Argentina" 604   "Bolivia" 605   "Brasile" 606   "Cile" 608   "Colombia" 609   "Ecuador" 612   "Guyana" 614   "Paraguay" 615   "Per" 616   "Suriname" 617   "Trinidad e Tobago" 618   "Uruguay" 619   "Venezuela" 701   "Australia" 703   "Figi" 708   "Kiribati" 712   "Marshall, Isole" 713   "Micronesia, Stati Federati" 715   "Nauru" 719   "Nuova Zelanda" 720   "Palau" 721   "Papua Nuova Guinea" 725   "Salomone" 727   "Samoa" 730   "Tonga" 731   "Tuvalu" 732   "Vanuatu"  
label define  citses_071_cl208 201   "Albania" 202   "Andorra" 203   "Austria" 206   "Belgio" 209   "Bulgaria" 212   "Danimarca" 214   "Finlandia" 215   "Francia" 216   "Germania" 219   "Regno Unito" 220   "Grecia" 221   "Irlanda" 223   "Islanda" 225   "Liechtenstein" 226   "Lussemburgo" 227   "Malta" 229   "Monaco" 231   "Norvegia" 232   "Paesi Bassi" 233   "Polonia" 234   "Portogallo" 235   "Romania" 236   "San Marino" 239   "Spagna" 240   "Svezia" 241   "Svizzera" 243   "Ucraina" 244   "Ungheria" 245   "Russa, Federazione" 246   "Vaticano, Citt" 247   "Estonia" 248   "Lettonia" 249   "Lituania" 250   "Croazia" 251   "Slovenia" 252   "Bosnia-Erzegovina" 253   "Macedonia, ex-Rep. Jugoslavia" 254   "Moldavia" 255   "Slovacchia" 256   "Bielorussia" 257   "Ceca, Repubblica" 270   "Montenegro" 271   "Serbia" 301   "Afghanistan" 302   "Arabia Saudita" 304   "Bahrein" 305   "Bangladesh" 306   "Bhutan" 307   "Myanmar (Birmania)" 309   "Brunei" 310   "Cambogia" 311   "Sri Lanka (Ceylon)" 314   "Cinese, Repubblica Popolare" 315   "Cipro" 319   "Corea, Repubblica Popolare (Nord)" 320   "Corea, Repubblica (Sud)" 322   "Emirati Arabi Uniti" 323   "Filippine" 324   "Palestina" 326   "Giappone" 327   "Giordania" 330   "India" 331   "Indonesia" 332   "Iran" 333   "Iraq" 334   "Israele" 335   "Kuwait" 336   "Laos" 337   "Libano" 338   "Timor orientale" 339   "Maldive" 340   "Malaysia" 341   "Mongolia" 342   "Nepal" 343   "Oman" 344   "Pakistan" 345   "Qatar" 346   "Singapore" 348   "Siria" 349   "Thailandia" 351   "Turchia" 353   "Vietnam" 354   "Yemen" 356   "Kazakistan" 357   "Uzbekistan" 358   "Armenia" 359   "Azerbaigian" 360   "Georgia" 361   "Kirghizistan" 362   "Tagikistan" 363   "Taiwan (Formosa)" 364   "Turkmenistan" 401   "Algeria" 402   "Angola" 404   "Costa d'Avorio" 406   "Benin (Dahomey)" 408   "Botswana" 409   "Burkina Faso (Alto Volta)" 410   "Burundi" 411   "Camerun" 413   "Capo Verde" 414   "Centrafricana, Rep." 415   "Ciad" 417   "Comore" 418   "Congo" 419   "Egitto" 420   "Etiopia" 421   "Gabon" 422   "Gambia" 423   "Ghana" 424   "Gibuti" 425   "Guinea" 426   "Guinea Bissau" 427   "Guinea Equatoriale" 428   "Kenia" 429   "Lesotho" 430   "Liberia" 431   "Libia" 432   "Madagascar" 434   "Malawi" 435   "Mali" 436   "Marocco" 437   "Mauritania" 438   "Maurizio" 440   "Mozambico" 441   "Namibia" 442   "Niger" 443   "Nigeria" 446   "Ruanda" 448   "Sao Tom e Principe" 449   "Seycelles" 450   "Senegal" 451   "Sierra Leone" 453   "Somalia" 454   "Sudafricana, Rep." 455   "Sudan" 456   "Swaziland" 457   "Tanzania" 458   "Togo" 460   "Tunisia" 461   "Uganda" 463   "Congo, Rep.Dem. (Zaire)" 464   "Zambia" 465   "Zimbabwe (Rhodesia)" 466   "Eritrea" 503   "Antigua e Barbuda" 505   "Bahama" 506   "Barbados" 507   "Belize" 509   "Canada" 513   "Costarica" 514   "Cuba" 515   "Dominica" 516   "Dominicana, Rep." 517   "El Salvador" 518   "Giamaica" 519   "Grenada" 523   "Guatemala" 524   "Haiti" 525   "Honduras" 527   "Messico" 529   "Nicaragua" 530   "Panama" 532   "Saint Lucia" 533   "Saint Vincent e Grenadine" 534   "Saint Kitts e Nevis" 536   "Stati Uniti d'America" 602   "Argentina" 604   "Bolivia" 605   "Brasile" 606   "Cile" 608   "Colombia" 609   "Ecuador" 612   "Guyana" 614   "Paraguay" 615   "Per" 616   "Suriname" 617   "Trinidad e Tobago" 618   "Uruguay" 619   "Venezuela" 701   "Australia" 703   "Figi" 708   "Kiribati" 712   "Marshall, Isole" 713   "Micronesia, Stati Federati" 715   "Nauru" 719   "Nuova Zelanda" 720   "Palau" 721   "Papua Nuova Guinea" 725   "Salomone" 727   "Samoa" 730   "Tonga" 731   "Tuvalu" 732   "Vanuatu" 999   "Apolide"  
label define  trim_081_cl210 1   "Primo trimestre" 2   "Secondo trimestre" 3   "Terzo trimestre" 4   "Quarto trimestre"  
label define  sg24_081_cl212 01   "Nessun titolo" 02   "Licenza elementare" 03   "Licenza media (o avviamento professionale)" 04   "Diploma di scuola superiore di 2-3 anni che non permette l'iscrizione all'Universita'" 05   "Diploma di scuola superiore di 4-5 anni che permette l'iscrizione all'Universit" 06   "Accademia Belle Arti, Istituto Superiore Industrie Artistiche, Accademia di arte drammatica, Perfezionamento Accademia di Danza, Perfezionamento Conservatorio, Perfezionamento Istituto di Musica Pareg" 07   "Diploma universitario di due/tre anni, Scuola diretta a fini speciali, Scuola parauniversitaria" 08   "Laurea di 3 anni di primo livello (nuovo ordinamento)" 09   "Laurea specialistica di 2 anni di secondo livello (nuovo ordinamento)" 10   "Laurea di 4 anni o pi (vecchio ordinamento o nuova laurea specialistica" 11   "Specializzazione post-laurea (compresi master di 1 e 2 livello)" 12   "Dottorato di ricerca"  
label define  sg24a_081_cl213 001   "Diploma (vecchio ordinamento)" 002   "Diploma accademico di alta formazione artistica e musicale di I livello (nuovo ordinamento)" 003   "Diploma accademico di alta formazione artistica e musicale di II livello (nuovo ordinamento)" 997   "Non sa"  
label define  b1_081_cl214 1   "Si" 2   "No" 3   "Permanentemente inabile al lavoro"  
label define  b2_081_cl215 1   "S" 2   "No"  
label define  b3_081_cl216 001   "Cassa Integrazione Guadagni (CIG ordinaria o straordinaria)" 002   "Ridotta attivit dell'impresa per motivi economici e/o tecnici (esclusa CIG)" 003   "Sciopero" 004   "Vertenza sindacale, controversia di lavoro" 005   "Maltempo" 006   "Malattia, problemi di salute personali" 007   "Ferie" 008   "Festivit nella settimana" 009   "Orario variabile o flessibile (ad es. riposo compensativo)" 010   "Part-time verticale" 011   "Studio o Formazione non organizzata nell'ambito del proprio lavoro" 012   "Assenza obbligatoria per maternit" 013   "Assenza facoltativa fino all'ottavo anno del bambino (congedo parentale)" 014   "Motivi familiari (esclusa maternit obbligatoria e congedo parentale)" 015   "Mancanza/scarsit di lavoro" 994   "Fa un lavoro occasionale" 995   "Fa un lavoro stagionale alle dipendenze (ad es. bagnino,  raccoglitore di frutta, cameriere in montagna dinverno ect.)" 996   "Altro motivo (specificare)"  
label define  b3bis_081_cl217 1   "Si" 2   "No" 3   "Aveva un lavoro, ma era assente" 4   "Non aveva un lavoro"  
label define  b4_081_cl218 1   "Un lavoro alle dipendenze" 2   "Un lavoro di: Collaborazione coordinata e continuativa (con o senza progetto)" 3   "Un lavoro di: Prestazione d'opera occasionale" 4   "Un lavoro autonomo come: Imprenditore" 5   "Un lavoro autonomo come: Libero professionista" 6   "Un lavoro autonomo come: Lavoratore in proprio" 7   "Un lavoro autonomo come: Coadiuvante nell'azienda di un familiare" 8   "Un lavoro autonomo come: Socio di cooperativa"  
label define  b4a_081_cl219 1   "Si,  Contratto di lavoro alle dipendenze" 2   "Si,  Contratto di collaborazione coordinata e continuativa (con o senza progetto)" 3   "No"  
label define  b4bis_081_cl220 1   "S" 2   "No"  
label define  b6_081_cl221 1   "Fino a tre mesi" 2   "Pi di tre mesi"  
label define  b7_081_cl222 1   "S, il 50% o pi" 2   "S, meno del 50%" 3   "No, non retribuito"  
label define  b8_081_cl223 001   "S" 002   "No" 997   "Non sa" 998   "Non risponde"  
label define  b9_081_cl224 1   "S" 2   "No"  
label define  b10_081_cl225 1   "S" 2   "No"  
label define  b11_081_cl226 1   "Momentaneamente sospesa" 2   "Conclusa"  
label define  c1_081_cl227 1   "Un lavoro alle dipendenze" 2   "Un lavoro di: Collaborazione coordinata e continuativa (con o senza progetto)" 3   "Un lavoro di: Prestazione d'opera occasionale" 4   "Un lavoro autonomo come: Imprenditore" 5   "Un lavoro autonomo come: Libero professionista" 6   "Un lavoro autonomo come: Lavoratore in proprio" 7   "Un lavoro autonomo come: Coadiuvante nell'azienda di un familiare" 8   "Un lavoro autonomo come: Socio di cooperativa"  
label define  c1bis_081_cl228 1   "S" 2   "No"  
label define  c1a_081_cl229 1   "Si,  Contratto di lavoro alle dipendenze" 2   "Si,  Contratto di collaborazione coordinata e continuativa (con o senza progetto)" 3   "No"  
label define  c1b_081_cl230 1   "S" 2   "No"  
label define  c1d_081_cl231 1   "S" 2   "No"  
label define  c4_081_cl232 1   "S" 2   "No"  
label define  c5_081_cl233 001   "Per un sola azienda/cliente" 002   "Per pi aziende/clienti" 997   "Non sa"  
label define  c6_081_cl234 001   "Decide dove lavorare/lavora presso il proprio ufficio" 002   "Lavora presso l'azienda/cliente/committente" 997   "Non sa"  
label define  c7_081_cl235 001   "Decide autonomamente l'orario" 002   "Non decide l'orario" 997   "Non sa"  
label define  c9_081_cl236 1   "Dirigente" 2   "Quadro" 3   "Impiegato" 4   "Operaio" 5   "Apprendista" 6   "Lavoratore presso il proprio domicilio per conto di un'impresa"  
label define  c10_081_cl237 001   "S" 002   "No" 997   "Non sa"  
label define  c14_081_cl238 001   "Solo una sede" 002   "Pi sedi" 997   "Non sa"  
label define  c18_081_cl240 1   "Fino a 10 persone" 2   "Da 11 a 15" 3   "Da 16 a 19" 4   "Da 20 a 49" 5   "Da 50 a 249" 6   "250 persone o pi" 7   "Non sa ma fino a 10" 8   "Non sa ma pi di 10"  
label define  c20_081_cl242 1   "A termine (tempo determinato)" 2   "A tempo indeterminato (senza una scadenza)"  
label define  c22_081_cl244 001   "Periodo di formazione, apprendistato" 002   "Periodo di prova" 003   "Lavoro stagionale" 004   "Lavoro occasionale (comprese supplenza nella scuola o sostituzione di un lavoratore assente compresa l'assenza per maternit)" 005   "Lavoro per la realizzazione di un progetto" 006   "Occupare un posto vacante (incarico a termine nella scuola, nella sanit, etc.)" 996   "Altro (specificare)" 997   "Non sa"  
label define  c23a_081_cl245 001   "Di inserimento lavorativo o formazione e lavoro" 002   "Di apprendistato" 003   "Altro tipo di contratto (tempo determinato, interinale, ecc.)" 994   "Contratto di collaborazione coordinata e continuativa (con o senza progetto)" 995   "Contratto di prestazione dopera occasionale" 997   "Non sa"  
label define  c24_081_cl246 001   "S" 002   "No" 997   "Non sa"  
label define  c24bis_081_cl247 001   "Dallimpresa" 002   "Dallagenzia interinale" 997   "Non sa"  
label define  c24ter_081_cl248 001   "S" 002   "No" 997   "Non sa"  
label define  c25_081_cl249 001   "Non vuole un lavoro a tempo indeterminato" 002   "Non ha trovato un lavoro a tempo indeterminato" 997   "Non sa"  
label define  c27_081_cl250 1   "A tempo pieno" 2   "A tempo parziale (part-time)"  
label define  c28_081_cl251 001   "Non vuole un lavoro a tempo pieno" 002   "Non ha trovato un lavoro a tempo pieno" 003   "Altri motivi" 997   "Non sa"  
label define  c29_081_cl252 001   "Studia o sta seguendo corsi di formazione professionale" 002   "Malattia, problemi di salute personali" 003   "Per prendersi cura dei figli, di bambini e/o di altre persone non autosufficienti" 004   "Svolge un secondo lavoro" 005   "Altri motivi familiari (esclusa cura dei figli o di altre persone)" 006   "Avere a disposizione pi tempo libero" 996   "Altri motivi (specificare)"  
label define  c29b_081_cl253 001   "S, sono assenti/inadeguati i servizi per la cura di bambini" 002   "S, sono assenti/inadeguati i servizi per la cura di persone anziane, malate, disabili" 003   "S, entrambi i servizi sono assenti/inadeguati" 004   "No" 997   "Non sa"  
label define  c32_081_cl256 001   "Meno del solito" 002   "Piu' del solito" 003   "Come al solito" 997   "Non sa"  
label define  c33_081_cl257 001   "Orario variabile, flessibile" 002   "Straordinario retribuito e/o non retribuito" 004   "Maggiori impegni di lavoro" 996   "Altro (specificare)"  
label define  c34_081_cl258 001   "Cassa Integrazione Guadagni (ordinaria o straordinaria)" 002   "Ridotta attivit dell'impresa per motivi economici e/o tecnici (esclusa CIG)" 003   "Sciopero" 004   "Vertenza sindacale, controversia di lavoro" 005   "Maltempo" 006   "Malattia, problemi di salute personali, infortunio" 007   "Ferie" 008   "Festivit nella settimana" 009   "Orario variabile o flessibile (ad es. riposo compensativo)" 010   "Part-time verticale" 011   "Studio o formazione non organizzata nell'ambito del proprio lavoro" 012   "Assenza obbligatoria per maternit" 013   "Assenza facoltativa fino all'ottavo anno del bambino (congedo parentale)" 014   "Motivi familiari (esclusa maternit obbligatoria e congedo parentale)" 015   "Mancanza di occasioni di maggior lavoro" 016   "Inizio o cambiamento del lavoro nella settimana" 017   "Ha concluso il lavoro nella settimana" 996   "Altro (specificare)"  
label define  c35_081_cl259 001   "S" 002   "No" 997   "Non sa"  
label define  c38_081_cl263 001   "S, meno ore" 002   "S, pi ore" 003   "No (avrebbe voluto lavorare lo stesso numero di ore)" 997   "Non sa"  
label define  c39a_081_cl265 1   "Aggiungendo un nuovo lavoro a quello che ha gi" 2   "Cambiando lavoro" 3   "Continuando a fare lo stesso lavoro" 4   "In uno qualunque dei modi precedenti"  
label define  c40_081_cl266 001   "S" 002   "No" 997   "Non sa"  
label define  c41_081_cl267 001   "Malattia, problemi di salute personali" 002   "Studio o Formazione non organizzata nell'ambito del proprio lavoro" 003   "Altri motivi personali (specificare)" 004   "Maternit, nascita di un figlio" 005   "Altri motivi familiari (esclusa cura dei figli o di altre persone)" 006   "Deve dare un preavviso" 007   "Per prendersi cura dei figli, bambini e/o di altre persone non autosufficienti" 996   "Altro motivo (specificare)" 997   "Non sa" 998   "Non risponde"  
label define  c42_081_cl268 001   "S, 2 o pi volte a settimana" 002   "S, meno di 2 volte a settimana" 003   "No" 997   "Non sa"  
label define  c43_081_cl269 001   "S, 2 o pi volte a settimana" 002   "S, meno di 2 volte a settimana" 003   "No" 997   "Non sa"  
label define  c44_081_cl270 001   "S, 2 o pi volte (nelle 4 settimane)" 002   "S, meno di 2 volte (nelle 4 settimane)" 003   "No" 997   "Non sa"  
label define  c45_081_cl271 001   "S, 2 o pi volte (nelle 4 settimane)" 002   "S, meno di 2 volte (nelle 4 settimane)" 003   "No" 997   "Non sa"  
label define  c46_081_cl272 001   "S" 002   "No" 997   "Non sa"  
label define  c47_081_cl273 001   "S" 002   "No" 997   "Non sa"  
label define  c48_081_cl274 001   "S, 2 o pi volte a settimana" 002   "S, meno di 2 volte a settimana" 003   "No" 997   "Non sa"  
label define  c53_081_cl275 001   "S, da un altro comune italiano" 003   "S, dall'estero" 004   "No" 005   "S, ma poi  tornato nel comune di residenza" 997   "Non sa"  
label define  c59_081_cl276 001   "S" 002   "No" 997   "Non sa"  
label define  c60_081_cl277 001   "S" 002   "No" 997   "Non sa"  
label define  d1_081_cl278 1   "S, un altro lavoro" 2   "S, pi di uno" 3   "No"  
label define  d3_081_cl280 001   "Regolarmente" 002   "Solo in alcune stagioni (o in particolari periodi dell'anno)" 003   "Ogni tanto, quando capita" 997   "Non sa"  
label define  d4_081_cl281 1   "Un lavoro alle dipendenze" 2   "Un lavoro di: Collaborazione coordinata e continuativa (con o senza progetto)" 3   "Un lavoro di: Prestazione d'opera occasionale" 4   "Un lavoro autonomo come: Imprenditore" 5   "Un lavoro autonomo come: Libero professionista" 6   "Un lavoro autonomo come: Lavoratore in proprio" 7   "Un lavoro autonomo come: Coadiuvante nell'azienda di un familiare" 8   "Un lavoro autonomo come: Socio di cooperativa"  
label define  d5_081_cl282 1   "Si,  Contratto di lavoro alle dipendenze" 2   "Si,  Contratto di collaborazione coordinata e continuativa (con o senza progetto)" 3   "No"  
label define  d5a_081_cl283 1   "S" 2   "No"  
label define  d5bis_081_cl284 1   "S" 2   "No"  
label define  d7_081_cl285 1   "S" 2   "No"  
label define  f1_081_cl287 1   "S" 2   "No"  
label define  f2_081_cl288 1   "Un nuovo lavoro" 2   "Un secondo lavoro (da aggiungere a quello attuale)"  
label define  f3_081_cl289 001   "Lavoro attuale  a termine (lavoro a tempo determinato)" 002   "Teme di perdere l'attuale lavoro" 003   "Considera l'attuale lavoro occasionale" 004   "Guadagnare di pi" 005   "Raggiungere pi facilmente il luogo di lavoro" 006   "Orario pi adatto a prendersi cura dei figli e/o di altri familiari" 007   "Orario diverso per altri motivi" 008   "Cerca un lavoro pi qualificante per le proprie  capacit/competenze e con maggiori prospettive di carriera" 009   "Cerca un lavoro pi adatto alle proprie condizioni di salute" 996   "Altri motivi (specificare)"  
label define  f4_081_cl290 001   "Pi ore" 002   "Meno ore" 003   "Lo stesso numero di ore" 997   "Non sa"  
label define  f5_081_cl291 1   "S" 2   "No"  
label define  f6_01_081_cl292 0   "No" 1   "Si"  
label define  f6_02_081_cl293 0   "No" 1   "Si"  
label define  f6_03_081_cl294 0   "No" 1   "Si"  
label define  f6_04_081_cl295 0   "No" 1   "Si"  
label define  f6_05_081_cl296 0   "No" 1   "Si"  
label define  f6_06_081_cl297 0   "No" 1   "Si"  
label define  f6_07_081_cl298 0   "No" 1   "Si"  
label define  f6_08_081_cl299 0   "No" 1   "Si"  
label define  f6_09_081_cl300 0   "No" 1   "Si"  
label define  f6_10_081_cl301 0   "No" 1   "Si"  
label define  f6_11_081_cl302 0   "No" 1   "Si"  
label define  f6_12_081_cl303 0   "No" 1   "Si"  
label define  f6_96_081_cl304 0   "No" 1   "Si"  
label define  f7_081_cl305 1   "S" 2   "No"  
label define  f8_081_cl306 1   "S" 2   "No"  
label define  f10_081_cl308 001   "Ha gi un lavoro che inizier in futuro" 002   "Studia o segue corsi di formazione professionale" 003   "Malattia, problemi di salute personali" 004   "Per prendersi cura dei figli, di bambini e/o di altre  persone non autosufficenti" 005   "In attesa di tornare al suo posto di lavoro" 007   "Pensione da lavoro (anzianit o vecchiaia)" 008   "Ritiene di non riuscire a trovare lavoro" 009   "Non gli interessa/non ne ha bisogno (anche per motivi di et)" 010   "Sta aspettando gli esiti di passate azioni di ricerca" 011   "Inabile al lavoro" 012   "Maternit, nascita di un figlio" 013   "Altri motivi familiari (esclusa maternit, cura dei figli o di altre persone)" 996   "Altri motivi (specificare)" 997   "Non sa"  
label define  f10a_081_cl309 001   "S, sono assenti/inadeguati i servizi per la cura di bambini" 002   "S, sono assenti/inadeguati i servizi per la cura di persone anziane, malate, disabili" 003   "S, entrambi i servizi sono assenti/inadeguati" 004   "No" 997   "Non sa"  
label define  f12_081_cl310 1   "S" 2   "No"  
label define  f13_081_cl311 1   "S" 2   "No"  
label define  f14_081_cl312 001   "Studia o segue corsi di formazione professionale" 002   "Altri motivi personali" 003   "Maternit, nascita di un figlio" 004   "Altri motivi familiari (esclusa la maternit, cura dei figli o di altre persone)" 005   "Malattia, problemi di salute personali" 006   "Deve dare un preavviso" 007   "Deve o vuole concludere il lavoro gi iniziato" 009   "Per prendersi cura dei figli, di bambini e/o di altre persone non autosufficienti" 996   "Altri motivi (specificare)" 997   "Non sa" 998   "Non risponde"  
label define  f15_081_cl313 001   "S" 002   "No" 997   "Non sa"  
label define  f16_081_cl314 1   "S" 2   "No"  
label define  f17_081_cl315 1   "S" 2   "No"  
label define  f18_081_cl316 1   "S" 2   "No"  
label define  f19_081_cl317 1   "S" 2   "No"  
label define  f20_081_cl318 1   "S" 2   "No"  
label define  f21_081_cl319 1   "S" 2   "No"  
label define  f22_081_cl320 1   "S" 2   "No"  
label define  f23_081_cl321 1   "S" 2   "No"  
label define  f24_081_cl322 1   "S" 2   "No"  
label define  f25_081_cl323 1   "S" 2   "No"  
label define  f26_081_cl324 1   "S" 2   "No"  
label define  f27_081_cl325 1   "S" 2   "No"  
label define  f28_081_cl326 1   "Si (specificare)" 2   "No"  
label define  f29_01_081_cl327 0   "No" 1   "Si"  
label define  f29_02_081_cl328 0   "No" 1   "Si"  
label define  f29_03_081_cl329 0   "No" 1   "Si"  
label define  f29_04_081_cl330 0   "No" 1   "Si"  
label define  f29_97_081_cl331 0   "No" 1   "Si"  
label define  f30_081_cl332 1   "S" 2   "No"  
label define  f32_081_cl334 1   "Studiava" 2   "Era in servizio militare o in servizio civile sostitutivo" 3   "Lavorava" 4   "Si prendeva cura della casa e/o dei familiari" 5   "In altra condizione"  
label define  f33_081_cl335 1   "S" 2   "No"  
label define  f34_081_cl336 001   "Studia o segue corsi di formazione professionale" 002   "Altri motivi personali" 003   "Maternit, nascita di un figlio" 004   "Altri motivi familiari (esclusa la maternit, cura dei figli o di altre persone)" 005   "Malattia, problemi di salute personali" 006   "Deve dare un preavviso" 007   "Deve o vuole concludere il lavoro gi iniziato" 009   "Per prendersi cura dei figli, di bambini e/o di altre persone non autosufficienti" 996   "Altri motivi (specificare)" 997   "Non sa" 998   "Non risponde"  
label define  f35_081_cl337 1   "In proprio" 2   "Dipendente" 3   "Senza preferenze"  
label define  f36_081_cl338 1   "A tempo pieno" 2   "A tempo parziale (part-time)" 3   "Senza preferenze"  
label define  f37_081_cl339 1   "S" 2   "No"  
label define  f38_081_cl340 1   "S" 2   "No"  
label define  f39_081_cl341 001   "A termine" 002   "A tempo indeterminato" 997   "Non sa"  
label define  f40_081_cl342 001   "S" 002   "No" 997   "Non sa"  
label define  f41_081_cl343 001   "Soltanto nel comune di residenza" 002   "In altro comune raggiungibile giornalmente" 003   "Ovunque, in Italia" 004   "Ovunque, anche all'estero" 997   "Non sa"  
label define  f44_081_cl346 1   "Studiava" 2   "Era in servizio militare o in servizio civile sostitutivo" 3   "Lavorava" 4   "Si prendeva cura dei figli e/o di altri familiari" 5   "In altra condizione"  
label define  f45_081_cl347 1   "Entro i prossimi 3 mesi" 2   "Tra pi di 3 mesi"  
label define  f46_081_cl348 1   "S" 2   "No"  
label define  f47_081_cl349 001   "Studia o segue corsi di formazione professionale" 002   "Altri motivi personali" 003   "Maternit, nascita di un figlio" 004   "Altri motivi familiari (esclusa la maternit, cura dei figli o di altre persone)" 005   "Malattia, problemi di salute personali" 006   "Deve dare un preavviso" 007   "Deve o vuole concludere il lavoro gi iniziato" 009   "Per prendersi cura dei figli, di bambini e/o di altre persone non autosufficienti" 996   "Altri motivi (specificare)" 997   "Non sa" 998   "Non risponde"  
label define  f48_081_cl350 1   "In proprio" 2   "Alle dipendenze"  
label define  f49_081_cl351 001   "Tempo pieno" 002   "Part-time (a tempo parziale)" 997   "Non sa"  
label define  f50_081_cl352 001   "S" 002   "No" 997   "Non sa"  
label define  i1_081_cl353 1   "Occupato" 2   "Disoccupato alla ricerca di nuova occupazione" 3   "In cerca di prima occupazione" 4   "Casalinga/o" 5   "Studente" 6   "Ritirato/a dal lavoro" 7   "Inabile al lavoro" 9   "In altra condizione (specificare)"  
label define  llases_081_cl354 201   "Albania" 202   "Andorra" 203   "Austria" 206   "Belgio" 209   "Bulgaria" 212   "Danimarca" 214   "Finlandia" 215   "Francia" 216   "Germania" 219   "Regno Unito" 220   "Grecia" 221   "Irlanda" 223   "Islanda" 225   "Liechtenstein" 226   "Lussemburgo" 227   "Malta" 229   "Monaco" 231   "Norvegia" 232   "Paesi Bassi" 233   "Polonia" 234   "Portogallo" 235   "Romania" 236   "San Marino" 239   "Spagna" 240   "Svezia" 241   "Svizzera" 243   "Ucraina" 244   "Ungheria" 245   "Russa, Federazione" 246   "Vaticano, Citt" 247   "Estonia" 248   "Lettonia" 249   "Lituania" 250   "Croazia" 251   "Slovenia" 252   "Bosnia-Erzegovina" 253   "Macedonia, ex-Rep. Jugoslavia" 254   "Moldavia" 255   "Slovacchia" 256   "Bielorussia" 257   "Ceca, Repubblica" 270   "Montenegro" 271   "Serbia" 301   "Afghanistan" 302   "Arabia Saudita" 304   "Bahrein" 305   "Bangladesh" 306   "Bhutan" 307   "Myanmar (Birmania)" 309   "Brunei" 310   "Cambogia" 311   "Sri Lanka (Ceylon)" 314   "Cinese, Repubblica Popolare" 315   "Cipro" 319   "Corea, Repubblica Popolare (Nord)" 320   "Corea, Repubblica (Sud)" 322   "Emirati Arabi Uniti" 323   "Filippine" 324   "Palestina" 326   "Giappone" 327   "Giordania" 330   "India" 331   "Indonesia" 332   "Iran" 333   "Iraq" 334   "Israele" 335   "Kuwait" 336   "Laos" 337   "Libano" 338   "Timor orientale" 339   "Maldive" 340   "Malaysia" 341   "Mongolia" 342   "Nepal" 343   "Oman" 344   "Pakistan" 345   "Qatar" 346   "Singapore" 348   "Siria" 349   "Thailandia" 351   "Turchia" 353   "Vietnam" 354   "Yemen" 356   "Kazakistan" 357   "Uzbekistan" 358   "Armenia" 359   "Azerbaigian" 360   "Georgia" 361   "Kirghizistan" 362   "Tagikistan" 363   "Taiwan (Formosa)" 364   "Turkmenistan" 401   "Algeria" 402   "Angola" 404   "Costa d'Avorio" 406   "Benin (Dahomey)" 408   "Botswana" 409   "Burkina Faso (Alto Volta)" 410   "Burundi" 411   "Camerun" 413   "Capo Verde" 414   "Centrafricana, Rep." 415   "Ciad" 417   "Comore" 418   "Congo" 419   "Egitto" 420   "Etiopia" 421   "Gabon" 422   "Gambia" 423   "Ghana" 424   "Gibuti" 425   "Guinea" 426   "Guinea Bissau" 427   "Guinea Equatoriale" 428   "Kenia" 429   "Lesotho" 430   "Liberia" 431   "Libia" 432   "Madagascar" 434   "Malawi" 435   "Mali" 436   "Marocco" 437   "Mauritania" 438   "Maurizio" 440   "Mozambico" 441   "Namibia" 442   "Niger" 443   "Nigeria" 446   "Ruanda" 448   "Sao Tom e Principe" 449   "Seycelles" 450   "Senegal" 451   "Sierra Leone" 453   "Somalia" 454   "Sudafricana, Rep." 455   "Sudan" 456   "Swaziland" 457   "Tanzania" 458   "Togo" 460   "Tunisia" 461   "Uganda" 463   "Congo, Rep.Dem. (Zaire)" 464   "Zambia" 465   "Zimbabwe (Rhodesia)" 466   "Eritrea" 503   "Antigua e Barbuda" 505   "Bahama" 506   "Barbados" 507   "Belize" 509   "Canada" 513   "Costarica" 514   "Cuba" 515   "Dominica" 516   "Dominicana, Rep." 517   "El Salvador" 518   "Giamaica" 519   "Grenada" 523   "Guatemala" 524   "Haiti" 525   "Honduras" 527   "Messico" 529   "Nicaragua" 530   "Panama" 532   "Saint Lucia" 533   "Saint Vincent e Grenadine" 534   "Saint Kitts e Nevis" 536   "Stati Uniti d'America" 602   "Argentina" 604   "Bolivia" 605   "Brasile" 606   "Cile" 608   "Colombia" 609   "Ecuador" 612   "Guyana" 614   "Paraguay" 615   "Per" 616   "Suriname" 617   "Trinidad e Tobago" 618   "Uruguay" 619   "Venezuela" 701   "Australia" 703   "Figi" 708   "Kiribati" 712   "Marshall, Isole" 713   "Micronesia, Stati Federati" 715   "Nauru" 719   "Nuova Zelanda" 720   "Palau" 721   "Papua Nuova Guinea" 725   "Salomone" 727   "Samoa" 730   "Tonga" 731   "Tuvalu" 732   "Vanuatu"  
label define  cond3_081_cl355 1   "occupati" 2   "persone in cerca" 3   "inattivi"  
label define  cond10_081_cl356 01   "occupati" 02   "persone in cerca, con precedenti esperienze, ex-occupati" 03   "persone in cerca, con precedenti esperienze, ex-inattivi" 04   "persone in cerca, senza precedenti esperienze" 05   "inattivi in et lav., cercano non attivamente ma disponibili" 06   "inattivi in et lav., cercano ma non disponibili" 07   "inattivi in et lav., non cercano ma disponibili" 08   "inattivi in et lav., non cercano e non disponibili (anche militari di leva e inabili al lavoro)" 09   "inattivi in et non lav., meno di 15 anni" 10   "inattivi in et non lav., pi di 64 anni"  
label define  dipaut_081_cl357 1   "dipendente" 2   "collaboratore" 3   "autonomo"  
label define  dipind_081_cl358 1   "Dipendente" 2   "Indipendente"  
label define  assocc_081_cl359 1   "S" 2   "No"  
label define  pospro_081_cl360 01   "Dirigente" 02   "Quadro" 03   "Impiegato" 04   "Operaio" 05   "Apprendista" 06   "Lavoratore presso il proprio domicilio per conto di un impresa" 07   "Imprenditore" 08   "Libero professionista" 09   "Lavoratore in proprio" 10   "Socio di cooperativa" 11   "Coadiuvante nell azienda di un familiare" 12   "Collaborazione coordinata e continuativa" 13   "Prestazione d opera occasionale"  
label define  detind_081_cl361 1   "tempo determinato" 2   "tempo indeterminato"  
label define  piepar_081_cl362 1   "tempo pieno" 2   "tempo parziale"  
label define  prof1_081_cl364 1   "LEGISLATORI, DIRIGENTI E IMPRENDITORI" 2   "PROFESSIONI INTELLETTUALI, SCIENTIFICHE E DI ELEVATA SPECIALIZZAZIONE" 3   "PROFESSIONI TECNICHE" 4   "IMPIEGATI" 5   "PROFESSIONI QUALIFICATE NELLE ATTIVITA" 6   "ARTIGIANI, OPERAI SPECIALIZZATI E AGRICOLTORI" 7   "CONDUTTORI DI IMPIANTI E OPERAI SEMIQUALIFICATI ADDETTI A MACCHINARI FISSI E MOBILI" 8   "PROFESSIONI NON QUALIFICATE" 9   "FORZE ARMATE"  
label define  ate2d_081_cl367 01   "agricoltura, caccia e relativi servizi" 02   "silvicoltura e utilizzazione di aree forestali e servizi connessi" 05   "pesca, piscicoltura e servizi connessi" 10   "estrazione di carbon fossile, lignite, torba" 11   "estrazione di petrolio greggio e di gas naturale e servizi connessi, esclusa la prospezione" 12   "estrazione di minerali di uranio e di torio" 13   "estrazione di minerali metalliferi" 14   "altre industrie estrattive" 15   "industrie alimentari e delle bevande" 16   "industria del tabacco" 17   "industrie tessili" 18   "confezione di articoli di abbigliamento; preparazione, tintura e confezione di pellicce" 19   "preparazione e concia del cuoio; fabbricazione di articoli da viaggio, borse, marocchineria, selleria e calzature" 20   "industria del legno e dei prodotti in legno e sughero, esclusi i mobili; fabbricazione di articoli in materiali da intreccio" 21   "fabbricazione della pasta-carta, della carta e del cartone e dei prodotti di carta" 22   "editoria, stampa e riproduzione di supporti registrati" 23   "fabbricazione di coke, raffinerie di petrolio, trattamento dei combustibili nucleari" 24   "fabbricazione di prodotti chimici e di fibre sintetiche e artificiali" 25   "fabbricazione di articoli in gomma e materie plastiche" 26   "fabbricazione di prodotti della lavorazione di minerali non metalliferi" 27   "metallurgia" 28   "fabbricazione e lavorazione dei prodotti in metallo, esclusi macchine e impianti" 29   "fabbricazione di macchine ed apparecchi meccanici" 30   "fabbricazione di macchine per ufficio, di elaboratori e sistemi informatici" 31   "fabbricazione di macchine ed apparecchi elettrici n.c.a." 32   "fabbricazione di apparecchi radiotelevisivi e di apparecchiature per le comunicazioni" 33   "fabbricazione di apparecchi medicali, di apparecchi di precisione, di strumenti ottici e di orologi" 34   "fabbricazione di autoveicoli, rimorchi e semirimorchi" 35   "fabbricazione di altri mezzi di trasporto" 36   "fabbricazione di mobili; altre industrie manifatturiere" 37   "recupero e preparazione per il riciclaggio" 40   "produzione e distribuzione di energia elettrica, di gas, di calore" 41   "raccolta, depurazione e distribuzione d'acqua" 45   "costruzioni" 50   "commercio, manutenzione e riparazione di autoveicoli e motocicli; vendita al dettaglio di carburanti per autotrazione" 51   "commercio all'ingrosso e intermediari del commercio, autoveicoli e motocicli esclusi" 52   "commercio al dettaglio (escluso quello di autoveicoli e di motocicli); riparazione di beni personali e per la casa" 55   "alberghi e ristoranti" 60   "trasporti terrestri; trasporti mediante condotte" 61   "trasporti marittimi e per vie d'acqua" 62   "trasporti aerei" 63   "attivit di supporto ed ausiliarie dei trasporti; attivit delle agenzie di viaggio" 64   "poste e telecomunicazioni" 65   "intermediazione monetaria e finanziaria (escluse le assicurazioni e i fondi pensione)" 66   "assicurazioni e fondi pensione, escluse le assicurazioni sociali obbligatorie" 67   "attivit ausiliarie dell'intermediazione finanziaria e delle assicurazioni" 70   "attivit immobiliari" 71   "noleggio di macchinari e attrezzature senza operatore e di beni per uso personale e domestico" 72   "informatica e attivit connesse" 73   "ricerca e sviluppo" 74   "attivit di servizi alle imprese" 75   "amministrazione pubblica" 80   "istruzione" 85   "sanit e assistenza sociale" 90   "smaltimento dei rifiuti solidi, delle acque di scarico e simili" 91   "attivit di organizzazioni associative" 92   "attivit ricreative, culturali e sportive" 93   "servizi alle famiglie" 95   "attivit di datore di lavoro per personale domestico svolto da famiglie e convivenze" 96   "produzione di beni per uso proprio da parte di famiglie e convivenze" 97   "produzione di servizi per uso proprio da parte di famiglie e convivenze" 99   "organizzazioni ed organismi extraterritoriali"  
label define  cat12_081_cl368 01   "Agricoltura, caccia e pesca" 02   "Industria dell energia, estrazione materiali energetici" 03   "Industria della trasformazione" 04   "Industria delle costruzioni" 05   "Altre attivit: commercio" 06   "Altre attivit: alberghi e ristoranti" 07   "Altre attivit: trasporti e comunicazioni" 08   "Altre attivit: intermediazione monetaria e finanziaria, attivit immobiliari" 09   "Altre attivit: servizi alle imprese e altre attivit professionali e imprenditoriali" 10   "Altre attivit: pubblica amministrazione, difesa, assicurazioni sociali obbligatorie" 11   "Altre attivit: istruzione, sanit ed altri servizi sociali" 12   "Altre attivit: altri servizi pubblici, sociali e alle persone"  
label define  cat5_081_cl369 1   "Agricoltura" 2   "Industria in senso stretto" 3   "Costruzioni" 4   "Commercio" 5   "Altre attivit"  
label define  cat3_081_cl370 1   "Agricoltura" 2   "Industria" 3   "Terziario"  
label define  lavspe_081_cl371 1   "Nel comune di residenza" 2   "Altro comune della stessa provincia" 3   "Altra provincia nella stessa regione" 4   "Altra regione" 5   "All estero"  
label define  regspe_081_cl372 01   "Piemonte" 02   "Valle d'Aosta" 03   "Lombardia" 04   "Trentino alto Adige" 05   "Veneto" 06   "Friuli Venezia Giulia" 07   "Liguria" 08   "Emilia Romagna" 09   "Toscana" 10   "Umbria" 11   "Marche" 12   "Lazio" 13   "Abruzzo" 14   "Molise" 15   "Campania" 16   "Puglia" 17   "Basilicata" 18   "Calabria" 19   "Sicilia" 20   "Sardegna"  
label define  prospe_081_cl373 001   "TORINO" 002   "VERCELLI" 003   "NOVARA" 004   "CUNEO" 005   "ASTI" 006   "ALESSANDRIA" 007   "AOSTA" 008   "IMPERIA" 009   "SAVONA" 010   "GENOVA" 011   "LA SPEZIA" 012   "VARESE" 013   "COMO" 014   "SONDRIO" 015   "MILANO" 016   "BERGAMO" 017   "BRESCIA" 018   "PAVIA" 019   "CREMONA" 020   "MANTOVA" 021   "BOLZANO" 022   "TRENTO" 023   "VERONA" 024   "VICENZA" 025   "BELLUNO" 026   "TREVISO" 027   "VENEZIA" 028   "PADOVA" 029   "ROVIGO" 030   "UDINE" 031   "GORIZIA" 032   "TRIESTE" 033   "PIACENZA" 034   "PARMA" 035   "REGGIO NELL'EMILIA" 036   "MODENA" 037   "BOLOGNA" 038   "FERRARA" 039   "RAVENNA" 040   "FORLI' - CESENA" 041   "PESARO E URBINO" 042   "ANCONA" 043   "MACERATA" 044   "ASCOLI PICENO" 045   "MASSA - CARRARA" 046   "LUCCA" 047   "PISTOIA" 048   "FIRENZE" 049   "LIVORNO" 050   "PISA" 051   "AREZZO" 052   "SIENA" 053   "GROSSETO" 054   "PERUGIA" 055   "TERNI" 056   "VITERBO" 057   "RIETI" 058   "ROMA" 059   "LATINA" 060   "FROSINONE" 061   "CASERTA" 062   "BENEVENTO" 063   "NAPOLI" 064   "AVELLINO" 065   "SALERNO" 066   "L'AQUILA" 067   "TERAMO" 068   "PESCARA" 069   "CHIETI" 070   "CAMPOBASSO" 071   "FOGGIA" 072   "BARI" 073   "TARANTO" 074   "BRINDISI" 075   "LECCE" 076   "POTENZA" 077   "MATERA" 078   "COSENZA" 079   "CATANZARO" 080   "REGGIO DI CALABRIA" 081   "TRAPANI" 082   "PALERMO" 083   "MESSINA" 084   "AGRIGENTO" 085   "CALTANISSETTA" 086   "ENNA" 087   "CATANIA" 088   "RAGUSA" 089   "SIRACUSA" 090   "SASSARI" 091   "NUORO" 092   "CAGLIARI" 093   "PORDENONE" 094   "ISERNIA" 095   "ORISTANO" 096   "BIELLA" 097   "LECCO" 098   "LODI" 099   "RIMINI" 100   "PRATO" 101   "CROTONE" 102   "VIBO VALENTIA" 103   "VERBANO-CUSIO-OSSOLA" 104   "OLBIA-TEMPIO" 105   "OGLIASTRA" 106   "MEDIO CAMPIDANO" 107   "CARBONIA-IGLESIAS"  
label define  tracom_081_cl374 001   "Si, da altro comune della stessa provincia" 002   "Si, da altra provincia della stessa regione" 003   "Si, da altra regione" 004   "Si, dall estero" 005   "No" 006   "Si, ma poi  tornato nella provincia di residenza" 997   "Non sa"  
label define  regtra_081_cl375 01   "Piemonte" 02   "Valle d'Aosta" 03   "Lombardia" 04   "Trentino alto Adige" 05   "Veneto" 06   "Friuli Venezia Giulia" 07   "Liguria" 08   "Emilia Romagna" 09   "Toscana" 10   "Umbria" 11   "Marche" 12   "Lazio" 13   "Abruzzo" 14   "Molise" 15   "Campania" 16   "Puglia" 17   "Basilicata" 18   "Calabria" 19   "Sicilia" 20   "Sardegna"  
label define  protra_081_cl376 001   "TORINO" 002   "VERCELLI" 003   "NOVARA" 004   "CUNEO" 005   "ASTI" 006   "ALESSANDRIA" 007   "AOSTA" 008   "IMPERIA" 009   "SAVONA" 010   "GENOVA" 011   "LA SPEZIA" 012   "VARESE" 013   "COMO" 014   "SONDRIO" 015   "MILANO" 016   "BERGAMO" 017   "BRESCIA" 018   "PAVIA" 019   "CREMONA" 020   "MANTOVA" 021   "BOLZANO" 022   "TRENTO" 023   "VERONA" 024   "VICENZA" 025   "BELLUNO" 026   "TREVISO" 027   "VENEZIA" 028   "PADOVA" 029   "ROVIGO" 030   "UDINE" 031   "GORIZIA" 032   "TRIESTE" 033   "PIACENZA" 034   "PARMA" 035   "REGGIO NELL'EMILIA" 036   "MODENA" 037   "BOLOGNA" 038   "FERRARA" 039   "RAVENNA" 040   "FORLI' - CESENA" 041   "PESARO E URBINO" 042   "ANCONA" 043   "MACERATA" 044   "ASCOLI PICENO" 045   "MASSA - CARRARA" 046   "LUCCA" 047   "PISTOIA" 048   "FIRENZE" 049   "LIVORNO" 050   "PISA" 051   "AREZZO" 052   "SIENA" 053   "GROSSETO" 054   "PERUGIA" 055   "TERNI" 056   "VITERBO" 057   "RIETI" 058   "ROMA" 059   "LATINA" 060   "FROSINONE" 061   "CASERTA" 062   "BENEVENTO" 063   "NAPOLI" 064   "AVELLINO" 065   "SALERNO" 066   "L'AQUILA" 067   "TERAMO" 068   "PESCARA" 069   "CHIETI" 070   "CAMPOBASSO" 071   "FOGGIA" 072   "BARI" 073   "TARANTO" 074   "BRINDISI" 075   "LECCE" 076   "POTENZA" 077   "MATERA" 078   "COSENZA" 079   "CATANZARO" 080   "REGGIO DI CALABRIA" 081   "TRAPANI" 082   "PALERMO" 083   "MESSINA" 084   "AGRIGENTO" 085   "CALTANISSETTA" 086   "ENNA" 087   "CATANIA" 088   "RAGUSA" 089   "SIRACUSA" 090   "SASSARI" 091   "NUORO" 092   "CAGLIARI" 093   "PORDENONE" 094   "ISERNIA" 095   "ORISTANO" 096   "BIELLA" 097   "LECCO" 098   "LODI" 099   "RIMINI" 100   "PRATO" 101   "CROTONE" 102   "VIBO VALENTIA" 103   "VERBANO-CUSIO-OSSOLA" 104   "OLBIA-TEMPIO" 105   "OGLIASTRA" 106   "MEDIO CAMPIDANO" 107   "CARBONIA-IGLESIAS"  
label define  dipaus_081_cl377 1   "dipendente" 2   "collaboratore" 3   "autonomo"  
label define  dipins_081_cl378 1   "Dipendente" 2   "Indipendente"  
label define  prof1s_081_cl379 1   "LEGISLATORI, DIRIGENTI E IMPRENDITORI" 2   "PROFESSIONI INTELLETTUALI, SCIENTIFICHE E DI ELEVATA SPECIALIZZAZIONE" 3   "PROFESSIONI TECNICHE" 4   "IMPIEGATI" 5   "PROFESSIONI QUALIFICATE NELLE ATTIVITA" 6   "ARTIGIANI, OPERAI SPECIALIZZATI E AGRICOLTORI" 7   "CONDUTTORI DI IMPIANTI E OPERAI SEMIQUALIFICATI ADDETTI A MACCHINARI FISSI E MOBILI" 8   "PROFESSIONI NON QUALIFICATE" 9   "FORZE ARMATE"  
label define  ate2ds_081_cl382 01   "agricoltura, caccia e relativi servizi" 02   "silvicoltura e utilizzazione di aree forestali e servizi connessi" 05   "pesca, piscicoltura e servizi connessi" 10   "estrazione di carbon fossile, lignite, torba" 11   "estrazione di petrolio greggio e di gas naturale e servizi connessi, esclusa la prospezione" 12   "estrazione di minerali di uranio e di torio" 13   "estrazione di minerali metalliferi" 14   "altre industrie estrattive" 15   "industrie alimentari e delle bevande" 16   "industria del tabacco" 17   "industrie tessili" 18   "confezione di articoli di abbigliamento; preparazione, tintura e confezione di pellicce" 19   "preparazione e concia del cuoio; fabbricazione di articoli da viaggio, borse, marocchineria, selleria e calzature" 20   "industria del legno e dei prodotti in legno e sughero, esclusi i mobili; fabbricazione di articoli in materiali da intreccio" 21   "fabbricazione della pasta-carta, della carta e del cartone e dei prodotti di carta" 22   "editoria, stampa e riproduzione di supporti registrati" 23   "fabbricazione di coke, raffinerie di petrolio, trattamento dei combustibili nucleari" 24   "fabbricazione di prodotti chimici e di fibre sintetiche e artificiali" 25   "fabbricazione di articoli in gomma e materie plastiche" 26   "fabbricazione di prodotti della lavorazione di minerali non metalliferi" 27   "metallurgia" 28   "fabbricazione e lavorazione dei prodotti in metallo, esclusi macchine e impianti" 29   "fabbricazione di macchine ed apparecchi meccanici" 30   "fabbricazione di macchine per ufficio, di elaboratori e sistemi informatici" 31   "fabbricazione di macchine ed apparecchi elettrici n.c.a." 32   "fabbricazione di apparecchi radiotelevisivi e di apparecchiature per le comunicazioni" 33   "fabbricazione di apparecchi medicali, di apparecchi di precisione, di strumenti ottici e di orologi" 34   "fabbricazione di autoveicoli, rimorchi e semirimorchi" 35   "fabbricazione di altri mezzi di trasporto" 36   "fabbricazione di mobili; altre industrie manifatturiere" 37   "recupero e preparazione per il riciclaggio" 40   "produzione e distribuzione di energia elettrica, di gas, di calore" 41   "raccolta, depurazione e distribuzione d'acqua" 45   "costruzioni" 50   "commercio, manutenzione e riparazione di autoveicoli e motocicli; vendita al dettaglio di carburanti per autotrazione" 51   "commercio all'ingrosso e intermediari del commercio, autoveicoli e motocicli esclusi" 52   "commercio al dettaglio (escluso quello di autoveicoli e di motocicli); riparazione di beni personali e per la casa" 55   "alberghi e ristoranti" 60   "trasporti terrestri; trasporti mediante condotte" 61   "trasporti marittimi e per vie d'acqua" 62   "trasporti aerei" 63   "attivit di supporto ed ausiliarie dei trasporti; attivit delle agenzie di viaggio" 64   "poste e telecomunicazioni" 65   "intermediazione monetaria e finanziaria (escluse le assicurazioni e i fondi pensione)" 66   "assicurazioni e fondi pensione, escluse le assicurazioni sociali obbligatorie" 67   "attivit ausiliarie dell'intermediazione finanziaria e delle assicurazioni" 70   "attivit immobiliari" 71   "noleggio di macchinari e attrezzature senza operatore e di beni per uso personale e domestico" 72   "informatica e attivit connesse" 73   "ricerca e sviluppo" 74   "attivit di servizi alle imprese" 75   "amministrazione pubblica" 80   "istruzione" 85   "sanit e assistenza sociale" 90   "smaltimento dei rifiuti solidi, delle acque di scarico e simili" 91   "attivit di organizzazioni associative" 92   "attivit ricreative, culturali e sportive" 93   "servizi alle famiglie" 95   "attivit di datore di lavoro per personale domestico svolto da famiglie e convivenze" 96   "produzione di beni per uso proprio da parte di famiglie e convivenze" 97   "produzione di servizi per uso proprio da parte di famiglie e convivenze" 99   "organizzazioni ed organismi extraterritoriali"  
label define  cat12s_081_cl383 01   "Agricoltura, caccia e pesca" 02   "Industria dell energia, estrazione materiali energetici" 03   "Industria della trasformazione" 04   "Industria delle costruzioni" 05   "Altre attivit: commercio" 06   "Altre attivit: alberghi e ristoranti" 07   "Altre attivit: trasporti e comunicazioni" 08   "Altre attivit: intermediazione monetaria e finanziaria, attivit immobiliari" 09   "Altre attivit: servizi alle imprese e altre attivit professionali e imprenditoriali" 10   "Altre attivit: pubblica amministrazione, difesa, assicurazioni sociali obbligatorie" 11   "Altre attivit: istruzione, sanit ed altri servizi sociali" 12   "Altre attivit: altri servizi pubblici, sociali e alle persone"  
label define  cat5s_081_cl384 1   "Agricoltura" 2   "Industria in senso stretto" 3   "Costruzioni" 4   "Commercio" 5   "Altre attivit"  
label define  cat3s_081_cl385 1   "Agricoltura" 2   "Industria" 3   "Terziario"  
label define  dipaua_081_cl386 1   "dipendente" 2   "collaboratore" 3   "autonomo"  
label define  dipina_081_cl387 1   "Dipendente" 2   "Indipendente"  
label define  esplav_081_cl388 1   "ha precedenti esperienze lavorative" 2   "non ha precedenti esperienze lavorative"  
label values  trim_071 trim_071_cl1
label values  reg_071 reg_071_cl2
label values  codpro_071 codpro_071_cl3
label values  sg11_071 sg11_071_cl5
label values  sg13_071 sg13_071_cl6
label values  sg16_071 sg16_071_cl7
label values  sg24_071 sg24_071_cl9
label values  b1_071 b1_071_cl10
label values  b2_071 b2_071_cl11
label values  b3_071 b3_071_cl12
label values  b3bis_071 b3bis_071_cl13
label values  b4_071 b4_071_cl14
label values  b4a_071 b4a_071_cl15
label values  b4bis_071 b4bis_071_cl16
label values  b6_071 b6_071_cl17
label values  b7_071 b7_071_cl18
label values  b8_071 b8_071_cl19
label values  b9_071 b9_071_cl20
label values  b10_071 b10_071_cl21
label values  b11_071 b11_071_cl22
label values  c1_071 c1_071_cl23
label values  c1bis_071 c1bis_071_cl24
label values  c1a_071 c1a_071_cl25
label values  c1b_071 c1b_071_cl26
label values  c1d_071 c1d_071_cl27
label values  c4_071 c4_071_cl28
label values  c5_071 c5_071_cl29
label values  c6_071 c6_071_cl30
label values  c7_071 c7_071_cl31
label values  c9_071 c9_071_cl32
label values  c10_071 c10_071_cl33
label values  c14_071 c14_071_cl34
label values  c18_071 c18_071_cl36
label values  c20_071 c20_071_cl38
label values  c22_071 c22_071_cl40
label values  c25_071 c25_071_cl41
label values  c26_071 c26_071_cl42
label values  c27_071 c27_071_cl43
label values  c28_071 c28_071_cl44
label values  c29_071 c29_071_cl45
label values  c29b_071 c29b_071_cl46
label values  c32_071 c32_071_cl49
label values  c33_071 c33_071_cl50
label values  c34_071 c34_071_cl51
label values  c35_071 c35_071_cl52
label values  c38_071 c38_071_cl56
label values  c39a_071 c39a_071_cl58
label values  c40_071 c40_071_cl59
label values  c41_071 c41_071_cl60
label values  c42_071 c42_071_cl61
label values  c43_071 c43_071_cl62
label values  c44_071 c44_071_cl63
label values  c45_071 c45_071_cl64
label values  c46_071 c46_071_cl65
label values  c47_071 c47_071_cl66
label values  c48_071 c48_071_cl67
label values  c51_071 c51_071_cl68
label values  c53_071 c53_071_cl69
label values  c54_071 c54_071_cl70
label values  c59_071 c59_071_cl71
label values  c60_071 c60_071_cl72
label values  d1_071 d1_071_cl73
label values  d3_071 d3_071_cl75
label values  d4_071 d4_071_cl76
label values  d5_071 d5_071_cl77
label values  d5a_071 d5a_071_cl78
label values  d5bis_071 d5bis_071_cl79
label values  d7_071 d7_071_cl80
label values  f1_071 f1_071_cl82
label values  f2_071 f2_071_cl83
label values  f3_071 f3_071_cl84
label values  f4_071 f4_071_cl85
label values  f5_071 f5_071_cl86
label values  f6_01_071 f6_01_071_cl87
label values  f6_02_071 f6_02_071_cl88
label values  f6_03_071 f6_03_071_cl89
label values  f6_04_071 f6_04_071_cl90
label values  f6_05_071 f6_05_071_cl91
label values  f6_06_071 f6_06_071_cl92
label values  f6_07_071 f6_07_071_cl93
label values  f6_08_071 f6_08_071_cl94
label values  f6_09_071 f6_09_071_cl95
label values  f6_10_071 f6_10_071_cl96
label values  f6_11_071 f6_11_071_cl97
label values  f6_12_071 f6_12_071_cl98
label values  f6_96_071 f6_96_071_cl99
label values  f7_071 f7_071_cl100
label values  f8_071 f8_071_cl101
label values  f10_071 f10_071_cl103
label values  f10a_071 f10a_071_cl104
label values  f12_071 f12_071_cl105
label values  f13_071 f13_071_cl106
label values  f14_071 f14_071_cl107
label values  f15_071 f15_071_cl108
label values  f16_071 f16_071_cl109
label values  f17_071 f17_071_cl110
label values  f18_071 f18_071_cl111
label values  f19_071 f19_071_cl112
label values  f20_071 f20_071_cl113
label values  f21_071 f21_071_cl114
label values  f22_071 f22_071_cl115
label values  f23_071 f23_071_cl116
label values  f24_071 f24_071_cl117
label values  f25_071 f25_071_cl118
label values  f26_071 f26_071_cl119
label values  f27_071 f27_071_cl120
label values  f28_071 f28_071_cl121
label values  f29_01_071 f29_01_071_cl122
label values  f29_02_071 f29_02_071_cl123
label values  f29_03_071 f29_03_071_cl124
label values  f29_04_071 f29_04_071_cl125
label values  f29_97_071 f29_97_071_cl126
label values  f30_071 f30_071_cl127
label values  f32_071 f32_071_cl129
label values  f33_071 f33_071_cl130
label values  f34_071 f34_071_cl131
label values  f35_071 f35_071_cl132
label values  f36_071 f36_071_cl133
label values  f37_071 f37_071_cl134
label values  f38_071 f38_071_cl135
label values  f39_071 f39_071_cl136
label values  f40_071 f40_071_cl137
label values  f41_071 f41_071_cl138
label values  f44_071 f44_071_cl141
label values  f45_071 f45_071_cl142
label values  f46_071 f46_071_cl143
label values  f47_071 f47_071_cl144
label values  f48_071 f48_071_cl145
label values  f49_071 f49_071_cl146
label values  f50_071 f50_071_cl147
label values  i1_071 i1_071_cl148
label values  i5_071 i5_071_cl149
label values  i6_071 i6_071_cl150
label values  i7_071 i7_071_cl151
label values  i8_071 i8_071_cl152
label values  i9_071 i9_071_cl153
label values  i16b_071 i16b_071_cl156
label values  rip4_071 rip4_071_cl158
label values  rip3_071 rip3_071_cl159
label values  cletad_071 cletad_071_cl161
label values  cletaq_071 cletaq_071_cl162
label values  cletas_071 cletas_071_cl163
label values  cittad_071 cittad_071_cl164
label values  llases_071 llases_071_cl165
label values  cond3_071 cond3_071_cl166
label values  cond10_071 cond10_071_cl167
label values  dipaut_071 dipaut_071_cl168
label values  dipind_071 dipind_071_cl169
label values  assocc_071 assocc_071_cl170
label values  pospro_071 pospro_071_cl171
label values  detind_071 detind_071_cl172
label values  piepar_071 piepar_071_cl173
label values  tipcon_071 tipcon_071_cl174
label values  prof1_071 prof1_071_cl176
label values  ate2d_071 ate2d_071_cl179
label values  cat12_071 cat12_071_cl180
label values  cat5_071 cat5_071_cl181
label values  cat3_071 cat3_071_cl182
label values  regspe_071 regspe_071_cl183
label values  prospe_071 prospe_071_cl184
label values  tracom_071 tracom_071_cl185
label values  regtra_071 regtra_071_cl186
label values  protra_071 protra_071_cl187
label values  dipaus_071 dipaus_071_cl188
label values  dipins_071 dipins_071_cl189
label values  prof1s_071 prof1s_071_cl190
label values  ate2ds_071 ate2ds_071_cl193
label values  cat12s_071 cat12s_071_cl194
label values  cat5s_071 cat5s_071_cl195
label values  cat3s_071 cat3s_071_cl196
label values  dipaua_071 dipaua_071_cl197
label values  dipina_071 dipina_071_cl198
label values  dipaup_071 dipaup_071_cl199
label values  dipinp_071 dipinp_071_cl200
label values  ate2dp_071 ate2dp_071_cl201
label values  cat12p_071 cat12p_071_cl202
label values  cat5p_071 cat5p_071_cl203
label values  cat3p_071 cat3p_071_cl204
label values  esplav_071 esplav_071_cl205
label values  nasses_071 nasses_071_cl207
label values  citses_071 citses_071_cl208
label values  trim_081 trim_081_cl210
label values  sg24_081 sg24_081_cl212
label values  sg24a_081 sg24a_081_cl213
label values  b1_081 b1_081_cl214
label values  b2_081 b2_081_cl215
label values  b3_081 b3_081_cl216
label values  b3bis_081 b3bis_081_cl217
label values  b4_081 b4_081_cl218
label values  b4a_081 b4a_081_cl219
label values  b4bis_081 b4bis_081_cl220
label values  b6_081 b6_081_cl221
label values  b7_081 b7_081_cl222
label values  b8_081 b8_081_cl223
label values  b9_081 b9_081_cl224
label values  b10_081 b10_081_cl225
label values  b11_081 b11_081_cl226
label values  c1_081 c1_081_cl227
label values  c1bis_081 c1bis_081_cl228
label values  c1a_081 c1a_081_cl229
label values  c1b_081 c1b_081_cl230
label values  c1d_081 c1d_081_cl231
label values  c4_081 c4_081_cl232
label values  c5_081 c5_081_cl233
label values  c6_081 c6_081_cl234
label values  c7_081 c7_081_cl235
label values  c9_081 c9_081_cl236
label values  c10_081 c10_081_cl237
label values  c14_081 c14_081_cl238
label values  c18_081 c18_081_cl240
label values  c20_081 c20_081_cl242
label values  c22_081 c22_081_cl244
label values  c23a_081 c23a_081_cl245
label values  c24_081 c24_081_cl246
label values  c24bis_081 c24bis_081_cl247
label values  c24ter_081 c24ter_081_cl248
label values  c25_081 c25_081_cl249
label values  c27_081 c27_081_cl250
label values  c28_081 c28_081_cl251
label values  c29_081 c29_081_cl252
label values  c29b_081 c29b_081_cl253
label values  c32_081 c32_081_cl256
label values  c33_081 c33_081_cl257
label values  c34_081 c34_081_cl258
label values  c35_081 c35_081_cl259
label values  c38_081 c38_081_cl263
label values  c39a_081 c39a_081_cl265
label values  c40_081 c40_081_cl266
label values  c41_081 c41_081_cl267
label values  c42_081 c42_081_cl268
label values  c43_081 c43_081_cl269
label values  c44_081 c44_081_cl270
label values  c45_081 c45_081_cl271
label values  c46_081 c46_081_cl272
label values  c47_081 c47_081_cl273
label values  c48_081 c48_081_cl274
label values  c53_081 c53_081_cl275
label values  c59_081 c59_081_cl276
label values  c60_081 c60_081_cl277
label values  d1_081 d1_081_cl278
label values  d3_081 d3_081_cl280
label values  d4_081 d4_081_cl281
label values  d5_081 d5_081_cl282
label values  d5a_081 d5a_081_cl283
label values  d5bis_081 d5bis_081_cl284
label values  d7_081 d7_081_cl285
label values  f1_081 f1_081_cl287
label values  f2_081 f2_081_cl288
label values  f3_081 f3_081_cl289
label values  f4_081 f4_081_cl290
label values  f5_081 f5_081_cl291
label values  f6_01_081 f6_01_081_cl292
label values  f6_02_081 f6_02_081_cl293
label values  f6_03_081 f6_03_081_cl294
label values  f6_04_081 f6_04_081_cl295
label values  f6_05_081 f6_05_081_cl296
label values  f6_06_081 f6_06_081_cl297
label values  f6_07_081 f6_07_081_cl298
label values  f6_08_081 f6_08_081_cl299
label values  f6_09_081 f6_09_081_cl300
label values  f6_10_081 f6_10_081_cl301
label values  f6_11_081 f6_11_081_cl302
label values  f6_12_081 f6_12_081_cl303
label values  f6_96_081 f6_96_081_cl304
label values  f7_081 f7_081_cl305
label values  f8_081 f8_081_cl306
label values  f10_081 f10_081_cl308
label values  f10a_081 f10a_081_cl309
label values  f12_081 f12_081_cl310
label values  f13_081 f13_081_cl311
label values  f14_081 f14_081_cl312
label values  f15_081 f15_081_cl313
label values  f16_081 f16_081_cl314
label values  f17_081 f17_081_cl315
label values  f18_081 f18_081_cl316
label values  f19_081 f19_081_cl317
label values  f20_081 f20_081_cl318
label values  f21_081 f21_081_cl319
label values  f22_081 f22_081_cl320
label values  f23_081 f23_081_cl321
label values  f24_081 f24_081_cl322
label values  f25_081 f25_081_cl323
label values  f26_081 f26_081_cl324
label values  f27_081 f27_081_cl325
label values  f28_081 f28_081_cl326
label values  f29_01_081 f29_01_081_cl327
label values  f29_02_081 f29_02_081_cl328
label values  f29_03_081 f29_03_081_cl329
label values  f29_04_081 f29_04_081_cl330
label values  f29_97_081 f29_97_081_cl331
label values  f30_081 f30_081_cl332
label values  f32_081 f32_081_cl334
label values  f33_081 f33_081_cl335
label values  f34_081 f34_081_cl336
label values  f35_081 f35_081_cl337
label values  f36_081 f36_081_cl338
label values  f37_081 f37_081_cl339
label values  f38_081 f38_081_cl340
label values  f39_081 f39_081_cl341
label values  f40_081 f40_081_cl342
label values  f41_081 f41_081_cl343
label values  f44_081 f44_081_cl346
label values  f45_081 f45_081_cl347
label values  f46_081 f46_081_cl348
label values  f47_081 f47_081_cl349
label values  f48_081 f48_081_cl350
label values  f49_081 f49_081_cl351
label values  f50_081 f50_081_cl352
label values  i1_081 i1_081_cl353
label values  llases_081 llases_081_cl354
label values  cond3_081 cond3_081_cl355
label values  cond10_081 cond10_081_cl356
label values  dipaut_081 dipaut_081_cl357
label values  dipind_081 dipind_081_cl358
label values  assocc_081 assocc_081_cl359
label values  pospro_081 pospro_081_cl360
label values  detind_081 detind_081_cl361
label values  piepar_081 piepar_081_cl362
label values  prof1_081 prof1_081_cl364
label values  ate2d_081 ate2d_081_cl367
label values  cat12_081 cat12_081_cl368
label values  cat5_081 cat5_081_cl369
label values  cat3_081 cat3_081_cl370
label values  lavspe_081 lavspe_081_cl371
label values  regspe_081 regspe_081_cl372
label values  prospe_081 prospe_081_cl373
label values  tracom_081 tracom_081_cl374
label values  regtra_081 regtra_081_cl375
label values  protra_081 protra_081_cl376
label values  dipaus_081 dipaus_081_cl377
label values  dipins_081 dipins_081_cl378
label values  prof1s_081 prof1s_081_cl379
label values  ate2ds_081 ate2ds_081_cl382
label values  cat12s_081 cat12s_081_cl383
label values  cat5s_081 cat5s_081_cl384
label values  cat3s_081 cat3s_081_cl385
label values  dipaua_081 dipaua_081_cl386
label values  dipina_081 dipina_081_cl387
label values  esplav_081 esplav_081_cl388
*/
save  ISTAT_MFR_RCFL_Long_Microdati_2007_Primo_trimestre_ESEMPIO_STRUTTURA_FILE.dta, replace
