/*  I valori delle label nelle variabili categoriche sono commentati a causa della presenza di codici non esclusivamente numerici. Comunque sono completamente documentati.  */
clear all
infile  using  PGM_2004_Primo_trimestre_IT_DELIMITED.dct, clear
/*
label define  trim_041_cl1 1   "Primo trimestre" 2   "Secondo trimestre" 3   "Terzo trimestre" 4   "Quarto trimestre"  
label define  reg_041_cl2 01   "Piemonte" 02   "Valle d'Aosta" 03   "Lombardia" 04   "Trentino alto Adige" 05   "Veneto" 06   "Friuli Venezia Giulia" 07   "Liguria" 08   "Emilia Romagna" 09   "Toscana" 10   "Umbria" 11   "Marche" 12   "Lazio" 13   "Abruzzo" 14   "Molise" 15   "Campania" 16   "Puglia" 17   "Basilicata" 18   "Calabria" 19   "Sicilia" 20   "Sardegna"  
label define  codpro_041_cl3 001   "TORINO" 002   "VERCELLI" 003   "NOVARA" 004   "CUNEO" 005   "ASTI" 006   "ALESSANDRIA" 007   "AOSTA" 008   "IMPERIA" 009   "SAVONA" 010   "GENOVA" 011   "LA SPEZIA" 012   "VARESE" 013   "COMO" 014   "SONDRIO" 015   "MILANO" 016   "BERGAMO" 017   "BRESCIA" 018   "PAVIA" 019   "CREMONA" 020   "MANTOVA" 021   "BOLZANO" 022   "TRENTO" 023   "VERONA" 024   "VICENZA" 025   "BELLUNO" 026   "TREVISO" 027   "VENEZIA" 028   "PADOVA" 029   "ROVIGO" 030   "UDINE" 031   "GORIZIA" 032   "TRIESTE" 033   "PIACENZA" 034   "PARMA" 035   "REGGIO NELL'EMILIA" 036   "MODENA" 037   "BOLOGNA" 038   "FERRARA" 039   "RAVENNA" 040   "FORLI' - CESENA" 041   "PESARO E URBINO" 042   "ANCONA" 043   "MACERATA" 044   "ASCOLI PICENO" 045   "MASSA - CARRARA" 046   "LUCCA" 047   "PISTOIA" 048   "FIRENZE" 049   "LIVORNO" 050   "PISA" 051   "AREZZO" 052   "SIENA" 053   "GROSSETO" 054   "PERUGIA" 055   "TERNI" 056   "VITERBO" 057   "RIETI" 058   "ROMA" 059   "LATINA" 060   "FROSINONE" 061   "CASERTA" 062   "BENEVENTO" 063   "NAPOLI" 064   "AVELLINO" 065   "SALERNO" 066   "L'AQUILA" 067   "TERAMO" 068   "PESCARA" 069   "CHIETI" 070   "CAMPOBASSO" 071   "FOGGIA" 072   "BARI" 073   "TARANTO" 074   "BRINDISI" 075   "LECCE" 076   "POTENZA" 077   "MATERA" 078   "COSENZA" 079   "CATANZARO" 080   "REGGIO DI CALABRIA" 081   "TRAPANI" 082   "PALERMO" 083   "MESSINA" 084   "AGRIGENTO" 085   "CALTANISSETTA" 086   "ENNA" 087   "CATANIA" 088   "RAGUSA" 089   "SIRACUSA" 090   "SASSARI" 091   "NUORO" 092   "CAGLIARI" 093   "PORDENONE" 094   "ISERNIA" 095   "ORISTANO" 096   "BIELLA" 097   "LECCO" 098   "LODI" 099   "RIMINI" 100   "PRATO" 101   "CROTONE" 102   "VIBO VALENTIA" 103   "VERBANO-CUSIO-OSSOLA"  
label define  sg11_041_cl5 1   "Maschio" 2   "Femmina"  
label define  sg13_041_cl6 1   "In Italia" 2   "All'Estero"  
label define  sg16_041_cl7 1   "S" 2   "No"  
label define  sg18_041_cl8 001   "Meno di 1 anno" 002   "Da 1 anno a meno di 2 anni" 003   "Da 2 a meno di 3 anni" 004   "Da 3 a meno di 4 anni" 005   "Da 4 a meno di 5 anni" 006   "Da 5 a meno di 6 anni" 007   "Da 6 a meno di 7 anni" 008   "Da 7 a meno di 8 anni" 009   "Da 8 a meno di 9 anni" 010   "Da 9 a meno di 10 anni" 011   "Da pi di 10 anni" 997   "Non sa" 998   "Non risponde"  
label define  sg24_041_cl9 001   "Nessun titolo" 002   "Licenza elementare" 003   "Licenza media (o avviamento professionale)" 004   "Diploma di scuola superiore di 2-3 anni che non permette l'iscrizione all'Universita'" 005   "Diploma di scuola superiore di 4-5 anni che permette l'iscrizione allUniversit" 006   "Accademia Belle Arti, Istituto Superiore Industrie Artistiche, Accademia di arte drammatica, Perfezionamento Accademia di Danza, Perfezionamento Conservatorio e Istituto Musica Pareggiato, Scuola Inte" 007   "Diploma universitario, Laurea breve (vecchio ordinamento), Scuola diretta a fini speciali, Scuola parauniversitaria" 008   "Laurea di 3 anni di primo livello (nuovo ordinamento)" 009   "Laurea specialistica di 2 anni di secondo livello (nuovo ordinamento)" 010   "Laurea di 4 anni o pi (vecchio ordinamento o nuova laurea specialistica a ciclo unico)" 011   "Specializzazione post-laurea" 012   "Dottorato di ricerca" 997   "Non sa" 998   "Non risponde"  
label define  sg28_041_cl10 1   "S" 2   "No"  
label define  b1_041_cl11 1   "Si" 2   "No" 3   "Permanentemente inabile al lavoro"  
label define  b2_041_cl12 1   "S" 2   "No"  
label define  b3_041_cl13 001   "Cassa Integrazione Guadagni (CIG ordinaria o straordinaria)" 002   "Ridotta attivit dell'impresa per motivi economici e/o tecnici (esclusa CIG)" 003   "Sciopero" 004   "Vertenza sindacale, controversia di lavoro" 005   "Maltempo" 006   "Malattia, problemi di salute personali" 007   "Ferie" 008   "Festivit nella settimana" 009   "Orario variabile o flessibile (ad es. riposo compensativo)" 010   "Part-time verticale" 011   "Studio o Formazione non organizzata nell'ambito del proprio lavoro" 012   "Assenza obbligatoria per maternit" 013   "Assenza facoltativa fino all'ottavo anno del bambino (congedo parentale)" 014   "Motivi familiari (esclusa maternit obbligatoria e congedo parentale)" 015   "Mancanza di occasioni di maggior lavoro" 994   "Fa un lavoro occasionale" 995   "Fa un lavoro stagionale alle dipendenze" 996   "Altro motivo (specificare)"  
label define  b3bis_041_cl14 1   "Si" 2   "No" 3   "Aveva un lavoro, ma era assente" 4   "Non aveva un lavoro"  
label define  b4_041_cl15 1   "Un lavoro alle dipendenze" 2   "Un lavoro di: Collaborazione coordinata e continuativa" 3   "Un lavoro di: Prestazione d'opera occasionale" 4   "Un lavoro autonomo come: Imprenditore" 5   "Un lavoro autonomo come: Libero professionista" 6   "Un lavoro autonomo come: Lavoratore in proprio" 7   "Un lavoro autonomo come: Coadiuvante nell'azienda di un familiare" 8   "Un lavoro autonomo come: Socio di cooperativa"  
label define  b4bis_041_cl16 1   "S" 2   "No"  
label define  b5_041_cl17 1   "S" 2   "No"  
label define  b6_041_cl18 1   "Meno di tre mesi" 2   "Tre mesi o pi"  
label define  b7_041_cl19 1   "S, il 50% o pi" 2   "S, meno del 50%" 3   "No, non retribuito"  
label define  b8_041_cl20 001   "S" 002   "No" 997   "Non sa" 998   "Non risponde"  
label define  b9_041_cl21 1   "S" 2   "No"  
label define  b10_041_cl22 1   "S" 2   "No"  
label define  b11_041_cl23 1   "Momentaneamente sospesa" 2   "Conclusa"  
label define  c1_041_cl24 1   "Un lavoro alle dipendenze" 2   "Un lavoro di: Collaborazione coordinata e continuativa" 3   "Un lavoro di: Prestazione d'opera occasionale" 4   "Un lavoro autonomo come: Imprenditore" 5   "Un lavoro autonomo come: Libero professionista" 6   "Un lavoro autonomo come: Lavoratore in proprio" 7   "Un lavoro autonomo come: Coadiuvante nell'azienda di un familiare" 8   "Un lavoro autonomo come: Socio di cooperativa"  
label define  c1bis_041_cl25 1   "S" 2   "No"  
label define  c1ter_041_cl26 1   "S" 2   "No"  
label define  c2_041_cl27 1   "S" 2   "No"  
label define  c4_041_cl28 1   "S" 2   "No"  
label define  c5_041_cl29 001   "Per un sola azienda/cliente" 002   "Per pi aziende/clienti" 997   "Non sa"  
label define  c6_041_cl30 001   "Decide dove lavorare" 002   "Lavora presso l'azienza/cliente" 997   "Non sa"  
label define  c7_041_cl31 001   "Decide autonomamente l'orario" 002   "Non decide l'orario" 997   "Non sa"  
label define  c9_041_cl32 1   "Dirigente" 2   "Quadro" 3   "Impiegato" 4   "Operaio" 5   "Apprendista" 6   "Lavoratore presso il proprio domicilio per conto di un'impresa"  
label define  c10_041_cl33 001   "S" 002   "No" 997   "Non sa"  
label define  c14_041_cl34 001   "Solo una sede" 002   "Pi sedi" 997   "Non sa"  
label define  c18_041_cl36 1   "Fino a 10 persone" 2   "Da 11 a 15" 3   "Da 16 a 19" 4   "Da 20 a 49" 5   "Da 50 a meno di 250" 6   "250 persone o pi" 7   "Non sa ma fino a 10" 8   "Non sa ma pi di 10"  
label define  c20_041_cl38 1   "A termine (tempo determinato)" 2   "Non ha scadenza (tempo indeterminato)"  
label define  c22_041_cl40 001   "Periodo di formazione" 002   "Periodo di prova" 003   "Lavoro stagionale" 004   "Lavoro occasionale (comprese supplenza nella scuola o sostituzione di un lavoratore)" 005   "Lavoro per la realizzazione di un progetto" 006   "Occupare un posto vacante (incarico a termine nella scuola, nella sanit, etc.)" 996   "Altro (specificare)" 997   "Non sa"  
label define  c24_041_cl41 001   "S" 002   "No" 997   "Non sa"  
label define  c25_041_cl42 001   "Non vuole un lavoro a tempo indeterminato" 002   "Non ha trovato un lavoro a tempo indeterminato" 997   "Non sa"  
label define  c26_041_cl43 001   "S" 002   "No" 003   "Senza preferenze" 997   "Non sa"  
label define  c27_041_cl44 1   "A tempo pieno" 2   "A tempo parziale (part-time)"  
label define  c28_041_cl45 001   "Non vuole un lavoro a tempo pieno" 002   "Non ha trovato un lavoro a tempo pieno" 003   "Altri motivi" 997   "Non sa"  
label define  c29_041_cl46 001   "Studia o segue corsi di formazione professionale" 002   "Malattia, problemi di salute personali" 003   "Per prendersi cura dei figli e/o di altri familiari non autosufficienti" 004   "Svolge un secondo lavoro" 996   "Altri motivi personali (specificare)"  
label define  c30_041_cl47 001   "S" 002   "No" 997   "Non sa"  
label define  c32_041_cl49 001   "Meno del solito" 002   "Piu' del solito" 003   "Come al solito" 997   "Non sa"  
label define  c33_041_cl50 001   "Orario variabile, flessibile" 002   "Straordinario retribuito" 003   "Straordinario non retribuito (ore in pi non recuperabili)" 004   "Maggiori impegni di lavoro" 996   "Altro (specificare)"  
label define  c34_041_cl51 001   "Cassa Integrazione Guadagni (ordinaria o straordinaria)" 002   "Ridotta attivit dell'impresa per motivi economici e/o tecnici (esclusa CIG)" 003   "Sciopero" 004   "Vertenza sindacale, controversia di lavoro" 005   "Maltempo" 006   "Malattia, problemi di salute personali" 007   "Ferie" 008   "Festivit nella settimana" 009   "Orario variabile o flessibile (ad es. riposo compensativo)" 010   "Part-time verticale" 011   "Studio o formazione non organizzata nell'ambito del proprio lavoro" 012   "Assenza obbligatoria per maternit" 013   "Assenza facoltativa fino all'ottavo anno del bambino (congedo parentale)" 014   "Motivi familiari (esclusa maternit obbligatoria e congedo parentale)" 015   "Mancanza di occasioni di maggior lavoro" 016   "Inizio o cambiamento del lavoro nella settimana" 017   "Ha concluso il lavoro nella settimana" 996   "Altro (specificare)"  
label define  c35_041_cl52 001   "S" 002   "No" 997   "Non sa"  
label define  c38_041_cl55 001   "S, meno ore" 002   "S, pi ore" 003   "No (avrebbe voluto lavorare lo stesso numero di ore)" 997   "Non sa"  
label define  c38a_041_cl56 1   "Aggiungendo un nuovo lavoro a quello che ha gi" 2   "Cambiando lavoro" 3   "Continuando a fare lo stesso lavoro" 4   "In uno qualunque dei modi precedenti"  
label define  c40_041_cl58 001   "S, entro due settimane" 002   "Si, dopo due settimane" 003   "No, non disponibile" 997   "Non sa"  
label define  c41_041_cl59 001   "Malattia, problemi di salute personali" 002   "Studio o formazione non organizzata nell'ambito del proprio lavoro" 003   "Altri motivi personali" 004   "Cura dei figli, maternit" 005   "Altri motivi familiari (esclusa cura dei figli)" 006   "Deve dare un preavviso" 996   "Altro motivo (specificare)" 997   "Non sa" 998   "Non risponde"  
label define  c42_041_cl60 001   "S, 2 o pi volte a settimana" 002   "S, meno di 2 volte a settimana" 003   "No" 997   "Non sa"  
label define  c43_041_cl61 001   "S, 2 o pi volte a settimana" 002   "S, meno di 2 volte a settimana" 003   "No" 997   "Non sa"  
label define  c44_041_cl62 001   "S, 2 o pi volte (nelle 4 settimane)" 002   "S, meno di 2 volte (nelle 4 settimane)" 003   "No" 997   "Non sa"  
label define  c45_041_cl63 001   "S, 2 o pi volte (nelle 4 settimane)" 002   "S, meno di 2 volte (nelle 4 settimane)" 003   "No" 997   "Non sa"  
label define  c46_041_cl64 001   "S" 002   "No" 997   "Non sa"  
label define  c47_041_cl65 001   "S" 002   "No" 997   "Non sa"  
label define  c48_041_cl66 001   "S, 2 o pi volte a settimana" 002   "S, meno di 2 volte a settimana" 003   "No" 997   "Non sa"  
label define  c51_041_cl67 001   "TORINO" 002   "VERCELLI" 003   "NOVARA" 004   "CUNEO" 005   "ASTI" 006   "ALESSANDRIA" 007   "AOSTA" 008   "IMPERIA" 009   "SAVONA" 010   "GENOVA" 011   "LA SPEZIA" 012   "VARESE" 013   "COMO" 014   "SONDRIO" 015   "MILANO" 016   "BERGAMO" 017   "BRESCIA" 018   "PAVIA" 019   "CREMONA" 020   "MANTOVA" 021   "BOLZANO" 022   "TRENTO" 023   "VERONA" 024   "VICENZA" 025   "BELLUNO" 026   "TREVISO" 027   "VENEZIA" 028   "PADOVA" 029   "ROVIGO" 030   "UDINE" 031   "GORIZIA" 032   "TRIESTE" 033   "PIACENZA" 034   "PARMA" 035   "REGGIO NELL'EMILIA" 036   "MODENA" 037   "BOLOGNA" 038   "FERRARA" 039   "RAVENNA" 040   "FORLI' - CESENA" 041   "PESARO E URBINO" 042   "ANCONA" 043   "MACERATA" 044   "ASCOLI PICENO" 045   "MASSA - CARRARA" 046   "LUCCA" 047   "PISTOIA" 048   "FIRENZE" 049   "LIVORNO" 050   "PISA" 051   "AREZZO" 052   "SIENA" 053   "GROSSETO" 054   "PERUGIA" 055   "TERNI" 056   "VITERBO" 057   "RIETI" 058   "ROMA" 059   "LATINA" 060   "FROSINONE" 061   "CASERTA" 062   "BENEVENTO" 063   "NAPOLI" 064   "AVELLINO" 065   "SALERNO" 066   "L'AQUILA" 067   "TERAMO" 068   "PESCARA" 069   "CHIETI" 070   "CAMPOBASSO" 071   "FOGGIA" 072   "BARI" 073   "TARANTO" 074   "BRINDISI" 075   "LECCE" 076   "POTENZA" 077   "MATERA" 078   "COSENZA" 079   "CATANZARO" 080   "REGGIO DI CALABRIA" 081   "TRAPANI" 082   "PALERMO" 083   "MESSINA" 084   "AGRIGENTO" 085   "CALTANISSETTA" 086   "ENNA" 087   "CATANIA" 088   "RAGUSA" 089   "SIRACUSA" 090   "SASSARI" 091   "NUORO" 092   "CAGLIARI" 093   "PORDENONE" 094   "ISERNIA" 095   "ORISTANO" 096   "BIELLA" 097   "LECCO" 098   "LODI" 099   "RIMINI" 100   "PRATO" 101   "CROTONE" 102   "VIBO VALENTIA" 103   "VERBANO-CUSIO-OSSOLA"  
label define  c53_041_cl68 001   "S, da un altro comune delle stessa provincia" 002   "S, da un'altra provincia" 003   "S, dall'estero" 004   "No" 005   "S, ma poi  tornato nella provincia di residenza" 997   "Non sa"  
label define  c54_041_cl69 001   "TORINO" 002   "VERCELLI" 003   "NOVARA" 004   "CUNEO" 005   "ASTI" 006   "ALESSANDRIA" 007   "AOSTA" 008   "IMPERIA" 009   "SAVONA" 010   "GENOVA" 011   "LA SPEZIA" 012   "VARESE" 013   "COMO" 014   "SONDRIO" 015   "MILANO" 016   "BERGAMO" 017   "BRESCIA" 018   "PAVIA" 019   "CREMONA" 020   "MANTOVA" 021   "BOLZANO" 022   "TRENTO" 023   "VERONA" 024   "VICENZA" 025   "BELLUNO" 026   "TREVISO" 027   "VENEZIA" 028   "PADOVA" 029   "ROVIGO" 030   "UDINE" 031   "GORIZIA" 032   "TRIESTE" 033   "PIACENZA" 034   "PARMA" 035   "REGGIO NELL'EMILIA" 036   "MODENA" 037   "BOLOGNA" 038   "FERRARA" 039   "RAVENNA" 040   "FORLI' - CESENA" 041   "PESARO E URBINO" 042   "ANCONA" 043   "MACERATA" 044   "ASCOLI PICENO" 045   "MASSA - CARRARA" 046   "LUCCA" 047   "PISTOIA" 048   "FIRENZE" 049   "LIVORNO" 050   "PISA" 051   "AREZZO" 052   "SIENA" 053   "GROSSETO" 054   "PERUGIA" 055   "TERNI" 056   "VITERBO" 057   "RIETI" 058   "ROMA" 059   "LATINA" 060   "FROSINONE" 061   "CASERTA" 062   "BENEVENTO" 063   "NAPOLI" 064   "AVELLINO" 065   "SALERNO" 066   "L'AQUILA" 067   "TERAMO" 068   "PESCARA" 069   "CHIETI" 070   "CAMPOBASSO" 071   "FOGGIA" 072   "BARI" 073   "TARANTO" 074   "BRINDISI" 075   "LECCE" 076   "POTENZA" 077   "MATERA" 078   "COSENZA" 079   "CATANZARO" 080   "REGGIO DI CALABRIA" 081   "TRAPANI" 082   "PALERMO" 083   "MESSINA" 084   "AGRIGENTO" 085   "CALTANISSETTA" 086   "ENNA" 087   "CATANIA" 088   "RAGUSA" 089   "SIRACUSA" 090   "SASSARI" 091   "NUORO" 092   "CAGLIARI" 093   "PORDENONE" 094   "ISERNIA" 095   "ORISTANO" 096   "BIELLA" 097   "LECCO" 098   "LODI" 099   "RIMINI" 100   "PRATO" 101   "CROTONE" 102   "VIBO VALENTIA" 103   "VERBANO-CUSIO-OSSOLA"  
label define  c59_041_cl70 001   "S" 002   "No" 997   "Non sa"  
label define  c60_041_cl71 001   "S" 002   "No" 997   "Non sa"  
label define  d1_041_cl72 1   "S, un altro lavoro" 2   "S, pi di uno" 3   "No"  
label define  d3_041_cl74 001   "Regolarmente" 002   "Solo in alcune stagioni (o in particolari periodi dell'anno)" 003   "Ogni tanto, quando capita" 997   "Non sa"  
label define  d4_041_cl75 1   "Un lavoro alle dipendenze" 2   "Un lavoro di: Collaborazione coordinata e continuativa" 3   "Un lavoro di: Prestazione d'opera occasionale" 4   "Un lavoro autonomo come: Imprenditore" 5   "Un lavoro autonomo come: Libero professionista" 6   "Un lavoro autonomo come: Lavoratore in proprio" 7   "Un lavoro autonomo come: Coadiuvante nell'azienda di un familiare" 8   "Un lavoro autonomo come: Socio di cooperativa"  
label define  d5_041_cl76 1   "S" 2   "No"  
label define  d7_041_cl77 1   "S" 2   "No"  
label define  f1_041_cl79 1   "S" 2   "No"  
label define  f2_041_cl80 1   "Un nuovo lavoro" 2   "Un secondo lavoro (da aggiungere a quello attuale)"  
label define  f3_041_cl81 001   "Lavoro attuale  a termine (lavoro a tempo determinato)" 002   "Teme di perdere l'attuale lavoro" 003   "Considera l'attuale lavoro occasionale" 004   "Guadagnare di pi" 005   "Raggiungere pi facilmente il luogo di lavoro" 006   "Orario pi adatto a prendersi cura dei figli e/o di altri familiari" 007   "Orario diverso per altri motivi" 008   "Cerca un lavoro pi qualificante per le proprie  capacit/competenze e con maggiori prospettive di carriera" 009   "Cerca un lavoro pi adatto alla propria disabilit" 996   "Altri motivi (specificare)"  
label define  f4_041_cl82 001   "Pi ore" 002   "Meno ore" 003   "Lo stesso numero di ore" 997   "Non sa"  
label define  f5_041_cl83 1   "S" 2   "No"  
label define  f6_01_041_cl84 0   "No" 1   "Si"  
label define  f6_02_041_cl85 0   "No" 1   "Si"  
label define  f6_03_041_cl86 0   "No" 1   "Si"  
label define  f6_04_041_cl87 0   "No" 1   "Si"  
label define  f6_05_041_cl88 0   "No" 1   "Si"  
label define  f6_06_041_cl89 0   "No" 1   "Si"  
label define  f6_07_041_cl90 0   "No" 1   "Si"  
label define  f6_08_041_cl91 0   "No" 1   "Si"  
label define  f6_09_041_cl92 0   "No" 1   "Si"  
label define  f6_10_041_cl93 0   "No" 1   "Si"  
label define  f6_11_041_cl94 0   "No" 1   "Si"  
label define  f6_12_041_cl95 0   "No" 1   "Si"  
label define  f6_96_041_cl96 0   "No" 1   "Si"  
label define  f7_041_cl97 1   "S" 2   "No"  
label define  f8_041_cl98 1   "S" 2   "No"  
label define  f10_041_cl100 001   "Ha gi un lavoro che inizier in futuro" 002   "Studia o segue corsi di formazione professionale" 003   "Malattia, problemi di salute personali" 004   "Per prendersi cura dei figli e/o di altri familiari" 005   "In attesa di tornare al suo posto di lavoro" 006   "Deve iniziare il servizio di leva o il servizio civile" 007   "Pensione da lavoro (anzianit o vecchiaia)" 008   "Ritiene di non riuscire a trovare lavoro" 009   "Non gli interessa/non ne ha bisogno (anche per motivi di et)" 010   "Sta aspettando gli esiti di passate azioni di ricerca" 011   "Inabile al lavoro" 996   "Altri motivi (specificare)" 997   "Non sa"  
label define  f11_041_cl101 001   "S" 002   "No" 997   "Non sa"  
label define  f12_041_cl102 1   "S" 2   "No"  
label define  f13_041_cl103 1   "S, entro 2 settimane" 2   "S, dopo 2 settimane" 3   "No"  
label define  f14_041_cl104 001   "Studia o segue corsi di formazione professionale" 002   "Altri motivi personali" 003   "Maternit, nascita di un figlio" 004   "Altri motivi familiari" 005   "Malattia, problemi di salute personali" 006   "Deve dare un preavviso" 007   "Deve o vuole concludere il lavoro gi iniziato" 008   "Deve iniziare il servizio di leva o il servizio civile" 996   "Altri motivi (specificare)" 997   "Non sa" 998   "Non risponde"  
label define  f15_041_cl105 001   "S" 002   "No" 997   "Non sa"  
label define  f16_041_cl106 1   "S" 2   "No"  
label define  f17_041_cl107 1   "S" 2   "No"  
label define  f18_041_cl108 1   "S" 2   "No"  
label define  f19_041_cl109 1   "S" 2   "No"  
label define  f20_041_cl110 1   "S" 2   "No"  
label define  f21_041_cl111 1   "S" 2   "No"  
label define  f22_041_cl112 1   "S" 2   "No"  
label define  f23_041_cl113 1   "S" 2   "No"  
label define  f24_041_cl114 1   "S" 2   "No"  
label define  f25_041_cl115 1   "S" 2   "No"  
label define  f26_041_cl116 1   "S" 2   "No"  
label define  f27_041_cl117 1   "S" 2   "No"  
label define  f28_041_cl118 1   "Si (specificare)" 2   "No"  
label define  f29_01_041_cl119 0   "No" 1   "Si"  
label define  f29_02_041_cl120 0   "No" 1   "Si"  
label define  f29_03_041_cl121 0   "No" 1   "Si"  
label define  f29_04_041_cl122 0   "No" 1   "Si"  
label define  f29_97_041_cl123 0   "No" 1   "Si"  
label define  f30_041_cl124 1   "S" 2   "No"  
label define  f32_041_cl126 1   "Studiava" 2   "Era in servizio militare o in servizio civile sostitutivo" 3   "Lavorava" 4   "Si prendeva cura dei figli e/o di altri familiari" 5   "In altra condizione"  
label define  f33_041_cl127 1   "S, disponibile ad iniziare entro 2 settimane" 2   "No, non disponibile ad iniziare entro 2 settimane"  
label define  f34_041_cl128 001   "Studio o segue corsi di Formazione professionale" 002   "Altri motivi personali" 003   "Maternit, nascita di un figlio" 004   "Altri motivi familiari" 005   "Malattia, problemi di salute personali" 006   "Deve dare un preavviso" 007   "Deve o vuole concludere il lavoro gi iniziato" 008   "Deve iniziare il servizio di leva o il servizio civile" 996   "Altri motivi (specificare)" 997   "Non sa" 998   "Non risponde"  
label define  f35_041_cl129 1   "In proprio" 2   "Dipendente" 3   "Senza preferenze"  
label define  f36_041_cl130 1   "A tempo pieno" 2   "A tempo parziale (part-time)" 3   "Senza preferenze"  
label define  f37_041_cl131 001   "S" 002   "No" 997   "Non sa"  
label define  f38_041_cl132 001   "S" 002   "No" 997   "Non sa"  
label define  f39_041_cl133 001   "A termine" 002   "A tempo indeterminato" 997   "Non sa"  
label define  f40_041_cl134 001   "S" 002   "No" 997   "Non sa"  
label define  f41_041_cl135 001   "Soltanto nel comune di residenza" 002   "In altro comune raggiungibile giornalmente" 003   "Ovunque, in Italia" 004   "Ovunque, anche all'estero" 997   "Non sa"  
label define  f44_041_cl138 1   "Studiava" 2   "Era in servizio militare o in servizio civile sostitutivo" 3   "Lavorava" 4   "Si prendeva cura dei figli e/o di altri familiari" 5   "In altra condizione"  
label define  f45_041_cl139 1   "Entro 2 settimane" 2   "Tra 2 settimane e 3 mesi" 3   "Tra pi di 3 mesi"  
label define  f46_041_cl140 1   "S, disponibile ad iniziare entro 2 settimane" 2   "No, non disponibile ad iniziare entro 2 settimane"  
label define  f47_041_cl141 001   "Studia o segue corsi di formazione professionale" 002   "Altri motivi personali" 003   "Maternit, nascita di un figlio" 004   "Altri motivi familiari" 005   "Malattia, problemi di salute personali" 006   "Deve dare un preavviso" 007   "Deve o vuole concludere il lavoro gi iniziato" 008   "Deve concludere il servizio di leva o il servizio civile" 996   "Altri motivi (specificare)" 997   "Non sa" 998   "Non risponde"  
label define  f48_041_cl142 1   "In proprio" 2   "Alle dipendenze"  
label define  f49_041_cl143 001   "Tempo pieno" 002   "Part-time (a tempo parziale)" 997   "Non sa"  
label define  f50_041_cl144 001   "S" 002   "No" 997   "Non sa"  
label define  i1_041_cl145 1   "Occupato" 2   "Disoccupato alla ricerca di nuova occupazione" 3   "In cerca di prima occupazione" 4   "Casalinga/o" 5   "Studente" 6   "Ritirato/a dal lavoro" 7   "Inabile al lavoro" 8   "In servizio di leva o servizio civile" 9   "In altra condizione (specificare)"  
label define  i5_041_cl146 1   "Occupato" 2   "Disoccupato alla ricerca di nuova occupazione" 3   "In cerca di prima occupazione" 4   "Casalinga/o" 5   "Studente" 6   "Ritirato/a dal lavoro" 7   "Inabile al lavoro" 8   "In servizio di leva o servizio civile" 9   "In altra condizione (specificare)"  
label define  i6_041_cl147 1   "Un lavoro alle dipendenze" 2   "Un lavoro di: Collaborazione coordinata e continuativa" 3   "Un lavoro di: Prestazione d'opera occasionale" 4   "Un lavoro autonomo come: Imprenditore" 5   "Un lavoro autonomo come: Libero professionista" 6   "Un lavoro autonomo come: Lavoratore in proprio" 7   "Un lavoro autonomo come: Coadiuvante nell'azienda di un familiare" 8   "Un lavoro autonomo come: Socio di cooperativa"  
label define  i7_041_cl148 1   "S" 2   "No"  
label define  i8_041_cl149 1   "S" 2   "No"  
label define  i9_041_cl150 001   "S" 002   "No" 997   "Non sa"  
label define  rip4_041_cl152 1   "Nord ovest" 2   "Nord est" 3   "Centro" 4   "Mezzogiorno"  
label define  rip3_041_cl153 1   "Nord" 2   "Centro" 3   "Mezzogiorno"  
label define  cletad_041_cl155 1   "0-14" 2   "15-24" 3   "25-34" 4   "35-44" 5   "45-54" 6   "55-64" 7   "65-74" 8   "75 e +"  
label define  cletaq_041_cl156 01   "0-14" 02   "15-19" 03   "20-24" 04   "25-29" 05   "30-34" 06   "35-39" 07   "40-44" 08   "45-49" 09   "50-54" 10   "55-59" 11   "60-64" 12   "65-69" 13   "70-74" 14   "75 e +"  
label define  cletas_041_cl157 01   "'0-2" 02   "'3-5" 03   "'6-10" 04   "'11-14" 05   "15-19" 06   "20-24" 07   "25-29" 08   "30-34" 09   "35-39" 10   "40-44" 11   "45-49" 12   "50-54" 13   "55-59" 14   "60-64" 15   "65-69" 16   "70-74" 17   "75 e +"  
label define  cittad_041_cl158 1   "citt. italiano" 2   "citt. straniero UE" 3   "citt. straniero NON UE"  
label define  llases_041_cl159 201   "Albania" 202   "Andorra" 203   "Austria" 206   "Belgio" 209   "Bulgaria" 212   "Danimarca" 214   "Finlandia" 215   "Francia" 216   "Germania" 219   "Regno Unito" 220   "Grecia" 221   "Irlanda" 223   "Islanda" 224   "Jugoslavia (Serbia-Montenegro)" 225   "Liechtenstein" 226   "Lussemburgo" 227   "Malta" 229   "Monaco" 231   "Norvegia" 232   "Paesi Bassi" 233   "Polonia" 234   "Portogallo" 235   "Romania" 236   "San Marino" 239   "Spagna" 240   "Svezia" 241   "Svizzera" 243   "Ucraina" 244   "Ungheria" 245   "Russa, Federazione" 246   "Citt del Vaticano" 247   "Estonia" 248   "Lettonia" 249   "Lituania" 250   "Croazia" 251   "Slovenia" 252   "Bosnia-Erzegovina" 253   "Macedonia, ex-Rep. Jugoslavia" 254   "Moldavia" 255   "Slovacchia" 256   "Bielorussia" 257   "Repubblica Ceca" 301   "Afghanistan" 302   "Arabia Saudita" 304   "Bahrein" 305   "Bangladesh" 306   "Bhutan" 307   "Myanmar (Birmania)" 309   "Brunei" 310   "Cambogia" 311   "Sri Lanka (Ceylon)" 314   "Cina" 315   "Cipro" 319   "Corea del Nord" 320   "Corea del Sud" 321   "Macao" 322   "Emirati Arabi Uniti" 323   "Filippine" 324   "Palestina" 326   "Giappone" 327   "Giordania" 330   "India" 331   "Indonesia" 332   "Iran" 333   "Iraq" 334   "Israele" 335   "Kuwait" 336   "Laos" 337   "Libano" 338   "Timor orientale" 339   "Maldive" 340   "Malaysia" 341   "Mongolia" 342   "Nepal" 343   "Oman" 344   "Pakistan" 345   "Qatar" 346   "Singapore" 348   "Siria" 349   "Thailandia" 351   "Turchia" 353   "Vietnam" 354   "Yemen" 356   "Kazakistan" 357   "Uzbekistan" 358   "Armenia" 359   "Azerbaigian" 360   "Georgia" 361   "Kirghizistan" 362   "Tagikistan" 363   "Taiwan (Formosa)" 364   "Turkmenistan" 401   "Algeria" 402   "Angola" 404   "Costa d'Avorio" 406   "Benin (Dahomey)" 408   "Botswana" 409   "Burkina Faso (Alto Volta)" 410   "Burundi" 411   "Camerun" 413   "Capo Verde" 414   "Centrafricana, Rep." 415   "Ciad" 417   "Comore" 418   "Congo" 419   "Egitto" 420   "Etiopia" 421   "Gabon" 422   "Gambia" 423   "Ghana" 424   "Gibuti" 425   "Guinea" 426   "Guinea Bissau" 427   "Guinea Equatoriale" 428   "Kenia" 429   "Lesotho" 430   "Liberia" 431   "Libia" 432   "Madagascar" 434   "Malawi" 435   "Mali" 436   "Marocco" 437   "Mauritania" 438   "Maurizio" 440   "Mozambico" 441   "Namibia" 442   "Niger" 443   "Nigeria" 446   "Ruanda" 448   "Sao Tom e Principe" 449   "Seycelles" 450   "Senegal" 451   "Sierra Leone" 453   "Somalia" 454   "Sudafricana, Rep." 455   "Sudan" 456   "Swaziland" 457   "Tanzania" 458   "Togo" 460   "Tunisia" 461   "Uganda" 463   "Congo, Rep.Dem. (Zaire)" 464   "Zambia" 465   "Zimbabwe (Rhodesia)" 466   "Eritrea" 503   "Antigua e Barbuda" 505   "Bahama" 506   "Barbados" 507   "Belize" 509   "Canada" 513   "Costarica" 514   "Cuba" 515   "Dominica" 516   "Dominicana, Rep." 517   "El Salvador" 518   "Giamaica" 519   "Grenada" 523   "Guatemala" 524   "Haiti" 525   "Honduras" 527   "Messico" 529   "Nicaragua" 530   "Panama" 532   "Saint Lucia" 533   "Saint Vincent e Grenadine" 534   "Saint Kitts e Nevis" 536   "Stati Uniti d'America" 602   "Argentina" 604   "Bolivia" 605   "Brasile" 606   "Cile" 608   "Colombia" 609   "Ecuador" 612   "Guyana" 614   "Paraguay" 615   "Per" 616   "Suriname" 617   "Trinidad e Tobago" 618   "Uruguay" 619   "Venezuela" 701   "Australia" 703   "Figi" 708   "Kiribati" 712   "Marshall" 713   "Micronesia" 715   "Nauru" 719   "Nuova Zelanda" 720   "Palau" 721   "Papua Nuova Guinea" 725   "Salomone" 727   "Samoa" 730   "Tonga" 731   "Tuvalu" 732   "Vanuatu"  
label define  cond3_041_cl160 1   "occupati" 2   "persone in cerca" 3   "inattivi"  
label define  cond10_041_cl161 01   "occupati" 02   "persone in cerca, con precedenti esperienze, ex-occupati" 03   "persone in cerca, con precedenti esperienze, ex-inattivi" 04   "persone in cerca, senza precedenti esperienze" 05   "inattivi in et lav., cercano non attivamente ma disponibili" 06   "inattivi in et lav., cercano ma non disponibili" 07   "inattivi in et lav., non cercano ma disponibili" 08   "inattivi in et lav., non cercano e non disponibili (anche militari di leva e inabili al lavoro)" 09   "inattivi in et non lav., meno di 15 anni" 10   "inattivi in et non lav., pi di 64 anni"  
label define  dipaut_041_cl162 1   "dipendente" 2   "collaboratore" 3   "autonomo"  
label define  dipind_041_cl163 1   "Dipendente" 2   "Indipendente"  
label define  assocc_041_cl164 1   "S" 2   "No"  
label define  pospro_041_cl165 01   "Dirigente" 02   "Quadro" 03   "Impiegato" 04   "Operaio" 05   "Apprendista" 06   "Lavoratore presso il proprio domicilio per conto di un impresa" 07   "Imprenditore" 08   "Libero professionista" 09   "Lavoratore in proprio" 10   "Socio di cooperativa" 11   "Coadiuvante nell azienda di un familiare" 12   "Collaborazione coordinata e continuativa" 13   "Prestazione d opera occasionale"  
label define  detind_041_cl166 1   "tempo determinato" 2   "tempo indeterminato"  
label define  piepar_041_cl167 1   "tempo pieno" 2   "tempo parziale"  
label define  prof1_041_cl169 1   "LEGISLATORI, DIRIGENTI E IMPRENDITORI" 2   "PROFESSIONI INTELLETTUALI, SCIENTIFICHE E DI ELEVATA SPECIALIZZAZIONE" 3   "PROFESSIONI TECNICHE" 4   "IMPIEGATI" 5   "PROFESSIONI QUALIFICATE NELLE ATTIVITA" 6   "ARTIGIANI, OPERAI SPECIALIZZATI E AGRICOLTORI" 7   "CONDUTTORI DI IMPIANTI E OPERAI SEMIQUALIFICATI ADDETTI A MACCHINARI FISSI E MOBILI" 8   "PROFESSIONI NON QUALIFICATE" 9   "FORZE ARMATE"  
label define  ate2d_041_cl172 01   "agricoltura, caccia e relativi servizi" 02   "silvicoltura e utilizzazione di aree forestali e servizi connessi" 05   "pesca, piscicoltura e servizi connessi" 10   "estrazione di carbon fossile, lignite, torba" 11   "estrazione di petrolio greggio e di gas naturale e servizi connessi, esclusa la prospezione" 12   "estrazione di minerali di uranio e di torio" 13   "estrazione di minerali metalliferi" 14   "altre industrie estrattive" 15   "industrie alimentari e delle bevande" 16   "industria del tabacco" 17   "industrie tessili" 18   "confezione di articoli di abbigliamento; preparazione, tintura e confezione di pellicce" 19   "preparazione e concia del cuoio; fabbricazione di articoli da viaggio, borse, marocchineria, selleria e calzature" 20   "industria del legno e dei prodotti in legno e sughero, esclusi i mobili; fabbricazione di articoli in materiali da intreccio" 21   "fabbricazione della pasta-carta, della carta e del cartone e dei prodotti di carta" 22   "editoria, stampa e riproduzione di supporti registrati" 23   "fabbricazione di coke, raffinerie di petrolio, trattamento dei combustibili nucleari" 24   "fabbricazione di prodotti chimici e di fibre sintetiche e artificiali" 25   "fabbricazione di articoli in gomma e materie plastiche" 26   "fabbricazione di prodotti della lavorazione di minerali non metalliferi" 27   "metallurgia" 28   "fabbricazione e lavorazione dei prodotti in metallo, esclusi macchine e impianti" 29   "fabbricazione di macchine ed apparecchi meccanici" 30   "fabbricazione di macchine per ufficio, di elaboratori e sistemi informatici" 31   "fabbricazione di macchine ed apparecchi elettrici n.c.a." 32   "fabbricazione di apparecchi radiotelevisivi e di apparecchiature per le comunicazioni" 33   "fabbricazione di apparecchi medicali, di apparecchi di precisione, di strumenti ottici e di orologi" 34   "fabbricazione di autoveicoli, rimorchi e semirimorchi" 35   "fabbricazione di altri mezzi di trasporto" 36   "fabbricazione di mobili; altre industrie manifatturiere" 37   "recupero e preparazione per il riciclaggio" 40   "produzione e distribuzione di energia elettrica, di gas, di calore" 41   "raccolta, depurazione e distribuzione d'acqua" 45   "costruzioni" 50   "commercio, manutenzione e riparazione di autoveicoli e motocicli; vendita al dettaglio di carburanti per autotrazione" 51   "commercio all'ingrosso e intermediari del commercio, autoveicoli e motocicli esclusi" 52   "commercio al dettaglio (escluso quello di autoveicoli e di motocicli); riparazione di beni personali e per la casa" 55   "alberghi e ristoranti" 60   "trasporti terrestri; trasporti mediante condotte" 61   "trasporti marittimi e per vie d'acqua" 62   "trasporti aerei" 63   "attivit di supporto ed ausiliarie dei trasporti; attivit delle agenzie di viaggio" 64   "poste e telecomunicazioni" 65   "intermediazione monetaria e finanziaria (escluse le assicurazioni e i fondi pensione)" 66   "assicurazioni e fondi pensione, escluse le assicurazioni sociali obbligatorie" 67   "attivit ausiliarie dell'intermediazione finanziaria e delle assicurazioni" 70   "attivit immobiliari" 71   "noleggio di macchinari e attrezzature senza operatore e di beni per uso personale e domestico" 72   "informatica e attivit connesse" 73   "ricerca e sviluppo" 74   "attivit di servizi alle imprese" 75   "amministrazione pubblica" 80   "istruzione" 85   "sanit e assistenza sociale" 90   "smaltimento dei rifiuti solidi, delle acque di scarico e simili" 91   "attivit di organizzazioni associative" 92   "attivit ricreative, culturali e sportive" 93   "servizi alle famiglie" 95   "attivit di datore di lavoro per personale domestico svolto da famiglie e convivenze" 96   "produzione di beni per uso proprio da parte di famiglie e convivenze" 97   "produzione di servizi per uso proprio da parte di famiglie e convivenze" 99   "organizzazioni ed organismi extraterritoriali"  
label define  cat12_041_cl173 01   "Agricoltura, caccia e pesca" 02   "Industria dell energia, estrazione materiali energetici" 03   "Industria della trasformazione" 04   "Industria delle costruzioni" 05   "Altre attivit: commercio" 06   "Altre attivit: alberghi e ristoranti" 07   "Altre attivit: trasporti e comunicazioni" 08   "Altre attivit: intermediazione monetaria e finanziaria, attivit immobiliari" 09   "Altre attivit: servizi alle imprese e altre attivit professionali e imprenditoriali" 10   "Altre attivit: pubblica amministrazione, difesa, assicurazioni sociali obbligatorie" 11   "Altre attivit: istruzione, sanit ed altri servizi sociali" 12   "Altre attivit: altri servizi pubblici, sociali e alle persone"  
label define  cat5_041_cl174 1   "Agricoltura" 2   "Industria in senso stretto" 3   "Costruzioni" 4   "Commercio" 5   "Altre attivit"  
label define  cat3_041_cl175 1   "Agricoltura" 2   "Industria" 3   "Terziario"  
label define  regspe_041_cl176 01   "Piemonte" 02   "Valle d'Aosta" 03   "Lombardia" 04   "Trentino alto Adige" 05   "Veneto" 06   "Friuli Venezia Giulia" 07   "Liguria" 08   "Emilia Romagna" 09   "Toscana" 10   "Umbria" 11   "Marche" 12   "Lazio" 13   "Abruzzo" 14   "Molise" 15   "Campania" 16   "Puglia" 17   "Basilicata" 18   "Calabria" 19   "Sicilia" 20   "Sardegna"  
label define  prospe_041_cl177 001   "TORINO" 002   "VERCELLI" 003   "NOVARA" 004   "CUNEO" 005   "ASTI" 006   "ALESSANDRIA" 007   "AOSTA" 008   "IMPERIA" 009   "SAVONA" 010   "GENOVA" 011   "LA SPEZIA" 012   "VARESE" 013   "COMO" 014   "SONDRIO" 015   "MILANO" 016   "BERGAMO" 017   "BRESCIA" 018   "PAVIA" 019   "CREMONA" 020   "MANTOVA" 021   "BOLZANO" 022   "TRENTO" 023   "VERONA" 024   "VICENZA" 025   "BELLUNO" 026   "TREVISO" 027   "VENEZIA" 028   "PADOVA" 029   "ROVIGO" 030   "UDINE" 031   "GORIZIA" 032   "TRIESTE" 033   "PIACENZA" 034   "PARMA" 035   "REGGIO NELL'EMILIA" 036   "MODENA" 037   "BOLOGNA" 038   "FERRARA" 039   "RAVENNA" 040   "FORLI' - CESENA" 041   "PESARO E URBINO" 042   "ANCONA" 043   "MACERATA" 044   "ASCOLI PICENO" 045   "MASSA - CARRARA" 046   "LUCCA" 047   "PISTOIA" 048   "FIRENZE" 049   "LIVORNO" 050   "PISA" 051   "AREZZO" 052   "SIENA" 053   "GROSSETO" 054   "PERUGIA" 055   "TERNI" 056   "VITERBO" 057   "RIETI" 058   "ROMA" 059   "LATINA" 060   "FROSINONE" 061   "CASERTA" 062   "BENEVENTO" 063   "NAPOLI" 064   "AVELLINO" 065   "SALERNO" 066   "L'AQUILA" 067   "TERAMO" 068   "PESCARA" 069   "CHIETI" 070   "CAMPOBASSO" 071   "FOGGIA" 072   "BARI" 073   "TARANTO" 074   "BRINDISI" 075   "LECCE" 076   "POTENZA" 077   "MATERA" 078   "COSENZA" 079   "CATANZARO" 080   "REGGIO DI CALABRIA" 081   "TRAPANI" 082   "PALERMO" 083   "MESSINA" 084   "AGRIGENTO" 085   "CALTANISSETTA" 086   "ENNA" 087   "CATANIA" 088   "RAGUSA" 089   "SIRACUSA" 090   "SASSARI" 091   "NUORO" 092   "CAGLIARI" 093   "PORDENONE" 094   "ISERNIA" 095   "ORISTANO" 096   "BIELLA" 097   "LECCO" 098   "LODI" 099   "RIMINI" 100   "PRATO" 101   "CROTONE" 102   "VIBO VALENTIA" 103   "VERBANO-CUSIO-OSSOLA" 104   "OLBIA-TEMPIO" 105   "OGLIASTRA" 106   "MEDIO CAMPIDANO" 107   "CARBONIA-IGLESIAS"  
label define  tracom_041_cl178 001   "Si, da altro comune della stessa provincia" 002   "Si, da altra provincia della stessa regione" 003   "Si, da altra regione" 004   "Si, dall estero" 005   "No" 006   "Si, ma poi  tornato nella provincia di residenza" 997   "Non sa"  
label define  regtra_041_cl179 01   "Piemonte" 02   "Valle d'Aosta" 03   "Lombardia" 04   "Trentino alto Adige" 05   "Veneto" 06   "Friuli Venezia Giulia" 07   "Liguria" 08   "Emilia Romagna" 09   "Toscana" 10   "Umbria" 11   "Marche" 12   "Lazio" 13   "Abruzzo" 14   "Molise" 15   "Campania" 16   "Puglia" 17   "Basilicata" 18   "Calabria" 19   "Sicilia" 20   "Sardegna"  
label define  protra_041_cl180 001   "TORINO" 002   "VERCELLI" 003   "NOVARA" 004   "CUNEO" 005   "ASTI" 006   "ALESSANDRIA" 007   "AOSTA" 008   "IMPERIA" 009   "SAVONA" 010   "GENOVA" 011   "LA SPEZIA" 012   "VARESE" 013   "COMO" 014   "SONDRIO" 015   "MILANO" 016   "BERGAMO" 017   "BRESCIA" 018   "PAVIA" 019   "CREMONA" 020   "MANTOVA" 021   "BOLZANO" 022   "TRENTO" 023   "VERONA" 024   "VICENZA" 025   "BELLUNO" 026   "TREVISO" 027   "VENEZIA" 028   "PADOVA" 029   "ROVIGO" 030   "UDINE" 031   "GORIZIA" 032   "TRIESTE" 033   "PIACENZA" 034   "PARMA" 035   "REGGIO NELL'EMILIA" 036   "MODENA" 037   "BOLOGNA" 038   "FERRARA" 039   "RAVENNA" 040   "FORLI' - CESENA" 041   "PESARO E URBINO" 042   "ANCONA" 043   "MACERATA" 044   "ASCOLI PICENO" 045   "MASSA - CARRARA" 046   "LUCCA" 047   "PISTOIA" 048   "FIRENZE" 049   "LIVORNO" 050   "PISA" 051   "AREZZO" 052   "SIENA" 053   "GROSSETO" 054   "PERUGIA" 055   "TERNI" 056   "VITERBO" 057   "RIETI" 058   "ROMA" 059   "LATINA" 060   "FROSINONE" 061   "CASERTA" 062   "BENEVENTO" 063   "NAPOLI" 064   "AVELLINO" 065   "SALERNO" 066   "L'AQUILA" 067   "TERAMO" 068   "PESCARA" 069   "CHIETI" 070   "CAMPOBASSO" 071   "FOGGIA" 072   "BARI" 073   "TARANTO" 074   "BRINDISI" 075   "LECCE" 076   "POTENZA" 077   "MATERA" 078   "COSENZA" 079   "CATANZARO" 080   "REGGIO DI CALABRIA" 081   "TRAPANI" 082   "PALERMO" 083   "MESSINA" 084   "AGRIGENTO" 085   "CALTANISSETTA" 086   "ENNA" 087   "CATANIA" 088   "RAGUSA" 089   "SIRACUSA" 090   "SASSARI" 091   "NUORO" 092   "CAGLIARI" 093   "PORDENONE" 094   "ISERNIA" 095   "ORISTANO" 096   "BIELLA" 097   "LECCO" 098   "LODI" 099   "RIMINI" 100   "PRATO" 101   "CROTONE" 102   "VIBO VALENTIA" 103   "VERBANO-CUSIO-OSSOLA" 104   "OLBIA-TEMPIO" 105   "OGLIASTRA" 106   "MEDIO CAMPIDANO" 107   "CARBONIA-IGLESIAS"  
label define  dipaus_041_cl181 1   "dipendente" 2   "collaboratore" 3   "autonomo"  
label define  dipins_041_cl182 1   "Dipendente" 2   "Indipendente"  
label define  prof1s_041_cl183 1   "LEGISLATORI, DIRIGENTI E IMPRENDITORI" 2   "PROFESSIONI INTELLETTUALI, SCIENTIFICHE E DI ELEVATA SPECIALIZZAZIONE" 3   "PROFESSIONI TECNICHE" 4   "IMPIEGATI" 5   "PROFESSIONI QUALIFICATE NELLE ATTIVITA" 6   "ARTIGIANI, OPERAI SPECIALIZZATI E AGRICOLTORI" 7   "CONDUTTORI DI IMPIANTI E OPERAI SEMIQUALIFICATI ADDETTI A MACCHINARI FISSI E MOBILI" 8   "PROFESSIONI NON QUALIFICATE" 9   "FORZE ARMATE"  
label define  ate2ds_041_cl186 01   "agricoltura, caccia e relativi servizi" 02   "silvicoltura e utilizzazione di aree forestali e servizi connessi" 05   "pesca, piscicoltura e servizi connessi" 10   "estrazione di carbon fossile, lignite, torba" 11   "estrazione di petrolio greggio e di gas naturale e servizi connessi, esclusa la prospezione" 12   "estrazione di minerali di uranio e di torio" 13   "estrazione di minerali metalliferi" 14   "altre industrie estrattive" 15   "industrie alimentari e delle bevande" 16   "industria del tabacco" 17   "industrie tessili" 18   "confezione di articoli di abbigliamento; preparazione, tintura e confezione di pellicce" 19   "preparazione e concia del cuoio; fabbricazione di articoli da viaggio, borse, marocchineria, selleria e calzature" 20   "industria del legno e dei prodotti in legno e sughero, esclusi i mobili; fabbricazione di articoli in materiali da intreccio" 21   "fabbricazione della pasta-carta, della carta e del cartone e dei prodotti di carta" 22   "editoria, stampa e riproduzione di supporti registrati" 23   "fabbricazione di coke, raffinerie di petrolio, trattamento dei combustibili nucleari" 24   "fabbricazione di prodotti chimici e di fibre sintetiche e artificiali" 25   "fabbricazione di articoli in gomma e materie plastiche" 26   "fabbricazione di prodotti della lavorazione di minerali non metalliferi" 27   "metallurgia" 28   "fabbricazione e lavorazione dei prodotti in metallo, esclusi macchine e impianti" 29   "fabbricazione di macchine ed apparecchi meccanici" 30   "fabbricazione di macchine per ufficio, di elaboratori e sistemi informatici" 31   "fabbricazione di macchine ed apparecchi elettrici n.c.a." 32   "fabbricazione di apparecchi radiotelevisivi e di apparecchiature per le comunicazioni" 33   "fabbricazione di apparecchi medicali, di apparecchi di precisione, di strumenti ottici e di orologi" 34   "fabbricazione di autoveicoli, rimorchi e semirimorchi" 35   "fabbricazione di altri mezzi di trasporto" 36   "fabbricazione di mobili; altre industrie manifatturiere" 37   "recupero e preparazione per il riciclaggio" 40   "produzione e distribuzione di energia elettrica, di gas, di calore" 41   "raccolta, depurazione e distribuzione d'acqua" 45   "costruzioni" 50   "commercio, manutenzione e riparazione di autoveicoli e motocicli; vendita al dettaglio di carburanti per autotrazione" 51   "commercio all'ingrosso e intermediari del commercio, autoveicoli e motocicli esclusi" 52   "commercio al dettaglio (escluso quello di autoveicoli e di motocicli); riparazione di beni personali e per la casa" 55   "alberghi e ristoranti" 60   "trasporti terrestri; trasporti mediante condotte" 61   "trasporti marittimi e per vie d'acqua" 62   "trasporti aerei" 63   "attivit di supporto ed ausiliarie dei trasporti; attivit delle agenzie di viaggio" 64   "poste e telecomunicazioni" 65   "intermediazione monetaria e finanziaria (escluse le assicurazioni e i fondi pensione)" 66   "assicurazioni e fondi pensione, escluse le assicurazioni sociali obbligatorie" 67   "attivit ausiliarie dell'intermediazione finanziaria e delle assicurazioni" 70   "attivit immobiliari" 71   "noleggio di macchinari e attrezzature senza operatore e di beni per uso personale e domestico" 72   "informatica e attivit connesse" 73   "ricerca e sviluppo" 74   "attivit di servizi alle imprese" 75   "amministrazione pubblica" 80   "istruzione" 85   "sanit e assistenza sociale" 90   "smaltimento dei rifiuti solidi, delle acque di scarico e simili" 91   "attivit di organizzazioni associative" 92   "attivit ricreative, culturali e sportive" 93   "servizi alle famiglie" 95   "attivit di datore di lavoro per personale domestico svolto da famiglie e convivenze" 96   "produzione di beni per uso proprio da parte di famiglie e convivenze" 97   "produzione di servizi per uso proprio da parte di famiglie e convivenze" 99   "organizzazioni ed organismi extraterritoriali"  
label define  cat12s_041_cl187 01   "Agricoltura, caccia e pesca" 02   "Industria dell energia, estrazione materiali energetici" 03   "Industria della trasformazione" 04   "Industria delle costruzioni" 05   "Altre attivit: commercio" 06   "Altre attivit: alberghi e ristoranti" 07   "Altre attivit: trasporti e comunicazioni" 08   "Altre attivit: intermediazione monetaria e finanziaria, attivit immobiliari" 09   "Altre attivit: servizi alle imprese e altre attivit professionali e imprenditoriali" 10   "Altre attivit: pubblica amministrazione, difesa, assicurazioni sociali obbligatorie" 11   "Altre attivit: istruzione, sanit ed altri servizi sociali" 12   "Altre attivit: altri servizi pubblici, sociali e alle persone"  
label define  cat5s_041_cl188 1   "Agricoltura" 2   "Industria in senso stretto" 3   "Costruzioni" 4   "Commercio" 5   "Altre attivit"  
label define  cat3s_041_cl189 1   "Agricoltura" 2   "Industria" 3   "Terziario"  
label define  dipaua_041_cl190 1   "dipendente" 2   "collaboratore" 3   "autonomo"  
label define  dipina_041_cl191 1   "Dipendente" 2   "Indipendente"  
label define  dipaup_041_cl192 1   "dipendente" 2   "collaboratore" 3   "autonomo"  
label define  dipinp_041_cl193 1   "Dipendente" 2   "Indipendente"  
label define  ate2dp_041_cl194 01   "agricoltura, caccia e relativi servizi" 02   "silvicoltura e utilizzazione di aree forestali e servizi connessi" 05   "pesca, piscicoltura e servizi connessi" 10   "estrazione di carbon fossile, lignite, torba" 11   "estrazione di petrolio greggio e di gas naturale e servizi connessi, esclusa la prospezione" 12   "estrazione di minerali di uranio e di torio" 13   "estrazione di minerali metalliferi" 14   "altre industrie estrattive" 15   "industrie alimentari e delle bevande" 16   "industria del tabacco" 17   "industrie tessili" 18   "confezione di articoli di abbigliamento; preparazione, tintura e confezione di pellicce" 19   "preparazione e concia del cuoio; fabbricazione di articoli da viaggio, borse, marocchineria, selleria e calzature" 20   "industria del legno e dei prodotti in legno e sughero, esclusi i mobili; fabbricazione di articoli in materiali da intreccio" 21   "fabbricazione della pasta-carta, della carta e del cartone e dei prodotti di carta" 22   "editoria, stampa e riproduzione di supporti registrati" 23   "fabbricazione di coke, raffinerie di petrolio, trattamento dei combustibili nucleari" 24   "fabbricazione di prodotti chimici e di fibre sintetiche e artificiali" 25   "fabbricazione di articoli in gomma e materie plastiche" 26   "fabbricazione di prodotti della lavorazione di minerali non metalliferi" 27   "metallurgia" 28   "fabbricazione e lavorazione dei prodotti in metallo, esclusi macchine e impianti" 29   "fabbricazione di macchine ed apparecchi meccanici" 30   "fabbricazione di macchine per ufficio, di elaboratori e sistemi informatici" 31   "fabbricazione di macchine ed apparecchi elettrici n.c.a." 32   "fabbricazione di apparecchi radiotelevisivi e di apparecchiature per le comunicazioni" 33   "fabbricazione di apparecchi medicali, di apparecchi di precisione, di strumenti ottici e di orologi" 34   "fabbricazione di autoveicoli, rimorchi e semirimorchi" 35   "fabbricazione di altri mezzi di trasporto" 36   "fabbricazione di mobili; altre industrie manifatturiere" 37   "recupero e preparazione per il riciclaggio" 40   "produzione e distribuzione di energia elettrica, di gas, di calore" 41   "raccolta, depurazione e distribuzione d'acqua" 45   "costruzioni" 50   "commercio, manutenzione e riparazione di autoveicoli e motocicli; vendita al dettaglio di carburanti per autotrazione" 51   "commercio all'ingrosso e intermediari del commercio, autoveicoli e motocicli esclusi" 52   "commercio al dettaglio (escluso quello di autoveicoli e di motocicli); riparazione di beni personali e per la casa" 55   "alberghi e ristoranti" 60   "trasporti terrestri; trasporti mediante condotte" 61   "trasporti marittimi e per vie d'acqua" 62   "trasporti aerei" 63   "attivit di supporto ed ausiliarie dei trasporti; attivit delle agenzie di viaggio" 64   "poste e telecomunicazioni" 65   "intermediazione monetaria e finanziaria (escluse le assicurazioni e i fondi pensione)" 66   "assicurazioni e fondi pensione, escluse le assicurazioni sociali obbligatorie" 67   "attivit ausiliarie dell'intermediazione finanziaria e delle assicurazioni" 70   "attivit immobiliari" 71   "noleggio di macchinari e attrezzature senza operatore e di beni per uso personale e domestico" 72   "informatica e attivit connesse" 73   "ricerca e sviluppo" 74   "attivit di servizi alle imprese" 75   "amministrazione pubblica" 80   "istruzione" 85   "sanit e assistenza sociale" 90   "smaltimento dei rifiuti solidi, delle acque di scarico e simili" 91   "attivit di organizzazioni associative" 92   "attivit ricreative, culturali e sportive" 93   "servizi alle famiglie" 95   "attivit di datore di lavoro per personale domestico svolto da famiglie e convivenze" 96   "produzione di beni per uso proprio da parte di famiglie e convivenze" 97   "produzione di servizi per uso proprio da parte di famiglie e convivenze" 99   "organizzazioni ed organismi extraterritoriali"  
label define  cat12p_041_cl195 01   "Agricoltura, caccia e pesca" 02   "Industria dell energia, estrazione materiali energetici" 03   "Industria della trasformazione" 04   "Industria delle costruzioni" 05   "Altre attivit: commercio" 06   "Altre attivit: alberghi e ristoranti" 07   "Altre attivit: trasporti e comunicazioni" 08   "Altre attivit: intermediazione monetaria e finanziaria, attivit immobiliari" 09   "Altre attivit: servizi alle imprese e altre attivit professionali e imprenditoriali" 10   "Altre attivit: pubblica amministrazione, difesa, assicurazioni sociali obbligatorie" 11   "Altre attivit: istruzione, sanit ed altri servizi sociali" 12   "Altre attivit: altri servizi pubblici, sociali e alle persone"  
label define  cat5p_041_cl196 1   "Agricoltura" 2   "Industria in senso stretto" 3   "Costruzioni" 4   "Commercio" 5   "Altre attivit"  
label define  cat3p_041_cl197 1   "Agricoltura" 2   "Industria" 3   "Terziario"  
label define  esplav_041_cl198 1   "ha precedenti esperienze lavorative" 2   "non ha precedenti esperienze lavorative"  
label define  trim_051_cl201 1   "Primo trimestre" 2   "Secondo trimestre" 3   "Terzo trimestre" 4   "Quarto trimestre"  
label define  sg24_051_cl203 01   "Nessun titolo" 02   "Licenza elementare" 03   "Licenza media (o avviamento professionale)" 04   "Diploma di scuola superiore di 2-3 anni che non permette l'iscrizione all'Universita'" 05   "Diploma di scuola superiore di 4-5 anni che permette l'iscrizione all'Universit" 06   "Accademia Belle Arti, Istituto Superiore Industrie Artistiche, Accademia di arte drammatica, Perfezionamento Accademia di Danza, Perfezionamento Conservatorio e Istituto Musica Pareggiato, Scuola Inte" 07   "Diploma universitario, Laurea breve (vecchio ordinamento), Scuola diretta a fini speciali, Scuola parauniversitaria" 08   "Laurea di 3 anni di primo livello (nuovo ordinamento)" 09   "Laurea specialistica di 2 anni di secondo livello (nuovo ordinamento)" 10   "Laurea di 4 anni o pi (vecchio ordinamento o nuova laurea specialistica" 11   "Specializzazione post-laurea (compresi master di 1 e 2 livello)" 12   "Dottorato di ricerca"  
label define  sg28_051_cl204 1   "S" 2   "No"  
label define  b1_051_cl205 1   "Si" 2   "No" 3   "Permanentemente inabile al lavoro"  
label define  b2_051_cl206 1   "S" 2   "No"  
label define  b3_051_cl207 001   "Cassa Integrazione Guadagni (CIG ordinaria o straordinaria)" 002   "Ridotta attivit dell'impresa per motivi economici e/o tecnici (esclusa CIG)" 003   "Sciopero" 004   "Vertenza sindacale, controversia di lavoro" 005   "Maltempo" 006   "Malattia, problemi di salute personali" 007   "Ferie" 008   "Festivit nella settimana" 009   "Orario variabile o flessibile (ad es. riposo compensativo)" 010   "Part-time verticale" 011   "Studio o Formazione non organizzata nell'ambito del proprio lavoro" 012   "Assenza obbligatoria per maternit" 013   "Assenza facoltativa fino all'ottavo anno del bambino (congedo parentale)" 014   "Motivi familiari (esclusa maternit obbligatoria e congedo parentale)" 015   "Mancanza di occasioni di maggior lavoro" 994   "Fa un lavoro occasionale" 995   "Fa un lavoro stagionale alle dipendenze" 996   "Altro motivo (specificare)"  
label define  b3bis_051_cl208 1   "Si" 2   "No" 3   "Aveva un lavoro, ma era assente" 4   "Non aveva un lavoro"  
label define  b4_051_cl209 1   "Un lavoro alle dipendenze" 2   "Un lavoro di: Collaborazione coordinata e continuativa (con o senza progetto)" 3   "Un lavoro di: Prestazione d'opera occasionale" 4   "Un lavoro autonomo come: Imprenditore" 5   "Un lavoro autonomo come: Libero professionista" 6   "Un lavoro autonomo come: Lavoratore in proprio" 7   "Un lavoro autonomo come: Coadiuvante nell'azienda di un familiare" 8   "Un lavoro autonomo come: Socio di cooperativa"  
label define  b4a_051_cl210 1   "Si,  Contratto di lavoro alle dipendenze" 2   "Si,  Contratto di collaborazione coordinata e continuativa (con o senza progetto)" 3   "No"  
label define  b4bis_051_cl211 1   "S" 2   "No"  
label define  b6_051_cl212 1   "Meno di tre mesi" 2   "Tre mesi o pi"  
label define  b7_051_cl213 1   "S, il 50% o pi" 2   "S, meno del 50%" 3   "No, non retribuito"  
label define  b8_051_cl214 001   "S" 002   "No" 997   "Non sa" 998   "Non risponde"  
label define  b9_051_cl215 1   "S" 2   "No"  
label define  b10_051_cl216 1   "S" 2   "No"  
label define  b11_051_cl217 1   "Momentaneamente sospesa" 2   "Conclusa"  
label define  c1_051_cl218 1   "Un lavoro alle dipendenze" 2   "Un lavoro di: Collaborazione coordinata e continuativa (con o senza progetto)" 3   "Un lavoro di: Prestazione d'opera occasionale" 4   "Un lavoro autonomo come: Imprenditore" 5   "Un lavoro autonomo come: Libero professionista" 6   "Un lavoro autonomo come: Lavoratore in proprio" 7   "Un lavoro autonomo come: Coadiuvante nell'azienda di un familiare" 8   "Un lavoro autonomo come: Socio di cooperativa"  
label define  c1bis_051_cl219 1   "S" 2   "No"  
label define  c1a_051_cl220 1   "Si,  Contratto di lavoro alle dipendenze" 2   "Si,  Contratto di collaborazione coordinata e continuativa (con o senza progetto)" 3   "No"  
label define  c1b_051_cl221 1   "S" 2   "No"  
label define  c1d_051_cl222 1   "S" 2   "No"  
label define  c4_051_cl223 1   "S" 2   "No"  
label define  c5_051_cl224 001   "Per un sola azienda/cliente" 002   "Per pi aziende/clienti" 997   "Non sa"  
label define  c6_051_cl225 001   "Decide dove lavorare" 002   "Lavora presso l'azienza/cliente" 997   "Non sa"  
label define  c7_051_cl226 001   "Decide autonomamente l'orario" 002   "Non decide l'orario" 997   "Non sa"  
label define  c9_051_cl227 1   "Dirigente" 2   "Quadro" 3   "Impiegato" 4   "Operaio" 5   "Apprendista" 6   "Lavoratore presso il proprio domicilio per conto di un'impresa"  
label define  c10_051_cl228 001   "S" 002   "No" 997   "Non sa"  
label define  c14_051_cl229 001   "Solo una sede" 002   "Pi sedi" 997   "Non sa"  
label define  c18_051_cl231 1   "Fino a 10 persone" 2   "Da 11 a 15" 3   "Da 16 a 19" 4   "Da 20 a 49" 5   "Da 50 a 249" 6   "250 persone o pi" 7   "Non sa ma fino a 10" 8   "Non sa ma pi di 10"  
label define  c20_051_cl233 1   "A termine (tempo determinato)" 2   "A tempo indeterminato (senza una scadenza)"  
label define  c22_051_cl235 001   "Periodo di formazione, apprendistato" 002   "Periodo di prova" 003   "Lavoro stagionale" 004   "Lavoro occasionale (comprese supplenza nella scuola o sostituzione di un lavoratore assente compresa l'assenza per maternit)" 005   "Lavoro per la realizzazione di un progetto" 006   "Occupare un posto vacante (incarico a termine nella scuola, nella sanit, etc.)" 996   "Altro (specificare)" 997   "Non sa"  
label define  c25_051_cl236 001   "Non vuole un lavoro a tempo indeterminato" 002   "Non ha trovato un lavoro a tempo indeterminato" 997   "Non sa"  
label define  c26_051_cl237 001   "S" 002   "No" 003   "Senza preferenze" 997   "Non sa"  
label define  c27_051_cl238 1   "A tempo pieno" 2   "A tempo parziale (part-time)"  
label define  c28_051_cl239 001   "Non vuole un lavoro a tempo pieno" 002   "Non ha trovato un lavoro a tempo pieno" 003   "Altri motivi" 997   "Non sa"  
label define  c29_051_cl240 001   "Studia o sta seguendo corsi di formazione professionale" 002   "Malattia, problemi di salute personali" 003   "Per prendersi cura dei figli, di bambini e/o di altre persone non autosufficienti" 004   "Svolge un secondo lavoro" 005   "Altri motivi familiari (esclusa cura dei figli o di altre persone)" 006   "Avere a disposizione pi tempo libero" 996   "Altri motivi (specificare)"  
label define  c29b_051_cl241 001   "S, sono assenti/inadeguati i servizi per la cura di bambini" 002   "S, sono assenti/inadeguati i servizi per la cura di persone anziane, malate, disabili" 003   "S, sono entrambi assenti/inadeguati" 004   "No" 997   "Non sa"  
label define  c32_051_cl243 001   "Meno del solito" 002   "Piu' del solito" 003   "Come al solito" 997   "Non sa"  
label define  c33_051_cl244 001   "Orario variabile, flessibile" 002   "Straordinario retribuito e/o non retribuito" 004   "Maggiori impegni di lavoro" 996   "Altro (specificare)"  
label define  c34_051_cl245 001   "Cassa Integrazione Guadagni (ordinaria o straordinaria)" 002   "Ridotta attivit dell'impresa per motivi economici e/o tecnici (esclusa CIG)" 003   "Sciopero" 004   "Vertenza sindacale, controversia di lavoro" 005   "Maltempo" 006   "Malattia, problemi di salute personali" 007   "Ferie" 008   "Festivit nella settimana" 009   "Orario variabile o flessibile (ad es. riposo compensativo)" 010   "Part-time verticale" 011   "Studio o formazione non organizzata nell'ambito del proprio lavoro" 012   "Assenza obbligatoria per maternit" 013   "Assenza facoltativa fino all'ottavo anno del bambino (congedo parentale)" 014   "Motivi familiari (esclusa maternit obbligatoria e congedo parentale)" 015   "Mancanza di occasioni di maggior lavoro" 016   "Inizio o cambiamento del lavoro nella settimana" 017   "Ha concluso il lavoro nella settimana" 996   "Altro (specificare)"  
label define  c35_051_cl246 001   "S" 002   "No" 997   "Non sa"  
label define  c38_051_cl250 001   "S, meno ore" 002   "S, pi ore" 003   "No (avrebbe voluto lavorare lo stesso numero di ore)" 997   "Non sa"  
label define  c38a_051_cl251 1   "Aggiungendo un nuovo lavoro a quello che ha gi" 2   "Cambiando lavoro" 3   "Continuando a fare lo stesso lavoro" 4   "In uno qualunque dei modi precedenti"  
label define  c40_051_cl253 001   "S, entro due settimane" 002   "Si, dopo due settimane" 003   "No, non disponibile" 997   "Non sa"  
label define  c41_051_cl254 001   "Malattia, problemi di salute personali" 002   "Studio o Formazione non organizzata nell'ambito del proprio lavoro" 003   "Altri motivi personali (specificare)" 004   "Maternit, nascita di un figlio" 005   "Altri motivi familiari (esclusa cura dei figli o di altre persone)" 006   "Deve dare un preavviso" 007   "Per prendersi cura dei figli, bambini e/o di altre persone non autosufficienti" 996   "Altro motivo (specificare)" 997   "Non sa" 998   "Non risponde"  
label define  c42_051_cl255 001   "S, 2 o pi volte a settimana" 002   "S, meno di 2 volte a settimana" 003   "No" 997   "Non sa"  
label define  c43_051_cl256 001   "S, 2 o pi volte a settimana" 002   "S, meno di 2 volte a settimana" 003   "No" 997   "Non sa"  
label define  c44_051_cl257 001   "S, 2 o pi volte (nelle 4 settimane)" 002   "S, meno di 2 volte (nelle 4 settimane)" 003   "No" 997   "Non sa"  
label define  c45_051_cl258 001   "S, 2 o pi volte (nelle 4 settimane)" 002   "S, meno di 2 volte (nelle 4 settimane)" 003   "No" 997   "Non sa"  
label define  c46_051_cl259 001   "S" 002   "No" 997   "Non sa"  
label define  c47_051_cl260 001   "S" 002   "No" 997   "Non sa"  
label define  c48_051_cl261 001   "S, 2 o pi volte a settimana" 002   "S, meno di 2 volte a settimana" 003   "No" 997   "Non sa"  
label define  c51_051_cl262 001   "TORINO" 002   "VERCELLI" 003   "NOVARA" 004   "CUNEO" 005   "ASTI" 006   "ALESSANDRIA" 007   "AOSTA" 008   "IMPERIA" 009   "SAVONA" 010   "GENOVA" 011   "LA SPEZIA" 012   "VARESE" 013   "COMO" 014   "SONDRIO" 015   "MILANO" 016   "BERGAMO" 017   "BRESCIA" 018   "PAVIA" 019   "CREMONA" 020   "MANTOVA" 021   "BOLZANO" 022   "TRENTO" 023   "VERONA" 024   "VICENZA" 025   "BELLUNO" 026   "TREVISO" 027   "VENEZIA" 028   "PADOVA" 029   "ROVIGO" 030   "UDINE" 031   "GORIZIA" 032   "TRIESTE" 033   "PIACENZA" 034   "PARMA" 035   "REGGIO NELL'EMILIA" 036   "MODENA" 037   "BOLOGNA" 038   "FERRARA" 039   "RAVENNA" 040   "FORLI' - CESENA" 041   "PESARO E URBINO" 042   "ANCONA" 043   "MACERATA" 044   "ASCOLI PICENO" 045   "MASSA - CARRARA" 046   "LUCCA" 047   "PISTOIA" 048   "FIRENZE" 049   "LIVORNO" 050   "PISA" 051   "AREZZO" 052   "SIENA" 053   "GROSSETO" 054   "PERUGIA" 055   "TERNI" 056   "VITERBO" 057   "RIETI" 058   "ROMA" 059   "LATINA" 060   "FROSINONE" 061   "CASERTA" 062   "BENEVENTO" 063   "NAPOLI" 064   "AVELLINO" 065   "SALERNO" 066   "L'AQUILA" 067   "TERAMO" 068   "PESCARA" 069   "CHIETI" 070   "CAMPOBASSO" 071   "FOGGIA" 072   "BARI" 073   "TARANTO" 074   "BRINDISI" 075   "LECCE" 076   "POTENZA" 077   "MATERA" 078   "COSENZA" 079   "CATANZARO" 080   "REGGIO DI CALABRIA" 081   "TRAPANI" 082   "PALERMO" 083   "MESSINA" 084   "AGRIGENTO" 085   "CALTANISSETTA" 086   "ENNA" 087   "CATANIA" 088   "RAGUSA" 089   "SIRACUSA" 090   "SASSARI" 091   "NUORO" 092   "CAGLIARI" 093   "PORDENONE" 094   "ISERNIA" 095   "ORISTANO" 096   "BIELLA" 097   "LECCO" 098   "LODI" 099   "RIMINI" 100   "PRATO" 101   "CROTONE" 102   "VIBO VALENTIA" 103   "VERBANO-CUSIO-OSSOLA"  
label define  c53_051_cl263 001   "S, da un altro comune delle stessa provincia" 002   "S, da un'altra provincia" 003   "S, dall'estero" 004   "No" 005   "S, ma poi  tornato nella provincia di residenza" 997   "Non sa"  
label define  c54_051_cl264 001   "TORINO" 002   "VERCELLI" 003   "NOVARA" 004   "CUNEO" 005   "ASTI" 006   "ALESSANDRIA" 007   "AOSTA" 008   "IMPERIA" 009   "SAVONA" 010   "GENOVA" 011   "LA SPEZIA" 012   "VARESE" 013   "COMO" 014   "SONDRIO" 015   "MILANO" 016   "BERGAMO" 017   "BRESCIA" 018   "PAVIA" 019   "CREMONA" 020   "MANTOVA" 021   "BOLZANO" 022   "TRENTO" 023   "VERONA" 024   "VICENZA" 025   "BELLUNO" 026   "TREVISO" 027   "VENEZIA" 028   "PADOVA" 029   "ROVIGO" 030   "UDINE" 031   "GORIZIA" 032   "TRIESTE" 033   "PIACENZA" 034   "PARMA" 035   "REGGIO NELL'EMILIA" 036   "MODENA" 037   "BOLOGNA" 038   "FERRARA" 039   "RAVENNA" 040   "FORLI' - CESENA" 041   "PESARO E URBINO" 042   "ANCONA" 043   "MACERATA" 044   "ASCOLI PICENO" 045   "MASSA - CARRARA" 046   "LUCCA" 047   "PISTOIA" 048   "FIRENZE" 049   "LIVORNO" 050   "PISA" 051   "AREZZO" 052   "SIENA" 053   "GROSSETO" 054   "PERUGIA" 055   "TERNI" 056   "VITERBO" 057   "RIETI" 058   "ROMA" 059   "LATINA" 060   "FROSINONE" 061   "CASERTA" 062   "BENEVENTO" 063   "NAPOLI" 064   "AVELLINO" 065   "SALERNO" 066   "L'AQUILA" 067   "TERAMO" 068   "PESCARA" 069   "CHIETI" 070   "CAMPOBASSO" 071   "FOGGIA" 072   "BARI" 073   "TARANTO" 074   "BRINDISI" 075   "LECCE" 076   "POTENZA" 077   "MATERA" 078   "COSENZA" 079   "CATANZARO" 080   "REGGIO DI CALABRIA" 081   "TRAPANI" 082   "PALERMO" 083   "MESSINA" 084   "AGRIGENTO" 085   "CALTANISSETTA" 086   "ENNA" 087   "CATANIA" 088   "RAGUSA" 089   "SIRACUSA" 090   "SASSARI" 091   "NUORO" 092   "CAGLIARI" 093   "PORDENONE" 094   "ISERNIA" 095   "ORISTANO" 096   "BIELLA" 097   "LECCO" 098   "LODI" 099   "RIMINI" 100   "PRATO" 101   "CROTONE" 102   "VIBO VALENTIA" 103   "VERBANO-CUSIO-OSSOLA"  
label define  c59_051_cl265 001   "S" 002   "No" 997   "Non sa"  
label define  c60_051_cl266 001   "S" 002   "No" 997   "Non sa"  
label define  d1_051_cl267 1   "S, un altro lavoro" 2   "S, pi di uno" 3   "No"  
label define  d3_051_cl269 001   "Regolarmente" 002   "Solo in alcune stagioni (o in particolari periodi dell'anno)" 003   "Ogni tanto, quando capita" 997   "Non sa"  
label define  d4_051_cl270 1   "Un lavoro alle dipendenze" 2   "Un lavoro di: Collaborazione coordinata e continuativa (con o senza progetto)" 3   "Un lavoro di: Prestazione d'opera occasionale" 4   "Un lavoro autonomo come: Imprenditore" 5   "Un lavoro autonomo come: Libero professionista" 6   "Un lavoro autonomo come: Lavoratore in proprio" 7   "Un lavoro autonomo come: Coadiuvante nell'azienda di un familiare" 8   "Un lavoro autonomo come: Socio di cooperativa"  
label define  d5_051_cl271 1   "Si,  Contratto di lavoro alle dipendenze" 2   "Si,  Contratto di collaborazione coordinata e continuativa (con o senza progetto)" 3   "No"  
label define  d5a_051_cl272 1   "S" 2   "No"  
label define  d5bis_051_cl273 1   "S" 2   "No"  
label define  d7_051_cl274 1   "S" 2   "No"  
label define  f1_051_cl276 1   "S" 2   "No"  
label define  f2_051_cl277 1   "Un nuovo lavoro" 2   "Un secondo lavoro (da aggiungere a quello attuale)"  
label define  f3_051_cl278 001   "Lavoro attuale  a termine (lavoro a tempo determinato)" 002   "Teme di perdere l'attuale lavoro" 003   "Considera l'attuale lavoro occasionale" 004   "Guadagnare di pi" 005   "Raggiungere pi facilmente il luogo di lavoro" 006   "Orario pi adatto a prendersi cura dei figli e/o di altri familiari" 007   "Orario diverso per altri motivi" 008   "Cerca un lavoro pi qualificante per le proprie  capacit/competenze e con maggiori prospettive di carriera" 009   "Cerca un lavoro pi adatto alle proprie condizioni di salute" 996   "Altri motivi (specificare)"  
label define  f4_051_cl279 001   "Pi ore" 002   "Meno ore" 003   "Lo stesso numero di ore" 997   "Non sa"  
label define  f5_051_cl280 1   "S" 2   "No"  
label define  f6_01_051_cl281 0   "No" 1   "Si"  
label define  f6_02_051_cl282 0   "No" 1   "Si"  
label define  f6_03_051_cl283 0   "No" 1   "Si"  
label define  f6_04_051_cl284 0   "No" 1   "Si"  
label define  f6_05_051_cl285 0   "No" 1   "Si"  
label define  f6_06_051_cl286 0   "No" 1   "Si"  
label define  f6_07_051_cl287 0   "No" 1   "Si"  
label define  f6_08_051_cl288 0   "No" 1   "Si"  
label define  f6_09_051_cl289 0   "No" 1   "Si"  
label define  f6_10_051_cl290 0   "No" 1   "Si"  
label define  f6_11_051_cl291 0   "No" 1   "Si"  
label define  f6_12_051_cl292 0   "No" 1   "Si"  
label define  f6_96_051_cl293 0   "No" 1   "Si"  
label define  f7_051_cl294 1   "S" 2   "No"  
label define  f8_051_cl295 1   "S" 2   "No"  
label define  f10_051_cl297 001   "Ha gi un lavoro che inizier in futuro" 002   "Studia o segue corsi di formazione professionale" 003   "Malattia, problemi di salute personali" 004   "Per prendersi cura dei figli, di bambini e/o di altre  persone non autosufficenti" 005   "In attesa di tornare al suo posto di lavoro" 006   "Deve iniziare il servizio di leva o il servizio civile" 007   "Pensione da lavoro (anzianit o vecchiaia)" 008   "Ritiene di non riuscire a trovare lavoro" 009   "Non gli interessa/non ne ha bisogno (anche per motivi di et)" 010   "Sta aspettando gli esiti di passate azioni di ricerca" 011   "Inabile al lavoro" 012   "Maternit, nascita di un figlio" 013   "Altri motivi familiari (esclusa maternit, cura dei figli o di altre persone)" 996   "Altri motivi (specificare)" 997   "Non sa"  
label define  f10a_051_cl298 001   "S, sono assenti/inadeguati i servizi per la cura di bambini" 002   "S, sono assenti/inadeguati i servizi per la cura di persone anziane, malate, disabili" 003   "S, sono entrambi assenti/inadeguati" 004   "No" 997   "Non sa"  
label define  f12_051_cl299 1   "S" 2   "No"  
label define  f13_051_cl300 1   "S, entro 2 settimane" 2   "S, dopo 2 settimane" 3   "No"  
label define  f14_051_cl301 001   "Studia o segue corsi di formazione professionale" 002   "Altri motivi personali" 003   "Maternit, nascita di un figlio" 004   "Altri motivi familiari (esclusa la maternit, cura dei figli o di altre persone)" 005   "Malattia, problemi di salute personali" 006   "Deve dare un preavviso" 007   "Deve o vuole concludere il lavoro gi iniziato" 008   "Deve iniziare il servizio di leva o il servizio civile" 009   "Per prendersi cura dei figli, di bambini e/o di altre persone non autosufficienti" 996   "Altri motivi (specificare)" 997   "Non sa" 998   "Non risponde"  
label define  f15_051_cl302 001   "S" 002   "No" 997   "Non sa"  
label define  f16_051_cl303 1   "S" 2   "No"  
label define  f17_051_cl304 1   "S" 2   "No"  
label define  f18_051_cl305 1   "S" 2   "No"  
label define  f19_051_cl306 1   "S" 2   "No"  
label define  f20_051_cl307 1   "S" 2   "No"  
label define  f21_051_cl308 1   "S" 2   "No"  
label define  f22_051_cl309 1   "S" 2   "No"  
label define  f23_051_cl310 1   "S" 2   "No"  
label define  f24_051_cl311 1   "S" 2   "No"  
label define  f25_051_cl312 1   "S" 2   "No"  
label define  f26_051_cl313 1   "S" 2   "No"  
label define  f27_051_cl314 1   "S" 2   "No"  
label define  f28_051_cl315 1   "Si (specificare)" 2   "No"  
label define  f29_01_051_cl316 0   "No" 1   "Si"  
label define  f29_02_051_cl317 0   "No" 1   "Si"  
label define  f29_03_051_cl318 0   "No" 1   "Si"  
label define  f29_04_051_cl319 0   "No" 1   "Si"  
label define  f29_97_051_cl320 0   "No" 1   "Si"  
label define  f30_051_cl321 1   "S" 2   "No"  
label define  f32_051_cl323 1   "Studiava" 2   "Era in servizio militare o in servizio civile sostitutivo" 3   "Lavorava" 4   "Si prendeva cura della casa e/o dei familiari" 5   "In altra condizione"  
label define  f33_051_cl324 1   "S, disponibile ad iniziare entro 2 settimane" 2   "No, non disponibile ad iniziare entro 2 settimane"  
label define  f34_051_cl325 001   "Studia o segue corsi di formazione professionale" 002   "Altri motivi personali" 003   "Maternit, nascita di un figlio" 004   "Altri motivi familiari (esclusa la maternit, cura dei figli o di altre persone)" 005   "Malattia, problemi di salute personali" 006   "Deve dare un preavviso" 007   "Deve o vuole concludere il lavoro gi iniziato" 008   "Deve iniziare il servizio di leva o il servizio civile" 009   "Per prendersi cura dei figli, di bambini e/o di altre persone non autosufficienti" 996   "Altri motivi (specificare)" 997   "Non sa" 998   "Non risponde"  
label define  f35_051_cl326 1   "In proprio" 2   "Dipendente" 3   "Senza preferenze"  
label define  f36_051_cl327 1   "A tempo pieno" 2   "A tempo parziale (part-time)" 3   "Senza preferenze"  
label define  f37_051_cl328 1   "S" 2   "No"  
label define  f38_051_cl329 1   "S" 2   "No"  
label define  f39_051_cl330 001   "A termine" 002   "A tempo indeterminato" 997   "Non sa"  
label define  f40_051_cl331 001   "S" 002   "No" 997   "Non sa"  
label define  f41_051_cl332 001   "Soltanto nel comune di residenza" 002   "In altro comune raggiungibile giornalmente" 003   "Ovunque, in Italia" 004   "Ovunque, anche all'estero" 997   "Non sa"  
label define  f44_051_cl335 1   "Studiava" 2   "Era in servizio militare o in servizio civile sostitutivo" 3   "Lavorava" 4   "Si prendeva cura dei figli e/o di altri familiari" 5   "In altra condizione"  
label define  f45_051_cl336 1   "Entro 2 settimane" 2   "Tra 2 settimane e 3 mesi" 3   "Tra pi di 3 mesi"  
label define  f46_051_cl337 1   "S, disponibile ad iniziare entro 2 settimane" 2   "No, non disponibile ad iniziare entro 2 settimane"  
label define  f47_051_cl338 001   "Studia o segue corsi di formazione professionale" 002   "Altri motivi personali" 003   "Maternit, nascita di un figlio" 004   "Altri motivi familiari (esclusa la maternit, cura dei figli o di altre persone)" 005   "Malattia, problemi di salute personali" 006   "Deve dare un preavviso" 007   "Deve o vuole concludere il lavoro gi iniziato" 008   "Deve iniziare il servizio di leva o il servizio civile" 009   "Per prendersi cura dei figli, di bambini e/o di altre persone non autosufficienti" 996   "Altri motivi (specificare)" 997   "Non sa" 998   "Non risponde"  
label define  f48_051_cl339 1   "In proprio" 2   "Alle dipendenze"  
label define  f49_051_cl340 001   "Tempo pieno" 002   "Part-time (a tempo parziale)" 997   "Non sa"  
label define  f50_051_cl341 001   "S" 002   "No" 997   "Non sa"  
label define  i1_051_cl342 1   "Occupato" 2   "Disoccupato alla ricerca di nuova occupazione" 3   "In cerca di prima occupazione" 4   "Casalinga/o" 5   "Studente" 6   "Ritirato/a dal lavoro" 7   "Inabile al lavoro" 8   "In servizio di leva o servizio civile" 9   "In altra condizione (specificare)"  
label define  llases_051_cl343 201   "Albania" 202   "Andorra" 203   "Austria" 206   "Belgio" 209   "Bulgaria" 212   "Danimarca" 214   "Finlandia" 215   "Francia" 216   "Germania" 219   "Regno Unito" 220   "Grecia" 221   "Irlanda" 223   "Islanda" 224   "Jugoslavia (Serbia-Montenegro)" 225   "Liechtenstein" 226   "Lussemburgo" 227   "Malta" 229   "Monaco" 231   "Norvegia" 232   "Paesi Bassi" 233   "Polonia" 234   "Portogallo" 235   "Romania" 236   "San Marino" 239   "Spagna" 240   "Svezia" 241   "Svizzera" 243   "Ucraina" 244   "Ungheria" 245   "Russa, Federazione" 246   "Citt del Vaticano" 247   "Estonia" 248   "Lettonia" 249   "Lituania" 250   "Croazia" 251   "Slovenia" 252   "Bosnia-Erzegovina" 253   "Macedonia, ex-Rep. Jugoslavia" 254   "Moldavia" 255   "Slovacchia" 256   "Bielorussia" 257   "Repubblica Ceca" 301   "Afghanistan" 302   "Arabia Saudita" 304   "Bahrein" 305   "Bangladesh" 306   "Bhutan" 307   "Myanmar (Birmania)" 309   "Brunei" 310   "Cambogia" 311   "Sri Lanka (Ceylon)" 314   "Cina" 315   "Cipro" 319   "Corea del Nord" 320   "Corea del Sud" 321   "Macao" 322   "Emirati Arabi Uniti" 323   "Filippine" 324   "Palestina" 326   "Giappone" 327   "Giordania" 330   "India" 331   "Indonesia" 332   "Iran" 333   "Iraq" 334   "Israele" 335   "Kuwait" 336   "Laos" 337   "Libano" 338   "Timor orientale" 339   "Maldive" 340   "Malaysia" 341   "Mongolia" 342   "Nepal" 343   "Oman" 344   "Pakistan" 345   "Qatar" 346   "Singapore" 348   "Siria" 349   "Thailandia" 351   "Turchia" 353   "Vietnam" 354   "Yemen" 356   "Kazakistan" 357   "Uzbekistan" 358   "Armenia" 359   "Azerbaigian" 360   "Georgia" 361   "Kirghizistan" 362   "Tagikistan" 363   "Taiwan (Formosa)" 364   "Turkmenistan" 401   "Algeria" 402   "Angola" 404   "Costa d'Avorio" 406   "Benin (Dahomey)" 408   "Botswana" 409   "Burkina Faso (Alto Volta)" 410   "Burundi" 411   "Camerun" 413   "Capo Verde" 414   "Centrafricana, Rep." 415   "Ciad" 417   "Comore" 418   "Congo" 419   "Egitto" 420   "Etiopia" 421   "Gabon" 422   "Gambia" 423   "Ghana" 424   "Gibuti" 425   "Guinea" 426   "Guinea Bissau" 427   "Guinea Equatoriale" 428   "Kenia" 429   "Lesotho" 430   "Liberia" 431   "Libia" 432   "Madagascar" 434   "Malawi" 435   "Mali" 436   "Marocco" 437   "Mauritania" 438   "Maurizio" 440   "Mozambico" 441   "Namibia" 442   "Niger" 443   "Nigeria" 446   "Ruanda" 448   "Sao Tom e Principe" 449   "Seycelles" 450   "Senegal" 451   "Sierra Leone" 453   "Somalia" 454   "Sudafricana, Rep." 455   "Sudan" 456   "Swaziland" 457   "Tanzania" 458   "Togo" 460   "Tunisia" 461   "Uganda" 463   "Congo, Rep.Dem. (Zaire)" 464   "Zambia" 465   "Zimbabwe (Rhodesia)" 466   "Eritrea" 503   "Antigua e Barbuda" 505   "Bahama" 506   "Barbados" 507   "Belize" 509   "Canada" 513   "Costarica" 514   "Cuba" 515   "Dominica" 516   "Dominicana, Rep." 517   "El Salvador" 518   "Giamaica" 519   "Grenada" 523   "Guatemala" 524   "Haiti" 525   "Honduras" 527   "Messico" 529   "Nicaragua" 530   "Panama" 532   "Saint Lucia" 533   "Saint Vincent e Grenadine" 534   "Saint Kitts e Nevis" 536   "Stati Uniti d'America" 602   "Argentina" 604   "Bolivia" 605   "Brasile" 606   "Cile" 608   "Colombia" 609   "Ecuador" 612   "Guyana" 614   "Paraguay" 615   "Per" 616   "Suriname" 617   "Trinidad e Tobago" 618   "Uruguay" 619   "Venezuela" 701   "Australia" 703   "Figi" 708   "Kiribati" 712   "Marshall" 713   "Micronesia" 715   "Nauru" 719   "Nuova Zelanda" 720   "Palau" 721   "Papua Nuova Guinea" 725   "Salomone" 727   "Samoa" 730   "Tonga" 731   "Tuvalu" 732   "Vanuatu"  
label define  cond3_051_cl344 1   "occupati" 2   "persone in cerca" 3   "inattivi"  
label define  cond10_051_cl345 01   "occupati" 02   "persone in cerca, con precedenti esperienze, ex-occupati" 03   "persone in cerca, con precedenti esperienze, ex-inattivi" 04   "persone in cerca, senza precedenti esperienze" 05   "inattivi in et lav., cercano non attivamente ma disponibili" 06   "inattivi in et lav., cercano ma non disponibili" 07   "inattivi in et lav., non cercano ma disponibili" 08   "inattivi in et lav., non cercano e non disponibili (anche militari di leva e inabili al lavoro)" 09   "inattivi in et non lav., meno di 15 anni" 10   "inattivi in et non lav., pi di 64 anni"  
label define  dipaut_051_cl346 1   "dipendente" 2   "collaboratore" 3   "autonomo"  
label define  dipind_051_cl347 1   "Dipendente" 2   "Indipendente"  
label define  assocc_051_cl348 1   "S" 2   "No"  
label define  pospro_051_cl349 01   "Dirigente" 02   "Quadro" 03   "Impiegato" 04   "Operaio" 05   "Apprendista" 06   "Lavoratore presso il proprio domicilio per conto di un impresa" 07   "Imprenditore" 08   "Libero professionista" 09   "Lavoratore in proprio" 10   "Socio di cooperativa" 11   "Coadiuvante nell azienda di un familiare" 12   "Collaborazione coordinata e continuativa" 13   "Prestazione d opera occasionale"  
label define  detind_051_cl350 1   "tempo determinato" 2   "tempo indeterminato"  
label define  piepar_051_cl351 1   "tempo pieno" 2   "tempo parziale"  
label define  tipcon_051_cl352 001   "Contratto di formazione e lavoro (inquadrato in un CCNL)" 002   "Contratto di apprendistato (inquadrato in un CCNL)" 003   "Contratto Individuale di Lavoro a termine (inquadrato in un CCNL)" 004   "Contratto di lavoro interinale o di somministrazione lavoro (inquadrato in un CCNL)" 996   "Altro tipo di contratto" 997   "Non sa"  
label define  prof1_051_cl354 1   "LEGISLATORI, DIRIGENTI E IMPRENDITORI" 2   "PROFESSIONI INTELLETTUALI, SCIENTIFICHE E DI ELEVATA SPECIALIZZAZIONE" 3   "PROFESSIONI TECNICHE" 4   "IMPIEGATI" 5   "PROFESSIONI QUALIFICATE NELLE ATTIVITA" 6   "ARTIGIANI, OPERAI SPECIALIZZATI E AGRICOLTORI" 7   "CONDUTTORI DI IMPIANTI E OPERAI SEMIQUALIFICATI ADDETTI A MACCHINARI FISSI E MOBILI" 8   "PROFESSIONI NON QUALIFICATE" 9   "FORZE ARMATE"  
label define  ate2d_051_cl357 01   "agricoltura, caccia e relativi servizi" 02   "silvicoltura e utilizzazione di aree forestali e servizi connessi" 05   "pesca, piscicoltura e servizi connessi" 10   "estrazione di carbon fossile, lignite, torba" 11   "estrazione di petrolio greggio e di gas naturale e servizi connessi, esclusa la prospezione" 12   "estrazione di minerali di uranio e di torio" 13   "estrazione di minerali metalliferi" 14   "altre industrie estrattive" 15   "industrie alimentari e delle bevande" 16   "industria del tabacco" 17   "industrie tessili" 18   "confezione di articoli di abbigliamento; preparazione, tintura e confezione di pellicce" 19   "preparazione e concia del cuoio; fabbricazione di articoli da viaggio, borse, marocchineria, selleria e calzature" 20   "industria del legno e dei prodotti in legno e sughero, esclusi i mobili; fabbricazione di articoli in materiali da intreccio" 21   "fabbricazione della pasta-carta, della carta e del cartone e dei prodotti di carta" 22   "editoria, stampa e riproduzione di supporti registrati" 23   "fabbricazione di coke, raffinerie di petrolio, trattamento dei combustibili nucleari" 24   "fabbricazione di prodotti chimici e di fibre sintetiche e artificiali" 25   "fabbricazione di articoli in gomma e materie plastiche" 26   "fabbricazione di prodotti della lavorazione di minerali non metalliferi" 27   "metallurgia" 28   "fabbricazione e lavorazione dei prodotti in metallo, esclusi macchine e impianti" 29   "fabbricazione di macchine ed apparecchi meccanici" 30   "fabbricazione di macchine per ufficio, di elaboratori e sistemi informatici" 31   "fabbricazione di macchine ed apparecchi elettrici n.c.a." 32   "fabbricazione di apparecchi radiotelevisivi e di apparecchiature per le comunicazioni" 33   "fabbricazione di apparecchi medicali, di apparecchi di precisione, di strumenti ottici e di orologi" 34   "fabbricazione di autoveicoli, rimorchi e semirimorchi" 35   "fabbricazione di altri mezzi di trasporto" 36   "fabbricazione di mobili; altre industrie manifatturiere" 37   "recupero e preparazione per il riciclaggio" 40   "produzione e distribuzione di energia elettrica, di gas, di calore" 41   "raccolta, depurazione e distribuzione d'acqua" 45   "costruzioni" 50   "commercio, manutenzione e riparazione di autoveicoli e motocicli; vendita al dettaglio di carburanti per autotrazione" 51   "commercio all'ingrosso e intermediari del commercio, autoveicoli e motocicli esclusi" 52   "commercio al dettaglio (escluso quello di autoveicoli e di motocicli); riparazione di beni personali e per la casa" 55   "alberghi e ristoranti" 60   "trasporti terrestri; trasporti mediante condotte" 61   "trasporti marittimi e per vie d'acqua" 62   "trasporti aerei" 63   "attivit di supporto ed ausiliarie dei trasporti; attivit delle agenzie di viaggio" 64   "poste e telecomunicazioni" 65   "intermediazione monetaria e finanziaria (escluse le assicurazioni e i fondi pensione)" 66   "assicurazioni e fondi pensione, escluse le assicurazioni sociali obbligatorie" 67   "attivit ausiliarie dell'intermediazione finanziaria e delle assicurazioni" 70   "attivit immobiliari" 71   "noleggio di macchinari e attrezzature senza operatore e di beni per uso personale e domestico" 72   "informatica e attivit connesse" 73   "ricerca e sviluppo" 74   "attivit di servizi alle imprese" 75   "amministrazione pubblica" 80   "istruzione" 85   "sanit e assistenza sociale" 90   "smaltimento dei rifiuti solidi, delle acque di scarico e simili" 91   "attivit di organizzazioni associative" 92   "attivit ricreative, culturali e sportive" 93   "servizi alle famiglie" 95   "attivit di datore di lavoro per personale domestico svolto da famiglie e convivenze" 96   "produzione di beni per uso proprio da parte di famiglie e convivenze" 97   "produzione di servizi per uso proprio da parte di famiglie e convivenze" 99   "organizzazioni ed organismi extraterritoriali"  
label define  cat12_051_cl358 01   "Agricoltura, caccia e pesca" 02   "Industria dell energia, estrazione materiali energetici" 03   "Industria della trasformazione" 04   "Industria delle costruzioni" 05   "Altre attivit: commercio" 06   "Altre attivit: alberghi e ristoranti" 07   "Altre attivit: trasporti e comunicazioni" 08   "Altre attivit: intermediazione monetaria e finanziaria, attivit immobiliari" 09   "Altre attivit: servizi alle imprese e altre attivit professionali e imprenditoriali" 10   "Altre attivit: pubblica amministrazione, difesa, assicurazioni sociali obbligatorie" 11   "Altre attivit: istruzione, sanit ed altri servizi sociali" 12   "Altre attivit: altri servizi pubblici, sociali e alle persone"  
label define  cat5_051_cl359 1   "Agricoltura" 2   "Industria in senso stretto" 3   "Costruzioni" 4   "Commercio" 5   "Altre attivit"  
label define  cat3_051_cl360 1   "Agricoltura" 2   "Industria" 3   "Terziario"  
label define  regspe_051_cl361 01   "Piemonte" 02   "Valle d'Aosta" 03   "Lombardia" 04   "Trentino alto Adige" 05   "Veneto" 06   "Friuli Venezia Giulia" 07   "Liguria" 08   "Emilia Romagna" 09   "Toscana" 10   "Umbria" 11   "Marche" 12   "Lazio" 13   "Abruzzo" 14   "Molise" 15   "Campania" 16   "Puglia" 17   "Basilicata" 18   "Calabria" 19   "Sicilia" 20   "Sardegna"  
label define  prospe_051_cl362 001   "TORINO" 002   "VERCELLI" 003   "NOVARA" 004   "CUNEO" 005   "ASTI" 006   "ALESSANDRIA" 007   "AOSTA" 008   "IMPERIA" 009   "SAVONA" 010   "GENOVA" 011   "LA SPEZIA" 012   "VARESE" 013   "COMO" 014   "SONDRIO" 015   "MILANO" 016   "BERGAMO" 017   "BRESCIA" 018   "PAVIA" 019   "CREMONA" 020   "MANTOVA" 021   "BOLZANO" 022   "TRENTO" 023   "VERONA" 024   "VICENZA" 025   "BELLUNO" 026   "TREVISO" 027   "VENEZIA" 028   "PADOVA" 029   "ROVIGO" 030   "UDINE" 031   "GORIZIA" 032   "TRIESTE" 033   "PIACENZA" 034   "PARMA" 035   "REGGIO NELL'EMILIA" 036   "MODENA" 037   "BOLOGNA" 038   "FERRARA" 039   "RAVENNA" 040   "FORLI' - CESENA" 041   "PESARO E URBINO" 042   "ANCONA" 043   "MACERATA" 044   "ASCOLI PICENO" 045   "MASSA - CARRARA" 046   "LUCCA" 047   "PISTOIA" 048   "FIRENZE" 049   "LIVORNO" 050   "PISA" 051   "AREZZO" 052   "SIENA" 053   "GROSSETO" 054   "PERUGIA" 055   "TERNI" 056   "VITERBO" 057   "RIETI" 058   "ROMA" 059   "LATINA" 060   "FROSINONE" 061   "CASERTA" 062   "BENEVENTO" 063   "NAPOLI" 064   "AVELLINO" 065   "SALERNO" 066   "L'AQUILA" 067   "TERAMO" 068   "PESCARA" 069   "CHIETI" 070   "CAMPOBASSO" 071   "FOGGIA" 072   "BARI" 073   "TARANTO" 074   "BRINDISI" 075   "LECCE" 076   "POTENZA" 077   "MATERA" 078   "COSENZA" 079   "CATANZARO" 080   "REGGIO DI CALABRIA" 081   "TRAPANI" 082   "PALERMO" 083   "MESSINA" 084   "AGRIGENTO" 085   "CALTANISSETTA" 086   "ENNA" 087   "CATANIA" 088   "RAGUSA" 089   "SIRACUSA" 090   "SASSARI" 091   "NUORO" 092   "CAGLIARI" 093   "PORDENONE" 094   "ISERNIA" 095   "ORISTANO" 096   "BIELLA" 097   "LECCO" 098   "LODI" 099   "RIMINI" 100   "PRATO" 101   "CROTONE" 102   "VIBO VALENTIA" 103   "VERBANO-CUSIO-OSSOLA" 104   "OLBIA-TEMPIO" 105   "OGLIASTRA" 106   "MEDIO CAMPIDANO" 107   "CARBONIA-IGLESIAS"  
label define  tracom_051_cl363 001   "Si, da altro comune della stessa provincia" 002   "Si, da altra provincia della stessa regione" 003   "Si, da altra regione" 004   "Si, dall estero" 005   "No" 006   "Si, ma poi  tornato nella provincia di residenza" 997   "Non sa"  
label define  regtra_051_cl364 01   "Piemonte" 02   "Valle d'Aosta" 03   "Lombardia" 04   "Trentino alto Adige" 05   "Veneto" 06   "Friuli Venezia Giulia" 07   "Liguria" 08   "Emilia Romagna" 09   "Toscana" 10   "Umbria" 11   "Marche" 12   "Lazio" 13   "Abruzzo" 14   "Molise" 15   "Campania" 16   "Puglia" 17   "Basilicata" 18   "Calabria" 19   "Sicilia" 20   "Sardegna"  
label define  protra_051_cl365 001   "TORINO" 002   "VERCELLI" 003   "NOVARA" 004   "CUNEO" 005   "ASTI" 006   "ALESSANDRIA" 007   "AOSTA" 008   "IMPERIA" 009   "SAVONA" 010   "GENOVA" 011   "LA SPEZIA" 012   "VARESE" 013   "COMO" 014   "SONDRIO" 015   "MILANO" 016   "BERGAMO" 017   "BRESCIA" 018   "PAVIA" 019   "CREMONA" 020   "MANTOVA" 021   "BOLZANO" 022   "TRENTO" 023   "VERONA" 024   "VICENZA" 025   "BELLUNO" 026   "TREVISO" 027   "VENEZIA" 028   "PADOVA" 029   "ROVIGO" 030   "UDINE" 031   "GORIZIA" 032   "TRIESTE" 033   "PIACENZA" 034   "PARMA" 035   "REGGIO NELL'EMILIA" 036   "MODENA" 037   "BOLOGNA" 038   "FERRARA" 039   "RAVENNA" 040   "FORLI' - CESENA" 041   "PESARO E URBINO" 042   "ANCONA" 043   "MACERATA" 044   "ASCOLI PICENO" 045   "MASSA - CARRARA" 046   "LUCCA" 047   "PISTOIA" 048   "FIRENZE" 049   "LIVORNO" 050   "PISA" 051   "AREZZO" 052   "SIENA" 053   "GROSSETO" 054   "PERUGIA" 055   "TERNI" 056   "VITERBO" 057   "RIETI" 058   "ROMA" 059   "LATINA" 060   "FROSINONE" 061   "CASERTA" 062   "BENEVENTO" 063   "NAPOLI" 064   "AVELLINO" 065   "SALERNO" 066   "L'AQUILA" 067   "TERAMO" 068   "PESCARA" 069   "CHIETI" 070   "CAMPOBASSO" 071   "FOGGIA" 072   "BARI" 073   "TARANTO" 074   "BRINDISI" 075   "LECCE" 076   "POTENZA" 077   "MATERA" 078   "COSENZA" 079   "CATANZARO" 080   "REGGIO DI CALABRIA" 081   "TRAPANI" 082   "PALERMO" 083   "MESSINA" 084   "AGRIGENTO" 085   "CALTANISSETTA" 086   "ENNA" 087   "CATANIA" 088   "RAGUSA" 089   "SIRACUSA" 090   "SASSARI" 091   "NUORO" 092   "CAGLIARI" 093   "PORDENONE" 094   "ISERNIA" 095   "ORISTANO" 096   "BIELLA" 097   "LECCO" 098   "LODI" 099   "RIMINI" 100   "PRATO" 101   "CROTONE" 102   "VIBO VALENTIA" 103   "VERBANO-CUSIO-OSSOLA" 104   "OLBIA-TEMPIO" 105   "OGLIASTRA" 106   "MEDIO CAMPIDANO" 107   "CARBONIA-IGLESIAS"  
label define  dipaus_051_cl366 1   "dipendente" 2   "collaboratore" 3   "autonomo"  
label define  dipins_051_cl367 1   "Dipendente" 2   "Indipendente"  
label define  prof1s_051_cl368 1   "LEGISLATORI, DIRIGENTI E IMPRENDITORI" 2   "PROFESSIONI INTELLETTUALI, SCIENTIFICHE E DI ELEVATA SPECIALIZZAZIONE" 3   "PROFESSIONI TECNICHE" 4   "IMPIEGATI" 5   "PROFESSIONI QUALIFICATE NELLE ATTIVITA" 6   "ARTIGIANI, OPERAI SPECIALIZZATI E AGRICOLTORI" 7   "CONDUTTORI DI IMPIANTI E OPERAI SEMIQUALIFICATI ADDETTI A MACCHINARI FISSI E MOBILI" 8   "PROFESSIONI NON QUALIFICATE" 9   "FORZE ARMATE"  
label define  ate2ds_051_cl371 01   "agricoltura, caccia e relativi servizi" 02   "silvicoltura e utilizzazione di aree forestali e servizi connessi" 05   "pesca, piscicoltura e servizi connessi" 10   "estrazione di carbon fossile, lignite, torba" 11   "estrazione di petrolio greggio e di gas naturale e servizi connessi, esclusa la prospezione" 12   "estrazione di minerali di uranio e di torio" 13   "estrazione di minerali metalliferi" 14   "altre industrie estrattive" 15   "industrie alimentari e delle bevande" 16   "industria del tabacco" 17   "industrie tessili" 18   "confezione di articoli di abbigliamento; preparazione, tintura e confezione di pellicce" 19   "preparazione e concia del cuoio; fabbricazione di articoli da viaggio, borse, marocchineria, selleria e calzature" 20   "industria del legno e dei prodotti in legno e sughero, esclusi i mobili; fabbricazione di articoli in materiali da intreccio" 21   "fabbricazione della pasta-carta, della carta e del cartone e dei prodotti di carta" 22   "editoria, stampa e riproduzione di supporti registrati" 23   "fabbricazione di coke, raffinerie di petrolio, trattamento dei combustibili nucleari" 24   "fabbricazione di prodotti chimici e di fibre sintetiche e artificiali" 25   "fabbricazione di articoli in gomma e materie plastiche" 26   "fabbricazione di prodotti della lavorazione di minerali non metalliferi" 27   "metallurgia" 28   "fabbricazione e lavorazione dei prodotti in metallo, esclusi macchine e impianti" 29   "fabbricazione di macchine ed apparecchi meccanici" 30   "fabbricazione di macchine per ufficio, di elaboratori e sistemi informatici" 31   "fabbricazione di macchine ed apparecchi elettrici n.c.a." 32   "fabbricazione di apparecchi radiotelevisivi e di apparecchiature per le comunicazioni" 33   "fabbricazione di apparecchi medicali, di apparecchi di precisione, di strumenti ottici e di orologi" 34   "fabbricazione di autoveicoli, rimorchi e semirimorchi" 35   "fabbricazione di altri mezzi di trasporto" 36   "fabbricazione di mobili; altre industrie manifatturiere" 37   "recupero e preparazione per il riciclaggio" 40   "produzione e distribuzione di energia elettrica, di gas, di calore" 41   "raccolta, depurazione e distribuzione d'acqua" 45   "costruzioni" 50   "commercio, manutenzione e riparazione di autoveicoli e motocicli; vendita al dettaglio di carburanti per autotrazione" 51   "commercio all'ingrosso e intermediari del commercio, autoveicoli e motocicli esclusi" 52   "commercio al dettaglio (escluso quello di autoveicoli e di motocicli); riparazione di beni personali e per la casa" 55   "alberghi e ristoranti" 60   "trasporti terrestri; trasporti mediante condotte" 61   "trasporti marittimi e per vie d'acqua" 62   "trasporti aerei" 63   "attivit di supporto ed ausiliarie dei trasporti; attivit delle agenzie di viaggio" 64   "poste e telecomunicazioni" 65   "intermediazione monetaria e finanziaria (escluse le assicurazioni e i fondi pensione)" 66   "assicurazioni e fondi pensione, escluse le assicurazioni sociali obbligatorie" 67   "attivit ausiliarie dell'intermediazione finanziaria e delle assicurazioni" 70   "attivit immobiliari" 71   "noleggio di macchinari e attrezzature senza operatore e di beni per uso personale e domestico" 72   "informatica e attivit connesse" 73   "ricerca e sviluppo" 74   "attivit di servizi alle imprese" 75   "amministrazione pubblica" 80   "istruzione" 85   "sanit e assistenza sociale" 90   "smaltimento dei rifiuti solidi, delle acque di scarico e simili" 91   "attivit di organizzazioni associative" 92   "attivit ricreative, culturali e sportive" 93   "servizi alle famiglie" 95   "attivit di datore di lavoro per personale domestico svolto da famiglie e convivenze" 96   "produzione di beni per uso proprio da parte di famiglie e convivenze" 97   "produzione di servizi per uso proprio da parte di famiglie e convivenze" 99   "organizzazioni ed organismi extraterritoriali"  
label define  cat12s_051_cl372 01   "Agricoltura, caccia e pesca" 02   "Industria dell energia, estrazione materiali energetici" 03   "Industria della trasformazione" 04   "Industria delle costruzioni" 05   "Altre attivit: commercio" 06   "Altre attivit: alberghi e ristoranti" 07   "Altre attivit: trasporti e comunicazioni" 08   "Altre attivit: intermediazione monetaria e finanziaria, attivit immobiliari" 09   "Altre attivit: servizi alle imprese e altre attivit professionali e imprenditoriali" 10   "Altre attivit: pubblica amministrazione, difesa, assicurazioni sociali obbligatorie" 11   "Altre attivit: istruzione, sanit ed altri servizi sociali" 12   "Altre attivit: altri servizi pubblici, sociali e alle persone"  
label define  cat5s_051_cl373 1   "Agricoltura" 2   "Industria in senso stretto" 3   "Costruzioni" 4   "Commercio" 5   "Altre attivit"  
label define  cat3s_051_cl374 1   "Agricoltura" 2   "Industria" 3   "Terziario"  
label define  dipaua_051_cl375 1   "dipendente" 2   "collaboratore" 3   "autonomo"  
label define  dipina_051_cl376 1   "Dipendente" 2   "Indipendente"  
label define  esplav_051_cl377 1   "ha precedenti esperienze lavorative" 2   "non ha precedenti esperienze lavorative"  
label values  trim_041 trim_041_cl1
label values  reg_041 reg_041_cl2
label values  codpro_041 codpro_041_cl3
label values  sg11_041 sg11_041_cl5
label values  sg13_041 sg13_041_cl6
label values  sg16_041 sg16_041_cl7
label values  sg18_041 sg18_041_cl8
label values  sg24_041 sg24_041_cl9
label values  sg28_041 sg28_041_cl10
label values  b1_041 b1_041_cl11
label values  b2_041 b2_041_cl12
label values  b3_041 b3_041_cl13
label values  b3bis_041 b3bis_041_cl14
label values  b4_041 b4_041_cl15
label values  b4bis_041 b4bis_041_cl16
label values  b5_041 b5_041_cl17
label values  b6_041 b6_041_cl18
label values  b7_041 b7_041_cl19
label values  b8_041 b8_041_cl20
label values  b9_041 b9_041_cl21
label values  b10_041 b10_041_cl22
label values  b11_041 b11_041_cl23
label values  c1_041 c1_041_cl24
label values  c1bis_041 c1bis_041_cl25
label values  c1ter_041 c1ter_041_cl26
label values  c2_041 c2_041_cl27
label values  c4_041 c4_041_cl28
label values  c5_041 c5_041_cl29
label values  c6_041 c6_041_cl30
label values  c7_041 c7_041_cl31
label values  c9_041 c9_041_cl32
label values  c10_041 c10_041_cl33
label values  c14_041 c14_041_cl34
label values  c18_041 c18_041_cl36
label values  c20_041 c20_041_cl38
label values  c22_041 c22_041_cl40
label values  c24_041 c24_041_cl41
label values  c25_041 c25_041_cl42
label values  c26_041 c26_041_cl43
label values  c27_041 c27_041_cl44
label values  c28_041 c28_041_cl45
label values  c29_041 c29_041_cl46
label values  c30_041 c30_041_cl47
label values  c32_041 c32_041_cl49
label values  c33_041 c33_041_cl50
label values  c34_041 c34_041_cl51
label values  c35_041 c35_041_cl52
label values  c38_041 c38_041_cl55
label values  c38a_041 c38a_041_cl56
label values  c40_041 c40_041_cl58
label values  c41_041 c41_041_cl59
label values  c42_041 c42_041_cl60
label values  c43_041 c43_041_cl61
label values  c44_041 c44_041_cl62
label values  c45_041 c45_041_cl63
label values  c46_041 c46_041_cl64
label values  c47_041 c47_041_cl65
label values  c48_041 c48_041_cl66
label values  c51_041 c51_041_cl67
label values  c53_041 c53_041_cl68
label values  c54_041 c54_041_cl69
label values  c59_041 c59_041_cl70
label values  c60_041 c60_041_cl71
label values  d1_041 d1_041_cl72
label values  d3_041 d3_041_cl74
label values  d4_041 d4_041_cl75
label values  d5_041 d5_041_cl76
label values  d7_041 d7_041_cl77
label values  f1_041 f1_041_cl79
label values  f2_041 f2_041_cl80
label values  f3_041 f3_041_cl81
label values  f4_041 f4_041_cl82
label values  f5_041 f5_041_cl83
label values  f6_01_041 f6_01_041_cl84
label values  f6_02_041 f6_02_041_cl85
label values  f6_03_041 f6_03_041_cl86
label values  f6_04_041 f6_04_041_cl87
label values  f6_05_041 f6_05_041_cl88
label values  f6_06_041 f6_06_041_cl89
label values  f6_07_041 f6_07_041_cl90
label values  f6_08_041 f6_08_041_cl91
label values  f6_09_041 f6_09_041_cl92
label values  f6_10_041 f6_10_041_cl93
label values  f6_11_041 f6_11_041_cl94
label values  f6_12_041 f6_12_041_cl95
label values  f6_96_041 f6_96_041_cl96
label values  f7_041 f7_041_cl97
label values  f8_041 f8_041_cl98
label values  f10_041 f10_041_cl100
label values  f11_041 f11_041_cl101
label values  f12_041 f12_041_cl102
label values  f13_041 f13_041_cl103
label values  f14_041 f14_041_cl104
label values  f15_041 f15_041_cl105
label values  f16_041 f16_041_cl106
label values  f17_041 f17_041_cl107
label values  f18_041 f18_041_cl108
label values  f19_041 f19_041_cl109
label values  f20_041 f20_041_cl110
label values  f21_041 f21_041_cl111
label values  f22_041 f22_041_cl112
label values  f23_041 f23_041_cl113
label values  f24_041 f24_041_cl114
label values  f25_041 f25_041_cl115
label values  f26_041 f26_041_cl116
label values  f27_041 f27_041_cl117
label values  f28_041 f28_041_cl118
label values  f29_01_041 f29_01_041_cl119
label values  f29_02_041 f29_02_041_cl120
label values  f29_03_041 f29_03_041_cl121
label values  f29_04_041 f29_04_041_cl122
label values  f29_97_041 f29_97_041_cl123
label values  f30_041 f30_041_cl124
label values  f32_041 f32_041_cl126
label values  f33_041 f33_041_cl127
label values  f34_041 f34_041_cl128
label values  f35_041 f35_041_cl129
label values  f36_041 f36_041_cl130
label values  f37_041 f37_041_cl131
label values  f38_041 f38_041_cl132
label values  f39_041 f39_041_cl133
label values  f40_041 f40_041_cl134
label values  f41_041 f41_041_cl135
label values  f44_041 f44_041_cl138
label values  f45_041 f45_041_cl139
label values  f46_041 f46_041_cl140
label values  f47_041 f47_041_cl141
label values  f48_041 f48_041_cl142
label values  f49_041 f49_041_cl143
label values  f50_041 f50_041_cl144
label values  i1_041 i1_041_cl145
label values  i5_041 i5_041_cl146
label values  i6_041 i6_041_cl147
label values  i7_041 i7_041_cl148
label values  i8_041 i8_041_cl149
label values  i9_041 i9_041_cl150
label values  rip4_041 rip4_041_cl152
label values  rip3_041 rip3_041_cl153
label values  cletad_041 cletad_041_cl155
label values  cletaq_041 cletaq_041_cl156
label values  cletas_041 cletas_041_cl157
label values  cittad_041 cittad_041_cl158
label values  llases_041 llases_041_cl159
label values  cond3_041 cond3_041_cl160
label values  cond10_041 cond10_041_cl161
label values  dipaut_041 dipaut_041_cl162
label values  dipind_041 dipind_041_cl163
label values  assocc_041 assocc_041_cl164
label values  pospro_041 pospro_041_cl165
label values  detind_041 detind_041_cl166
label values  piepar_041 piepar_041_cl167
label values  prof1_041 prof1_041_cl169
label values  ate2d_041 ate2d_041_cl172
label values  cat12_041 cat12_041_cl173
label values  cat5_041 cat5_041_cl174
label values  cat3_041 cat3_041_cl175
label values  regspe_041 regspe_041_cl176
label values  prospe_041 prospe_041_cl177
label values  tracom_041 tracom_041_cl178
label values  regtra_041 regtra_041_cl179
label values  protra_041 protra_041_cl180
label values  dipaus_041 dipaus_041_cl181
label values  dipins_041 dipins_041_cl182
label values  prof1s_041 prof1s_041_cl183
label values  ate2ds_041 ate2ds_041_cl186
label values  cat12s_041 cat12s_041_cl187
label values  cat5s_041 cat5s_041_cl188
label values  cat3s_041 cat3s_041_cl189
label values  dipaua_041 dipaua_041_cl190
label values  dipina_041 dipina_041_cl191
label values  dipaup_041 dipaup_041_cl192
label values  dipinp_041 dipinp_041_cl193
label values  ate2dp_041 ate2dp_041_cl194
label values  cat12p_041 cat12p_041_cl195
label values  cat5p_041 cat5p_041_cl196
label values  cat3p_041 cat3p_041_cl197
label values  esplav_041 esplav_041_cl198
label values  trim_051 trim_051_cl201
label values  sg24_051 sg24_051_cl203
label values  sg28_051 sg28_051_cl204
label values  b1_051 b1_051_cl205
label values  b2_051 b2_051_cl206
label values  b3_051 b3_051_cl207
label values  b3bis_051 b3bis_051_cl208
label values  b4_051 b4_051_cl209
label values  b4a_051 b4a_051_cl210
label values  b4bis_051 b4bis_051_cl211
label values  b6_051 b6_051_cl212
label values  b7_051 b7_051_cl213
label values  b8_051 b8_051_cl214
label values  b9_051 b9_051_cl215
label values  b10_051 b10_051_cl216
label values  b11_051 b11_051_cl217
label values  c1_051 c1_051_cl218
label values  c1bis_051 c1bis_051_cl219
label values  c1a_051 c1a_051_cl220
label values  c1b_051 c1b_051_cl221
label values  c1d_051 c1d_051_cl222
label values  c4_051 c4_051_cl223
label values  c5_051 c5_051_cl224
label values  c6_051 c6_051_cl225
label values  c7_051 c7_051_cl226
label values  c9_051 c9_051_cl227
label values  c10_051 c10_051_cl228
label values  c14_051 c14_051_cl229
label values  c18_051 c18_051_cl231
label values  c20_051 c20_051_cl233
label values  c22_051 c22_051_cl235
label values  c25_051 c25_051_cl236
label values  c26_051 c26_051_cl237
label values  c27_051 c27_051_cl238
label values  c28_051 c28_051_cl239
label values  c29_051 c29_051_cl240
label values  c29b_051 c29b_051_cl241
label values  c32_051 c32_051_cl243
label values  c33_051 c33_051_cl244
label values  c34_051 c34_051_cl245
label values  c35_051 c35_051_cl246
label values  c38_051 c38_051_cl250
label values  c38a_051 c38a_051_cl251
label values  c40_051 c40_051_cl253
label values  c41_051 c41_051_cl254
label values  c42_051 c42_051_cl255
label values  c43_051 c43_051_cl256
label values  c44_051 c44_051_cl257
label values  c45_051 c45_051_cl258
label values  c46_051 c46_051_cl259
label values  c47_051 c47_051_cl260
label values  c48_051 c48_051_cl261
label values  c51_051 c51_051_cl262
label values  c53_051 c53_051_cl263
label values  c54_051 c54_051_cl264
label values  c59_051 c59_051_cl265
label values  c60_051 c60_051_cl266
label values  d1_051 d1_051_cl267
label values  d3_051 d3_051_cl269
label values  d4_051 d4_051_cl270
label values  d5_051 d5_051_cl271
label values  d5a_051 d5a_051_cl272
label values  d5bis_051 d5bis_051_cl273
label values  d7_051 d7_051_cl274
label values  f1_051 f1_051_cl276
label values  f2_051 f2_051_cl277
label values  f3_051 f3_051_cl278
label values  f4_051 f4_051_cl279
label values  f5_051 f5_051_cl280
label values  f6_01_051 f6_01_051_cl281
label values  f6_02_051 f6_02_051_cl282
label values  f6_03_051 f6_03_051_cl283
label values  f6_04_051 f6_04_051_cl284
label values  f6_05_051 f6_05_051_cl285
label values  f6_06_051 f6_06_051_cl286
label values  f6_07_051 f6_07_051_cl287
label values  f6_08_051 f6_08_051_cl288
label values  f6_09_051 f6_09_051_cl289
label values  f6_10_051 f6_10_051_cl290
label values  f6_11_051 f6_11_051_cl291
label values  f6_12_051 f6_12_051_cl292
label values  f6_96_051 f6_96_051_cl293
label values  f7_051 f7_051_cl294
label values  f8_051 f8_051_cl295
label values  f10_051 f10_051_cl297
label values  f10a_051 f10a_051_cl298
label values  f12_051 f12_051_cl299
label values  f13_051 f13_051_cl300
label values  f14_051 f14_051_cl301
label values  f15_051 f15_051_cl302
label values  f16_051 f16_051_cl303
label values  f17_051 f17_051_cl304
label values  f18_051 f18_051_cl305
label values  f19_051 f19_051_cl306
label values  f20_051 f20_051_cl307
label values  f21_051 f21_051_cl308
label values  f22_051 f22_051_cl309
label values  f23_051 f23_051_cl310
label values  f24_051 f24_051_cl311
label values  f25_051 f25_051_cl312
label values  f26_051 f26_051_cl313
label values  f27_051 f27_051_cl314
label values  f28_051 f28_051_cl315
label values  f29_01_051 f29_01_051_cl316
label values  f29_02_051 f29_02_051_cl317
label values  f29_03_051 f29_03_051_cl318
label values  f29_04_051 f29_04_051_cl319
label values  f29_97_051 f29_97_051_cl320
label values  f30_051 f30_051_cl321
label values  f32_051 f32_051_cl323
label values  f33_051 f33_051_cl324
label values  f34_051 f34_051_cl325
label values  f35_051 f35_051_cl326
label values  f36_051 f36_051_cl327
label values  f37_051 f37_051_cl328
label values  f38_051 f38_051_cl329
label values  f39_051 f39_051_cl330
label values  f40_051 f40_051_cl331
label values  f41_051 f41_051_cl332
label values  f44_051 f44_051_cl335
label values  f45_051 f45_051_cl336
label values  f46_051 f46_051_cl337
label values  f47_051 f47_051_cl338
label values  f48_051 f48_051_cl339
label values  f49_051 f49_051_cl340
label values  f50_051 f50_051_cl341
label values  i1_051 i1_051_cl342
label values  llases_051 llases_051_cl343
label values  cond3_051 cond3_051_cl344
label values  cond10_051 cond10_051_cl345
label values  dipaut_051 dipaut_051_cl346
label values  dipind_051 dipind_051_cl347
label values  assocc_051 assocc_051_cl348
label values  pospro_051 pospro_051_cl349
label values  detind_051 detind_051_cl350
label values  piepar_051 piepar_051_cl351
label values  tipcon_051 tipcon_051_cl352
label values  prof1_051 prof1_051_cl354
label values  ate2d_051 ate2d_051_cl357
label values  cat12_051 cat12_051_cl358
label values  cat5_051 cat5_051_cl359
label values  cat3_051 cat3_051_cl360
label values  regspe_051 regspe_051_cl361
label values  prospe_051 prospe_051_cl362
label values  tracom_051 tracom_051_cl363
label values  regtra_051 regtra_051_cl364
label values  protra_051 protra_051_cl365
label values  dipaus_051 dipaus_051_cl366
label values  dipins_051 dipins_051_cl367
label values  prof1s_051 prof1s_051_cl368
label values  ate2ds_051 ate2ds_051_cl371
label values  cat12s_051 cat12s_051_cl372
label values  cat5s_051 cat5s_051_cl373
label values  cat3s_051 cat3s_051_cl374
label values  dipaua_051 dipaua_051_cl375
label values  dipina_051 dipina_051_cl376
label values  esplav_051 esplav_051_cl377
*/
save  ISTAT_MFR_RCFL_Long_Microdati_2004_Primo_trimestre_ESEMPIO_STRUTTURA_FILE.dta, replace
