/* Declinazione di responsabilità. 
I file rilasciati in formato testo sono provvisti anche dei programmi di importazione per STATA, SAS e R. 
L'Istat non garantisce che le funzioni contenute nei suddetti programmi siano esenti da errore e non si assume alcuna responsabilità sull’output ottenuto dal loro utilizzo.                 */
%macro grabpath;
%qsubstr(%sysget(SAS_EXECFILEPATH),1,%length(%sysget(SAS_EXECFILEPATH))-%length(%sysget(SAS_EXECFILEname)))
%mend grabpath;
%let path = %grabpath;
%let nomeFile =ISTAT_MFR_EUSILC_Long_Microdata_2019_PERSONAL_REGISTER_(R-FILE)_Longitudinal_FILE_STRUCTURE_EXAMPLE.txt;
LIBNAME ISTAT "&path";
DATA ISTAT.EUSILC_Long_A2019_PERSONAL_REGI;

INFILE "&path&nomeFile" DLM='09'x  LRECL=32767 TRUNCOVER FIRSTOBS=2 IGNOREDOSEOF;
INPUT 
RB010 :5.   /*  YEAR OF THE SURVEY */
RB020 : $3.   /*  COUNTRY */
RB030 :12.   /*  PERSONAL ID */
RB040 :10.   /*  CURRENT HOUSEHOLD ID */
RB060 :16.   /*  PERSONAL BASE WEIGHT */
RB060_F :2.   /*  FLAG OF RB060 */
RB062 :16.   /*  LONGITUDINAL WEIGHT (TWO-YEAR DURATION) */
RB062_F :2.   /*  FLAG OF RB062 */
RB063 :16.   /*  LONGITUDINAL WEIGHT (THREE-YEAR DURATION) */
RB063_F :2.   /*  FLAG OF RB063 */
RB064 :16.   /*  LONGITUDINAL WEIGHT (FOUR-YEAR DURATION) */
RB064_F :2.   /*  FLAG OF RB064 */
RB070 :2.   /*  MONTH OF BIRTH */
RB070_F :2.   /*  FLAG OF RB070 */
RB080 :5.   /*  YEAR OF BIRTH */
RB080_F :2.   /*  FLAG OF RB080 */
RB090 :2.   /*  SEX */
RB090_F :2.   /*  FLAG OF RB090 */
RB100 :2.   /*  SAMPLE PERSON OR CO-RESIDENT */
RB100_F :2.   /*  FLAG OF RB100 */
RB110 :2.   /*  MEMBERSHIP STATUS */
RB110_F :2.   /*  FLAG OF RB110 */
RB120 :2.   /*  MOVED TO */
RB120_F :2.   /*  FLAG OF RB120 */
RB140 :2.   /*  MONTH MOVED OUT OR DIED */
RB140_F :2.   /*  FLAG OF RB140 */
RB150 :5.   /*  YEAR MOVED OUT OR DIED */
RB150_F :2.   /*  FLAG OF RB150 */
RB160 :3.   /*  NUMBER OF MONTHS IN HOUSEHOLD DURING THE INCOME REFERENCE PERIOD */
RB160_F :2.   /*  FLAG OF RB160 */
RB170 :2.   /*  MAIN ACTIVITY STATUS DURING THE INCOME REFERENCE PERIOD */
RB170_F :2.   /*  FLAG OF RB170 */
RB180 :2.   /*  MONTH MOVED IN */
RB180_F :2.   /*  FLAG OF RB180 */
RB190 :5.   /*  YEAR MOVED IN */
RB190_F :2.   /*  FLAG OF RB190 */
RB200 :2.   /*  RESIDENTIAL STATUS */
RB200_F :2.   /*  FLAG OF RB200 */
RB210 :2.   /*  BASIC ACTIVITY STATUS */
RB210_F :2.   /*  FLAG OF RB210 */
RB220 :12.   /*  FATHER ID */
RB220_F :2.   /*  FLAG OF RB220 */
RB230 :12.   /*  MOTHER ID */
RB230_F :2.   /*  FLAG OF RB230 */
RB240 :12.   /*  SPOUSE/PARTNER ID */
RB240_F :2.   /*  FLAG OF RB240 */
RB245 :2.   /*  RESPONDENT STATUS */
RB245_F :2.   /*  FLAG OF RB245 */
RB250 :3.   /*  DATA STATUS */
RB250_F :2.   /*  FLAG OF RB250 */
RB260 :2.   /*  TYPE OF INTERVIEW */
RB260_F :2.   /*  FLAG OF RB260 */
RB270 :12.   /*  PERSONAL ID OF PROXY */
RB270_F :2.   /*  FLAG OF RB270 */
RX010 :3.   /*  AGE AT THE TIME OF INTERVIEW */
RX020 :3.   /*  AGE AT THE END OF INCOME REFERENCE PERIOD */
;
LABEL 
RB010 = "YEAR OF THE SURVEY"
RB020 = "COUNTRY"
RB030 = "PERSONAL ID"
RB040 = "CURRENT HOUSEHOLD ID"
RB060 = "PERSONAL BASE WEIGHT"
RB060_F = "FLAG OF RB060"
RB062 = "LONGITUDINAL WEIGHT (TWO-YEAR DURATION)"
RB062_F = "FLAG OF RB062"
RB063 = "LONGITUDINAL WEIGHT (THREE-YEAR DURATION)"
RB063_F = "FLAG OF RB063"
RB064 = "LONGITUDINAL WEIGHT (FOUR-YEAR DURATION)"
RB064_F = "FLAG OF RB064"
RB070 = "MONTH OF BIRTH"
RB070_F = "FLAG OF RB070"
RB080 = "YEAR OF BIRTH"
RB080_F = "FLAG OF RB080"
RB090 = "SEX"
RB090_F = "FLAG OF RB090"
RB100 = "SAMPLE PERSON OR CO-RESIDENT"
RB100_F = "FLAG OF RB100"
RB110 = "MEMBERSHIP STATUS"
RB110_F = "FLAG OF RB110"
RB120 = "MOVED TO"
RB120_F = "FLAG OF RB120"
RB140 = "MONTH MOVED OUT OR DIED"
RB140_F = "FLAG OF RB140"
RB150 = "YEAR MOVED OUT OR DIED"
RB150_F = "FLAG OF RB150"
RB160 = "NUMBER OF MONTHS IN HOUSEHOLD DURING THE INCOME REFERENCE PERIOD"
RB160_F = "FLAG OF RB160"
RB170 = "MAIN ACTIVITY STATUS DURING THE INCOME REFERENCE PERIOD"
RB170_F = "FLAG OF RB170"
RB180 = "MONTH MOVED IN"
RB180_F = "FLAG OF RB180"
RB190 = "YEAR MOVED IN"
RB190_F = "FLAG OF RB190"
RB200 = "RESIDENTIAL STATUS"
RB200_F = "FLAG OF RB200"
RB210 = "BASIC ACTIVITY STATUS"
RB210_F = "FLAG OF RB210"
RB220 = "FATHER ID"
RB220_F = "FLAG OF RB220"
RB230 = "MOTHER ID"
RB230_F = "FLAG OF RB230"
RB240 = "SPOUSE/PARTNER ID"
RB240_F = "FLAG OF RB240"
RB245 = "RESPONDENT STATUS"
RB245_F = "FLAG OF RB245"
RB250 = "DATA STATUS"
RB250_F = "FLAG OF RB250"
RB260 = "TYPE OF INTERVIEW"
RB260_F = "FLAG OF RB260"
RB270 = "PERSONAL ID OF PROXY"
RB270_F = "FLAG OF RB270"
RX010 = "AGE AT THE TIME OF INTERVIEW"
RX020 = "AGE AT THE END OF INCOME REFERENCE PERIOD"
;
RUN;
PROC FORMAT;
VALUE $RB01F /* RB020 */
"AL" = "Albania"
"AT" = "Osterreich"
"BE" = "Belgique/Belgie"
"BG" = "Bulgaria"
"CH" = "Switzerland"
"CY" = "Cyprus"
"CZ" = "Czech Republic"
"DE" = "Deutschland"
"DK" = "Denmark"
"EE" = "Estonia"
"EL" = "Ellada"
"ES" = "Espana"
"FI" = "Suomi"
"FR" = "France"
"HR" = "Croatia"
"HU" = "Hungary"
"IE" = "Ireland"
"IS" = "Iceland"
"IT" = "Italia"
"LT" = "Lithuania"
"LU" = "Luxembourg"
"LV" = "Latvia"
"ME" = "Montenegro"
"MK" = "The Former Yugoslav Republic of Macedonia (FYROM)"
"MT" = "Malta"
"NL" = "Nederland"
"NO" = "Norway"
"PL" = "Poland"
"PT" = "Portugal"
"RO" = "Romania"
"RS" = "Serbia"
"SE" = "Sverige"
"SI" = "Slovenia"
"SK" = "Slovak Republic"
"TR" = "Turkey"
"UK" = "United Kingdom"
;
VALUE RB05F /* RB060_F */
1= "Filled"
;
VALUE RB07F /* RB062_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable (only 1 year trajectory for the individual, i.e.individual in first wave)"
;
VALUE RB09F /* RB063_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable (less than three-year trajectory for the individual, i.e. individual in first or second wave)"
;
VALUE RB011F /* RB064_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable (less than four-year trajectory for the individual, i.e. individual in first, second or third wave)"
;
VALUE RB012F /* RB070 */
1= "January-March"
2= "April-June"
3= "July-September"
4= "October-December"
;
VALUE RB013F /* RB070_F */
1= "Filled"
-1= "Missing"
;
VALUE RB015F /* RB080_F */
1= "Filled"
-1= "Missing"
;
VALUE RB016F /* RB090 */
1= "Male"
2= "Female"
;
VALUE RB017F /* RB090_F */
1= "Filled"
-1= "Missing"
;
VALUE RB118F /* RB100 */
1= "Sample person"
2= "Co-resident"
;
VALUE RB119F /* RB100_F */
1= "Filled"
-1= "Missing"
;
VALUE RB120F /* RB110 */
1= "Was in this household in previous waves or current household member"
2= "Moved into this household from another sample household since previous wave"
3= "Moved into this household from outside sample since previous wave"
4= "Newly born into this household since last wave"
5= "Moved out since previous wave or last interview if not contacted in previous wave"
6= "Died"
7= "Lived in the household at least three months during the income reference period and was not recorded in the register of this household"
;
VALUE RB121F /* RB110_F */
1= "Filled"
-1= "Missing"
;
VALUE RB122F /* RB120 */
1= "To a private household in the country"
2= "To a collective household or institution in the country"
3= "Abroad"
4= "Lost"
;
VALUE RB123F /* RB120_F */
1= "Filled"
-2= "Not applicable (RB110 not equal to 5)"
;
VALUE RB124F /* RB140 */
1= "January-March"
2= "April-June"
3= "July-September"
4= "October-December"
;
VALUE RB125F /* RB140_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable (RB110 not equal to 5 or 6)"
;
VALUE RB127F /* RB150_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable (RB110 not equal to 5 or 6)"
;
VALUE RB129F /* RB160_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable (RB110 not equal to 5 or 6 or 7)"
;
VALUE RB130F /* RB170 */
1= "At work"
2= "Unemployed"
3= "In retirement or early retirement or has given up business"
4= "Other inactive person"
;
VALUE RB131F /* RB170_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable (RB110 not equal to 5 or 6 or 7)"
;
VALUE RB132F /* RB180 */
1= "January-March"
2= "April-June"
3= "July-September"
4= "October-December"
;
VALUE RB133F /* RB180_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable (RB110 not equal to 3)"
;
VALUE RB135F /* RB190_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable (RB110 not equal to 3)"
;
VALUE RB236F /* RB200 */
1= "Currently living in the household"
2= "Temporarily absent"
;
VALUE RB237F /* RB200_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable (RB110 not equal to 1, 2, 3 or 4)"
;
VALUE RB238F /* RB210 */
1= "At work"
2= "Unemployed"
3= "In retirement or early retirement or has given up business"
4= "Other inactive person"
;
VALUE RB239F /* RB210_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable (RB110 not equal to 1, 2, 3 or 4)"
;
VALUE RB241F /* RB220_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable ((father is not a household member) OR (RB110 not equal to 1, 2, 3 or 4))"
;
VALUE RB243F /* RB230_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable ((mother is not a household member) OR (RB110 not equal to 1, 2, 3 or 4))"
;
VALUE RB245F /* RB240_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable ((spouse/partner is not a household member) OR (RB110 not equal to 1, 2, 3 or 4))"
;
VALUE RB246F /* RB245 */
1= "Current household member aged 16 and over"
2= "Selected respondent"
3= "Non-selected respondent"
4= "Ineligible person"
;
VALUE RB247F /* RB245_F */
1= "Filled"
-2= "Not applicable (RB110 not equal to 1, 2, 3 or 4))"
;
VALUE RB248F /* RB250 */
11= "Information completed only from interview"
12= "Information completed only from registers"
13= "Information completed from both: interview and registers"
14= "Information completed from full-record imputation"
21= "Individual unable to respond (illness, incapacity, etc) and no proxy possible"
22= "Failed to return self-completed questionnaire"
23= "Refusal to co-operate"
31= "Person temporarily away and no proxy possible"
32= "No contact for other reasons"
33= "Information not completed: reason unknown"
;
VALUE RB249F /* RB250_F */
1= "Filled"
-2= "Not applicable (RB245 not equal to 1, 2 or 3)"
;
VALUE RB250F /* RB260 */
1= "Face to face interview-PAPI"
2= "Face to face interview-CAPI"
3= "CATI, telephone interview"
4= "Self-administered by respondent"
5= "Computer assisted web interviewing-CAWI"
6= "Face to face interview-PAPI with proxy"
7= "Face to face interview-CAPI with proxy"
8= "CATI, telephone interview with proxy"
9= "Self-administered by respondent with proxy"
10= "Computer assisted web interviewing-CAWI with proxy"
;
VALUE RB251F /* RB260_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable (RB250 not equal to 11 or 13) or RB245 eq 3"
;
VALUE RB253F /* RB270_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable (RB260 not equal to 6, 7, 8, 9, 10)"
;
format RB020 $RB01F.;
format RB060_F RB05F.;
format RB062_F RB07F.;
format RB063_F RB09F.;
format RB064_F RB011F.;
format RB070 RB012F.;
format RB070_F RB013F.;
format RB080_F RB015F.;
format RB090 RB016F.;
format RB090_F RB017F.;
format RB100 RB118F.;
format RB100_F RB119F.;
format RB110 RB120F.;
format RB110_F RB121F.;
format RB120 RB122F.;
format RB120_F RB123F.;
format RB140 RB124F.;
format RB140_F RB125F.;
format RB150_F RB127F.;
format RB160_F RB129F.;
format RB170 RB130F.;
format RB170_F RB131F.;
format RB180 RB132F.;
format RB180_F RB133F.;
format RB190_F RB135F.;
format RB200 RB236F.;
format RB200_F RB237F.;
format RB210 RB238F.;
format RB210_F RB239F.;
format RB220_F RB241F.;
format RB230_F RB243F.;
format RB240_F RB245F.;
format RB245 RB246F.;
format RB245_F RB247F.;
format RB250 RB248F.;
format RB250_F RB249F.;
format RB260 RB250F.;
format RB260_F RB251F.;
format RB270_F RB253F.;
RUN;
