#Declinazione di responsabilità. 
#I file rilasciati in formato testo sono provvisti anche dei programmi di importazione per STATA, SAS e R. 
#L'Istat non garantisce che le funzioni contenute nei suddetti programmi siano esenti da errore e non si assume alcuna responsabilità sull’output ottenuto dal loro utilizzo.  
setwd(choose.dir(default = "", caption = "WHERE ARE MICRODATA?"))
direttorio = getwd()
fileInput = paste (direttorio, "/ISTAT_MFR_EUSILC_Long_Microdata_2019_PERSONAL_REGISTER_(R-FILE)_Longitudinal_FILE_STRUCTURE_EXAMPLE.txt", sep="")
DF_EUSILC_Long_A2019_PERSONAL_R<- read.delim2 (fileInput,  header=T, sep="	",  quote="",  na.strings = ".")
attr(DF_EUSILC_Long_A2019_PERSONAL_R, "label") <- c(
"YEAR OF THE SURVEY",
"COUNTRY",
"PERSONAL ID",
"CURRENT HOUSEHOLD ID",
"PERSONAL BASE WEIGHT",
"FLAG OF RB060",
"LONGITUDINAL WEIGHT (TWO-YEAR DURATION)",
"FLAG OF RB062",
"LONGITUDINAL WEIGHT (THREE-YEAR DURATION)",
"FLAG OF RB063",
"LONGITUDINAL WEIGHT (FOUR-YEAR DURATION)",
"FLAG OF RB064",
"MONTH OF BIRTH",
"FLAG OF RB070",
"YEAR OF BIRTH",
"FLAG OF RB080",
"SEX",
"FLAG OF RB090",
"SAMPLE PERSON OR CO-RESIDENT",
"FLAG OF RB100",
"MEMBERSHIP STATUS",
"FLAG OF RB110",
"MOVED TO",
"FLAG OF RB120",
"MONTH MOVED OUT OR DIED",
"FLAG OF RB140",
"YEAR MOVED OUT OR DIED",
"FLAG OF RB150",
"NUMBER OF MONTHS IN HOUSEHOLD DURING THE INCOME REFERENCE PERIOD",
"FLAG OF RB160",
"MAIN ACTIVITY STATUS DURING THE INCOME REFERENCE PERIOD",
"FLAG OF RB170",
"MONTH MOVED IN",
"FLAG OF RB180",
"YEAR MOVED IN",
"FLAG OF RB190",
"RESIDENTIAL STATUS",
"FLAG OF RB200",
"BASIC ACTIVITY STATUS",
"FLAG OF RB210",
"FATHER ID",
"FLAG OF RB220",
"MOTHER ID",
"FLAG OF RB230",
"SPOUSE/PARTNER ID",
"FLAG OF RB240",
"RESPONDENT STATUS",
"FLAG OF RB245",
"DATA STATUS",
"FLAG OF RB250",
"TYPE OF INTERVIEW",
"FLAG OF RB260",
"PERSONAL ID OF PROXY",
"FLAG OF RB270",
"AGE AT THE TIME OF INTERVIEW",
"AGE AT THE END OF INCOME REFERENCE PERIOD")

RB020_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_R$RB020, 
levels=c("AL", 
"AT", 
"BE", 
"BG", 
"CH", 
"CY", 
"CZ", 
"DE", 
"DK", 
"EE", 
"EL", 
"ES", 
"FI", 
"FR", 
"HR", 
"HU", 
"IE", 
"IS", 
"IT", 
"LT", 
"LU", 
"LV", 
"ME", 
"MK", 
"MT", 
"NL", 
"NO", 
"PL", 
"PT", 
"RO", 
"RS", 
"SE", 
"SI", 
"SK", 
"TR", 
"UK"), 
labels=c("Albania", 
"Osterreich", 
"Belgique/Belgie", 
"Bulgaria", 
"Switzerland", 
"Cyprus", 
"Czech Republic", 
"Deutschland", 
"Denmark", 
"Estonia", 
"Ellada", 
"Espana", 
"Suomi", 
"France", 
"Croatia", 
"Hungary", 
"Ireland", 
"Iceland", 
"Italia", 
"Lithuania", 
"Luxembourg", 
"Latvia", 
"Montenegro", 
"The Former Yugoslav Republic of Macedonia (FYROM)", 
"Malta", 
"Nederland", 
"Norway", 
"Poland", 
"Portugal", 
"Romania", 
"Serbia", 
"Sverige", 
"Slovenia", 
"Slovak Republic", 
"Turkey", 
"United Kingdom")) 


RB060_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_R$RB060_F, 
levels=c(1), 
labels=c("Filled")) 


RB062_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_R$RB062_F, 
levels=c(1, 
-1, 
-2), 
labels=c("Filled", 
"Missing", 
"Not applicable (only 1 year trajectory for the individual, i.e.individual in first wave)")) 


RB063_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_R$RB063_F, 
levels=c(1, 
-1, 
-2), 
labels=c("Filled", 
"Missing", 
"Not applicable (less than three-year trajectory for the individual, i.e. individual in first or second wave)")) 


RB064_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_R$RB064_F, 
levels=c(1, 
-1, 
-2), 
labels=c("Filled", 
"Missing", 
"Not applicable (less than four-year trajectory for the individual, i.e. individual in first, second or third wave)")) 


RB070_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_R$RB070, 
levels=c(1, 
2, 
3, 
4), 
labels=c("January-March", 
"April-June", 
"July-September", 
"October-December")) 


RB070_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_R$RB070_F, 
levels=c(1, 
-1), 
labels=c("Filled", 
"Missing")) 


RB080_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_R$RB080_F, 
levels=c(1, 
-1), 
labels=c("Filled", 
"Missing")) 


RB090_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_R$RB090, 
levels=c(1, 
2), 
labels=c("Male", 
"Female")) 


RB090_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_R$RB090_F, 
levels=c(1, 
-1), 
labels=c("Filled", 
"Missing")) 


RB100_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_R$RB100, 
levels=c(1, 
2), 
labels=c("Sample person", 
"Co-resident")) 


RB100_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_R$RB100_F, 
levels=c(1, 
-1), 
labels=c("Filled", 
"Missing")) 


RB110_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_R$RB110, 
levels=c(1, 
2, 
3, 
4, 
5, 
6, 
7), 
labels=c("Was in this household in previous waves or current household member", 
"Moved into this household from another sample household since previous wave", 
"Moved into this household from outside sample since previous wave", 
"Newly born into this household since last wave", 
"Moved out since previous wave or last interview if not contacted in previous wave", 
"Died", 
"Lived in the household at least three months during the income reference period and was not recorded in the register of this household")) 


RB110_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_R$RB110_F, 
levels=c(1, 
-1), 
labels=c("Filled", 
"Missing")) 


RB120_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_R$RB120, 
levels=c(1, 
2, 
3, 
4), 
labels=c("To a private household in the country", 
"To a collective household or institution in the country", 
"Abroad", 
"Lost")) 


RB120_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_R$RB120_F, 
levels=c(1, 
-2), 
labels=c("Filled", 
"Not applicable (RB110 not equal to 5)")) 


RB140_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_R$RB140, 
levels=c(1, 
2, 
3, 
4), 
labels=c("January-March", 
"April-June", 
"July-September", 
"October-December")) 


RB140_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_R$RB140_F, 
levels=c(1, 
-1, 
-2), 
labels=c("Filled", 
"Missing", 
"Not applicable (RB110 not equal to 5 or 6)")) 


RB150_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_R$RB150_F, 
levels=c(1, 
-1, 
-2), 
labels=c("Filled", 
"Missing", 
"Not applicable (RB110 not equal to 5 or 6)")) 


RB160_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_R$RB160_F, 
levels=c(1, 
-1, 
-2), 
labels=c("Filled", 
"Missing", 
"Not applicable (RB110 not equal to 5 or 6 or 7)")) 


RB170_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_R$RB170, 
levels=c(1, 
2, 
3, 
4), 
labels=c("At work", 
"Unemployed", 
"In retirement or early retirement or has given up business", 
"Other inactive person")) 


RB170_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_R$RB170_F, 
levels=c(1, 
-1, 
-2), 
labels=c("Filled", 
"Missing", 
"Not applicable (RB110 not equal to 5 or 6 or 7)")) 


RB180_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_R$RB180, 
levels=c(1, 
2, 
3, 
4), 
labels=c("January-March", 
"April-June", 
"July-September", 
"October-December")) 


RB180_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_R$RB180_F, 
levels=c(1, 
-1, 
-2), 
labels=c("Filled", 
"Missing", 
"Not applicable (RB110 not equal to 3)")) 


RB190_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_R$RB190_F, 
levels=c(1, 
-1, 
-2), 
labels=c("Filled", 
"Missing", 
"Not applicable (RB110 not equal to 3)")) 


RB200_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_R$RB200, 
levels=c(1, 
2), 
labels=c("Currently living in the household", 
"Temporarily absent")) 


RB200_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_R$RB200_F, 
levels=c(1, 
-1, 
-2), 
labels=c("Filled", 
"Missing", 
"Not applicable (RB110 not equal to 1, 2, 3 or 4)")) 


RB210_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_R$RB210, 
levels=c(1, 
2, 
3, 
4), 
labels=c("At work", 
"Unemployed", 
"In retirement or early retirement or has given up business", 
"Other inactive person")) 


RB210_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_R$RB210_F, 
levels=c(1, 
-1, 
-2), 
labels=c("Filled", 
"Missing", 
"Not applicable (RB110 not equal to 1, 2, 3 or 4)")) 


RB220_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_R$RB220_F, 
levels=c(1, 
-1, 
-2), 
labels=c("Filled", 
"Missing", 
"Not applicable ((father is not a household member) OR (RB110 not equal to 1, 2, 3 or 4))")) 


RB230_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_R$RB230_F, 
levels=c(1, 
-1, 
-2), 
labels=c("Filled", 
"Missing", 
"Not applicable ((mother is not a household member) OR (RB110 not equal to 1, 2, 3 or 4))")) 


RB240_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_R$RB240_F, 
levels=c(1, 
-1, 
-2), 
labels=c("Filled", 
"Missing", 
"Not applicable ((spouse/partner is not a household member) OR (RB110 not equal to 1, 2, 3 or 4))")) 


RB245_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_R$RB245, 
levels=c(1, 
2, 
3, 
4), 
labels=c("Current household member aged 16 and over", 
"Selected respondent", 
"Non-selected respondent", 
"Ineligible person")) 


RB245_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_R$RB245_F, 
levels=c(1, 
-2), 
labels=c("Filled", 
"Not applicable (RB110 not equal to 1, 2, 3 or 4))")) 


RB250_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_R$RB250, 
levels=c(11, 
12, 
13, 
14, 
21, 
22, 
23, 
31, 
32, 
33), 
labels=c("Information completed only from interview", 
"Information completed only from registers", 
"Information completed from both: interview and registers", 
"Information completed from full-record imputation", 
"Individual unable to respond (illness, incapacity, etc) and no proxy possible", 
"Failed to return self-completed questionnaire", 
"Refusal to co-operate", 
"Person temporarily away and no proxy possible", 
"No contact for other reasons", 
"Information not completed: reason unknown")) 


RB250_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_R$RB250_F, 
levels=c(1, 
-2), 
labels=c("Filled", 
"Not applicable (RB245 not equal to 1, 2 or 3)")) 


RB260_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_R$RB260, 
levels=c(1, 
2, 
3, 
4, 
5, 
6, 
7, 
8, 
9, 
10), 
labels=c("Face to face interview-PAPI", 
"Face to face interview-CAPI", 
"CATI, telephone interview", 
"Self-administered by respondent", 
"Computer assisted web interviewing-CAWI", 
"Face to face interview-PAPI with proxy", 
"Face to face interview-CAPI with proxy", 
"CATI, telephone interview with proxy", 
"Self-administered by respondent with proxy", 
"Computer assisted web interviewing-CAWI with proxy")) 


RB260_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_R$RB260_F, 
levels=c(1, 
-1, 
-2), 
labels=c("Filled", 
"Missing", 
"Not applicable (RB250 not equal to 11 or 13) or RB245 eq 3")) 


RB270_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_R$RB270_F, 
levels=c(1, 
-1, 
-2), 
labels=c("Filled", 
"Missing", 
"Not applicable (RB260 not equal to 6, 7, 8, 9, 10)")) 

save.image (file="DF_EUSILC_Long_A2019_PERSONAL_R.RData")
