/* #Declinazione di responsabilità. 
#I file rilasciati in formato testo sono provvisti anche dei programmi di importazione per STATA, SAS e R. 
#L'Istat non garantisce che le funzioni contenute nei suddetti programmi siano esenti da errore e non si assume alcuna responsabilità sull’output ottenuto dal loro utilizzo.       */
/*  I valori delle label nelle variabili categoriche sono commentati a causa della presenza di codici non esclusivamente numerici. Comunque sono completamente documentati.  */
clear all
infile  using  PGM_2019_PERSONAL_REGISTER_(R-FILE)_Longitudinal_EN_DELIMITED.dct, clear
/*
label define  rb020_cl1 AL   "Albania" AT   "Osterreich" BE   "Belgique/Belgie" BG   "Bulgaria" CH   "Switzerland" CY   "Cyprus" CZ   "Czech Republic" DE   "Deutschland" DK   "Denmark" EE   "Estonia" EL   "Ellada" ES   "Espana" FI   "Suomi" FR   "France" HR   "Croatia" HU   "Hungary" IE   "Ireland" IS   "Iceland" IT   "Italia" LT   "Lithuania" LU   "Luxembourg" LV   "Latvia" ME   "Montenegro" MK   "The Former Yugoslav Republic of Macedonia (FYROM)" MT   "Malta" NL   "Nederland" NO   "Norway" PL   "Poland" PT   "Portugal" RO   "Romania" RS   "Serbia" SE   "Sverige" SI   "Slovenia" SK   "Slovak Republic" TR   "Turkey" UK   "United Kingdom"  
label define  rb060_f_cl5 1   "Filled"  
label define  rb062_f_cl7 1   "Filled" -1   "Missing" -2   "Not applicable (only 1 year trajectory for the individual, i.e.individual in first wave)"  
label define  rb063_f_cl9 1   "Filled" -1   "Missing" -2   "Not applicable (less than three-year trajectory for the individual, i.e. individual in first or second wave)"  
label define  rb064_f_cl11 1   "Filled" -1   "Missing" -2   "Not applicable (less than four-year trajectory for the individual, i.e. individual in first, second or third wave)"  
label define  rb070_cl12 1   "January-March" 2   "April-June" 3   "July-September" 4   "October-December"  
label define  rb070_f_cl13 1   "Filled" -1   "Missing"  
label define  rb080_f_cl15 1   "Filled" -1   "Missing"  
label define  rb090_cl16 1   "Male" 2   "Female"  
label define  rb090_f_cl17 1   "Filled" -1   "Missing"  
label define  rb100_cl18 1   "Sample person" 2   "Co-resident"  
label define  rb100_f_cl19 1   "Filled" -1   "Missing"  
label define  rb110_cl20 1   "Was in this household in previous waves or current household member" 2   "Moved into this household from another sample household since previous wave" 3   "Moved into this household from outside sample since previous wave" 4   "Newly born into this household since last wave" 5   "Moved out since previous wave or last interview if not contacted in previous wave" 6   "Died" 7   "Lived in the household at least three months during the income reference period and was not recorded in the register of this household"  
label define  rb110_f_cl21 1   "Filled" -1   "Missing"  
label define  rb120_cl22 1   "To a private household in the country" 2   "To a collective household or institution in the country" 3   "Abroad" 4   "Lost"  
label define  rb120_f_cl23 1   "Filled" -2   "Not applicable (RB110 not equal to 5)"  
label define  rb140_cl24 1   "January-March" 2   "April-June" 3   "July-September" 4   "October-December"  
label define  rb140_f_cl25 1   "Filled" -1   "Missing" -2   "Not applicable (RB110 not equal to 5 or 6)"  
label define  rb150_f_cl27 1   "Filled" -1   "Missing" -2   "Not applicable (RB110 not equal to 5 or 6)"  
label define  rb160_f_cl29 1   "Filled" -1   "Missing" -2   "Not applicable (RB110 not equal to 5 or 6 or 7)"  
label define  rb170_cl30 1   "At work" 2   "Unemployed" 3   "In retirement or early retirement or has given up business" 4   "Other inactive person"  
label define  rb170_f_cl31 1   "Filled" -1   "Missing" -2   "Not applicable (RB110 not equal to 5 or 6 or 7)"  
label define  rb180_cl32 1   "January-March" 2   "April-June" 3   "July-September" 4   "October-December"  
label define  rb180_f_cl33 1   "Filled" -1   "Missing" -2   "Not applicable (RB110 not equal to 3)"  
label define  rb190_f_cl35 1   "Filled" -1   "Missing" -2   "Not applicable (RB110 not equal to 3)"  
label define  rb200_cl36 1   "Currently living in the household" 2   "Temporarily absent"  
label define  rb200_f_cl37 1   "Filled" -1   "Missing" -2   "Not applicable (RB110 not equal to 1, 2, 3 or 4)"  
label define  rb210_cl38 1   "At work" 2   "Unemployed" 3   "In retirement or early retirement or has given up business" 4   "Other inactive person"  
label define  rb210_f_cl39 1   "Filled" -1   "Missing" -2   "Not applicable (RB110 not equal to 1, 2, 3 or 4)"  
label define  rb220_f_cl41 1   "Filled" -1   "Missing" -2   "Not applicable ((father is not a household member) OR (RB110 not equal to 1, 2, 3 or 4))"  
label define  rb230_f_cl43 1   "Filled" -1   "Missing" -2   "Not applicable ((mother is not a household member) OR (RB110 not equal to 1, 2, 3 or 4))"  
label define  rb240_f_cl45 1   "Filled" -1   "Missing" -2   "Not applicable ((spouse/partner is not a household member) OR (RB110 not equal to 1, 2, 3 or 4))"  
label define  rb245_cl46 1   "Current household member aged 16 and over" 2   "Selected respondent" 3   "Non-selected respondent" 4   "Ineligible person"  
label define  rb245_f_cl47 1   "Filled" -2   "Not applicable (RB110 not equal to 1, 2, 3 or 4))"  
label define  rb250_cl48 11   "Information completed only from interview" 12   "Information completed only from registers" 13   "Information completed from both: interview and registers" 14   "Information completed from full-record imputation" 21   "Individual unable to respond (illness, incapacity, etc) and no proxy possible" 22   "Failed to return self-completed questionnaire" 23   "Refusal to co-operate" 31   "Person temporarily away and no proxy possible" 32   "No contact for other reasons" 33   "Information not completed: reason unknown"  
label define  rb250_f_cl49 1   "Filled" -2   "Not applicable (RB245 not equal to 1, 2 or 3)"  
label define  rb260_cl50 1   "Face to face interview-PAPI" 2   "Face to face interview-CAPI" 3   "CATI, telephone interview" 4   "Self-administered by respondent" 5   "Computer assisted web interviewing-CAWI" 6   "Face to face interview-PAPI with proxy" 7   "Face to face interview-CAPI with proxy" 8   "CATI, telephone interview with proxy" 9   "Self-administered by respondent with proxy" 10   "Computer assisted web interviewing-CAWI with proxy"  
label define  rb260_f_cl51 1   "Filled" -1   "Missing" -2   "Not applicable (RB250 not equal to 11 or 13) or RB245 eq 3"  
label define  rb270_f_cl53 1   "Filled" -1   "Missing" -2   "Not applicable (RB260 not equal to 6, 7, 8, 9, 10)"  
label values  rb020 rb020_cl1
label values  rb060_f rb060_f_cl5
label values  rb062_f rb062_f_cl7
label values  rb063_f rb063_f_cl9
label values  rb064_f rb064_f_cl11
label values  rb070 rb070_cl12
label values  rb070_f rb070_f_cl13
label values  rb080_f rb080_f_cl15
label values  rb090 rb090_cl16
label values  rb090_f rb090_f_cl17
label values  rb100 rb100_cl18
label values  rb100_f rb100_f_cl19
label values  rb110 rb110_cl20
label values  rb110_f rb110_f_cl21
label values  rb120 rb120_cl22
label values  rb120_f rb120_f_cl23
label values  rb140 rb140_cl24
label values  rb140_f rb140_f_cl25
label values  rb150_f rb150_f_cl27
label values  rb160_f rb160_f_cl29
label values  rb170 rb170_cl30
label values  rb170_f rb170_f_cl31
label values  rb180 rb180_cl32
label values  rb180_f rb180_f_cl33
label values  rb190_f rb190_f_cl35
label values  rb200 rb200_cl36
label values  rb200_f rb200_f_cl37
label values  rb210 rb210_cl38
label values  rb210_f rb210_f_cl39
label values  rb220_f rb220_f_cl41
label values  rb230_f rb230_f_cl43
label values  rb240_f rb240_f_cl45
label values  rb245 rb245_cl46
label values  rb245_f rb245_f_cl47
label values  rb250 rb250_cl48
label values  rb250_f rb250_f_cl49
label values  rb260 rb260_cl50
label values  rb260_f rb260_f_cl51
label values  rb270_f rb270_f_cl53
*/
save  EUSILC_Long_A2019_PERSONAL_REGI.dta, replace
