/* Declinazione di responsabilità. 
I file rilasciati in formato testo sono provvisti anche dei programmi di importazione per STATA, SAS e R. 
L'Istat non garantisce che le funzioni contenute nei suddetti programmi siano esenti da errore e non si assume alcuna responsabilità sull’output ottenuto dal loro utilizzo.                 */
%macro grabpath;
%qsubstr(%sysget(SAS_EXECFILEPATH),1,%length(%sysget(SAS_EXECFILEPATH))-%length(%sysget(SAS_EXECFILEname)))
%mend grabpath;
%let path = %grabpath;
%let nomeFile =ISTAT_MFR_EUSILC_Long_Microdata_2019_PERSONAL_DATA_(P-FILE)_Longitudinal_FILE_STRUCTURE_EXAMPLE.txt;
LIBNAME ISTAT "&path";
DATA ISTAT.EUSILC_Long_A2019_PERSONAL_DATA;

INFILE "&path&nomeFile" DLM='09'x  LRECL=32767 TRUNCOVER FIRSTOBS=2 IGNOREDOSEOF;
INPUT 
PB010 :5.   /*  YEAR OF THE SURVEY */
PB020 : $3.   /*  COUNTRY */
PB030 :12.   /*  PERSONAL ID */
PB050 :16.   /*  PERSONAL BASE WEIGHT */
PB050_F :2.   /*  FLAG OF PB050 */
PB080 :16.   /*  PERSONAL BASE WEIGHT FOR SELECTED RESPONDENT */
PB080_F :3.   /*  FLAG OF PB080 */
PB100 :2.   /*  MONTH OF THE PERSONAL INTERVIEW */
PB100_F :2.   /*  FLAG OF PB100 */
PB110 :5.   /*  YEAR OF THE PERSONAL INTERVIEW */
PB110_F :2.   /*  FLAG OF PB110 */
PB120 :3.   /*  MINUTES TO COMPLETE THE PERSONAL QUESTIONNAIRE */
PB120_F :2.   /*  FLAG OF PB120 */
PB130 :2.   /*  MONTH OF BIRTH */
PB130_F :2.   /*  FLAG OF PB130 */
PB140 :5.   /*  YEAR OF BIRTH */
PB140_F :2.   /*  FLAG OF PB140 */
PB150 :2.   /*  SEX */
PB150_F :2.   /*  FLAG OF PB150 */
PB160 :12.   /*  FATHER ID */
PB160_F :2.   /*  FLAG OF PB160 */
PB170 :12.   /*  MOTHER ID */
PB170_F :2.   /*  FLAG OF PB170 */
PB180 :12.   /*  SPOUSE/PARTNER ID */
PB180_F :2.   /*  FLAG OF PB180 */
PB190 :2.   /*  MARITAL STATUS */
PB190_F :2.   /*  FLAG OF PB190 */
PB200 :2.   /*  CONSENSUAL UNION */
PB200_F :2.   /*  FLAG OF PB200 */
PE040 :4.   /*  HIGHEST ISCED LEVEL ATTAINED */
PE040_F :2.   /*  FLAG OF PE040 */
PH010 :2.   /*  GENERAL HEALTH */
PH010_F :2.   /*  FLAG OF PH010 */
PH020 :2.   /*  SUFFER FROM ANY CHRONIC (LONG-STANDING) ILLNESS OR CONDITION */
PH020_F :2.   /*  FLAG OF PH020 */
PH030 :2.   /*  LIMITATION IN ACTIVITIES BECAUSE OF HEALTH PROBLEMS */
PH030_F :2.   /*  FLAG OF PH030 */
PL020 :2.   /*  ACTIVELY LOOKING FOR A JOB */
PL020_F :2.   /*  FLAG OF PL020 */
PL025 :2.   /*  AVAILABLE FOR WORK */
PL025_F :2.   /*  FLAG OF PL025 */
PL031 :3.   /*  SELF-DEFINED CURRENT ECONOMIC STATUS */
PL031_F :2.   /*  FLAG OF PL031 */
PL040 :2.   /*  STATUS IN EMPLOYMENT */
PL040_F :2.   /*  FLAG OF PL040 */
PL051 :3.   /*  OCCUPATION (ISCO-08 (COM)) */
PL051_F :2.   /*  FLAG OF PL051 */
PL060 :3.   /*  NUMBER OF HOURS USUALLY WORKED PER WEEK IN MAIN JOB */
PL060_F :2.   /*  FLAG OF PL060 */
PL140 :2.   /*  TYPE OF CONTRACT */
PL140_F :2.   /*  FLAG OF PL140 */
PL160 :2.   /*  CHANGE OF JOB SINCE LAST YEAR */
PL160_F :2.   /*  FLAG OF PL160 */
PL170 :2.   /*  REASON TO CHANGE */
PL170_F :2.   /*  FLAG OF PL170 */
PL180 :3.   /*  MOST RECENT CHANGE IN THE INDIVIDUALS ACTIVITY STATUS */
PL180_F :2.   /*  FLAG OF PL180 */
PL190 :3.   /*  WHEN BEGAN FIRST REGULAR JOB */
PL190_F :2.   /*  FLAG OF PL190 */
PL200 :3.   /*  NUMBER OF YEARS SPENT IN PAID WORK */
PL200_F :2.   /*  FLAG OF PL200 */
PL211A :3.   /*  MAIN ACTIVITY IN JANUARY */
PL211A_F :2.   /*  FLAG OF PL211A */
PL211B :3.   /*  MAIN ACTIVITY IN FEBRUARY */
PL211B_F :2.   /*  FLAG OF PL211B */
PL211C :3.   /*  MAIN ACTIVITY IN MARCH */
PL211C_F :2.   /*  FLAG OF PL211C */
PL211D :3.   /*  MAIN ACTIVITY IN APRIL */
PL211D_F :2.   /*  FLAG OF PL211D */
PL211E :3.   /*  MAIN ACTIVITY IN MAY */
PL211E_F :2.   /*  FLAG OF PL211E */
PL211F :3.   /*  MAIN ACTIVITY IN JUNE */
PL211F_F :2.   /*  FLAG OF PL211F */
PL211G :3.   /*  MAIN ACTIVITY IN JULY */
PL211G_F :2.   /*  FLAG OF PL211G */
PL211H :3.   /*  MAIN ACTIVITY IN AUGUST */
PL211H_F :2.   /*  FLAG OF PL211H */
PL211I :3.   /*  MAIN ACTIVITY IN SEPTEMBER */
PL211I_F :2.   /*  FLAG OF PL211I */
PL211J :3.   /*  MAIN ACTIVITY IN OCTOBER */
PL211J_F :2.   /*  FLAG OF PL211J */
PL211K :3.   /*  MAIN ACTIVITY IN NOVEMBER */
PL211K_F :2.   /*  FLAG OF PL211K */
PL211L :3.   /*  MAIN ACTIVITY IN DECEMBER */
PL211L_F :2.   /*  FLAG OF PL211L */
PY010N :7.   /*  EMPLOYEE CASH OR NEAR CASH INCOME */
PY010N_F :2.   /*  FLAG OF PY010N */
PY010N_I :16.   /*  IMPUTATION FACTOR OF PY010N */
PY020N :7.   /*  NON-CASH EMPLOYEE INCOME */
PY020N_F :2.   /*  FLAG OF PY020N */
PY020N_I :16.   /*  IMPUTATION FACTOR OF PY020N */
PY021N :7.   /*  COMPANY CAR */
PY021N_F :2.   /*  FLAG OF PY021N */
PY021N_I :16.   /*  IMPUTATION FACTOR OF PY021N */
PY035N :7.   /*  CONTRIBUTIONS TO INDIVIDUAL PRIVATE PENSION PLANS */
PY035N_F :2.   /*  FLAG OF PY035N */
PY035N_I :16.   /*  IMPUTATION FACTOR OF PY035N */
PY050N :7.   /*  CASH PROFITS OR LOSSES FROM SELF-EMPLOYMENT */
PY050N_F :2.   /*  FLAG OF PY050N */
PY050N_I :16.   /*  IMPUTATION FACTOR OF PY050N */
PY080N :7.   /*  PENSION FROM INDIVIDUAL PRIVATE PLANS */
PY080N_F :2.   /*  FLAG OF PY080N */
PY080N_I :16.   /*  IMPUTATION FACTOR OF PY080N */
PY090N :7.   /*  UNEMPLOYMENT BENEFITS */
PY090N_F :2.   /*  FLAG OF PY090N */
PY090N_I :16.   /*  IMPUTATION FACTOR OF PY090N */
PY100N :7.   /*  OLD-AGE BENEFITS */
PY100N_F :2.   /*  FLAG OF PY100N */
PY100N_I :16.   /*  IMPUTATION FACTOR OF PY100N */
PY110N :7.   /*  SURVIVOR' BENEFITS */
PY110N_F :2.   /*  FLAG OF PY110N */
PY110N_I :16.   /*  IMPUTATION FACTOR OF PY110N */
PY120N :7.   /*  SICKNESS BENEFITS */
PY120N_F :2.   /*  FLAG OF PY120N */
PY120N_I :16.   /*  IMPUTATION FACTOR OF PY120N */
PY130N :7.   /*  DISABILITY BENEFITS */
PY130N_F :2.   /*  FLAG OF PY130N */
PY130N_I :16.   /*  IMPUTATION FACTOR OF PY130N */
PY140N :7.   /*  EDUCATION-RELATED ALLOWANCES */
PY140N_F :2.   /*  FLAG OF PY140N */
PY140N_I :16.   /*  IMPUTATION FACTOR OF PY140N */
PY010G :7.   /*  EMPLOYEE CASH OR NEAR CASH INCOME */
PY010G_F :2.   /*  FLAG OF PY010G */
PY010G_I :16.   /*  IMPUTATION FACTOR OF PY010G */
PY020G :7.   /*  NON-CASH EMPLOYEE INCOME */
PY020G_F :2.   /*  FLAG OF PY020G */
PY020G_I :16.   /*  IMPUTATION FACTOR OF PY020G */
PY021G :7.   /*  COMPANY CAR */
PY021G_F :2.   /*  FLAG OF PY021G */
PY021G_I :16.   /*  IMPUTATION FACTOR OF PY021G */
PY030G :7.   /*  EMPLOYER'S SOCIAL INSURANCE CONTRIBUTION */
PY030G_F :2.   /*  FLAG OF PY030G */
PY030G_I :16.   /*  IMPUTATION FACTOR OF PY030G */
PY031G :7.   /*  OPTIONAL EMPLOYER'S SOCIAL INSURANCE CONTRIBUTIONS */
PY031G_F :2.   /*  FLAG OF PY031G */
PY031G_I :16.   /*  IMPUTATION FACTOR OF PY031G */
PY035G :7.   /*  CONTRIBUTIONS TO INDIVIDUAL PRIVATE PENSION PLANS */
PY035G_F :2.   /*  FLAG OF PY035G */
PY035G_I :16.   /*  IMPUTATION FACTOR OF PY035G */
PY050G :7.   /*  CASH PROFITS OR LOSSES FROM SELF-EMPLOYMENT */
PY050G_F :2.   /*  FLAG OF PY050G */
PY050G_I :16.   /*  IMPUTATION FACTOR OF PY050G */
PY080G :7.   /*  PENSION FROM INDIVIDUAL PRIVATE PLANS */
PY080G_F :2.   /*  FLAG OF PY080G */
PY080G_I :16.   /*  IMPUTATION FACTOR OF PY080G */
PY090G :7.   /*  UNEMPLOYMENT BENEFITS */
PY090G_F :2.   /*  FLAG OF PY090G */
PY090G_I :16.   /*  IMPUTATION FACTOR OF PY090G */
PY091G :7.   /*  UNEMPLOYMENT BENEFITS (CONTRIBUTORY AND MEANS-TESTED) */
PY091G_F :2.   /*  FLAG OF PY091G */
PY092G :7.   /*  UNEMPLOYMENT BENEFITS (CONTRIBUTORY AND NON MEANS-TESTED) */
PY092G_F :2.   /*  FLAG OF PY092G */
PY093G :7.   /*  UNEMPLOYMENT BENEFITS (NON-CONTRIBUTORY AND MEANS-TESTED) */
PY093G_F :2.   /*  FLAG OF PY093G */
PY094G :7.   /*  UNEMPLOYMENT BENEFITS (NON-CONTRIBUTORY AND NON MEANS-TESTED) */
PY094G_F :2.   /*  FLAG OF PY094G */
PY100G :7.   /*  OLD-AGE BENEFITS */
PY100G_F :2.   /*  FLAG OF PY100G */
PY100G_I :16.   /*  IMPUTATION FACTOR OF PY100G */
PY101G :7.   /*  OLD-AGE BENEFITS (CONTRIBUTORY AND MEANS-TESTED) */
PY101G_F :2.   /*  FLAG OF PY101G */
PY102G :7.   /*  OLD-AGE BENEFITS (CONTRIBUTORY AND NON MEANS-TESTED) */
PY102G_F :2.   /*  FLAG OF PY102G */
PY103G :7.   /*  OLD-AGE BENEFITS (NON-CONTRIBUTORY AND MEANS-TESTED) */
PY103G_F :2.   /*  FLAG OF PY103G */
PY104G :7.   /*  OLD-AGE BENEFITS (NON-CONTRIBUTORY AND NON MEANS-TESTED) */
PY104G_F :2.   /*  FLAG OF PY104G */
PY110G :7.   /*  SURVIVOR' BENEFITS */
PY110G_F :2.   /*  FLAG OF PY110G */
PY110G_I :16.   /*  IMPUTATION FACTOR OF PY110G */
PY111G :7.   /*  SURVIVOR BENEFITS (CONTRIBUTORY AND MEANS-TESTED) */
PY111G_F :2.   /*  FLAG OF PY111G */
PY112G :7.   /*  SURVIVOR BENEFITS (CONTRIBUTORY AND NON MEANS-TESTED) */
PY112G_F :2.   /*  FLAG OF PY112G */
PY113G :7.   /*  SURVIVOR BENEFITS (NON-CONTRIBUTORY AND MEANS-TESTED) */
PY113G_F :2.   /*  FLAG OF PY113G */
PY114G :7.   /*  SURVIVOR BENEFITS (NON-CONTRIBUTORY AND NON MEANS-TESTED) */
PY114G_F :2.   /*  FLAG OF PY114G */
PY120G :7.   /*  SICKNESS BENEFITS */
PY120G_F :2.   /*  FLAG OF PY120G */
PY120G_I :16.   /*  IMPUTATION FACTOR OF PY120G */
PY121G :7.   /*  SICKNESS BENEFITS (CONTRIBUTORY AND MEANS-TESTED) */
PY121G_F :2.   /*  FLAG OF PY121G */
PY122G :7.   /*  SICKNESS BENEFITS (CONTRIBUTORY AND NON MEANS-TESTED) */
PY122G_F :2.   /*  FLAG OF PY122G */
PY123G :7.   /*  SICKNESS BENEFITS (NON-CONTRIBUTORY AND MEANS-TESTED) */
PY123G_F :2.   /*  FLAG OF PY123G */
PY124G :7.   /*  SICKNESS BENEFITS (NON-CONTRIBUTORY AND NON MEANS-TESTED) */
PY124G_F :2.   /*  FLAG OF PY124G */
PY130G :7.   /*  DISABILITY BENEFITS */
PY130G_F :2.   /*  FLAG OF PY130G */
PY130G_I :16.   /*  IMPUTATION FACTOR OF PY130G */
PY131G :7.   /*  DISABILITY BENEFITS (CONTRIBUTORY AND MEANS-TESTED) */
PY131G_F :2.   /*  FLAG OF PY131G */
PY132G :7.   /*  DISABILITY BENEFITS (CONTRIBUTORY AND NON MEANS-TESTED) */
PY132G_F :2.   /*  FLAG OF PY132G */
PY133G :7.   /*  DISABILITY BENEFITS (NON-CONTRIBUTORY AND MEANS-TESTED) */
PY133G_F :2.   /*  FLAG OF PY133G */
PY134G :7.   /*  DISABILITY BENEFITS (NON-CONTRIBUTORY AND NON MEANS-TESTED) */
PY134G_F :2.   /*  FLAG OF PY134G */
PY140G :7.   /*  EDUCATION-RELATED ALLOWANCES */
PY140G_F :2.   /*  FLAG OF PY140G */
PY140G_I :16.   /*  IMPUTATION FACTOR OF PY140G */
PY141G :7.   /*  EDUCATION-RELATED ALLOWANCES (CONTRIBUTORY AND MEANS-TESTED) */
PY141G_F :2.   /*  FLAG OF PY141G */
PY142G :7.   /*  EDUCATION-RELATED ALLOWANCES (CONTRIBUTORY AND NON MEANS-TESTED) */
PY142G_F :2.   /*  FLAG OF PY142G */
PY143G :7.   /*  EDUCATION-RELATED ALLOWANCES (NON-CONTRIBUTORY AND MEANS-TESTED) */
PY143G_F :2.   /*  FLAG OF PY143G */
PY144G :7.   /*  EDUCATION-RELATED ALLOWANCES (NON-CONTRIBUTORY AND NON MEANS-TESTED) */
PY144G_F :2.   /*  FLAG OF PY144G */
PD020 :2.   /*  REPLACE WORN-OUT CLOTHES BY SOME NEW (NOT SECOND-HAND) ONES */
PD020_F :2.   /*  FLAG OF PD020 */
PD030 :2.   /*  TWO PAIRS OF PROPERLY FITTING SHOES (INCLUDING A PAIR OF ALL-WEATHER SHOES) */
PD030_F :2.   /*  FLAG OF PD030 */
PD050 :2.   /*  GET-TOGETHER WITH FRIENDS/FAMILY (RELATIVES) FOR A DRINK/MEAL AT LEAST ONCE A MONTH */
PD050_F :2.   /*  FLAG OF PD050 */
PD060 :2.   /*  REGULARLY PARTICIPATE IN A LEISURE ACTIVITY */
PD060_F :2.   /*  FLAG OF PD060 */
PD070 :2.   /*  SPEND A SMALL AMOUNT OF MONEY EACH WEEK ON YOURSELF */
PD070_F :2.   /*  FLAG OF PD070 */
PD080 :2.   /*  INTERNET CONNECTION FOR PERSONAL USE AT HOME */
PD080_F :2.   /*  FLAG OF PD080 */
PX010 :2.   /*  CHANGE RATE */
PX020 :3.   /*  AGE AT THE END OF THE INCOME REFERENCE PERIOD */
PX030 :10.   /*  HOUSEHOLD IDENTIFICATION NUMBER */
PX040 :2.   /*  SELECTED RESPONDENT STATUS */
;
LABEL 
PB010 = "YEAR OF THE SURVEY"
PB020 = "COUNTRY"
PB030 = "PERSONAL ID"
PB050 = "PERSONAL BASE WEIGHT"
PB050_F = "FLAG OF PB050"
PB080 = "PERSONAL BASE WEIGHT FOR SELECTED RESPONDENT"
PB080_F = "FLAG OF PB080"
PB100 = "MONTH OF THE PERSONAL INTERVIEW"
PB100_F = "FLAG OF PB100"
PB110 = "YEAR OF THE PERSONAL INTERVIEW"
PB110_F = "FLAG OF PB110"
PB120 = "MINUTES TO COMPLETE THE PERSONAL QUESTIONNAIRE"
PB120_F = "FLAG OF PB120"
PB130 = "MONTH OF BIRTH"
PB130_F = "FLAG OF PB130"
PB140 = "YEAR OF BIRTH"
PB140_F = "FLAG OF PB140"
PB150 = "SEX"
PB150_F = "FLAG OF PB150"
PB160 = "FATHER ID"
PB160_F = "FLAG OF PB160"
PB170 = "MOTHER ID"
PB170_F = "FLAG OF PB170"
PB180 = "SPOUSE/PARTNER ID"
PB180_F = "FLAG OF PB180"
PB190 = "MARITAL STATUS"
PB190_F = "FLAG OF PB190"
PB200 = "CONSENSUAL UNION"
PB200_F = "FLAG OF PB200"
PE040 = "HIGHEST ISCED LEVEL ATTAINED"
PE040_F = "FLAG OF PE040"
PH010 = "GENERAL HEALTH"
PH010_F = "FLAG OF PH010"
PH020 = "SUFFER FROM ANY CHRONIC (LONG-STANDING) ILLNESS OR CONDITION"
PH020_F = "FLAG OF PH020"
PH030 = "LIMITATION IN ACTIVITIES BECAUSE OF HEALTH PROBLEMS"
PH030_F = "FLAG OF PH030"
PL020 = "ACTIVELY LOOKING FOR A JOB"
PL020_F = "FLAG OF PL020"
PL025 = "AVAILABLE FOR WORK"
PL025_F = "FLAG OF PL025"
PL031 = "SELF-DEFINED CURRENT ECONOMIC STATUS"
PL031_F = "FLAG OF PL031"
PL040 = "STATUS IN EMPLOYMENT"
PL040_F = "FLAG OF PL040"
PL051 = "OCCUPATION (ISCO-08 (COM))"
PL051_F = "FLAG OF PL051"
PL060 = "NUMBER OF HOURS USUALLY WORKED PER WEEK IN MAIN JOB"
PL060_F = "FLAG OF PL060"
PL140 = "TYPE OF CONTRACT"
PL140_F = "FLAG OF PL140"
PL160 = "CHANGE OF JOB SINCE LAST YEAR"
PL160_F = "FLAG OF PL160"
PL170 = "REASON TO CHANGE"
PL170_F = "FLAG OF PL170"
PL180 = "MOST RECENT CHANGE IN THE INDIVIDUALS ACTIVITY STATUS"
PL180_F = "FLAG OF PL180"
PL190 = "WHEN BEGAN FIRST REGULAR JOB"
PL190_F = "FLAG OF PL190"
PL200 = "NUMBER OF YEARS SPENT IN PAID WORK"
PL200_F = "FLAG OF PL200"
PL211A = "MAIN ACTIVITY IN JANUARY"
PL211A_F = "FLAG OF PL211A"
PL211B = "MAIN ACTIVITY IN FEBRUARY"
PL211B_F = "FLAG OF PL211B"
PL211C = "MAIN ACTIVITY IN MARCH"
PL211C_F = "FLAG OF PL211C"
PL211D = "MAIN ACTIVITY IN APRIL"
PL211D_F = "FLAG OF PL211D"
PL211E = "MAIN ACTIVITY IN MAY"
PL211E_F = "FLAG OF PL211E"
PL211F = "MAIN ACTIVITY IN JUNE"
PL211F_F = "FLAG OF PL211F"
PL211G = "MAIN ACTIVITY IN JULY"
PL211G_F = "FLAG OF PL211G"
PL211H = "MAIN ACTIVITY IN AUGUST"
PL211H_F = "FLAG OF PL211H"
PL211I = "MAIN ACTIVITY IN SEPTEMBER"
PL211I_F = "FLAG OF PL211I"
PL211J = "MAIN ACTIVITY IN OCTOBER"
PL211J_F = "FLAG OF PL211J"
PL211K = "MAIN ACTIVITY IN NOVEMBER"
PL211K_F = "FLAG OF PL211K"
PL211L = "MAIN ACTIVITY IN DECEMBER"
PL211L_F = "FLAG OF PL211L"
PY010N = "EMPLOYEE CASH OR NEAR CASH INCOME"
PY010N_F = "FLAG OF PY010N"
PY010N_I = "IMPUTATION FACTOR OF PY010N"
PY020N = "NON-CASH EMPLOYEE INCOME"
PY020N_F = "FLAG OF PY020N"
PY020N_I = "IMPUTATION FACTOR OF PY020N"
PY021N = "COMPANY CAR"
PY021N_F = "FLAG OF PY021N"
PY021N_I = "IMPUTATION FACTOR OF PY021N"
PY035N = "CONTRIBUTIONS TO INDIVIDUAL PRIVATE PENSION PLANS"
PY035N_F = "FLAG OF PY035N"
PY035N_I = "IMPUTATION FACTOR OF PY035N"
PY050N = "CASH PROFITS OR LOSSES FROM SELF-EMPLOYMENT"
PY050N_F = "FLAG OF PY050N"
PY050N_I = "IMPUTATION FACTOR OF PY050N"
PY080N = "PENSION FROM INDIVIDUAL PRIVATE PLANS"
PY080N_F = "FLAG OF PY080N"
PY080N_I = "IMPUTATION FACTOR OF PY080N"
PY090N = "UNEMPLOYMENT BENEFITS"
PY090N_F = "FLAG OF PY090N"
PY090N_I = "IMPUTATION FACTOR OF PY090N"
PY100N = "OLD-AGE BENEFITS"
PY100N_F = "FLAG OF PY100N"
PY100N_I = "IMPUTATION FACTOR OF PY100N"
PY110N = "SURVIVOR' BENEFITS"
PY110N_F = "FLAG OF PY110N"
PY110N_I = "IMPUTATION FACTOR OF PY110N"
PY120N = "SICKNESS BENEFITS"
PY120N_F = "FLAG OF PY120N"
PY120N_I = "IMPUTATION FACTOR OF PY120N"
PY130N = "DISABILITY BENEFITS"
PY130N_F = "FLAG OF PY130N"
PY130N_I = "IMPUTATION FACTOR OF PY130N"
PY140N = "EDUCATION-RELATED ALLOWANCES"
PY140N_F = "FLAG OF PY140N"
PY140N_I = "IMPUTATION FACTOR OF PY140N"
PY010G = "EMPLOYEE CASH OR NEAR CASH INCOME"
PY010G_F = "FLAG OF PY010G"
PY010G_I = "IMPUTATION FACTOR OF PY010G"
PY020G = "NON-CASH EMPLOYEE INCOME"
PY020G_F = "FLAG OF PY020G"
PY020G_I = "IMPUTATION FACTOR OF PY020G"
PY021G = "COMPANY CAR"
PY021G_F = "FLAG OF PY021G"
PY021G_I = "IMPUTATION FACTOR OF PY021G"
PY030G = "EMPLOYER'S SOCIAL INSURANCE CONTRIBUTION"
PY030G_F = "FLAG OF PY030G"
PY030G_I = "IMPUTATION FACTOR OF PY030G"
PY031G = "OPTIONAL EMPLOYER'S SOCIAL INSURANCE CONTRIBUTIONS"
PY031G_F = "FLAG OF PY031G"
PY031G_I = "IMPUTATION FACTOR OF PY031G"
PY035G = "CONTRIBUTIONS TO INDIVIDUAL PRIVATE PENSION PLANS"
PY035G_F = "FLAG OF PY035G"
PY035G_I = "IMPUTATION FACTOR OF PY035G"
PY050G = "CASH PROFITS OR LOSSES FROM SELF-EMPLOYMENT"
PY050G_F = "FLAG OF PY050G"
PY050G_I = "IMPUTATION FACTOR OF PY050G"
PY080G = "PENSION FROM INDIVIDUAL PRIVATE PLANS"
PY080G_F = "FLAG OF PY080G"
PY080G_I = "IMPUTATION FACTOR OF PY080G"
PY090G = "UNEMPLOYMENT BENEFITS"
PY090G_F = "FLAG OF PY090G"
PY090G_I = "IMPUTATION FACTOR OF PY090G"
PY091G = "UNEMPLOYMENT BENEFITS (CONTRIBUTORY AND MEANS-TESTED)"
PY091G_F = "FLAG OF PY091G"
PY092G = "UNEMPLOYMENT BENEFITS (CONTRIBUTORY AND NON MEANS-TESTED)"
PY092G_F = "FLAG OF PY092G"
PY093G = "UNEMPLOYMENT BENEFITS (NON-CONTRIBUTORY AND MEANS-TESTED)"
PY093G_F = "FLAG OF PY093G"
PY094G = "UNEMPLOYMENT BENEFITS (NON-CONTRIBUTORY AND NON MEANS-TESTED)"
PY094G_F = "FLAG OF PY094G"
PY100G = "OLD-AGE BENEFITS"
PY100G_F = "FLAG OF PY100G"
PY100G_I = "IMPUTATION FACTOR OF PY100G"
PY101G = "OLD-AGE BENEFITS (CONTRIBUTORY AND MEANS-TESTED)"
PY101G_F = "FLAG OF PY101G"
PY102G = "OLD-AGE BENEFITS (CONTRIBUTORY AND NON MEANS-TESTED)"
PY102G_F = "FLAG OF PY102G"
PY103G = "OLD-AGE BENEFITS (NON-CONTRIBUTORY AND MEANS-TESTED)"
PY103G_F = "FLAG OF PY103G"
PY104G = "OLD-AGE BENEFITS (NON-CONTRIBUTORY AND NON MEANS-TESTED)"
PY104G_F = "FLAG OF PY104G"
PY110G = "SURVIVOR' BENEFITS"
PY110G_F = "FLAG OF PY110G"
PY110G_I = "IMPUTATION FACTOR OF PY110G"
PY111G = "SURVIVOR BENEFITS (CONTRIBUTORY AND MEANS-TESTED)"
PY111G_F = "FLAG OF PY111G"
PY112G = "SURVIVOR BENEFITS (CONTRIBUTORY AND NON MEANS-TESTED)"
PY112G_F = "FLAG OF PY112G"
PY113G = "SURVIVOR BENEFITS (NON-CONTRIBUTORY AND MEANS-TESTED)"
PY113G_F = "FLAG OF PY113G"
PY114G = "SURVIVOR BENEFITS (NON-CONTRIBUTORY AND NON MEANS-TESTED)"
PY114G_F = "FLAG OF PY114G"
PY120G = "SICKNESS BENEFITS"
PY120G_F = "FLAG OF PY120G"
PY120G_I = "IMPUTATION FACTOR OF PY120G"
PY121G = "SICKNESS BENEFITS (CONTRIBUTORY AND MEANS-TESTED)"
PY121G_F = "FLAG OF PY121G"
PY122G = "SICKNESS BENEFITS (CONTRIBUTORY AND NON MEANS-TESTED)"
PY122G_F = "FLAG OF PY122G"
PY123G = "SICKNESS BENEFITS (NON-CONTRIBUTORY AND MEANS-TESTED)"
PY123G_F = "FLAG OF PY123G"
PY124G = "SICKNESS BENEFITS (NON-CONTRIBUTORY AND NON MEANS-TESTED)"
PY124G_F = "FLAG OF PY124G"
PY130G = "DISABILITY BENEFITS"
PY130G_F = "FLAG OF PY130G"
PY130G_I = "IMPUTATION FACTOR OF PY130G"
PY131G = "DISABILITY BENEFITS (CONTRIBUTORY AND MEANS-TESTED)"
PY131G_F = "FLAG OF PY131G"
PY132G = "DISABILITY BENEFITS (CONTRIBUTORY AND NON MEANS-TESTED)"
PY132G_F = "FLAG OF PY132G"
PY133G = "DISABILITY BENEFITS (NON-CONTRIBUTORY AND MEANS-TESTED)"
PY133G_F = "FLAG OF PY133G"
PY134G = "DISABILITY BENEFITS (NON-CONTRIBUTORY AND NON MEANS-TESTED)"
PY134G_F = "FLAG OF PY134G"
PY140G = "EDUCATION-RELATED ALLOWANCES"
PY140G_F = "FLAG OF PY140G"
PY140G_I = "IMPUTATION FACTOR OF PY140G"
PY141G = "EDUCATION-RELATED ALLOWANCES (CONTRIBUTORY AND MEANS-TESTED)"
PY141G_F = "FLAG OF PY141G"
PY142G = "EDUCATION-RELATED ALLOWANCES (CONTRIBUTORY AND NON MEANS-TESTED)"
PY142G_F = "FLAG OF PY142G"
PY143G = "EDUCATION-RELATED ALLOWANCES (NON-CONTRIBUTORY AND MEANS-TESTED)"
PY143G_F = "FLAG OF PY143G"
PY144G = "EDUCATION-RELATED ALLOWANCES (NON-CONTRIBUTORY AND NON MEANS-TESTED)"
PY144G_F = "FLAG OF PY144G"
PD020 = "REPLACE WORN-OUT CLOTHES BY SOME NEW (NOT SECOND-HAND) ONES"
PD020_F = "FLAG OF PD020"
PD030 = "TWO PAIRS OF PROPERLY FITTING SHOES (INCLUDING A PAIR OF ALL-WEATHER SHOES)"
PD030_F = "FLAG OF PD030"
PD050 = "GET-TOGETHER WITH FRIENDS/FAMILY (RELATIVES) FOR A DRINK/MEAL AT LEAST ONCE A MONTH"
PD050_F = "FLAG OF PD050"
PD060 = "REGULARLY PARTICIPATE IN A LEISURE ACTIVITY"
PD060_F = "FLAG OF PD060"
PD070 = "SPEND A SMALL AMOUNT OF MONEY EACH WEEK ON YOURSELF"
PD070_F = "FLAG OF PD070"
PD080 = "INTERNET CONNECTION FOR PERSONAL USE AT HOME"
PD080_F = "FLAG OF PD080"
PX010 = "CHANGE RATE"
PX020 = "AGE AT THE END OF THE INCOME REFERENCE PERIOD"
PX030 = "HOUSEHOLD IDENTIFICATION NUMBER"
PX040 = "SELECTED RESPONDENT STATUS"
;
RUN;
PROC FORMAT;
VALUE $PB01F /* PB020 */
"AL" = "Albania"
"AT" = "Osterreich"
"BE" = "Belgique/Belgie"
"BG" = "Bulgaria"
"CH" = "Switzerland"
"CY" = "Cyprus"
"CZ" = "Czech Republic"
"DE" = "Deutschland"
"DK" = "Denmark"
"EE" = "Estonia"
"EL" = "Ellada"
"ES" = "Espana"
"FI" = "Suomi"
"FR" = "France"
"HR" = "Croatia"
"HU" = "Hungary"
"IE" = "Ireland"
"IS" = "Iceland"
"IT" = "Italia"
"LT" = "Lithuania"
"LU" = "Luxembourg"
"LV" = "Latvia"
"ME" = "Montenegro"
"MK" = "The Former Yugoslav Republic of Macedonia (FYROM)"
"MT" = "Malta"
"NL" = "Nederland"
"NO" = "Norway"
"PL" = "Poland"
"PT" = "Portugal"
"RO" = "Romania"
"RS" = "Serbia"
"SE" = "Sverige"
"SI" = "Slovenia"
"SK" = "Slovak Republic"
"TR" = "Turkey"
"UK" = "United Kingdom"
;
VALUE PB04F /* PB050_F */
1= "Filled"
;
VALUE PB06F /* PB080_F */
1= "Filled"
-2= "Not applicable (country does not use the selected respondent model)"
-3= "Non-selected respondent"
;
VALUE PB17F /* PB100 */
1= "January-March"
2= "April-June"
3= "July-September"
4= "October-December"
;
VALUE PB18F /* PB100_F */
1= "Filled"
-1= "Missing"
;
VALUE PB110F /* PB110_F */
1= "Filled"
-1= "Missing"
;
VALUE PB112F /* PB120_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable (information only extracted from registers)"
;
VALUE PB113F /* PB130 */
1= "January-March"
2= "April-June"
3= "July-September"
4= "October-December"
;
VALUE PB114F /* PB130_F */
1= "Filled"
-1= "Missing"
;
VALUE PB116F /* PB140_F */
1= "Filled"
-1= "Missing"
;
VALUE PB117F /* PB150 */
1= "Male"
2= "Female"
;
VALUE PB118F /* PB150_F */
1= "Filled"
-1= "Missing"
;
VALUE PB120F /* PB160_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable (father is not a household member)"
;
VALUE PB122F /* PB170_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable (mother is not a household member)"
;
VALUE PB124F /* PB180_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable (person has no spouse/partner or spouse/partner is not a household member)"
;
VALUE PB125F /* PB190 */
1= "Never married"
2= "Married"
3= "Separated"
4= "Widowed"
5= "Divorced"
;
VALUE PB126F /* PB190_F */
1= "Filled"
-1= "Missing"
;
VALUE PB227F /* PB200 */
1= "Yes, on a legal basis"
2= "Yes, without a legal basis"
3= "No"
;
VALUE PB228F /* PB200_F */
1= "Filled"
-1= "Missing"
;
VALUE PE029F /* PE040 */
000= "Less than primary education"
100= "Primary education"
200= "Lower secondary education"
300= "Upper secondary education (not further specified)"
400= "Post-secondary non-tertiary education (not further specified)"
500= "Tertiary education"
;
VALUE PE030F /* PE040_F */
1= "Filled"
-1= "Missing"
;
VALUE PH031F /* PH010 */
1= "Very good"
2= "Good"
3= "Fair"
4= "Bad"
5= "Very bad"
;
VALUE PH032F /* PH010_F */
1= "Filled"
-1= "Missing"
-3= "Non-selected respondent"
;
VALUE PH033F /* PH020 */
1= "Yes"
2= "No"
;
VALUE PH034F /* PH020_F */
1= "Filled"
-1= "Missing"
-3= "Non-selected respondent"
;
VALUE PH035F /* PH030 */
1= "Yes, strongly limited"
2= "Yes, limited"
3= "No, not limited"
;
VALUE PH036F /* PH030_F */
1= "Filled"
-1= "Missing"
-3= "Non-selected respondent"
;
VALUE PL037F /* PL020 */
1= "Yes"
2= "No"
;
VALUE PL038F /* PL020_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable (PL031 eq 1, 2, 3 or 4 or older than the standard retirement age)"
;
VALUE PL039F /* PL025 */
1= "Yes"
2= "No"
;
VALUE PL040F /* PL025_F */
1= "filled"
-1= "Missing"
-2= "Not applicable (PL020 not equal to 1)"
;
VALUE PL041F /* PL031 */
1= "Employee working full-time"
2= "Employee working part-time"
3= "Self-employed working full-time (including family worker)"
4= "Self-employed working part-time (including family worker)"
5= "Unemployed"
6= "Pupil, student, further training, unpaid work experience"
7= "In retirement or in early retirement or has given up business"
8= "Permanently disabled or/and unfit to work"
9= "In compulsory military or community service"
10= "Fulfilling domestic tasks and care responsibilities"
11= "Other inactive person"
;
VALUE PL042F /* PL031_F */
1= "Filled"
-1= "Missing"
;
VALUE PL043F /* PL040 */
1= "Self-employed with employees"
2= "Self-employed without employees"
3= "Employee"
4= "Family worker"
;
VALUE PL044F /* PL040_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable (PL015 not equal to 1 and PL031 not equal to 1,2,3 or 4)"
;
VALUE PL045F /* PL051 */
1= "Commissioned Armed Forces Officers"
2= "Non-commissioned Armed Forces Officers"
3= "Armed Forces Occupations, Other Ranks"
11= "Chief Executives, Senior Officials and Legislators"
12= "Administrative and Commercial Managers"
13= "Production and Specialized Services Managers"
14= "Hospitality, Retail and Other Services Managers"
21= "Science and Engineering Professionals"
22= "Health Professionals"
23= "Teaching Professionals"
24= "Business and Administration Professionals"
25= "Information and Communications Technology Professionals"
26= "Legal, Social and Cultural Professionals"
31= "Science and Engineering Associate Professionals"
32= "Health Associate Professionals"
33= "Business and Administration Associate Professionals"
34= "Legal, Social, Cultural and Related Associate Professionals"
35= "Information and Communications Technicians"
41= "General and Keyboard Clerks"
42= "Customer Services Clerks"
43= "Numerical and Material Recording Clerks"
44= "Other Clerical Support Workers"
51= "Personal Services Workers"
52= "Sales Workers"
53= "Personal Care Workers"
54= "Protective Services Workers"
61= "Market-oriented Skilled Agricultural Workers"
62= "Market-oriented Skilled Forestry, Fishery and Hunting Workers"
63= "Subsistence Farmers, Fishers, Hunters and Gatherers"
71= "Building and Related Trades Workers (excluding Electricians)"
72= "Metal, Machinery and Related Trades Workers"
73= "Handicraft and Printing Workers"
74= "Electrical and Electronic Trades Workers"
75= "Food Processing, Woodworking, Garment and Other Craft and Related Trades Workers"
81= "Stationary Plant and Machine Operators"
82= "Assemblers"
83= "Drivers and Mobile Plant Operators"
91= "Cleaners and Helpers"
92= "Agricultural, Forestry and Fishery Labourers"
93= "Labourers in Mining, Construction, Manufacturing and Transport"
94= "Food Preparation Assistants"
95= "Street and Related Sales and Services Workers"
96= "Refuse Workers and Other Elementary Workers"
;
VALUE PL046F /* PL051_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable (PL031 not eq 1, 2, 3 or 4 and PL015 not eq 1)"
;
VALUE PL048F /* PL060_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable (PL031 not eq 1, 2, 3 or 4)"
-6= "Hours varying (when an average for over four weeks is not possible)"
;
VALUE PL149F /* PL140 */
1= "Permanent job/work contract of unlimited duration"
2= "Temporary job/work contract of limited duration"
;
VALUE PL150F /* PL140_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable (PL040 not equal to 3)"
-3= "Non-selected respondent"
-4= "Not applicable because the person is employee (PL040 eq 3) but does not have a contract"
;
VALUE PL151F /* PL160 */
1= "Yes"
2= "No"
;
VALUE PL152F /* PL160_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable (PL031 not equal to 1, 2, 3 or 4)"
-3= "Non-selected respondent"
;
VALUE PL153F /* PL170 */
1= "To take up or seek better job"
2= "End of temporary contract"
3= "Obliged to stop by employer (business closure, redundancy, early retirement, dismissal etc.)"
4= "Sale or closure of own/family business"
5= "Childcare and care for other dependents"
6= "Partner¿s job required us to move to another area or marriage"
7= "Other reasons"
;
VALUE PL154F /* PL170_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable (PL160 not equal to 1)"
-3= "Non-selected respondent"
;
VALUE PL155F /* PL180 */
1= "Employed - unemployed"
2= "Employed - retired"
3= "Employed - other inactive"
4= "Unemployed - employed"
5= "Unemployed - retired"
6= "Unemployed - other inactive"
7= "Retired - employed"
8= "Retired - unemployed"
9= "Retired - other inactive"
10= "Other inactive - employed"
11= "Other inactive - unemployed"
12= "Other inactive - retired"
;
VALUE PL156F /* PL180_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable (no change since last year)"
-3= "Non-selected respondent"
;
VALUE PL158F /* PL190_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable (person never worked i.e. (PL031 not equal to 1, 2, 3 or 4 AND PL015 not equal to 1))"
-3= "Non-selected respondent"
;
VALUE PL260F /* PL200_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable (person never worked i.e. (PL031 not equal to 1, 2, 3 or 4 AND PL015 not equal to 1))"
-3= "Non-selected respondent"
;
VALUE PL261F /* PL211A */
1= "Employee working full-time"
2= "Employee working part-time"
3= "Self-employed working full-time (including family worker)"
4= "Self-employed working part-time (including family worker)"
5= "Unemployed"
6= "Pupil, student, further training, unpaid work experience"
7= "In retirement or in early retirement or has given up business"
8= "Permanently disabled or/and unfit to work"
9= "In compulsory military or community service"
10= "Fulfilling domestic tasks and care responsibilities"
11= "Other inactive person"
;
VALUE PL262F /* PL211A_F */
1= "Filled"
-1= "Missing"
-3= "Non-selected respondent"
;
VALUE PL263F /* PL211B */
1= "Employee working full-time"
2= "Employee working part-time"
3= "Self-employed working full-time (including family worker)"
4= "Self-employed working part-time (including family worker)"
5= "Unemployed"
6= "Pupil, student, further training, unpaid work experience"
7= "In retirement or in early retirement or has given up business"
8= "Permanently disabled or/and unfit to work"
9= "In compulsory military or community service"
10= "Fulfilling domestic tasks and care responsibilities"
11= "Other inactive person"
;
VALUE PL264F /* PL211B_F */
1= "Filled"
-1= "Missing"
-3= "Non-selected respondent"
;
VALUE PL265F /* PL211C */
1= "Employee working full-time"
2= "Employee working part-time"
3= "Self-employed working full-time (including family worker)"
4= "Self-employed working part-time (including family worker)"
5= "Unemployed"
6= "Pupil, student, further training, unpaid work experience"
7= "In retirement or in early retirement or has given up business"
8= "Permanently disabled or/and unfit to work"
9= "In compulsory military or community service"
10= "Fulfilling domestic tasks and care responsibilities"
11= "Other inactive person"
;
VALUE PL266F /* PL211C_F */
1= "Filled"
-1= "Missing"
-3= "Non-selected respondent"
;
VALUE PL267F /* PL211D */
1= "Employee working full-time"
2= "Employee working part-time"
3= "Self-employed working full-time (including family worker)"
4= "Self-employed working part-time (including family worker)"
5= "Unemployed"
6= "Pupil, student, further training, unpaid work experience"
7= "In retirement or in early retirement or has given up business"
8= "Permanently disabled or/and unfit to work"
9= "In compulsory military or community service"
10= "Fulfilling domestic tasks and care responsibilities"
11= "Other inactive person"
;
VALUE PL268F /* PL211D_F */
1= "Filled"
-1= "Missing"
-3= "Non-selected respondent"
;
VALUE PL269F /* PL211E */
1= "Employee working full-time"
2= "Employee working part-time"
3= "Self-employed working full-time (including family worker)"
4= "Self-employed working part-time (including family worker)"
5= "Unemployed"
6= "Pupil, student, further training, unpaid work experience"
7= "In retirement or in early retirement or has given up business"
8= "Permanently disabled or/and unfit to work"
9= "In compulsory military or community service"
10= "Fulfilling domestic tasks and care responsibilities"
11= "Other inactive person"
;
VALUE PL270F /* PL211E_F */
1= "Filled"
-1= "Missing"
-3= "Non-selected respondent"
;
VALUE PL271F /* PL211F */
1= "Employee working full-time"
2= "Employee working part-time"
3= "Self-employed working full-time (including family worker)"
4= "Self-employed working part-time (including family worker)"
5= "Unemployed"
6= "Pupil, student, further training, unpaid work experience"
7= "In retirement or in early retirement or has given up business"
8= "Permanently disabled or/and unfit to work"
9= "In compulsory military or community service"
10= "Fulfilling domestic tasks and care responsibilities"
11= "Other inactive person"
;
VALUE PL272F /* PL211F_F */
1= "Filled"
-1= "Missing"
-3= "Non-selected respondent"
;
VALUE PL273F /* PL211G */
1= "Employee working full-time"
2= "Employee working part-time"
3= "Self-employed working full-time (including family worker)"
4= "Self-employed working part-time (including family worker)"
5= "Unemployed"
6= "Pupil, student, further training, unpaid work experience"
7= "In retirement or in early retirement or has given up business"
8= "Permanently disabled or/and unfit to work"
9= "In compulsory military or community service"
10= "Fulfilling domestic tasks and care responsibilities"
11= "Other inactive person"
;
VALUE PL274F /* PL211G_F */
1= "Filled"
-1= "Missing"
-3= "Non-selected respondent"
;
VALUE PL275F /* PL211H */
1= "Employee working full-time"
2= "Employee working part-time"
3= "Self-employed working full-time (including family worker)"
4= "Self-employed working part-time (including family worker)"
5= "Unemployed"
6= "Pupil, student, further training, unpaid work experience"
7= "In retirement or in early retirement or has given up business"
8= "Permanently disabled or/and unfit to work"
9= "In compulsory military or community service"
10= "Fulfilling domestic tasks and care responsibilities"
11= "Other inactive person"
;
VALUE PL276F /* PL211H_F */
1= "Filled"
-1= "Missing"
-3= "Non-selected respondent"
;
VALUE PL277F /* PL211I */
1= "Employee working full-time"
2= "Employee working part-time"
3= "Self-employed working full-time (including family worker)"
4= "Self-employed working part-time (including family worker)"
5= "Unemployed"
6= "Pupil, student, further training, unpaid work experience"
7= "In retirement or in early retirement or has given up business"
8= "Permanently disabled or/and unfit to work"
9= "In compulsory military or community service"
10= "Fulfilling domestic tasks and care responsibilities"
11= "Other inactive person"
;
VALUE PL278F /* PL211I_F */
1= "Filled"
-1= "Missing"
-3= "Non-selected respondent"
;
VALUE PL279F /* PL211J */
1= "Employee working full-time"
2= "Employee working part-time"
3= "Self-employed working full-time (including family worker)"
4= "Self-employed working part-time (including family worker)"
5= "Unemployed"
6= "Pupil, student, further training, unpaid work experience"
7= "In retirement or in early retirement or has given up business"
8= "Permanently disabled or/and unfit to work"
9= "In compulsory military or community service"
10= "Fulfilling domestic tasks and care responsibilities"
11= "Other inactive person"
;
VALUE PL280F /* PL211J_F */
1= "Filled"
-1= "Missing"
-3= "Non-selected respondent"
;
VALUE PL281F /* PL211K */
1= "Employee working full-time"
2= "Employee working part-time"
3= "Self-employed working full-time (including family worker)"
4= "Self-employed working part-time (including family worker)"
5= "Unemployed"
6= "Pupil, student, further training, unpaid work experience"
7= "In retirement or in early retirement or has given up business"
8= "Permanently disabled or/and unfit to work"
9= "In compulsory military or community service"
10= "Fulfilling domestic tasks and care responsibilities"
11= "Other inactive person"
;
VALUE PL282F /* PL211K_F */
1= "Filled"
-1= "Missing"
-3= "Non-selected respondent"
;
VALUE PL283F /* PL211L */
1= "Employee working full-time"
2= "Employee working part-time"
3= "Self-employed working full-time (including family worker)"
4= "Self-employed working part-time (including family worker)"
5= "Unemployed"
6= "Pupil, student, further training, unpaid work experience"
7= "In retirement or in early retirement or has given up business"
8= "Permanently disabled or/and unfit to work"
9= "In compulsory military or community service"
10= "Fulfilling domestic tasks and care responsibilities"
11= "Other inactive person"
;
VALUE PL284F /* PL211L_F */
1= "Filled"
-1= "Missing"
-3= "Non-selected respondent"
;
VALUE PY0131F /* PY030G_F */
0= "No income"
1= "Income (variable is filled)"
-1= "Missing"
;
VALUE PY0134F /* PY031G_F */
0= "No income"
1= "Income (variable is filled)"
-1= "Missing"
;
VALUE PY0149F /* PY091G_F */
0= "No income"
1= "Filled with only Contributory and means-tested components"
2= "Filled with mixed components"
-1= "Missing"
-2= "Not applicable (This scheme doesn't exist at national level)"
-7= "Not applicable (PB010 ne last year)"
;
VALUE PY0151F /* PY092G_F */
0= "No income"
1= "Filled with only Contributory and non means-tested components"
2= "Filled with mixed components"
-1= "Missing"
-2= "Not applicable (This scheme doesn't exist at national level)"
-7= "Not applicable (PB010 ne last year)"
;
VALUE PY0153F /* PY093G_F */
0= "No income"
1= "Filled with only Non-contributory and means-tested components"
2= "Filled with mixed components"
-1= "Missing"
-2= "Not applicable (This scheme doesn't exist at national level)"
-7= "Not applicable (PB010 ne last year)"
;
VALUE PY0155F /* PY094G_F */
0= "No income"
1= "Filled with only Non-contributory and non means-tested components"
2= "Filled with mixed components"
-1= "Missing"
-2= "Not applicable (This scheme doesn't exist at national level)"
-7= "Not applicable (PB010 ne last year)"
;
VALUE PY1160F /* PY101G_F */
0= "No income"
1= "Filled with only Contributory and means-tested components"
2= "Filled with mixed components"
-1= "Missing"
-2= "Not applicable (This scheme doesn't exist at national level)"
-7= "Not applicable (PB010 ne last year)"
;
VALUE PY1162F /* PY102G_F */
0= "No income"
1= "Filled with only Contributory and non means-tested components"
2= "Filled with mixed components"
-1= "Missing"
-2= "Not applicable (This scheme doesn't exist at national level)"
-7= "Not applicable (PB010 ne last year)"
;
VALUE PY1164F /* PY103G_F */
0= "No income"
1= "Filled with only Non-contributory and means-tested components"
2= "Filled with mixed components"
-1= "Missing"
-2= "Not applicable (This scheme doesn't exist at national level)"
-7= "Not applicable (PB010 ne last year)"
;
VALUE PY1166F /* PY104G_F */
0= "No income"
1= "Filled with only Non-contributory and non means-tested components"
2= "Filled with mixed components"
-1= "Missing"
-2= "Not applicable (This scheme doesn't exist at national level)"
-7= "Not applicable (PB010 ne last year)"
;
VALUE PY1171F /* PY111G_F */
0= "No income"
1= "Filled with only Contributory and means-tested components"
2= "Filled with mixed components"
-1= "Missing"
-2= "Not applicable (This scheme doesn't exist at national level)"
-7= "Not applicable (PB010 ne last year)"
;
VALUE PY1173F /* PY112G_F */
0= "No income"
1= "Filled with only Contributory and non means-tested components"
2= "Filled with mixed components"
-1= "Missing"
-2= "Not applicable (This scheme doesn't exist at national level)"
-7= "Not applicable (PB010 ne last year)"
;
VALUE PY1175F /* PY113G_F */
0= "No income"
1= "Filled with only Non-contributory and means-tested components"
2= "Filled with mixed components"
-1= "Missing"
-2= "Not applicable (This scheme doesn't exist at national level)"
-7= "Not applicable (PB010 ne last year)"
;
VALUE PY1177F /* PY114G_F */
0= "No income"
1= "Filled with only Non-contributory and non means-tested components"
2= "Filled with mixed components"
-1= "Missing"
-2= "Not applicable (This scheme doesn't exist at national level)"
-7= "Not applicable (PB010 ne last year)"
;
VALUE PY1182F /* PY121G_F */
0= "No income"
1= "Filled with only Contributory and means-tested components"
2= "Filled with mixed components"
-1= "Missing"
-2= "Not applicable (This scheme doesn't exist at national level)"
-7= "Not applicable (PB010 ne last year)"
;
VALUE PY1184F /* PY122G_F */
0= "No income"
1= "Filled with only Contributory and non means-tested components"
2= "Filled with mixed components"
-1= "Missing"
-2= "Not applicable (This scheme doesn't exist at national level)"
-7= "Not applicable (PB010 ne last year)"
;
VALUE PY1186F /* PY123G_F */
0= "No income"
1= "Filled with only Non-contributory and means-tested components"
2= "Filled with mixed components"
-1= "Missing"
-2= "Not applicable (This scheme doesn't exist at national level)"
-7= "Not applicable (PB010 ne last year)"
;
VALUE PY1188F /* PY124G_F */
0= "No income"
1= "Filled with only Non-contributory and non means-tested components"
2= "Filled with mixed components"
-1= "Missing"
-2= "Not applicable (This scheme doesn't exist at national level)"
-7= "Not applicable (PB010 ne last year)"
;
VALUE PY1193F /* PY131G_F */
0= "No income"
1= "Filled with only Contributory and means-tested components"
2= "Filled with mixed components"
-1= "Missing"
-2= "Not applicable (This scheme doesn't exist at national level)"
-7= "Not applicable (PB010 ne last year)"
;
VALUE PY1195F /* PY132G_F */
0= "No income"
1= "Filled with only Contributory and non means-tested components"
2= "Filled with mixed components"
-1= "Missing"
-2= "Not applicable (This scheme doesn't exist at national level)"
-7= "Not applicable (PB010 ne last year)"
;
VALUE PY1197F /* PY133G_F */
0= "No income"
1= "Filled with only Non-contributory and means-tested components"
2= "Filled with mixed components"
-1= "Missing"
-2= "Not applicable (This scheme doesn't exist at national level)"
-7= "Not applicable (PB010 ne last year)"
;
VALUE PY1199F /* PY134G_F */
0= "No income"
1= "Filled with only Non-contributory and non means-tested components"
2= "Filled with mixed components"
-1= "Missing"
-2= "Not applicable (This scheme doesn't exist at national level)"
-7= "Not applicable (PB010 ne last year)"
;
VALUE PY1204F /* PY141G_F */
0= "No income"
1= "Filled with only Contributory and means-tested components"
2= "Filled with mixed components"
-1= "Missing"
-2= "Not applicable (This scheme doesn't exist at national level)"
-7= "Not applicable (PB010 ne last year)"
;
VALUE PY1206F /* PY142G_F */
0= "No income"
1= "Filled with only Contributory and non means-tested components"
2= "Filled with mixed components"
-1= "Missing"
-2= "Not applicable (This scheme doesn't exist at national level)"
-7= "Not applicable (PB010 ne last year)"
;
VALUE PY1208F /* PY143G_F */
0= "No income"
1= "Filled with only Non-contributory and means-tested components"
2= "Filled with mixed components"
-1= "Missing"
-2= "Not applicable (This scheme doesn't exist at national level)"
-7= "Not applicable (PB010 ne last year)"
;
VALUE PY1210F /* PY144G_F */
0= "No income"
1= "Filled with only Non-contributory and non means-tested components"
2= "Filled with mixed components"
-1= "Missing"
-2= "Not applicable (This scheme doesn't exist at national level)"
-7= "Not applicable (PB010 ne last year)"
;
VALUE PD0211F /* PD020 */
1= "Yes"
2= "No - cannot afford it"
3= "No - other reason"
;
VALUE PD0212F /* PD020_F */
1= "Filled"
-1= "Missing"
-3= "Not selected respondent"
;
VALUE PD0213F /* PD030 */
1= "Yes"
2= "No - cannot afford it"
3= "No - other reason"
;
VALUE PD0214F /* PD030_F */
1= "Filled"
-1= "Missing"
-3= "Not selected respondent"
;
VALUE PD0215F /* PD050 */
1= "Yes"
2= "No - cannot afford it"
3= "No - other reason"
;
VALUE PD0216F /* PD050_F */
1= "Filled"
-1= "Missing"
-3= "Not selected respondent"
;
VALUE PD0217F /* PD060 */
1= "Yes"
2= "No - cannot afford it"
3= "No - other reason"
;
VALUE PD0218F /* PD060_F */
1= "Filled"
-1= "Missing"
-3= "Not selected respondent"
;
VALUE PD0219F /* PD070 */
1= "Yes"
2= "No - cannot afford it"
3= "No - other reason"
;
VALUE PD0220F /* PD070_F */
1= "Filled"
-1= "Missing"
-3= "Not selected respondent"
;
VALUE PD0221F /* PD080 */
1= "Yes"
2= "No - cannot afford it"
3= "No - other reason"
;
VALUE PD0222F /* PD080_F */
1= "Filled"
-1= "Missing"
-3= "Not selected respondent"
;
VALUE PX0226F /* PX040 */
1= "Current household member aged 16 and over"
2= "Selected respondent"
3= "Non-selected respondent"
4= "Ineligible person"
;
format PB020 $PB01F.;
format PB050_F PB04F.;
format PB080_F PB06F.;
format PB100 PB17F.;
format PB100_F PB18F.;
format PB110_F PB110F.;
format PB120_F PB112F.;
format PB130 PB113F.;
format PB130_F PB114F.;
format PB140_F PB116F.;
format PB150 PB117F.;
format PB150_F PB118F.;
format PB160_F PB120F.;
format PB170_F PB122F.;
format PB180_F PB124F.;
format PB190 PB125F.;
format PB190_F PB126F.;
format PB200 PB227F.;
format PB200_F PB228F.;
format PE040 PE029F.;
format PE040_F PE030F.;
format PH010 PH031F.;
format PH010_F PH032F.;
format PH020 PH033F.;
format PH020_F PH034F.;
format PH030 PH035F.;
format PH030_F PH036F.;
format PL020 PL037F.;
format PL020_F PL038F.;
format PL025 PL039F.;
format PL025_F PL040F.;
format PL031 PL041F.;
format PL031_F PL042F.;
format PL040 PL043F.;
format PL040_F PL044F.;
format PL051 PL045F.;
format PL051_F PL046F.;
format PL060_F PL048F.;
format PL140 PL149F.;
format PL140_F PL150F.;
format PL160 PL151F.;
format PL160_F PL152F.;
format PL170 PL153F.;
format PL170_F PL154F.;
format PL180 PL155F.;
format PL180_F PL156F.;
format PL190_F PL158F.;
format PL200_F PL260F.;
format PL211A PL261F.;
format PL211A_F PL262F.;
format PL211B PL263F.;
format PL211B_F PL264F.;
format PL211C PL265F.;
format PL211C_F PL266F.;
format PL211D PL267F.;
format PL211D_F PL268F.;
format PL211E PL269F.;
format PL211E_F PL270F.;
format PL211F PL271F.;
format PL211F_F PL272F.;
format PL211G PL273F.;
format PL211G_F PL274F.;
format PL211H PL275F.;
format PL211H_F PL276F.;
format PL211I PL277F.;
format PL211I_F PL278F.;
format PL211J PL279F.;
format PL211J_F PL280F.;
format PL211K PL281F.;
format PL211K_F PL282F.;
format PL211L PL283F.;
format PL211L_F PL284F.;
format PY030G_F PY0131F.;
format PY031G_F PY0134F.;
format PY091G_F PY0149F.;
format PY092G_F PY0151F.;
format PY093G_F PY0153F.;
format PY094G_F PY0155F.;
format PY101G_F PY1160F.;
format PY102G_F PY1162F.;
format PY103G_F PY1164F.;
format PY104G_F PY1166F.;
format PY111G_F PY1171F.;
format PY112G_F PY1173F.;
format PY113G_F PY1175F.;
format PY114G_F PY1177F.;
format PY121G_F PY1182F.;
format PY122G_F PY1184F.;
format PY123G_F PY1186F.;
format PY124G_F PY1188F.;
format PY131G_F PY1193F.;
format PY132G_F PY1195F.;
format PY133G_F PY1197F.;
format PY134G_F PY1199F.;
format PY141G_F PY1204F.;
format PY142G_F PY1206F.;
format PY143G_F PY1208F.;
format PY144G_F PY1210F.;
format PD020 PD0211F.;
format PD020_F PD0212F.;
format PD030 PD0213F.;
format PD030_F PD0214F.;
format PD050 PD0215F.;
format PD050_F PD0216F.;
format PD060 PD0217F.;
format PD060_F PD0218F.;
format PD070 PD0219F.;
format PD070_F PD0220F.;
format PD080 PD0221F.;
format PD080_F PD0222F.;
format PX040 PX0226F.;
RUN;
