#Declinazione di responsabilità. 
#I file rilasciati in formato testo sono provvisti anche dei programmi di importazione per STATA, SAS e R. 
#L'Istat non garantisce che le funzioni contenute nei suddetti programmi siano esenti da errore e non si assume alcuna responsabilità sull’output ottenuto dal loro utilizzo.  
setwd(choose.dir(default = "", caption = "WHERE ARE MICRODATA?"))
direttorio = getwd()
fileInput = paste (direttorio, "/ISTAT_MFR_EUSILC_Long_Microdata_2019_PERSONAL_DATA_(P-FILE)_Longitudinal_FILE_STRUCTURE_EXAMPLE.txt", sep="")
DF_EUSILC_Long_A2019_PERSONAL_D<- read.delim2 (fileInput,  header=T, sep="	",  quote="",  na.strings = ".")
attr(DF_EUSILC_Long_A2019_PERSONAL_D, "label") <- c(
"YEAR OF THE SURVEY",
"COUNTRY",
"PERSONAL ID",
"PERSONAL BASE WEIGHT",
"FLAG OF PB050",
"PERSONAL BASE WEIGHT FOR SELECTED RESPONDENT",
"FLAG OF PB080",
"MONTH OF THE PERSONAL INTERVIEW",
"FLAG OF PB100",
"YEAR OF THE PERSONAL INTERVIEW",
"FLAG OF PB110",
"MINUTES TO COMPLETE THE PERSONAL QUESTIONNAIRE",
"FLAG OF PB120",
"MONTH OF BIRTH",
"FLAG OF PB130",
"YEAR OF BIRTH",
"FLAG OF PB140",
"SEX",
"FLAG OF PB150",
"FATHER ID",
"FLAG OF PB160",
"MOTHER ID",
"FLAG OF PB170",
"SPOUSE/PARTNER ID",
"FLAG OF PB180",
"MARITAL STATUS",
"FLAG OF PB190",
"CONSENSUAL UNION",
"FLAG OF PB200",
"HIGHEST ISCED LEVEL ATTAINED",
"FLAG OF PE040",
"GENERAL HEALTH",
"FLAG OF PH010",
"SUFFER FROM ANY CHRONIC (LONG-STANDING) ILLNESS OR CONDITION",
"FLAG OF PH020",
"LIMITATION IN ACTIVITIES BECAUSE OF HEALTH PROBLEMS",
"FLAG OF PH030",
"ACTIVELY LOOKING FOR A JOB",
"FLAG OF PL020",
"AVAILABLE FOR WORK",
"FLAG OF PL025",
"SELF-DEFINED CURRENT ECONOMIC STATUS",
"FLAG OF PL031",
"STATUS IN EMPLOYMENT",
"FLAG OF PL040",
"OCCUPATION (ISCO-08 (COM))",
"FLAG OF PL051",
"NUMBER OF HOURS USUALLY WORKED PER WEEK IN MAIN JOB",
"FLAG OF PL060",
"TYPE OF CONTRACT",
"FLAG OF PL140",
"CHANGE OF JOB SINCE LAST YEAR",
"FLAG OF PL160",
"REASON TO CHANGE",
"FLAG OF PL170",
"MOST RECENT CHANGE IN THE INDIVIDUALS ACTIVITY STATUS",
"FLAG OF PL180",
"WHEN BEGAN FIRST REGULAR JOB",
"FLAG OF PL190",
"NUMBER OF YEARS SPENT IN PAID WORK",
"FLAG OF PL200",
"MAIN ACTIVITY IN JANUARY",
"FLAG OF PL211A",
"MAIN ACTIVITY IN FEBRUARY",
"FLAG OF PL211B",
"MAIN ACTIVITY IN MARCH",
"FLAG OF PL211C",
"MAIN ACTIVITY IN APRIL",
"FLAG OF PL211D",
"MAIN ACTIVITY IN MAY",
"FLAG OF PL211E",
"MAIN ACTIVITY IN JUNE",
"FLAG OF PL211F",
"MAIN ACTIVITY IN JULY",
"FLAG OF PL211G",
"MAIN ACTIVITY IN AUGUST",
"FLAG OF PL211H",
"MAIN ACTIVITY IN SEPTEMBER",
"FLAG OF PL211I",
"MAIN ACTIVITY IN OCTOBER",
"FLAG OF PL211J",
"MAIN ACTIVITY IN NOVEMBER",
"FLAG OF PL211K",
"MAIN ACTIVITY IN DECEMBER",
"FLAG OF PL211L",
"EMPLOYEE CASH OR NEAR CASH INCOME",
"FLAG OF PY010N",
"IMPUTATION FACTOR OF PY010N",
"NON-CASH EMPLOYEE INCOME",
"FLAG OF PY020N",
"IMPUTATION FACTOR OF PY020N",
"COMPANY CAR",
"FLAG OF PY021N",
"IMPUTATION FACTOR OF PY021N",
"CONTRIBUTIONS TO INDIVIDUAL PRIVATE PENSION PLANS",
"FLAG OF PY035N",
"IMPUTATION FACTOR OF PY035N",
"CASH PROFITS OR LOSSES FROM SELF-EMPLOYMENT",
"FLAG OF PY050N",
"IMPUTATION FACTOR OF PY050N",
"PENSION FROM INDIVIDUAL PRIVATE PLANS",
"FLAG OF PY080N",
"IMPUTATION FACTOR OF PY080N",
"UNEMPLOYMENT BENEFITS",
"FLAG OF PY090N",
"IMPUTATION FACTOR OF PY090N",
"OLD-AGE BENEFITS",
"FLAG OF PY100N",
"IMPUTATION FACTOR OF PY100N",
"SURVIVOR' BENEFITS",
"FLAG OF PY110N",
"IMPUTATION FACTOR OF PY110N",
"SICKNESS BENEFITS",
"FLAG OF PY120N",
"IMPUTATION FACTOR OF PY120N",
"DISABILITY BENEFITS",
"FLAG OF PY130N",
"IMPUTATION FACTOR OF PY130N",
"EDUCATION-RELATED ALLOWANCES",
"FLAG OF PY140N",
"IMPUTATION FACTOR OF PY140N",
"EMPLOYEE CASH OR NEAR CASH INCOME",
"FLAG OF PY010G",
"IMPUTATION FACTOR OF PY010G",
"NON-CASH EMPLOYEE INCOME",
"FLAG OF PY020G",
"IMPUTATION FACTOR OF PY020G",
"COMPANY CAR",
"FLAG OF PY021G",
"IMPUTATION FACTOR OF PY021G",
"EMPLOYER'S SOCIAL INSURANCE CONTRIBUTION",
"FLAG OF PY030G",
"IMPUTATION FACTOR OF PY030G",
"OPTIONAL EMPLOYER'S SOCIAL INSURANCE CONTRIBUTIONS",
"FLAG OF PY031G",
"IMPUTATION FACTOR OF PY031G",
"CONTRIBUTIONS TO INDIVIDUAL PRIVATE PENSION PLANS",
"FLAG OF PY035G",
"IMPUTATION FACTOR OF PY035G",
"CASH PROFITS OR LOSSES FROM SELF-EMPLOYMENT",
"FLAG OF PY050G",
"IMPUTATION FACTOR OF PY050G",
"PENSION FROM INDIVIDUAL PRIVATE PLANS",
"FLAG OF PY080G",
"IMPUTATION FACTOR OF PY080G",
"UNEMPLOYMENT BENEFITS",
"FLAG OF PY090G",
"IMPUTATION FACTOR OF PY090G",
"UNEMPLOYMENT BENEFITS (CONTRIBUTORY AND MEANS-TESTED)",
"FLAG OF PY091G",
"UNEMPLOYMENT BENEFITS (CONTRIBUTORY AND NON MEANS-TESTED)",
"FLAG OF PY092G",
"UNEMPLOYMENT BENEFITS (NON-CONTRIBUTORY AND MEANS-TESTED)",
"FLAG OF PY093G",
"UNEMPLOYMENT BENEFITS (NON-CONTRIBUTORY AND NON MEANS-TESTED)",
"FLAG OF PY094G",
"OLD-AGE BENEFITS",
"FLAG OF PY100G",
"IMPUTATION FACTOR OF PY100G",
"OLD-AGE BENEFITS (CONTRIBUTORY AND MEANS-TESTED)",
"FLAG OF PY101G",
"OLD-AGE BENEFITS (CONTRIBUTORY AND NON MEANS-TESTED)",
"FLAG OF PY102G",
"OLD-AGE BENEFITS (NON-CONTRIBUTORY AND MEANS-TESTED)",
"FLAG OF PY103G",
"OLD-AGE BENEFITS (NON-CONTRIBUTORY AND NON MEANS-TESTED)",
"FLAG OF PY104G",
"SURVIVOR' BENEFITS",
"FLAG OF PY110G",
"IMPUTATION FACTOR OF PY110G",
"SURVIVOR BENEFITS (CONTRIBUTORY AND MEANS-TESTED)",
"FLAG OF PY111G",
"SURVIVOR BENEFITS (CONTRIBUTORY AND NON MEANS-TESTED)",
"FLAG OF PY112G",
"SURVIVOR BENEFITS (NON-CONTRIBUTORY AND MEANS-TESTED)",
"FLAG OF PY113G",
"SURVIVOR BENEFITS (NON-CONTRIBUTORY AND NON MEANS-TESTED)",
"FLAG OF PY114G",
"SICKNESS BENEFITS",
"FLAG OF PY120G",
"IMPUTATION FACTOR OF PY120G",
"SICKNESS BENEFITS (CONTRIBUTORY AND MEANS-TESTED)",
"FLAG OF PY121G",
"SICKNESS BENEFITS (CONTRIBUTORY AND NON MEANS-TESTED)",
"FLAG OF PY122G",
"SICKNESS BENEFITS (NON-CONTRIBUTORY AND MEANS-TESTED)",
"FLAG OF PY123G",
"SICKNESS BENEFITS (NON-CONTRIBUTORY AND NON MEANS-TESTED)",
"FLAG OF PY124G",
"DISABILITY BENEFITS",
"FLAG OF PY130G",
"IMPUTATION FACTOR OF PY130G",
"DISABILITY BENEFITS (CONTRIBUTORY AND MEANS-TESTED)",
"FLAG OF PY131G",
"DISABILITY BENEFITS (CONTRIBUTORY AND NON MEANS-TESTED)",
"FLAG OF PY132G",
"DISABILITY BENEFITS (NON-CONTRIBUTORY AND MEANS-TESTED)",
"FLAG OF PY133G",
"DISABILITY BENEFITS (NON-CONTRIBUTORY AND NON MEANS-TESTED)",
"FLAG OF PY134G",
"EDUCATION-RELATED ALLOWANCES",
"FLAG OF PY140G",
"IMPUTATION FACTOR OF PY140G",
"EDUCATION-RELATED ALLOWANCES (CONTRIBUTORY AND MEANS-TESTED)",
"FLAG OF PY141G",
"EDUCATION-RELATED ALLOWANCES (CONTRIBUTORY AND NON MEANS-TESTED)",
"FLAG OF PY142G",
"EDUCATION-RELATED ALLOWANCES (NON-CONTRIBUTORY AND MEANS-TESTED)",
"FLAG OF PY143G",
"EDUCATION-RELATED ALLOWANCES (NON-CONTRIBUTORY AND NON MEANS-TESTED)",
"FLAG OF PY144G",
"REPLACE WORN-OUT CLOTHES BY SOME NEW (NOT SECOND-HAND) ONES",
"FLAG OF PD020",
"TWO PAIRS OF PROPERLY FITTING SHOES (INCLUDING A PAIR OF ALL-WEATHER SHOES)",
"FLAG OF PD030",
"GET-TOGETHER WITH FRIENDS/FAMILY (RELATIVES) FOR A DRINK/MEAL AT LEAST ONCE A MONTH",
"FLAG OF PD050",
"REGULARLY PARTICIPATE IN A LEISURE ACTIVITY",
"FLAG OF PD060",
"SPEND A SMALL AMOUNT OF MONEY EACH WEEK ON YOURSELF",
"FLAG OF PD070",
"INTERNET CONNECTION FOR PERSONAL USE AT HOME",
"FLAG OF PD080",
"CHANGE RATE",
"AGE AT THE END OF THE INCOME REFERENCE PERIOD",
"HOUSEHOLD IDENTIFICATION NUMBER",
"SELECTED RESPONDENT STATUS")

PB020_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PB020, 
levels=c("AL", 
"AT", 
"BE", 
"BG", 
"CH", 
"CY", 
"CZ", 
"DE", 
"DK", 
"EE", 
"EL", 
"ES", 
"FI", 
"FR", 
"HR", 
"HU", 
"IE", 
"IS", 
"IT", 
"LT", 
"LU", 
"LV", 
"ME", 
"MK", 
"MT", 
"NL", 
"NO", 
"PL", 
"PT", 
"RO", 
"RS", 
"SE", 
"SI", 
"SK", 
"TR", 
"UK"), 
labels=c("Albania", 
"Osterreich", 
"Belgique/Belgie", 
"Bulgaria", 
"Switzerland", 
"Cyprus", 
"Czech Republic", 
"Deutschland", 
"Denmark", 
"Estonia", 
"Ellada", 
"Espana", 
"Suomi", 
"France", 
"Croatia", 
"Hungary", 
"Ireland", 
"Iceland", 
"Italia", 
"Lithuania", 
"Luxembourg", 
"Latvia", 
"Montenegro", 
"The Former Yugoslav Republic of Macedonia (FYROM)", 
"Malta", 
"Nederland", 
"Norway", 
"Poland", 
"Portugal", 
"Romania", 
"Serbia", 
"Sverige", 
"Slovenia", 
"Slovak Republic", 
"Turkey", 
"United Kingdom")) 


PB050_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PB050_F, 
levels=c(1), 
labels=c("Filled")) 


PB080_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PB080_F, 
levels=c(1, 
-2, 
-3), 
labels=c("Filled", 
"Not applicable (country does not use the selected respondent model)", 
"Non-selected respondent")) 


PB100_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PB100, 
levels=c(1, 
2, 
3, 
4), 
labels=c("January-March", 
"April-June", 
"July-September", 
"October-December")) 


PB100_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PB100_F, 
levels=c(1, 
-1), 
labels=c("Filled", 
"Missing")) 


PB110_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PB110_F, 
levels=c(1, 
-1), 
labels=c("Filled", 
"Missing")) 


PB120_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PB120_F, 
levels=c(1, 
-1, 
-2), 
labels=c("Filled", 
"Missing", 
"Not applicable (information only extracted from registers)")) 


PB130_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PB130, 
levels=c(1, 
2, 
3, 
4), 
labels=c("January-March", 
"April-June", 
"July-September", 
"October-December")) 


PB130_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PB130_F, 
levels=c(1, 
-1), 
labels=c("Filled", 
"Missing")) 


PB140_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PB140_F, 
levels=c(1, 
-1), 
labels=c("Filled", 
"Missing")) 


PB150_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PB150, 
levels=c(1, 
2), 
labels=c("Male", 
"Female")) 


PB150_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PB150_F, 
levels=c(1, 
-1), 
labels=c("Filled", 
"Missing")) 


PB160_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PB160_F, 
levels=c(1, 
-1, 
-2), 
labels=c("Filled", 
"Missing", 
"Not applicable (father is not a household member)")) 


PB170_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PB170_F, 
levels=c(1, 
-1, 
-2), 
labels=c("Filled", 
"Missing", 
"Not applicable (mother is not a household member)")) 


PB180_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PB180_F, 
levels=c(1, 
-1, 
-2), 
labels=c("Filled", 
"Missing", 
"Not applicable (person has no spouse/partner or spouse/partner is not a household member)")) 


PB190_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PB190, 
levels=c(1, 
2, 
3, 
4, 
5), 
labels=c("Never married", 
"Married", 
"Separated", 
"Widowed", 
"Divorced")) 


PB190_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PB190_F, 
levels=c(1, 
-1), 
labels=c("Filled", 
"Missing")) 


PB200_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PB200, 
levels=c(1, 
2, 
3), 
labels=c("Yes, on a legal basis", 
"Yes, without a legal basis", 
"No")) 


PB200_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PB200_F, 
levels=c(1, 
-1), 
labels=c("Filled", 
"Missing")) 


PE040_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PE040, 
levels=c(000, 
100, 
200, 
300, 
400, 
500), 
labels=c("Less than primary education", 
"Primary education", 
"Lower secondary education", 
"Upper secondary education (not further specified)", 
"Post-secondary non-tertiary education (not further specified)", 
"Tertiary education")) 


PE040_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PE040_F, 
levels=c(1, 
-1), 
labels=c("Filled", 
"Missing")) 


PH010_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PH010, 
levels=c(1, 
2, 
3, 
4, 
5), 
labels=c("Very good", 
"Good", 
"Fair", 
"Bad", 
"Very bad")) 


PH010_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PH010_F, 
levels=c(1, 
-1, 
-3), 
labels=c("Filled", 
"Missing", 
"Non-selected respondent")) 


PH020_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PH020, 
levels=c(1, 
2), 
labels=c("Yes", 
"No")) 


PH020_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PH020_F, 
levels=c(1, 
-1, 
-3), 
labels=c("Filled", 
"Missing", 
"Non-selected respondent")) 


PH030_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PH030, 
levels=c(1, 
2, 
3), 
labels=c("Yes, strongly limited", 
"Yes, limited", 
"No, not limited")) 


PH030_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PH030_F, 
levels=c(1, 
-1, 
-3), 
labels=c("Filled", 
"Missing", 
"Non-selected respondent")) 


PL020_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PL020, 
levels=c(1, 
2), 
labels=c("Yes", 
"No")) 


PL020_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PL020_F, 
levels=c(1, 
-1, 
-2), 
labels=c("Filled", 
"Missing", 
"Not applicable (PL031 eq 1, 2, 3 or 4 or older than the standard retirement age)")) 


PL025_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PL025, 
levels=c(1, 
2), 
labels=c("Yes", 
"No")) 


PL025_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PL025_F, 
levels=c(1, 
-1, 
-2), 
labels=c("filled", 
"Missing", 
"Not applicable (PL020 not equal to 1)")) 


PL031_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PL031, 
levels=c(1, 
2, 
3, 
4, 
5, 
6, 
7, 
8, 
9, 
10, 
11), 
labels=c("Employee working full-time", 
"Employee working part-time", 
"Self-employed working full-time (including family worker)", 
"Self-employed working part-time (including family worker)", 
"Unemployed", 
"Pupil, student, further training, unpaid work experience", 
"In retirement or in early retirement or has given up business", 
"Permanently disabled or/and unfit to work", 
"In compulsory military or community service", 
"Fulfilling domestic tasks and care responsibilities", 
"Other inactive person")) 


PL031_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PL031_F, 
levels=c(1, 
-1), 
labels=c("Filled", 
"Missing")) 


PL040_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PL040, 
levels=c(1, 
2, 
3, 
4), 
labels=c("Self-employed with employees", 
"Self-employed without employees", 
"Employee", 
"Family worker")) 


PL040_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PL040_F, 
levels=c(1, 
-1, 
-2), 
labels=c("Filled", 
"Missing", 
"Not applicable (PL015 not equal to 1 and PL031 not equal to 1,2,3 or 4)")) 


PL051_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PL051, 
levels=c(1, 
2, 
3, 
11, 
12, 
13, 
14, 
21, 
22, 
23, 
24, 
25, 
26, 
31, 
32, 
33, 
34, 
35, 
41, 
42, 
43, 
44, 
51, 
52, 
53, 
54, 
61, 
62, 
63, 
71, 
72, 
73, 
74, 
75, 
81, 
82, 
83, 
91, 
92, 
93, 
94, 
95, 
96), 
labels=c("Commissioned Armed Forces Officers", 
"Non-commissioned Armed Forces Officers", 
"Armed Forces Occupations, Other Ranks", 
"Chief Executives, Senior Officials and Legislators", 
"Administrative and Commercial Managers", 
"Production and Specialized Services Managers", 
"Hospitality, Retail and Other Services Managers", 
"Science and Engineering Professionals", 
"Health Professionals", 
"Teaching Professionals", 
"Business and Administration Professionals", 
"Information and Communications Technology Professionals", 
"Legal, Social and Cultural Professionals", 
"Science and Engineering Associate Professionals", 
"Health Associate Professionals", 
"Business and Administration Associate Professionals", 
"Legal, Social, Cultural and Related Associate Professionals", 
"Information and Communications Technicians", 
"General and Keyboard Clerks", 
"Customer Services Clerks", 
"Numerical and Material Recording Clerks", 
"Other Clerical Support Workers", 
"Personal Services Workers", 
"Sales Workers", 
"Personal Care Workers", 
"Protective Services Workers", 
"Market-oriented Skilled Agricultural Workers", 
"Market-oriented Skilled Forestry, Fishery and Hunting Workers", 
"Subsistence Farmers, Fishers, Hunters and Gatherers", 
"Building and Related Trades Workers (excluding Electricians)", 
"Metal, Machinery and Related Trades Workers", 
"Handicraft and Printing Workers", 
"Electrical and Electronic Trades Workers", 
"Food Processing, Woodworking, Garment and Other Craft and Related Trades Workers", 
"Stationary Plant and Machine Operators", 
"Assemblers", 
"Drivers and Mobile Plant Operators", 
"Cleaners and Helpers", 
"Agricultural, Forestry and Fishery Labourers", 
"Labourers in Mining, Construction, Manufacturing and Transport", 
"Food Preparation Assistants", 
"Street and Related Sales and Services Workers", 
"Refuse Workers and Other Elementary Workers")) 


PL051_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PL051_F, 
levels=c(1, 
-1, 
-2), 
labels=c("Filled", 
"Missing", 
"Not applicable (PL031 not eq 1, 2, 3 or 4 and PL015 not eq 1)")) 


PL060_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PL060_F, 
levels=c(1, 
-1, 
-2, 
-6), 
labels=c("Filled", 
"Missing", 
"Not applicable (PL031 not eq 1, 2, 3 or 4)", 
"Hours varying (when an average for over four weeks is not possible)")) 


PL140_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PL140, 
levels=c(1, 
2), 
labels=c("Permanent job/work contract of unlimited duration", 
"Temporary job/work contract of limited duration")) 


PL140_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PL140_F, 
levels=c(1, 
-1, 
-2, 
-3, 
-4), 
labels=c("Filled", 
"Missing", 
"Not applicable (PL040 not equal to 3)", 
"Non-selected respondent", 
"Not applicable because the person is employee (PL040 eq 3) but does not have a contract")) 


PL160_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PL160, 
levels=c(1, 
2), 
labels=c("Yes", 
"No")) 


PL160_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PL160_F, 
levels=c(1, 
-1, 
-2, 
-3), 
labels=c("Filled", 
"Missing", 
"Not applicable (PL031 not equal to 1, 2, 3 or 4)", 
"Non-selected respondent")) 


PL170_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PL170, 
levels=c(1, 
2, 
3, 
4, 
5, 
6, 
7), 
labels=c("To take up or seek better job", 
"End of temporary contract", 
"Obliged to stop by employer (business closure, redundancy, early retirement, dismissal etc.)", 
"Sale or closure of own/family business", 
"Childcare and care for other dependents", 
"Partner¿s job required us to move to another area or marriage", 
"Other reasons")) 


PL170_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PL170_F, 
levels=c(1, 
-1, 
-2, 
-3), 
labels=c("Filled", 
"Missing", 
"Not applicable (PL160 not equal to 1)", 
"Non-selected respondent")) 


PL180_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PL180, 
levels=c(1, 
2, 
3, 
4, 
5, 
6, 
7, 
8, 
9, 
10, 
11, 
12), 
labels=c("Employed - unemployed", 
"Employed - retired", 
"Employed - other inactive", 
"Unemployed - employed", 
"Unemployed - retired", 
"Unemployed - other inactive", 
"Retired - employed", 
"Retired - unemployed", 
"Retired - other inactive", 
"Other inactive - employed", 
"Other inactive - unemployed", 
"Other inactive - retired")) 


PL180_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PL180_F, 
levels=c(1, 
-1, 
-2, 
-3), 
labels=c("Filled", 
"Missing", 
"Not applicable (no change since last year)", 
"Non-selected respondent")) 


PL190_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PL190_F, 
levels=c(1, 
-1, 
-2, 
-3), 
labels=c("Filled", 
"Missing", 
"Not applicable (person never worked i.e. (PL031 not equal to 1, 2, 3 or 4 AND PL015 not equal to 1))", 
"Non-selected respondent")) 


PL200_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PL200_F, 
levels=c(1, 
-1, 
-2, 
-3), 
labels=c("Filled", 
"Missing", 
"Not applicable (person never worked i.e. (PL031 not equal to 1, 2, 3 or 4 AND PL015 not equal to 1))", 
"Non-selected respondent")) 


PL211A_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PL211A, 
levels=c(1, 
2, 
3, 
4, 
5, 
6, 
7, 
8, 
9, 
10, 
11), 
labels=c("Employee working full-time", 
"Employee working part-time", 
"Self-employed working full-time (including family worker)", 
"Self-employed working part-time (including family worker)", 
"Unemployed", 
"Pupil, student, further training, unpaid work experience", 
"In retirement or in early retirement or has given up business", 
"Permanently disabled or/and unfit to work", 
"In compulsory military or community service", 
"Fulfilling domestic tasks and care responsibilities", 
"Other inactive person")) 


PL211A_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PL211A_F, 
levels=c(1, 
-1, 
-3), 
labels=c("Filled", 
"Missing", 
"Non-selected respondent")) 


PL211B_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PL211B, 
levels=c(1, 
2, 
3, 
4, 
5, 
6, 
7, 
8, 
9, 
10, 
11), 
labels=c("Employee working full-time", 
"Employee working part-time", 
"Self-employed working full-time (including family worker)", 
"Self-employed working part-time (including family worker)", 
"Unemployed", 
"Pupil, student, further training, unpaid work experience", 
"In retirement or in early retirement or has given up business", 
"Permanently disabled or/and unfit to work", 
"In compulsory military or community service", 
"Fulfilling domestic tasks and care responsibilities", 
"Other inactive person")) 


PL211B_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PL211B_F, 
levels=c(1, 
-1, 
-3), 
labels=c("Filled", 
"Missing", 
"Non-selected respondent")) 


PL211C_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PL211C, 
levels=c(1, 
2, 
3, 
4, 
5, 
6, 
7, 
8, 
9, 
10, 
11), 
labels=c("Employee working full-time", 
"Employee working part-time", 
"Self-employed working full-time (including family worker)", 
"Self-employed working part-time (including family worker)", 
"Unemployed", 
"Pupil, student, further training, unpaid work experience", 
"In retirement or in early retirement or has given up business", 
"Permanently disabled or/and unfit to work", 
"In compulsory military or community service", 
"Fulfilling domestic tasks and care responsibilities", 
"Other inactive person")) 


PL211C_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PL211C_F, 
levels=c(1, 
-1, 
-3), 
labels=c("Filled", 
"Missing", 
"Non-selected respondent")) 


PL211D_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PL211D, 
levels=c(1, 
2, 
3, 
4, 
5, 
6, 
7, 
8, 
9, 
10, 
11), 
labels=c("Employee working full-time", 
"Employee working part-time", 
"Self-employed working full-time (including family worker)", 
"Self-employed working part-time (including family worker)", 
"Unemployed", 
"Pupil, student, further training, unpaid work experience", 
"In retirement or in early retirement or has given up business", 
"Permanently disabled or/and unfit to work", 
"In compulsory military or community service", 
"Fulfilling domestic tasks and care responsibilities", 
"Other inactive person")) 


PL211D_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PL211D_F, 
levels=c(1, 
-1, 
-3), 
labels=c("Filled", 
"Missing", 
"Non-selected respondent")) 


PL211E_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PL211E, 
levels=c(1, 
2, 
3, 
4, 
5, 
6, 
7, 
8, 
9, 
10, 
11), 
labels=c("Employee working full-time", 
"Employee working part-time", 
"Self-employed working full-time (including family worker)", 
"Self-employed working part-time (including family worker)", 
"Unemployed", 
"Pupil, student, further training, unpaid work experience", 
"In retirement or in early retirement or has given up business", 
"Permanently disabled or/and unfit to work", 
"In compulsory military or community service", 
"Fulfilling domestic tasks and care responsibilities", 
"Other inactive person")) 


PL211E_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PL211E_F, 
levels=c(1, 
-1, 
-3), 
labels=c("Filled", 
"Missing", 
"Non-selected respondent")) 


PL211F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PL211F, 
levels=c(1, 
2, 
3, 
4, 
5, 
6, 
7, 
8, 
9, 
10, 
11), 
labels=c("Employee working full-time", 
"Employee working part-time", 
"Self-employed working full-time (including family worker)", 
"Self-employed working part-time (including family worker)", 
"Unemployed", 
"Pupil, student, further training, unpaid work experience", 
"In retirement or in early retirement or has given up business", 
"Permanently disabled or/and unfit to work", 
"In compulsory military or community service", 
"Fulfilling domestic tasks and care responsibilities", 
"Other inactive person")) 


PL211F_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PL211F_F, 
levels=c(1, 
-1, 
-3), 
labels=c("Filled", 
"Missing", 
"Non-selected respondent")) 


PL211G_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PL211G, 
levels=c(1, 
2, 
3, 
4, 
5, 
6, 
7, 
8, 
9, 
10, 
11), 
labels=c("Employee working full-time", 
"Employee working part-time", 
"Self-employed working full-time (including family worker)", 
"Self-employed working part-time (including family worker)", 
"Unemployed", 
"Pupil, student, further training, unpaid work experience", 
"In retirement or in early retirement or has given up business", 
"Permanently disabled or/and unfit to work", 
"In compulsory military or community service", 
"Fulfilling domestic tasks and care responsibilities", 
"Other inactive person")) 


PL211G_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PL211G_F, 
levels=c(1, 
-1, 
-3), 
labels=c("Filled", 
"Missing", 
"Non-selected respondent")) 


PL211H_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PL211H, 
levels=c(1, 
2, 
3, 
4, 
5, 
6, 
7, 
8, 
9, 
10, 
11), 
labels=c("Employee working full-time", 
"Employee working part-time", 
"Self-employed working full-time (including family worker)", 
"Self-employed working part-time (including family worker)", 
"Unemployed", 
"Pupil, student, further training, unpaid work experience", 
"In retirement or in early retirement or has given up business", 
"Permanently disabled or/and unfit to work", 
"In compulsory military or community service", 
"Fulfilling domestic tasks and care responsibilities", 
"Other inactive person")) 


PL211H_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PL211H_F, 
levels=c(1, 
-1, 
-3), 
labels=c("Filled", 
"Missing", 
"Non-selected respondent")) 


PL211I_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PL211I, 
levels=c(1, 
2, 
3, 
4, 
5, 
6, 
7, 
8, 
9, 
10, 
11), 
labels=c("Employee working full-time", 
"Employee working part-time", 
"Self-employed working full-time (including family worker)", 
"Self-employed working part-time (including family worker)", 
"Unemployed", 
"Pupil, student, further training, unpaid work experience", 
"In retirement or in early retirement or has given up business", 
"Permanently disabled or/and unfit to work", 
"In compulsory military or community service", 
"Fulfilling domestic tasks and care responsibilities", 
"Other inactive person")) 


PL211I_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PL211I_F, 
levels=c(1, 
-1, 
-3), 
labels=c("Filled", 
"Missing", 
"Non-selected respondent")) 


PL211J_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PL211J, 
levels=c(1, 
2, 
3, 
4, 
5, 
6, 
7, 
8, 
9, 
10, 
11), 
labels=c("Employee working full-time", 
"Employee working part-time", 
"Self-employed working full-time (including family worker)", 
"Self-employed working part-time (including family worker)", 
"Unemployed", 
"Pupil, student, further training, unpaid work experience", 
"In retirement or in early retirement or has given up business", 
"Permanently disabled or/and unfit to work", 
"In compulsory military or community service", 
"Fulfilling domestic tasks and care responsibilities", 
"Other inactive person")) 


PL211J_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PL211J_F, 
levels=c(1, 
-1, 
-3), 
labels=c("Filled", 
"Missing", 
"Non-selected respondent")) 


PL211K_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PL211K, 
levels=c(1, 
2, 
3, 
4, 
5, 
6, 
7, 
8, 
9, 
10, 
11), 
labels=c("Employee working full-time", 
"Employee working part-time", 
"Self-employed working full-time (including family worker)", 
"Self-employed working part-time (including family worker)", 
"Unemployed", 
"Pupil, student, further training, unpaid work experience", 
"In retirement or in early retirement or has given up business", 
"Permanently disabled or/and unfit to work", 
"In compulsory military or community service", 
"Fulfilling domestic tasks and care responsibilities", 
"Other inactive person")) 


PL211K_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PL211K_F, 
levels=c(1, 
-1, 
-3), 
labels=c("Filled", 
"Missing", 
"Non-selected respondent")) 


PL211L_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PL211L, 
levels=c(1, 
2, 
3, 
4, 
5, 
6, 
7, 
8, 
9, 
10, 
11), 
labels=c("Employee working full-time", 
"Employee working part-time", 
"Self-employed working full-time (including family worker)", 
"Self-employed working part-time (including family worker)", 
"Unemployed", 
"Pupil, student, further training, unpaid work experience", 
"In retirement or in early retirement or has given up business", 
"Permanently disabled or/and unfit to work", 
"In compulsory military or community service", 
"Fulfilling domestic tasks and care responsibilities", 
"Other inactive person")) 


PL211L_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PL211L_F, 
levels=c(1, 
-1, 
-3), 
labels=c("Filled", 
"Missing", 
"Non-selected respondent")) 


PY030G_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PY030G_F, 
levels=c(0, 
1, 
-1), 
labels=c("No income", 
"Income (variable is filled)", 
"Missing")) 


PY031G_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PY031G_F, 
levels=c(0, 
1, 
-1), 
labels=c("No income", 
"Income (variable is filled)", 
"Missing")) 


PY091G_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PY091G_F, 
levels=c(0, 
1, 
2, 
-1, 
-2, 
-7), 
labels=c("No income", 
"Filled with only Contributory and means-tested components", 
"Filled with mixed components", 
"Missing", 
"Not applicable (This scheme doesn't exist at national level)", 
"Not applicable (PB010 ne last year)")) 


PY092G_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PY092G_F, 
levels=c(0, 
1, 
2, 
-1, 
-2, 
-7), 
labels=c("No income", 
"Filled with only Contributory and non means-tested components", 
"Filled with mixed components", 
"Missing", 
"Not applicable (This scheme doesn't exist at national level)", 
"Not applicable (PB010 ne last year)")) 


PY093G_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PY093G_F, 
levels=c(0, 
1, 
2, 
-1, 
-2, 
-7), 
labels=c("No income", 
"Filled with only Non-contributory and means-tested components", 
"Filled with mixed components", 
"Missing", 
"Not applicable (This scheme doesn't exist at national level)", 
"Not applicable (PB010 ne last year)")) 


PY094G_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PY094G_F, 
levels=c(0, 
1, 
2, 
-1, 
-2, 
-7), 
labels=c("No income", 
"Filled with only Non-contributory and non means-tested components", 
"Filled with mixed components", 
"Missing", 
"Not applicable (This scheme doesn't exist at national level)", 
"Not applicable (PB010 ne last year)")) 


PY101G_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PY101G_F, 
levels=c(0, 
1, 
2, 
-1, 
-2, 
-7), 
labels=c("No income", 
"Filled with only Contributory and means-tested components", 
"Filled with mixed components", 
"Missing", 
"Not applicable (This scheme doesn't exist at national level)", 
"Not applicable (PB010 ne last year)")) 


PY102G_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PY102G_F, 
levels=c(0, 
1, 
2, 
-1, 
-2, 
-7), 
labels=c("No income", 
"Filled with only Contributory and non means-tested components", 
"Filled with mixed components", 
"Missing", 
"Not applicable (This scheme doesn't exist at national level)", 
"Not applicable (PB010 ne last year)")) 


PY103G_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PY103G_F, 
levels=c(0, 
1, 
2, 
-1, 
-2, 
-7), 
labels=c("No income", 
"Filled with only Non-contributory and means-tested components", 
"Filled with mixed components", 
"Missing", 
"Not applicable (This scheme doesn't exist at national level)", 
"Not applicable (PB010 ne last year)")) 


PY104G_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PY104G_F, 
levels=c(0, 
1, 
2, 
-1, 
-2, 
-7), 
labels=c("No income", 
"Filled with only Non-contributory and non means-tested components", 
"Filled with mixed components", 
"Missing", 
"Not applicable (This scheme doesn't exist at national level)", 
"Not applicable (PB010 ne last year)")) 


PY111G_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PY111G_F, 
levels=c(0, 
1, 
2, 
-1, 
-2, 
-7), 
labels=c("No income", 
"Filled with only Contributory and means-tested components", 
"Filled with mixed components", 
"Missing", 
"Not applicable (This scheme doesn't exist at national level)", 
"Not applicable (PB010 ne last year)")) 


PY112G_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PY112G_F, 
levels=c(0, 
1, 
2, 
-1, 
-2, 
-7), 
labels=c("No income", 
"Filled with only Contributory and non means-tested components", 
"Filled with mixed components", 
"Missing", 
"Not applicable (This scheme doesn't exist at national level)", 
"Not applicable (PB010 ne last year)")) 


PY113G_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PY113G_F, 
levels=c(0, 
1, 
2, 
-1, 
-2, 
-7), 
labels=c("No income", 
"Filled with only Non-contributory and means-tested components", 
"Filled with mixed components", 
"Missing", 
"Not applicable (This scheme doesn't exist at national level)", 
"Not applicable (PB010 ne last year)")) 


PY114G_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PY114G_F, 
levels=c(0, 
1, 
2, 
-1, 
-2, 
-7), 
labels=c("No income", 
"Filled with only Non-contributory and non means-tested components", 
"Filled with mixed components", 
"Missing", 
"Not applicable (This scheme doesn't exist at national level)", 
"Not applicable (PB010 ne last year)")) 


PY121G_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PY121G_F, 
levels=c(0, 
1, 
2, 
-1, 
-2, 
-7), 
labels=c("No income", 
"Filled with only Contributory and means-tested components", 
"Filled with mixed components", 
"Missing", 
"Not applicable (This scheme doesn't exist at national level)", 
"Not applicable (PB010 ne last year)")) 


PY122G_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PY122G_F, 
levels=c(0, 
1, 
2, 
-1, 
-2, 
-7), 
labels=c("No income", 
"Filled with only Contributory and non means-tested components", 
"Filled with mixed components", 
"Missing", 
"Not applicable (This scheme doesn't exist at national level)", 
"Not applicable (PB010 ne last year)")) 


PY123G_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PY123G_F, 
levels=c(0, 
1, 
2, 
-1, 
-2, 
-7), 
labels=c("No income", 
"Filled with only Non-contributory and means-tested components", 
"Filled with mixed components", 
"Missing", 
"Not applicable (This scheme doesn't exist at national level)", 
"Not applicable (PB010 ne last year)")) 


PY124G_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PY124G_F, 
levels=c(0, 
1, 
2, 
-1, 
-2, 
-7), 
labels=c("No income", 
"Filled with only Non-contributory and non means-tested components", 
"Filled with mixed components", 
"Missing", 
"Not applicable (This scheme doesn't exist at national level)", 
"Not applicable (PB010 ne last year)")) 


PY131G_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PY131G_F, 
levels=c(0, 
1, 
2, 
-1, 
-2, 
-7), 
labels=c("No income", 
"Filled with only Contributory and means-tested components", 
"Filled with mixed components", 
"Missing", 
"Not applicable (This scheme doesn't exist at national level)", 
"Not applicable (PB010 ne last year)")) 


PY132G_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PY132G_F, 
levels=c(0, 
1, 
2, 
-1, 
-2, 
-7), 
labels=c("No income", 
"Filled with only Contributory and non means-tested components", 
"Filled with mixed components", 
"Missing", 
"Not applicable (This scheme doesn't exist at national level)", 
"Not applicable (PB010 ne last year)")) 


PY133G_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PY133G_F, 
levels=c(0, 
1, 
2, 
-1, 
-2, 
-7), 
labels=c("No income", 
"Filled with only Non-contributory and means-tested components", 
"Filled with mixed components", 
"Missing", 
"Not applicable (This scheme doesn't exist at national level)", 
"Not applicable (PB010 ne last year)")) 


PY134G_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PY134G_F, 
levels=c(0, 
1, 
2, 
-1, 
-2, 
-7), 
labels=c("No income", 
"Filled with only Non-contributory and non means-tested components", 
"Filled with mixed components", 
"Missing", 
"Not applicable (This scheme doesn't exist at national level)", 
"Not applicable (PB010 ne last year)")) 


PY141G_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PY141G_F, 
levels=c(0, 
1, 
2, 
-1, 
-2, 
-7), 
labels=c("No income", 
"Filled with only Contributory and means-tested components", 
"Filled with mixed components", 
"Missing", 
"Not applicable (This scheme doesn't exist at national level)", 
"Not applicable (PB010 ne last year)")) 


PY142G_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PY142G_F, 
levels=c(0, 
1, 
2, 
-1, 
-2, 
-7), 
labels=c("No income", 
"Filled with only Contributory and non means-tested components", 
"Filled with mixed components", 
"Missing", 
"Not applicable (This scheme doesn't exist at national level)", 
"Not applicable (PB010 ne last year)")) 


PY143G_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PY143G_F, 
levels=c(0, 
1, 
2, 
-1, 
-2, 
-7), 
labels=c("No income", 
"Filled with only Non-contributory and means-tested components", 
"Filled with mixed components", 
"Missing", 
"Not applicable (This scheme doesn't exist at national level)", 
"Not applicable (PB010 ne last year)")) 


PY144G_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PY144G_F, 
levels=c(0, 
1, 
2, 
-1, 
-2, 
-7), 
labels=c("No income", 
"Filled with only Non-contributory and non means-tested components", 
"Filled with mixed components", 
"Missing", 
"Not applicable (This scheme doesn't exist at national level)", 
"Not applicable (PB010 ne last year)")) 


PD020_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PD020, 
levels=c(1, 
2, 
3), 
labels=c("Yes", 
"No - cannot afford it", 
"No - other reason")) 


PD020_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PD020_F, 
levels=c(1, 
-1, 
-3), 
labels=c("Filled", 
"Missing", 
"Not selected respondent")) 


PD030_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PD030, 
levels=c(1, 
2, 
3), 
labels=c("Yes", 
"No - cannot afford it", 
"No - other reason")) 


PD030_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PD030_F, 
levels=c(1, 
-1, 
-3), 
labels=c("Filled", 
"Missing", 
"Not selected respondent")) 


PD050_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PD050, 
levels=c(1, 
2, 
3), 
labels=c("Yes", 
"No - cannot afford it", 
"No - other reason")) 


PD050_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PD050_F, 
levels=c(1, 
-1, 
-3), 
labels=c("Filled", 
"Missing", 
"Not selected respondent")) 


PD060_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PD060, 
levels=c(1, 
2, 
3), 
labels=c("Yes", 
"No - cannot afford it", 
"No - other reason")) 


PD060_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PD060_F, 
levels=c(1, 
-1, 
-3), 
labels=c("Filled", 
"Missing", 
"Not selected respondent")) 


PD070_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PD070, 
levels=c(1, 
2, 
3), 
labels=c("Yes", 
"No - cannot afford it", 
"No - other reason")) 


PD070_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PD070_F, 
levels=c(1, 
-1, 
-3), 
labels=c("Filled", 
"Missing", 
"Not selected respondent")) 


PD080_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PD080, 
levels=c(1, 
2, 
3), 
labels=c("Yes", 
"No - cannot afford it", 
"No - other reason")) 


PD080_F_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PD080_F, 
levels=c(1, 
-1, 
-3), 
labels=c("Filled", 
"Missing", 
"Not selected respondent")) 


PX040_Fact <- factor(DF_EUSILC_Long_A2019_PERSONAL_D$PX040, 
levels=c(1, 
2, 
3, 
4), 
labels=c("Current household member aged 16 and over", 
"Selected respondent", 
"Non-selected respondent", 
"Ineligible person")) 

save.image (file="DF_EUSILC_Long_A2019_PERSONAL_D.RData")
