/* Declinazione di responsabilità. 
I file rilasciati in formato testo sono provvisti anche dei programmi di importazione per STATA, SAS e R. 
L'Istat non garantisce che le funzioni contenute nei suddetti programmi siano esenti da errore e non si assume alcuna responsabilità sull’output ottenuto dal loro utilizzo.                 */
%macro grabpath;
%qsubstr(%sysget(SAS_EXECFILEPATH),1,%length(%sysget(SAS_EXECFILEPATH))-%length(%sysget(SAS_EXECFILEname)))
%mend grabpath;
%let path = %grabpath;
%let nomeFile =ISTAT_MFR_EUSILC_Long_Microdata_2019_HOUSEHOLD_REGISTER_(D-FILE)_Longitudinal_FILE_STRUCTURE_EXAMPLE.txt;
LIBNAME ISTAT "&path";
DATA ISTAT.EUSILC_Long_A2019_HOUSEHOLD_REG;

INFILE "&path&nomeFile" DLM='09'x  LRECL=32767 TRUNCOVER FIRSTOBS=2 IGNOREDOSEOF;
INPUT 
DB010 :5.   /*  YEAR OF THE SURVEY */
DB020 : $3.   /*  COUNTRY */
DB030 :10.   /*  HOUSEHOLD ID */
DB040 : $5.   /*  REGION */
DB040_F :2.   /*  FLAG OF DB040 */
DB060 :4.   /*  PRIMARY SAMPLING UNITS (PSU) */
DB060_F :2.   /*  FLAG OF DB060 */
DB062 :5.   /*  SECONDARY SAMPLING UNITS (SSU) */
DB062_F :2.   /*  FLAG OF DB062 */
DB070 :5.   /*  ORDER OF SELECTION OF PSU */
DB070_F :3.   /*  FLAG OF DB070 */
DB075 :2.   /*  ROTATION GROUP */
DB075_F :2.   /*  FLAG OF DB075 */
DB095 :16.   /*  HOUSEHOLD LONGITUDINAL WEIGHT */
DB095_F :2.   /*  FLAG OF DB095 */
DB100 :2.   /*  DEGREE OF URBANISATION */
DB100_F :2.   /*  FLAG OF DB100 */
DB110 :3.   /*  HOUSEHOLD STATUS */
DB110_F :2.   /*  FLAG OF DB110 */
;
LABEL 
DB010 = "YEAR OF THE SURVEY"
DB020 = "COUNTRY"
DB030 = "HOUSEHOLD ID"
DB040 = "REGION"
DB040_F = "FLAG OF DB040"
DB060 = "PRIMARY SAMPLING UNITS (PSU)"
DB060_F = "FLAG OF DB060"
DB062 = "SECONDARY SAMPLING UNITS (SSU)"
DB062_F = "FLAG OF DB062"
DB070 = "ORDER OF SELECTION OF PSU"
DB070_F = "FLAG OF DB070"
DB075 = "ROTATION GROUP"
DB075_F = "FLAG OF DB075"
DB095 = "HOUSEHOLD LONGITUDINAL WEIGHT"
DB095_F = "FLAG OF DB095"
DB100 = "DEGREE OF URBANISATION"
DB100_F = "FLAG OF DB100"
DB110 = "HOUSEHOLD STATUS"
DB110_F = "FLAG OF DB110"
;
RUN;
PROC FORMAT;
VALUE $DB01F /* DB020 */
"AL" = "Albania"
"AT" = "Osterreich"
"BE" = "Belgique/Belgie"
"BG" = "Bulgaria"
"CH" = "Switzerland"
"CY" = "Cyprus"
"CZ" = "Czech Republic"
"DE" = "Deutschland"
"DK" = "Denmark"
"EE" = "Estonia"
"EL" = "Ellada"
"ES" = "Espana"
"FI" = "Suomi"
"FR" = "France"
"HR" = "Croatia"
"HU" = "Hungary"
"IE" = "Ireland"
"IS" = "Iceland"
"IT" = "Italia"
"LT" = "Lithuania"
"LU" = "Luxembourg"
"LV" = "Latvia"
"ME" = "Montenegro"
"MK" = "The Former Yugoslav Republic of Macedonia (FYROM)"
"MT" = "Malta"
"NL" = "Nederland"
"NO" = "Norway"
"PL" = "Poland"
"PT" = "Portugal"
"RO" = "Romania"
"RS" = "Serbia"
"SE" = "Sverige"
"SI" = "Slovenia"
"SK" = "Slovak Republic"
"TR" = "Turkey"
"UK" = "United Kingdom"
;
VALUE $DB03F /* DB040 */
"ITC" = "Northwest Italy"
"ITF" = "South Italy"
"ITG" = "Insular Italy"
"ITH" = "Northeast Italy"
"ITI" = "Central Italy"
;
VALUE DB04F /* DB040_F */
1= "Filled according to NUTS-10"
-1= "Missing"
;
VALUE DB06F /* DB060_F */
1= "Rotation is implemented at PSU level (the PSU rotates in and out of the sample)"
2= "Rotation is implemented at SSU or household level (The PSU remains in the sample for the entire duration of EUSILC)"
-2= "Not applicable (no first or second sampling stage)"
;
VALUE DB08F /* DB062_F */
1= "Rotation is implemented at PSU level (the PSU rotates in and out of the sample)"
2= "Rotation is implemented at SSU or household level (The PSU remains in the sample for the entire duration of EUSILC)"
-2= "Not applicable (no first or second sampling stage)"
;
VALUE DB010F /* DB070_F */
-2= "Not applicable (no systematic selection)"
;
VALUE DB012F /* DB075_F */
1= "Filled"
-2= "Not applicable (no rotational design used)"
;
VALUE DB014F /* DB095_F */
1= "Filled"
-2= "Not applicable (DB110 equal 9) and DB010 eq last year"
;
VALUE DB115F /* DB100 */
1= "Densely-populated area"
2= "Intermediate area"
3= "Thinly-populated area"
;
VALUE DB116F /* DB100_F */
1= "Filled"
-1= "Missing (allowed only from wave 2 onwards)"
;
VALUE DB117F /* DB110 */
1= "At the same address as last interview"
2= "Entire household moved to a private household within the country"
3= "Entire household moved to a collective household or institution within the country"
4= "Household moved outside the country"
5= "Entire household died"
6= "Household does not contain sample person"
7= "Household unable to access (due to for example climatic conditions)"
8= "Split-off household"
9= "New address added to the sample this wave or first wave"
10= "Fusion"
11= "Lost household (no information on record on what happened to the household)"
;
VALUE DB118F /* DB110_F */
1= "Filled"
;
format DB020 $DB01F.;
format DB040 $DB03F.;
format DB040_F DB04F.;
format DB060_F DB06F.;
format DB062_F DB08F.;
format DB070_F DB010F.;
format DB075_F DB012F.;
format DB095_F DB014F.;
format DB100 DB115F.;
format DB100_F DB116F.;
format DB110 DB117F.;
format DB110_F DB118F.;
RUN;
