#Declinazione di responsabilità. 
#I file rilasciati in formato testo sono provvisti anche dei programmi di importazione per STATA, SAS e R. 
#L'Istat non garantisce che le funzioni contenute nei suddetti programmi siano esenti da errore e non si assume alcuna responsabilità sull’output ottenuto dal loro utilizzo.  
setwd(choose.dir(default = "", caption = "WHERE ARE MICRODATA?"))
direttorio = getwd()
fileInput = paste (direttorio, "/ISTAT_MFR_EUSILC_Long_Microdata_2019_HOUSEHOLD_REGISTER_(D-FILE)_Longitudinal_FILE_STRUCTURE_EXAMPLE.txt", sep="")
DF_EUSILC_Long_A2019_HOUSEHOLD_<- read.delim2 (fileInput,  header=T, sep="	",  quote="",  na.strings = ".")
attr(DF_EUSILC_Long_A2019_HOUSEHOLD_, "label") <- c(
"YEAR OF THE SURVEY",
"COUNTRY",
"HOUSEHOLD ID",
"REGION",
"FLAG OF DB040",
"PRIMARY SAMPLING UNITS (PSU)",
"FLAG OF DB060",
"SECONDARY SAMPLING UNITS (SSU)",
"FLAG OF DB062",
"ORDER OF SELECTION OF PSU",
"FLAG OF DB070",
"ROTATION GROUP",
"FLAG OF DB075",
"HOUSEHOLD LONGITUDINAL WEIGHT",
"FLAG OF DB095",
"DEGREE OF URBANISATION",
"FLAG OF DB100",
"HOUSEHOLD STATUS",
"FLAG OF DB110")

DB020_Fact <- factor(DF_EUSILC_Long_A2019_HOUSEHOLD_$DB020, 
levels=c("AL", 
"AT", 
"BE", 
"BG", 
"CH", 
"CY", 
"CZ", 
"DE", 
"DK", 
"EE", 
"EL", 
"ES", 
"FI", 
"FR", 
"HR", 
"HU", 
"IE", 
"IS", 
"IT", 
"LT", 
"LU", 
"LV", 
"ME", 
"MK", 
"MT", 
"NL", 
"NO", 
"PL", 
"PT", 
"RO", 
"RS", 
"SE", 
"SI", 
"SK", 
"TR", 
"UK"), 
labels=c("Albania", 
"Osterreich", 
"Belgique/Belgie", 
"Bulgaria", 
"Switzerland", 
"Cyprus", 
"Czech Republic", 
"Deutschland", 
"Denmark", 
"Estonia", 
"Ellada", 
"Espana", 
"Suomi", 
"France", 
"Croatia", 
"Hungary", 
"Ireland", 
"Iceland", 
"Italia", 
"Lithuania", 
"Luxembourg", 
"Latvia", 
"Montenegro", 
"The Former Yugoslav Republic of Macedonia (FYROM)", 
"Malta", 
"Nederland", 
"Norway", 
"Poland", 
"Portugal", 
"Romania", 
"Serbia", 
"Sverige", 
"Slovenia", 
"Slovak Republic", 
"Turkey", 
"United Kingdom")) 


DB040_Fact <- factor(DF_EUSILC_Long_A2019_HOUSEHOLD_$DB040, 
levels=c("ITC", 
"ITF", 
"ITG", 
"ITH", 
"ITI"), 
labels=c("Northwest Italy", 
"South Italy", 
"Insular Italy", 
"Northeast Italy", 
"Central Italy")) 


DB040_F_Fact <- factor(DF_EUSILC_Long_A2019_HOUSEHOLD_$DB040_F, 
levels=c(1, 
-1), 
labels=c("Filled according to NUTS-10", 
"Missing")) 


DB060_F_Fact <- factor(DF_EUSILC_Long_A2019_HOUSEHOLD_$DB060_F, 
levels=c(1, 
2, 
-2), 
labels=c("Rotation is implemented at PSU level (the PSU rotates in and out of the sample)", 
"Rotation is implemented at SSU or household level (The PSU remains in the sample for the entire duration of EUSILC)", 
"Not applicable (no first or second sampling stage)")) 


DB062_F_Fact <- factor(DF_EUSILC_Long_A2019_HOUSEHOLD_$DB062_F, 
levels=c(1, 
2, 
-2), 
labels=c("Rotation is implemented at PSU level (the PSU rotates in and out of the sample)", 
"Rotation is implemented at SSU or household level (The PSU remains in the sample for the entire duration of EUSILC)", 
"Not applicable (no first or second sampling stage)")) 


DB070_F_Fact <- factor(DF_EUSILC_Long_A2019_HOUSEHOLD_$DB070_F, 
levels=c(-2), 
labels=c("Not applicable (no systematic selection)")) 


DB075_F_Fact <- factor(DF_EUSILC_Long_A2019_HOUSEHOLD_$DB075_F, 
levels=c(1, 
-2), 
labels=c("Filled", 
"Not applicable (no rotational design used)")) 


DB095_F_Fact <- factor(DF_EUSILC_Long_A2019_HOUSEHOLD_$DB095_F, 
levels=c(1, 
-2), 
labels=c("Filled", 
"Not applicable (DB110 equal 9) and DB010 eq last year")) 


DB100_Fact <- factor(DF_EUSILC_Long_A2019_HOUSEHOLD_$DB100, 
levels=c(1, 
2, 
3), 
labels=c("Densely-populated area", 
"Intermediate area", 
"Thinly-populated area")) 


DB100_F_Fact <- factor(DF_EUSILC_Long_A2019_HOUSEHOLD_$DB100_F, 
levels=c(1, 
-1), 
labels=c("Filled", 
"Missing (allowed only from wave 2 onwards)")) 


DB110_Fact <- factor(DF_EUSILC_Long_A2019_HOUSEHOLD_$DB110, 
levels=c(1, 
2, 
3, 
4, 
5, 
6, 
7, 
8, 
9, 
10, 
11), 
labels=c("At the same address as last interview", 
"Entire household moved to a private household within the country", 
"Entire household moved to a collective household or institution within the country", 
"Household moved outside the country", 
"Entire household died", 
"Household does not contain sample person", 
"Household unable to access (due to for example climatic conditions)", 
"Split-off household", 
"New address added to the sample this wave or first wave", 
"Fusion", 
"Lost household (no information on record on what happened to the household)")) 


DB110_F_Fact <- factor(DF_EUSILC_Long_A2019_HOUSEHOLD_$DB110_F, 
levels=c(1), 
labels=c("Filled")) 

save.image (file="DF_EUSILC_Long_A2019_HOUSEHOLD_.RData")
