/* Declinazione di responsabilità. 
I file rilasciati in formato testo sono provvisti anche dei programmi di importazione per STATA, SAS e R. 
L'Istat non garantisce che le funzioni contenute nei suddetti programmi siano esenti da errore e non si assume alcuna responsabilità sull’output ottenuto dal loro utilizzo.                 */
%macro grabpath;
%qsubstr(%sysget(SAS_EXECFILEPATH),1,%length(%sysget(SAS_EXECFILEPATH))-%length(%sysget(SAS_EXECFILEname)))
%mend grabpath;
%let path = %grabpath;
%let nomeFile =ISTAT_MFR_EUSILC_Long_Microdata_2019_HOUSEHOLD_DATA_(H-FILE)_Longitudinal_FILE_STRUCTURE_EXAMPLE.txt;
LIBNAME ISTAT "&path";
DATA ISTAT.EUSILC_Long_A2019_HOUSEHOLD_DAT;

INFILE "&path&nomeFile" DLM='09'x  LRECL=32767 TRUNCOVER FIRSTOBS=2 IGNOREDOSEOF;
INPUT 
HB010 :5.   /*  YEAR OF THE SURVEY */
HB020 : $3.   /*  COUNTRY */
HB030 :10.   /*  HOUSEHOLD ID */
HB050 :2.   /*  MONTH OF HOUSEHOLD INTERVIEW */
HB050_F :2.   /*  FLAG OF HB050 */
HB060 :5.   /*  YEAR OF HOUSEHOLD INTERVIEW */
HB060_F :2.   /*  FLAG OF HB060 */
HB070 :12.   /*  PERSON RESPONDING THE HOUSEHOLD QUESTIONNAIRE */
HB070_F :2.   /*  FLAG OF HB070 */
HB080 :12.   /*  PERSON 1 RESPONSIBLE FOR THE ACCOMMODATION */
HB080_F :2.   /*  FLAG OF HB080 */
HB090 :12.   /*  PERSON 2 RESPONSIBLE FOR THE ACCOMMODATION */
HB090_F :2.   /*  FLAG OF HB090 */
HB100 :3.   /*  NUMBER OF MINUTES TO COMPLETE THE HOUSEHOLD QUESTIONNAIRE */
HB100_F :2.   /*  FLAG OF HB100 */
HH010 :2.   /*  DWELLING TYPE */
HH010_F :2.   /*  FLAG OF HH010 */
HH021 :2.   /*  TENURE STATUS */
HH021_F :2.   /*  FLAG OF HH021 */
HH030 :2.   /*  NUMBER OF ROOMS AVAILABLE TO THE HOUSEHOLD */
HH030_F :2.   /*  FLAG OF HH030 */
HH031 :5.   /*  YEAR OF CONTRACT OR PURCHASING OR INSTALLATION */
HH031_F :2.   /*  FLAG OF HH031 */
HH040 :2.   /*  LEAKING ROOF, DAMP WALLS/FLOORS/FOUNDATION, OR ROT IN WINDOW FRAMES OR FLOOR */
HH040_F :2.   /*  FLAG OF HH040 */
HH050 :2.   /*  ABILITY TO KEEP HOME ADEQUATELY WARM */
HH050_F :2.   /*  FLAG OF HH050 */
HH060 :5.   /*  CURRENT RENT RELATED TO OCCUPIED DWELLING */
HH060_F :2.   /*  FLAG OF HH060 */
HH061 :5.   /*  SUBJECTIVE RENT */
HH061_F :2.   /*  FLAG OF HH061 */
HH081 :2.   /*  BATH OR SHOWER IN DWELLING */
HH081_F :2.   /*  FLAG OF HH081 */
HH091 :2.   /*  INDOOR FLUSHING TOILET FOR SOLE USE OF HOUSEHOLD */
HH091_F :2.   /*  FLAG OF HH091 */
HS011 :2.   /*  ARREARS ON MORTGAGE OR RENTAL PAYMENTS */
HS011_F :2.   /*  FLAG OF HS011 */
HS021 :2.   /*  ARREARS ON UTILITY BILLS */
HS021_F :2.   /*  FLAG OF HS021 */
HS031 :2.   /*  ARREARS ON HIRE PURCHASE INSTALLMENTS OR OTHER LOAN PAYMENTS */
HS031_F :2.   /*  FLAG OF HS031 */
HS040 :2.   /*  CAPACITY TO AFFORD PAYING FOR ONE WEEK ANNUAL HOLIDAY AWAY FROM HOME */
HS040_F :2.   /*  FLAG OF HS040 */
HS050 :2.   /*  CAPACITY TO AFFORD A MEAL WITH MEAT, CHICKEN, FISH (OR VEGETARIAN EQUIVALENT) EVERY SECOND DAY */
HS050_F :2.   /*  FLAG OF HS050 */
HS060 :2.   /*  CAPACITY TO FACE UNEXPECTED FINANCIAL EXPENSES */
HS060_F :2.   /*  FLAG OF HS060 */
HS070 :2.   /*  DO YOU HAVE A TELEPHONE (INCLUDING MOBILE PHONE)? */
HS070_F :2.   /*  FLAG OF HS070 */
HS080 :2.   /*  DO YOU HAVE A COLOUR TV? */
HS080_F :2.   /*  FLAG OF HS080 */
HS090 :2.   /*  DO YOU HAVE A COMPUTER? */
HS090_F :2.   /*  FLAG OF HS090 */
HS100 :2.   /*  DO YOU HAVE A WASHING MACHINE? */
HS100_F :2.   /*  FLAG OF HS100 */
HS110 :2.   /*  DO YOU HAVE A CAR? */
HS110_F :2.   /*  FLAG OF HS110 */
HS120 :2.   /*  ABILITY TO MAKE ENDS MEET */
HS120_F :2.   /*  FLAG OF HS120 */
HS130 :6.   /*  LOWEST MONTHLY INCOME TO MAKE ENDS MEET */
HS130_F :2.   /*  FLAG OF HS130 */
HS140 :2.   /*  FINANCIAL BURDEN OF THE TOTAL HOUSING COST */
HS140_F :2.   /*  FLAG OF HS140 */
HS150 :2.   /*  FINANCIAL BURDEN OF THE REPAYMENT OF DEBTS FROM HIRE PURCHASES OR LOANS */
HS150_F :2.   /*  FLAG OF HS150 */
HY010 :7.   /*  TOTAL HOUSEHOLD GROSS INCOME */
HY010_F :2.   /*  FLAG OF HY010 */
HY010_I :16.   /*  IMPUTATION FACTOR OF HY010 */
HY020 :7.   /*  TOTAL DISPOSABLE HOUSEHOLD INCOME */
HY020_F :2.   /*  FLAG OF HY020 */
HY020_I :16.   /*  IMPUTATION FACTOR OF HY020 */
HY022 :7.   /*  TOTAL DISPOSABLE HOUSEHOLD INCOME BEFORE SOCIAL TRANSFERS OTHER THAN OLD-AGE AND SURVIVOR'S BENEFITS */
HY022_F :2.   /*  FLAG OF HY022 */
HY022_I :16.   /*  IMPUTATION FACTOR OF HY022 */
HY023 :7.   /*  TOTAL DISPOSABLE HOUSEHOLD INCOME BEFORE SOCIAL TRANSFERS INCLUDING OLD-AGE AND SURVIVOR'S BENEFITS */
HY023_F :2.   /*  FLAG OF HY023 */
HY023_I :16.   /*  IMPUTATION FACTOR OF HY023 */
HY030N :7.   /*  IMPUTED RENT */
HY030N_F :2.   /*  FLAG OF HY030N */
HY040N :7.   /*  INCOME FROM RENTAL OF A PROPERTY OR LAND */
HY040N_F :2.   /*  FLAG OF HY040N */
HY040N_I :16.   /*  IMPUTATION FACTOR OF HY040N */
HY050N :7.   /*  FAMILY/CHILDREN-RELATED ALLOWANCES */
HY050N_F :2.   /*  FLAG OF HY050N */
HY050N_I :16.   /*  IMPUTATION FACTOR OF HY050N */
HY060N :7.   /*  SOCIAL EXCLUSION NOT ELSEWHERE CLASSIFIED */
HY060N_F :2.   /*  FLAG OF HY060N */
HY060N_I :16.   /*  IMPUTATION FACTOR OF HY060N */
HY070N :7.   /*  HOUSING ALLOWANCES */
HY070N_F :2.   /*  FLAG OF HY070N */
HY070N_I :16.   /*  IMPUTATION FACTOR OF HY070N */
HY080N :7.   /*  REGULAR INTER-HOUSEHOLD CASH TRANSFER RECEIVED */
HY080N_F :2.   /*  FLAG OF HY080N */
HY080N_I :16.   /*  IMPUTATION FACTOR OF HY080N */
HY081N :7.   /*  ALIMONIES RECEIVED (COMPULSORY + VOLUNTARY) */
HY081N_F :2.   /*  FLAG OF HY081N */
HY081N_I :16.   /*  IMPUTATION FACTOR OF HY081N */
HY090N :7.   /*  INTEREST, DIVIDENDS, PROFIT FROM CAPITAL INVESTMENTS IN UNINCORPORATED BUSINESS */
HY090N_F :2.   /*  FLAG OF HY090N */
HY090N_I :16.   /*  IMPUTATION FACTOR OF HY090N */
HY100N :7.   /*  INTEREST REPAYMENTS ON MORTGAGE */
HY100N_F :2.   /*  FLAG OF HY100N */
HY100N_I :16.   /*  IMPUTATION FACTOR OF HY100N */
HY110N :7.   /*  INCOME RECEIVED BY PEOPLE AGED UNDER 16 */
HY110N_F :2.   /*  FLAG OF HY110N */
HY110N_I :16.   /*  IMPUTATION FACTOR OF HY110N */
HY120N :7.   /*  REGULAR TAXES ON WEALTH */
HY120N_F :2.   /*  FLAG OF HY120N */
HY120N_I :16.   /*  IMPUTATION FACTOR OF HY120N */
HY130N :7.   /*  REGULAR INTER-HOUSEHOLD CASH TRANSFER PAID */
HY130N_F :2.   /*  FLAG OF HY130N */
HY130N_I :16.   /*  IMPUTATION FACTOR OF HY130N */
HY131N :7.   /*  ALIMONIES PAID (COMPULSORY + VOLUNTARY) */
HY131N_F :2.   /*  FLAG OF HY131N */
HY131N_I :16.   /*  IMPUTATION FACTOR OF HY131N */
HY140N :7.   /*  TAX ON INCOME AND SOCIAL CONTRIBUTIONS */
HY140N_F :2.   /*  FLAG OF HY140N */
HY140N_I :16.   /*  IMPUTATION FACTOR OF HY140N */
HY145N :7.   /*  REPAYMENTS/RECEIPTS FOR TAX ADJUSTMENT */
HY145N_F :2.   /*  FLAG OF HY145N */
HY145N_I :16.   /*  IMPUTATION FACTOR OF HY145N */
HY170N :7.   /*  VALUE OF GOODS PRODUCED FOR OWN CONSUMPTION */
HY170N_F :2.   /*  FLAG OF HY170N */
HY170N_I :16.   /*  IMPUTATION FACTOR OF HY170N */
HY030G :7.   /*  IMPUTED RENT */
HY030G_F :2.   /*  FLAG OF HY030G */
HY040G :7.   /*  INCOME FROM RENTAL OF A PROPERTY OR LAND */
HY040G_F :2.   /*  FLAG OF HY040G */
HY040G_I :16.   /*  IMPUTATION FACTOR OF HY040G */
HY050G :7.   /*  FAMILY/CHILDREN-RELATED ALLOWANCES */
HY050G_F :2.   /*  FLAG OF HY050G */
HY050G_I :16.   /*  IMPUTATION FACTOR OF HY050G */
HY051G :7.   /*  FAMILY/CHILDREN-RELATED ALLOWANCES (CONTRIBUTORY AND MEANS-TESTED) */
HY051G_F :2.   /*  FLAG OF HY051G */
HY052G :7.   /*  FAMILY/CHILDREN-RELATED ALLOWANCES (CONTRIBUTORY AND NON MEANS-TESTED) */
HY052G_F :2.   /*  FLAG OF HY052G */
HY053G :7.   /*  FAMILY/CHILDREN-RELATED ALLOWANCES (NON-CONTRIBUTORY AND MEANS-TESTED) */
HY053G_F :2.   /*  FLAG OF HY053G */
HY054G :7.   /*  FAMILY/CHILDREN-RELATED ALLOWANCES (NON-CONTRIBUTORY AND NON MEANS-TESTED) */
HY054G_F :2.   /*  FLAG OF HY054G */
HY060G :7.   /*  SOCIAL EXCLUSION NOT ELSEWHERE CLASSIFIED */
HY060G_F :2.   /*  FLAG OF HY060G */
HY060G_I :16.   /*  IMPUTATION FACTOR OF HY060G */
HY061G :7.   /*  SOCIAL EXCLUSION NOT ELSEWHERE CLASSIFIED (CONTRIBUTORY AND MEANS-TESTED) */
HY061G_F :2.   /*  FLAG OF HY061G */
HY062G :7.   /*  SOCIAL EXCLUSION NOT ELSEWHERE CLASSIFIED (CONTRIBUTORY AND NON MEANS-TESTED) */
HY062G_F :2.   /*  FLAG OF HY062G */
HY063G :7.   /*  SOCIAL EXCLUSION NOT ELSEWHERE CLASSIFIED (NON-CONTRIBUTORY AND MEANS-TESTED) */
HY063G_F :2.   /*  FLAG OF HY063G */
HY064G :7.   /*  SOCIAL EXCLUSION NOT ELSEWHERE CLASSIFIED (NON-CONTRIBUTORY AND NON MEANS-TESTED) */
HY064G_F :2.   /*  FLAG OF HY064G */
HY070G :7.   /*  HOUSING ALLOWANCES */
HY070G_F :2.   /*  FLAG OF HY070G */
HY070G_I :16.   /*  IMPUTATION FACTOR OF HY070G */
HY071G :7.   /*  HOUSING ALLOWANCES (CONTRIBUTORY AND MEANS-TESTED) */
HY071G_F :2.   /*  FLAG OF HY071G */
HY072G :7.   /*  HOUSING ALLOWANCES (CONTRIBUTORY AND NON MEANS-TESTED) */
HY072G_F :2.   /*  FLAG OF HY072G */
HY073G :7.   /*  HOUSING ALLOWANCES (NON-CONTRIBUTORY AND MEANS-TESTED) */
HY073G_F :2.   /*  FLAG OF HY073G */
HY074G :7.   /*  HOUSING ALLOWANCES (NON-CONTRIBUTORY AND NON MEANS-TESTED) */
HY074G_F :2.   /*  FLAG OF HY074G */
HY080G :7.   /*  REGULAR INTER-HOUSEHOLD CASH TRANSFER RECEIVED */
HY080G_F :2.   /*  FLAG OF HY080G */
HY080G_I :16.   /*  IMPUTATION FACTOR OF HY080G */
HY081G :7.   /*  ALIMONIES RECEIVED (COMPULSORY + VOLUNTARY) */
HY081G_F :2.   /*  FLAG OF HY081G */
HY081G_I :16.   /*  IMPUTATION FACTOR OF HY081G */
HY090G :7.   /*  INTEREST, DIVIDENDS, PROFIT FROM CAPITAL INVESTMENTS IN UNINCORPORATED BUSINESS */
HY090G_F :2.   /*  FLAG OF HY090G */
HY090G_I :16.   /*  IMPUTATION FACTOR OF HY090G */
HY100G :7.   /*  INTEREST REPAYMENTS ON MORTGAGE */
HY100G_F :2.   /*  FLAG OF HY100G */
HY100G_I :16.   /*  IMPUTATION FACTOR OF HY100G */
HY110G :7.   /*  INCOME RECEIVED BY PEOPLE AGED UNDER 16 */
HY110G_F :2.   /*  FLAG OF HY110G */
HY110G_I :16.   /*  IMPUTATION FACTOR OF HY110G */
HY120G :7.   /*  REGULAR TAXES ON WEALTH */
HY120G_F :2.   /*  FLAG OF HY120G */
HY120G_I :16.   /*  IMPUTATION FACTOR OF HY120G */
HY130G :7.   /*  REGULAR INTER-HOUSEHOLD CASH TRANSFER PAID */
HY130G_F :2.   /*  FLAG OF HY130G */
HY130G_I :16.   /*  IMPUTATION FACTOR OF HY130G */
HY131G :7.   /*  ALIMONIES PAID (COMPULSORY + VOLUNTARY) */
HY131G_F :2.   /*  FLAG OF HY131G */
HY131G_I :16.   /*  IMPUTATION FACTOR OF HY131G */
HY140G :7.   /*  TAX ON INCOME AND SOCIAL CONTRIBUTIONS */
HY140G_F :2.   /*  FLAG OF HY140G */
HY140G_I :16.   /*  IMPUTATION FACTOR OF HY140G */
HY170G :7.   /*  VALUE OF GOODS PRODUCED FOR OWN CONSUMPTION */
HY170G_F :2.   /*  FLAG OF HY170G */
HY170G_I :16.   /*  IMPUTATION FACTOR OF HY170G */
HD080 :2.   /*  REPLACING WORN-OUT FURNITURE */
HD080_F :2.   /*  FLAG OF HD080 */
HX010 :2.   /*  CHANGE RATE */
HX040 :3.   /*  HOUSEHOLD SIZE */
HX050 :16.   /*  EQUIVALISED HOUSEHOLD SIZE */
HX090 :18.   /*  EQUIVALISED DISPOSABLE INCOME */
HX100 :2.   /*  EQUIVALISED DISPOSABLE INCOME QUINTILE */
;
LABEL 
HB010 = "YEAR OF THE SURVEY"
HB020 = "COUNTRY"
HB030 = "HOUSEHOLD ID"
HB050 = "MONTH OF HOUSEHOLD INTERVIEW"
HB050_F = "FLAG OF HB050"
HB060 = "YEAR OF HOUSEHOLD INTERVIEW"
HB060_F = "FLAG OF HB060"
HB070 = "PERSON RESPONDING THE HOUSEHOLD QUESTIONNAIRE"
HB070_F = "FLAG OF HB070"
HB080 = "PERSON 1 RESPONSIBLE FOR THE ACCOMMODATION"
HB080_F = "FLAG OF HB080"
HB090 = "PERSON 2 RESPONSIBLE FOR THE ACCOMMODATION"
HB090_F = "FLAG OF HB090"
HB100 = "NUMBER OF MINUTES TO COMPLETE THE HOUSEHOLD QUESTIONNAIRE"
HB100_F = "FLAG OF HB100"
HH010 = "DWELLING TYPE"
HH010_F = "FLAG OF HH010"
HH021 = "TENURE STATUS"
HH021_F = "FLAG OF HH021"
HH030 = "NUMBER OF ROOMS AVAILABLE TO THE HOUSEHOLD"
HH030_F = "FLAG OF HH030"
HH031 = "YEAR OF CONTRACT OR PURCHASING OR INSTALLATION"
HH031_F = "FLAG OF HH031"
HH040 = "LEAKING ROOF, DAMP WALLS/FLOORS/FOUNDATION, OR ROT IN WINDOW FRAMES OR FLOOR"
HH040_F = "FLAG OF HH040"
HH050 = "ABILITY TO KEEP HOME ADEQUATELY WARM"
HH050_F = "FLAG OF HH050"
HH060 = "CURRENT RENT RELATED TO OCCUPIED DWELLING"
HH060_F = "FLAG OF HH060"
HH061 = "SUBJECTIVE RENT"
HH061_F = "FLAG OF HH061"
HH081 = "BATH OR SHOWER IN DWELLING"
HH081_F = "FLAG OF HH081"
HH091 = "INDOOR FLUSHING TOILET FOR SOLE USE OF HOUSEHOLD"
HH091_F = "FLAG OF HH091"
HS011 = "ARREARS ON MORTGAGE OR RENTAL PAYMENTS"
HS011_F = "FLAG OF HS011"
HS021 = "ARREARS ON UTILITY BILLS"
HS021_F = "FLAG OF HS021"
HS031 = "ARREARS ON HIRE PURCHASE INSTALLMENTS OR OTHER LOAN PAYMENTS"
HS031_F = "FLAG OF HS031"
HS040 = "CAPACITY TO AFFORD PAYING FOR ONE WEEK ANNUAL HOLIDAY AWAY FROM HOME"
HS040_F = "FLAG OF HS040"
HS050 = "CAPACITY TO AFFORD A MEAL WITH MEAT, CHICKEN, FISH (OR VEGETARIAN EQUIVALENT) EVERY SECOND DAY"
HS050_F = "FLAG OF HS050"
HS060 = "CAPACITY TO FACE UNEXPECTED FINANCIAL EXPENSES"
HS060_F = "FLAG OF HS060"
HS070 = "DO YOU HAVE A TELEPHONE (INCLUDING MOBILE PHONE)?"
HS070_F = "FLAG OF HS070"
HS080 = "DO YOU HAVE A COLOUR TV?"
HS080_F = "FLAG OF HS080"
HS090 = "DO YOU HAVE A COMPUTER?"
HS090_F = "FLAG OF HS090"
HS100 = "DO YOU HAVE A WASHING MACHINE?"
HS100_F = "FLAG OF HS100"
HS110 = "DO YOU HAVE A CAR?"
HS110_F = "FLAG OF HS110"
HS120 = "ABILITY TO MAKE ENDS MEET"
HS120_F = "FLAG OF HS120"
HS130 = "LOWEST MONTHLY INCOME TO MAKE ENDS MEET"
HS130_F = "FLAG OF HS130"
HS140 = "FINANCIAL BURDEN OF THE TOTAL HOUSING COST"
HS140_F = "FLAG OF HS140"
HS150 = "FINANCIAL BURDEN OF THE REPAYMENT OF DEBTS FROM HIRE PURCHASES OR LOANS"
HS150_F = "FLAG OF HS150"
HY010 = "TOTAL HOUSEHOLD GROSS INCOME"
HY010_F = "FLAG OF HY010"
HY010_I = "IMPUTATION FACTOR OF HY010"
HY020 = "TOTAL DISPOSABLE HOUSEHOLD INCOME"
HY020_F = "FLAG OF HY020"
HY020_I = "IMPUTATION FACTOR OF HY020"
HY022 = "TOTAL DISPOSABLE HOUSEHOLD INCOME BEFORE SOCIAL TRANSFERS OTHER THAN OLD-AGE AND SURVIVOR'S BENEFITS"
HY022_F = "FLAG OF HY022"
HY022_I = "IMPUTATION FACTOR OF HY022"
HY023 = "TOTAL DISPOSABLE HOUSEHOLD INCOME BEFORE SOCIAL TRANSFERS INCLUDING OLD-AGE AND SURVIVOR'S BENEFITS"
HY023_F = "FLAG OF HY023"
HY023_I = "IMPUTATION FACTOR OF HY023"
HY030N = "IMPUTED RENT"
HY030N_F = "FLAG OF HY030N"
HY040N = "INCOME FROM RENTAL OF A PROPERTY OR LAND"
HY040N_F = "FLAG OF HY040N"
HY040N_I = "IMPUTATION FACTOR OF HY040N"
HY050N = "FAMILY/CHILDREN-RELATED ALLOWANCES"
HY050N_F = "FLAG OF HY050N"
HY050N_I = "IMPUTATION FACTOR OF HY050N"
HY060N = "SOCIAL EXCLUSION NOT ELSEWHERE CLASSIFIED"
HY060N_F = "FLAG OF HY060N"
HY060N_I = "IMPUTATION FACTOR OF HY060N"
HY070N = "HOUSING ALLOWANCES"
HY070N_F = "FLAG OF HY070N"
HY070N_I = "IMPUTATION FACTOR OF HY070N"
HY080N = "REGULAR INTER-HOUSEHOLD CASH TRANSFER RECEIVED"
HY080N_F = "FLAG OF HY080N"
HY080N_I = "IMPUTATION FACTOR OF HY080N"
HY081N = "ALIMONIES RECEIVED (COMPULSORY + VOLUNTARY)"
HY081N_F = "FLAG OF HY081N"
HY081N_I = "IMPUTATION FACTOR OF HY081N"
HY090N = "INTEREST, DIVIDENDS, PROFIT FROM CAPITAL INVESTMENTS IN UNINCORPORATED BUSINESS"
HY090N_F = "FLAG OF HY090N"
HY090N_I = "IMPUTATION FACTOR OF HY090N"
HY100N = "INTEREST REPAYMENTS ON MORTGAGE"
HY100N_F = "FLAG OF HY100N"
HY100N_I = "IMPUTATION FACTOR OF HY100N"
HY110N = "INCOME RECEIVED BY PEOPLE AGED UNDER 16"
HY110N_F = "FLAG OF HY110N"
HY110N_I = "IMPUTATION FACTOR OF HY110N"
HY120N = "REGULAR TAXES ON WEALTH"
HY120N_F = "FLAG OF HY120N"
HY120N_I = "IMPUTATION FACTOR OF HY120N"
HY130N = "REGULAR INTER-HOUSEHOLD CASH TRANSFER PAID"
HY130N_F = "FLAG OF HY130N"
HY130N_I = "IMPUTATION FACTOR OF HY130N"
HY131N = "ALIMONIES PAID (COMPULSORY + VOLUNTARY)"
HY131N_F = "FLAG OF HY131N"
HY131N_I = "IMPUTATION FACTOR OF HY131N"
HY140N = "TAX ON INCOME AND SOCIAL CONTRIBUTIONS"
HY140N_F = "FLAG OF HY140N"
HY140N_I = "IMPUTATION FACTOR OF HY140N"
HY145N = "REPAYMENTS/RECEIPTS FOR TAX ADJUSTMENT"
HY145N_F = "FLAG OF HY145N"
HY145N_I = "IMPUTATION FACTOR OF HY145N"
HY170N = "VALUE OF GOODS PRODUCED FOR OWN CONSUMPTION"
HY170N_F = "FLAG OF HY170N"
HY170N_I = "IMPUTATION FACTOR OF HY170N"
HY030G = "IMPUTED RENT"
HY030G_F = "FLAG OF HY030G"
HY040G = "INCOME FROM RENTAL OF A PROPERTY OR LAND"
HY040G_F = "FLAG OF HY040G"
HY040G_I = "IMPUTATION FACTOR OF HY040G"
HY050G = "FAMILY/CHILDREN-RELATED ALLOWANCES"
HY050G_F = "FLAG OF HY050G"
HY050G_I = "IMPUTATION FACTOR OF HY050G"
HY051G = "FAMILY/CHILDREN-RELATED ALLOWANCES (CONTRIBUTORY AND MEANS-TESTED)"
HY051G_F = "FLAG OF HY051G"
HY052G = "FAMILY/CHILDREN-RELATED ALLOWANCES (CONTRIBUTORY AND NON MEANS-TESTED)"
HY052G_F = "FLAG OF HY052G"
HY053G = "FAMILY/CHILDREN-RELATED ALLOWANCES (NON-CONTRIBUTORY AND MEANS-TESTED)"
HY053G_F = "FLAG OF HY053G"
HY054G = "FAMILY/CHILDREN-RELATED ALLOWANCES (NON-CONTRIBUTORY AND NON MEANS-TESTED)"
HY054G_F = "FLAG OF HY054G"
HY060G = "SOCIAL EXCLUSION NOT ELSEWHERE CLASSIFIED"
HY060G_F = "FLAG OF HY060G"
HY060G_I = "IMPUTATION FACTOR OF HY060G"
HY061G = "SOCIAL EXCLUSION NOT ELSEWHERE CLASSIFIED (CONTRIBUTORY AND MEANS-TESTED)"
HY061G_F = "FLAG OF HY061G"
HY062G = "SOCIAL EXCLUSION NOT ELSEWHERE CLASSIFIED (CONTRIBUTORY AND NON MEANS-TESTED)"
HY062G_F = "FLAG OF HY062G"
HY063G = "SOCIAL EXCLUSION NOT ELSEWHERE CLASSIFIED (NON-CONTRIBUTORY AND MEANS-TESTED)"
HY063G_F = "FLAG OF HY063G"
HY064G = "SOCIAL EXCLUSION NOT ELSEWHERE CLASSIFIED (NON-CONTRIBUTORY AND NON MEANS-TESTED)"
HY064G_F = "FLAG OF HY064G"
HY070G = "HOUSING ALLOWANCES"
HY070G_F = "FLAG OF HY070G"
HY070G_I = "IMPUTATION FACTOR OF HY070G"
HY071G = "HOUSING ALLOWANCES (CONTRIBUTORY AND MEANS-TESTED)"
HY071G_F = "FLAG OF HY071G"
HY072G = "HOUSING ALLOWANCES (CONTRIBUTORY AND NON MEANS-TESTED)"
HY072G_F = "FLAG OF HY072G"
HY073G = "HOUSING ALLOWANCES (NON-CONTRIBUTORY AND MEANS-TESTED)"
HY073G_F = "FLAG OF HY073G"
HY074G = "HOUSING ALLOWANCES (NON-CONTRIBUTORY AND NON MEANS-TESTED)"
HY074G_F = "FLAG OF HY074G"
HY080G = "REGULAR INTER-HOUSEHOLD CASH TRANSFER RECEIVED"
HY080G_F = "FLAG OF HY080G"
HY080G_I = "IMPUTATION FACTOR OF HY080G"
HY081G = "ALIMONIES RECEIVED (COMPULSORY + VOLUNTARY)"
HY081G_F = "FLAG OF HY081G"
HY081G_I = "IMPUTATION FACTOR OF HY081G"
HY090G = "INTEREST, DIVIDENDS, PROFIT FROM CAPITAL INVESTMENTS IN UNINCORPORATED BUSINESS"
HY090G_F = "FLAG OF HY090G"
HY090G_I = "IMPUTATION FACTOR OF HY090G"
HY100G = "INTEREST REPAYMENTS ON MORTGAGE"
HY100G_F = "FLAG OF HY100G"
HY100G_I = "IMPUTATION FACTOR OF HY100G"
HY110G = "INCOME RECEIVED BY PEOPLE AGED UNDER 16"
HY110G_F = "FLAG OF HY110G"
HY110G_I = "IMPUTATION FACTOR OF HY110G"
HY120G = "REGULAR TAXES ON WEALTH"
HY120G_F = "FLAG OF HY120G"
HY120G_I = "IMPUTATION FACTOR OF HY120G"
HY130G = "REGULAR INTER-HOUSEHOLD CASH TRANSFER PAID"
HY130G_F = "FLAG OF HY130G"
HY130G_I = "IMPUTATION FACTOR OF HY130G"
HY131G = "ALIMONIES PAID (COMPULSORY + VOLUNTARY)"
HY131G_F = "FLAG OF HY131G"
HY131G_I = "IMPUTATION FACTOR OF HY131G"
HY140G = "TAX ON INCOME AND SOCIAL CONTRIBUTIONS"
HY140G_F = "FLAG OF HY140G"
HY140G_I = "IMPUTATION FACTOR OF HY140G"
HY170G = "VALUE OF GOODS PRODUCED FOR OWN CONSUMPTION"
HY170G_F = "FLAG OF HY170G"
HY170G_I = "IMPUTATION FACTOR OF HY170G"
HD080 = "REPLACING WORN-OUT FURNITURE"
HD080_F = "FLAG OF HD080"
HX010 = "CHANGE RATE"
HX040 = "HOUSEHOLD SIZE"
HX050 = "EQUIVALISED HOUSEHOLD SIZE"
HX090 = "EQUIVALISED DISPOSABLE INCOME"
HX100 = "EQUIVALISED DISPOSABLE INCOME QUINTILE"
;
RUN;
PROC FORMAT;
VALUE $HB01F /* HB020 */
"AL" = "Albania"
"AT" = "Osterreich"
"BE" = "Belgique/Belgie"
"BG" = "Bulgaria"
"CH" = "Switzerland"
"CY" = "Cyprus"
"CZ" = "Czech Republic"
"DE" = "Deutschland"
"DK" = "Denmark"
"EE" = "Estonia"
"EL" = "Ellada"
"ES" = "Espana"
"FI" = "Suomi"
"FR" = "France"
"HR" = "Croatia"
"HU" = "Hungary"
"IE" = "Ireland"
"IS" = "Iceland"
"IT" = "Italia"
"LT" = "Lithuania"
"LU" = "Luxembourg"
"LV" = "Latvia"
"ME" = "Montenegro"
"MK" = "The Former Yugoslav Republic of Macedonia (FYROM)"
"MT" = "Malta"
"NL" = "Nederland"
"NO" = "Norway"
"PL" = "Poland"
"PT" = "Portugal"
"RO" = "Romania"
"RS" = "Serbia"
"SE" = "Sverige"
"SI" = "Slovenia"
"SK" = "Slovak Republic"
"TR" = "Turkey"
"UK" = "United Kingdom"
;
VALUE HB03F /* HB050 */
1= "January-March"
2= "April-June"
3= "July-September"
4= "October-December"
;
VALUE HB04F /* HB050_F */
1= "Filled"
-1= "Missing"
;
VALUE HB06F /* HB060_F */
1= "Filled"
;
VALUE HB08F /* HB070_F */
1= "Filled"
-1= "Missing"
;
VALUE HB010F /* HB080_F */
1= "Filled"
-1= "Missing"
;
VALUE HB012F /* HB090_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable (no second person responsible for the accommodation)"
;
VALUE HB114F /* HB100_F */
1= "Filled"
-1= "Missing"
;
VALUE HH015F /* HH010 */
1= "Detached house"
2= "Semi-detached or terraced house"
3= "Apartment or flat in a building with less than 10 dwellings"
4= "Apartment or flat in a building with 10 or more dwellings"
;
VALUE HH016F /* HH010_F */
1= "Filled"
-1= "Missing"
;
VALUE HH017F /* HH021 */
1= "Outright owner"
2= "Owner paying mortgage"
3= "Tenant or subtenant paying rent at prevailing or market rate"
4= "Accommodation is rented at a reduced rate (lower price that the market price)"
5= "Accommodation is provided free"
;
VALUE HH018F /* HH021_F */
1= "Filled"
-1= "Missing"
;
VALUE HH019F /* HH030 */
1= "1 room"
2= "2 rooms"
3= "3 rooms"
4= "4 rooms"
5= "5 rooms"
6= "6 or more rooms"
;
VALUE HH020F /* HH030_F */
1= "Filled"
-1= "Missing"
;
VALUE HH022F /* HH031_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable (MS using objective national methods to calculate imputed rent)"
;
VALUE HH023F /* HH040 */
1= "Yes"
2= "No"
;
VALUE HH024F /* HH040_F */
1= "Filled"
-1= "Missing"
;
VALUE HH025F /* HH050 */
1= "Yes"
2= "No"
;
VALUE HH026F /* HH050_F */
1= "Filled"
-1= "Missing"
;
VALUE HH028F /* HH060_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable (HH021 not equal to 3 or 4)"
;
VALUE HH030F /* HH061_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable (HH021 eq 3) or (MS do not use subjective method to calculate imputed rent)"
;
VALUE HH031F /* HH081 */
1= "Yes, for sole use of the household"
2= "Yes, shared"
3= "No"
;
VALUE HH032F /* HH081_F */
1= "Filled"
-1= "Missing"
;
VALUE HH033F /* HH091 */
1= "Yes, for sole use of the household"
2= "Yes, shared"
3= "No"
;
VALUE HH034F /* HH091_F */
1= "Filled"
-1= "Missing"
;
VALUE HS035F /* HS011 */
1= "Yes, once"
2= "Yes, twice or more"
3= "No"
;
VALUE HS036F /* HS011_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable (outright owner or rent free during the last 12 months)"
;
VALUE HS037F /* HS021 */
1= "Yes, once"
2= "Yes, twice or more"
3= "No"
;
VALUE HS038F /* HS021_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable (no utility bills)"
;
VALUE HS039F /* HS031 */
1= "Yes, once"
2= "Yes, twice or more"
3= "No"
;
VALUE HS040F /* HS031_F */
1= "Filled"
-1= "Missing"
-2= "Not applicable (no hire purchase instalments and no other loan payments)"
;
VALUE HS041F /* HS040 */
1= "Yes"
2= "No"
;
VALUE HS042F /* HS040_F */
1= "Filled"
-1= "Missing"
;
VALUE HS043F /* HS050 */
1= "Yes"
2= "No"
;
VALUE HS044F /* HS050_F */
1= "Filled"
-1= "Missing"
;
VALUE HS045F /* HS060 */
1= "Yes"
2= "No"
;
VALUE HS046F /* HS060_F */
1= "Filled"
-1= "Missing"
;
VALUE HS047F /* HS070 */
1= "Yes"
2= "No ¿ cannot afford"
3= "No ¿ other reason"
;
VALUE HS048F /* HS070_F */
1= "Filled"
-1= "Missing"
;
VALUE HS049F /* HS080 */
1= "Yes"
2= "No ¿ cannot afford"
3= "No ¿ other reason"
;
VALUE HS050F /* HS080_F */
1= "Filled"
-1= "Missing"
;
VALUE HS051F /* HS090 */
1= "Yes"
2= "No ¿ cannot afford"
3= "No ¿ other reason"
;
VALUE HS052F /* HS090_F */
1= "Filled"
-1= "Missing"
;
VALUE HS153F /* HS100 */
1= "Yes"
2= "No ¿ cannot afford"
3= "No ¿ other reason"
;
VALUE HS154F /* HS100_F */
1= "Filled"
-1= "Missing"
;
VALUE HS155F /* HS110 */
1= "Yes"
2= "No ¿ cannot afford"
3= "No ¿ other reason"
;
VALUE HS156F /* HS110_F */
1= "Filled"
-1= "Missing"
;
VALUE HS157F /* HS120 */
1= "With great difficulty"
2= "With difficulty"
3= "With some difficulty"
4= "Fairly easily"
5= "Easily"
6= "Very easily"
;
VALUE HS158F /* HS120_F */
1= "Filled"
-1= "Missing"
;
VALUE HS160F /* HS130_F */
1= "Filled"
-1= "Missing"
;
VALUE HS161F /* HS140 */
1= "A heavy burden"
2= "A slight burden"
3= "Not a burden at all"
;
VALUE HS162F /* HS140_F */
1= "Filled"
-1= "Missing"
-2= "Missing (no housing costs)"
;
VALUE HS163F /* HS150 */
1= "Repayment is a heavy burden"
2= "Repayment is somewhat a burden"
3= "Repayment is not a burden at all"
;
VALUE HS164F /* HS150_F */
1= "Filled"
-1= "Missing"
-2= "Missing (no repayment of debts)"
;
VALUE HY078F /* HY030N_F */
0= "No income"
1= "Income (variable is filled)"
-1= "Missing (As missing values are imputed, this code is only acceptable if imputation is not possible)"
-5= "Not filled: variable of gross (...N) series is filled"
;
VALUE HY0125F /* HY030G_F */
0= "No income"
1= "Income (variable is filled)"
-1= "Missing (As missing values are imputed, this code is only acceptable if imputation is not possible)"
;
VALUE HY0133F /* HY051G_F */
0= "No income"
1= "Filled with only Contributory and means-tested components"
2= "Filled with mixed components"
-1= "Missing"
-2= "Not applicable (This scheme doesn't exist at national level)"
-7= "Not applicable (HB010 ne last year)"
;
VALUE HY0135F /* HY052G_F */
0= "No income"
1= "Filled with only Contributory and non means-tested components"
2= "Filled with mixed components"
-1= "Missing"
-2= "Not applicable (This scheme doesn't exist at national level)"
-7= "Not applicable (HB010 ne last year)"
;
VALUE HY0137F /* HY053G_F */
0= "No income"
1= "Filled with only Non-contributory and means-tested components"
2= "Filled with mixed components"
-1= "Missing"
-2= "Not applicable (This scheme doesn't exist at national level)"
-7= "Not applicable (HB010 ne last year)"
;
VALUE HY0139F /* HY054G_F */
0= "No income"
1= "Filled with only Non-contributory and non means-tested components"
2= "Filled with mixed components"
-1= "Missing"
-2= "Not applicable (This scheme doesn't exist at national level)"
-7= "Not applicable (HB010 ne last year)"
;
VALUE HY0144F /* HY061G_F */
0= "No income"
1= "Filled with only Contributory and means-tested components"
2= "Filled with mixed components"
-1= "Missing"
-2= "Not applicable (This scheme doesn't exist at national level)"
-7= "Not applicable (HB010 ne last year)"
;
VALUE HY0146F /* HY062G_F */
0= "No income"
1= "Filled with only Contributory and non means-tested components"
2= "Filled with mixed components"
-1= "Missing"
-2= "Not applicable (This scheme doesn't exist at national level)"
-7= "Not applicable (HB010 ne last year)"
;
VALUE HY0148F /* HY063G_F */
0= "No income"
1= "Filled with only Non-contributory and means-tested components"
2= "Filled with mixed components"
-1= "Missing"
-2= "Not applicable (This scheme doesn't exist at national level)"
-7= "Not applicable (HB010 ne last year)"
;
VALUE HY0150F /* HY064G_F */
0= "No income"
1= "Filled with only Non-contributory and non means-tested components"
2= "Filled with mixed components"
-1= "Missing"
-2= "Not applicable (This scheme doesn't exist at national level)"
-7= "Not applicable (HB010 ne last year)"
;
VALUE HY0155F /* HY071G_F */
0= "No income"
1= "Filled with only Contributory and means-tested components"
2= "Filled with mixed components"
-1= "Missing"
-2= "Not applicable (This scheme doesn't exist at national level)"
-7= "Not applicable (HB010 ne last year)"
;
VALUE HY0157F /* HY072G_F */
0= "No income"
1= "Filled with only Contributory and non means-tested components"
2= "Filled with mixed components"
-1= "Missing"
-2= "Not applicable (This scheme doesn't exist at national level)"
-7= "Not applicable (HB010 ne last year)"
;
VALUE HY0159F /* HY073G_F */
0= "No income"
1= "Filled with only Non-contributory and means-tested components"
2= "Filled with mixed components"
-1= "Missing"
-2= "Not applicable (This scheme doesn't exist at national level)"
-7= "Not applicable (HB010 ne last year)"
;
VALUE HY0161F /* HY074G_F */
0= "No income"
1= "Filled with only Non-contributory and non means-tested components"
2= "Filled with mixed components"
-1= "Missing"
-2= "Not applicable (This scheme doesn't exist at national level)"
-7= "Not applicable (HB010 ne last year)"
;
VALUE HD0192F /* HD080 */
1= "Yes"
2= "No - household cannot afford it"
3= "No - other reason"
;
VALUE HD0193F /* HD080_F */
1= "Filled"
-1= "Missing"
;
VALUE HX1198F /* HX100 */
1= "Household pertains to the lower (1st) quintile"
2= "Household pertains to the 2nd quintile"
3= "Household pertains to the 3rd quintile"
4= "Household pertains to the 4th quintile"
5= "Household pertains to the upper (5th) quintile"
;
format HB020 $HB01F.;
format HB050 HB03F.;
format HB050_F HB04F.;
format HB060_F HB06F.;
format HB070_F HB08F.;
format HB080_F HB010F.;
format HB090_F HB012F.;
format HB100_F HB114F.;
format HH010 HH015F.;
format HH010_F HH016F.;
format HH021 HH017F.;
format HH021_F HH018F.;
format HH030 HH019F.;
format HH030_F HH020F.;
format HH031_F HH022F.;
format HH040 HH023F.;
format HH040_F HH024F.;
format HH050 HH025F.;
format HH050_F HH026F.;
format HH060_F HH028F.;
format HH061_F HH030F.;
format HH081 HH031F.;
format HH081_F HH032F.;
format HH091 HH033F.;
format HH091_F HH034F.;
format HS011 HS035F.;
format HS011_F HS036F.;
format HS021 HS037F.;
format HS021_F HS038F.;
format HS031 HS039F.;
format HS031_F HS040F.;
format HS040 HS041F.;
format HS040_F HS042F.;
format HS050 HS043F.;
format HS050_F HS044F.;
format HS060 HS045F.;
format HS060_F HS046F.;
format HS070 HS047F.;
format HS070_F HS048F.;
format HS080 HS049F.;
format HS080_F HS050F.;
format HS090 HS051F.;
format HS090_F HS052F.;
format HS100 HS153F.;
format HS100_F HS154F.;
format HS110 HS155F.;
format HS110_F HS156F.;
format HS120 HS157F.;
format HS120_F HS158F.;
format HS130_F HS160F.;
format HS140 HS161F.;
format HS140_F HS162F.;
format HS150 HS163F.;
format HS150_F HS164F.;
format HY030N_F HY078F.;
format HY030G_F HY0125F.;
format HY051G_F HY0133F.;
format HY052G_F HY0135F.;
format HY053G_F HY0137F.;
format HY054G_F HY0139F.;
format HY061G_F HY0144F.;
format HY062G_F HY0146F.;
format HY063G_F HY0148F.;
format HY064G_F HY0150F.;
format HY071G_F HY0155F.;
format HY072G_F HY0157F.;
format HY073G_F HY0159F.;
format HY074G_F HY0161F.;
format HD080 HD0192F.;
format HD080_F HD0193F.;
format HX100 HX1198F.;
RUN;
