/* #Declinazione di responsabilità. 
#I file rilasciati in formato testo sono provvisti anche dei programmi di importazione per STATA, SAS e R. 
#L'Istat non garantisce che le funzioni contenute nei suddetti programmi siano esenti da errore e non si assume alcuna responsabilità sull’output ottenuto dal loro utilizzo.       */
/*  I valori delle label nelle variabili categoriche sono commentati a causa della presenza di codici non esclusivamente numerici. Comunque sono completamente documentati.  */
clear all
infile  using  PGM_2019_HOUSEHOLD_DATA_(H-FILE)_Longitudinal_EN_DELIMITED.dct, clear
/*
label define  hb020_cl1 AL   "Albania" AT   "Osterreich" BE   "Belgique/Belgie" BG   "Bulgaria" CH   "Switzerland" CY   "Cyprus" CZ   "Czech Republic" DE   "Deutschland" DK   "Denmark" EE   "Estonia" EL   "Ellada" ES   "Espana" FI   "Suomi" FR   "France" HR   "Croatia" HU   "Hungary" IE   "Ireland" IS   "Iceland" IT   "Italia" LT   "Lithuania" LU   "Luxembourg" LV   "Latvia" ME   "Montenegro" MK   "The Former Yugoslav Republic of Macedonia (FYROM)" MT   "Malta" NL   "Nederland" NO   "Norway" PL   "Poland" PT   "Portugal" RO   "Romania" RS   "Serbia" SE   "Sverige" SI   "Slovenia" SK   "Slovak Republic" TR   "Turkey" UK   "United Kingdom"  
label define  hb050_cl3 1   "January-March" 2   "April-June" 3   "July-September" 4   "October-December"  
label define  hb050_f_cl4 1   "Filled" -1   "Missing"  
label define  hb060_f_cl6 1   "Filled"  
label define  hb070_f_cl8 1   "Filled" -1   "Missing"  
label define  hb080_f_cl10 1   "Filled" -1   "Missing"  
label define  hb090_f_cl12 1   "Filled" -1   "Missing" -2   "Not applicable (no second person responsible for the accommodation)"  
label define  hb100_f_cl14 1   "Filled" -1   "Missing"  
label define  hh010_cl15 1   "Detached house" 2   "Semi-detached or terraced house" 3   "Apartment or flat in a building with less than 10 dwellings" 4   "Apartment or flat in a building with 10 or more dwellings"  
label define  hh010_f_cl16 1   "Filled" -1   "Missing"  
label define  hh021_cl17 1   "Outright owner" 2   "Owner paying mortgage" 3   "Tenant or subtenant paying rent at prevailing or market rate" 4   "Accommodation is rented at a reduced rate (lower price that the market price)" 5   "Accommodation is provided free"  
label define  hh021_f_cl18 1   "Filled" -1   "Missing"  
label define  hh030_cl19 1   "1 room" 2   "2 rooms" 3   "3 rooms" 4   "4 rooms" 5   "5 rooms" 6   "6 or more rooms"  
label define  hh030_f_cl20 1   "Filled" -1   "Missing"  
label define  hh031_f_cl22 1   "Filled" -1   "Missing" -2   "Not applicable (MS using objective national methods to calculate imputed rent)"  
label define  hh040_cl23 1   "Yes" 2   "No"  
label define  hh040_f_cl24 1   "Filled" -1   "Missing"  
label define  hh050_cl25 1   "Yes" 2   "No"  
label define  hh050_f_cl26 1   "Filled" -1   "Missing"  
label define  hh060_f_cl28 1   "Filled" -1   "Missing" -2   "Not applicable (HH021 not equal to 3 or 4)"  
label define  hh061_f_cl30 1   "Filled" -1   "Missing" -2   "Not applicable (HH021 eq 3) or (MS do not use subjective method to calculate imputed rent)"  
label define  hh081_cl31 1   "Yes, for sole use of the household" 2   "Yes, shared" 3   "No"  
label define  hh081_f_cl32 1   "Filled" -1   "Missing"  
label define  hh091_cl33 1   "Yes, for sole use of the household" 2   "Yes, shared" 3   "No"  
label define  hh091_f_cl34 1   "Filled" -1   "Missing"  
label define  hs011_cl35 1   "Yes, once" 2   "Yes, twice or more" 3   "No"  
label define  hs011_f_cl36 1   "Filled" -1   "Missing" -2   "Not applicable (outright owner or rent free during the last 12 months)"  
label define  hs021_cl37 1   "Yes, once" 2   "Yes, twice or more" 3   "No"  
label define  hs021_f_cl38 1   "Filled" -1   "Missing" -2   "Not applicable (no utility bills)"  
label define  hs031_cl39 1   "Yes, once" 2   "Yes, twice or more" 3   "No"  
label define  hs031_f_cl40 1   "Filled" -1   "Missing" -2   "Not applicable (no hire purchase instalments and no other loan payments)"  
label define  hs040_cl41 1   "Yes" 2   "No"  
label define  hs040_f_cl42 1   "Filled" -1   "Missing"  
label define  hs050_cl43 1   "Yes" 2   "No"  
label define  hs050_f_cl44 1   "Filled" -1   "Missing"  
label define  hs060_cl45 1   "Yes" 2   "No"  
label define  hs060_f_cl46 1   "Filled" -1   "Missing"  
label define  hs070_cl47 1   "Yes" 2   "No ¿ cannot afford" 3   "No ¿ other reason"  
label define  hs070_f_cl48 1   "Filled" -1   "Missing"  
label define  hs080_cl49 1   "Yes" 2   "No ¿ cannot afford" 3   "No ¿ other reason"  
label define  hs080_f_cl50 1   "Filled" -1   "Missing"  
label define  hs090_cl51 1   "Yes" 2   "No ¿ cannot afford" 3   "No ¿ other reason"  
label define  hs090_f_cl52 1   "Filled" -1   "Missing"  
label define  hs100_cl53 1   "Yes" 2   "No ¿ cannot afford" 3   "No ¿ other reason"  
label define  hs100_f_cl54 1   "Filled" -1   "Missing"  
label define  hs110_cl55 1   "Yes" 2   "No ¿ cannot afford" 3   "No ¿ other reason"  
label define  hs110_f_cl56 1   "Filled" -1   "Missing"  
label define  hs120_cl57 1   "With great difficulty" 2   "With difficulty" 3   "With some difficulty" 4   "Fairly easily" 5   "Easily" 6   "Very easily"  
label define  hs120_f_cl58 1   "Filled" -1   "Missing"  
label define  hs130_f_cl60 1   "Filled" -1   "Missing"  
label define  hs140_cl61 1   "A heavy burden" 2   "A slight burden" 3   "Not a burden at all"  
label define  hs140_f_cl62 1   "Filled" -1   "Missing" -2   "Missing (no housing costs)"  
label define  hs150_cl63 1   "Repayment is a heavy burden" 2   "Repayment is somewhat a burden" 3   "Repayment is not a burden at all"  
label define  hs150_f_cl64 1   "Filled" -1   "Missing" -2   "Missing (no repayment of debts)"  
label define  hy030n_f_cl78 0   "No income" 1   "Income (variable is filled)" -1   "Missing (As missing values are imputed, this code is only acceptable if imputation is not possible)" -5   "Not filled: variable of gross (...N) series is filled"  
label define  hy030g_f_cl125 0   "No income" 1   "Income (variable is filled)" -1   "Missing (As missing values are imputed, this code is only acceptable if imputation is not possible)"  
label define  hy051g_f_cl133 0   "No income" 1   "Filled with only Contributory and means-tested components" 2   "Filled with mixed components" -1   "Missing" -2   "Not applicable (This scheme doesn't exist at national level)" -7   "Not applicable (HB010 ne last year)"  
label define  hy052g_f_cl135 0   "No income" 1   "Filled with only Contributory and non means-tested components" 2   "Filled with mixed components" -1   "Missing" -2   "Not applicable (This scheme doesn't exist at national level)" -7   "Not applicable (HB010 ne last year)"  
label define  hy053g_f_cl137 0   "No income" 1   "Filled with only Non-contributory and means-tested components" 2   "Filled with mixed components" -1   "Missing" -2   "Not applicable (This scheme doesn't exist at national level)" -7   "Not applicable (HB010 ne last year)"  
label define  hy054g_f_cl139 0   "No income" 1   "Filled with only Non-contributory and non means-tested components" 2   "Filled with mixed components" -1   "Missing" -2   "Not applicable (This scheme doesn't exist at national level)" -7   "Not applicable (HB010 ne last year)"  
label define  hy061g_f_cl144 0   "No income" 1   "Filled with only Contributory and means-tested components" 2   "Filled with mixed components" -1   "Missing" -2   "Not applicable (This scheme doesn't exist at national level)" -7   "Not applicable (HB010 ne last year)"  
label define  hy062g_f_cl146 0   "No income" 1   "Filled with only Contributory and non means-tested components" 2   "Filled with mixed components" -1   "Missing" -2   "Not applicable (This scheme doesn't exist at national level)" -7   "Not applicable (HB010 ne last year)"  
label define  hy063g_f_cl148 0   "No income" 1   "Filled with only Non-contributory and means-tested components" 2   "Filled with mixed components" -1   "Missing" -2   "Not applicable (This scheme doesn't exist at national level)" -7   "Not applicable (HB010 ne last year)"  
label define  hy064g_f_cl150 0   "No income" 1   "Filled with only Non-contributory and non means-tested components" 2   "Filled with mixed components" -1   "Missing" -2   "Not applicable (This scheme doesn't exist at national level)" -7   "Not applicable (HB010 ne last year)"  
label define  hy071g_f_cl155 0   "No income" 1   "Filled with only Contributory and means-tested components" 2   "Filled with mixed components" -1   "Missing" -2   "Not applicable (This scheme doesn't exist at national level)" -7   "Not applicable (HB010 ne last year)"  
label define  hy072g_f_cl157 0   "No income" 1   "Filled with only Contributory and non means-tested components" 2   "Filled with mixed components" -1   "Missing" -2   "Not applicable (This scheme doesn't exist at national level)" -7   "Not applicable (HB010 ne last year)"  
label define  hy073g_f_cl159 0   "No income" 1   "Filled with only Non-contributory and means-tested components" 2   "Filled with mixed components" -1   "Missing" -2   "Not applicable (This scheme doesn't exist at national level)" -7   "Not applicable (HB010 ne last year)"  
label define  hy074g_f_cl161 0   "No income" 1   "Filled with only Non-contributory and non means-tested components" 2   "Filled with mixed components" -1   "Missing" -2   "Not applicable (This scheme doesn't exist at national level)" -7   "Not applicable (HB010 ne last year)"  
label define  hd080_cl192 1   "Yes" 2   "No - household cannot afford it" 3   "No - other reason"  
label define  hd080_f_cl193 1   "Filled" -1   "Missing"  
label define  hx100_cl198 1   "Household pertains to the lower (1st) quintile" 2   "Household pertains to the 2nd quintile" 3   "Household pertains to the 3rd quintile" 4   "Household pertains to the 4th quintile" 5   "Household pertains to the upper (5th) quintile"  
label values  hb020 hb020_cl1
label values  hb050 hb050_cl3
label values  hb050_f hb050_f_cl4
label values  hb060_f hb060_f_cl6
label values  hb070_f hb070_f_cl8
label values  hb080_f hb080_f_cl10
label values  hb090_f hb090_f_cl12
label values  hb100_f hb100_f_cl14
label values  hh010 hh010_cl15
label values  hh010_f hh010_f_cl16
label values  hh021 hh021_cl17
label values  hh021_f hh021_f_cl18
label values  hh030 hh030_cl19
label values  hh030_f hh030_f_cl20
label values  hh031_f hh031_f_cl22
label values  hh040 hh040_cl23
label values  hh040_f hh040_f_cl24
label values  hh050 hh050_cl25
label values  hh050_f hh050_f_cl26
label values  hh060_f hh060_f_cl28
label values  hh061_f hh061_f_cl30
label values  hh081 hh081_cl31
label values  hh081_f hh081_f_cl32
label values  hh091 hh091_cl33
label values  hh091_f hh091_f_cl34
label values  hs011 hs011_cl35
label values  hs011_f hs011_f_cl36
label values  hs021 hs021_cl37
label values  hs021_f hs021_f_cl38
label values  hs031 hs031_cl39
label values  hs031_f hs031_f_cl40
label values  hs040 hs040_cl41
label values  hs040_f hs040_f_cl42
label values  hs050 hs050_cl43
label values  hs050_f hs050_f_cl44
label values  hs060 hs060_cl45
label values  hs060_f hs060_f_cl46
label values  hs070 hs070_cl47
label values  hs070_f hs070_f_cl48
label values  hs080 hs080_cl49
label values  hs080_f hs080_f_cl50
label values  hs090 hs090_cl51
label values  hs090_f hs090_f_cl52
label values  hs100 hs100_cl53
label values  hs100_f hs100_f_cl54
label values  hs110 hs110_cl55
label values  hs110_f hs110_f_cl56
label values  hs120 hs120_cl57
label values  hs120_f hs120_f_cl58
label values  hs130_f hs130_f_cl60
label values  hs140 hs140_cl61
label values  hs140_f hs140_f_cl62
label values  hs150 hs150_cl63
label values  hs150_f hs150_f_cl64
label values  hy030n_f hy030n_f_cl78
label values  hy030g_f hy030g_f_cl125
label values  hy051g_f hy051g_f_cl133
label values  hy052g_f hy052g_f_cl135
label values  hy053g_f hy053g_f_cl137
label values  hy054g_f hy054g_f_cl139
label values  hy061g_f hy061g_f_cl144
label values  hy062g_f hy062g_f_cl146
label values  hy063g_f hy063g_f_cl148
label values  hy064g_f hy064g_f_cl150
label values  hy071g_f hy071g_f_cl155
label values  hy072g_f hy072g_f_cl157
label values  hy073g_f hy073g_f_cl159
label values  hy074g_f hy074g_f_cl161
label values  hd080 hd080_cl192
label values  hd080_f hd080_f_cl193
label values  hx100 hx100_cl198
*/
save  EUSILC_Long_A2019_HOUSEHOLD_DAT.dta, replace
