/*    LIMITAZIONE DELLA RESPONSABILITA'. 
  Il software  fornito "cos com'", senza garanzie di  sorta.               */
%macro grabpath;
%qsubstr(%sysget(SAS_EXECFILEPATH),1,%length(%sysget(SAS_EXECFILEPATH))-%length(%sysget(SAS_EXECFILEname)))
%mend grabpath;
%let path = %grabpath;
%let nomeFile =ISTAT_MFR_EU-SILC_Microdati_2016_PERSONAL_REGISTER_(R-FILE)_Cross-Sectional_ESEMPIO_STRUTTURA_FILE.txt;
LIBNAME ISTAT "&path";
DATA ISTAT.EU-SILC_A2016_PERSONAL_REGISTER;

INFILE "&path&nomeFile" DLM='5E'x  LRECL=32767 TRUNCOVER FIRSTOBS=2 IGNOREDOSEOF;
INPUT 
RB010 :5.   /*  YEAR OF THE SURVEY */
RB020 : $3.   /*  COUNTRY */
RB030 :12.   /*  PERSONAL ID */
RB031 :5.   /*  YEAR OF IMMIGRATION */
RB031_F :2.   /*  FLAGS OF RB031 */
RB050 :16.   /*  PERSONAL CROSS-SECTIONAL WEIGHT */
RB050_F :2.   /*  FLAGS OF RB050 */
RB070 :3.   /*  MONTH OF BIRTH */
RB070_F :2.   /*  FLAGS OF RB070 */
RB080 :5.   /*  YEAR OF BIRTH */
RB080_F :2.   /*  FLAGS OF RB080 */
RB090 :2.   /*  SEX */
RB090_F :2.   /*  FLAGS OF RB090 */
RB200 :2.   /*  RESIDENTIAL STATUS */
RB200_F :2.   /*  FLAGS OF RB200 */
RB210 :2.   /*  BASIC ACTIVITY STATUS */
RB210_F :2.   /*  FLAGS OF RB210 */
RB220 :12.   /*  FATHER ID */
RB220_F :2.   /*  FLAGS OF RB220 */
RB230 :12.   /*  MOTHER ID */
RB230_F :2.   /*  FLAGS OF RB230 */
RB240 :12.   /*  SPOUSE/PARTNER ID */
RB240_F :2.   /*  FLAGS OF RB240 */
RB245 :2.   /*  RESPONDENT STATUS */
RB245_F :2.   /*  FLAGS OF RB245 */
RB250 :3.   /*  DATA STATUS */
RB250_F :2.   /*  FLAGS OF RB250 */
RB260 :2.   /*  TYPE OF INTERVIEW */
RB260_F :2.   /*  FLAGS OF RB260 */
RB270 :12.   /*  PERSONAL ID OF PROXY */
RB270_F :2.   /*  FLAGS OF RB270 */
RL010 :3.   /*  EDUCATION AT PRE-SCHOOL */
RL010_F :2.   /*  FLAGS OF RL010 */
RL020 :3.   /*  EDUCATION AT COMPULSORY SCHOOL */
RL020_F :2.   /*  FLAGS OF RL020 */
RL030 :3.   /*  CHILD CARE AT CENTRE-BASED SERVICES */
RL030_F :2.   /*  FLAGS OF RL030 */
RL040 :3.   /*  CHILD CARE AT DAY-CARE CENTRE */
RL040_F :2.   /*  FLAGS OF RL040 */
RL050 :3.   /*  CHILD CARE BY A PROFESSIONAL CHILD-MINDER AT CHILD'S HOME OR AT CHILDMINDERS HOME */
RL050_F :2.   /*  FLAGS OF RL050 */
RL060 :3.   /*  CHILD CARE BY GRAND-PARENTS - OTHERS HOUSEHOLD MEMBERS (OUTSIDE PARENTS)  OTHER RELATIVES - FRIENDS OR NEIGHBOURS */
RL060_F :2.   /*  FLAGS OF RL060 */
RL070 :16.   /*  CHILDREN CROSS-SECTIONAL WEIGHT FOR CHILD CARE */
RL070_F :2.   /*  FLAGS OF RL070 */
RC010 :2.   /*  PAYMENT FOR THE COST OF FORMAL CHILDCARE SERVICES */
RC010_F :2.   /*  FLAGS OF RC010 */
RC020 :2.   /*  PROPORTION OF THE COST OF FORMAL CHILDCARE SERVICES PAID */
RC020_F :2.   /*  FLAGS OF RC020 */
RC030 :2.   /*  WHO PAYS/CONTRIBUTES TO THE COST OF FORMAL CHILDCARE SERVICES */
RC030_F :2.   /*  FLAGS OF RC030 */
RC070 :2.   /*  PAYMENT FOR TUITION FEES */
RC070_F :2.   /*  FLAGS OF RC070 */
RC080 :2.   /*  PART OF THE TUITION FEES PAID */
RC080_F :2.   /*  FLAGS OF RC080 */
RC090 :2.   /*  WHO PAYS/ CONTRIBUTES TO THE TUITION FEES */
RC090_F :2.   /*  FLAGS OF RC090 */
RX010 :3.   /*  AGE AT THE TIME OF INTERVIEW */
RX020 :3.   /*  AGE AT THE END OF INCOME REFERENCE PERIOD */
RX030 :6.   /*  HOUSEHOLD IDENTIFICATION NUMBER */
RX040 :16.   /*  WORK INTENSITY */
RX050 :2.   /*  LOW WORK INTENSITY STATUS */
RX060 :2.   /*  SEVERELY MATERIALLY DEPRIVED */
RX070 : $4.   /*  AT RISK OF POVERTY OR SOCIAL EXCLUSION */
;
LABEL 
RB010 = "YEAR OF THE SURVEY"
RB020 = "COUNTRY"
RB030 = "PERSONAL ID"
RB031 = "YEAR OF IMMIGRATION"
RB031_F = "FLAGS OF RB031"
RB050 = "PERSONAL CROSS-SECTIONAL WEIGHT"
RB050_F = "FLAGS OF RB050"
RB070 = "MONTH OF BIRTH"
RB070_F = "FLAGS OF RB070"
RB080 = "YEAR OF BIRTH"
RB080_F = "FLAGS OF RB080"
RB090 = "SEX"
RB090_F = "FLAGS OF RB090"
RB200 = "RESIDENTIAL STATUS"
RB200_F = "FLAGS OF RB200"
RB210 = "BASIC ACTIVITY STATUS"
RB210_F = "FLAGS OF RB210"
RB220 = "FATHER ID"
RB220_F = "FLAGS OF RB220"
RB230 = "MOTHER ID"
RB230_F = "FLAGS OF RB230"
RB240 = "SPOUSE/PARTNER ID"
RB240_F = "FLAGS OF RB240"
RB245 = "RESPONDENT STATUS"
RB245_F = "FLAGS OF RB245"
RB250 = "DATA STATUS"
RB250_F = "FLAGS OF RB250"
RB260 = "TYPE OF INTERVIEW"
RB260_F = "FLAGS OF RB260"
RB270 = "PERSONAL ID OF PROXY"
RB270_F = "FLAGS OF RB270"
RL010 = "EDUCATION AT PRE-SCHOOL"
RL010_F = "FLAGS OF RL010"
RL020 = "EDUCATION AT COMPULSORY SCHOOL"
RL020_F = "FLAGS OF RL020"
RL030 = "CHILD CARE AT CENTRE-BASED SERVICES"
RL030_F = "FLAGS OF RL030"
RL040 = "CHILD CARE AT DAY-CARE CENTRE"
RL040_F = "FLAGS OF RL040"
RL050 = "CHILD CARE BY A PROFESSIONAL CHILD-MINDER AT CHILD'S HOME OR AT CHILDMINDERS HOME"
RL050_F = "FLAGS OF RL050"
RL060 = "CHILD CARE BY GRAND-PARENTS - OTHERS HOUSEHOLD MEMBERS (OUTSIDE PARENTS)  OTHER RELATIVES - FRIENDS OR NEIGHBOURS"
RL060_F = "FLAGS OF RL060"
RL070 = "CHILDREN CROSS-SECTIONAL WEIGHT FOR CHILD CARE"
RL070_F = "FLAGS OF RL070"
RC010 = "PAYMENT FOR THE COST OF FORMAL CHILDCARE SERVICES"
RC010_F = "FLAGS OF RC010"
RC020 = "PROPORTION OF THE COST OF FORMAL CHILDCARE SERVICES PAID"
RC020_F = "FLAGS OF RC020"
RC030 = "WHO PAYS/CONTRIBUTES TO THE COST OF FORMAL CHILDCARE SERVICES"
RC030_F = "FLAGS OF RC030"
RC070 = "PAYMENT FOR TUITION FEES"
RC070_F = "FLAGS OF RC070"
RC080 = "PART OF THE TUITION FEES PAID"
RC080_F = "FLAGS OF RC080"
RC090 = "WHO PAYS/ CONTRIBUTES TO THE TUITION FEES"
RC090_F = "FLAGS OF RC090"
RX010 = "AGE AT THE TIME OF INTERVIEW"
RX020 = "AGE AT THE END OF INCOME REFERENCE PERIOD"
RX030 = "HOUSEHOLD IDENTIFICATION NUMBER"
RX040 = "WORK INTENSITY"
RX050 = "LOW WORK INTENSITY STATUS"
RX060 = "SEVERELY MATERIALLY DEPRIVED"
RX070 = "AT RISK OF POVERTY OR SOCIAL EXCLUSION"
;
RUN;
PROC FORMAT;
VALUE $RB01F /* RB020 */
"AT" = "sterreich"
"BE" = "Belgique"
"BG" = "Bulgaria"
"CH" = "Switzerland"
"CY" = "Cyprus"
"CZ" = "Czech"
"DE" = "Deutschland"
"DK" = "Danmark"
"EE" = "Estonia"
"ES" = "Espaa"
"FI" = "Suomi"
"FR" = "France"
"GR" = "Ellda"
"HU" = "Hungary"
"IE" = "Ireland"
"IS" = "Iceland"
"IT" = "Italia"
"LT" = "Lithuania"
"LU" = "Luxembourg"
"LV" = "Latvia"
"MT" = "Malta"
"NL" = "Nederland"
"NO" = "Norway"
"PL" = "Poland"
"PT" = "Portugal"
"RO" = "Romania"
"SE" = "Sverige"
"SI" = "Slovenia"
"SK" = "Slovak/republic"
"UK" = "United"
;
VALUE RB03F /* RB031 */
1936= "<=1936"
1941= "1941 - 1937"
1946= "1946 - 1942"
1951= "1951 - 1947"
1956= "1956 - 1952"
1961= "1961 - 1957"
1966= "1966 - 1962"
1971= "1971 - 1967"
1976= "1976 - 1972"
1981= "1981 - 1977"
1986= "1986 - 1982"
1991= "1991 - 1987"
1996= "1996 - 1992"
2001= "2001 - 1997"
2006= "2006 - 2002"
2011= "2011 - 2007"
2016= "2016 - 2012"
;
VALUE RB04F /* RB031_F */
1= "filled"
-1= "missing"
-2= "not applicable (no immigration for the person)"
;
VALUE RB06F /* RB050_F */
1= "filled"
-2= "Not applicable (RB110 not equal to 1, 2, 3 or 4)"
-7= "Not applicable RB010 ne last year"
;
VALUE RB07F /* RB070 */
1= "January-March"
2= "April-June"
3= "July-September"
4= "October-December"
;
VALUE RB08F /* RB070_F */
1= "filled"
-1= "missing"
;
VALUE RB010F /* RB080_F */
1= "filled"
-1= "missing"
;
VALUE RB011F /* RB090 */
1= "Male"
2= "Female"
;
VALUE RB012F /* RB090_F */
1= "filled"
-1= "missing"
;
VALUE RB213F /* RB200 */
1= "currently living in the household"
2= "temporarily absent"
;
VALUE RB214F /* RB200_F */
1= "filled"
-1= "Missing"
-2= "Not applicable (RB110 not equal to 1, 2, 3 or 4)"
;
VALUE RB215F /* RB210 */
1= "at work"
2= "unemployed"
3= "in retirement or early retirement"
4= "other inactive person"
;
VALUE RB216F /* RB210_F */
1= "filled"
-1= "Missing"
-2= "Not applicable (RB110 not equal to 1, 2, 3 or 4)"
;
VALUE RB218F /* RB220_F */
1= "filled"
-1= "missing"
-2= "na (father is not a household member)"
;
VALUE RB220F /* RB230_F */
1= "filled"
-1= "missing"
-2= "na (mother is not a household member)"
;
VALUE RB222F /* RB240_F */
1= "filled"
-1= "missing"
-2= "na (spouse/partneris not a household member)"
;
VALUE RB223F /* RB245 */
1= "current household member aged 16 and over Only selected household member aged 16 and over is interviewed"
2= "selected respondent"
3= "not selected respondent Households members aged less than 16 at the time of interview"
4= "not eligible person"
;
VALUE RB224F /* RB245_F */
1= "filled"
-2= "Not applicable (RB110 not equal to 1, 2, 3 or 4))"
;
VALUE RB225F /* RB250 */
11= "information completed only from interview"
12= "information completed only from registers"
13= "information completed from both: interview and registers"
14= "information completed from full-record imputation"
21= "individual unable to respond (illness, incapacity, etc) and no proxy possible"
22= "failed to return self-completed questionnaire"
23= "refusal to co-operate"
31= "person temporarily away and no proxy possible"
32= "no contact for other reasons Information or interview not completed"
33= "information not completed reason unknown"
;
VALUE RB226F /* RB250_F */
1= "filled"
-2= "na (RB245 not = 1,2 or 3)"
;
VALUE RB227F /* RB260 */
1= "face to face interview-PAPI"
2= "face to face interview-CAPI"
3= "CATI telephone interview"
4= "self-administered by respondent"
5= "Computer assisted web interviewing-CAWI"
6= "Face to face interview-PAPI with proxy"
7= "Face to face interview-CAPI with proxy"
8= "CATI, telephone interview with proxy"
9= "Self-administered by respondent with proxy"
10= "Computer assisted web interviewing-CAWI with proxy"
;
VALUE RB228F /* RB260_F */
1= "filled"
-1= "missing"
-2= "Not applicable (RB250 not equal to 11 or 13) or RB245=3"
;
VALUE RB230F /* RB270_F */
1= "filled"
-1= "missing"
-2= "Not applicable ((RB260 not equal to 6, 7, 8, 9, 10) AND RB010 > 2013) OR ( RB260 ne 5 AND RB010 < 2014))"
;
VALUE RL032F /* RL010_F */
1= "filled"
-1= "missing"
-2= "na person is not admitted to pre-school because of her age, is at compulsory school or is more than 12 years old"
;
VALUE RL034F /* RL020_F */
1= "filled"
-1= "missing"
-2= "na person is not admitted to compulsory school because of her age or is more than 12 years"
;
VALUE RL036F /* RL030_F */
1= "filled"
-1= "missing"
-2= "na: person is neither at pre-school nor at school or is more than 12 years old"
;
VALUE RL038F /* RL040_F */
1= "filled"
-1= "missing"
-2= "na person is more than 12 years old"
;
VALUE RL040F /* RL050_F */
1= "filled"
-1= "missing"
-2= "na person is more than 12 years old"
;
VALUE RL042F /* RL060_F */
1= "filled"
-1= "missing"
-2= "na person is more than 12 years old"
;
VALUE RL044F /* RL070_F */
1= "filled"
-2= "na RB110 not equal to 1, 2, 3 or 4 (persons aged more than 12 years old at the date of interview)"
-7= "Not applicable RB010 ne last year"
;
VALUE RC045F /* RC010 */
1= "yes"
2= "no"
;
VALUE RC046F /* RC010_F */
1= "filled"
-1= "missing"
-4= "no formal childcare for this child (RL030<1 AND RL040<1) OR not current household member (RB110 not in (1,2,3,4))"
-5= "not applicable (person is more than 12 years old)"
-7= "not applicable RB010 not = 2016"
;
VALUE RC047F /* RC020 */
1= "full price (full cost)"
2= "reduced price (subsidised by government, employer, private, person, etc.)"
9= "do not know"
;
VALUE RC048F /* RC020_F */
1= "filled"
-1= "missing"
-2= "not applicable (RC010 = 2)"
-4= "no formal childcare for this child (RL030<1 AND RL040<1) OR not current household member (RB110 not in (1,2,3,4))"
-5= "not applicable (person is more than 12 years old)"
-7= "not applicable RB010 not = 2016"
;
VALUE RC049F /* RC030 */
1= "government or local authorities"
2= "employer"
3= "other institutions (e.g. church, non-profit organisations)"
4= "private persons who are not household members"
5= "other"
9= "do not know"
;
VALUE RC050F /* RC030_F */
1= "filled"
-1= "missing"
-2= "not applicable (RC020 = 1 OR RC020=9)"
-4= "no formal childcare for this child (RL030<1 AND RL040<1) OR not current household member (RB110 not in (1,2,3,4))"
-5= "not applicable (person is more than 12 years old)"
-7= "not applicable RB010 not = 2016"
;
VALUE RC051F /* RC070 */
1= "yes"
2= "no"
;
VALUE RC052F /* RC070_F */
1= "filled"
-1= "missing"
-4= "person does not follow formal education OR not current household member (RB110 not in (1,2,3,4))"
-7= "not applicable RB010 not = 2016"
;
VALUE RC053F /* RC080 */
1= "full price (full cost)"
2= "reduced price (subsidised by government, employer, private, person, etc.)"
9= "do not know"
;
VALUE RC054F /* RC080_F */
1= "filled"
-1= "missing"
-2= "not applicable (RC070=2)"
-4= "person does not follow formal education OR not current household member (RB110 not in (1,2,3,4))"
-7= "not applicable RB010 not = 2016"
;
VALUE RC055F /* RC090 */
1= "government or local authorities"
2= "employer"
3= "other institutions (e.g. church, non-profit organisations)"
4= "private persons who are not household members"
5= "other"
9= "do not know"
;
VALUE RC056F /* RC090_F */
1= "filled"
-1= "missing"
-2= "not applicable (RC080=1 OR RC080=9) OR not current household member (RB110 not in (1,2,3,4))"
-4= "person does not follow formal education"
-7= "not applicable RB010 not = 2016"
;
VALUE RX061F /* RX050 */
0= "no Low Work Intensity"
1= "Low Work Intensity"
2= "not applicable"
;
VALUE RX062F /* RX060 */
0= "not severely deprived"
1= "severely deprived"
;
format RB020 $RB01F.;
format RB031 RB03F.;
format RB031_F RB04F.;
format RB050_F RB06F.;
format RB070 RB07F.;
format RB070_F RB08F.;
format RB080_F RB010F.;
format RB090 RB011F.;
format RB090_F RB012F.;
format RB200 RB213F.;
format RB200_F RB214F.;
format RB210 RB215F.;
format RB210_F RB216F.;
format RB220_F RB218F.;
format RB230_F RB220F.;
format RB240_F RB222F.;
format RB245 RB223F.;
format RB245_F RB224F.;
format RB250 RB225F.;
format RB250_F RB226F.;
format RB260 RB227F.;
format RB260_F RB228F.;
format RB270_F RB230F.;
format RL010_F RL032F.;
format RL020_F RL034F.;
format RL030_F RL036F.;
format RL040_F RL038F.;
format RL050_F RL040F.;
format RL060_F RL042F.;
format RL070_F RL044F.;
format RC010 RC045F.;
format RC010_F RC046F.;
format RC020 RC047F.;
format RC020_F RC048F.;
format RC030 RC049F.;
format RC030_F RC050F.;
format RC070 RC051F.;
format RC070_F RC052F.;
format RC080 RC053F.;
format RC080_F RC054F.;
format RC090 RC055F.;
format RC090_F RC056F.;
format RX050 RX061F.;
format RX060 RX062F.;
RUN;
