#LIMITAZIONE DELLA RESPONSABILITA'. 
#Il software  fornito "cos com'", senza garanzie di  sorta.
setwd(choose.dir(default = "", caption = "WHERE ARE MICRODATA?"))
direttorio = getwd()
fileInput = paste (direttorio, "/ISTAT_MFR_EU-SILC_Microdati_2016_PERSONAL_REGISTER_(R-FILE)_Cross-Sectional_ESEMPIO_STRUTTURA_FILE.txt", sep="")
DF_EU-SILC_A2016_PERSONAL_REGIS<- read.delim2 (fileInput,  header=T, sep="^",  quote="",  na.strings = ".")
attr(DF_EU-SILC_A2016_PERSONAL_REGIS, "label") <- c(
"YEAR OF THE SURVEY",
"COUNTRY",
"PERSONAL ID",
"YEAR OF IMMIGRATION",
"FLAGS OF RB031",
"PERSONAL CROSS-SECTIONAL WEIGHT",
"FLAGS OF RB050",
"MONTH OF BIRTH",
"FLAGS OF RB070",
"YEAR OF BIRTH",
"FLAGS OF RB080",
"SEX",
"FLAGS OF RB090",
"RESIDENTIAL STATUS",
"FLAGS OF RB200",
"BASIC ACTIVITY STATUS",
"FLAGS OF RB210",
"FATHER ID",
"FLAGS OF RB220",
"MOTHER ID",
"FLAGS OF RB230",
"SPOUSE/PARTNER ID",
"FLAGS OF RB240",
"RESPONDENT STATUS",
"FLAGS OF RB245",
"DATA STATUS",
"FLAGS OF RB250",
"TYPE OF INTERVIEW",
"FLAGS OF RB260",
"PERSONAL ID OF PROXY",
"FLAGS OF RB270",
"EDUCATION AT PRE-SCHOOL",
"FLAGS OF RL010",
"EDUCATION AT COMPULSORY SCHOOL",
"FLAGS OF RL020",
"CHILD CARE AT CENTRE-BASED SERVICES",
"FLAGS OF RL030",
"CHILD CARE AT DAY-CARE CENTRE",
"FLAGS OF RL040",
"CHILD CARE BY A PROFESSIONAL CHILD-MINDER AT CHILD'S HOME OR AT CHILDMINDERS HOME",
"FLAGS OF RL050",
"CHILD CARE BY GRAND-PARENTS - OTHERS HOUSEHOLD MEMBERS (OUTSIDE PARENTS)  OTHER RELATIVES - FRIENDS OR NEIGHBOURS",
"FLAGS OF RL060",
"CHILDREN CROSS-SECTIONAL WEIGHT FOR CHILD CARE",
"FLAGS OF RL070",
"PAYMENT FOR THE COST OF FORMAL CHILDCARE SERVICES",
"FLAGS OF RC010",
"PROPORTION OF THE COST OF FORMAL CHILDCARE SERVICES PAID",
"FLAGS OF RC020",
"WHO PAYS/CONTRIBUTES TO THE COST OF FORMAL CHILDCARE SERVICES",
"FLAGS OF RC030",
"PAYMENT FOR TUITION FEES",
"FLAGS OF RC070",
"PART OF THE TUITION FEES PAID",
"FLAGS OF RC080",
"WHO PAYS/ CONTRIBUTES TO THE TUITION FEES",
"FLAGS OF RC090",
"AGE AT THE TIME OF INTERVIEW",
"AGE AT THE END OF INCOME REFERENCE PERIOD",
"HOUSEHOLD IDENTIFICATION NUMBER",
"WORK INTENSITY",
"LOW WORK INTENSITY STATUS",
"SEVERELY MATERIALLY DEPRIVED",
"AT RISK OF POVERTY OR SOCIAL EXCLUSION")

RB020_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_REGIS$RB020, 
levels=c("AT", 
"BE", 
"BG", 
"CH", 
"CY", 
"CZ", 
"DE", 
"DK", 
"EE", 
"ES", 
"FI", 
"FR", 
"GR", 
"HU", 
"IE", 
"IS", 
"IT", 
"LT", 
"LU", 
"LV", 
"MT", 
"NL", 
"NO", 
"PL", 
"PT", 
"RO", 
"SE", 
"SI", 
"SK", 
"UK"), 
labels=c("sterreich", 
"Belgique", 
"Bulgaria", 
"Switzerland", 
"Cyprus", 
"Czech", 
"Deutschland", 
"Danmark", 
"Estonia", 
"Espaa", 
"Suomi", 
"France", 
"Ellda", 
"Hungary", 
"Ireland", 
"Iceland", 
"Italia", 
"Lithuania", 
"Luxembourg", 
"Latvia", 
"Malta", 
"Nederland", 
"Norway", 
"Poland", 
"Portugal", 
"Romania", 
"Sverige", 
"Slovenia", 
"Slovak/republic", 
"United")) 


RB031_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_REGIS$RB031, 
levels=c(1936, 
1941, 
1946, 
1951, 
1956, 
1961, 
1966, 
1971, 
1976, 
1981, 
1986, 
1991, 
1996, 
2001, 
2006, 
2011, 
2016), 
labels=c("<=1936", 
"1941 - 1937", 
"1946 - 1942", 
"1951 - 1947", 
"1956 - 1952", 
"1961 - 1957", 
"1966 - 1962", 
"1971 - 1967", 
"1976 - 1972", 
"1981 - 1977", 
"1986 - 1982", 
"1991 - 1987", 
"1996 - 1992", 
"2001 - 1997", 
"2006 - 2002", 
"2011 - 2007", 
"2016 - 2012")) 


RB031_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_REGIS$RB031_F, 
levels=c(1, 
-1, 
-2), 
labels=c("filled", 
"missing", 
"not applicable (no immigration for the person)")) 


RB050_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_REGIS$RB050_F, 
levels=c(1, 
-2, 
-7), 
labels=c("filled", 
"Not applicable (RB110 not equal to 1, 2, 3 or 4)", 
"Not applicable RB010 ne last year")) 


RB070_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_REGIS$RB070, 
levels=c(1, 
2, 
3, 
4), 
labels=c("January-March", 
"April-June", 
"July-September", 
"October-December")) 


RB070_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_REGIS$RB070_F, 
levels=c(1, 
-1), 
labels=c("filled", 
"missing")) 


RB080_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_REGIS$RB080_F, 
levels=c(1, 
-1), 
labels=c("filled", 
"missing")) 


RB090_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_REGIS$RB090, 
levels=c(1, 
2), 
labels=c("Male", 
"Female")) 


RB090_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_REGIS$RB090_F, 
levels=c(1, 
-1), 
labels=c("filled", 
"missing")) 


RB200_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_REGIS$RB200, 
levels=c(1, 
2), 
labels=c("currently living in the household", 
"temporarily absent")) 


RB200_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_REGIS$RB200_F, 
levels=c(1, 
-1, 
-2), 
labels=c("filled", 
"Missing", 
"Not applicable (RB110 not equal to 1, 2, 3 or 4)")) 


RB210_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_REGIS$RB210, 
levels=c(1, 
2, 
3, 
4), 
labels=c("at work", 
"unemployed", 
"in retirement or early retirement", 
"other inactive person")) 


RB210_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_REGIS$RB210_F, 
levels=c(1, 
-1, 
-2), 
labels=c("filled", 
"Missing", 
"Not applicable (RB110 not equal to 1, 2, 3 or 4)")) 


RB220_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_REGIS$RB220_F, 
levels=c(1, 
-1, 
-2), 
labels=c("filled", 
"missing", 
"na (father is not a household member)")) 


RB230_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_REGIS$RB230_F, 
levels=c(1, 
-1, 
-2), 
labels=c("filled", 
"missing", 
"na (mother is not a household member)")) 


RB240_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_REGIS$RB240_F, 
levels=c(1, 
-1, 
-2), 
labels=c("filled", 
"missing", 
"na (spouse/partneris not a household member)")) 


RB245_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_REGIS$RB245, 
levels=c(1, 
2, 
3, 
4), 
labels=c("current household member aged 16 and over Only selected household member aged 16 and over is interviewed", 
"selected respondent", 
"not selected respondent Households members aged less than 16 at the time of interview", 
"not eligible person")) 


RB245_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_REGIS$RB245_F, 
levels=c(1, 
-2), 
labels=c("filled", 
"Not applicable (RB110 not equal to 1, 2, 3 or 4))")) 


RB250_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_REGIS$RB250, 
levels=c(11, 
12, 
13, 
14, 
21, 
22, 
23, 
31, 
32, 
33), 
labels=c("information completed only from interview", 
"information completed only from registers", 
"information completed from both: interview and registers", 
"information completed from full-record imputation", 
"individual unable to respond (illness, incapacity, etc) and no proxy possible", 
"failed to return self-completed questionnaire", 
"refusal to co-operate", 
"person temporarily away and no proxy possible", 
"no contact for other reasons Information or interview not completed", 
"information not completed reason unknown")) 


RB250_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_REGIS$RB250_F, 
levels=c(1, 
-2), 
labels=c("filled", 
"na (RB245 not = 1,2 or 3)")) 


RB260_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_REGIS$RB260, 
levels=c(1, 
2, 
3, 
4, 
5, 
6, 
7, 
8, 
9, 
10), 
labels=c("face to face interview-PAPI", 
"face to face interview-CAPI", 
"CATI telephone interview", 
"self-administered by respondent", 
"Computer assisted web interviewing-CAWI", 
"Face to face interview-PAPI with proxy", 
"Face to face interview-CAPI with proxy", 
"CATI, telephone interview with proxy", 
"Self-administered by respondent with proxy", 
"Computer assisted web interviewing-CAWI with proxy")) 


RB260_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_REGIS$RB260_F, 
levels=c(1, 
-1, 
-2), 
labels=c("filled", 
"missing", 
"Not applicable (RB250 not equal to 11 or 13) or RB245=3")) 


RB270_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_REGIS$RB270_F, 
levels=c(1, 
-1, 
-2), 
labels=c("filled", 
"missing", 
"Not applicable ((RB260 not equal to 6, 7, 8, 9, 10) AND RB010 > 2013) OR ( RB260 ne 5 AND RB010 < 2014))")) 


RL010_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_REGIS$RL010_F, 
levels=c(1, 
-1, 
-2), 
labels=c("filled", 
"missing", 
"na person is not admitted to pre-school because of her age, is at compulsory school or is more than 12 years old")) 


RL020_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_REGIS$RL020_F, 
levels=c(1, 
-1, 
-2), 
labels=c("filled", 
"missing", 
"na person is not admitted to compulsory school because of her age or is more than 12 years")) 


RL030_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_REGIS$RL030_F, 
levels=c(1, 
-1, 
-2), 
labels=c("filled", 
"missing", 
"na: person is neither at pre-school nor at school or is more than 12 years old")) 


RL040_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_REGIS$RL040_F, 
levels=c(1, 
-1, 
-2), 
labels=c("filled", 
"missing", 
"na person is more than 12 years old")) 


RL050_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_REGIS$RL050_F, 
levels=c(1, 
-1, 
-2), 
labels=c("filled", 
"missing", 
"na person is more than 12 years old")) 


RL060_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_REGIS$RL060_F, 
levels=c(1, 
-1, 
-2), 
labels=c("filled", 
"missing", 
"na person is more than 12 years old")) 


RL070_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_REGIS$RL070_F, 
levels=c(1, 
-2, 
-7), 
labels=c("filled", 
"na RB110 not equal to 1, 2, 3 or 4 (persons aged more than 12 years old at the date of interview)", 
"Not applicable RB010 ne last year")) 


RC010_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_REGIS$RC010, 
levels=c(1, 
2), 
labels=c("yes", 
"no")) 


RC010_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_REGIS$RC010_F, 
levels=c(1, 
-1, 
-4, 
-5, 
-7), 
labels=c("filled", 
"missing", 
"no formal childcare for this child (RL030<1 AND RL040<1) OR not current household member (RB110 not in (1,2,3,4))", 
"not applicable (person is more than 12 years old)", 
"not applicable RB010 not = 2016")) 


RC020_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_REGIS$RC020, 
levels=c(1, 
2, 
9), 
labels=c("full price (full cost)", 
"reduced price (subsidised by government, employer, private, person, etc.)", 
"do not know")) 


RC020_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_REGIS$RC020_F, 
levels=c(1, 
-1, 
-2, 
-4, 
-5, 
-7), 
labels=c("filled", 
"missing", 
"not applicable (RC010 = 2)", 
"no formal childcare for this child (RL030<1 AND RL040<1) OR not current household member (RB110 not in (1,2,3,4))", 
"not applicable (person is more than 12 years old)", 
"not applicable RB010 not = 2016")) 


RC030_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_REGIS$RC030, 
levels=c(1, 
2, 
3, 
4, 
5, 
9), 
labels=c("government or local authorities", 
"employer", 
"other institutions (e.g. church, non-profit organisations)", 
"private persons who are not household members", 
"other", 
"do not know")) 


RC030_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_REGIS$RC030_F, 
levels=c(1, 
-1, 
-2, 
-4, 
-5, 
-7), 
labels=c("filled", 
"missing", 
"not applicable (RC020 = 1 OR RC020=9)", 
"no formal childcare for this child (RL030<1 AND RL040<1) OR not current household member (RB110 not in (1,2,3,4))", 
"not applicable (person is more than 12 years old)", 
"not applicable RB010 not = 2016")) 


RC070_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_REGIS$RC070, 
levels=c(1, 
2), 
labels=c("yes", 
"no")) 


RC070_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_REGIS$RC070_F, 
levels=c(1, 
-1, 
-4, 
-7), 
labels=c("filled", 
"missing", 
"person does not follow formal education OR not current household member (RB110 not in (1,2,3,4))", 
"not applicable RB010 not = 2016")) 


RC080_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_REGIS$RC080, 
levels=c(1, 
2, 
9), 
labels=c("full price (full cost)", 
"reduced price (subsidised by government, employer, private, person, etc.)", 
"do not know")) 


RC080_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_REGIS$RC080_F, 
levels=c(1, 
-1, 
-2, 
-4, 
-7), 
labels=c("filled", 
"missing", 
"not applicable (RC070=2)", 
"person does not follow formal education OR not current household member (RB110 not in (1,2,3,4))", 
"not applicable RB010 not = 2016")) 


RC090_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_REGIS$RC090, 
levels=c(1, 
2, 
3, 
4, 
5, 
9), 
labels=c("government or local authorities", 
"employer", 
"other institutions (e.g. church, non-profit organisations)", 
"private persons who are not household members", 
"other", 
"do not know")) 


RC090_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_REGIS$RC090_F, 
levels=c(1, 
-1, 
-2, 
-4, 
-7), 
labels=c("filled", 
"missing", 
"not applicable (RC080=1 OR RC080=9) OR not current household member (RB110 not in (1,2,3,4))", 
"person does not follow formal education", 
"not applicable RB010 not = 2016")) 


RX050_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_REGIS$RX050, 
levels=c(0, 
1, 
2), 
labels=c("no Low Work Intensity", 
"Low Work Intensity", 
"not applicable")) 


RX060_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_REGIS$RX060, 
levels=c(0, 
1), 
labels=c("not severely deprived", 
"severely deprived")) 

save.image (file="DF_EU-SILC_A2016_PERSONAL_REGIS.RData")
