/*    LIMITAZIONE DELLA RESPONSABILITA'. 
  Il software  fornito "cos com'", senza garanzie di  sorta.               */
%macro grabpath;
%qsubstr(%sysget(SAS_EXECFILEPATH),1,%length(%sysget(SAS_EXECFILEPATH))-%length(%sysget(SAS_EXECFILEname)))
%mend grabpath;
%let path = %grabpath;
%let nomeFile =ISTAT_MFR_EU-SILC_Microdati_2016_PERSONAL_DATA_(P-FILE)_Cross-Sectional_ESEMPIO_STRUTTURA_FILE.txt;
LIBNAME ISTAT "&path";
DATA ISTAT.EU-SILC_A2016_PERSONAL_DATA_(P-;

INFILE "&path&nomeFile" DLM='5E'x  LRECL=32767 TRUNCOVER FIRSTOBS=2 IGNOREDOSEOF;
INPUT 
PB010 :5.   /*  YEAR OF THE SURVEY */
PB020 : $9.   /*  COUNTRY */
PB030 :12.   /*  PERSONAL ID */
PB040 :16.   /*  PERSONAL CROSS-SECTIONAL WEIGHT */
PB040_F :2.   /*  FLAGS OF PB040 */
PB060 :9.   /*  PERSONAL CROSS-SECTIONAL WEIGHT FOR SELECTED RESPONDENT */
PB060_F :3.   /*  FLAGS OF PB060 */
PB100 :3.   /*  MONTH OF THE PERSONAL INTERVIEW */
PB100_F :2.   /*  FLAGS OF PB100 */
PB110 :5.   /*  YEAR OF THE PERSONAL INTERVIEW */
PB110_F :2.   /*  FLAGS OF PB110 */
PB120 :3.   /*  MINUTES TO COMPLETE THE PERSONAL QUESTIONNAIRE */
PB120_F :2.   /*  FLAGS OF PB120 */
PB130 :3.   /*  MONTH OF BIRTH */
PB130_F :2.   /*  FLAGS OF PB130 */
PB140 :5.   /*  YEAR OF BIRTH */
PB140_F :2.   /*  FLAGS OF PB140 */
PB150 :2.   /*  SEX */
PB150_F :2.   /*  FLAGS OF PB150 */
PB160 :12.   /*  FATHER ID */
PB160_F :2.   /*  FLAGS OF PB160 */
PB170 :12.   /*  FATHER ID */
PB170_F :2.   /*  FLAGS OF PB170 */
PB180 :12.   /*  SPOUSE/PARTNER ID */
PB180_F :2.   /*  FLAGS OF PB180 */
PB190 :2.   /*  MARITAL STATUS */
PB190_F :2.   /*  FLAGS OF PB190 */
PB200 :2.   /*  CONSENSUAL UNION */
PB200_F :2.   /*  FLAGS OF PB200 */
PB210 : $4.   /*  COUNTRY OF BIRTH */
PB210_F :2.   /*  FLAGS OF PB210 */
PB220A : $4.   /*  CITIZENSHIP 1 */
PB220A_F :2.   /*  FLAGS OF PB220A */
PE010 :2.   /*  CURRENT EDUCATION ACTIVITY */
PE010_F :2.   /*  FLAGS OF PE010 */
PE020 :3.   /*  ISCED LEVEL CURRENTLY ATTENDED */
PE020_F :2.   /*  FLAGS OF PE020 */
PE030 :5.   /*  YEAR WHEN HIGHEST LEVEL OF EDUCATION WAS ATTAINED */
PE030_F :2.   /*  FLAGS OF PE030 */
PE040 :3.   /*  HIGHEST ISCED LEVEL ATTAINED */
PE040_F :2.   /*  FLAGS OF PE040 */
PH010 :2.   /*  GENERAL HEALTH */
PH010_F :2.   /*  FLAGS OF PH010 */
PH020 :2.   /*  SUFFER FROM ANY A CHRONIC (LONG-STANDING) ILLNESS OR CONDITION */
PH020_F :2.   /*  FLAGS OF PH020 */
PH030 :2.   /*  LIMITATION IN ACTIVITIES BECAUSE OF HEALTH PROBLEMS */
PH030_F :2.   /*  FLAGS OF PH030 */
PH040 :2.   /*  UNMET NEED FOR MEDICAL EXAMINATION OR TREATMENT */
PH040_F :2.   /*  FLAGS OF PH040 */
PH050 :2.   /*  MAIN REASON FOR UNMET NEED FOR MEDICAL EXAMINATION OR TREATMENT */
PH050_F :2.   /*  FLAGS OF PH050 */
PH060 :2.   /*  UNMET NEED FOR DENTAL EXAMINATION OR TREATMENT */
PH060_F :2.   /*  FLAGS OF PH060 */
PH070 :2.   /*  MAIN REASON FOR UNMET NEED FOR DENTAL EXAMINATION OR TREATMENT */
PH070_F :2.   /*  FLAGS OF PH070 */
PL015 :2.   /*  PERSON HAS EVER WORKED */
PL015_F :2.   /*  FLAGS OF PL015 */
PL020 :2.   /*  ACTIVELY LOOKING FOR A JOB */
PL020_F :2.   /*  FLAGS OF PL020 */
PL025 :2.   /*  AVAILABLE FOR WORK */
PL025_F :2.   /*  FLAGS OF PL025 */
PL031 :2.   /*  SELF-DEFINED CURRENT ECONOMIC STATUS */
PL031_F :2.   /*  FLAGS OF PL031 */
PL035 :2.   /*  WORKED AT LEAST 1 HOUR DURING THE PREVIOUS WEEK */
PL035_F :2.   /*  FLAGS OF PL035 */
PL040 :2.   /*  STATUS IN EMPLOYMENT */
PL040_F :2.   /*  FLAGS OF PL040 */
PL051 :3.   /*  OCCUPATION (ISCO-8 (COM)) */
PL051_F :2.   /*  FLAGS OF PL051 */
PL060 :3.   /*  NUMBER OF HOURS USUALLY WORKED PER WEEK IN MAIN JOB */
PL060_F :2.   /*  FLAGS OF PL060 */
PL073 :3.   /*  NUMBER OF MONTHS SPENT AT FULL-TIME WORK AS UNEMPLOYMENT */
PL073_F :2.   /*  FLAGS OF PL073 */
PL074 :3.   /*  NUMBER OF MONTHS SPENT AT PART-TIME WORK AS UNEMPLOYMENT */
PL074_F :2.   /*  FLAGS OF PL074 */
PL075 :3.   /*  NUMBER OF MONTHS SPENT AT FULL-TIME WORK AS SELF- UNEMPLOYMENT (INCLUDING FAMILY WORKER */
PL075_F :2.   /*  FLAGS OF PL075 */
PL076 :3.   /*  NUMBER OF MONTHS SPENT AT PART-TIME WORK AS SELF- UNEMPLOYMENT (INCLUDING FAMILY WORKER */
PL076_F :2.   /*  FLAGS OF PL076 */
PL080 :3.   /*  NUMBER OF MONTHS SPENT IN UNEMPLOYMENT */
PL080_F :2.   /*  FLAGS OF PL080 */
PL085 :3.   /*  NUMBER OF MONTHS SPENT IN RETIREMENT OR EARLY RETIREMENT */
PL085_F :2.   /*  FLAGS OF PL085 */
PL086 :3.   /*  NUMBER OF MONTHS SPENT AS DISABLED OR/AND UNFIT TO WORK */
PL086_F :2.   /*  FLAGS OF PL086 */
PL087 :3.   /*  NUMBER OF MONTHS SPENT STUDYING */
PL087_F :2.   /*  FLAGS OF PL087 */
PL088 :3.   /*  NUMBER OF MONTHS SPENT IN COMPULSORY MILITARY SERVICE */
PL088_F :2.   /*  FLAGS OF PL088 */
PL089 :3.   /*  NUMBER OF MONTHS SPENT FULFILLING DOMESTIC TASKS AND CARE RESPONSIBILITIES */
PL089_F :2.   /*  FLAGS OF PL089 */
PL090 :3.   /*  NUMBER OF MONTHS SPENT IN OTHER INACTIVITY */
PL090_F :2.   /*  FLAGS OF PL090 */
PL100 :3.   /*  TOTAL NUMBER OF HOURS USUALLY WORKED IN SECOND THIRD JOBS */
PL100_F :2.   /*  FLAGS OF PL100 */
PL111 : $5.   /*  NACE REV.2 */
PL111_F :2.   /*  FLAGS OF PL111 */
PL120 :2.   /*  REASON FOR WORKING LESS THAN 30 HOURS */
PL120_F :2.   /*  FLAGS OF PL120 */
PL130 :3.   /*  NUMBER OF PERSONS WORKING AT THE LOCAL UNIT */
PL130_F :2.   /*  FLAGS OF PL130 */
PL140 :2.   /*  TYPE OF CONTRACT */
PL140_F :2.   /*  FLAGS OF PL140 */
PL150 :2.   /*  MANAGERIAL POSITION */
PL150_F :2.   /*  FLAGS OF PL150 */
PL160 :2.   /*  CHANGE OF JOB SINCE LAST YEAR */
PL160_F :2.   /*  FLAGS OF PL160 */
PL170 :2.   /*  REASON FOR CHANGE */
PL170_F :2.   /*  FLAGS OF PL170 */
PL180 :3.   /*  MOST RECENT CHANGE IN THE INDIVIDUALS ACTIVITY STATUS */
PL180_F :2.   /*  FLAGS OF PL180 */
PL190 :3.   /*  WHEN BEGAN FIRST REGULAR JOB */
PL190_F :2.   /*  FLAGS OF PL190 */
PL200 :3.   /*  NUMBER OF YEARS SPENT IN PAID WORK */
PL200_F :2.   /*  FLAGS OF PL200 */
PL211A :2.   /*  MAIN ACTIVITY ON JANUARY */
PL211A_F :2.   /*  FLAGS OF PL211A */
PL211B :2.   /*  MAIN ACTIVITY ON FEBRUARY */
PL211B_F :2.   /*  FLAGS OF PL211B */
PL211C :2.   /*  MAIN ACTIVITY ON MARCH */
PL211C_F :2.   /*  FLAGS OF PL211C */
PL211D :2.   /*  MAIN ACTIVITY ON APRIL */
PL211D_F :2.   /*  FLAGS OF PL211D */
PL211E :2.   /*  MAIN ACTIVITY ON MAY */
PL211E_F :2.   /*  FLAGS OF PL211E */
PL211F :2.   /*  MAIN ACTIVITY ON JUNE */
PL211F_F :2.   /*  FLAGS OF PL211F */
PL211G :2.   /*  MAIN ACTIVITY ON JULY */
PL211G_F :2.   /*  FLAGS OF PL211G */
PL211H :2.   /*  MAIN ACTIVITY ON AUGUST */
PL211H_F :2.   /*  FLAGS OF PL211H */
PL211I :2.   /*  MAIN ACTIVITY ON SEPTEMBER */
PL211I_F :2.   /*  FLAGS OF PL211I */
PL211J :2.   /*  MAIN ACTIVITY ON OCTOBER */
PL211J_F :2.   /*  FLAGS OF PL211J */
PL211K :2.   /*  MAIN ACTIVITY ON NOVEMBER */
PL211K_F :2.   /*  FLAGS OF PL211K */
PL211L :2.   /*  MAIN ACTIVITY ON DECEMBER */
PL211L_F :2.   /*  FLAGS OF PL211L */
PY010N :7.   /*  EMPLOYEE CASH OR NEAR CASH INCOME */
PY010N_F :2.   /*  FLAGS OF PY010N */
PY010N_I :10.   /*  FLAGS OF PY010N */
PY020N :7.   /*  NON-CASH EMPLOYEE INCOME */
PY020N_F :2.   /*  FLAGS OF PY020N */
PY020N_I :10.   /*  FLAGS OF PY020N */
PY021N :7.   /*  COMPANY CAR */
PY021N_F :2.   /*  FLAGS OF PY021N */
PY021N_I :10.   /*  FLAGS OF PY021N */
PY035N :7.   /*  CONTRIBUTIONS TO INDIVIDUAL PRIVATE PENSION PLANS */
PY035N_F :2.   /*  FLAGS OF PY035N */
PY035N_I :10.   /*  FLAGS OF PY035N */
PY050N :7.   /*  CASH BENEFITS OR LOSSES FROM SELF-EMPLOYMENT */
PY050N_F :2.   /*  FLAGS OF PY050N */
PY050N_I :10.   /*  FLAGS OF PY050N */
PY080N :7.   /*  PENSION FROM INDIVIDUAL PRIVATE PLANS */
PY080N_F :2.   /*  FLAGS OF PY080N */
PY080N_I :10.   /*  FLAGS OF PY080N */
PY090N :7.   /*  UNEMPLOYMENT BENEFITS */
PY090N_F :2.   /*  FLAGS OF PY090N */
PY090N_I :10.   /*  FLAGS OF PY090N */
PY100N :7.   /*  OLD-AGE BENEFITS */
PY100N_F :2.   /*  FLAGS OF PY100N */
PY100N_I :10.   /*  FLAGS OF PY100N */
PY110N :7.   /*  SURVIVOR BENEFITS */
PY110N_F :2.   /*  FLAGS OF PY110N */
PY110N_I :10.   /*  FLAGS OF PY110N */
PY120N :7.   /*  SICKNESS BENEFITS */
PY120N_F :2.   /*  FLAGS OF PY120N */
PY120N_I :10.   /*  FLAGS OF PY120N */
PY130N :7.   /*  DISABILITY BENEFITS */
PY130N_F :2.   /*  FLAGS OF PY130N */
PY130N_I :10.   /*  FLAGS OF PY130N */
PY140N :7.   /*  EDUCATION-RELATED ALLOWANCES */
PY140N_F :2.   /*  FLAGS OF PY140N */
PY140N_I :10.   /*  FLAGS OF PY140N */
PY010G :8.   /*  EMPLOYEE CASH OR NEAR CASH INCOME */
PY010G_F :2.   /*  FLAGS OF PY010G */
PY010G_I :10.   /*  FLAGS OF PY010G */
PY020G :7.   /*  NON-CASH EMPLOYEE INCOME */
PY020G_F :2.   /*  FLAGS OF PY020G */
PY020G_I :10.   /*  FLAGS OF PY020G */
PY021G :7.   /*  COMPANY CAR */
PY021G_F :2.   /*  FLAGS OF PY021G */
PY021G_I :10.   /*  FLAGS OF PY021G */
PY030G :8.   /*  EMPLOYER'S SOCIAL INSURANCE CONTRIBUTION */
PY030G_F :2.   /*  FLAGS OF PY030G */
PY030G_I :10.   /*  FLAGS OF PY030G */
PY031G :8.   /*  OPTIONAL EMPLOYER'S SOCIAL INSURANCE CONTRIBUTIONS */
PY031G_F :2.   /*  FLAGS OF PY031G */
PY031G_I :10.   /*  FLAGS OF PY031G */
PY035G :7.   /*  CONTRIBUTIONS TO INDIVIDUAL PRIVATE PENSION PLANS */
PY035G_F :2.   /*  FLAGS OF PY035G */
PY035G_I :10.   /*  FLAGS OF PY035G */
PY050G :8.   /*  CASH BENEFITS OR LOSSES FROM SELF-EMPLOYMENT */
PY050G_F :2.   /*  FLAGS OF PY050G */
PY050G_I :10.   /*  FLAGS OF PY050G */
PY080G :7.   /*  PENSION FROM INDIVIDUAL PRIVATE PLANS */
PY080G_F :2.   /*  FLAGS OF PY080G */
PY080G_I :10.   /*  FLAGS OF PY080G */
PY090G :7.   /*  UNEMPLOYMENT BENEFITS */
PY090G_F :2.   /*  FLAGS OF PY090G */
PY090G_I :10.   /*  FLAGS OF PY090G */
PY091G :6.   /*  UNEMPLOYMENT BENEFITS (CONTRIBUTORY AND MEANS-TESTED) */
PY091G_F :2.   /*  FLAGS OF PY091G */
PY092G :6.   /*  UNEMPLOYMENT BENEFITS (CONTRIBUTORY AND NON MEANS-TESTED) */
PY092G_F :2.   /*  FLAGS OF PY092G */
PY093G :6.   /*  UNEMPLOYMENT BENEFITS (NON-CONTRIBUTORY AND MEANS-TESTED) */
PY093G_F :2.   /*  FLAGS OF PY093G */
PY094G :6.   /*  UNEMPLOYMENT BENEFITS (NON-CONTRIBUTORY AND NON MEANS-TESTED) */
PY094G_F :2.   /*  FLAGS OF PY094G */
PY100G :7.   /*  OLD-AGE BENEFITS */
PY100G_F :2.   /*  FLAGS OF PY100G */
PY100G_I :10.   /*  FLAGS OF PY100G */
PY101G :6.   /*  OLD-AGE BENEFITS (CONTRIBUTORY AND MEANS-TESTED) */
PY101G_F :2.   /*  FLAGS OF PY101G */
PY102G :6.   /*  OLD-AGE BENEFITS (CONTRIBUTORY AND NON MEANS-TESTED) */
PY102G_F :2.   /*  FLAGS OF PY102G */
PY103G :6.   /*  OLD-AGE BENEFITS (NON-CONTRIBUTORY AND MEANS-TESTED) */
PY103G_F :2.   /*  FLAGS OF PY103G */
PY104G :6.   /*  OLD-AGE BENEFITS (NON-CONTRIBUTORY AND NON MEANS-TESTED) */
PY104G_F :2.   /*  FLAGS OF PY104G */
PY110G :7.   /*  SURVIVOR BENEFITS */
PY110G_F :2.   /*  FLAGS OF PY110G */
PY110G_I :10.   /*  FLAGS OF PY110G */
PY111G :6.   /*  SURVIVOR BENEFITS (CONTRIBUTORY AND MEANS-TESTED) */
PY111G_F :2.   /*  FLAGS OF PY111G */
PY112G :6.   /*  SURVIVOR BENEFITS (CONTRIBUTORY AND NON MEANS-TESTED) */
PY112G_F :2.   /*  FLAGS OF PY112G */
PY113G :6.   /*  SURVIVOR BENEFITS (NON-CONTRIBUTORY AND MEANS-TESTED) */
PY113G_F :2.   /*  FLAGS OF PY113G */
PY114G :6.   /*  SURVIVOR BENEFITS (NON-CONTRIBUTORY AND NON MEANS-TESTED) */
PY114G_F :2.   /*  FLAGS OF PY114G */
PY120G :12.   /*  SICKNESS BENEFITS */
PY120G_F :2.   /*  FLAGS OF PY120G */
PY120G_I :10.   /*  FLAGS OF PY120G */
PY121G :6.   /*  SICKNESS BENEFITS (CONTRIBUTORY AND MEANS-TESTED) */
PY121G_F :2.   /*  FLAGS OF PY121G */
PY122G :6.   /*  SICKNESS BENEFITS (CONTRIBUTORY AND NON MEANS-TESTED) */
PY122G_F :2.   /*  FLAGS OF PY122G */
PY123G :6.   /*  SICKNESS BENEFITS (NON-CONTRIBUTORY AND MEANS-TESTED) */
PY123G_F :2.   /*  FLAGS OF PY123G */
PY124G :6.   /*  SICKNESS BENEFITS (NON-CONTRIBUTORY AND NON MEANS-TESTED) */
PY124G_F :2.   /*  FLAGS OF PY124G */
PY130G :7.   /*  DISABILITY BENEFITS */
PY130G_F :2.   /*  FLAGS OF PY130G */
PY130G_I :10.   /*  FLAGS OF PY130G */
PY131G :6.   /*  DISABILITY BENEFITS (CONTRIBUTORY AND MEANS-TESTED) */
PY131G_F :2.   /*  FLAGS OF PY131G */
PY132G :6.   /*  DISABILITY BENEFITS (CONTRIBUTORY AND NON MEANS-TESTED) */
PY132G_F :2.   /*  FLAGS OF PY132G */
PY133G :6.   /*  DISABILITY BENEFITS (NON-CONTRIBUTORY AND MEANS-TESTED) */
PY133G_F :2.   /*  FLAGS OF PY133G */
PY134G :6.   /*  DISABILITY BENEFITS (NON-CONTRIBUTORY AND NON MEANS-TESTED) */
PY134G_F :2.   /*  FLAGS OF PY134G */
PY140G :7.   /*  EDUCATION-RELATED ALLOWANCES */
PY140G_F :2.   /*  FLAGS OF PY140G */
PY140G_I :10.   /*  FLAGS OF PY140G */
PY141G :6.   /*  EDUCATION-RELATED ALLOWANCES (CONTRIBUTORY AND MEANS-TESTED) */
PY141G_F :2.   /*  FLAGS OF PY141G */
PY142G :6.   /*  EDUCATION-RELATED ALLOWANCES (CONTRIBUTORY AND NON MEANS-TESTED) */
PY142G_F :2.   /*  FLAGS OF PY142G */
PY143G :6.   /*  EDUCATION-RELATED ALLOWANCES (NON-CONTRIBUTORY AND MEANS-TESTED) */
PY143G_F :2.   /*  FLAGS OF PY143G */
PY144G :6.   /*  EDUCATION-RELATED ALLOWANCES (NON-CONTRIBUTORY AND NON MEANS-TESTED) */
PY144G_F :2.   /*  FLAGS OF PY144G */
PY200G :7.   /*  GROSS MONTHLY EARNINGS FOR EMPLOYEES */
PY200G_F :2.   /*  FLAGS OF PY200G */
PY200G_I :10.   /*  FLAGS OF PY200G */
PD020 :2.   /*  REPLACE WORN-OUT CLOTHES BY SOME NEW (NOT SECOND-HAND) ONES */
PD020_F :2.   /*  FLAGS OF PD020 */
PD030 :2.   /*  TWO PAIRS OF PROPERLY FITTING SHOES (INCLUDING A PAIR OF ALL-WEATHER SHOES) */
PD030_F :2.   /*  FLAGS OF PD030 */
PD050 :2.   /*  GET-TOGETHER WITH FRIENDS/FAMILY (RELATIVES) FOR A DRINK/MEAL AT LEAST ONCE A MONTH */
PD050_F :2.   /*  FLAGS OF PD050 */
PD060 :2.   /*  REGULARLY PARTICIPATE IN A LEISURE ACTIVITY */
PD060_F :2.   /*  FLAGS OF PD060 */
PD070 :2.   /*  SPEND A SMALL AMOUNT OF MONEY EACH WEEK ON YOURSELF */
PD070_F :2.   /*  FLAGS OF PD070 */
PD080 :2.   /*  INTERNET CONNECTION FOR PERSONAL USE AT HOME */
PD080_F :2.   /*  FLAGS OF PD080 */
PC110 :2.   /*  UNMET NEEDS FOR FORMAL EDUCATION */
PC110_F :2.   /*  FLAGS OF PC110 */
PC120 :2.   /*  MAIN REASON FOR NON-PARTICIPATION IN FORMAL EDUCATION */
PC120_F :2.   /*  FLAGS OF PC120 */
PC130 :2.   /*  PARTICIPATION IN TRAINING RELATED TO HOBBIES */
PC130_F :2.   /*  FLAGS OF PC130 */
PC140 :2.   /*  PARTICIPATION IN TRAINING RELATED TO PROFESSIONAL ACTIVITY */
PC140_F :2.   /*  FLAGS OF PC140 */
PC150 :2.   /*  MAIN REASON FOR NON-PARTICIPATION IN TRAINING RELATED TO PROFESSIONAL ACTIVITY */
PC150_F :2.   /*  FLAGS OF PC150 */
PC260 :2.   /*  CARE OR ASSISTANCE PROVIDED */
PC260_F :2.   /*  FLAGS OF PC260 */
PC270 :2.   /*  NUMBER OF HOURS PER WEEK OF CARE OR ASSISTANCE PROVIDED */
PC270_F :2.   /*  FLAGS OF PC270 */
PX010 :2.   /*  CHANGE RATE */
PX020 :3.   /*  AGE AT THE END OF THE INCOME REFERENCE PERIOD */
PX030 :6.   /*  HOUSEHOLD IDENTIFICATION NUMBER */
PX040 :2.   /*  SELECTED RESPONDENT STATUS */
PX050 :2.   /*  ACTIVITY STATUS */
;
LABEL 
PB010 = "YEAR OF THE SURVEY"
PB020 = "COUNTRY"
PB030 = "PERSONAL ID"
PB040 = "PERSONAL CROSS-SECTIONAL WEIGHT"
PB040_F = "FLAGS OF PB040"
PB060 = "PERSONAL CROSS-SECTIONAL WEIGHT FOR SELECTED RESPONDENT"
PB060_F = "FLAGS OF PB060"
PB100 = "MONTH OF THE PERSONAL INTERVIEW"
PB100_F = "FLAGS OF PB100"
PB110 = "YEAR OF THE PERSONAL INTERVIEW"
PB110_F = "FLAGS OF PB110"
PB120 = "MINUTES TO COMPLETE THE PERSONAL QUESTIONNAIRE"
PB120_F = "FLAGS OF PB120"
PB130 = "MONTH OF BIRTH"
PB130_F = "FLAGS OF PB130"
PB140 = "YEAR OF BIRTH"
PB140_F = "FLAGS OF PB140"
PB150 = "SEX"
PB150_F = "FLAGS OF PB150"
PB160 = "FATHER ID"
PB160_F = "FLAGS OF PB160"
PB170 = "FATHER ID"
PB170_F = "FLAGS OF PB170"
PB180 = "SPOUSE/PARTNER ID"
PB180_F = "FLAGS OF PB180"
PB190 = "MARITAL STATUS"
PB190_F = "FLAGS OF PB190"
PB200 = "CONSENSUAL UNION"
PB200_F = "FLAGS OF PB200"
PB210 = "COUNTRY OF BIRTH"
PB210_F = "FLAGS OF PB210"
PB220A = "CITIZENSHIP 1"
PB220A_F = "FLAGS OF PB220A"
PE010 = "CURRENT EDUCATION ACTIVITY"
PE010_F = "FLAGS OF PE010"
PE020 = "ISCED LEVEL CURRENTLY ATTENDED"
PE020_F = "FLAGS OF PE020"
PE030 = "YEAR WHEN HIGHEST LEVEL OF EDUCATION WAS ATTAINED"
PE030_F = "FLAGS OF PE030"
PE040 = "HIGHEST ISCED LEVEL ATTAINED"
PE040_F = "FLAGS OF PE040"
PH010 = "GENERAL HEALTH"
PH010_F = "FLAGS OF PH010"
PH020 = "SUFFER FROM ANY A CHRONIC (LONG-STANDING) ILLNESS OR CONDITION"
PH020_F = "FLAGS OF PH020"
PH030 = "LIMITATION IN ACTIVITIES BECAUSE OF HEALTH PROBLEMS"
PH030_F = "FLAGS OF PH030"
PH040 = "UNMET NEED FOR MEDICAL EXAMINATION OR TREATMENT"
PH040_F = "FLAGS OF PH040"
PH050 = "MAIN REASON FOR UNMET NEED FOR MEDICAL EXAMINATION OR TREATMENT"
PH050_F = "FLAGS OF PH050"
PH060 = "UNMET NEED FOR DENTAL EXAMINATION OR TREATMENT"
PH060_F = "FLAGS OF PH060"
PH070 = "MAIN REASON FOR UNMET NEED FOR DENTAL EXAMINATION OR TREATMENT"
PH070_F = "FLAGS OF PH070"
PL015 = "PERSON HAS EVER WORKED"
PL015_F = "FLAGS OF PL015"
PL020 = "ACTIVELY LOOKING FOR A JOB"
PL020_F = "FLAGS OF PL020"
PL025 = "AVAILABLE FOR WORK"
PL025_F = "FLAGS OF PL025"
PL031 = "SELF-DEFINED CURRENT ECONOMIC STATUS"
PL031_F = "FLAGS OF PL031"
PL035 = "WORKED AT LEAST 1 HOUR DURING THE PREVIOUS WEEK"
PL035_F = "FLAGS OF PL035"
PL040 = "STATUS IN EMPLOYMENT"
PL040_F = "FLAGS OF PL040"
PL051 = "OCCUPATION (ISCO-8 (COM))"
PL051_F = "FLAGS OF PL051"
PL060 = "NUMBER OF HOURS USUALLY WORKED PER WEEK IN MAIN JOB"
PL060_F = "FLAGS OF PL060"
PL073 = "NUMBER OF MONTHS SPENT AT FULL-TIME WORK AS UNEMPLOYMENT"
PL073_F = "FLAGS OF PL073"
PL074 = "NUMBER OF MONTHS SPENT AT PART-TIME WORK AS UNEMPLOYMENT"
PL074_F = "FLAGS OF PL074"
PL075 = "NUMBER OF MONTHS SPENT AT FULL-TIME WORK AS SELF- UNEMPLOYMENT (INCLUDING FAMILY WORKER"
PL075_F = "FLAGS OF PL075"
PL076 = "NUMBER OF MONTHS SPENT AT PART-TIME WORK AS SELF- UNEMPLOYMENT (INCLUDING FAMILY WORKER"
PL076_F = "FLAGS OF PL076"
PL080 = "NUMBER OF MONTHS SPENT IN UNEMPLOYMENT"
PL080_F = "FLAGS OF PL080"
PL085 = "NUMBER OF MONTHS SPENT IN RETIREMENT OR EARLY RETIREMENT"
PL085_F = "FLAGS OF PL085"
PL086 = "NUMBER OF MONTHS SPENT AS DISABLED OR/AND UNFIT TO WORK"
PL086_F = "FLAGS OF PL086"
PL087 = "NUMBER OF MONTHS SPENT STUDYING"
PL087_F = "FLAGS OF PL087"
PL088 = "NUMBER OF MONTHS SPENT IN COMPULSORY MILITARY SERVICE"
PL088_F = "FLAGS OF PL088"
PL089 = "NUMBER OF MONTHS SPENT FULFILLING DOMESTIC TASKS AND CARE RESPONSIBILITIES"
PL089_F = "FLAGS OF PL089"
PL090 = "NUMBER OF MONTHS SPENT IN OTHER INACTIVITY"
PL090_F = "FLAGS OF PL090"
PL100 = "TOTAL NUMBER OF HOURS USUALLY WORKED IN SECOND THIRD JOBS"
PL100_F = "FLAGS OF PL100"
PL111 = "NACE REV.2"
PL111_F = "FLAGS OF PL111"
PL120 = "REASON FOR WORKING LESS THAN 30 HOURS"
PL120_F = "FLAGS OF PL120"
PL130 = "NUMBER OF PERSONS WORKING AT THE LOCAL UNIT"
PL130_F = "FLAGS OF PL130"
PL140 = "TYPE OF CONTRACT"
PL140_F = "FLAGS OF PL140"
PL150 = "MANAGERIAL POSITION"
PL150_F = "FLAGS OF PL150"
PL160 = "CHANGE OF JOB SINCE LAST YEAR"
PL160_F = "FLAGS OF PL160"
PL170 = "REASON FOR CHANGE"
PL170_F = "FLAGS OF PL170"
PL180 = "MOST RECENT CHANGE IN THE INDIVIDUALS ACTIVITY STATUS"
PL180_F = "FLAGS OF PL180"
PL190 = "WHEN BEGAN FIRST REGULAR JOB"
PL190_F = "FLAGS OF PL190"
PL200 = "NUMBER OF YEARS SPENT IN PAID WORK"
PL200_F = "FLAGS OF PL200"
PL211A = "MAIN ACTIVITY ON JANUARY"
PL211A_F = "FLAGS OF PL211A"
PL211B = "MAIN ACTIVITY ON FEBRUARY"
PL211B_F = "FLAGS OF PL211B"
PL211C = "MAIN ACTIVITY ON MARCH"
PL211C_F = "FLAGS OF PL211C"
PL211D = "MAIN ACTIVITY ON APRIL"
PL211D_F = "FLAGS OF PL211D"
PL211E = "MAIN ACTIVITY ON MAY"
PL211E_F = "FLAGS OF PL211E"
PL211F = "MAIN ACTIVITY ON JUNE"
PL211F_F = "FLAGS OF PL211F"
PL211G = "MAIN ACTIVITY ON JULY"
PL211G_F = "FLAGS OF PL211G"
PL211H = "MAIN ACTIVITY ON AUGUST"
PL211H_F = "FLAGS OF PL211H"
PL211I = "MAIN ACTIVITY ON SEPTEMBER"
PL211I_F = "FLAGS OF PL211I"
PL211J = "MAIN ACTIVITY ON OCTOBER"
PL211J_F = "FLAGS OF PL211J"
PL211K = "MAIN ACTIVITY ON NOVEMBER"
PL211K_F = "FLAGS OF PL211K"
PL211L = "MAIN ACTIVITY ON DECEMBER"
PL211L_F = "FLAGS OF PL211L"
PY010N = "EMPLOYEE CASH OR NEAR CASH INCOME"
PY010N_F = "FLAGS OF PY010N"
PY010N_I = "FLAGS OF PY010N"
PY020N = "NON-CASH EMPLOYEE INCOME"
PY020N_F = "FLAGS OF PY020N"
PY020N_I = "FLAGS OF PY020N"
PY021N = "COMPANY CAR"
PY021N_F = "FLAGS OF PY021N"
PY021N_I = "FLAGS OF PY021N"
PY035N = "CONTRIBUTIONS TO INDIVIDUAL PRIVATE PENSION PLANS"
PY035N_F = "FLAGS OF PY035N"
PY035N_I = "FLAGS OF PY035N"
PY050N = "CASH BENEFITS OR LOSSES FROM SELF-EMPLOYMENT"
PY050N_F = "FLAGS OF PY050N"
PY050N_I = "FLAGS OF PY050N"
PY080N = "PENSION FROM INDIVIDUAL PRIVATE PLANS"
PY080N_F = "FLAGS OF PY080N"
PY080N_I = "FLAGS OF PY080N"
PY090N = "UNEMPLOYMENT BENEFITS"
PY090N_F = "FLAGS OF PY090N"
PY090N_I = "FLAGS OF PY090N"
PY100N = "OLD-AGE BENEFITS"
PY100N_F = "FLAGS OF PY100N"
PY100N_I = "FLAGS OF PY100N"
PY110N = "SURVIVOR BENEFITS"
PY110N_F = "FLAGS OF PY110N"
PY110N_I = "FLAGS OF PY110N"
PY120N = "SICKNESS BENEFITS"
PY120N_F = "FLAGS OF PY120N"
PY120N_I = "FLAGS OF PY120N"
PY130N = "DISABILITY BENEFITS"
PY130N_F = "FLAGS OF PY130N"
PY130N_I = "FLAGS OF PY130N"
PY140N = "EDUCATION-RELATED ALLOWANCES"
PY140N_F = "FLAGS OF PY140N"
PY140N_I = "FLAGS OF PY140N"
PY010G = "EMPLOYEE CASH OR NEAR CASH INCOME"
PY010G_F = "FLAGS OF PY010G"
PY010G_I = "FLAGS OF PY010G"
PY020G = "NON-CASH EMPLOYEE INCOME"
PY020G_F = "FLAGS OF PY020G"
PY020G_I = "FLAGS OF PY020G"
PY021G = "COMPANY CAR"
PY021G_F = "FLAGS OF PY021G"
PY021G_I = "FLAGS OF PY021G"
PY030G = "EMPLOYER'S SOCIAL INSURANCE CONTRIBUTION"
PY030G_F = "FLAGS OF PY030G"
PY030G_I = "FLAGS OF PY030G"
PY031G = "OPTIONAL EMPLOYER'S SOCIAL INSURANCE CONTRIBUTIONS"
PY031G_F = "FLAGS OF PY031G"
PY031G_I = "FLAGS OF PY031G"
PY035G = "CONTRIBUTIONS TO INDIVIDUAL PRIVATE PENSION PLANS"
PY035G_F = "FLAGS OF PY035G"
PY035G_I = "FLAGS OF PY035G"
PY050G = "CASH BENEFITS OR LOSSES FROM SELF-EMPLOYMENT"
PY050G_F = "FLAGS OF PY050G"
PY050G_I = "FLAGS OF PY050G"
PY080G = "PENSION FROM INDIVIDUAL PRIVATE PLANS"
PY080G_F = "FLAGS OF PY080G"
PY080G_I = "FLAGS OF PY080G"
PY090G = "UNEMPLOYMENT BENEFITS"
PY090G_F = "FLAGS OF PY090G"
PY090G_I = "FLAGS OF PY090G"
PY091G = "UNEMPLOYMENT BENEFITS (CONTRIBUTORY AND MEANS-TESTED)"
PY091G_F = "FLAGS OF PY091G"
PY092G = "UNEMPLOYMENT BENEFITS (CONTRIBUTORY AND NON MEANS-TESTED)"
PY092G_F = "FLAGS OF PY092G"
PY093G = "UNEMPLOYMENT BENEFITS (NON-CONTRIBUTORY AND MEANS-TESTED)"
PY093G_F = "FLAGS OF PY093G"
PY094G = "UNEMPLOYMENT BENEFITS (NON-CONTRIBUTORY AND NON MEANS-TESTED)"
PY094G_F = "FLAGS OF PY094G"
PY100G = "OLD-AGE BENEFITS"
PY100G_F = "FLAGS OF PY100G"
PY100G_I = "FLAGS OF PY100G"
PY101G = "OLD-AGE BENEFITS (CONTRIBUTORY AND MEANS-TESTED)"
PY101G_F = "FLAGS OF PY101G"
PY102G = "OLD-AGE BENEFITS (CONTRIBUTORY AND NON MEANS-TESTED)"
PY102G_F = "FLAGS OF PY102G"
PY103G = "OLD-AGE BENEFITS (NON-CONTRIBUTORY AND MEANS-TESTED)"
PY103G_F = "FLAGS OF PY103G"
PY104G = "OLD-AGE BENEFITS (NON-CONTRIBUTORY AND NON MEANS-TESTED)"
PY104G_F = "FLAGS OF PY104G"
PY110G = "SURVIVOR BENEFITS"
PY110G_F = "FLAGS OF PY110G"
PY110G_I = "FLAGS OF PY110G"
PY111G = "SURVIVOR BENEFITS (CONTRIBUTORY AND MEANS-TESTED)"
PY111G_F = "FLAGS OF PY111G"
PY112G = "SURVIVOR BENEFITS (CONTRIBUTORY AND NON MEANS-TESTED)"
PY112G_F = "FLAGS OF PY112G"
PY113G = "SURVIVOR BENEFITS (NON-CONTRIBUTORY AND MEANS-TESTED)"
PY113G_F = "FLAGS OF PY113G"
PY114G = "SURVIVOR BENEFITS (NON-CONTRIBUTORY AND NON MEANS-TESTED)"
PY114G_F = "FLAGS OF PY114G"
PY120G = "SICKNESS BENEFITS"
PY120G_F = "FLAGS OF PY120G"
PY120G_I = "FLAGS OF PY120G"
PY121G = "SICKNESS BENEFITS (CONTRIBUTORY AND MEANS-TESTED)"
PY121G_F = "FLAGS OF PY121G"
PY122G = "SICKNESS BENEFITS (CONTRIBUTORY AND NON MEANS-TESTED)"
PY122G_F = "FLAGS OF PY122G"
PY123G = "SICKNESS BENEFITS (NON-CONTRIBUTORY AND MEANS-TESTED)"
PY123G_F = "FLAGS OF PY123G"
PY124G = "SICKNESS BENEFITS (NON-CONTRIBUTORY AND NON MEANS-TESTED)"
PY124G_F = "FLAGS OF PY124G"
PY130G = "DISABILITY BENEFITS"
PY130G_F = "FLAGS OF PY130G"
PY130G_I = "FLAGS OF PY130G"
PY131G = "DISABILITY BENEFITS (CONTRIBUTORY AND MEANS-TESTED)"
PY131G_F = "FLAGS OF PY131G"
PY132G = "DISABILITY BENEFITS (CONTRIBUTORY AND NON MEANS-TESTED)"
PY132G_F = "FLAGS OF PY132G"
PY133G = "DISABILITY BENEFITS (NON-CONTRIBUTORY AND MEANS-TESTED)"
PY133G_F = "FLAGS OF PY133G"
PY134G = "DISABILITY BENEFITS (NON-CONTRIBUTORY AND NON MEANS-TESTED)"
PY134G_F = "FLAGS OF PY134G"
PY140G = "EDUCATION-RELATED ALLOWANCES"
PY140G_F = "FLAGS OF PY140G"
PY140G_I = "FLAGS OF PY140G"
PY141G = "EDUCATION-RELATED ALLOWANCES (CONTRIBUTORY AND MEANS-TESTED)"
PY141G_F = "FLAGS OF PY141G"
PY142G = "EDUCATION-RELATED ALLOWANCES (CONTRIBUTORY AND NON MEANS-TESTED)"
PY142G_F = "FLAGS OF PY142G"
PY143G = "EDUCATION-RELATED ALLOWANCES (NON-CONTRIBUTORY AND MEANS-TESTED)"
PY143G_F = "FLAGS OF PY143G"
PY144G = "EDUCATION-RELATED ALLOWANCES (NON-CONTRIBUTORY AND NON MEANS-TESTED)"
PY144G_F = "FLAGS OF PY144G"
PY200G = "GROSS MONTHLY EARNINGS FOR EMPLOYEES"
PY200G_F = "FLAGS OF PY200G"
PY200G_I = "FLAGS OF PY200G"
PD020 = "REPLACE WORN-OUT CLOTHES BY SOME NEW (NOT SECOND-HAND) ONES"
PD020_F = "FLAGS OF PD020"
PD030 = "TWO PAIRS OF PROPERLY FITTING SHOES (INCLUDING A PAIR OF ALL-WEATHER SHOES)"
PD030_F = "FLAGS OF PD030"
PD050 = "GET-TOGETHER WITH FRIENDS/FAMILY (RELATIVES) FOR A DRINK/MEAL AT LEAST ONCE A MONTH"
PD050_F = "FLAGS OF PD050"
PD060 = "REGULARLY PARTICIPATE IN A LEISURE ACTIVITY"
PD060_F = "FLAGS OF PD060"
PD070 = "SPEND A SMALL AMOUNT OF MONEY EACH WEEK ON YOURSELF"
PD070_F = "FLAGS OF PD070"
PD080 = "INTERNET CONNECTION FOR PERSONAL USE AT HOME"
PD080_F = "FLAGS OF PD080"
PC110 = "UNMET NEEDS FOR FORMAL EDUCATION"
PC110_F = "FLAGS OF PC110"
PC120 = "MAIN REASON FOR NON-PARTICIPATION IN FORMAL EDUCATION"
PC120_F = "FLAGS OF PC120"
PC130 = "PARTICIPATION IN TRAINING RELATED TO HOBBIES"
PC130_F = "FLAGS OF PC130"
PC140 = "PARTICIPATION IN TRAINING RELATED TO PROFESSIONAL ACTIVITY"
PC140_F = "FLAGS OF PC140"
PC150 = "MAIN REASON FOR NON-PARTICIPATION IN TRAINING RELATED TO PROFESSIONAL ACTIVITY"
PC150_F = "FLAGS OF PC150"
PC260 = "CARE OR ASSISTANCE PROVIDED"
PC260_F = "FLAGS OF PC260"
PC270 = "NUMBER OF HOURS PER WEEK OF CARE OR ASSISTANCE PROVIDED"
PC270_F = "FLAGS OF PC270"
PX010 = "CHANGE RATE"
PX020 = "AGE AT THE END OF THE INCOME REFERENCE PERIOD"
PX030 = "HOUSEHOLD IDENTIFICATION NUMBER"
PX040 = "SELECTED RESPONDENT STATUS"
PX050 = "ACTIVITY STATUS"
;
RUN;
PROC FORMAT;
VALUE $PB01F /* PB020 */
"AT" = "sterreich"
"BE" = "Belgique"
"BG" = "Bulgaria"
"CH" = "Switzerland"
"CY" = "Cyprus"
"CZ" = "Czech"
"DE" = "Deutschland"
"DK" = "Danmark"
"EE" = "Estonia"
"ES" = "Espaa"
"FI" = "Suomi"
"FR" = "France"
"GR" = "Ellda"
"HU" = "Hungary"
"IE" = "Ireland"
"IS" = "Iceland"
"IT" = "Italia"
"LT" = "Lithuania"
"LU" = "Luxembourg"
"LV" = "Latvia"
"MT" = "Malta"
"NL" = "Nederland"
"NO" = "Norway"
"PL" = "Poland"
"PT" = "Portugal"
"RO" = "Romania"
"SE" = "Sverige"
"SI" = "Slovenia"
"SK" = "Slovak/republic"
"UK" = "United"
;
VALUE PB04F /* PB040_F */
1= "filled"
-7= "Not applicable: PB010 ne last year"
;
VALUE PB06F /* PB060_F */
1= "filled"
-3= "not selected respondent"
;
VALUE PB17F /* PB100 */
1= "January-March"
2= "April-June"
3= "July-September"
4= "October-December"
;
VALUE PB18F /* PB100_F */
1= "filled"
-1= "missing"
;
VALUE PB110F /* PB110_F */
1= "filled"
-1= "missing"
;
VALUE PB112F /* PB120_F */
1= "filled"
-1= "missing"
-2= "na (information only extracted from registers)"
;
VALUE PB113F /* PB130 */
1= "January-March"
2= "April-June"
3= "July-September"
4= "October-December"
;
VALUE PB114F /* PB130_F */
1= "filled"
-1= "missing"
;
VALUE PB116F /* PB140_F */
1= "filled"
-1= "missing"
;
VALUE PB117F /* PB150 */
1= "Male"
2= "Female"
;
VALUE PB118F /* PB150_F */
1= "filled"
-1= "missing"
;
VALUE PB120F /* PB160_F */
1= "filled"
-1= "missing"
-2= "na (father is not a household member)"
;
VALUE PB122F /* PB170_F */
1= "filled"
-1= "missing"
-2= "na (mother is not a household member)"
;
VALUE PB124F /* PB180_F */
1= "filled"
-1= "missing"
-2= "not applicable (person has no spouse/partner or spouse/partner is not a household member)"
;
VALUE PB125F /* PB190 */
1= "Never married"
2= "Married"
3= "Separated"
4= "Widowed"
5= "Divorced"
;
VALUE PB126F /* PB190_F */
1= "filled"
-1= "missing"
;
VALUE PB227F /* PB200 */
1= "yes on a legal basis"
2= "yes without a legal basis"
3= "no"
;
VALUE PB228F /* PB200_F */
1= "filled"
-1= "missing"
;
VALUE $PB229F /* PB210 */
"EU" = "European Countries"
"LOC" = "Italy"
"OTH" = "Other"
;
VALUE PB230F /* PB210_F */
1= "filled"
-1= "missing"
;
VALUE $PB231F /* PB220A */
"EU" = "European Countries"
"LOC" = "Italy"
"OTH" = "Other"
;
VALUE PB232F /* PB220A_F */
1= "filled"
-1= "missing"
-2= "only PB220B: na (no second citizenship)"
;
VALUE PE033F /* PE010 */
1= "in education"
2= "not in education"
;
VALUE PE034F /* PE010_F */
1= "filled"
-1= "missing"
;
VALUE PE035F /* PE020 */
0= "pre-primary education"
1= "primary education"
2= "lower secondary education"
3= "(upper) secondary education"
4= "post-secondary non tertiary education"
5= "first stage of tertiary education (not leading directly to an advanced research qualification)"
6= "second stage of tertiary education (leading to an advanced research qualification)"
10= "Primary education"
20= "Lower secondary education"
30= "Upper secondary education (not further specified)"
40= "Post-secondary non tertiary education (not further specified)"
50= "Tertiary education"
;
VALUE PE036F /* PE020_F */
1= "filled"
-1= "missing"
-2= "na (PE010 not = 1)"
;
VALUE PE038F /* PE030_F */
1= "filled"
-1= "missing"
-2= "Not applicable ((PE040=000 AND PB010 > 2013) OR (PE040_F=-2 AND PB010 < 2014))"
;
VALUE PE039F /* PE040 */
1= "primary education"
2= "lower secondary education"
3= "(upper) secondary education"
4= "post-secondary non tertiary education"
5= "first stage of tertiary education (not leading directly to an advanced research qualification)"
6= "second stage of tertiary education (leading to an advanced research qualification)"
000= "Less than primary education"
100= "Primary education"
200= "Lower secondary education"
300= "Upper secondary education (not further specified)"
400= "Post-secondary non-tertiary education (not further specified)"
500= "Tertiary education"
;
VALUE PE040F /* PE040_F */
1= "filled"
-1= "missing"
-2= "non applicable (the person has never been in education) can only be used before 2014(PB010<2014)"
;
VALUE PH041F /* PH010 */
1= "very good"
2= "good"
3= "fair"
4= "bad"
5= "very bad"
;
VALUE PH042F /* PH010_F */
1= "filled"
-1= "missing"
-3= "not selected respondent"
;
VALUE PH043F /* PH020 */
1= "yes"
2= "no"
;
VALUE PH044F /* PH020_F */
1= "filled"
-1= "missing"
-3= "not selected respondent"
;
VALUE PH045F /* PH030 */
1= "yes, strongly limited"
2= "yes, limited"
3= "no, not limited"
;
VALUE PH046F /* PH030_F */
1= "filled"
-1= "missing"
-3= "not selected respondent"
;
VALUE PH047F /* PH040 */
1= "yes, there was at least one occasion when the person really needed examination or treatment but did not"
2= "no, there was no occasion when the person really needed examination or treatment but did not"
;
VALUE PH048F /* PH040_F */
1= "filled"
-1= "missing"
-2= "not applicable: the person did not really need any medical examination or treatment"
-3= "not selected respondent"
;
VALUE PH049F /* PH050 */
1= "Could not afford to (too expensive)"
2= "Waiting list"
3= "Could not take time because of work, care for children or for others"
4= "Too far to travel/no means of transportation"
5= "Fear of doctor/hospitals/examination/ treatment"
6= "Wanted to wait and see if problem got better on its own"
7= "Didnt know any good doctor or specialist"
8= "Other reasons"
;
VALUE PH050F /* PH050_F */
1= "filled"
-1= "missing"
-2= "na (PH040 not = 1)"
-3= "not selected respondent"
;
VALUE PH051F /* PH060 */
1= "yes, there was at least one occasion when the person really needed dental examination or treatment but did not"
2= "no, there was no occasion when the person really needed dental examination or treatment but did not"
;
VALUE PH052F /* PH060_F */
1= "filled"
-1= "missing"
-2= "not applicable: the person did not really need any dental examination or treatment"
-3= "not selected respondent"
;
VALUE PH053F /* PH070 */
1= "Could not afford to (too expensive)"
2= "Waiting list"
3= "Could not take time because of work, care for children or for others"
4= "Too far to travel/no means of transportation"
5= "Fear of doctor(dentist)/hospitals/examination/ treatment"
6= "Wanted to wait and see if problem got better on its own"
7= "Didnt know any good dentist"
8= "Other reasons"
;
VALUE PH054F /* PH070_F */
1= "filled"
-1= "missing"
-2= "na (PH060 not = 1)"
-3= "not selected respondent"
;
VALUE PL055F /* PL015 */
1= "yes"
2= "no"
;
VALUE PL056F /* PL015_F */
1= "filled"
-1= "missing"
-2= "not applicable  (PL031 = 1, 2, 3 or 4)"
;
VALUE PL057F /* PL020 */
1= "yes"
2= "no"
;
VALUE PL058F /* PL020_F */
1= "filled"
-1= "missing"
-2= "not applicable  (PL031 = 1, 2, 3 or 4)"
;
VALUE PL059F /* PL025 */
1= "yes"
2= "no"
;
VALUE PL060F /* PL025_F */
1= "filled"
-1= "missing"
-2= "not applicable  (PL031 = 1, 2, 3 or 4)"
;
VALUE PL061F /* PL031 */
1= "Employee working full-time"
2= "Employee working part-time"
3= "Self-employed working full-time (including family worker)"
4= "Self-employed working part-time (including family worker)"
5= "Unemployed"
6= "Pupil, student, further training, unpaid work experience"
7= "In retirement or in early retirement or has given up business"
8= "Permanently disabled or/and unfit to work"
9= "In compulsory military community or service"
10= "Fulfilling domestic tasks and care responsibilities"
11= "Other inactive person"
;
VALUE PL062F /* PL031_F */
1= "filled"
-1= "missing"
-5= "missing value of PL031 because PL030 is still used"
;
VALUE PL063F /* PL035 */
1= "yes"
2= "no"
;
VALUE PL064F /* PL035_F */
1= "filled"
-1= "missing"
-2= "not applicable (person is not employee or MS has other source to calculate the gender pay gap)"
-3= "not selected respondent"
;
VALUE PL065F /* PL040 */
1= "self-employed with employees"
2= "self-employed without employees"
3= "employee"
4= "family worker"
;
VALUE PL066F /* PL040_F */
1= "filled"
-1= "missing"
-2= "not applicable ( PL031 not = 1, 2, 3 or 4 and PL015 not = 1)"
;
VALUE PL067F /* PL051 */
1= "Commissioned armed forces officers"
2= "Non-commissioned armed forces officers"
3= "Armed forces occupations, other ranks"
11= "Chief executives, senior officials and legislators"
12= "Administrative and commercial managers"
13= "Production and specialised services managers"
14= "Hospitality, retail and other services managers"
21= "Science and engineering professionals"
22= "Health professionals"
23= "Teaching professionals"
24= "Business and administration professionals"
25= "Information and communications technology professionals"
26= "Legal, social and cultural professionals"
31= "Science and engineering associate professionals"
32= "Health associate professionals"
33= "Business and administration associate professionals"
34= "Legal, social, cultural and related associate professionals"
35= "Information and communications technicians"
41= "General and keyboard clerks"
42= "Customer services clerks"
43= "Numerical and material recording clerks"
44= "Other clerical support workers"
51= "Personal service workers"
52= "Sales workers"
53= "Personal care workers"
54= "Protective services workers"
61= "Market-oriented skilled agricultural workers"
62= "Market-oriented skilled forestry, fishery and hunting workers"
63= "Subsistence farmers, fishers, hunters and gatherers"
71= "Building and related trades workers, excluding electricians"
72= "Metal, machinery and related trades workers"
73= "Handicraft and printing workers"
74= "Electrical and electronic trades workers"
75= "Food processing, wood working, garment and other craft and related trades workers"
81= "Stationary plant and machine operators"
82= "Assemblers"
83= "Drivers and mobile plant operators"
91= "Cleaners and helpers"
92= "Agricultural, forestry and fishery labourers"
93= "Labourers in mining, construction, manufacturing and transport"
94= "Food preparation assistants"
95= "Street and related sales and service workers"
96= "Refuse workers and other elementary workers"
;
VALUE PL068F /* PL051_F */
1= "filled"
-1= "missing"
-2= "not applicable (PL031 not = 1, 2, 3 or 4 and PL015 not = 1)"
-5= "missing value of PL051 because PL050 is still used"
;
VALUE PL070F /* PL060_F */
1= "filled"
-1= "missing"
-2= "not applicable (PL031 not = 1, 2, 3 or 4 and PL035 not = 1)"
-6= "hours varying (even an average over 4 weeks is not possible"
;
VALUE PL072F /* PL073_F */
1= "filled"
-1= "missing"
-5= "missing value because the definition of this variable is not used (PL088 and PL089 only)"
;
VALUE PL074F /* PL074_F */
1= "filled"
-1= "missing"
-5= "missing value because the definition of this variable is not used (PL088 and PL089 only)"
;
VALUE PL076F /* PL075_F */
1= "filled"
-1= "missing"
-5= "missing value because the definition of this variable is not used (PL088 and PL089 only)"
;
VALUE PL078F /* PL076_F */
1= "filled"
-1= "missing"
-5= "missing value because the definition of this variable is not used (PL088 and PL089 only)"
;
VALUE PL080F /* PL080_F */
1= "filled"
-1= "missing"
-5= "missing value because the definition of this variable is not used (PL088 and PL089 only)"
;
VALUE PL082F /* PL085_F */
1= "filled"
-1= "missing"
-5= "missing value because the definition of this variable is not used (PL088 and PL089 only)"
;
VALUE PL084F /* PL086_F */
1= "filled"
-1= "missing"
-5= "missing value because the definition of this variable is not used (PL088 and PL089 only)"
;
VALUE PL086F /* PL087_F */
1= "filled"
-1= "missing"
-5= "missing value because the definition of this variable is not used (PL088 and PL089 only)"
;
VALUE PL088F /* PL088_F */
1= "filled"
-1= "missing"
-5= "missing value because the definition of this variable is not used (PL088 and PL089 only)"
;
VALUE PL090F /* PL089_F */
1= "filled"
-1= "missing"
-5= "missing value because the definition of this variable is not used (PL088 and PL089 only)"
;
VALUE PL092F /* PL090_F */
1= "filled"
-1= "missing"
-5= "missing value because the definition of this variable is not used (PL088 and PL089 only)"
;
VALUE PL194F /* PL100_F */
1= "filled"
-1= "missing"
-2= "na (person does not have a second job or PL030 not = 1 or 2)"
;
VALUE $PL195F /* PL111 */
"a" = "Agriculture ,forestry and fishing"
"f" = "Construction"
"g" = "Wholesale retail"
"h" = "Transportation and storage"
"i" = "Accommodation and food service activities"
"j" = "Information and communication"
"k" = "Financial and insurance activities"
"o" = "Public administration and defence, compulsory social security"
"p" = "Education"
"q" = "Human health and social work activities"
"b - e" = "Mining and quarrying, Manufacturing, Electricity, gas, steam and air conditioning supply, Water supply"
"l - n" = "Real estate activities, Professional, scientific and technical activities, Administrative and support service activities"
"r - u" = "Arts, entertainment and recreation, Other service activities, Activities as household as employer..., Activities of extraterritorial organisations and bodies"
;
VALUE PL196F /* PL111_F */
1= "filled"
-1= "missing"
-2= "na (PL031 not = 1, 2,3 or 4)"
-3= "not selected respondent"
;
VALUE PL197F /* PL120 */
1= "Undergoing education or training"
2= "Personal illness or disability"
3= "Want to work more hours but cannot find a job(s) or work(s) of more hours"
4= "Do not want to work more hours"
5= "Number of hours in all job(s) are considered as a full-time job"
6= "Housework, looking after children or other persons"
7= "Other reasons"
;
VALUE PL198F /* PL120_F */
1= "filled"
-1= "missing"
-2= "not applicable (Not (PL031 = 1, 2 , 3 or 4, and PL060 + PL100 < 30))"
-3= "not selected respondent"
;
VALUE PL199F /* PL130 */
1= "between 1 and 10"
2= "between 1 and 10"
3= "between 1 and 10"
4= "between 1 and 10"
5= "between 1 and 10"
6= "between 1 and 10"
7= "between 1 and 10"
8= "between 1 and 10"
9= "between 1 and 10"
10= "between 1 and 10"
11= "between 11 and 19 persons"
12= "between 20 and 49 persons"
13= "50 persons and more"
14= "do not know but less than 11 persons"
15= "do not know but more than 10 persons"
;
VALUE PL1100F /* PL130_F */
1= "filled"
-1= "missing"
-2= "not applicable ( PL031 not = 1, 2, 3 or 4 and PL035 not = 1)"
-3= "not selected respondent"
;
VALUE PL1101F /* PL140 */
1= "permanent job/work contract of unlimited duration"
2= "temporary job/work contract of limited duration"
;
VALUE PL1102F /* PL140_F */
1= "filled"
-1= "missing"
-2= "not applicable (PL040 not = 3)"
-3= "not selected respondent"
-4= "not applicable because the person is employee (PL040=3) but has not any contract"
;
VALUE PL1103F /* PL150 */
1= "supervisory"
2= "non-supervisory"
;
VALUE PL1104F /* PL150_F */
1= "filled"
-1= "missing"
-2= "not applicable (PL040 not = 3)"
-3= "not selected respondent"
;
VALUE PL1105F /* PL160 */
1= "yes"
2= "no"
;
VALUE PL1106F /* PL160_F */
1= "filled"
-1= "missing"
-2= "not applicable (PL031 not = 1, 2, 3 or 4)"
-3= "not selected respondent"
;
VALUE PL1107F /* PL170 */
1= "To take up or seek better job"
2= "End of temporary contract"
3= "Obliged to stop by employer (business closure, redundancy, early retirement, dismissal etc.)"
4= "Sale or closure of own/family business"
5= "Child care and care for other dependent"
6= "Partners job required us to move to another area or marriage"
7= "Other reasons"
;
VALUE PL1108F /* PL170_F */
1= "filled"
-1= "missing"
-2= "na (PL160 not = 1)"
-3= "not selected respondent"
;
VALUE PL1109F /* PL180 */
1= "employed - unemployed"
2= "employed - retired"
3= "employed - other inactive"
4= "unemployed - employed"
5= "unemployed - retired"
6= "unemployed - other inactive"
7= "retired - employed"
8= "retired - unemployed"
9= "retired - other inactive"
10= "other inactive - employed"
11= "other inactive - unemployed"
12= "other inactive - retired"
;
VALUE PL1110F /* PL180_F */
1= "filled"
-1= "missing"
-2= "not applicable (no change since last year)"
-3= "not selected respondent"
;
VALUE PL1112F /* PL190_F */
1= "filled"
-1= "missing"
-2= "not applicable (person never worked i.e. (PL031 not = 1, 2, 3 or 4 AND PL015 not= 1))"
-3= "not selected respondent"
;
VALUE PL2114F /* PL200_F */
1= "filled"
-1= "missing"
-2= "na (person never worked)"
-3= "not selected respondent"
;
VALUE PL2115F /* PL211A */
1= "Employee working full-time"
2= "Employee working part-time"
3= "Self-employed working full-time (including family worker)"
4= "Self-employed working part-time (including family worker)"
5= "Unemployed"
6= "Pupil, student, further training, unpaid work experience"
7= "In retirement or in early retirement or has given up business"
8= "Permanently disabled or/and unfit to work"
9= "In compulsory military community or service"
10= "Fulfilling domestic tasks and care responsibilities"
11= "Other inactive person"
;
VALUE PL2116F /* PL211A_F */
1= "filled"
-1= "missing"
-3= "not selected respondent"
;
VALUE PL2117F /* PL211B */
1= "Employee working full-time"
2= "Employee working part-time"
3= "Self-employed working full-time (including family worker)"
4= "Self-employed working part-time (including family worker)"
5= "Unemployed"
6= "Pupil, student, further training, unpaid work experience"
7= "In retirement or in early retirement or has given up business"
8= "Permanently disabled or/and unfit to work"
9= "In compulsory military community or service"
10= "Fulfilling domestic tasks and care responsibilities"
11= "Other inactive person"
;
VALUE PL2118F /* PL211B_F */
1= "filled"
-1= "missing"
-3= "not selected respondent"
;
VALUE PL2119F /* PL211C */
1= "Employee working full-time"
2= "Employee working part-time"
3= "Self-employed working full-time (including family worker)"
4= "Self-employed working part-time (including family worker)"
5= "Unemployed"
6= "Pupil, student, further training, unpaid work experience"
7= "In retirement or in early retirement or has given up business"
8= "Permanently disabled or/and unfit to work"
9= "In compulsory military community or service"
10= "Fulfilling domestic tasks and care responsibilities"
11= "Other inactive person"
;
VALUE PL2120F /* PL211C_F */
1= "filled"
-1= "missing"
-3= "not selected respondent"
;
VALUE PL2121F /* PL211D */
1= "Employee working full-time"
2= "Employee working part-time"
3= "Self-employed working full-time (including family worker)"
4= "Self-employed working part-time (including family worker)"
5= "Unemployed"
6= "Pupil, student, further training, unpaid work experience"
7= "In retirement or in early retirement or has given up business"
8= "Permanently disabled or/and unfit to work"
9= "In compulsory military community or service"
10= "Fulfilling domestic tasks and care responsibilities"
11= "Other inactive person"
;
VALUE PL2122F /* PL211D_F */
1= "filled"
-1= "missing"
-3= "not selected respondent"
;
VALUE PL2123F /* PL211E */
1= "Employee working full-time"
2= "Employee working part-time"
3= "Self-employed working full-time (including family worker)"
4= "Self-employed working part-time (including family worker)"
5= "Unemployed"
6= "Pupil, student, further training, unpaid work experience"
7= "In retirement or in early retirement or has given up business"
8= "Permanently disabled or/and unfit to work"
9= "In compulsory military community or service"
10= "Fulfilling domestic tasks and care responsibilities"
11= "Other inactive person"
;
VALUE PL2124F /* PL211E_F */
1= "filled"
-1= "missing"
-3= "not selected respondent"
;
VALUE PL2125F /* PL211F */
1= "Employee working full-time"
2= "Employee working part-time"
3= "Self-employed working full-time (including family worker)"
4= "Self-employed working part-time (including family worker)"
5= "Unemployed"
6= "Pupil, student, further training, unpaid work experience"
7= "In retirement or in early retirement or has given up business"
8= "Permanently disabled or/and unfit to work"
9= "In compulsory military community or service"
10= "Fulfilling domestic tasks and care responsibilities"
11= "Other inactive person"
;
VALUE PL2126F /* PL211F_F */
1= "filled"
-1= "missing"
-3= "not selected respondent"
;
VALUE PL2127F /* PL211G */
1= "Employee working full-time"
2= "Employee working part-time"
3= "Self-employed working full-time (including family worker)"
4= "Self-employed working part-time (including family worker)"
5= "Unemployed"
6= "Pupil, student, further training, unpaid work experience"
7= "In retirement or in early retirement or has given up business"
8= "Permanently disabled or/and unfit to work"
9= "In compulsory military community or service"
10= "Fulfilling domestic tasks and care responsibilities"
11= "Other inactive person"
;
VALUE PL2128F /* PL211G_F */
1= "filled"
-1= "missing"
-3= "not selected respondent"
;
VALUE PL2129F /* PL211H */
1= "Employee working full-time"
2= "Employee working part-time"
3= "Self-employed working full-time (including family worker)"
4= "Self-employed working part-time (including family worker)"
5= "Unemployed"
6= "Pupil, student, further training, unpaid work experience"
7= "In retirement or in early retirement or has given up business"
8= "Permanently disabled or/and unfit to work"
9= "In compulsory military community or service"
10= "Fulfilling domestic tasks and care responsibilities"
11= "Other inactive person"
;
VALUE PL2130F /* PL211H_F */
1= "filled"
-1= "missing"
-3= "not selected respondent"
;
VALUE PL2131F /* PL211I */
1= "Employee working full-time"
2= "Employee working part-time"
3= "Self-employed working full-time (including family worker)"
4= "Self-employed working part-time (including family worker)"
5= "Unemployed"
6= "Pupil, student, further training, unpaid work experience"
7= "In retirement or in early retirement or has given up business"
8= "Permanently disabled or/and unfit to work"
9= "In compulsory military community or service"
10= "Fulfilling domestic tasks and care responsibilities"
11= "Other inactive person"
;
VALUE PL2132F /* PL211I_F */
1= "filled"
-1= "missing"
-3= "not selected respondent"
;
VALUE PL2133F /* PL211J */
1= "Employee working full-time"
2= "Employee working part-time"
3= "Self-employed working full-time (including family worker)"
4= "Self-employed working part-time (including family worker)"
5= "Unemployed"
6= "Pupil, student, further training, unpaid work experience"
7= "In retirement or in early retirement or has given up business"
8= "Permanently disabled or/and unfit to work"
9= "In compulsory military community or service"
10= "Fulfilling domestic tasks and care responsibilities"
11= "Other inactive person"
;
VALUE PL2134F /* PL211J_F */
1= "filled"
-1= "missing"
-3= "not selected respondent"
;
VALUE PL2135F /* PL211K */
1= "Employee working full-time"
2= "Employee working part-time"
3= "Self-employed working full-time (including family worker)"
4= "Self-employed working part-time (including family worker)"
5= "Unemployed"
6= "Pupil, student, further training, unpaid work experience"
7= "In retirement or in early retirement or has given up business"
8= "Permanently disabled or/and unfit to work"
9= "In compulsory military community or service"
10= "Fulfilling domestic tasks and care responsibilities"
11= "Other inactive person"
;
VALUE PL2136F /* PL211K_F */
1= "filled"
-1= "missing"
-3= "not selected respondent"
;
VALUE PL2137F /* PL211L */
1= "Employee working full-time"
2= "Employee working part-time"
3= "Self-employed working full-time (including family worker)"
4= "Self-employed working part-time (including family worker)"
5= "Unemployed"
6= "Pupil, student, further training, unpaid work experience"
7= "In retirement or in early retirement or has given up business"
8= "Permanently disabled or/and unfit to work"
9= "In compulsory military community or service"
10= "Fulfilling domestic tasks and care responsibilities"
11= "Other inactive person"
;
VALUE PL2138F /* PL211L_F */
1= "filled"
-1= "missing"
-3= "not selected respondent"
;
VALUE PD0268F /* PD020 */
1= "Yes"
2= "No, because cannot afford it"
3= "No, for some other reason"
;
VALUE PD0269F /* PD020_F */
1= "filled"
-1= "missing"
-3= "not selected respondent"
;
VALUE PD0270F /* PD030 */
1= "Yes"
2= "No, because cannot afford it"
3= "No, for some other reason"
;
VALUE PD0271F /* PD030_F */
1= "filled"
-1= "missing"
-3= "not selected respondent"
;
VALUE PD0272F /* PD050 */
1= "Yes"
2= "No, because cannot afford it"
3= "No, for some other reason"
;
VALUE PD0273F /* PD050_F */
1= "filled"
-1= "missing"
-3= "not selected respondent"
;
VALUE PD0274F /* PD060 */
1= "Yes"
2= "No, because cannot afford it"
3= "No, for some other reason"
;
VALUE PD0275F /* PD060_F */
1= "filled"
-1= "missing"
-3= "not selected respondent"
;
VALUE PD0276F /* PD070 */
1= "Yes"
2= "No, because cannot afford it"
3= "No, for some other reason"
;
VALUE PD0277F /* PD070_F */
1= "filled"
-1= "missing"
-3= "not selected respondent"
;
VALUE PD0278F /* PD080 */
1= "Yes"
2= "No, because cannot afford it"
3= "No, for some other reason"
;
VALUE PD0279F /* PD080_F */
1= "filled"
-1= "missing"
-3= "not selected respondent"
;
VALUE PC1280F /* PC110 */
1= "yes"
2= "no"
;
VALUE PC1281F /* PC110_F */
1= "filled"
-1= "missing"
-3= "not selected respondent"
-4= "person currently in formal education"
-7= "not applicable PB010 not = 2016"
;
VALUE PC1282F /* PC120 */
1= "cannot afford it"
2= "not admitted to the course programme"
3= "time constraints (schedule, family responsibilities, etc.)"
4= "no suitable course or programmes available"
5= "other reasons"
;
VALUE PC1283F /* PC120_F */
1= "filled"
-1= "missing"
-2= "not applicable (PC110=2)"
-3= "not selected respondent"
-4= "person currently in formal education"
-7= "not applicable PB010 not = 2016"
;
VALUE PC1284F /* PC130 */
1= "yes"
2= "no"
;
VALUE PC1285F /* PC130_F */
1= "filled"
-1= "missing"
-3= "not selected respondent"
-7= "not applicable PB010 not = 2016"
;
VALUE PC1286F /* PC140 */
1= "yes"
2= "no"
;
VALUE PC1287F /* PC140_F */
1= "filled"
-1= "missing"
-3= "not selected respondent"
-7= "not applicable PB010 not = 2016"
;
VALUE PC1288F /* PC150 */
1= "cannot afford it"
2= "not interested"
3= "time constraints (schedule, family responsibilities, etc.)"
4= "no suitable course or programmes available"
5= "not provided by employer"
6= "other reasons"
;
VALUE PC1289F /* PC150_F */
1= "filled"
-1= "missing"
-2= "not applicable (PC140=1)"
-3= "not selected respondent"
-7= "not applicable PB010 not = 2016"
;
VALUE PC2290F /* PC260 */
1= "yes  only to household members"
2= "yes  only to persons who are not the household members"
3= "yes- to household members and to persons who are not the household members"
4= "no"
;
VALUE PC2291F /* PC260_F */
1= "filled"
-1= "missing"
-3= "not selected respondent"
-7= "not applicable PB010 not = 2016"
;
VALUE PC2292F /* PC270 */
1= "less than 10 hours per week"
2= "at least 10 but less than 20 hours per week"
3= "20 hours per week or more"
;
VALUE PC2293F /* PC270_F */
1= "filled"
-1= "missing"
-2= "not applicable (PC260=4)"
-3= "not selected respondent"
-7= "not applicable PB010 not = 2016"
;
VALUE PX0297F /* PX040 */
1= "current household member aged 16 and over Only selected household member aged 16 and over is interviewed"
2= "selected respondent"
3= "not selected respondent Households members aged less than 16 at the time of interview"
4= "not eligible person"
;
VALUE PX0298F /* PX050 */
2= "employees (SAL)"
3= "employed persons except employees (NSAL)"
4= "other employed (when time of SAL and NSAL is >  of total time calendar)"
5= "unemployed"
6= "retired"
7= "inactive"
8= "other inactive (when time of unemployed, retirement and inactivity is >  of total time calendar)"
;
format PB020 $PB01F.;
format PB040_F PB04F.;
format PB060_F PB06F.;
format PB100 PB17F.;
format PB100_F PB18F.;
format PB110_F PB110F.;
format PB120_F PB112F.;
format PB130 PB113F.;
format PB130_F PB114F.;
format PB140_F PB116F.;
format PB150 PB117F.;
format PB150_F PB118F.;
format PB160_F PB120F.;
format PB170_F PB122F.;
format PB180_F PB124F.;
format PB190 PB125F.;
format PB190_F PB126F.;
format PB200 PB227F.;
format PB200_F PB228F.;
format PB210 $PB229F.;
format PB210_F PB230F.;
format PB220A $PB231F.;
format PB220A_F PB232F.;
format PE010 PE033F.;
format PE010_F PE034F.;
format PE020 PE035F.;
format PE020_F PE036F.;
format PE030_F PE038F.;
format PE040 PE039F.;
format PE040_F PE040F.;
format PH010 PH041F.;
format PH010_F PH042F.;
format PH020 PH043F.;
format PH020_F PH044F.;
format PH030 PH045F.;
format PH030_F PH046F.;
format PH040 PH047F.;
format PH040_F PH048F.;
format PH050 PH049F.;
format PH050_F PH050F.;
format PH060 PH051F.;
format PH060_F PH052F.;
format PH070 PH053F.;
format PH070_F PH054F.;
format PL015 PL055F.;
format PL015_F PL056F.;
format PL020 PL057F.;
format PL020_F PL058F.;
format PL025 PL059F.;
format PL025_F PL060F.;
format PL031 PL061F.;
format PL031_F PL062F.;
format PL035 PL063F.;
format PL035_F PL064F.;
format PL040 PL065F.;
format PL040_F PL066F.;
format PL051 PL067F.;
format PL051_F PL068F.;
format PL060_F PL070F.;
format PL073_F PL072F.;
format PL074_F PL074F.;
format PL075_F PL076F.;
format PL076_F PL078F.;
format PL080_F PL080F.;
format PL085_F PL082F.;
format PL086_F PL084F.;
format PL087_F PL086F.;
format PL088_F PL088F.;
format PL089_F PL090F.;
format PL090_F PL092F.;
format PL100_F PL194F.;
format PL111 $PL195F.;
format PL111_F PL196F.;
format PL120 PL197F.;
format PL120_F PL198F.;
format PL130 PL199F.;
format PL130_F PL1100F.;
format PL140 PL1101F.;
format PL140_F PL1102F.;
format PL150 PL1103F.;
format PL150_F PL1104F.;
format PL160 PL1105F.;
format PL160_F PL1106F.;
format PL170 PL1107F.;
format PL170_F PL1108F.;
format PL180 PL1109F.;
format PL180_F PL1110F.;
format PL190_F PL1112F.;
format PL200_F PL2114F.;
format PL211A PL2115F.;
format PL211A_F PL2116F.;
format PL211B PL2117F.;
format PL211B_F PL2118F.;
format PL211C PL2119F.;
format PL211C_F PL2120F.;
format PL211D PL2121F.;
format PL211D_F PL2122F.;
format PL211E PL2123F.;
format PL211E_F PL2124F.;
format PL211F PL2125F.;
format PL211F_F PL2126F.;
format PL211G PL2127F.;
format PL211G_F PL2128F.;
format PL211H PL2129F.;
format PL211H_F PL2130F.;
format PL211I PL2131F.;
format PL211I_F PL2132F.;
format PL211J PL2133F.;
format PL211J_F PL2134F.;
format PL211K PL2135F.;
format PL211K_F PL2136F.;
format PL211L PL2137F.;
format PL211L_F PL2138F.;
format PD020 PD0268F.;
format PD020_F PD0269F.;
format PD030 PD0270F.;
format PD030_F PD0271F.;
format PD050 PD0272F.;
format PD050_F PD0273F.;
format PD060 PD0274F.;
format PD060_F PD0275F.;
format PD070 PD0276F.;
format PD070_F PD0277F.;
format PD080 PD0278F.;
format PD080_F PD0279F.;
format PC110 PC1280F.;
format PC110_F PC1281F.;
format PC120 PC1282F.;
format PC120_F PC1283F.;
format PC130 PC1284F.;
format PC130_F PC1285F.;
format PC140 PC1286F.;
format PC140_F PC1287F.;
format PC150 PC1288F.;
format PC150_F PC1289F.;
format PC260 PC2290F.;
format PC260_F PC2291F.;
format PC270 PC2292F.;
format PC270_F PC2293F.;
format PX040 PX0297F.;
format PX050 PX0298F.;
RUN;
