#LIMITAZIONE DELLA RESPONSABILITA'. 
#Il software  fornito "cos com'", senza garanzie di  sorta.
setwd(choose.dir(default = "", caption = "WHERE ARE MICRODATA?"))
direttorio = getwd()
fileInput = paste (direttorio, "/ISTAT_MFR_EU-SILC_Microdati_2016_PERSONAL_DATA_(P-FILE)_Cross-Sectional_ESEMPIO_STRUTTURA_FILE.txt", sep="")
DF_EU-SILC_A2016_PERSONAL_DATA_<- read.delim2 (fileInput,  header=T, sep="^",  quote="",  na.strings = ".")
attr(DF_EU-SILC_A2016_PERSONAL_DATA_, "label") <- c(
"YEAR OF THE SURVEY",
"COUNTRY",
"PERSONAL ID",
"PERSONAL CROSS-SECTIONAL WEIGHT",
"FLAGS OF PB040",
"PERSONAL CROSS-SECTIONAL WEIGHT FOR SELECTED RESPONDENT",
"FLAGS OF PB060",
"MONTH OF THE PERSONAL INTERVIEW",
"FLAGS OF PB100",
"YEAR OF THE PERSONAL INTERVIEW",
"FLAGS OF PB110",
"MINUTES TO COMPLETE THE PERSONAL QUESTIONNAIRE",
"FLAGS OF PB120",
"MONTH OF BIRTH",
"FLAGS OF PB130",
"YEAR OF BIRTH",
"FLAGS OF PB140",
"SEX",
"FLAGS OF PB150",
"FATHER ID",
"FLAGS OF PB160",
"FATHER ID",
"FLAGS OF PB170",
"SPOUSE/PARTNER ID",
"FLAGS OF PB180",
"MARITAL STATUS",
"FLAGS OF PB190",
"CONSENSUAL UNION",
"FLAGS OF PB200",
"COUNTRY OF BIRTH",
"FLAGS OF PB210",
"CITIZENSHIP 1",
"FLAGS OF PB220A",
"CURRENT EDUCATION ACTIVITY",
"FLAGS OF PE010",
"ISCED LEVEL CURRENTLY ATTENDED",
"FLAGS OF PE020",
"YEAR WHEN HIGHEST LEVEL OF EDUCATION WAS ATTAINED",
"FLAGS OF PE030",
"HIGHEST ISCED LEVEL ATTAINED",
"FLAGS OF PE040",
"GENERAL HEALTH",
"FLAGS OF PH010",
"SUFFER FROM ANY A CHRONIC (LONG-STANDING) ILLNESS OR CONDITION",
"FLAGS OF PH020",
"LIMITATION IN ACTIVITIES BECAUSE OF HEALTH PROBLEMS",
"FLAGS OF PH030",
"UNMET NEED FOR MEDICAL EXAMINATION OR TREATMENT",
"FLAGS OF PH040",
"MAIN REASON FOR UNMET NEED FOR MEDICAL EXAMINATION OR TREATMENT",
"FLAGS OF PH050",
"UNMET NEED FOR DENTAL EXAMINATION OR TREATMENT",
"FLAGS OF PH060",
"MAIN REASON FOR UNMET NEED FOR DENTAL EXAMINATION OR TREATMENT",
"FLAGS OF PH070",
"PERSON HAS EVER WORKED",
"FLAGS OF PL015",
"ACTIVELY LOOKING FOR A JOB",
"FLAGS OF PL020",
"AVAILABLE FOR WORK",
"FLAGS OF PL025",
"SELF-DEFINED CURRENT ECONOMIC STATUS",
"FLAGS OF PL031",
"WORKED AT LEAST 1 HOUR DURING THE PREVIOUS WEEK",
"FLAGS OF PL035",
"STATUS IN EMPLOYMENT",
"FLAGS OF PL040",
"OCCUPATION (ISCO-8 (COM))",
"FLAGS OF PL051",
"NUMBER OF HOURS USUALLY WORKED PER WEEK IN MAIN JOB",
"FLAGS OF PL060",
"NUMBER OF MONTHS SPENT AT FULL-TIME WORK AS UNEMPLOYMENT",
"FLAGS OF PL073",
"NUMBER OF MONTHS SPENT AT PART-TIME WORK AS UNEMPLOYMENT",
"FLAGS OF PL074",
"NUMBER OF MONTHS SPENT AT FULL-TIME WORK AS SELF- UNEMPLOYMENT (INCLUDING FAMILY WORKER",
"FLAGS OF PL075",
"NUMBER OF MONTHS SPENT AT PART-TIME WORK AS SELF- UNEMPLOYMENT (INCLUDING FAMILY WORKER",
"FLAGS OF PL076",
"NUMBER OF MONTHS SPENT IN UNEMPLOYMENT",
"FLAGS OF PL080",
"NUMBER OF MONTHS SPENT IN RETIREMENT OR EARLY RETIREMENT",
"FLAGS OF PL085",
"NUMBER OF MONTHS SPENT AS DISABLED OR/AND UNFIT TO WORK",
"FLAGS OF PL086",
"NUMBER OF MONTHS SPENT STUDYING",
"FLAGS OF PL087",
"NUMBER OF MONTHS SPENT IN COMPULSORY MILITARY SERVICE",
"FLAGS OF PL088",
"NUMBER OF MONTHS SPENT FULFILLING DOMESTIC TASKS AND CARE RESPONSIBILITIES",
"FLAGS OF PL089",
"NUMBER OF MONTHS SPENT IN OTHER INACTIVITY",
"FLAGS OF PL090",
"TOTAL NUMBER OF HOURS USUALLY WORKED IN SECOND THIRD JOBS",
"FLAGS OF PL100",
"NACE REV.2",
"FLAGS OF PL111",
"REASON FOR WORKING LESS THAN 30 HOURS",
"FLAGS OF PL120",
"NUMBER OF PERSONS WORKING AT THE LOCAL UNIT",
"FLAGS OF PL130",
"TYPE OF CONTRACT",
"FLAGS OF PL140",
"MANAGERIAL POSITION",
"FLAGS OF PL150",
"CHANGE OF JOB SINCE LAST YEAR",
"FLAGS OF PL160",
"REASON FOR CHANGE",
"FLAGS OF PL170",
"MOST RECENT CHANGE IN THE INDIVIDUALS ACTIVITY STATUS",
"FLAGS OF PL180",
"WHEN BEGAN FIRST REGULAR JOB",
"FLAGS OF PL190",
"NUMBER OF YEARS SPENT IN PAID WORK",
"FLAGS OF PL200",
"MAIN ACTIVITY ON JANUARY",
"FLAGS OF PL211A",
"MAIN ACTIVITY ON FEBRUARY",
"FLAGS OF PL211B",
"MAIN ACTIVITY ON MARCH",
"FLAGS OF PL211C",
"MAIN ACTIVITY ON APRIL",
"FLAGS OF PL211D",
"MAIN ACTIVITY ON MAY",
"FLAGS OF PL211E",
"MAIN ACTIVITY ON JUNE",
"FLAGS OF PL211F",
"MAIN ACTIVITY ON JULY",
"FLAGS OF PL211G",
"MAIN ACTIVITY ON AUGUST",
"FLAGS OF PL211H",
"MAIN ACTIVITY ON SEPTEMBER",
"FLAGS OF PL211I",
"MAIN ACTIVITY ON OCTOBER",
"FLAGS OF PL211J",
"MAIN ACTIVITY ON NOVEMBER",
"FLAGS OF PL211K",
"MAIN ACTIVITY ON DECEMBER",
"FLAGS OF PL211L",
"EMPLOYEE CASH OR NEAR CASH INCOME",
"FLAGS OF PY010N",
"FLAGS OF PY010N",
"NON-CASH EMPLOYEE INCOME",
"FLAGS OF PY020N",
"FLAGS OF PY020N",
"COMPANY CAR",
"FLAGS OF PY021N",
"FLAGS OF PY021N",
"CONTRIBUTIONS TO INDIVIDUAL PRIVATE PENSION PLANS",
"FLAGS OF PY035N",
"FLAGS OF PY035N",
"CASH BENEFITS OR LOSSES FROM SELF-EMPLOYMENT",
"FLAGS OF PY050N",
"FLAGS OF PY050N",
"PENSION FROM INDIVIDUAL PRIVATE PLANS",
"FLAGS OF PY080N",
"FLAGS OF PY080N",
"UNEMPLOYMENT BENEFITS",
"FLAGS OF PY090N",
"FLAGS OF PY090N",
"OLD-AGE BENEFITS",
"FLAGS OF PY100N",
"FLAGS OF PY100N",
"SURVIVOR BENEFITS",
"FLAGS OF PY110N",
"FLAGS OF PY110N",
"SICKNESS BENEFITS",
"FLAGS OF PY120N",
"FLAGS OF PY120N",
"DISABILITY BENEFITS",
"FLAGS OF PY130N",
"FLAGS OF PY130N",
"EDUCATION-RELATED ALLOWANCES",
"FLAGS OF PY140N",
"FLAGS OF PY140N",
"EMPLOYEE CASH OR NEAR CASH INCOME",
"FLAGS OF PY010G",
"FLAGS OF PY010G",
"NON-CASH EMPLOYEE INCOME",
"FLAGS OF PY020G",
"FLAGS OF PY020G",
"COMPANY CAR",
"FLAGS OF PY021G",
"FLAGS OF PY021G",
"EMPLOYER'S SOCIAL INSURANCE CONTRIBUTION",
"FLAGS OF PY030G",
"FLAGS OF PY030G",
"OPTIONAL EMPLOYER'S SOCIAL INSURANCE CONTRIBUTIONS",
"FLAGS OF PY031G",
"FLAGS OF PY031G",
"CONTRIBUTIONS TO INDIVIDUAL PRIVATE PENSION PLANS",
"FLAGS OF PY035G",
"FLAGS OF PY035G",
"CASH BENEFITS OR LOSSES FROM SELF-EMPLOYMENT",
"FLAGS OF PY050G",
"FLAGS OF PY050G",
"PENSION FROM INDIVIDUAL PRIVATE PLANS",
"FLAGS OF PY080G",
"FLAGS OF PY080G",
"UNEMPLOYMENT BENEFITS",
"FLAGS OF PY090G",
"FLAGS OF PY090G",
"UNEMPLOYMENT BENEFITS (CONTRIBUTORY AND MEANS-TESTED)",
"FLAGS OF PY091G",
"UNEMPLOYMENT BENEFITS (CONTRIBUTORY AND NON MEANS-TESTED)",
"FLAGS OF PY092G",
"UNEMPLOYMENT BENEFITS (NON-CONTRIBUTORY AND MEANS-TESTED)",
"FLAGS OF PY093G",
"UNEMPLOYMENT BENEFITS (NON-CONTRIBUTORY AND NON MEANS-TESTED)",
"FLAGS OF PY094G",
"OLD-AGE BENEFITS",
"FLAGS OF PY100G",
"FLAGS OF PY100G",
"OLD-AGE BENEFITS (CONTRIBUTORY AND MEANS-TESTED)",
"FLAGS OF PY101G",
"OLD-AGE BENEFITS (CONTRIBUTORY AND NON MEANS-TESTED)",
"FLAGS OF PY102G",
"OLD-AGE BENEFITS (NON-CONTRIBUTORY AND MEANS-TESTED)",
"FLAGS OF PY103G",
"OLD-AGE BENEFITS (NON-CONTRIBUTORY AND NON MEANS-TESTED)",
"FLAGS OF PY104G",
"SURVIVOR BENEFITS",
"FLAGS OF PY110G",
"FLAGS OF PY110G",
"SURVIVOR BENEFITS (CONTRIBUTORY AND MEANS-TESTED)",
"FLAGS OF PY111G",
"SURVIVOR BENEFITS (CONTRIBUTORY AND NON MEANS-TESTED)",
"FLAGS OF PY112G",
"SURVIVOR BENEFITS (NON-CONTRIBUTORY AND MEANS-TESTED)",
"FLAGS OF PY113G",
"SURVIVOR BENEFITS (NON-CONTRIBUTORY AND NON MEANS-TESTED)",
"FLAGS OF PY114G",
"SICKNESS BENEFITS",
"FLAGS OF PY120G",
"FLAGS OF PY120G",
"SICKNESS BENEFITS (CONTRIBUTORY AND MEANS-TESTED)",
"FLAGS OF PY121G",
"SICKNESS BENEFITS (CONTRIBUTORY AND NON MEANS-TESTED)",
"FLAGS OF PY122G",
"SICKNESS BENEFITS (NON-CONTRIBUTORY AND MEANS-TESTED)",
"FLAGS OF PY123G",
"SICKNESS BENEFITS (NON-CONTRIBUTORY AND NON MEANS-TESTED)",
"FLAGS OF PY124G",
"DISABILITY BENEFITS",
"FLAGS OF PY130G",
"FLAGS OF PY130G",
"DISABILITY BENEFITS (CONTRIBUTORY AND MEANS-TESTED)",
"FLAGS OF PY131G",
"DISABILITY BENEFITS (CONTRIBUTORY AND NON MEANS-TESTED)",
"FLAGS OF PY132G",
"DISABILITY BENEFITS (NON-CONTRIBUTORY AND MEANS-TESTED)",
"FLAGS OF PY133G",
"DISABILITY BENEFITS (NON-CONTRIBUTORY AND NON MEANS-TESTED)",
"FLAGS OF PY134G",
"EDUCATION-RELATED ALLOWANCES",
"FLAGS OF PY140G",
"FLAGS OF PY140G",
"EDUCATION-RELATED ALLOWANCES (CONTRIBUTORY AND MEANS-TESTED)",
"FLAGS OF PY141G",
"EDUCATION-RELATED ALLOWANCES (CONTRIBUTORY AND NON MEANS-TESTED)",
"FLAGS OF PY142G",
"EDUCATION-RELATED ALLOWANCES (NON-CONTRIBUTORY AND MEANS-TESTED)",
"FLAGS OF PY143G",
"EDUCATION-RELATED ALLOWANCES (NON-CONTRIBUTORY AND NON MEANS-TESTED)",
"FLAGS OF PY144G",
"GROSS MONTHLY EARNINGS FOR EMPLOYEES",
"FLAGS OF PY200G",
"FLAGS OF PY200G",
"REPLACE WORN-OUT CLOTHES BY SOME NEW (NOT SECOND-HAND) ONES",
"FLAGS OF PD020",
"TWO PAIRS OF PROPERLY FITTING SHOES (INCLUDING A PAIR OF ALL-WEATHER SHOES)",
"FLAGS OF PD030",
"GET-TOGETHER WITH FRIENDS/FAMILY (RELATIVES) FOR A DRINK/MEAL AT LEAST ONCE A MONTH",
"FLAGS OF PD050",
"REGULARLY PARTICIPATE IN A LEISURE ACTIVITY",
"FLAGS OF PD060",
"SPEND A SMALL AMOUNT OF MONEY EACH WEEK ON YOURSELF",
"FLAGS OF PD070",
"INTERNET CONNECTION FOR PERSONAL USE AT HOME",
"FLAGS OF PD080",
"UNMET NEEDS FOR FORMAL EDUCATION",
"FLAGS OF PC110",
"MAIN REASON FOR NON-PARTICIPATION IN FORMAL EDUCATION",
"FLAGS OF PC120",
"PARTICIPATION IN TRAINING RELATED TO HOBBIES",
"FLAGS OF PC130",
"PARTICIPATION IN TRAINING RELATED TO PROFESSIONAL ACTIVITY",
"FLAGS OF PC140",
"MAIN REASON FOR NON-PARTICIPATION IN TRAINING RELATED TO PROFESSIONAL ACTIVITY",
"FLAGS OF PC150",
"CARE OR ASSISTANCE PROVIDED",
"FLAGS OF PC260",
"NUMBER OF HOURS PER WEEK OF CARE OR ASSISTANCE PROVIDED",
"FLAGS OF PC270",
"CHANGE RATE",
"AGE AT THE END OF THE INCOME REFERENCE PERIOD",
"HOUSEHOLD IDENTIFICATION NUMBER",
"SELECTED RESPONDENT STATUS",
"ACTIVITY STATUS")

PB020_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PB020, 
levels=c("AT", 
"BE", 
"BG", 
"CH", 
"CY", 
"CZ", 
"DE", 
"DK", 
"EE", 
"ES", 
"FI", 
"FR", 
"GR", 
"HU", 
"IE", 
"IS", 
"IT", 
"LT", 
"LU", 
"LV", 
"MT", 
"NL", 
"NO", 
"PL", 
"PT", 
"RO", 
"SE", 
"SI", 
"SK", 
"UK"), 
labels=c("sterreich", 
"Belgique", 
"Bulgaria", 
"Switzerland", 
"Cyprus", 
"Czech", 
"Deutschland", 
"Danmark", 
"Estonia", 
"Espaa", 
"Suomi", 
"France", 
"Ellda", 
"Hungary", 
"Ireland", 
"Iceland", 
"Italia", 
"Lithuania", 
"Luxembourg", 
"Latvia", 
"Malta", 
"Nederland", 
"Norway", 
"Poland", 
"Portugal", 
"Romania", 
"Sverige", 
"Slovenia", 
"Slovak/republic", 
"United")) 


PB040_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PB040_F, 
levels=c(1, 
-7), 
labels=c("filled", 
"Not applicable: PB010 ne last year")) 


PB060_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PB060_F, 
levels=c(1, 
-3), 
labels=c("filled", 
"not selected respondent")) 


PB100_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PB100, 
levels=c(1, 
2, 
3, 
4), 
labels=c("January-March", 
"April-June", 
"July-September", 
"October-December")) 


PB100_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PB100_F, 
levels=c(1, 
-1), 
labels=c("filled", 
"missing")) 


PB110_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PB110_F, 
levels=c(1, 
-1), 
labels=c("filled", 
"missing")) 


PB120_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PB120_F, 
levels=c(1, 
-1, 
-2), 
labels=c("filled", 
"missing", 
"na (information only extracted from registers)")) 


PB130_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PB130, 
levels=c(1, 
2, 
3, 
4), 
labels=c("January-March", 
"April-June", 
"July-September", 
"October-December")) 


PB130_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PB130_F, 
levels=c(1, 
-1), 
labels=c("filled", 
"missing")) 


PB140_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PB140_F, 
levels=c(1, 
-1), 
labels=c("filled", 
"missing")) 


PB150_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PB150, 
levels=c(1, 
2), 
labels=c("Male", 
"Female")) 


PB150_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PB150_F, 
levels=c(1, 
-1), 
labels=c("filled", 
"missing")) 


PB160_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PB160_F, 
levels=c(1, 
-1, 
-2), 
labels=c("filled", 
"missing", 
"na (father is not a household member)")) 


PB170_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PB170_F, 
levels=c(1, 
-1, 
-2), 
labels=c("filled", 
"missing", 
"na (mother is not a household member)")) 


PB180_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PB180_F, 
levels=c(1, 
-1, 
-2), 
labels=c("filled", 
"missing", 
"not applicable (person has no spouse/partner or spouse/partner is not a household member)")) 


PB190_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PB190, 
levels=c(1, 
2, 
3, 
4, 
5), 
labels=c("Never married", 
"Married", 
"Separated", 
"Widowed", 
"Divorced")) 


PB190_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PB190_F, 
levels=c(1, 
-1), 
labels=c("filled", 
"missing")) 


PB200_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PB200, 
levels=c(1, 
2, 
3), 
labels=c("yes on a legal basis", 
"yes without a legal basis", 
"no")) 


PB200_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PB200_F, 
levels=c(1, 
-1), 
labels=c("filled", 
"missing")) 


PB210_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PB210, 
levels=c("EU", 
"LOC", 
"OTH"), 
labels=c("European Countries", 
"Italy", 
"Other")) 


PB210_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PB210_F, 
levels=c(1, 
-1), 
labels=c("filled", 
"missing")) 


PB220A_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PB220A, 
levels=c("EU", 
"LOC", 
"OTH"), 
labels=c("European Countries", 
"Italy", 
"Other")) 


PB220A_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PB220A_F, 
levels=c(1, 
-1, 
-2), 
labels=c("filled", 
"missing", 
"only PB220B: na (no second citizenship)")) 


PE010_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PE010, 
levels=c(1, 
2), 
labels=c("in education", 
"not in education")) 


PE010_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PE010_F, 
levels=c(1, 
-1), 
labels=c("filled", 
"missing")) 


PE020_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PE020, 
levels=c(0, 
1, 
2, 
3, 
4, 
5, 
6, 
10, 
20, 
30, 
40, 
50), 
labels=c("pre-primary education", 
"primary education", 
"lower secondary education", 
"(upper) secondary education", 
"post-secondary non tertiary education", 
"first stage of tertiary education (not leading directly to an advanced research qualification)", 
"second stage of tertiary education (leading to an advanced research qualification)", 
"Primary education", 
"Lower secondary education", 
"Upper secondary education (not further specified)", 
"Post-secondary non tertiary education (not further specified)", 
"Tertiary education")) 


PE020_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PE020_F, 
levels=c(1, 
-1, 
-2), 
labels=c("filled", 
"missing", 
"na (PE010 not = 1)")) 


PE030_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PE030_F, 
levels=c(1, 
-1, 
-2), 
labels=c("filled", 
"missing", 
"Not applicable ((PE040=000 AND PB010 > 2013) OR (PE040_F=-2 AND PB010 < 2014))")) 


PE040_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PE040, 
levels=c(1, 
2, 
3, 
4, 
5, 
6, 
000, 
100, 
200, 
300, 
400, 
500), 
labels=c("primary education", 
"lower secondary education", 
"(upper) secondary education", 
"post-secondary non tertiary education", 
"first stage of tertiary education (not leading directly to an advanced research qualification)", 
"second stage of tertiary education (leading to an advanced research qualification)", 
"Less than primary education", 
"Primary education", 
"Lower secondary education", 
"Upper secondary education (not further specified)", 
"Post-secondary non-tertiary education (not further specified)", 
"Tertiary education")) 


PE040_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PE040_F, 
levels=c(1, 
-1, 
-2), 
labels=c("filled", 
"missing", 
"non applicable (the person has never been in education) can only be used before 2014(PB010<2014)")) 


PH010_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PH010, 
levels=c(1, 
2, 
3, 
4, 
5), 
labels=c("very good", 
"good", 
"fair", 
"bad", 
"very bad")) 


PH010_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PH010_F, 
levels=c(1, 
-1, 
-3), 
labels=c("filled", 
"missing", 
"not selected respondent")) 


PH020_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PH020, 
levels=c(1, 
2), 
labels=c("yes", 
"no")) 


PH020_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PH020_F, 
levels=c(1, 
-1, 
-3), 
labels=c("filled", 
"missing", 
"not selected respondent")) 


PH030_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PH030, 
levels=c(1, 
2, 
3), 
labels=c("yes, strongly limited", 
"yes, limited", 
"no, not limited")) 


PH030_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PH030_F, 
levels=c(1, 
-1, 
-3), 
labels=c("filled", 
"missing", 
"not selected respondent")) 


PH040_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PH040, 
levels=c(1, 
2), 
labels=c("yes, there was at least one occasion when the person really needed examination or treatment but did not", 
"no, there was no occasion when the person really needed examination or treatment but did not")) 


PH040_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PH040_F, 
levels=c(1, 
-1, 
-2, 
-3), 
labels=c("filled", 
"missing", 
"not applicable: the person did not really need any medical examination or treatment", 
"not selected respondent")) 


PH050_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PH050, 
levels=c(1, 
2, 
3, 
4, 
5, 
6, 
7, 
8), 
labels=c("Could not afford to (too expensive)", 
"Waiting list", 
"Could not take time because of work, care for children or for others", 
"Too far to travel/no means of transportation", 
"Fear of doctor/hospitals/examination/ treatment", 
"Wanted to wait and see if problem got better on its own", 
"Didnt know any good doctor or specialist", 
"Other reasons")) 


PH050_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PH050_F, 
levels=c(1, 
-1, 
-2, 
-3), 
labels=c("filled", 
"missing", 
"na (PH040 not = 1)", 
"not selected respondent")) 


PH060_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PH060, 
levels=c(1, 
2), 
labels=c("yes, there was at least one occasion when the person really needed dental examination or treatment but did not", 
"no, there was no occasion when the person really needed dental examination or treatment but did not")) 


PH060_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PH060_F, 
levels=c(1, 
-1, 
-2, 
-3), 
labels=c("filled", 
"missing", 
"not applicable: the person did not really need any dental examination or treatment", 
"not selected respondent")) 


PH070_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PH070, 
levels=c(1, 
2, 
3, 
4, 
5, 
6, 
7, 
8), 
labels=c("Could not afford to (too expensive)", 
"Waiting list", 
"Could not take time because of work, care for children or for others", 
"Too far to travel/no means of transportation", 
"Fear of doctor(dentist)/hospitals/examination/ treatment", 
"Wanted to wait and see if problem got better on its own", 
"Didnt know any good dentist", 
"Other reasons")) 


PH070_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PH070_F, 
levels=c(1, 
-1, 
-2, 
-3), 
labels=c("filled", 
"missing", 
"na (PH060 not = 1)", 
"not selected respondent")) 


PL015_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PL015, 
levels=c(1, 
2), 
labels=c("yes", 
"no")) 


PL015_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PL015_F, 
levels=c(1, 
-1, 
-2), 
labels=c("filled", 
"missing", 
"not applicable  (PL031 = 1, 2, 3 or 4)")) 


PL020_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PL020, 
levels=c(1, 
2), 
labels=c("yes", 
"no")) 


PL020_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PL020_F, 
levels=c(1, 
-1, 
-2), 
labels=c("filled", 
"missing", 
"not applicable  (PL031 = 1, 2, 3 or 4)")) 


PL025_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PL025, 
levels=c(1, 
2), 
labels=c("yes", 
"no")) 


PL025_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PL025_F, 
levels=c(1, 
-1, 
-2), 
labels=c("filled", 
"missing", 
"not applicable  (PL031 = 1, 2, 3 or 4)")) 


PL031_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PL031, 
levels=c(1, 
2, 
3, 
4, 
5, 
6, 
7, 
8, 
9, 
10, 
11), 
labels=c("Employee working full-time", 
"Employee working part-time", 
"Self-employed working full-time (including family worker)", 
"Self-employed working part-time (including family worker)", 
"Unemployed", 
"Pupil, student, further training, unpaid work experience", 
"In retirement or in early retirement or has given up business", 
"Permanently disabled or/and unfit to work", 
"In compulsory military community or service", 
"Fulfilling domestic tasks and care responsibilities", 
"Other inactive person")) 


PL031_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PL031_F, 
levels=c(1, 
-1, 
-5), 
labels=c("filled", 
"missing", 
"missing value of PL031 because PL030 is still used")) 


PL035_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PL035, 
levels=c(1, 
2), 
labels=c("yes", 
"no")) 


PL035_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PL035_F, 
levels=c(1, 
-1, 
-2, 
-3), 
labels=c("filled", 
"missing", 
"not applicable (person is not employee or MS has other source to calculate the gender pay gap)", 
"not selected respondent")) 


PL040_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PL040, 
levels=c(1, 
2, 
3, 
4), 
labels=c("self-employed with employees", 
"self-employed without employees", 
"employee", 
"family worker")) 


PL040_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PL040_F, 
levels=c(1, 
-1, 
-2), 
labels=c("filled", 
"missing", 
"not applicable ( PL031 not = 1, 2, 3 or 4 and PL015 not = 1)")) 


PL051_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PL051, 
levels=c(1, 
2, 
3, 
11, 
12, 
13, 
14, 
21, 
22, 
23, 
24, 
25, 
26, 
31, 
32, 
33, 
34, 
35, 
41, 
42, 
43, 
44, 
51, 
52, 
53, 
54, 
61, 
62, 
63, 
71, 
72, 
73, 
74, 
75, 
81, 
82, 
83, 
91, 
92, 
93, 
94, 
95, 
96), 
labels=c("Commissioned armed forces officers", 
"Non-commissioned armed forces officers", 
"Armed forces occupations, other ranks", 
"Chief executives, senior officials and legislators", 
"Administrative and commercial managers", 
"Production and specialised services managers", 
"Hospitality, retail and other services managers", 
"Science and engineering professionals", 
"Health professionals", 
"Teaching professionals", 
"Business and administration professionals", 
"Information and communications technology professionals", 
"Legal, social and cultural professionals", 
"Science and engineering associate professionals", 
"Health associate professionals", 
"Business and administration associate professionals", 
"Legal, social, cultural and related associate professionals", 
"Information and communications technicians", 
"General and keyboard clerks", 
"Customer services clerks", 
"Numerical and material recording clerks", 
"Other clerical support workers", 
"Personal service workers", 
"Sales workers", 
"Personal care workers", 
"Protective services workers", 
"Market-oriented skilled agricultural workers", 
"Market-oriented skilled forestry, fishery and hunting workers", 
"Subsistence farmers, fishers, hunters and gatherers", 
"Building and related trades workers, excluding electricians", 
"Metal, machinery and related trades workers", 
"Handicraft and printing workers", 
"Electrical and electronic trades workers", 
"Food processing, wood working, garment and other craft and related trades workers", 
"Stationary plant and machine operators", 
"Assemblers", 
"Drivers and mobile plant operators", 
"Cleaners and helpers", 
"Agricultural, forestry and fishery labourers", 
"Labourers in mining, construction, manufacturing and transport", 
"Food preparation assistants", 
"Street and related sales and service workers", 
"Refuse workers and other elementary workers")) 


PL051_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PL051_F, 
levels=c(1, 
-1, 
-2, 
-5), 
labels=c("filled", 
"missing", 
"not applicable (PL031 not = 1, 2, 3 or 4 and PL015 not = 1)", 
"missing value of PL051 because PL050 is still used")) 


PL060_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PL060_F, 
levels=c(1, 
-1, 
-2, 
-6), 
labels=c("filled", 
"missing", 
"not applicable (PL031 not = 1, 2, 3 or 4 and PL035 not = 1)", 
"hours varying (even an average over 4 weeks is not possible")) 


PL073_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PL073_F, 
levels=c(1, 
-1, 
-5), 
labels=c("filled", 
"missing", 
"missing value because the definition of this variable is not used (PL088 and PL089 only)")) 


PL074_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PL074_F, 
levels=c(1, 
-1, 
-5), 
labels=c("filled", 
"missing", 
"missing value because the definition of this variable is not used (PL088 and PL089 only)")) 


PL075_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PL075_F, 
levels=c(1, 
-1, 
-5), 
labels=c("filled", 
"missing", 
"missing value because the definition of this variable is not used (PL088 and PL089 only)")) 


PL076_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PL076_F, 
levels=c(1, 
-1, 
-5), 
labels=c("filled", 
"missing", 
"missing value because the definition of this variable is not used (PL088 and PL089 only)")) 


PL080_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PL080_F, 
levels=c(1, 
-1, 
-5), 
labels=c("filled", 
"missing", 
"missing value because the definition of this variable is not used (PL088 and PL089 only)")) 


PL085_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PL085_F, 
levels=c(1, 
-1, 
-5), 
labels=c("filled", 
"missing", 
"missing value because the definition of this variable is not used (PL088 and PL089 only)")) 


PL086_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PL086_F, 
levels=c(1, 
-1, 
-5), 
labels=c("filled", 
"missing", 
"missing value because the definition of this variable is not used (PL088 and PL089 only)")) 


PL087_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PL087_F, 
levels=c(1, 
-1, 
-5), 
labels=c("filled", 
"missing", 
"missing value because the definition of this variable is not used (PL088 and PL089 only)")) 


PL088_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PL088_F, 
levels=c(1, 
-1, 
-5), 
labels=c("filled", 
"missing", 
"missing value because the definition of this variable is not used (PL088 and PL089 only)")) 


PL089_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PL089_F, 
levels=c(1, 
-1, 
-5), 
labels=c("filled", 
"missing", 
"missing value because the definition of this variable is not used (PL088 and PL089 only)")) 


PL090_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PL090_F, 
levels=c(1, 
-1, 
-5), 
labels=c("filled", 
"missing", 
"missing value because the definition of this variable is not used (PL088 and PL089 only)")) 


PL100_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PL100_F, 
levels=c(1, 
-1, 
-2), 
labels=c("filled", 
"missing", 
"na (person does not have a second job or PL030 not = 1 or 2)")) 


PL111_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PL111, 
levels=c("a", 
"f", 
"g", 
"h", 
"i", 
"j", 
"k", 
"o", 
"p", 
"q", 
"b - e", 
"l - n", 
"r - u"), 
labels=c("Agriculture ,forestry and fishing", 
"Construction", 
"Wholesale retail", 
"Transportation and storage", 
"Accommodation and food service activities", 
"Information and communication", 
"Financial and insurance activities", 
"Public administration and defence, compulsory social security", 
"Education", 
"Human health and social work activities", 
"Mining and quarrying, Manufacturing, Electricity, gas, steam and air conditioning supply, Water supply", 
"Real estate activities, Professional, scientific and technical activities, Administrative and support service activities", 
"Arts, entertainment and recreation, Other service activities, Activities as household as employer..., Activities of extraterritorial organisations and bodies")) 


PL111_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PL111_F, 
levels=c(1, 
-1, 
-2, 
-3), 
labels=c("filled", 
"missing", 
"na (PL031 not = 1, 2,3 or 4)", 
"not selected respondent")) 


PL120_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PL120, 
levels=c(1, 
2, 
3, 
4, 
5, 
6, 
7), 
labels=c("Undergoing education or training", 
"Personal illness or disability", 
"Want to work more hours but cannot find a job(s) or work(s) of more hours", 
"Do not want to work more hours", 
"Number of hours in all job(s) are considered as a full-time job", 
"Housework, looking after children or other persons", 
"Other reasons")) 


PL120_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PL120_F, 
levels=c(1, 
-1, 
-2, 
-3), 
labels=c("filled", 
"missing", 
"not applicable (Not (PL031 = 1, 2 , 3 or 4, and PL060 + PL100 < 30))", 
"not selected respondent")) 


PL130_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PL130, 
levels=c(1, 
2, 
3, 
4, 
5, 
6, 
7, 
8, 
9, 
10, 
11, 
12, 
13, 
14, 
15), 
labels=c("between 1 and 10", 
"between 1 and 10", 
"between 1 and 10", 
"between 1 and 10", 
"between 1 and 10", 
"between 1 and 10", 
"between 1 and 10", 
"between 1 and 10", 
"between 1 and 10", 
"between 1 and 10", 
"between 11 and 19 persons", 
"between 20 and 49 persons", 
"50 persons and more", 
"do not know but less than 11 persons", 
"do not know but more than 10 persons")) 


PL130_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PL130_F, 
levels=c(1, 
-1, 
-2, 
-3), 
labels=c("filled", 
"missing", 
"not applicable ( PL031 not = 1, 2, 3 or 4 and PL035 not = 1)", 
"not selected respondent")) 


PL140_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PL140, 
levels=c(1, 
2), 
labels=c("permanent job/work contract of unlimited duration", 
"temporary job/work contract of limited duration")) 


PL140_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PL140_F, 
levels=c(1, 
-1, 
-2, 
-3, 
-4), 
labels=c("filled", 
"missing", 
"not applicable (PL040 not = 3)", 
"not selected respondent", 
"not applicable because the person is employee (PL040=3) but has not any contract")) 


PL150_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PL150, 
levels=c(1, 
2), 
labels=c("supervisory", 
"non-supervisory")) 


PL150_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PL150_F, 
levels=c(1, 
-1, 
-2, 
-3), 
labels=c("filled", 
"missing", 
"not applicable (PL040 not = 3)", 
"not selected respondent")) 


PL160_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PL160, 
levels=c(1, 
2), 
labels=c("yes", 
"no")) 


PL160_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PL160_F, 
levels=c(1, 
-1, 
-2, 
-3), 
labels=c("filled", 
"missing", 
"not applicable (PL031 not = 1, 2, 3 or 4)", 
"not selected respondent")) 


PL170_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PL170, 
levels=c(1, 
2, 
3, 
4, 
5, 
6, 
7), 
labels=c("To take up or seek better job", 
"End of temporary contract", 
"Obliged to stop by employer (business closure, redundancy, early retirement, dismissal etc.)", 
"Sale or closure of own/family business", 
"Child care and care for other dependent", 
"Partners job required us to move to another area or marriage", 
"Other reasons")) 


PL170_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PL170_F, 
levels=c(1, 
-1, 
-2, 
-3), 
labels=c("filled", 
"missing", 
"na (PL160 not = 1)", 
"not selected respondent")) 


PL180_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PL180, 
levels=c(1, 
2, 
3, 
4, 
5, 
6, 
7, 
8, 
9, 
10, 
11, 
12), 
labels=c("employed - unemployed", 
"employed - retired", 
"employed - other inactive", 
"unemployed - employed", 
"unemployed - retired", 
"unemployed - other inactive", 
"retired - employed", 
"retired - unemployed", 
"retired - other inactive", 
"other inactive - employed", 
"other inactive - unemployed", 
"other inactive - retired")) 


PL180_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PL180_F, 
levels=c(1, 
-1, 
-2, 
-3), 
labels=c("filled", 
"missing", 
"not applicable (no change since last year)", 
"not selected respondent")) 


PL190_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PL190_F, 
levels=c(1, 
-1, 
-2, 
-3), 
labels=c("filled", 
"missing", 
"not applicable (person never worked i.e. (PL031 not = 1, 2, 3 or 4 AND PL015 not= 1))", 
"not selected respondent")) 


PL200_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PL200_F, 
levels=c(1, 
-1, 
-2, 
-3), 
labels=c("filled", 
"missing", 
"na (person never worked)", 
"not selected respondent")) 


PL211A_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PL211A, 
levels=c(1, 
2, 
3, 
4, 
5, 
6, 
7, 
8, 
9, 
10, 
11), 
labels=c("Employee working full-time", 
"Employee working part-time", 
"Self-employed working full-time (including family worker)", 
"Self-employed working part-time (including family worker)", 
"Unemployed", 
"Pupil, student, further training, unpaid work experience", 
"In retirement or in early retirement or has given up business", 
"Permanently disabled or/and unfit to work", 
"In compulsory military community or service", 
"Fulfilling domestic tasks and care responsibilities", 
"Other inactive person")) 


PL211A_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PL211A_F, 
levels=c(1, 
-1, 
-3), 
labels=c("filled", 
"missing", 
"not selected respondent")) 


PL211B_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PL211B, 
levels=c(1, 
2, 
3, 
4, 
5, 
6, 
7, 
8, 
9, 
10, 
11), 
labels=c("Employee working full-time", 
"Employee working part-time", 
"Self-employed working full-time (including family worker)", 
"Self-employed working part-time (including family worker)", 
"Unemployed", 
"Pupil, student, further training, unpaid work experience", 
"In retirement or in early retirement or has given up business", 
"Permanently disabled or/and unfit to work", 
"In compulsory military community or service", 
"Fulfilling domestic tasks and care responsibilities", 
"Other inactive person")) 


PL211B_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PL211B_F, 
levels=c(1, 
-1, 
-3), 
labels=c("filled", 
"missing", 
"not selected respondent")) 


PL211C_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PL211C, 
levels=c(1, 
2, 
3, 
4, 
5, 
6, 
7, 
8, 
9, 
10, 
11), 
labels=c("Employee working full-time", 
"Employee working part-time", 
"Self-employed working full-time (including family worker)", 
"Self-employed working part-time (including family worker)", 
"Unemployed", 
"Pupil, student, further training, unpaid work experience", 
"In retirement or in early retirement or has given up business", 
"Permanently disabled or/and unfit to work", 
"In compulsory military community or service", 
"Fulfilling domestic tasks and care responsibilities", 
"Other inactive person")) 


PL211C_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PL211C_F, 
levels=c(1, 
-1, 
-3), 
labels=c("filled", 
"missing", 
"not selected respondent")) 


PL211D_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PL211D, 
levels=c(1, 
2, 
3, 
4, 
5, 
6, 
7, 
8, 
9, 
10, 
11), 
labels=c("Employee working full-time", 
"Employee working part-time", 
"Self-employed working full-time (including family worker)", 
"Self-employed working part-time (including family worker)", 
"Unemployed", 
"Pupil, student, further training, unpaid work experience", 
"In retirement or in early retirement or has given up business", 
"Permanently disabled or/and unfit to work", 
"In compulsory military community or service", 
"Fulfilling domestic tasks and care responsibilities", 
"Other inactive person")) 


PL211D_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PL211D_F, 
levels=c(1, 
-1, 
-3), 
labels=c("filled", 
"missing", 
"not selected respondent")) 


PL211E_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PL211E, 
levels=c(1, 
2, 
3, 
4, 
5, 
6, 
7, 
8, 
9, 
10, 
11), 
labels=c("Employee working full-time", 
"Employee working part-time", 
"Self-employed working full-time (including family worker)", 
"Self-employed working part-time (including family worker)", 
"Unemployed", 
"Pupil, student, further training, unpaid work experience", 
"In retirement or in early retirement or has given up business", 
"Permanently disabled or/and unfit to work", 
"In compulsory military community or service", 
"Fulfilling domestic tasks and care responsibilities", 
"Other inactive person")) 


PL211E_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PL211E_F, 
levels=c(1, 
-1, 
-3), 
labels=c("filled", 
"missing", 
"not selected respondent")) 


PL211F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PL211F, 
levels=c(1, 
2, 
3, 
4, 
5, 
6, 
7, 
8, 
9, 
10, 
11), 
labels=c("Employee working full-time", 
"Employee working part-time", 
"Self-employed working full-time (including family worker)", 
"Self-employed working part-time (including family worker)", 
"Unemployed", 
"Pupil, student, further training, unpaid work experience", 
"In retirement or in early retirement or has given up business", 
"Permanently disabled or/and unfit to work", 
"In compulsory military community or service", 
"Fulfilling domestic tasks and care responsibilities", 
"Other inactive person")) 


PL211F_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PL211F_F, 
levels=c(1, 
-1, 
-3), 
labels=c("filled", 
"missing", 
"not selected respondent")) 


PL211G_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PL211G, 
levels=c(1, 
2, 
3, 
4, 
5, 
6, 
7, 
8, 
9, 
10, 
11), 
labels=c("Employee working full-time", 
"Employee working part-time", 
"Self-employed working full-time (including family worker)", 
"Self-employed working part-time (including family worker)", 
"Unemployed", 
"Pupil, student, further training, unpaid work experience", 
"In retirement or in early retirement or has given up business", 
"Permanently disabled or/and unfit to work", 
"In compulsory military community or service", 
"Fulfilling domestic tasks and care responsibilities", 
"Other inactive person")) 


PL211G_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PL211G_F, 
levels=c(1, 
-1, 
-3), 
labels=c("filled", 
"missing", 
"not selected respondent")) 


PL211H_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PL211H, 
levels=c(1, 
2, 
3, 
4, 
5, 
6, 
7, 
8, 
9, 
10, 
11), 
labels=c("Employee working full-time", 
"Employee working part-time", 
"Self-employed working full-time (including family worker)", 
"Self-employed working part-time (including family worker)", 
"Unemployed", 
"Pupil, student, further training, unpaid work experience", 
"In retirement or in early retirement or has given up business", 
"Permanently disabled or/and unfit to work", 
"In compulsory military community or service", 
"Fulfilling domestic tasks and care responsibilities", 
"Other inactive person")) 


PL211H_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PL211H_F, 
levels=c(1, 
-1, 
-3), 
labels=c("filled", 
"missing", 
"not selected respondent")) 


PL211I_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PL211I, 
levels=c(1, 
2, 
3, 
4, 
5, 
6, 
7, 
8, 
9, 
10, 
11), 
labels=c("Employee working full-time", 
"Employee working part-time", 
"Self-employed working full-time (including family worker)", 
"Self-employed working part-time (including family worker)", 
"Unemployed", 
"Pupil, student, further training, unpaid work experience", 
"In retirement or in early retirement or has given up business", 
"Permanently disabled or/and unfit to work", 
"In compulsory military community or service", 
"Fulfilling domestic tasks and care responsibilities", 
"Other inactive person")) 


PL211I_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PL211I_F, 
levels=c(1, 
-1, 
-3), 
labels=c("filled", 
"missing", 
"not selected respondent")) 


PL211J_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PL211J, 
levels=c(1, 
2, 
3, 
4, 
5, 
6, 
7, 
8, 
9, 
10, 
11), 
labels=c("Employee working full-time", 
"Employee working part-time", 
"Self-employed working full-time (including family worker)", 
"Self-employed working part-time (including family worker)", 
"Unemployed", 
"Pupil, student, further training, unpaid work experience", 
"In retirement or in early retirement or has given up business", 
"Permanently disabled or/and unfit to work", 
"In compulsory military community or service", 
"Fulfilling domestic tasks and care responsibilities", 
"Other inactive person")) 


PL211J_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PL211J_F, 
levels=c(1, 
-1, 
-3), 
labels=c("filled", 
"missing", 
"not selected respondent")) 


PL211K_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PL211K, 
levels=c(1, 
2, 
3, 
4, 
5, 
6, 
7, 
8, 
9, 
10, 
11), 
labels=c("Employee working full-time", 
"Employee working part-time", 
"Self-employed working full-time (including family worker)", 
"Self-employed working part-time (including family worker)", 
"Unemployed", 
"Pupil, student, further training, unpaid work experience", 
"In retirement or in early retirement or has given up business", 
"Permanently disabled or/and unfit to work", 
"In compulsory military community or service", 
"Fulfilling domestic tasks and care responsibilities", 
"Other inactive person")) 


PL211K_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PL211K_F, 
levels=c(1, 
-1, 
-3), 
labels=c("filled", 
"missing", 
"not selected respondent")) 


PL211L_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PL211L, 
levels=c(1, 
2, 
3, 
4, 
5, 
6, 
7, 
8, 
9, 
10, 
11), 
labels=c("Employee working full-time", 
"Employee working part-time", 
"Self-employed working full-time (including family worker)", 
"Self-employed working part-time (including family worker)", 
"Unemployed", 
"Pupil, student, further training, unpaid work experience", 
"In retirement or in early retirement or has given up business", 
"Permanently disabled or/and unfit to work", 
"In compulsory military community or service", 
"Fulfilling domestic tasks and care responsibilities", 
"Other inactive person")) 


PL211L_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PL211L_F, 
levels=c(1, 
-1, 
-3), 
labels=c("filled", 
"missing", 
"not selected respondent")) 


PD020_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PD020, 
levels=c(1, 
2, 
3), 
labels=c("Yes", 
"No, because cannot afford it", 
"No, for some other reason")) 


PD020_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PD020_F, 
levels=c(1, 
-1, 
-3), 
labels=c("filled", 
"missing", 
"not selected respondent")) 


PD030_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PD030, 
levels=c(1, 
2, 
3), 
labels=c("Yes", 
"No, because cannot afford it", 
"No, for some other reason")) 


PD030_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PD030_F, 
levels=c(1, 
-1, 
-3), 
labels=c("filled", 
"missing", 
"not selected respondent")) 


PD050_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PD050, 
levels=c(1, 
2, 
3), 
labels=c("Yes", 
"No, because cannot afford it", 
"No, for some other reason")) 


PD050_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PD050_F, 
levels=c(1, 
-1, 
-3), 
labels=c("filled", 
"missing", 
"not selected respondent")) 


PD060_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PD060, 
levels=c(1, 
2, 
3), 
labels=c("Yes", 
"No, because cannot afford it", 
"No, for some other reason")) 


PD060_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PD060_F, 
levels=c(1, 
-1, 
-3), 
labels=c("filled", 
"missing", 
"not selected respondent")) 


PD070_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PD070, 
levels=c(1, 
2, 
3), 
labels=c("Yes", 
"No, because cannot afford it", 
"No, for some other reason")) 


PD070_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PD070_F, 
levels=c(1, 
-1, 
-3), 
labels=c("filled", 
"missing", 
"not selected respondent")) 


PD080_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PD080, 
levels=c(1, 
2, 
3), 
labels=c("Yes", 
"No, because cannot afford it", 
"No, for some other reason")) 


PD080_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PD080_F, 
levels=c(1, 
-1, 
-3), 
labels=c("filled", 
"missing", 
"not selected respondent")) 


PC110_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PC110, 
levels=c(1, 
2), 
labels=c("yes", 
"no")) 


PC110_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PC110_F, 
levels=c(1, 
-1, 
-3, 
-4, 
-7), 
labels=c("filled", 
"missing", 
"not selected respondent", 
"person currently in formal education", 
"not applicable PB010 not = 2016")) 


PC120_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PC120, 
levels=c(1, 
2, 
3, 
4, 
5), 
labels=c("cannot afford it", 
"not admitted to the course programme", 
"time constraints (schedule, family responsibilities, etc.)", 
"no suitable course or programmes available", 
"other reasons")) 


PC120_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PC120_F, 
levels=c(1, 
-1, 
-2, 
-3, 
-4, 
-7), 
labels=c("filled", 
"missing", 
"not applicable (PC110=2)", 
"not selected respondent", 
"person currently in formal education", 
"not applicable PB010 not = 2016")) 


PC130_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PC130, 
levels=c(1, 
2), 
labels=c("yes", 
"no")) 


PC130_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PC130_F, 
levels=c(1, 
-1, 
-3, 
-7), 
labels=c("filled", 
"missing", 
"not selected respondent", 
"not applicable PB010 not = 2016")) 


PC140_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PC140, 
levels=c(1, 
2), 
labels=c("yes", 
"no")) 


PC140_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PC140_F, 
levels=c(1, 
-1, 
-3, 
-7), 
labels=c("filled", 
"missing", 
"not selected respondent", 
"not applicable PB010 not = 2016")) 


PC150_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PC150, 
levels=c(1, 
2, 
3, 
4, 
5, 
6), 
labels=c("cannot afford it", 
"not interested", 
"time constraints (schedule, family responsibilities, etc.)", 
"no suitable course or programmes available", 
"not provided by employer", 
"other reasons")) 


PC150_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PC150_F, 
levels=c(1, 
-1, 
-2, 
-3, 
-7), 
labels=c("filled", 
"missing", 
"not applicable (PC140=1)", 
"not selected respondent", 
"not applicable PB010 not = 2016")) 


PC260_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PC260, 
levels=c(1, 
2, 
3, 
4), 
labels=c("yes  only to household members", 
"yes  only to persons who are not the household members", 
"yes- to household members and to persons who are not the household members", 
"no")) 


PC260_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PC260_F, 
levels=c(1, 
-1, 
-3, 
-7), 
labels=c("filled", 
"missing", 
"not selected respondent", 
"not applicable PB010 not = 2016")) 


PC270_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PC270, 
levels=c(1, 
2, 
3), 
labels=c("less than 10 hours per week", 
"at least 10 but less than 20 hours per week", 
"20 hours per week or more")) 


PC270_F_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PC270_F, 
levels=c(1, 
-1, 
-2, 
-3, 
-7), 
labels=c("filled", 
"missing", 
"not applicable (PC260=4)", 
"not selected respondent", 
"not applicable PB010 not = 2016")) 


PX040_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PX040, 
levels=c(1, 
2, 
3, 
4), 
labels=c("current household member aged 16 and over Only selected household member aged 16 and over is interviewed", 
"selected respondent", 
"not selected respondent Households members aged less than 16 at the time of interview", 
"not eligible person")) 


PX050_Fact <- factor(DF_EU-SILC_A2016_PERSONAL_DATA_$PX050, 
levels=c(2, 
3, 
4, 
5, 
6, 
7, 
8), 
labels=c("employees (SAL)", 
"employed persons except employees (NSAL)", 
"other employed (when time of SAL and NSAL is >  of total time calendar)", 
"unemployed", 
"retired", 
"inactive", 
"other inactive (when time of unemployed, retirement and inactivity is >  of total time calendar)")) 

save.image (file="DF_EU-SILC_A2016_PERSONAL_DATA_.RData")
