/*    LIMITAZIONE DELLA RESPONSABILITA'. 
  Il software  fornito "cos com'", senza garanzie di  sorta.               */
%macro grabpath;
%qsubstr(%sysget(SAS_EXECFILEPATH),1,%length(%sysget(SAS_EXECFILEPATH))-%length(%sysget(SAS_EXECFILEname)))
%mend grabpath;
%let path = %grabpath;
%let nomeFile =ISTAT_MFR_EU-SILC_Microdati_2016_HOUSEHOLD_REGISTER_(D-FILE)_Cross-Sectional__ESEMPIO_STRUTTURA_FILE.txt;
LIBNAME ISTAT "&path";
DATA ISTAT.EU-SILC_A2016_HOUSEHOLD_REGISTE;

INFILE "&path&nomeFile" DLM='5E'x  LRECL=32767 TRUNCOVER FIRSTOBS=2 IGNOREDOSEOF;
INPUT 
DB010 :5.   /*  YEAR OF THE SURVEY */
DB020 : $3.   /*  COUNTRY */
DB030 :10.   /*  HOUSEHOLD ID */
DB040 : $5.   /*  REGION */
DB040_F :2.   /*  FLAGS  of DB040 */
DB060 :4.   /*  PRIMARY SAMPLING UNITS (PSU) */
DB060_F :2.   /*  FLAGS of DB060 */
DB062 :4.   /*  SECONDARY SAMPLING UNITS (SSU) */
DB062_F :2.   /*  FLAGS of DB062 */
DB070 :2.   /*  ORDER OF SELECTION OF PSU */
DB070_F :3.   /*  FLAGS of DB070 */
DB075 :2.   /*  ROTATIONAL GROUP */
DB075_F :2.   /*  FLAGS of DB075 */
DB090 :16.   /*  HOUSEHOLD CROSS-SECTIONAL WEIGHT */
DB090_F :2.   /*  FLAGS of DB090 */
DB100 :2.   /*  DEGREE OF URBANISATION */
DB100_F :2.   /*  FLAGS of DB100 */
;
LABEL 
DB010 = "YEAR OF THE SURVEY"
DB020 = "COUNTRY"
DB030 = "HOUSEHOLD ID"
DB040 = "REGION"
DB040_F = "FLAGS  of DB040"
DB060 = "PRIMARY SAMPLING UNITS (PSU)"
DB060_F = "FLAGS of DB060"
DB062 = "SECONDARY SAMPLING UNITS (SSU)"
DB062_F = "FLAGS of DB062"
DB070 = "ORDER OF SELECTION OF PSU"
DB070_F = "FLAGS of DB070"
DB075 = "ROTATIONAL GROUP"
DB075_F = "FLAGS of DB075"
DB090 = "HOUSEHOLD CROSS-SECTIONAL WEIGHT"
DB090_F = "FLAGS of DB090"
DB100 = "DEGREE OF URBANISATION"
DB100_F = "FLAGS of DB100"
;
RUN;
PROC FORMAT;
VALUE $DB01F /* DB020 */
"AT" = "sterreich"
"BE" = "Belgique"
"BG" = "Bulgaria"
"CH" = "Switzerland"
"CY" = "Cyprus"
"CZ" = "Czech"
"DE" = "Deutschland"
"DK" = "Danmark"
"EE" = "Estonia"
"ES" = "Espaa"
"FI" = "Suomi"
"FR" = "France"
"GR" = "Ellda"
"HU" = "Hungary"
"IE" = "Ireland"
"IS" = "Iceland"
"IT" = "Italia"
"LT" = "Lithuania"
"LU" = "Luxembourg"
"LV" = "Latvia"
"MT" = "Malta"
"NL" = "Nederland"
"NO" = "Norway"
"PL" = "Poland"
"PT" = "Portugal"
"RO" = "Romania"
"SE" = "Sverige"
"SI" = "Slovenia"
"SK" = "Slovak/republic"
"UK" = "United"
;
VALUE $DB03F /* DB040 */
"ITC" = "Northwest Italy"
"ITF" = "Northeast Italy"
"ITG" = "Central Italy"
"ITH" = "South Italy"
"ITI" = "Insular Italy"
;
VALUE DB04F /* DB040_F */
1= "filled"
-1= "Missing"
;
VALUE DB06F /* DB060_F */
1= "Rotation is implemented at PSU level (the PSU rotates in and out of the sample)"
2= "Rotation is implemented at SSU or household level (The PSU remains in the sample for the entire duration of EU-SILC)"
-2= "Not applicable (no first or second sampling stage)"
;
VALUE DB08F /* DB062_F */
1= "Rotation is implemented at PSU level (the PSU rotates in and out of the sample)"
2= "Rotation is implemented at SSU or household level (The PSU remains in the sample for the entire duration of EU-SILC)"
-2= "Not applicable (no first or second sampling stage)"
;
VALUE DB010F /* DB070_F */
1= "filled"
-2= "not applicable"
;
VALUE DB012F /* DB075_F */
1= "filled"
-2= "na (no rotational design is used)"
;
VALUE DB014F /* DB090_F */
1= "filled"
-7= "Not applicable: DB010 ne last year"
;
VALUE DB115F /* DB100 */
1= "densely populated area"
2= "intermediate area"
3= "thinly populated area"
;
VALUE DB116F /* DB100_F */
1= "filled"
-1= "missing (from wave 2 onwards)"
;
format DB020 $DB01F.;
format DB040 $DB03F.;
format DB040_F DB04F.;
format DB060_F DB06F.;
format DB062_F DB08F.;
format DB070_F DB010F.;
format DB075_F DB012F.;
format DB090_F DB014F.;
format DB100 DB115F.;
format DB100_F DB116F.;
RUN;
