#LIMITAZIONE DELLA RESPONSABILITA'. 
#Il software  fornito "cos com'", senza garanzie di  sorta.
setwd(choose.dir(default = "", caption = "WHERE ARE MICRODATA?"))
direttorio = getwd()
fileInput = paste (direttorio, "/ISTAT_MFR_EU-SILC_Microdati_2016_HOUSEHOLD_REGISTER_(D-FILE)_Cross-Sectional__ESEMPIO_STRUTTURA_FILE.txt", sep="")
DF_EU-SILC_A2016_HOUSEHOLD_REGI<- read.delim2 (fileInput,  header=T, sep="^",  quote="",  na.strings = ".")
attr(DF_EU-SILC_A2016_HOUSEHOLD_REGI, "label") <- c(
"YEAR OF THE SURVEY",
"COUNTRY",
"HOUSEHOLD ID",
"REGION",
"FLAGS  of DB040",
"PRIMARY SAMPLING UNITS (PSU)",
"FLAGS of DB060",
"SECONDARY SAMPLING UNITS (SSU)",
"FLAGS of DB062",
"ORDER OF SELECTION OF PSU",
"FLAGS of DB070",
"ROTATIONAL GROUP",
"FLAGS of DB075",
"HOUSEHOLD CROSS-SECTIONAL WEIGHT",
"FLAGS of DB090",
"DEGREE OF URBANISATION",
"FLAGS of DB100")

DB020_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_REGI$DB020, 
levels=c("AT", 
"BE", 
"BG", 
"CH", 
"CY", 
"CZ", 
"DE", 
"DK", 
"EE", 
"ES", 
"FI", 
"FR", 
"GR", 
"HU", 
"IE", 
"IS", 
"IT", 
"LT", 
"LU", 
"LV", 
"MT", 
"NL", 
"NO", 
"PL", 
"PT", 
"RO", 
"SE", 
"SI", 
"SK", 
"UK"), 
labels=c("sterreich", 
"Belgique", 
"Bulgaria", 
"Switzerland", 
"Cyprus", 
"Czech", 
"Deutschland", 
"Danmark", 
"Estonia", 
"Espaa", 
"Suomi", 
"France", 
"Ellda", 
"Hungary", 
"Ireland", 
"Iceland", 
"Italia", 
"Lithuania", 
"Luxembourg", 
"Latvia", 
"Malta", 
"Nederland", 
"Norway", 
"Poland", 
"Portugal", 
"Romania", 
"Sverige", 
"Slovenia", 
"Slovak/republic", 
"United")) 


DB040_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_REGI$DB040, 
levels=c("ITC", 
"ITF", 
"ITG", 
"ITH", 
"ITI"), 
labels=c("Northwest Italy", 
"Northeast Italy", 
"Central Italy", 
"South Italy", 
"Insular Italy")) 


DB040_F_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_REGI$DB040_F, 
levels=c(1, 
-1), 
labels=c("filled", 
"Missing")) 


DB060_F_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_REGI$DB060_F, 
levels=c(1, 
2, 
-2), 
labels=c("Rotation is implemented at PSU level (the PSU rotates in and out of the sample)", 
"Rotation is implemented at SSU or household level (The PSU remains in the sample for the entire duration of EU-SILC)", 
"Not applicable (no first or second sampling stage)")) 


DB062_F_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_REGI$DB062_F, 
levels=c(1, 
2, 
-2), 
labels=c("Rotation is implemented at PSU level (the PSU rotates in and out of the sample)", 
"Rotation is implemented at SSU or household level (The PSU remains in the sample for the entire duration of EU-SILC)", 
"Not applicable (no first or second sampling stage)")) 


DB070_F_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_REGI$DB070_F, 
levels=c(1, 
-2), 
labels=c("filled", 
"not applicable")) 


DB075_F_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_REGI$DB075_F, 
levels=c(1, 
-2), 
labels=c("filled", 
"na (no rotational design is used)")) 


DB090_F_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_REGI$DB090_F, 
levels=c(1, 
-7), 
labels=c("filled", 
"Not applicable: DB010 ne last year")) 


DB100_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_REGI$DB100, 
levels=c(1, 
2, 
3), 
labels=c("densely populated area", 
"intermediate area", 
"thinly populated area")) 


DB100_F_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_REGI$DB100_F, 
levels=c(1, 
-1), 
labels=c("filled", 
"missing (from wave 2 onwards)")) 

save.image (file="DF_EU-SILC_A2016_HOUSEHOLD_REGI.RData")
