/*    LIMITAZIONE DELLA RESPONSABILITA'. 
  Il software  fornito "cos com'", senza garanzie di  sorta.               */
%macro grabpath;
%qsubstr(%sysget(SAS_EXECFILEPATH),1,%length(%sysget(SAS_EXECFILEPATH))-%length(%sysget(SAS_EXECFILEname)))
%mend grabpath;
%let path = %grabpath;
%let nomeFile =ISTAT_MFR_EU-SILC_Microdati_2016_HOUSEHOLD_DATA_(H-FILE)_Cross-Sectional_ESEMPIO_STRUTTURA_FILE.txt;
LIBNAME ISTAT "&path";
DATA ISTAT.EU-SILC_A2016_HOUSEHOLD_DATA_(H;

INFILE "&path&nomeFile" DLM='5E'x  LRECL=32767 TRUNCOVER FIRSTOBS=2 IGNOREDOSEOF;
INPUT 
HB010 :5.   /*  YEAR OF THE SURVEY */
HB020 : $2.   /*  COUNTRY OF HB020 */
HB030 :10.   /*  HOUSEHOLD ID */
HB050 :3.   /*  MONTH OF HOUSEHOLD INTERVIEW */
HB050_F :2.   /*  FLAGS OF HB050 */
HB060 :5.   /*  YEAR OF HOUSEHOLD INTERVIEW */
HB060_F :2.   /*  FLAGS OF HB060 */
HB070 :12.   /*  PERSON RESPONDING THE HOUSEHOLD QUESTIONNAIRE */
HB070_F :2.   /*  FLAGS OF HB070 */
HB080 :12.   /*  PERSON 1 RESPONSIBLE FOR THE ACCOMMODATION */
HB080_F :2.   /*  FLAGS OF HB080 */
HB090 :12.   /*  PERSON 2 RESPONSIBLE FOR THE ACCOMMODATION */
HB090_F :2.   /*  FLAGS OF HB090 */
HB100 :3.   /*  NUMBER OF MINUTES TO COMPLETE THE HOUSEHOLD QUESTIONNAIRE */
HB100_F :2.   /*  FLAGS OF HB100 */
HH010 :2.   /*  DWELLING TYPE */
HH010_F :2.   /*  FLAGS OF HH010 */
HH021 :2.   /*  TENURE STATUS */
HH021_F :2.   /*  FLAGS OF HH021 */
HH030 :3.   /*  NUMBER OF ROOMS AVAILABLE TO THE HOUSEHOLD */
HH030_F :2.   /*  FLAGS OF HH030 */
HH031 :5.   /*  YEAR OF CONTRACT OR PURCHASING OR INSTALLATION */
HH031_F :2.   /*  FLAGS OF HH031 */
HH040 :2.   /*  LEAKING ROOF DAMP WALLS/FLOORS/FOUNDATION OR ROT IN WINDOW FRAMES OR FLOOR */
HH040_F :2.   /*  FLAGS OF HH040 */
HH050 :2.   /*  ABILITY TO KEEP HOME ADEQUATELY WARM */
HH050_F :2.   /*  FLAGS OF HH050 */
HH060 :5.   /*  CURRENT RENT RELATED TO OCCUPIED DWELLING */
HH060_F :2.   /*  FLAGS OF HH060 */
HH061 :5.   /*  SUBJECTIVE RENT */
HH061_F :2.   /*  FLAGS OF HH061 */
HH070 :5.   /*  TOTAL HOUSING COST */
HH070_F :2.   /*  FLAGS OF HH070 */
HH071 :5.   /*  MORTGAGE PRINCIPAL REPAYMENT */
HH071_F :2.   /*  FLAGS OF HH071 */
HH081 :2.   /*  BATH OR SHOWER IN DWELLING */
HH081_F :3.   /*  FLAGS OF HH081 */
HH091 :2.   /*  INDOOR FLUSHING TOILET FOR SOLE USE OF HOUSEHOLD */
HH091_F :3.   /*  FLAGS OF HH091 */
HS011 :2.   /*  ARREARS ON MORTGAGE OR RENT PAYMENTS */
HS011_F :3.   /*  FLAGS OF HS011 */
HS021 :2.   /*  ARREARS ON UTILITY BILLS */
HS021_F :3.   /*  FLAGS OF HS021 */
HS031 :2.   /*  ARREARS ON HIRE PURCHASE INSTALMENTS OR OTHER LOAN PAYMENTS */
HS031_F :3.   /*  FLAGS OF HS031 */
HS040 :2.   /*  CAPACITY TO AFFORD PAYING FOR ONE WEEK ANNUAL HOLIDAY AWAY FROM HOME */
HS040_F :2.   /*  FLAGS OF HS040 */
HS050 :2.   /*  CAPACITY TO AFFORD A MEAL WITH MEAT CHICKEN FISH (OR VEGETARIAN EQUIVALENT) EVERY SECOND DAY */
HS050_F :2.   /*  FLAGS OF HS050 */
HS060 :2.   /*  CAPACITY TO FACE UNEXPECTED FINALCIAL EXPENSES */
HS060_F :2.   /*  FLAGS OF HS060 */
HS070 :2.   /*  DO YOU HAVE A TELEPHONE (INCLUDING MOBILE PHONE)? */
HS070_F :2.   /*  FLAGS OF HS070 */
HS080 :2.   /*  DO YOU HAVE A COLOUR TV? */
HS080_F :2.   /*  FLAGS OF HS080 */
HS090 :2.   /*  DO YOU HAVE A COMPUTER? */
HS090_F :2.   /*  FLAGS OF HS090 */
HS100 :2.   /*  DO YOU HAVE A COMPUTER? */
HS100_F :2.   /*  FLAGS OF HS100 */
HS110 :2.   /*  DO YOU HAVE A CAR? */
HS110_F :2.   /*  FLAGS OF HS110 */
HS120 :2.   /*  ABILITY TO MAKE ENDS MEET */
HS120_F :2.   /*  FLAGS OF HS120 */
HS130 :6.   /*  LOWEST MONTHLY INCOME TO MAKE ENDS MEET */
HS130_F :2.   /*  FLAGS OF HS130 */
HS140 :2.   /*  FINANCIAL BURDEN OF THE TOTAL HOUSING COST */
HS140_F :2.   /*  FLAGS OF HS140 */
HS150 :2.   /*  FINANCIAL BURDEN OF THE REPAYMENT OF DEBTS FROM HIRE PURCHASES OR LOANS */
HS150_F :2.   /*  FLAGS OF HS150 */
HS160 :2.   /*  PROBLEMS WITH THE DWELLING: TOO DARK, NOT ENOUGH LIGHT */
HS160_F :2.   /*  FLAGS OF HS160 */
HS170 :2.   /*  NOISE FROM NEIGHBOURS OR FROM THE STREET */
HS170_F :2.   /*  FLAGS OF HS170 */
HS180 :2.   /*  POLLUTION, GRIME OR OTHER ENVIRONMENTAL PROBLEMS */
HS180_F :2.   /*  FLAGS OF HS180 */
HS190 :2.   /*  CRIME VIOLENCE OR VANDALISM IN THE AREA */
HS190_F :2.   /*  FLAGS OF HS190 */
HY010 :7.   /*  TOTAL HOUSEHOLD GROSS INCOME */
HY010_F :2.   /*  FLAGS OF HY010 */
HY010_I :10.   /*  FLAGS OF HY010 */
HY020 :7.   /*  TOTAL DISPOSABLE HOUSEHOLD INCOME */
HY020_F :2.   /*  FLAGS OF HY020 */
HY020_I :10.   /*  FLAGS OF HY020 */
HY022 :7.   /*  TOTAL DISPOSABLE HOUSEHOLD INCOME BEFORE SOCIAL TRANSFERS OTHER THAN OLD-AGE AND SURVIVOR'S BENEFITS */
HY022_F :2.   /*  FLAGS OF HY022 */
HY022_I :10.   /*  FLAGS OF HY022 */
HY023 :7.   /*  TOTAL DISPOSABLE HOUSEHOLD INCOME BEFORE SOCIAL TRANSFERS OTHER THAN OLD-AGE AND SURVIVORS BENEFITS */
HY023_F :2.   /*  FLAGS OF HY023 */
HY023_I :10.   /*  FLAGS OF HY023 */
HY030N :2.   /*  IMPUTED RENT OF HY030N */
HY030N_F :2.   /*  FLAGS OF HY030N */
HY040N :7.   /*  INCOME FROM RENTAL OF A PROPERTY OR LAND */
HY040N_F :2.   /*  FLAGS OF HY040N */
HY040N_I :10.   /*  FLAGS OF HY040N */
HY050N :7.   /*  FAMILY/CHILDREN RELATED ALLOWANCES */
HY050N_F :2.   /*  FLAGS OF HY050N */
HY050N_I :10.   /*  FLAGS OF HY050N */
HY060N :7.   /*  SOCIAL EXCLUSION NOT ELSEWHERE CLASSIFIED */
HY060N_F :2.   /*  FLAGS OF HY060N */
HY060N_I :10.   /*  FLAGS OF HY060N */
HY070N :7.   /*  HOUSING ALLOWANCES */
HY070N_F :2.   /*  FLAGS OF HY070N */
HY070N_I :10.   /*  FLAGS OF HY070N */
HY080N :7.   /*  REGULAR INTER-HOUSEHOLD CASH TRANSFER RECEIVED */
HY080N_F :2.   /*  FLAGS OF HY080N */
HY080N_I :10.   /*  FLAGS OF HY080N */
HY081N :7.   /*  ALIMONIES RECEIVED (COMPULSORY + VOLUNTARY) */
HY081N_F :2.   /*  FLAGS OF HY081N */
HY081N_I :10.   /*  FLAGS OF HY081N */
HY090N :7.   /*  INTEREST DIVIDENDS PROFIT FROM CAPITAL INVESTMENTS IN UNINCORPORATED BUSINESS */
HY090N_F :2.   /*  FLAGS OF HY090N */
HY090N_I :10.   /*  FLAGS OF HY090N */
HY100N :7.   /*  INTEREST REPAYMENTS ON MORTGAGE OF HY100 */
HY100N_F :2.   /*  FLAGS OF HY100N */
HY100N_I :10.   /*  FLAGS OF HY100N */
HY110N :7.   /*  INCOME RECEIVED BY PEOPLE AGED UNDER 16 */
HY110N_F :2.   /*  FLAGS OF HY110N */
HY110N_I :10.   /*  FLAGS OF HY110N */
HY120N :7.   /*  INCOME RECEIVED BY PEOPLE AGED UNDER 16 */
HY120N_F :2.   /*  FLAGS OF HY120N */
HY120N_I :10.   /*  FLAGS OF HY120N */
HY130N :7.   /*  REGULAR INTER-HOUSEHOLD CASH TRANSFER PAID */
HY130N_F :2.   /*  FLAGS OF HY130N */
HY130N_I :10.   /*  FLAGS OF HY130N */
HY131N :7.   /*  ALIMONIES PAID (COMPULSORY + VOLUNTARY) */
HY131N_F :2.   /*  FLAGS OF HY131N */
HY131N_I :10.   /*  FLAGS OF HY131N */
HY140N :7.   /*  TAX ON INCOME AND SOCIAL CONTRIBUTIONS */
HY140N_F :2.   /*  FLAGS OF HY140N */
HY140N_I :10.   /*  FLAGS OF HY140N */
HY145N :7.   /*  REPAYMENTS/RECEIPTS FOR TAX ADJUSTMENT */
HY145N_F :2.   /*  FLAGS OF HY145N */
HY145N_I :10.   /*  FLAGS OF HY145N */
HY170N :7.   /*  VALUE OF GOODS PRODUCED FOR OWN CONSUMPTION */
HY170N_F :2.   /*  FLAGS OF HY170N */
HY170N_I :10.   /*  FLAGS OF HY170N */
HY030G :6.   /*  IMPUTED RENT OF HY030G */
HY030G_F :2.   /*  FLAGS OF HY030G */
HY040G :7.   /*  INCOME FROM RENTAL OF A PROPERTY OR LAND */
HY040G_F :2.   /*  FLAGS OF HY040G */
HY040G_I :10.   /*  FLAGS OF HY040G */
HY050G :7.   /*  FAMILY/HILDREN RELATED ALLOWANES */
HY050G_F :2.   /*  FLAGS OF HY050G */
HY050G_I :10.   /*  FLAGS OF HY050G */
HY051G :5.   /*  FAMILY/CHILDREN-RELATED ALLOWANCES (CONTRIBUTORY AND MEANS-TESTED) */
HY051G_F :2.   /*  FLAGS OF HY051G */
HY052G :8.   /*  FAMILY/CHILDREN-RELATED ALLOWANCES (CONTRIBUTORY AND NON MEANS-TESTED) */
HY052G_F :2.   /*  FLAGS OF HY052G */
HY053G :5.   /*  FAMILY/CHILDREN-RELATED ALLOWANCES (NON-CONTRIBUTORY AND MEANS-TESTED) */
HY053G_F :2.   /*  FLAGS OF HY053G */
HY054G :2.   /*  FAMILY/CHILDREN-RELATED ALLOWANCES (NON-CONTRIBUTORY AND NON MEANS-TESTED) */
HY054G_F :2.   /*  FLAGS OF HY054G */
HY060G :7.   /*  SOIAL EXLUSION NOT ELSEWHERE LASSIFIED */
HY060G_F :2.   /*  FLAGS OF HY060G */
HY060G_I :10.   /*  FLAGS OF HY060G */
HY061G :12.   /*  SOCIAL EXCLUSION NOT ELSEWHERE CLASSIFIED (CONTRIBUTORY AND MEANS-TESTED) */
HY061G_F :2.   /*  FLAGS OF HY061G */
HY062G :2.   /*  SOCIAL EXCLUSION NOT ELSEWHERE CLASSIFIED (CONTRIBUTORY AND NON MEANS-TESTED) */
HY062G_F :2.   /*  FLAGS OF HY062G */
HY063G :5.   /*  SOCIAL EXCLUSION NOT ELSEWHERE CLASSIFIED (NON-CONTRIBUTORY AND MEANS-TESTED) */
HY063G_F :2.   /*  FLAGS OF HY063G */
HY064G :2.   /*  SOCIAL EXCLUSION NOT ELSEWHERE CLASSIFIED (NON-CONTRIBUTORY AND NON MEANS-TESTED) */
HY064G_F :2.   /*  FLAGS OF HY064G */
HY070G :7.   /*  HOUSING ALLOWANES */
HY070G_F :2.   /*  FLAGS OF HY070G */
HY070G_I :10.   /*  FLAGS OF HY070G */
HY071G :12.   /*  HOUSING ALLOWANCES (CONTRIBUTORY AND MEANS-TESTED) */
HY071G_F :2.   /*  FLAGS OF HY071G */
HY072G :2.   /*  HOUSING ALLOWANCES (CONTRIBUTORY AND NON MEANS-TESTED) */
HY072G_F :2.   /*  FLAGS OF HY072G */
HY073G :4.   /*  HOUSING ALLOWANCES (NON-CONTRIBUTORY AND MEANS-TESTED) */
HY073G_F :2.   /*  FLAGS OF HY073G */
HY074G :2.   /*  HOUSING ALLOWANCES (NON-CONTRIBUTORY AND NON MEANS-TESTED) */
HY074G_F :2.   /*  FLAGS OF HY074G */
HY080G :7.   /*  REGULAR INTER-HOUSEHOLD ASH TRANSFER REEIVED */
HY080G_F :2.   /*  FLAGS OF HY080G */
HY080G_I :10.   /*  FLAGS OF HY080G */
HY081G :7.   /*  ALIMONIES RECEIVED (COMPULSORY + VOLUNTARY) */
HY081G_F :2.   /*  FLAGS OF HY081G */
HY081G_I :10.   /*  FLAGS OF HY081G */
HY090G :7.   /*  INTEREST DIVIDENDS PROFIT FROM CAPITAL INVESTMENTS IN UNINCORPORATED BUSINESS */
HY090G_F :2.   /*  FLAGS OF HY090G */
HY090G_I :10.   /*  FLAGS OF HY090G */
HY100G :7.   /*  INTEREST REPAYMENTS ON MORTGAGE */
HY100G_F :2.   /*  FLAGS OF HY100G */
HY100G_I :10.   /*  FLAGS OF HY100G */
HY110G :7.   /*  INCOME RECEIVED BY PEOPLE AGED UNDER 16 */
HY110G_F :2.   /*  FLAGS OF HY110G */
HY110G_I :10.   /*  FLAGS OF HY110G */
HY120G :7.   /*  INCOME RECEIVED BY PEOPLE AGED UNDER 16 */
HY120G_F :2.   /*  FLAGS OF HY120G */
HY120G_I :10.   /*  FLAGS OF HY120G */
HY130G :7.   /*  REGULAR INTER-HOUSEHOLD CASH TRANSFER PAID */
HY130G_F :2.   /*  FLAGS OF HY130G */
HY130G_I :10.   /*  FLAGS OF HY130G */
HY131G :7.   /*  ALIMONIES PAID (COMPULSORY + VOLUNTARY) */
HY131G_F :2.   /*  FLAGS OF HY131G */
HY131G_I :10.   /*  FLAGS OF HY131G */
HY140G :7.   /*  TAX ON INCOME AND SOCIAL CONTRIBUTIONS OF HY140 */
HY140G_F :2.   /*  FLAGS OF HY140G */
HY140G_I :10.   /*  FLAGS OF HY140G */
HY170G :7.   /*  VALUE OF GOODS PRODUCED FOR OWN CONSUMPTION */
HY170G_F :2.   /*  FLAGS OF HY171G */
HY170G_I :10.   /*  FLAGS OF HY171G */
HD080 :2.   /*  REPLACE WORN-OUT FURNITURE */
HD080_F :2.   /*  FLAGS OF HD080 */
HC040 :2.   /*  AFFORDABILITY OF CHILDCARE SERVICES */
HC040_F :2.   /*  FLAGS OF HC040 */
HC050 :2.   /*  UNMET NEEDS FOR FORMAL CHILDCARE SERVICES */
HC050_F :2.   /*  FLAGS OF HC050 */
HC060 :2.   /*  MAIN REASON FOR NOT MAKING (MORE) USE OF FORMAL CHILDCARE SERVICES */
HC060_F :2.   /*  FLAGS OF HC060 */
HC100 :2.   /*  AFFORDABILITY OF FORMAL EDUCATION */
HC100_F :2.   /*  FLAGS OF HC100 */
HC160 :2.   /*  USE OF HEALTH CARE SERVICES */
HC160_F :2.   /*  FLAGS OF HC160 */
HC170 :2.   /*  PAYMENT FOR HEALTH CARE SERVICES */
HC170_F :2.   /*  FLAGS OF HC170 */
HC180 :2.   /*  AFFORDABILITY OF HEALTH CARE SERVICES */
HC180_F :2.   /*  FLAGS OF HC180 */
HC190 :2.   /*  PRESENCE IN THE HOUSEHOLD OF PEOPLE WHO NEED HELP DUE TO LONG-TERM PHYSICAL OR MENTAL ILL-HEALTH, INFIRMITY OR BECAUSE OF OLD AGE */
HC190_F :2.   /*  FLAGS OF HC190 */
HC200 :2.   /*  PROFESSIONAL HOME CARE RECEIVED */
HC200_F :2.   /*  FLAGS OF HC200 */
HC210 :2.   /*  NUMBER OF HOURS PER WEEK OF PROFESSIONAL HOME CARE RECEIVED */
HC210_F :2.   /*  FLAGS OF HC210 */
HC220 :2.   /*  PAYMENT FOR PROFESSIONAL HOME CARE */
HC220_F :2.   /*  FLAGS OF HC220 */
HC230 :2.   /*  AFFORDABILITY OF PROFESSIONAL HOME CARE SERVICES */
HC230_F :2.   /*  FLAGS OF HC230 */
HC240 :2.   /*  UNMET NEEDS FOR PROFESSIONAL HOME CARE */
HC240_F :2.   /*  FLAGS OF HC240 */
HC250 :2.   /*  MAIN REASON FOR NOT RECEIVING (MORE) PROFESSIONAL HOME CARE SERVICES */
HC250_F :2.   /*  FLAGS OF HC250 */
HX010 :2.   /*  CHANGE RATE */
HX040 :2.   /*  HOUSEHOLD SIZE */
HX050 :3.   /*  EQUIVALISED HOUSEHOLD SIZE */
HX060 :2.   /*  HOUSEHOLD TYPE */
HX070 :2.   /*  TENURE STATUS */
HX080 :2.   /*  POVERTY INDICATOR */
HX090 :17.   /*  EQUIVALISED DISPOSABLE INCOME */
HX120 :2.   /*  OVERCROWDED HOUSEHOLD */
;
LABEL 
HB010 = "YEAR OF THE SURVEY"
HB020 = "COUNTRY OF HB020"
HB030 = "HOUSEHOLD ID"
HB050 = "MONTH OF HOUSEHOLD INTERVIEW"
HB050_F = "FLAGS OF HB050"
HB060 = "YEAR OF HOUSEHOLD INTERVIEW"
HB060_F = "FLAGS OF HB060"
HB070 = "PERSON RESPONDING THE HOUSEHOLD QUESTIONNAIRE"
HB070_F = "FLAGS OF HB070"
HB080 = "PERSON 1 RESPONSIBLE FOR THE ACCOMMODATION"
HB080_F = "FLAGS OF HB080"
HB090 = "PERSON 2 RESPONSIBLE FOR THE ACCOMMODATION"
HB090_F = "FLAGS OF HB090"
HB100 = "NUMBER OF MINUTES TO COMPLETE THE HOUSEHOLD QUESTIONNAIRE"
HB100_F = "FLAGS OF HB100"
HH010 = "DWELLING TYPE"
HH010_F = "FLAGS OF HH010"
HH021 = "TENURE STATUS"
HH021_F = "FLAGS OF HH021"
HH030 = "NUMBER OF ROOMS AVAILABLE TO THE HOUSEHOLD"
HH030_F = "FLAGS OF HH030"
HH031 = "YEAR OF CONTRACT OR PURCHASING OR INSTALLATION"
HH031_F = "FLAGS OF HH031"
HH040 = "LEAKING ROOF DAMP WALLS/FLOORS/FOUNDATION OR ROT IN WINDOW FRAMES OR FLOOR"
HH040_F = "FLAGS OF HH040"
HH050 = "ABILITY TO KEEP HOME ADEQUATELY WARM"
HH050_F = "FLAGS OF HH050"
HH060 = "CURRENT RENT RELATED TO OCCUPIED DWELLING"
HH060_F = "FLAGS OF HH060"
HH061 = "SUBJECTIVE RENT"
HH061_F = "FLAGS OF HH061"
HH070 = "TOTAL HOUSING COST"
HH070_F = "FLAGS OF HH070"
HH071 = "MORTGAGE PRINCIPAL REPAYMENT"
HH071_F = "FLAGS OF HH071"
HH081 = "BATH OR SHOWER IN DWELLING"
HH081_F = "FLAGS OF HH081"
HH091 = "INDOOR FLUSHING TOILET FOR SOLE USE OF HOUSEHOLD"
HH091_F = "FLAGS OF HH091"
HS011 = "ARREARS ON MORTGAGE OR RENT PAYMENTS"
HS011_F = "FLAGS OF HS011"
HS021 = "ARREARS ON UTILITY BILLS"
HS021_F = "FLAGS OF HS021"
HS031 = "ARREARS ON HIRE PURCHASE INSTALMENTS OR OTHER LOAN PAYMENTS"
HS031_F = "FLAGS OF HS031"
HS040 = "CAPACITY TO AFFORD PAYING FOR ONE WEEK ANNUAL HOLIDAY AWAY FROM HOME"
HS040_F = "FLAGS OF HS040"
HS050 = "CAPACITY TO AFFORD A MEAL WITH MEAT CHICKEN FISH (OR VEGETARIAN EQUIVALENT) EVERY SECOND DAY"
HS050_F = "FLAGS OF HS050"
HS060 = "CAPACITY TO FACE UNEXPECTED FINALCIAL EXPENSES"
HS060_F = "FLAGS OF HS060"
HS070 = "DO YOU HAVE A TELEPHONE (INCLUDING MOBILE PHONE)?"
HS070_F = "FLAGS OF HS070"
HS080 = "DO YOU HAVE A COLOUR TV?"
HS080_F = "FLAGS OF HS080"
HS090 = "DO YOU HAVE A COMPUTER?"
HS090_F = "FLAGS OF HS090"
HS100 = "DO YOU HAVE A COMPUTER?"
HS100_F = "FLAGS OF HS100"
HS110 = "DO YOU HAVE A CAR?"
HS110_F = "FLAGS OF HS110"
HS120 = "ABILITY TO MAKE ENDS MEET"
HS120_F = "FLAGS OF HS120"
HS130 = "LOWEST MONTHLY INCOME TO MAKE ENDS MEET"
HS130_F = "FLAGS OF HS130"
HS140 = "FINANCIAL BURDEN OF THE TOTAL HOUSING COST"
HS140_F = "FLAGS OF HS140"
HS150 = "FINANCIAL BURDEN OF THE REPAYMENT OF DEBTS FROM HIRE PURCHASES OR LOANS"
HS150_F = "FLAGS OF HS150"
HS160 = "PROBLEMS WITH THE DWELLING: TOO DARK, NOT ENOUGH LIGHT"
HS160_F = "FLAGS OF HS160"
HS170 = "NOISE FROM NEIGHBOURS OR FROM THE STREET"
HS170_F = "FLAGS OF HS170"
HS180 = "POLLUTION, GRIME OR OTHER ENVIRONMENTAL PROBLEMS"
HS180_F = "FLAGS OF HS180"
HS190 = "CRIME VIOLENCE OR VANDALISM IN THE AREA"
HS190_F = "FLAGS OF HS190"
HY010 = "TOTAL HOUSEHOLD GROSS INCOME"
HY010_F = "FLAGS OF HY010"
HY010_I = "FLAGS OF HY010"
HY020 = "TOTAL DISPOSABLE HOUSEHOLD INCOME"
HY020_F = "FLAGS OF HY020"
HY020_I = "FLAGS OF HY020"
HY022 = "TOTAL DISPOSABLE HOUSEHOLD INCOME BEFORE SOCIAL TRANSFERS OTHER THAN OLD-AGE AND SURVIVOR'S BENEFITS"
HY022_F = "FLAGS OF HY022"
HY022_I = "FLAGS OF HY022"
HY023 = "TOTAL DISPOSABLE HOUSEHOLD INCOME BEFORE SOCIAL TRANSFERS OTHER THAN OLD-AGE AND SURVIVORS BENEFITS"
HY023_F = "FLAGS OF HY023"
HY023_I = "FLAGS OF HY023"
HY030N = "IMPUTED RENT OF HY030N"
HY030N_F = "FLAGS OF HY030N"
HY040N = "INCOME FROM RENTAL OF A PROPERTY OR LAND"
HY040N_F = "FLAGS OF HY040N"
HY040N_I = "FLAGS OF HY040N"
HY050N = "FAMILY/CHILDREN RELATED ALLOWANCES"
HY050N_F = "FLAGS OF HY050N"
HY050N_I = "FLAGS OF HY050N"
HY060N = "SOCIAL EXCLUSION NOT ELSEWHERE CLASSIFIED"
HY060N_F = "FLAGS OF HY060N"
HY060N_I = "FLAGS OF HY060N"
HY070N = "HOUSING ALLOWANCES"
HY070N_F = "FLAGS OF HY070N"
HY070N_I = "FLAGS OF HY070N"
HY080N = "REGULAR INTER-HOUSEHOLD CASH TRANSFER RECEIVED"
HY080N_F = "FLAGS OF HY080N"
HY080N_I = "FLAGS OF HY080N"
HY081N = "ALIMONIES RECEIVED (COMPULSORY + VOLUNTARY)"
HY081N_F = "FLAGS OF HY081N"
HY081N_I = "FLAGS OF HY081N"
HY090N = "INTEREST DIVIDENDS PROFIT FROM CAPITAL INVESTMENTS IN UNINCORPORATED BUSINESS"
HY090N_F = "FLAGS OF HY090N"
HY090N_I = "FLAGS OF HY090N"
HY100N = "INTEREST REPAYMENTS ON MORTGAGE OF HY100"
HY100N_F = "FLAGS OF HY100N"
HY100N_I = "FLAGS OF HY100N"
HY110N = "INCOME RECEIVED BY PEOPLE AGED UNDER 16"
HY110N_F = "FLAGS OF HY110N"
HY110N_I = "FLAGS OF HY110N"
HY120N = "INCOME RECEIVED BY PEOPLE AGED UNDER 16"
HY120N_F = "FLAGS OF HY120N"
HY120N_I = "FLAGS OF HY120N"
HY130N = "REGULAR INTER-HOUSEHOLD CASH TRANSFER PAID"
HY130N_F = "FLAGS OF HY130N"
HY130N_I = "FLAGS OF HY130N"
HY131N = "ALIMONIES PAID (COMPULSORY + VOLUNTARY)"
HY131N_F = "FLAGS OF HY131N"
HY131N_I = "FLAGS OF HY131N"
HY140N = "TAX ON INCOME AND SOCIAL CONTRIBUTIONS"
HY140N_F = "FLAGS OF HY140N"
HY140N_I = "FLAGS OF HY140N"
HY145N = "REPAYMENTS/RECEIPTS FOR TAX ADJUSTMENT"
HY145N_F = "FLAGS OF HY145N"
HY145N_I = "FLAGS OF HY145N"
HY170N = "VALUE OF GOODS PRODUCED FOR OWN CONSUMPTION"
HY170N_F = "FLAGS OF HY170N"
HY170N_I = "FLAGS OF HY170N"
HY030G = "IMPUTED RENT OF HY030G"
HY030G_F = "FLAGS OF HY030G"
HY040G = "INCOME FROM RENTAL OF A PROPERTY OR LAND"
HY040G_F = "FLAGS OF HY040G"
HY040G_I = "FLAGS OF HY040G"
HY050G = "FAMILY/HILDREN RELATED ALLOWANES"
HY050G_F = "FLAGS OF HY050G"
HY050G_I = "FLAGS OF HY050G"
HY051G = "FAMILY/CHILDREN-RELATED ALLOWANCES (CONTRIBUTORY AND MEANS-TESTED)"
HY051G_F = "FLAGS OF HY051G"
HY052G = "FAMILY/CHILDREN-RELATED ALLOWANCES (CONTRIBUTORY AND NON MEANS-TESTED)"
HY052G_F = "FLAGS OF HY052G"
HY053G = "FAMILY/CHILDREN-RELATED ALLOWANCES (NON-CONTRIBUTORY AND MEANS-TESTED)"
HY053G_F = "FLAGS OF HY053G"
HY054G = "FAMILY/CHILDREN-RELATED ALLOWANCES (NON-CONTRIBUTORY AND NON MEANS-TESTED)"
HY054G_F = "FLAGS OF HY054G"
HY060G = "SOIAL EXLUSION NOT ELSEWHERE LASSIFIED"
HY060G_F = "FLAGS OF HY060G"
HY060G_I = "FLAGS OF HY060G"
HY061G = "SOCIAL EXCLUSION NOT ELSEWHERE CLASSIFIED (CONTRIBUTORY AND MEANS-TESTED)"
HY061G_F = "FLAGS OF HY061G"
HY062G = "SOCIAL EXCLUSION NOT ELSEWHERE CLASSIFIED (CONTRIBUTORY AND NON MEANS-TESTED)"
HY062G_F = "FLAGS OF HY062G"
HY063G = "SOCIAL EXCLUSION NOT ELSEWHERE CLASSIFIED (NON-CONTRIBUTORY AND MEANS-TESTED)"
HY063G_F = "FLAGS OF HY063G"
HY064G = "SOCIAL EXCLUSION NOT ELSEWHERE CLASSIFIED (NON-CONTRIBUTORY AND NON MEANS-TESTED)"
HY064G_F = "FLAGS OF HY064G"
HY070G = "HOUSING ALLOWANES"
HY070G_F = "FLAGS OF HY070G"
HY070G_I = "FLAGS OF HY070G"
HY071G = "HOUSING ALLOWANCES (CONTRIBUTORY AND MEANS-TESTED)"
HY071G_F = "FLAGS OF HY071G"
HY072G = "HOUSING ALLOWANCES (CONTRIBUTORY AND NON MEANS-TESTED)"
HY072G_F = "FLAGS OF HY072G"
HY073G = "HOUSING ALLOWANCES (NON-CONTRIBUTORY AND MEANS-TESTED)"
HY073G_F = "FLAGS OF HY073G"
HY074G = "HOUSING ALLOWANCES (NON-CONTRIBUTORY AND NON MEANS-TESTED)"
HY074G_F = "FLAGS OF HY074G"
HY080G = "REGULAR INTER-HOUSEHOLD ASH TRANSFER REEIVED"
HY080G_F = "FLAGS OF HY080G"
HY080G_I = "FLAGS OF HY080G"
HY081G = "ALIMONIES RECEIVED (COMPULSORY + VOLUNTARY)"
HY081G_F = "FLAGS OF HY081G"
HY081G_I = "FLAGS OF HY081G"
HY090G = "INTEREST DIVIDENDS PROFIT FROM CAPITAL INVESTMENTS IN UNINCORPORATED BUSINESS"
HY090G_F = "FLAGS OF HY090G"
HY090G_I = "FLAGS OF HY090G"
HY100G = "INTEREST REPAYMENTS ON MORTGAGE"
HY100G_F = "FLAGS OF HY100G"
HY100G_I = "FLAGS OF HY100G"
HY110G = "INCOME RECEIVED BY PEOPLE AGED UNDER 16"
HY110G_F = "FLAGS OF HY110G"
HY110G_I = "FLAGS OF HY110G"
HY120G = "INCOME RECEIVED BY PEOPLE AGED UNDER 16"
HY120G_F = "FLAGS OF HY120G"
HY120G_I = "FLAGS OF HY120G"
HY130G = "REGULAR INTER-HOUSEHOLD CASH TRANSFER PAID"
HY130G_F = "FLAGS OF HY130G"
HY130G_I = "FLAGS OF HY130G"
HY131G = "ALIMONIES PAID (COMPULSORY + VOLUNTARY)"
HY131G_F = "FLAGS OF HY131G"
HY131G_I = "FLAGS OF HY131G"
HY140G = "TAX ON INCOME AND SOCIAL CONTRIBUTIONS OF HY140"
HY140G_F = "FLAGS OF HY140G"
HY140G_I = "FLAGS OF HY140G"
HY170G = "VALUE OF GOODS PRODUCED FOR OWN CONSUMPTION"
HY170G_F = "FLAGS OF HY171G"
HY170G_I = "FLAGS OF HY171G"
HD080 = "REPLACE WORN-OUT FURNITURE"
HD080_F = "FLAGS OF HD080"
HC040 = "AFFORDABILITY OF CHILDCARE SERVICES"
HC040_F = "FLAGS OF HC040"
HC050 = "UNMET NEEDS FOR FORMAL CHILDCARE SERVICES"
HC050_F = "FLAGS OF HC050"
HC060 = "MAIN REASON FOR NOT MAKING (MORE) USE OF FORMAL CHILDCARE SERVICES"
HC060_F = "FLAGS OF HC060"
HC100 = "AFFORDABILITY OF FORMAL EDUCATION"
HC100_F = "FLAGS OF HC100"
HC160 = "USE OF HEALTH CARE SERVICES"
HC160_F = "FLAGS OF HC160"
HC170 = "PAYMENT FOR HEALTH CARE SERVICES"
HC170_F = "FLAGS OF HC170"
HC180 = "AFFORDABILITY OF HEALTH CARE SERVICES"
HC180_F = "FLAGS OF HC180"
HC190 = "PRESENCE IN THE HOUSEHOLD OF PEOPLE WHO NEED HELP DUE TO LONG-TERM PHYSICAL OR MENTAL ILL-HEALTH, INFIRMITY OR BECAUSE OF OLD AGE"
HC190_F = "FLAGS OF HC190"
HC200 = "PROFESSIONAL HOME CARE RECEIVED"
HC200_F = "FLAGS OF HC200"
HC210 = "NUMBER OF HOURS PER WEEK OF PROFESSIONAL HOME CARE RECEIVED"
HC210_F = "FLAGS OF HC210"
HC220 = "PAYMENT FOR PROFESSIONAL HOME CARE"
HC220_F = "FLAGS OF HC220"
HC230 = "AFFORDABILITY OF PROFESSIONAL HOME CARE SERVICES"
HC230_F = "FLAGS OF HC230"
HC240 = "UNMET NEEDS FOR PROFESSIONAL HOME CARE"
HC240_F = "FLAGS OF HC240"
HC250 = "MAIN REASON FOR NOT RECEIVING (MORE) PROFESSIONAL HOME CARE SERVICES"
HC250_F = "FLAGS OF HC250"
HX010 = "CHANGE RATE"
HX040 = "HOUSEHOLD SIZE"
HX050 = "EQUIVALISED HOUSEHOLD SIZE"
HX060 = "HOUSEHOLD TYPE"
HX070 = "TENURE STATUS"
HX080 = "POVERTY INDICATOR"
HX090 = "EQUIVALISED DISPOSABLE INCOME"
HX120 = "OVERCROWDED HOUSEHOLD"
;
RUN;
PROC FORMAT;
VALUE $HB01F /* HB020 */
"AT" = "sterreich"
"BE" = "Belgique"
"BG" = "Bulgaria"
"CH" = "Switzerland"
"CY" = "Cyprus"
"CZ" = "Czech"
"DE" = "Deutschland"
"DK" = "Danmark"
"EE" = "Estonia"
"ES" = "Espaa"
"FI" = "Suomi"
"FR" = "France"
"GR" = "Ellda"
"HU" = "Hungary"
"IE" = "Ireland"
"IS" = "Iceland"
"IT" = "Italia"
"LT" = "Lithuania"
"LU" = "Luxembourg"
"LV" = "Latvia"
"MT" = "Malta"
"NL" = "Nederland"
"NO" = "Norway"
"PL" = "Poland"
"PT" = "Portugal"
"RO" = "Romania"
"SE" = "Sverige"
"SI" = "Slovenia"
"SK" = "Slovak/republic"
"UK" = "United"
;
VALUE HB03F /* HB050 */
1= "January-March"
2= "April-June"
3= "July-September"
4= "October-December"
;
VALUE HB04F /* HB050_F */
1= "filled"
-1= "missing"
;
VALUE HB06F /* HB060_F */
1= "filled"
;
VALUE HB08F /* HB070_F */
1= "filled"
-1= "missing"
;
VALUE HB010F /* HB080_F */
1= "filled"
-1= "missing"
;
VALUE HB012F /* HB090_F */
1= "filled"
-1= "missing"
-2= "only  na (no second responsible)"
;
VALUE HB114F /* HB100_F */
1= "filled"
-1= "missing"
;
VALUE HH015F /* HH010 */
1= "detached house"
2= "semi-detached or terraced house"
3= "apartment or flat in a building with less than 10 dwellings"
4= "apartment or flat in a building with 10 or more dwellings"
;
VALUE HH016F /* HH010_F */
1= "filled"
-1= "missing"
;
VALUE HH017F /* HH021 */
1= "Outright owner"
2= "Owner paying mortgage"
3= "Tenant or subtenant paying rent at prevailing or market rate"
4= "Accommodation is rented at a reduced rate (lower price that the market price"
5= "Accommodation is provided free"
;
VALUE HH018F /* HH021_F */
1= "filled"
-1= "missing"
-5= "missing value of HH021 because HH020 is still used"
;
VALUE HH019F /* HH030 */
1= "1 room"
2= "2 rooms"
3= "3 rooms"
4= "4 rooms"
5= "5 rooms"
6= "6 rooms"
7= "7 rooms"
8= "8 rooms"
9= "9 rooms"
10= "10 or more rooms"
;
VALUE HH020F /* HH030_F */
1= "filled"
-1= "missing"
;
VALUE HH022F /* HH031_F */
1= "filled"
-1= "missing"
-2= "n.a. (MS using objective national methods to calculate imputed rent)"
;
VALUE HH023F /* HH040 */
1= "yes"
2= "no"
;
VALUE HH024F /* HH040_F */
1= "filled"
-1= "missing"
;
VALUE HH025F /* HH050 */
1= "yes"
2= "no"
;
VALUE HH026F /* HH050_F */
1= "filled"
-1= "missing"
;
VALUE HH028F /* HH060_F */
1= "filled"
-1= "missing"
-2= "na (HH020 not = 2 or 3)"
;
VALUE HH030F /* HH061_F */
1= "filled"
-1= "missing"
-2= "na (HH020 not = 1 or 3 or 4) or (MS do not use subjective method to calculate imputed rent)"
;
VALUE HH032F /* HH070_F */
1= "filled"
-1= "missing"
;
VALUE HH034F /* HH071_F */
1= "filled"
-1= "missing"
-2= "Not applicable"
;
VALUE HH035F /* HH081 */
1= "yes, for sole use of the household"
2= "yes, shared"
3= "no"
;
VALUE HH036F /* HH081_F */
1= "filled"
-1= "missing"
;
VALUE HH037F /* HH091 */
1= "yes, for sole use of the household"
2= "yes, shared"
3= "no"
;
VALUE HH038F /* HH091_F */
1= "filled"
-1= "missing"
;
VALUE HS039F /* HS011 */
1= "yes, once"
2= "yes, twice or more"
3= "no"
;
VALUE HS040F /* HS011_F */
1= "filled"
-1= "missing"
-2= "not applicable (outright owner or rent free during the last twelve months)"
-5= "missing value of HS011 because HS010 is still used"
;
VALUE HS041F /* HS021 */
1= "yes, once"
2= "yes, twice or more"
3= "no"
;
VALUE HS042F /* HS021_F */
1= "filled"
-1= "missing"
-2= "na (no utility bills)"
-5= "missing value of HS021 because HS020 is still used"
;
VALUE HS043F /* HS031 */
1= "yes, once"
2= "yes, twice or more"
3= "no"
;
VALUE HS044F /* HS031_F */
1= "filled"
-1= "missing"
-2= "na (no hire purchase instalments and no other loan payments)"
-5= "missing value of HS031 because HS030 is still used"
;
VALUE HS045F /* HS040 */
1= "yes"
2= "no"
;
VALUE HS046F /* HS040_F */
1= "filled"
-1= "missing"
;
VALUE HS047F /* HS050 */
1= "yes"
2= "no"
;
VALUE HS048F /* HS050_F */
1= "filled"
-1= "missing"
;
VALUE HS049F /* HS060 */
1= "yes"
2= "no"
;
VALUE HS050F /* HS060_F */
1= "filled"
-1= "missing"
;
VALUE HS051F /* HS070 */
1= "yes"
2= "no - cannot afford"
3= "no - other reason"
;
VALUE HS052F /* HS070_F */
1= "filled"
-1= "missing"
;
VALUE HS053F /* HS080 */
1= "yes"
2= "no - cannot afford"
3= "no - other reason"
;
VALUE HS054F /* HS080_F */
1= "filled"
-1= "missing"
;
VALUE HS055F /* HS090 */
1= "yes"
2= "no - cannot afford"
3= "no - other reason"
;
VALUE HS056F /* HS090_F */
1= "filled"
-1= "missing"
;
VALUE HS157F /* HS100 */
1= "yes"
2= "no - cannot afford"
3= "no - other reason"
;
VALUE HS158F /* HS100_F */
1= "filled"
-1= "missing"
;
VALUE HS159F /* HS110 */
1= "yes"
2= "no - cannot afford"
3= "no - other reason"
;
VALUE HS160F /* HS110_F */
1= "filled"
-1= "missing"
;
VALUE HS161F /* HS120 */
1= "with great difficulty"
2= "with difficulty"
3= "with some difficulty"
4= "fairly easily"
5= "easily"
6= "very easily"
;
VALUE HS162F /* HS120_F */
1= "filled"
-1= "missing"
;
VALUE HS164F /* HS130_F */
1= "filled"
-1= "missing"
;
VALUE HS165F /* HS140 */
1= "A heavy burden"
2= "Somewhat a burden"
3= "not burden at all"
;
VALUE HS166F /* HS140_F */
1= "filled"
-1= "missing"
;
VALUE HS167F /* HS150 */
1= "Repayment is a heavy burden"
2= "Repayment is somewhat a burden"
3= "Repayment is not a burden at all"
;
VALUE HS168F /* HS150_F */
1= "filled"
-1= "missing"
-2= "not applicable ( no repayment of debts)"
;
VALUE HS169F /* HS160 */
1= "yes"
2= "no"
;
VALUE HS170F /* HS160_F */
1= "filled"
-1= "missing"
;
VALUE HS171F /* HS170 */
1= "yes"
2= "no"
;
VALUE HS172F /* HS170_F */
1= "filled"
-1= "missing"
;
VALUE HS173F /* HS180 */
1= "yes"
2= "no"
;
VALUE HS174F /* HS180_F */
1= "filled"
-1= "missing"
;
VALUE HS175F /* HS190 */
1= "yes"
2= "no"
;
VALUE HS176F /* HS190_F */
1= "filled"
-1= "missing"
;
VALUE HD0204F /* HD080 */
1= "Yes"
2= "No - household cannot afford it"
3= "No - other reason"
;
VALUE HD0205F /* HD080_F */
1= "Filled"
-1= "Missing"
-7= "Not applicable: HB010 < 2013"
;
VALUE HC0206F /* HC040 */
1= "with great difficulty"
2= "with difficulty"
3= "with some difficulty"
4= "fairly easily"
5= "easily"
6= "very easily"
;
VALUE HC0207F /* HC040_F */
1= "filled"
-1= "missing"
-4= "no costs of childcare in the household"
-5= "no children aged 0-12 in the household"
-7= "not applicable HB010 not = 2016"
;
VALUE HC0208F /* HC050 */
1= "yes"
2= "no"
;
VALUE HC0209F /* HC050_F */
1= "filled"
-1= "missing"
-5= "no children aged 0-12 in the household"
-7= "not applicable HB010 not = 2016"
;
VALUE HC0210F /* HC060 */
1= "cannot afford it"
2= "no places available"
3= "places available but not nearby"
4= "places available but opening hours not suitable"
5= "places available but the quality of the services available not"
6= "other reasons"
;
VALUE HC0211F /* HC060_F */
1= "filled"
-1= "missing"
-2= "not applicable (HC050 = 2)"
-5= "no children aged 0-12 in the household"
-7= "not applicable HB010 not = 2016"
;
VALUE HC1212F /* HC100 */
1= "with great difficulty"
2= "with difficulty"
3= "with some difficulty"
4= "fairly easily"
5= "easily"
6= "very easily"
;
VALUE HC1213F /* HC100_F */
1= "filled"
-1= "missing"
-4= "no costs of formal education in the household"
-5= "nobody in the household follows formal education"
-7= "not applicable HB010 not = 2016"
;
VALUE HC1214F /* HC160 */
1= "yes"
2= "no"
;
VALUE HC1215F /* HC160_F */
1= "filled"
-1= "missing"
-7= "not applicable HB010 not = 2016"
;
VALUE HC1216F /* HC170 */
1= "yes"
2= "no"
;
VALUE HC1217F /* HC170_F */
1= "filled"
-1= "missing"
-2= "not applicable (HC160=2)"
-7= "not applicable HB010 not = 2016"
;
VALUE HC1218F /* HC180 */
1= "with great difficulty"
2= "with difficulty"
3= "with some difficulty"
4= "fairly easily"
5= "easily"
6= "very easily"
;
VALUE HC1219F /* HC180_F */
1= "filled"
-1= "missing"
-2= "not applicable (HC160=2)"
-7= "not applicable HB010 not = 2016"
;
VALUE HC1220F /* HC190 */
1= "yes"
2= "no"
;
VALUE HC1221F /* HC190_F */
1= "filled"
-1= "missing"
-4= "no costs of formal education in the household"
-5= "nobody in the household follows formal education"
-7= "not applicable HB010 not = 2016"
;
VALUE HC2222F /* HC200 */
1= "yes"
2= "no"
;
VALUE HC2223F /* HC200_F */
1= "filled"
-1= "missing"
-2= "not applicable (HC190=2)"
-7= "not applicable HB010 not = 2016"
;
VALUE HC2224F /* HC210 */
1= "less than 10 hours per week"
2= "at least 10 but less than 20 hours per week"
3= "20 hours per week or more"
;
VALUE HC2225F /* HC210_F */
1= "filled"
-1= "missing"
-2= "not applicable (HC190=2 or HC200=2)"
-7= "not applicable HB010 not = 2016"
;
VALUE HC2226F /* HC220 */
1= "yes"
2= "no"
;
VALUE HC2227F /* HC220_F */
1= "filled"
-1= "missing"
-2= "not applicable (HC190=2 or HC240=2)"
-7= "not applicable HB010 not = 2016"
;
VALUE HC2228F /* HC230 */
1= "with great difficulty"
2= "with difficulty"
3= "with some difficulty"
4= "fairly easily"
5= "easily"
6= "very easily"
;
VALUE HC2229F /* HC230_F */
1= "filled"
-1= "missing"
-2= "not applicable (HC190=2 or HC200=2 or HC220=2)"
-7= "not applicable HB010 not = 2016"
;
VALUE HC2230F /* HC240 */
1= "yes"
2= "no"
;
VALUE HC2231F /* HC240_F */
1= "filled"
-1= "missing"
-2= "not applicable (HC190=2)"
-7= "not applicable HB010 not = 2016"
;
VALUE HC2232F /* HC250 */
1= "cannot afford it"
2= "refused by person needing such services"
3= "no such care services available"
4= "quality of the services available not satisfactory"
5= "other reasons"
;
VALUE HC2233F /* HC250_F */
1= "filled"
-1= "missing"
-2= "not applicable (HC190=2 or HC240=2)"
-7= "not applicable HB010 not = 2016"
;
VALUE HX0237F /* HX060 */
5= "One person household"
6= "2 adults, no dependent children, both adults under 65 years"
7= "2 adults, no dependent children, at least one adult 65 years or more"
8= "Other households without dependent children"
9= "Single parent household, one or more dependent children"
10= "2 adults, one dependent child"
11= "2 adults, two dependent children"
12= "2 adults, three or more dependent children"
13= "Other households with dependent children"
16= "Other (these household are excluded from Laeken indicators calculation)"
;
VALUE HX0238F /* HX070 */
1= "owner"
2= "tenant"
;
VALUE HX0239F /* HX080 */
0= "not at risk of poverty"
1= "at risk of poverty"
;
VALUE HX1241F /* HX120 */
.= "not applicable"
0= "not overcrowded"
1= "overcrowded"
;
format HB020 $HB01F.;
format HB050 HB03F.;
format HB050_F HB04F.;
format HB060_F HB06F.;
format HB070_F HB08F.;
format HB080_F HB010F.;
format HB090_F HB012F.;
format HB100_F HB114F.;
format HH010 HH015F.;
format HH010_F HH016F.;
format HH021 HH017F.;
format HH021_F HH018F.;
format HH030 HH019F.;
format HH030_F HH020F.;
format HH031_F HH022F.;
format HH040 HH023F.;
format HH040_F HH024F.;
format HH050 HH025F.;
format HH050_F HH026F.;
format HH060_F HH028F.;
format HH061_F HH030F.;
format HH070_F HH032F.;
format HH071_F HH034F.;
format HH081 HH035F.;
format HH081_F HH036F.;
format HH091 HH037F.;
format HH091_F HH038F.;
format HS011 HS039F.;
format HS011_F HS040F.;
format HS021 HS041F.;
format HS021_F HS042F.;
format HS031 HS043F.;
format HS031_F HS044F.;
format HS040 HS045F.;
format HS040_F HS046F.;
format HS050 HS047F.;
format HS050_F HS048F.;
format HS060 HS049F.;
format HS060_F HS050F.;
format HS070 HS051F.;
format HS070_F HS052F.;
format HS080 HS053F.;
format HS080_F HS054F.;
format HS090 HS055F.;
format HS090_F HS056F.;
format HS100 HS157F.;
format HS100_F HS158F.;
format HS110 HS159F.;
format HS110_F HS160F.;
format HS120 HS161F.;
format HS120_F HS162F.;
format HS130_F HS164F.;
format HS140 HS165F.;
format HS140_F HS166F.;
format HS150 HS167F.;
format HS150_F HS168F.;
format HS160 HS169F.;
format HS160_F HS170F.;
format HS170 HS171F.;
format HS170_F HS172F.;
format HS180 HS173F.;
format HS180_F HS174F.;
format HS190 HS175F.;
format HS190_F HS176F.;
format HD080 HD0204F.;
format HD080_F HD0205F.;
format HC040 HC0206F.;
format HC040_F HC0207F.;
format HC050 HC0208F.;
format HC050_F HC0209F.;
format HC060 HC0210F.;
format HC060_F HC0211F.;
format HC100 HC1212F.;
format HC100_F HC1213F.;
format HC160 HC1214F.;
format HC160_F HC1215F.;
format HC170 HC1216F.;
format HC170_F HC1217F.;
format HC180 HC1218F.;
format HC180_F HC1219F.;
format HC190 HC1220F.;
format HC190_F HC1221F.;
format HC200 HC2222F.;
format HC200_F HC2223F.;
format HC210 HC2224F.;
format HC210_F HC2225F.;
format HC220 HC2226F.;
format HC220_F HC2227F.;
format HC230 HC2228F.;
format HC230_F HC2229F.;
format HC240 HC2230F.;
format HC240_F HC2231F.;
format HC250 HC2232F.;
format HC250_F HC2233F.;
format HX060 HX0237F.;
format HX070 HX0238F.;
format HX080 HX0239F.;
format HX120 HX1241F.;
RUN;
