#LIMITAZIONE DELLA RESPONSABILITA'. 
#Il software  fornito "cos com'", senza garanzie di  sorta.
setwd(choose.dir(default = "", caption = "WHERE ARE MICRODATA?"))
direttorio = getwd()
fileInput = paste (direttorio, "/ISTAT_MFR_EU-SILC_Microdati_2016_HOUSEHOLD_DATA_(H-FILE)_Cross-Sectional_ESEMPIO_STRUTTURA_FILE.txt", sep="")
DF_EU-SILC_A2016_HOUSEHOLD_DATA<- read.delim2 (fileInput,  header=T, sep="^",  quote="",  na.strings = ".")
attr(DF_EU-SILC_A2016_HOUSEHOLD_DATA, "label") <- c(
"YEAR OF THE SURVEY",
"COUNTRY OF HB020",
"HOUSEHOLD ID",
"MONTH OF HOUSEHOLD INTERVIEW",
"FLAGS OF HB050",
"YEAR OF HOUSEHOLD INTERVIEW",
"FLAGS OF HB060",
"PERSON RESPONDING THE HOUSEHOLD QUESTIONNAIRE",
"FLAGS OF HB070",
"PERSON 1 RESPONSIBLE FOR THE ACCOMMODATION",
"FLAGS OF HB080",
"PERSON 2 RESPONSIBLE FOR THE ACCOMMODATION",
"FLAGS OF HB090",
"NUMBER OF MINUTES TO COMPLETE THE HOUSEHOLD QUESTIONNAIRE",
"FLAGS OF HB100",
"DWELLING TYPE",
"FLAGS OF HH010",
"TENURE STATUS",
"FLAGS OF HH021",
"NUMBER OF ROOMS AVAILABLE TO THE HOUSEHOLD",
"FLAGS OF HH030",
"YEAR OF CONTRACT OR PURCHASING OR INSTALLATION",
"FLAGS OF HH031",
"LEAKING ROOF DAMP WALLS/FLOORS/FOUNDATION OR ROT IN WINDOW FRAMES OR FLOOR",
"FLAGS OF HH040",
"ABILITY TO KEEP HOME ADEQUATELY WARM",
"FLAGS OF HH050",
"CURRENT RENT RELATED TO OCCUPIED DWELLING",
"FLAGS OF HH060",
"SUBJECTIVE RENT",
"FLAGS OF HH061",
"TOTAL HOUSING COST",
"FLAGS OF HH070",
"MORTGAGE PRINCIPAL REPAYMENT",
"FLAGS OF HH071",
"BATH OR SHOWER IN DWELLING",
"FLAGS OF HH081",
"INDOOR FLUSHING TOILET FOR SOLE USE OF HOUSEHOLD",
"FLAGS OF HH091",
"ARREARS ON MORTGAGE OR RENT PAYMENTS",
"FLAGS OF HS011",
"ARREARS ON UTILITY BILLS",
"FLAGS OF HS021",
"ARREARS ON HIRE PURCHASE INSTALMENTS OR OTHER LOAN PAYMENTS",
"FLAGS OF HS031",
"CAPACITY TO AFFORD PAYING FOR ONE WEEK ANNUAL HOLIDAY AWAY FROM HOME",
"FLAGS OF HS040",
"CAPACITY TO AFFORD A MEAL WITH MEAT CHICKEN FISH (OR VEGETARIAN EQUIVALENT) EVERY SECOND DAY",
"FLAGS OF HS050",
"CAPACITY TO FACE UNEXPECTED FINALCIAL EXPENSES",
"FLAGS OF HS060",
"DO YOU HAVE A TELEPHONE (INCLUDING MOBILE PHONE)?",
"FLAGS OF HS070",
"DO YOU HAVE A COLOUR TV?",
"FLAGS OF HS080",
"DO YOU HAVE A COMPUTER?",
"FLAGS OF HS090",
"DO YOU HAVE A COMPUTER?",
"FLAGS OF HS100",
"DO YOU HAVE A CAR?",
"FLAGS OF HS110",
"ABILITY TO MAKE ENDS MEET",
"FLAGS OF HS120",
"LOWEST MONTHLY INCOME TO MAKE ENDS MEET",
"FLAGS OF HS130",
"FINANCIAL BURDEN OF THE TOTAL HOUSING COST",
"FLAGS OF HS140",
"FINANCIAL BURDEN OF THE REPAYMENT OF DEBTS FROM HIRE PURCHASES OR LOANS",
"FLAGS OF HS150",
"PROBLEMS WITH THE DWELLING: TOO DARK, NOT ENOUGH LIGHT",
"FLAGS OF HS160",
"NOISE FROM NEIGHBOURS OR FROM THE STREET",
"FLAGS OF HS170",
"POLLUTION, GRIME OR OTHER ENVIRONMENTAL PROBLEMS",
"FLAGS OF HS180",
"CRIME VIOLENCE OR VANDALISM IN THE AREA",
"FLAGS OF HS190",
"TOTAL HOUSEHOLD GROSS INCOME",
"FLAGS OF HY010",
"FLAGS OF HY010",
"TOTAL DISPOSABLE HOUSEHOLD INCOME",
"FLAGS OF HY020",
"FLAGS OF HY020",
"TOTAL DISPOSABLE HOUSEHOLD INCOME BEFORE SOCIAL TRANSFERS OTHER THAN OLD-AGE AND SURVIVOR'S BENEFITS",
"FLAGS OF HY022",
"FLAGS OF HY022",
"TOTAL DISPOSABLE HOUSEHOLD INCOME BEFORE SOCIAL TRANSFERS OTHER THAN OLD-AGE AND SURVIVORS BENEFITS",
"FLAGS OF HY023",
"FLAGS OF HY023",
"IMPUTED RENT OF HY030N",
"FLAGS OF HY030N",
"INCOME FROM RENTAL OF A PROPERTY OR LAND",
"FLAGS OF HY040N",
"FLAGS OF HY040N",
"FAMILY/CHILDREN RELATED ALLOWANCES",
"FLAGS OF HY050N",
"FLAGS OF HY050N",
"SOCIAL EXCLUSION NOT ELSEWHERE CLASSIFIED",
"FLAGS OF HY060N",
"FLAGS OF HY060N",
"HOUSING ALLOWANCES",
"FLAGS OF HY070N",
"FLAGS OF HY070N",
"REGULAR INTER-HOUSEHOLD CASH TRANSFER RECEIVED",
"FLAGS OF HY080N",
"FLAGS OF HY080N",
"ALIMONIES RECEIVED (COMPULSORY + VOLUNTARY)",
"FLAGS OF HY081N",
"FLAGS OF HY081N",
"INTEREST DIVIDENDS PROFIT FROM CAPITAL INVESTMENTS IN UNINCORPORATED BUSINESS",
"FLAGS OF HY090N",
"FLAGS OF HY090N",
"INTEREST REPAYMENTS ON MORTGAGE OF HY100",
"FLAGS OF HY100N",
"FLAGS OF HY100N",
"INCOME RECEIVED BY PEOPLE AGED UNDER 16",
"FLAGS OF HY110N",
"FLAGS OF HY110N",
"INCOME RECEIVED BY PEOPLE AGED UNDER 16",
"FLAGS OF HY120N",
"FLAGS OF HY120N",
"REGULAR INTER-HOUSEHOLD CASH TRANSFER PAID",
"FLAGS OF HY130N",
"FLAGS OF HY130N",
"ALIMONIES PAID (COMPULSORY + VOLUNTARY)",
"FLAGS OF HY131N",
"FLAGS OF HY131N",
"TAX ON INCOME AND SOCIAL CONTRIBUTIONS",
"FLAGS OF HY140N",
"FLAGS OF HY140N",
"REPAYMENTS/RECEIPTS FOR TAX ADJUSTMENT",
"FLAGS OF HY145N",
"FLAGS OF HY145N",
"VALUE OF GOODS PRODUCED FOR OWN CONSUMPTION",
"FLAGS OF HY170N",
"FLAGS OF HY170N",
"IMPUTED RENT OF HY030G",
"FLAGS OF HY030G",
"INCOME FROM RENTAL OF A PROPERTY OR LAND",
"FLAGS OF HY040G",
"FLAGS OF HY040G",
"FAMILY/HILDREN RELATED ALLOWANES",
"FLAGS OF HY050G",
"FLAGS OF HY050G",
"FAMILY/CHILDREN-RELATED ALLOWANCES (CONTRIBUTORY AND MEANS-TESTED)",
"FLAGS OF HY051G",
"FAMILY/CHILDREN-RELATED ALLOWANCES (CONTRIBUTORY AND NON MEANS-TESTED)",
"FLAGS OF HY052G",
"FAMILY/CHILDREN-RELATED ALLOWANCES (NON-CONTRIBUTORY AND MEANS-TESTED)",
"FLAGS OF HY053G",
"FAMILY/CHILDREN-RELATED ALLOWANCES (NON-CONTRIBUTORY AND NON MEANS-TESTED)",
"FLAGS OF HY054G",
"SOIAL EXLUSION NOT ELSEWHERE LASSIFIED",
"FLAGS OF HY060G",
"FLAGS OF HY060G",
"SOCIAL EXCLUSION NOT ELSEWHERE CLASSIFIED (CONTRIBUTORY AND MEANS-TESTED)",
"FLAGS OF HY061G",
"SOCIAL EXCLUSION NOT ELSEWHERE CLASSIFIED (CONTRIBUTORY AND NON MEANS-TESTED)",
"FLAGS OF HY062G",
"SOCIAL EXCLUSION NOT ELSEWHERE CLASSIFIED (NON-CONTRIBUTORY AND MEANS-TESTED)",
"FLAGS OF HY063G",
"SOCIAL EXCLUSION NOT ELSEWHERE CLASSIFIED (NON-CONTRIBUTORY AND NON MEANS-TESTED)",
"FLAGS OF HY064G",
"HOUSING ALLOWANES",
"FLAGS OF HY070G",
"FLAGS OF HY070G",
"HOUSING ALLOWANCES (CONTRIBUTORY AND MEANS-TESTED)",
"FLAGS OF HY071G",
"HOUSING ALLOWANCES (CONTRIBUTORY AND NON MEANS-TESTED)",
"FLAGS OF HY072G",
"HOUSING ALLOWANCES (NON-CONTRIBUTORY AND MEANS-TESTED)",
"FLAGS OF HY073G",
"HOUSING ALLOWANCES (NON-CONTRIBUTORY AND NON MEANS-TESTED)",
"FLAGS OF HY074G",
"REGULAR INTER-HOUSEHOLD ASH TRANSFER REEIVED",
"FLAGS OF HY080G",
"FLAGS OF HY080G",
"ALIMONIES RECEIVED (COMPULSORY + VOLUNTARY)",
"FLAGS OF HY081G",
"FLAGS OF HY081G",
"INTEREST DIVIDENDS PROFIT FROM CAPITAL INVESTMENTS IN UNINCORPORATED BUSINESS",
"FLAGS OF HY090G",
"FLAGS OF HY090G",
"INTEREST REPAYMENTS ON MORTGAGE",
"FLAGS OF HY100G",
"FLAGS OF HY100G",
"INCOME RECEIVED BY PEOPLE AGED UNDER 16",
"FLAGS OF HY110G",
"FLAGS OF HY110G",
"INCOME RECEIVED BY PEOPLE AGED UNDER 16",
"FLAGS OF HY120G",
"FLAGS OF HY120G",
"REGULAR INTER-HOUSEHOLD CASH TRANSFER PAID",
"FLAGS OF HY130G",
"FLAGS OF HY130G",
"ALIMONIES PAID (COMPULSORY + VOLUNTARY)",
"FLAGS OF HY131G",
"FLAGS OF HY131G",
"TAX ON INCOME AND SOCIAL CONTRIBUTIONS OF HY140",
"FLAGS OF HY140G",
"FLAGS OF HY140G",
"VALUE OF GOODS PRODUCED FOR OWN CONSUMPTION",
"FLAGS OF HY171G",
"FLAGS OF HY171G",
"REPLACE WORN-OUT FURNITURE",
"FLAGS OF HD080",
"AFFORDABILITY OF CHILDCARE SERVICES",
"FLAGS OF HC040",
"UNMET NEEDS FOR FORMAL CHILDCARE SERVICES",
"FLAGS OF HC050",
"MAIN REASON FOR NOT MAKING (MORE) USE OF FORMAL CHILDCARE SERVICES",
"FLAGS OF HC060",
"AFFORDABILITY OF FORMAL EDUCATION",
"FLAGS OF HC100",
"USE OF HEALTH CARE SERVICES",
"FLAGS OF HC160",
"PAYMENT FOR HEALTH CARE SERVICES",
"FLAGS OF HC170",
"AFFORDABILITY OF HEALTH CARE SERVICES",
"FLAGS OF HC180",
"PRESENCE IN THE HOUSEHOLD OF PEOPLE WHO NEED HELP DUE TO LONG-TERM PHYSICAL OR MENTAL ILL-HEALTH, INFIRMITY OR BECAUSE OF OLD AGE",
"FLAGS OF HC190",
"PROFESSIONAL HOME CARE RECEIVED",
"FLAGS OF HC200",
"NUMBER OF HOURS PER WEEK OF PROFESSIONAL HOME CARE RECEIVED",
"FLAGS OF HC210",
"PAYMENT FOR PROFESSIONAL HOME CARE",
"FLAGS OF HC220",
"AFFORDABILITY OF PROFESSIONAL HOME CARE SERVICES",
"FLAGS OF HC230",
"UNMET NEEDS FOR PROFESSIONAL HOME CARE",
"FLAGS OF HC240",
"MAIN REASON FOR NOT RECEIVING (MORE) PROFESSIONAL HOME CARE SERVICES",
"FLAGS OF HC250",
"CHANGE RATE",
"HOUSEHOLD SIZE",
"EQUIVALISED HOUSEHOLD SIZE",
"HOUSEHOLD TYPE",
"TENURE STATUS",
"POVERTY INDICATOR",
"EQUIVALISED DISPOSABLE INCOME",
"OVERCROWDED HOUSEHOLD")

HB020_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HB020, 
levels=c("AT", 
"BE", 
"BG", 
"CH", 
"CY", 
"CZ", 
"DE", 
"DK", 
"EE", 
"ES", 
"FI", 
"FR", 
"GR", 
"HU", 
"IE", 
"IS", 
"IT", 
"LT", 
"LU", 
"LV", 
"MT", 
"NL", 
"NO", 
"PL", 
"PT", 
"RO", 
"SE", 
"SI", 
"SK", 
"UK"), 
labels=c("sterreich", 
"Belgique", 
"Bulgaria", 
"Switzerland", 
"Cyprus", 
"Czech", 
"Deutschland", 
"Danmark", 
"Estonia", 
"Espaa", 
"Suomi", 
"France", 
"Ellda", 
"Hungary", 
"Ireland", 
"Iceland", 
"Italia", 
"Lithuania", 
"Luxembourg", 
"Latvia", 
"Malta", 
"Nederland", 
"Norway", 
"Poland", 
"Portugal", 
"Romania", 
"Sverige", 
"Slovenia", 
"Slovak/republic", 
"United")) 


HB050_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HB050, 
levels=c(1, 
2, 
3, 
4), 
labels=c("January-March", 
"April-June", 
"July-September", 
"October-December")) 


HB050_F_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HB050_F, 
levels=c(1, 
-1), 
labels=c("filled", 
"missing")) 


HB060_F_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HB060_F, 
levels=c(1), 
labels=c("filled")) 


HB070_F_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HB070_F, 
levels=c(1, 
-1), 
labels=c("filled", 
"missing")) 


HB080_F_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HB080_F, 
levels=c(1, 
-1), 
labels=c("filled", 
"missing")) 


HB090_F_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HB090_F, 
levels=c(1, 
-1, 
-2), 
labels=c("filled", 
"missing", 
"only  na (no second responsible)")) 


HB100_F_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HB100_F, 
levels=c(1, 
-1), 
labels=c("filled", 
"missing")) 


HH010_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HH010, 
levels=c(1, 
2, 
3, 
4), 
labels=c("detached house", 
"semi-detached or terraced house", 
"apartment or flat in a building with less than 10 dwellings", 
"apartment or flat in a building with 10 or more dwellings")) 


HH010_F_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HH010_F, 
levels=c(1, 
-1), 
labels=c("filled", 
"missing")) 


HH021_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HH021, 
levels=c(1, 
2, 
3, 
4, 
5), 
labels=c("Outright owner", 
"Owner paying mortgage", 
"Tenant or subtenant paying rent at prevailing or market rate", 
"Accommodation is rented at a reduced rate (lower price that the market price", 
"Accommodation is provided free")) 


HH021_F_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HH021_F, 
levels=c(1, 
-1, 
-5), 
labels=c("filled", 
"missing", 
"missing value of HH021 because HH020 is still used")) 


HH030_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HH030, 
levels=c(1, 
2, 
3, 
4, 
5, 
6, 
7, 
8, 
9, 
10), 
labels=c("1 room", 
"2 rooms", 
"3 rooms", 
"4 rooms", 
"5 rooms", 
"6 rooms", 
"7 rooms", 
"8 rooms", 
"9 rooms", 
"10 or more rooms")) 


HH030_F_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HH030_F, 
levels=c(1, 
-1), 
labels=c("filled", 
"missing")) 


HH031_F_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HH031_F, 
levels=c(1, 
-1, 
-2), 
labels=c("filled", 
"missing", 
"n.a. (MS using objective national methods to calculate imputed rent)")) 


HH040_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HH040, 
levels=c(1, 
2), 
labels=c("yes", 
"no")) 


HH040_F_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HH040_F, 
levels=c(1, 
-1), 
labels=c("filled", 
"missing")) 


HH050_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HH050, 
levels=c(1, 
2), 
labels=c("yes", 
"no")) 


HH050_F_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HH050_F, 
levels=c(1, 
-1), 
labels=c("filled", 
"missing")) 


HH060_F_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HH060_F, 
levels=c(1, 
-1, 
-2), 
labels=c("filled", 
"missing", 
"na (HH020 not = 2 or 3)")) 


HH061_F_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HH061_F, 
levels=c(1, 
-1, 
-2), 
labels=c("filled", 
"missing", 
"na (HH020 not = 1 or 3 or 4) or (MS do not use subjective method to calculate imputed rent)")) 


HH070_F_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HH070_F, 
levels=c(1, 
-1), 
labels=c("filled", 
"missing")) 


HH071_F_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HH071_F, 
levels=c(1, 
-1, 
-2), 
labels=c("filled", 
"missing", 
"Not applicable")) 


HH081_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HH081, 
levels=c(1, 
2, 
3), 
labels=c("yes, for sole use of the household", 
"yes, shared", 
"no")) 


HH081_F_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HH081_F, 
levels=c(1, 
-1), 
labels=c("filled", 
"missing")) 


HH091_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HH091, 
levels=c(1, 
2, 
3), 
labels=c("yes, for sole use of the household", 
"yes, shared", 
"no")) 


HH091_F_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HH091_F, 
levels=c(1, 
-1), 
labels=c("filled", 
"missing")) 


HS011_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HS011, 
levels=c(1, 
2, 
3), 
labels=c("yes, once", 
"yes, twice or more", 
"no")) 


HS011_F_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HS011_F, 
levels=c(1, 
-1, 
-2, 
-5), 
labels=c("filled", 
"missing", 
"not applicable (outright owner or rent free during the last twelve months)", 
"missing value of HS011 because HS010 is still used")) 


HS021_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HS021, 
levels=c(1, 
2, 
3), 
labels=c("yes, once", 
"yes, twice or more", 
"no")) 


HS021_F_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HS021_F, 
levels=c(1, 
-1, 
-2, 
-5), 
labels=c("filled", 
"missing", 
"na (no utility bills)", 
"missing value of HS021 because HS020 is still used")) 


HS031_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HS031, 
levels=c(1, 
2, 
3), 
labels=c("yes, once", 
"yes, twice or more", 
"no")) 


HS031_F_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HS031_F, 
levels=c(1, 
-1, 
-2, 
-5), 
labels=c("filled", 
"missing", 
"na (no hire purchase instalments and no other loan payments)", 
"missing value of HS031 because HS030 is still used")) 


HS040_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HS040, 
levels=c(1, 
2), 
labels=c("yes", 
"no")) 


HS040_F_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HS040_F, 
levels=c(1, 
-1), 
labels=c("filled", 
"missing")) 


HS050_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HS050, 
levels=c(1, 
2), 
labels=c("yes", 
"no")) 


HS050_F_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HS050_F, 
levels=c(1, 
-1), 
labels=c("filled", 
"missing")) 


HS060_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HS060, 
levels=c(1, 
2), 
labels=c("yes", 
"no")) 


HS060_F_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HS060_F, 
levels=c(1, 
-1), 
labels=c("filled", 
"missing")) 


HS070_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HS070, 
levels=c(1, 
2, 
3), 
labels=c("yes", 
"no - cannot afford", 
"no - other reason")) 


HS070_F_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HS070_F, 
levels=c(1, 
-1), 
labels=c("filled", 
"missing")) 


HS080_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HS080, 
levels=c(1, 
2, 
3), 
labels=c("yes", 
"no - cannot afford", 
"no - other reason")) 


HS080_F_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HS080_F, 
levels=c(1, 
-1), 
labels=c("filled", 
"missing")) 


HS090_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HS090, 
levels=c(1, 
2, 
3), 
labels=c("yes", 
"no - cannot afford", 
"no - other reason")) 


HS090_F_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HS090_F, 
levels=c(1, 
-1), 
labels=c("filled", 
"missing")) 


HS100_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HS100, 
levels=c(1, 
2, 
3), 
labels=c("yes", 
"no - cannot afford", 
"no - other reason")) 


HS100_F_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HS100_F, 
levels=c(1, 
-1), 
labels=c("filled", 
"missing")) 


HS110_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HS110, 
levels=c(1, 
2, 
3), 
labels=c("yes", 
"no - cannot afford", 
"no - other reason")) 


HS110_F_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HS110_F, 
levels=c(1, 
-1), 
labels=c("filled", 
"missing")) 


HS120_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HS120, 
levels=c(1, 
2, 
3, 
4, 
5, 
6), 
labels=c("with great difficulty", 
"with difficulty", 
"with some difficulty", 
"fairly easily", 
"easily", 
"very easily")) 


HS120_F_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HS120_F, 
levels=c(1, 
-1), 
labels=c("filled", 
"missing")) 


HS130_F_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HS130_F, 
levels=c(1, 
-1), 
labels=c("filled", 
"missing")) 


HS140_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HS140, 
levels=c(1, 
2, 
3), 
labels=c("A heavy burden", 
"Somewhat a burden", 
"not burden at all")) 


HS140_F_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HS140_F, 
levels=c(1, 
-1), 
labels=c("filled", 
"missing")) 


HS150_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HS150, 
levels=c(1, 
2, 
3), 
labels=c("Repayment is a heavy burden", 
"Repayment is somewhat a burden", 
"Repayment is not a burden at all")) 


HS150_F_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HS150_F, 
levels=c(1, 
-1, 
-2), 
labels=c("filled", 
"missing", 
"not applicable ( no repayment of debts)")) 


HS160_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HS160, 
levels=c(1, 
2), 
labels=c("yes", 
"no")) 


HS160_F_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HS160_F, 
levels=c(1, 
-1), 
labels=c("filled", 
"missing")) 


HS170_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HS170, 
levels=c(1, 
2), 
labels=c("yes", 
"no")) 


HS170_F_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HS170_F, 
levels=c(1, 
-1), 
labels=c("filled", 
"missing")) 


HS180_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HS180, 
levels=c(1, 
2), 
labels=c("yes", 
"no")) 


HS180_F_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HS180_F, 
levels=c(1, 
-1), 
labels=c("filled", 
"missing")) 


HS190_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HS190, 
levels=c(1, 
2), 
labels=c("yes", 
"no")) 


HS190_F_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HS190_F, 
levels=c(1, 
-1), 
labels=c("filled", 
"missing")) 


HD080_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HD080, 
levels=c(1, 
2, 
3), 
labels=c("Yes", 
"No - household cannot afford it", 
"No - other reason")) 


HD080_F_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HD080_F, 
levels=c(1, 
-1, 
-7), 
labels=c("Filled", 
"Missing", 
"Not applicable: HB010 < 2013")) 


HC040_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HC040, 
levels=c(1, 
2, 
3, 
4, 
5, 
6), 
labels=c("with great difficulty", 
"with difficulty", 
"with some difficulty", 
"fairly easily", 
"easily", 
"very easily")) 


HC040_F_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HC040_F, 
levels=c(1, 
-1, 
-4, 
-5, 
-7), 
labels=c("filled", 
"missing", 
"no costs of childcare in the household", 
"no children aged 0-12 in the household", 
"not applicable HB010 not = 2016")) 


HC050_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HC050, 
levels=c(1, 
2), 
labels=c("yes", 
"no")) 


HC050_F_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HC050_F, 
levels=c(1, 
-1, 
-5, 
-7), 
labels=c("filled", 
"missing", 
"no children aged 0-12 in the household", 
"not applicable HB010 not = 2016")) 


HC060_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HC060, 
levels=c(1, 
2, 
3, 
4, 
5, 
6), 
labels=c("cannot afford it", 
"no places available", 
"places available but not nearby", 
"places available but opening hours not suitable", 
"places available but the quality of the services available not", 
"other reasons")) 


HC060_F_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HC060_F, 
levels=c(1, 
-1, 
-2, 
-5, 
-7), 
labels=c("filled", 
"missing", 
"not applicable (HC050 = 2)", 
"no children aged 0-12 in the household", 
"not applicable HB010 not = 2016")) 


HC100_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HC100, 
levels=c(1, 
2, 
3, 
4, 
5, 
6), 
labels=c("with great difficulty", 
"with difficulty", 
"with some difficulty", 
"fairly easily", 
"easily", 
"very easily")) 


HC100_F_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HC100_F, 
levels=c(1, 
-1, 
-4, 
-5, 
-7), 
labels=c("filled", 
"missing", 
"no costs of formal education in the household", 
"nobody in the household follows formal education", 
"not applicable HB010 not = 2016")) 


HC160_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HC160, 
levels=c(1, 
2), 
labels=c("yes", 
"no")) 


HC160_F_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HC160_F, 
levels=c(1, 
-1, 
-7), 
labels=c("filled", 
"missing", 
"not applicable HB010 not = 2016")) 


HC170_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HC170, 
levels=c(1, 
2), 
labels=c("yes", 
"no")) 


HC170_F_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HC170_F, 
levels=c(1, 
-1, 
-2, 
-7), 
labels=c("filled", 
"missing", 
"not applicable (HC160=2)", 
"not applicable HB010 not = 2016")) 


HC180_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HC180, 
levels=c(1, 
2, 
3, 
4, 
5, 
6), 
labels=c("with great difficulty", 
"with difficulty", 
"with some difficulty", 
"fairly easily", 
"easily", 
"very easily")) 


HC180_F_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HC180_F, 
levels=c(1, 
-1, 
-2, 
-7), 
labels=c("filled", 
"missing", 
"not applicable (HC160=2)", 
"not applicable HB010 not = 2016")) 


HC190_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HC190, 
levels=c(1, 
2), 
labels=c("yes", 
"no")) 


HC190_F_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HC190_F, 
levels=c(1, 
-1, 
-4, 
-5, 
-7), 
labels=c("filled", 
"missing", 
"no costs of formal education in the household", 
"nobody in the household follows formal education", 
"not applicable HB010 not = 2016")) 


HC200_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HC200, 
levels=c(1, 
2), 
labels=c("yes", 
"no")) 


HC200_F_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HC200_F, 
levels=c(1, 
-1, 
-2, 
-7), 
labels=c("filled", 
"missing", 
"not applicable (HC190=2)", 
"not applicable HB010 not = 2016")) 


HC210_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HC210, 
levels=c(1, 
2, 
3), 
labels=c("less than 10 hours per week", 
"at least 10 but less than 20 hours per week", 
"20 hours per week or more")) 


HC210_F_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HC210_F, 
levels=c(1, 
-1, 
-2, 
-7), 
labels=c("filled", 
"missing", 
"not applicable (HC190=2 or HC200=2)", 
"not applicable HB010 not = 2016")) 


HC220_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HC220, 
levels=c(1, 
2), 
labels=c("yes", 
"no")) 


HC220_F_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HC220_F, 
levels=c(1, 
-1, 
-2, 
-7), 
labels=c("filled", 
"missing", 
"not applicable (HC190=2 or HC240=2)", 
"not applicable HB010 not = 2016")) 


HC230_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HC230, 
levels=c(1, 
2, 
3, 
4, 
5, 
6), 
labels=c("with great difficulty", 
"with difficulty", 
"with some difficulty", 
"fairly easily", 
"easily", 
"very easily")) 


HC230_F_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HC230_F, 
levels=c(1, 
-1, 
-2, 
-7), 
labels=c("filled", 
"missing", 
"not applicable (HC190=2 or HC200=2 or HC220=2)", 
"not applicable HB010 not = 2016")) 


HC240_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HC240, 
levels=c(1, 
2), 
labels=c("yes", 
"no")) 


HC240_F_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HC240_F, 
levels=c(1, 
-1, 
-2, 
-7), 
labels=c("filled", 
"missing", 
"not applicable (HC190=2)", 
"not applicable HB010 not = 2016")) 


HC250_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HC250, 
levels=c(1, 
2, 
3, 
4, 
5), 
labels=c("cannot afford it", 
"refused by person needing such services", 
"no such care services available", 
"quality of the services available not satisfactory", 
"other reasons")) 


HC250_F_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HC250_F, 
levels=c(1, 
-1, 
-2, 
-7), 
labels=c("filled", 
"missing", 
"not applicable (HC190=2 or HC240=2)", 
"not applicable HB010 not = 2016")) 


HX060_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HX060, 
levels=c(5, 
6, 
7, 
8, 
9, 
10, 
11, 
12, 
13, 
16), 
labels=c("One person household", 
"2 adults, no dependent children, both adults under 65 years", 
"2 adults, no dependent children, at least one adult 65 years or more", 
"Other households without dependent children", 
"Single parent household, one or more dependent children", 
"2 adults, one dependent child", 
"2 adults, two dependent children", 
"2 adults, three or more dependent children", 
"Other households with dependent children", 
"Other (these household are excluded from Laeken indicators calculation)")) 


HX070_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HX070, 
levels=c(1, 
2), 
labels=c("owner", 
"tenant")) 


HX080_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HX080, 
levels=c(0, 
1), 
labels=c("not at risk of poverty", 
"at risk of poverty")) 


HX120_Fact <- factor(DF_EU-SILC_A2016_HOUSEHOLD_DATA$HX120, 
levels=c(NA, 
0, 
1), 
labels=c("not applicable", 
"not overcrowded", 
"overcrowded"), exclude=NULL) 

save.image (file="DF_EU-SILC_A2016_HOUSEHOLD_DATA.RData")
