/* #Declinazione di responsabilità. 
#I file rilasciati in formato testo sono provvisti anche dei programmi di importazione per STATA, SAS e R. 
#L'Istat non garantisce che le funzioni contenute nei suddetti programmi siano esenti da errore e non si assume alcuna responsabilità sull’output ottenuto dal loro utilizzo.     
/*  I valori delle label nelle variabili categoriche sono commentati a causa della presenza di codici non esclusivamente numerici. Comunque sono completamente documentati.  */
clear all
infile  using  PGM_2018_Quarto_trimestre_IT_DELIMITED.dct, clear
/*
label define  trim_t0_cl1 1   "Primo trimestre" 2   "Secondo trimestre" 3   "Terzo trimestre" 4   "Quarto trimestre"  
label define  reg_t0_cl2 01   "Piemonte" 02   "Valle d'Aosta" 03   "Lombardia" 04   "Trentino alto Adige" 05   "Veneto" 06   "Friuli Venezia Giulia" 07   "Liguria" 08   "Emilia Romagna" 09   "Toscana" 10   "Umbria" 11   "Marche" 12   "Lazio" 13   "Abruzzo" 14   "Molise" 15   "Campania" 16   "Puglia" 17   "Basilicata" 18   "Calabria" 19   "Sicilia" 20   "Sardegna"  
label define  sg11_t0_cl4 1   "Maschio" 2   "Femmina"  
label define  sg13_t0_cl5 1   "In Italia" 2   "All'estero"  
label define  sg16_t0_cl6 1   "Sì 2   "No"  
label define  sg24_t0_cl7 01   "Nessun titolo" 02   "Licenza elementare / Attestato di valutazione finale" 03   "Licenza media (dall'anno 2007 denominata Diploma di Istruzione secondaria di I grado) o avviamento professionale (conseguito non oltre all'anno 1965)" 04   "Diploma di qualifica professionale di scuola secondaria superiore (di II grado) di 2-3 anni che non permette l'iscrizione all'Università 05   "Diploma di maturità / Diploma di istruzione secondaria superiore (di II grado) di 4-5 anni che permette l'iscrizione all'Universit 06   "Diploma di Accademia (Belle Arti, Nazionale di arte drammatica, Nazionale di Danza), Istituto superiore Industrie artistiche, Conservatorio di musica statale, Istituto di Musica Pareggiato" 07   "Diploma universitario di due/tre anni, Scuola diretta a fini speciali, Scuola parauniversitaria" 08   "Laurea di primo livello (triennale)" 09   "Laurea specialistica / magistrale (biennale)" 10   "Laurea di 4-6 anni: laurea del vecchio ordinamento o laurea specialistica / magistrale a ciclo unico" 13   "Attestato IFP di qualifica professionale triennale (operatore) / Diploma professionale IFP di tecnico (quarto anno) (dal 2005)" 14   "Certificato di specializzazione tecnica superiore  IFTS (dal 2000)" 15   "Diploma di tecnico superiore ITS (corsi biennali) (dal 2013)"  
label define  sg24a_t0_cl8 001   "Diploma (vecchio ordinamento)" 002   "Diploma accademico di alta formazione artistica, musicale e coreutica di I livello" 003   "Diploma accademico di alta formazione artistica, musicale e coreutica di II livello" 997   "Non sa"  
label define  sg24b_t0_cl9 1   "Master universitario di I livello/ Diploma accademico  di perfezionamento o Master di I livello/Diploma accademico di specializzazione di I livello" 2   "Master universitario di II livello/ Diploma accademico di perfezionamento o Master di II livello/Diploma accademico di specializzazione di II livello" 3   "Diploma di specializzazione universitaria" 4   "Dottorato di ricerca/Diploma accademico di formazione alla ricerca AFAM" 5   "Nessuno di questi"  
label define  b1_t0_cl10 1   "Si" 2   "No" 3   "Permanentemente inabile al lavoro"  
label define  b2_t0_cl11 1   "Sì 2   "No"  
label define  b3_t0_cl12 001   "Cassa Integrazione Guadagni (CIG ordinaria o straordinaria)" 002   "Ridotta attività dell'impresa per motivi economici e/o tecnici (esclusa CIG) 004   "Controversia di lavoro" 005   "Maltempo" 006   "Malattia, problemi di salute personali, infortunio" 007   "Ferie" 008   "Festività nella settimana 009   "Orario variabile o flessibile (ad es. riposo compensativo)" 010   "Part-time verticale" 011   "Studio o formazione riconosciuta nell'orario lavorativo" 012   "Assenza obbligatoria per maternità 013   "Assenza facoltativa fino al dodicesimo anno del bambino (congedo parentale)" 014   "Motivi familiari (esclusa maternità obbligatoria e congedo parentale) 015   "Mancanza/scarsità di lavoro 018   "Studio o formazione non riconosciuta nell'orario lavorativo" 994   "Fa un lavoro occasionale" 995   "Fa un lavoro stagionale ALLE DIPENDENZE (ad es. bagnino,  raccoglitore di frutta, cameriere in montagna d'inverno, etc.)" 996   "Altro motivo (specificare)"  
label define  b4_t0_cl13 1   "Un lavoro alle dipendenze" 2   "Un lavoro di: Collaborazione coordinata e continuativa (con o senza progetto)" 3   "Un lavoro di: Prestazione d'opera occasionale" 4   "Un lavoro autonomo come: Imprenditore" 5   "Un lavoro autonomo come: Libero professionista" 6   "Un lavoro autonomo come: Lavoratore in proprio" 7   "Un lavoro autonomo come: Coadiuvante nell'azienda di un familiare" 8   "Un lavoro autonomo come: Socio di cooperativa"  
label define  b4a_t0_cl14 1   "Si,  Contratto di lavoro alle dipendenze" 2   "Si,  Contratto di collaborazione coordinata e continuativa (con o senza progetto)" 3   "No"  
label define  c1_t0_cl15 1   "Un lavoro alle dipendenze" 2   "Un lavoro di: Collaborazione coordinata e continuativa (con o senza progetto)" 3   "Un lavoro di: Prestazione d'opera occasionale" 4   "Un lavoro autonomo come: Imprenditore" 5   "Un lavoro autonomo come: Libero professionista" 6   "Un lavoro autonomo come: Lavoratore in proprio" 7   "Un lavoro autonomo come: Coadiuvante nell'azienda di un familiare" 8   "Un lavoro autonomo come: Socio di cooperativa"  
label define  c1a_t0_cl16 1   "Si,  Contratto di lavoro alle dipendenze" 2   "Si,  Contratto di collaborazione coordinata e continuativa (con o senza progetto)" 3   "No"  
label define  c4_t0_cl17 1   "Sì 2   "No"  
label define  c5_t0_cl18 001   "Per un sola azienda/cliente" 002   "Per più aziende/clienti 997   "Non sa"  
label define  c6_t0_cl19 001   "Decide dove lavorare/lavora presso il proprio ufficio" 002   "Lavora presso l'azienda/cliente/committente" 997   "Non sa"  
label define  c7_t0_cl20 001   "Decide autonomamente l'orario" 002   "Non decide l'orario" 997   "Non sa"  
label define  c9_t0_cl21 1   "Dirigente" 2   "Quadro" 3   "Impiegato" 4   "Operaio" 5   "Apprendista" 6   "Lavoratore presso il proprio domicilio per conto di un'impresa"  
label define  c10_t0_cl22 001   "Sì 002   "No" 997   "Non sa"  
label define  c14_t0_cl23 001   "Solo una sede" 002   "Più sedi 997   "Non sa"  
label define  c18_t0_cl24 1   "Fino a 10 persone" 2   "Da 11 a 15" 3   "Da 16 a 19" 4   "Da 20 a 49" 5   "Da 50 a 249" 6   "250 persone o più 7   "Non sa ma fino a 10" 8   "Non sa ma più di 10  
label define  c20_t0_cl25 1   "A termine (tempo determinato)" 2   "A tempo indeterminato (senza una scadenza)"  
label define  c22_t0_cl27 001   "Per imparare il lavoro (stage, tirocinio e apprendistato)" 002   "Per svolgere un periodo di prova" 003   "È un lavoro stagionale 004   "Il lavoro è per sua natura occasionale, discontinuo o intermittente 005   "Per realizzare un progetto specifico" 006   "Per occupare un posto vacante (comprese supplenze brevi e incarico a termine nella scuola, nella sanità, etc.) 007   "È l'unico che è stato proposto (compreso eventuale lavoro senza contratto e chi dice non c'è una ragione specific 996   "Altro (specificare)" 997   "Non sa"  
label define  c24_t0_cl28 001   "Sì 002   "No" 997   "Non sa"  
label define  c24bis_t0_cl29 001   "Dall'impresa" 002   "Dall'agenzia interinale" 997   "Non sa"  
label define  c24ter_t0_cl30 001   "Sì 002   "No" 997   "Non sa"  
label define  c25_t0_cl31 001   "Non vuole un lavoro a tempo indeterminato" 002   "Non ha trovato un lavoro a tempo indeterminato" 997   "Non sa"  
label define  c27_t0_cl32 1   "A tempo pieno" 2   "A tempo parziale (part-time)"  
label define  c27b_t0_cl33 001   "Part-time orizzontale: lavora tutti i giorni ma meno ore rispetto all'orario normale giornaliero" 002   "Part-time verticale: lavora a tempo pieno ma solo alcuni giorni della settimana, del mese o dell'anno" 003   "Combinazione di part-time orizzontale e verticale" 004   "Part-time occasionale o saltuario" 997   "Non sa"  
label define  c27d_t0_cl34 001   "Alcuni giorni a settimana" 002   "Alcune settimane al mese" 003   "Alcuni mesi all'anno" 996   "Altro (specificare)" 997   "Non sa"  
label define  c28_t0_cl35 001   "Non vuole un lavoro a tempo pieno" 002   "Non ha trovato un lavoro a tempo pieno" 003   "Altri motivi" 997   "Non sa"  
label define  c29b_t0_cl36 001   "Sì, sono assenti/inadeguati i servizi per la cura di bambini 002   "Sì, sono assenti/inadeguati i servizi per la cura di persone anziane, malate, disabili 003   "Sì, entrambi i servizi sono assenti/inadeguati 004   "No, lavora part-time per altri motivi" 997   "Non sa"  
label define  c32_t0_cl39 001   "Meno del solito" 002   "Piu' del solito" 003   "Come al solito" 997   "Non sa"  
label define  c33_t0_cl40 001   "Orario variabile, flessibile" 002   "Straordinario retribuito e/o non retribuito" 004   "Maggiori impegni di lavoro" 996   "Altro (specificare)"  
label define  c34_t0_cl41 001   "Cassa Integrazione Guadagni (ordinaria o straordinaria)" 002   "Ridotta attività dell'impresa per motivi economici e/o tecnici (esclusa CIG) 004   "Controversia di lavoro" 005   "Maltempo" 006   "Malattia, problemi di salute personali, infortunio" 007   "Ferie" 008   "Festività nella settimana 009   "Orario variabile o flessibile (ad es. riposo compensativo)" 010   "Part-time verticale" 011   "Studio o formazione riconosciuta nell'orario lavorativo" 012   "Assenza obbligatoria per maternità 013   "Assenza facoltativa fino al dodicesimo anno del bambino (congedo parentale)" 014   "Motivi familiari (esclusa maternità obbligatoria e congedo parentale, compreso allattamento) 015   "Mancanza/scarsità di lavoro 016   "Inizio o cambiamento del lavoro nella settimana" 017   "Ha concluso il lavoro nella settimana" 018   "Studio o formazione non riconosciuta nell¿orario lavorativo 994   "Fa un lavoro occasionale" 995   "Fa un lavoro stagionale ALLE DIPENDENZE (ad es. bagnino, raccoglitore di frutta, cameriere in montagna d¿inverno etc.) 996   "raccoglitore di frutta, cameriere in montagna d¿inverno etc.)  
label define  c35_t0_cl42 001   "Sì 002   "No" 997   "Non sa"  
label define  c38_t0_cl45 001   "Sì, meno ore 002   "Sì, più or 003   "No (avrebbe voluto lavorare lo stesso numero di ore)" 997   "Non sa"  
label define  c39a_t0_cl47 1   "Aggiungendo un nuovo lavoro a quello che ha già 2   "Cambiando lavoro" 3   "Continuando a fare lo stesso lavoro" 4   "In uno qualunque dei modi precedenti"  
label define  c40_t0_cl48 001   "Sì, nella settimana specificata o entro le due settimane successive 002   "No" 997   "Non sa"  
label define  c42_t0_cl49 001   "Sì, 2 o più volte a settiman 002   "Sì, meno di 2 volte a settimana 003   "No" 997   "Non sa"  
label define  c43_t0_cl50 001   "Sì, 2 o più volte a settiman 002   "Sì, meno di 2 volte a settimana 003   "No" 997   "Non sa"  
label define  c44_t0_cl51 001   "Sì, 2 o più volte (nelle 4 settimane 002   "Sì, meno di 2 volte (nelle 4 settimane) 003   "No" 997   "Non sa"  
label define  c45_t0_cl52 001   "Sì, 2 o più volte (nelle 4 settimane 002   "Sì, meno di 2 volte (nelle 4 settimane) 003   "No" 997   "Non sa"  
label define  c46_t0_cl53 001   "Sì 002   "No" 997   "Non sa"  
label define  c47_t0_cl54 001   "Sì 002   "No" 997   "Non sa"  
label define  c48_t0_cl55 001   "Sì, 2 o più volte a settiman 002   "Sì, meno di 2 volte a settimana 003   "No" 997   "Non sa"  
label define  c53_t0_cl56 001   "Sì, da un altro comune italiano 003   "Sì, dall'estero 004   "No" 005   "Sì, ma poi è tornato nel comune di residenz 997   "Non sa"  
label define  c59_t0_cl57 001   "Sì 002   "No" 997   "Non sa"  
label define  c60_t0_cl58 001   "Sì 002   "No" 997   "Non sa"  
label define  d1_t0_cl59 1   "Sì, un altro lavoro 2   "Sì, più di un 3   "No"  
label define  d3_t0_cl61 001   "Regolarmente" 002   "Solo in alcune stagioni (o in particolari periodi dell'anno)" 003   "Ogni tanto, quando capita" 997   "Non sa"  
label define  d4_t0_cl62 1   "Un lavoro alle dipendenze" 2   "Un lavoro di: Collaborazione coordinata e continuativa (con o senza progetto)" 3   "Un lavoro di: Prestazione d'opera occasionale" 4   "Un lavoro autonomo come: Imprenditore" 5   "Un lavoro autonomo come: Libero professionista" 6   "Un lavoro autonomo come: Lavoratore in proprio" 7   "Un lavoro autonomo come: Coadiuvante nell'azienda di un familiare" 8   "Un lavoro autonomo come: Socio di cooperativa"  
label define  d5_t0_cl63 1   "Si,  Contratto di lavoro alle dipendenze" 2   "Si,  Contratto di collaborazione coordinata e continuativa (con o senza progetto)" 3   "No"  
label define  f1_t0_cl64 1   "Sì 2   "No"  
label define  f2_t0_cl65 1   "Un nuovo lavoro" 2   "Un secondo lavoro (da aggiungere a quello attuale)"  
label define  f3_t0_cl66 001   "Lavoro attuale è a termine (lavoro a tempo determinato) 002   "Teme di perdere l'attuale lavoro" 003   "Considera l'attuale lavoro occasionale" 004   "Guadagnare di più 005   "Raggiungere più facilmente il luogo di lavoro 006   "Orario più adatto a prendersi cura dei figli e/o di altri familiari 007   "Orario diverso per altri motivi" 008   "Cerca un lavoro più qualificante per le proprie  capacità/competenze e con maggiori prospettive di carrier 009   "Cerca un lavoro più adatto alle proprie condizioni di salute 996   "Altri motivi (specificare)"  
label define  f4_t0_cl67 001   "Più ore 002   "Meno ore" 003   "Lo stesso numero di ore" 997   "Non sa"  
label define  f5_t0_cl68 1   "Sì 2   "No"  
label define  f6_01_t0_cl69 0   "No" 1   "Si"  
label define  f6_02_t0_cl70 0   "No" 1   "Si"  
label define  f6_03_t0_cl71 0   "No" 1   "Si"  
label define  f6_04_t0_cl72 0   "No" 1   "Si"  
label define  f6_05_t0_cl73 0   "No" 1   "Si"  
label define  f6_06_t0_cl74 0   "No" 1   "Si"  
label define  f6_07_t0_cl75 0   "No" 1   "Si"  
label define  f6_08_t0_cl76 0   "No" 1   "Si"  
label define  f6_09_t0_cl77 0   "No" 1   "Si"  
label define  f6_10_t0_cl78 0   "No" 1   "Si"  
label define  f6_11_t0_cl79 0   "No" 1   "Si"  
label define  f6_12_t0_cl80 0   "No" 1   "Si"  
label define  f6_96_t0_cl81 0   "No" 1   "Si"  
label define  f6a_01_t0_cl82 0   "No" 1   "Si"  
label define  f6a_02_t0_cl83 0   "No" 1   "Si"  
label define  f6a_03_t0_cl84 0   "No" 1   "Si"  
label define  f6a_96_t0_cl85 0   "No" 1   "Si"  
label define  f7_t0_cl86 1   "Sì 2   "No"  
label define  f8_t0_cl87 1   "Sì 2   "No"  
label define  f10_t0_cl88 001   "Ha già un lavoro che inizierà in futur 002   "Studia o segue corsi di formazione professionale" 003   "Malattia, problemi di salute personali" 004   "Per prendersi cura dei figli, di bambini e/o di altre  persone non autosufficenti" 005   "In attesa di tornare al suo posto di lavoro" 007   "Pensione da lavoro (anzianità o vecchiaia) 008   "Ritiene di non riuscire a trovare lavoro" 009   "Non gli interessa/non ne ha bisogno (anche per motivi di età) 010   "Sta aspettando gli esiti di passate azioni di ricerca" 011   "Permanentemente inabile al lavoro" 012   "Maternità, nascita di un figlio 013   "Altri motivi familiari (compreso fa la casalinga, esclusa maternità, cura dei figli o di altre persone) 014   "È in attesa di iniziare a ricevere la pensione 996   "Altri motivi (specificare)" 997   "Non sa"  
label define  f10a_t0_cl89 001   "Sì, sono assenti/inadeguati i servizi per la cura di bambini 002   "Sì, sono assenti/inadeguati i servizi per la cura di persone anziane, malate, disabili 003   "Sì, entrambi i servizi sono assenti/inadeguati 004   "No, non ha cercato lavoro per altri motivi" 997   "Non sa"  
label define  f12_t0_cl90 1   "Sì 2   "No"  
label define  f13_t0_cl91 1   "Sì 2   "No"  
label define  f14_t0_cl92 001   "Studia o segue corsi di formazione professionale" 002   "Altri motivi personali" 003   "Maternità, nascita di un figlio 004   "Altri motivi familiari (compreso la casalinga, esclusa la maternità, cura dei figli o di altre persone) 005   "Malattia, problemi di salute personali" 006   "Deve dare un preavviso" 007   "Deve o vuole concludere il lavoro già iniziato 008   "Frequenta uno stage o un tirocinio" 009   "Per prendersi cura dei figli, di bambini e/o di altre persone non autosufficienti" 996   "Altri motivi (specificare)" 997   "Non sa" 998   "Non risponde"  
label define  f16_t0_cl93 1   "Sì 2   "No"  
label define  f17_t0_cl94 1   "Sì 2   "No"  
label define  f18_t0_cl95 1   "Sì 2   "No"  
label define  f19_t0_cl96 1   "Sì 2   "No"  
label define  f20_t0_cl97 1   "Sì 2   "No"  
label define  f21_t0_cl98 1   "Sì 2   "No"  
label define  f22_t0_cl99 1   "Sì 2   "No"  
label define  f23_t0_cl100 1   "Sì 2   "No"  
label define  f24_t0_cl101 1   "Sì 2   "No"  
label define  f24a_01_t0_cl102 0   "No" 1   "Si"  
label define  f24a_02_t0_cl103 0   "No" 1   "Si"  
label define  f24a_03_t0_cl104 0   "No" 1   "Si"  
label define  f24a_96_t0_cl105 0   "No" 1   "Si"  
label define  f25_t0_cl106 1   "Sì 2   "No"  
label define  f26_t0_cl107 1   "Sì 2   "No"  
label define  f27_t0_cl108 1   "Sì 2   "No"  
label define  f28_t0_cl109 1   "Si (specificare)" 2   "No"  
label define  f29_01_t0_cl110 0   "No" 1   "Si"  
label define  f29_02_t0_cl111 0   "No" 1   "Si"  
label define  f29_03_t0_cl112 0   "No" 1   "Si"  
label define  f29_04_t0_cl113 0   "No" 1   "Si"  
label define  f29_97_t0_cl114 0   "No" 1   "Si"  
label define  f30_t0_cl115 1   "Sì 2   "No"  
label define  f32_t0_cl117 1   "Studiava" 2   "Era in servizio militare o in servizio civile sostitutivo" 3   "Lavorava" 4   "Si prendeva cura della casa e/o dei familiari" 5   "In altra condizione"  
label define  f33_t0_cl118 1   "Sì 2   "No"  
label define  f34_t0_cl119 001   "Studia o segue corsi di formazione professionale" 002   "Altri motivi personali" 003   "Maternità, nascita di un figlio 004   "Altri motivi familiari (compreso la casalinga, esclusa la maternità, cura dei figli o di altre persone) 005   "Malattia, problemi di salute personali" 006   "Deve dare un preavviso" 007   "Deve o vuole concludere il lavoro già iniziato 008   "Frequenta uno stage o un tirocinio" 009   "Per prendersi cura dei figli, di bambini e/o di altre persone non autosufficienti" 996   "Altri motivi (specificare)" 997   "Non sa" 998   "Non risponde"  
label define  f35_t0_cl120 1   "In proprio" 2   "Dipendente" 3   "Senza preferenze"  
label define  f36_t0_cl121 1   "A tempo pieno" 2   "Part-time (a tempo parziale)" 3   "Senza preferenze"  
label define  f37_t0_cl122 1   "Sì 2   "No"  
label define  f38_t0_cl123 1   "Sì 2   "No"  
label define  f40_t0_cl124 001   "Sì 002   "No" 997   "Non sa"  
label define  f41_t0_cl125 001   "Soltanto nel comune di residenza" 002   "In altro comune raggiungibile giornalmente" 003   "Ovunque, in Italia" 004   "Ovunque, anche all'estero" 997   "Non sa"  
label define  f44_t0_cl127 1   "Studiava" 2   "Era in servizio di leva o in servizio civile sostitutivo" 3   "Lavorava" 4   "Si prendeva cura dei figli e/o di altri familiari" 5   "In altra condizione"  
label define  f45_t0_cl128 1   "Sì 2   "No"  
label define  f46_t0_cl129 1   "Sì 2   "No"  
label define  f47_t0_cl130 001   "Studia o segue corsi di formazione professionale" 002   "Altri motivi personali" 003   "Maternità, nascita di un figlio 004   "Altri motivi familiari (esclusa la maternità, cura dei figli o di altre persone) 005   "Malattia, problemi di salute personali" 006   "Deve dare un preavviso" 007   "Deve o vuole concludere il lavoro già iniziato 008   "Frequenta uno stage o un tirocinio" 009   "Per prendersi cura dei figli, di bambini e/o di altre persone non autosufficienti" 996   "Altri motivi (specificare)" 997   "Non sa" 998   "Non risponde"  
label define  f48_t0_cl131 1   "In proprio" 2   "Alle dipendenze"  
label define  f49_t0_cl132 001   "Tempo pieno" 002   "Part-time (a tempo parziale)" 997   "Non sa"  
label define  f50_t0_cl133 001   "Sì 002   "No" 997   "Non sa"  
label define  i1_t0_cl134 1   "Occupato" 2   "Disoccupato alla ricerca di nuova occupazione" 3   "In cerca di prima occupazione" 4   "Casalinga/o" 5   "Studente" 6   "Ritirato/a dal lavoro" 7   "Inabile al lavoro" 9   "In altra condizione (specificare)"  
label define  i5_t0_cl135 1   "Occupato" 2   "Disoccupato alla ricerca di nuova occupazione" 3   "In cerca di prima occupazione" 4   "Casalinga/o" 5   "Studente" 6   "Ritirato/a dal lavoro" 7   "Inabile al lavoro" 9   "In altra condizione (specificare)"  
label define  i6_t0_cl136 1   "Un lavoro alle dipendenze" 2   "Un lavoro di: Collaborazione coordinata e continuativa (con o senza progetto)" 3   "Un lavoro di: Prestazione d'opera occasionale" 4   "Un lavoro autonomo come: Imprenditore" 5   "Un lavoro autonomo come: Libero professionista" 6   "Un lavoro autonomo come: Lavoratore in proprio" 7   "Un lavoro autonomo come: Coadiuvante nell'azienda di un familiare" 8   "Un lavoro autonomo come: Socio di cooperativa"  
label define  i7_t0_cl137 1   "Si,  Contratto di lavoro alle dipendenze" 2   "Si,  Contratto di collaborazione coordinata e continuativa (con o senza progetto)" 3   "No"  
label define  i8_t0_cl138 1   "Sì 2   "No"  
label define  i9_t0_cl139 001   "A termine (tempo determinato)" 002   "A tempo indeterminato (senza una scadenza)" 997   "Non sa"  
label define  rip4_t0_cl140 1   "Nord ovest" 2   "Nord est" 3   "Centro" 4   "Mezzogiorno"  
label define  rip3_t0_cl141 1   "Nord" 2   "Centro" 3   "Mezzogiorno"  
label define  cletad_t0_cl142 1   "0-14" 2   "15-24" 3   "25-34" 4   "35-44" 5   "45-54" 6   "55-64" 7   "65-74" 8   "75 e +"  
label define  cletaq_t0_cl143 01   "0-14" 02   "15-19" 03   "20-24" 04   "25-29" 05   "30-34" 06   "35-39" 07   "40-44" 08   "45-49" 09   "50-54" 10   "55-59" 11   "60-64" 12   "65-69" 13   "70-74" 14   "75 e +"  
label define  cittad_t0_cl144 1   "citt. italiano" 2   "citt. straniero UE" 3   "citt. straniero NON UE"  
label define  cond3_t0_cl145 1   "occupati" 2   "persone in cerca" 3   "inattivi"  
label define  cond10_t0_cl146 01   "occupati" 02   "persone in cerca, con precedenti esperienze, ex-occupati" 03   "persone in cerca, con precedenti esperienze, ex-inattivi" 04   "persone in cerca, senza precedenti esperienze" 05   "inattivi in età lav., cercano non attivamente ma disponibili 06   "inattivi in età lav., cercano ma non disponibili 07   "inattivi in età lav., non cercano ma disponibili 08   "inattivi in età lav., non cercano e non disponibili (anche militari di leva e inabili al lavoro) 09   "inattivi in età non lav., meno di 15 anni 10   "inattivi in età non lav., più di 64 ann  
label define  dipaut_t0_cl147 1   "dipendente" 2   "collaboratore" 3   "autonomo"  
label define  dipind_t0_cl148 1   "Dipendente" 2   "Indipendente"  
label define  assocc_t0_cl149 1   "Sì 2   "No"  
label define  pospro_t0_cl150 01   "Dirigente" 02   "Quadro" 03   "Impiegato" 04   "Operaio" 05   "Apprendista" 06   "Lavoratore presso il proprio domicilio per conto di un impresa" 07   "Imprenditore" 08   "Libero professionista" 09   "Lavoratore in proprio" 10   "Socio di cooperativa" 11   "Coadiuvante nell azienda di un familiare" 12   "Collaborazione coordinata e continuativa" 13   "Prestazione d opera occasionale"  
label define  detind_t0_cl151 1   "tempo determinato" 2   "tempo indeterminato"  
label define  piepar_t0_cl152 1   "tempo pieno" 2   "tempo parziale"  
label define  prof1_t0_cl154 1   "LEGISLATORI, IMPRENDITORI E ALTA DIRIGENZA" 2   "PROFESSIONI INTELLETTUALI, SCIENTIFICHE E DI ELEVATA SPECIALIZZAZIONE" 3   "PROFESSIONI TECNICHE" 4   "PROFESSIONI ESECUTIVE NEL LAVORO D'UFFICIO" 5   "PROFESSIONI QUALIFICATE NELLE ATTIVITA' COMMERCIALI E NEI SERVIZI" 6   "ARTIGIANI, OPERAI SPECIALIZZATI E AGRICOLTORI" 7   "CONDUTTORI DI IMPIANTI, OPERAI DI MACCHINARI FISSI E MOBILI E CONDUCENTI DI VEICOLI" 8   "PROFESSIONI NON QUALIFICATE" 9   "FORZE ARMATE"  
label define  ate2d_t0_cl156 01   "coltivazioni agricole e produzione di prodotti animali, caccia e servizi connessi" 02   "silvicoltura ed utilizzo di aree forestali" 03   "pesca e acquacoltura" 05   "estrazione di carbone (esclusa torba)" 06   "estrazione di petrolio greggio e di gas naturale" 07   "estrazione di minerali metalliferi" 08   "altre attività di estrazione di minerali da cave e miniere 09   "attività dei servizi di supporto all'estrazione 10   "industrie alimentari" 11   "industria delle bevande" 12   "industria del tabacco" 13   "industrie tessili" 14   "confezione di articoli di abbigliamento; confezione di articoli in pelle e pelliccia" 15   "fabbricazione di articoli in pelle e simili" 16   "industria del legno e dei prodotti in legno e sughero (esclusi i mobili); fabbricazione di articoli in paglia e materiali da intreccio" 17   "fabbricazione di carta e di prodotti di carta" 18   "stampa e riproduzione di supporti registrati" 19   "fabbricazione di coke e prodotti derivanti dalla raffinazione del petrolio" 20   "fabbricazione di prodotti chimici" 21   "fabbricazione di prodotti farmaceutici di base e di preparati farmaceutici" 22   "fabbricazione di articoli in gomma e materie plastiche" 23   "fabbricazione di altri prodotti della lavorazione di minerali non metalliferi" 24   "metallurgia" 25   "fabbricazione di prodotti in metallo (esclusi macchinari e attrezzature)" 26   "fabbricazione di computer e prodotti di elettronica  e ottica; apparecchi elettromedicali, apparecchi di misurazione e di orologi" 27   "fabbricazione di apparecchiature elettriche ed apparecchiature per uso domestico non elettriche" 28   "fabbricazione di macchinari ed apparecchiature nca" 29   "fabbricazione di autoveicoli, rimorchi e semirimorchi" 30   "fabbricazione di altri mezzi di trasporto" 31   "fabbricazione di mobili" 32   "altre industrie manifatturiere" 33   "riparazione, manutenzione ed installazione di macchine ed apparecchiature" 35   "fornitura di energia elettrica, gas, vapore e aria condizionata" 36   "raccolta, trattamento e fornitura di acqua" 37   "gestione delle reti fognarie" 38   "attività di raccolta, trattamento e smaltimento dei rifiuti; recupero dei materiali 39   "attività di risanamento e altri servizi di gestione dei rifiuti 41   "costruzione di edifici" 42   "ingegneria civile" 43   "lavori di costruzione specializzati" 45   "commercio all'ingrosso e al dettaglio e riparazione di autoveicoli e motocicli" 46   "commercio all'ingrosso (escluso quello di autoveicoli e di motocicli)" 47   "commercio al dettaglio (escluso quello di autoveicoli e di motocicli)" 49   "trasporto terrestre e trasporto mediante condotte" 50   "trasporto marittimo e per vie d'acqua" 51   "trasporto aereo" 52   "magazzinaggio e attività di supporto ai trasporti 53   "servizi postali e attività di corriere 55   "alloggio" 56   "attività dei servizi di ristorazione 58   "attività editoriali 59   "attività di produzione cinematografica, di video e di programmi televisivi, di registrazioni musicali e sonore 60   "attività di programmazione e trasmissione 61   "telecomunicazioni" 62   "produzione di software, consulenza informatica e attività connesse 63   "attività dei servizi d'informazione e altri servizi informatici 64   "attività di servizi finanziari (escluse le assicurazioni e i fondi pensione) 65   "assicurazioni, riassicurazioni e fondi pensione (escluse le assicurazioni sociali obbligatorie)" 66   "attività ausiliarie dei servizi finanziari e delle attività assicurativ 68   "attività immobiliari 69   "attività legali e contabilit 70   "attività di direzione aziendale e di consulenza gestionale 71   "attività degli studi di architettura e d'ingegneria; collaudi ed analisi tecniche 72   "ricerca scientifica e sviluppo" 73   "pubblicità e ricerche di mercato 74   "altre attività professionali, scientifiche e tecniche 75   "servizi veterinari" 77   "attività di noleggio e leasing operativo 78   "attività di ricerca, selezione, fornitura di personale 79   "attività dei servizi delle agenzie di viaggio, dei tour operator e servizi di prenotazione e attività conness 80   "servizi di vigilanza e investigazione" 81   "attività di servizi per edifici e paesaggio 82   "attività di supporto per le funzioni d'ufficio e altri servizi di supporto alle imprese 84   "amministrazione pubblica e difesa; assicurazione sociale obbligatoria" 85   "istruzione" 86   "assistenza sanitaria" 87   "servizi di assistenza sociale residenziale" 88   "assistenza sociale non residenziale" 90   "attività creative, artistiche e di intrattenimento 91   "attività di biblioteche, archivi, musei ed altre attività cultural 92   "attività riguardanti le lotterie, le scommesse, le case da gioco 93   "attività sportive, di intrattenimento e di divertimento 94   "attività di organizzazioni associative 95   "riparazione di computer e di beni per uso personale e per la casa" 96   "altre attività di servizi per la persona 97   "attività di famiglie e convivenze come datori di lavoro per personale domestico 98   "produzione di beni e servizi indifferenziati  per uso proprio da parte di  famiglie e convivenze" 99   "organizzazioni ed organismi extraterritoriali"  
label define  cat12_t0_cl157 01   "Agricoltura, silvicoltura e pesca" 02   "Industria in senso stretto" 03   "Costruzioni" 04   "Commercio" 05   "Alberghi e ristoranti" 06   "Trasporto e magazzinaggio" 07   "Servizi di informazione e comunicazione" 08   "Attività finanziarie e assicurative 09   "Attività immobiliari, servizi alle imprese e altre attività professionali e imprenditorial 10   "Amministrazione pubblica e difesa assicurazione sociale obbligatoria" 11   "Istruzione, sanità ed altri servizi sociali 12   "Altri servizi collettivi e personali"  
label define  cat5_t0_cl158 1   "Agricoltura" 2   "Industria in senso stretto" 3   "Costruzioni" 4   "Commercio" 5   "Altre attività dei servizi  
label define  cat3_t0_cl159 1   "Agricoltura" 2   "Industria" 3   "Servizi"  
label define  lavspe_t0_cl160 1   "Nel comune di residenza" 2   "Altro comune della stessa provincia" 3   "Altra provincia nella stessa regione" 4   "Altra regione" 5   "All estero"  
label define  regspe_t0_cl161 01   "Piemonte" 02   "Valle d'Aosta" 03   "Lombardia" 04   "Trentino alto Adige" 05   "Veneto" 06   "Friuli Venezia Giulia" 07   "Liguria" 08   "Emilia Romagna" 09   "Toscana" 10   "Umbria" 11   "Marche" 12   "Lazio" 13   "Abruzzo" 14   "Molise" 15   "Campania" 16   "Puglia" 17   "Basilicata" 18   "Calabria" 19   "Sicilia" 20   "Sardegna"  
label define  tracom_t0_cl162 001   "Si, da altro comune della stessa provincia" 002   "Si, da altra provincia della stessa regione" 003   "Si, da altra regione" 004   "Si, dall estero" 005   "No" 006   "Si, ma poi è tornato nella provincia di residenza 997   "Non sa"  
label define  regtra_t0_cl163 01   "Piemonte" 02   "Valle d'Aosta" 03   "Lombardia" 04   "Trentino alto Adige" 05   "Veneto" 06   "Friuli Venezia Giulia" 07   "Liguria" 08   "Emilia Romagna" 09   "Toscana" 10   "Umbria" 11   "Marche" 12   "Lazio" 13   "Abruzzo" 14   "Molise" 15   "Campania" 16   "Puglia" 17   "Basilicata" 18   "Calabria" 19   "Sicilia" 20   "Sardegna"  
label define  dipaus_t0_cl164 1   "dipendente" 2   "collaboratore" 3   "autonomo"  
label define  dipins_t0_cl165 1   "Dipendente" 2   "Indipendente"  
label define  prof1s_t0_cl166 1   "LEGISLATORI, IMPRENDITORI E ALTA DIRIGENZA" 2   "PROFESSIONI INTELLETTUALI, SCIENTIFICHE E DI ELEVATA SPECIALIZZAZIONE" 3   "PROFESSIONI TECNICHE" 4   "PROFESSIONI ESECUTIVE NEL LAVORO D'UFFICIO" 5   "PROFESSIONI QUALIFICATE NELLE ATTIVITA' COMMERCIALI E NEI SERVIZI" 6   "ARTIGIANI, OPERAI SPECIALIZZATI E AGRICOLTORI" 7   "CONDUTTORI DI IMPIANTI, OPERAI DI MACCHINARI FISSI E MOBILI E CONDUCENTI DI VEICOLI" 8   "PROFESSIONI NON QUALIFICATE" 9   "FORZE ARMATE"  
label define  ate2ds_t0_cl168 01   "coltivazioni agricole e produzione di prodotti animali, caccia e servizi connessi" 02   "silvicoltura ed utilizzo di aree forestali" 03   "pesca e acquacoltura" 05   "estrazione di carbone (esclusa torba)" 06   "estrazione di petrolio greggio e di gas naturale" 07   "estrazione di minerali metalliferi" 08   "altre attività di estrazione di minerali da cave e miniere 09   "attività dei servizi di supporto all'estrazione 10   "industrie alimentari" 11   "industria delle bevande" 12   "industria del tabacco" 13   "industrie tessili" 14   "confezione di articoli di abbigliamento; confezione di articoli in pelle e pelliccia" 15   "fabbricazione di articoli in pelle e simili" 16   "industria del legno e dei prodotti in legno e sughero (esclusi i mobili); fabbricazione di articoli in paglia e materiali da intreccio" 17   "fabbricazione di carta e di prodotti di carta" 18   "stampa e riproduzione di supporti registrati" 19   "fabbricazione di coke e prodotti derivanti dalla raffinazione del petrolio" 20   "fabbricazione di prodotti chimici" 21   "fabbricazione di prodotti farmaceutici di base e di preparati farmaceutici" 22   "fabbricazione di articoli in gomma e materie plastiche" 23   "fabbricazione di altri prodotti della lavorazione di minerali non metalliferi" 24   "metallurgia" 25   "fabbricazione di prodotti in metallo (esclusi macchinari e attrezzature)" 26   "fabbricazione di computer e prodotti di elettronica  e ottica; apparecchi elettromedicali, apparecchi di misurazione e di orologi" 27   "fabbricazione di apparecchiature elettriche ed apparecchiature per uso domestico non elettriche" 28   "fabbricazione di macchinari ed apparecchiature nca" 29   "fabbricazione di autoveicoli, rimorchi e semirimorchi" 30   "fabbricazione di altri mezzi di trasporto" 31   "fabbricazione di mobili" 32   "altre industrie manifatturiere" 33   "riparazione, manutenzione ed installazione di macchine ed apparecchiature" 35   "fornitura di energia elettrica, gas, vapore e aria condizionata" 36   "raccolta, trattamento e fornitura di acqua" 37   "gestione delle reti fognarie" 38   "attività di raccolta, trattamento e smaltimento dei rifiuti; recupero dei materiali 39   "attività di risanamento e altri servizi di gestione dei rifiuti 41   "costruzione di edifici" 42   "ingegneria civile" 43   "lavori di costruzione specializzati" 45   "commercio all'ingrosso e al dettaglio e riparazione di autoveicoli e motocicli" 46   "commercio all'ingrosso (escluso quello di autoveicoli e di motocicli)" 47   "commercio al dettaglio (escluso quello di autoveicoli e di motocicli)" 49   "trasporto terrestre e trasporto mediante condotte" 50   "trasporto marittimo e per vie d'acqua" 51   "trasporto aereo" 52   "magazzinaggio e attività di supporto ai trasporti 53   "servizi postali e attività di corriere 55   "alloggio" 56   "attività dei servizi di ristorazione 58   "attività editoriali 59   "attività di produzione cinematografica, di video e di programmi televisivi, di registrazioni musicali e sonore 60   "attività di programmazione e trasmissione 61   "telecomunicazioni" 62   "produzione di software, consulenza informatica e attività connesse 63   "attività dei servizi d'informazione e altri servizi informatici 64   "attività di servizi finanziari (escluse le assicurazioni e i fondi pensione) 65   "assicurazioni, riassicurazioni e fondi pensione (escluse le assicurazioni sociali obbligatorie)" 66   "attività ausiliarie dei servizi finanziari e delle attività assicurativ 68   "attività immobiliari 69   "attività legali e contabilit 70   "attività di direzione aziendale e di consulenza gestionale 71   "attività degli studi di architettura e d'ingegneria; collaudi ed analisi tecniche 72   "ricerca scientifica e sviluppo" 73   "pubblicità e ricerche di mercato 74   "altre attività professionali, scientifiche e tecniche 75   "servizi veterinari" 77   "attività di noleggio e leasing operativo 78   "attività di ricerca, selezione, fornitura di personale 79   "attività dei servizi delle agenzie di viaggio, dei tour operator e servizi di prenotazione e attività conness 80   "servizi di vigilanza e investigazione" 81   "attività di servizi per edifici e paesaggio 82   "attività di supporto per le funzioni d'ufficio e altri servizi di supporto alle imprese 84   "amministrazione pubblica e difesa; assicurazione sociale obbligatoria" 85   "istruzione" 86   "assistenza sanitaria" 87   "servizi di assistenza sociale residenziale" 88   "assistenza sociale non residenziale" 90   "attività creative, artistiche e di intrattenimento 91   "attività di biblioteche, archivi, musei ed altre attività cultural 92   "attività riguardanti le lotterie, le scommesse, le case da gioco 93   "attività sportive, di intrattenimento e di divertimento 94   "attività di organizzazioni associative 95   "riparazione di computer e di beni per uso personale e per la casa" 96   "altre attività di servizi per la persona 97   "attività di famiglie e convivenze come datori di lavoro per personale domestico 98   "produzione di beni e servizi indifferenziati  per uso proprio da parte di  famiglie e convivenze" 99   "organizzazioni ed organismi extraterritoriali"  
label define  cat12s_t0_cl169 01   "Agricoltura, silvicoltura e pesca" 02   "Industria in senso stretto" 03   "Costruzioni" 04   "Commercio" 05   "Alberghi e ristoranti" 06   "Trasporto e magazzinaggio" 07   "Servizi di informazione e comunicazione" 08   "Attività finanziarie e assicurative 09   "Attività immobiliari, servizi alle imprese e altre attività professionali e imprenditorial 10   "Amministrazione pubblica e difesa assicurazione sociale obbligatoria" 11   "Istruzione, sanità ed altri servizi sociali 12   "Altri servizi collettivi e personali"  
label define  cat5s_t0_cl170 1   "Agricoltura" 2   "Industria in senso stretto" 3   "Costruzioni" 4   "Commercio" 5   "Altre attività dei servizi  
label define  cat3s_t0_cl171 1   "Agricoltura" 2   "Industria" 3   "Servizi"  
label define  dipaup_t0_cl172 1   "dipendente" 2   "collaboratore" 3   "autonomo"  
label define  dipinp_t0_cl173 1   "Dipendente" 2   "Indipendente"  
label define  ate2dp_t0_cl174 01   "coltivazioni agricole e produzione di prodotti animali, caccia e servizi connessi" 02   "silvicoltura ed utilizzo di aree forestali" 03   "pesca e acquacoltura" 05   "estrazione di carbone (esclusa torba)" 06   "estrazione di petrolio greggio e di gas naturale" 07   "estrazione di minerali metalliferi" 08   "altre attività di estrazione di minerali da cave e miniere 09   "attività dei servizi di supporto all'estrazione 10   "industrie alimentari" 11   "industria delle bevande" 12   "industria del tabacco" 13   "industrie tessili" 14   "confezione di articoli di abbigliamento; confezione di articoli in pelle e pelliccia" 15   "fabbricazione di articoli in pelle e simili" 16   "industria del legno e dei prodotti in legno e sughero (esclusi i mobili); fabbricazione di articoli in paglia e materiali da intreccio" 17   "fabbricazione di carta e di prodotti di carta" 18   "stampa e riproduzione di supporti registrati" 19   "fabbricazione di coke e prodotti derivanti dalla raffinazione del petrolio" 20   "fabbricazione di prodotti chimici" 21   "fabbricazione di prodotti farmaceutici di base e di preparati farmaceutici" 22   "fabbricazione di articoli in gomma e materie plastiche" 23   "fabbricazione di altri prodotti della lavorazione di minerali non metalliferi" 24   "metallurgia" 25   "fabbricazione di prodotti in metallo (esclusi macchinari e attrezzature)" 26   "fabbricazione di computer e prodotti di elettronica  e ottica; apparecchi elettromedicali, apparecchi di misurazione e di orologi" 27   "fabbricazione di apparecchiature elettriche ed apparecchiature per uso domestico non elettriche" 28   "fabbricazione di macchinari ed apparecchiature nca" 29   "fabbricazione di autoveicoli, rimorchi e semirimorchi" 30   "fabbricazione di altri mezzi di trasporto" 31   "fabbricazione di mobili" 32   "altre industrie manifatturiere" 33   "riparazione, manutenzione ed installazione di macchine ed apparecchiature" 35   "fornitura di energia elettrica, gas, vapore e aria condizionata" 36   "raccolta, trattamento e fornitura di acqua" 37   "gestione delle reti fognarie" 38   "attività di raccolta, trattamento e smaltimento dei rifiuti; recupero dei materiali 39   "attività di risanamento e altri servizi di gestione dei rifiuti 41   "costruzione di edifici" 42   "ingegneria civile" 43   "lavori di costruzione specializzati" 45   "commercio all'ingrosso e al dettaglio e riparazione di autoveicoli e motocicli" 46   "commercio all'ingrosso (escluso quello di autoveicoli e di motocicli)" 47   "commercio al dettaglio (escluso quello di autoveicoli e di motocicli)" 49   "trasporto terrestre e trasporto mediante condotte" 50   "trasporto marittimo e per vie d'acqua" 51   "trasporto aereo" 52   "magazzinaggio e attività di supporto ai trasporti 53   "servizi postali e attività di corriere 55   "alloggio" 56   "attività dei servizi di ristorazione 58   "attività editoriali 59   "attività di produzione cinematografica, di video e di programmi televisivi, di registrazioni musicali e sonore 60   "attività di programmazione e trasmissione 61   "telecomunicazioni" 62   "produzione di software, consulenza informatica e attività connesse 63   "attività dei servizi d'informazione e altri servizi informatici 64   "attività di servizi finanziari (escluse le assicurazioni e i fondi pensione) 65   "assicurazioni, riassicurazioni e fondi pensione (escluse le assicurazioni sociali obbligatorie)" 66   "attività ausiliarie dei servizi finanziari e delle attività assicurativ 68   "attività immobiliari 69   "attività legali e contabilit 70   "attività di direzione aziendale e di consulenza gestionale 71   "attività degli studi di architettura e d'ingegneria; collaudi ed analisi tecniche 72   "ricerca scientifica e sviluppo" 73   "pubblicità e ricerche di mercato 74   "altre attività professionali, scientifiche e tecniche 75   "servizi veterinari" 77   "attività di noleggio e leasing operativo 78   "attività di ricerca, selezione, fornitura di personale 79   "attività dei servizi delle agenzie di viaggio, dei tour operator e servizi di prenotazione e attività conness 80   "servizi di vigilanza e investigazione" 81   "attività di servizi per edifici e paesaggio 82   "attività di supporto per le funzioni d'ufficio e altri servizi di supporto alle imprese 84   "amministrazione pubblica e difesa; assicurazione sociale obbligatoria" 85   "istruzione" 86   "assistenza sanitaria" 87   "servizi di assistenza sociale residenziale" 88   "assistenza sociale non residenziale" 90   "attività creative, artistiche e di intrattenimento 91   "attività di biblioteche, archivi, musei ed altre attività cultural 92   "attività riguardanti le lotterie, le scommesse, le case da gioco 93   "attività sportive, di intrattenimento e di divertimento 94   "attività di organizzazioni associative 95   "riparazione di computer e di beni per uso personale e per la casa" 96   "altre attività di servizi per la persona 97   "attività di famiglie e convivenze come datori di lavoro per personale domestico 98   "produzione di beni e servizi indifferenziati  per uso proprio da parte di  famiglie e convivenze" 99   "organizzazioni ed organismi extraterritoriali"  
label define  cat12p_t0_cl175 01   "Agricoltura, silvicoltura e pesca" 02   "Industria in senso stretto" 03   "Costruzioni" 04   "Commercio" 05   "Alberghi e ristoranti" 06   "Trasporto e magazzinaggio" 07   "Servizi di informazione e comunicazione" 08   "Attività finanziarie e assicurative 09   "Attività immobiliari, servizi alle imprese e altre attività professionali e imprenditorial 10   "Amministrazione pubblica e difesa assicurazione sociale obbligatoria" 11   "Istruzione, sanità ed altri servizi sociali 12   "Altri servizi collettivi e personali"  
label define  cat5p_t0_cl176 1   "Agricoltura" 2   "Industria in senso stretto" 3   "Costruzioni" 4   "Commercio" 5   "Altre attività dei servizi  
label define  cat3p_t0_cl177 1   "Agricoltura" 2   "Industria" 3   "Servizi"  
label define  esplav_t0_cl178 1   "ha precedenti esperienze lavorative" 2   "non ha precedenti esperienze lavorative"  
label define  trim_t1_cl181 1   "Primo trimestre" 2   "Secondo trimestre" 3   "Terzo trimestre" 4   "Quarto trimestre"  
label define  sg24_t1_cl183 01   "Nessun titolo" 02   "Licenza elementare / Attestato di valutazione finale" 03   "Licenza media (dall'anno 2007 denominata Diploma di Istruzione secondaria di I grado) o avviamento professionale (conseguito non oltre all'anno 1965)" 04   "Diploma di qualifica professionale di scuola secondaria superiore (di II grado) di 2-3 anni che non permette l'iscrizione all'Università 05   "Diploma di maturità / Diploma di istruzione secondaria superiore (di II grado) di 4-5 anni che permette l'iscrizione all'Universit 06   "Diploma di Accademia (Belle Arti, Nazionale di arte drammatica, Nazionale di Danza), Istituto superiore Industrie artistiche, Conservatorio di musica statale, Istituto di Musica Pareggiato" 07   "Diploma universitario di due/tre anni, Scuola diretta a fini speciali, Scuola parauniversitaria" 08   "Laurea di primo livello (triennale)" 09   "Laurea specialistica / magistrale (biennale)" 10   "Laurea di 4-6 anni: laurea del vecchio ordinamento o laurea specialistica / magistrale a ciclo unico" 13   "Attestato IFP di qualifica professionale triennale (operatore) / Diploma professionale IFP di tecnico (quarto anno) (dal 2005)" 14   "Certificato di specializzazione tecnica superiore  IFTS (dal 2000)" 15   "Diploma di tecnico superiore ITS (corsi biennali) (dal 2013)"  
label define  sg24a_t1_cl184 001   "Diploma (vecchio ordinamento)" 002   "Diploma accademico di alta formazione artistica, musicale e coreutica di I livello" 003   "Diploma accademico di alta formazione artistica, musicale e coreutica di II livello" 997   "Non sa"  
label define  sg24b_t1_cl185 1   "Master universitario di I livello/ Diploma accademico  di perfezionamento o Master di I livello/Diploma accademico di specializzazione di I livello" 2   "Master universitario di II livello/ Diploma accademico di perfezionamento o Master di II livello/Diploma accademico di specializzazione di II livello" 3   "Diploma di specializzazione universitaria" 4   "Dottorato di ricerca/Diploma accademico di formazione alla ricerca AFAM" 5   "Nessuno di questi"  
label define  b1_t1_cl186 1   "Si" 2   "No" 3   "Permanentemente inabile al lavoro"  
label define  b2_t1_cl187 1   "Sì 2   "No"  
label define  b3_t1_cl188 001   "Cassa Integrazione Guadagni (CIG ordinaria o straordinaria)" 002   "Ridotta attività dell'impresa per motivi economici e/o tecnici (esclusa CIG) 004   "Controversia di lavoro" 005   "Maltempo" 006   "Malattia, problemi di salute personali, infortunio" 007   "Ferie" 008   "Festività nella settimana 009   "Orario variabile o flessibile (ad es. riposo compensativo)" 010   "Part-time verticale" 011   "Studio o formazione riconosciuta nell'orario lavorativo" 012   "Assenza obbligatoria per maternità 013   "Assenza facoltativa fino al dodicesimo anno del bambino (congedo parentale)" 014   "Motivi familiari (esclusa maternità obbligatoria e congedo parentale) 015   "Mancanza/scarsità di lavoro 018   "Studio o formazione non riconosciuta nell'orario lavorativo" 994   "Fa un lavoro occasionale" 995   "Fa un lavoro stagionale ALLE DIPENDENZE (ad es. bagnino,  raccoglitore di frutta, cameriere in montagna d'inverno, etc.)" 996   "Altro motivo (specificare)"  
label define  b4_t1_cl189 1   "Un lavoro alle dipendenze" 2   "Un lavoro di: Collaborazione coordinata e continuativa (con o senza progetto)" 3   "Un lavoro di: Prestazione d'opera occasionale" 4   "Un lavoro autonomo come: Imprenditore" 5   "Un lavoro autonomo come: Libero professionista" 6   "Un lavoro autonomo come: Lavoratore in proprio" 7   "Un lavoro autonomo come: Coadiuvante nell'azienda di un familiare" 8   "Un lavoro autonomo come: Socio di cooperativa"  
label define  b4a_t1_cl190 1   "Si,  Contratto di lavoro alle dipendenze" 2   "Si,  Contratto di collaborazione coordinata e continuativa (con o senza progetto)" 3   "No"  
label define  c1_t1_cl191 1   "Un lavoro alle dipendenze" 2   "Un lavoro di: Collaborazione coordinata e continuativa (con o senza progetto)" 3   "Un lavoro di: Prestazione d'opera occasionale" 4   "Un lavoro autonomo come: Imprenditore" 5   "Un lavoro autonomo come: Libero professionista" 6   "Un lavoro autonomo come: Lavoratore in proprio" 7   "Un lavoro autonomo come: Coadiuvante nell'azienda di un familiare" 8   "Un lavoro autonomo come: Socio di cooperativa"  
label define  c1a_t1_cl192 1   "Si,  Contratto di lavoro alle dipendenze" 2   "Si,  Contratto di collaborazione coordinata e continuativa (con o senza progetto)" 3   "No"  
label define  c4_t1_cl193 1   "Sì 2   "No"  
label define  c5_t1_cl194 001   "Per un sola azienda/cliente" 002   "Per più aziende/clienti 997   "Non sa"  
label define  c6_t1_cl195 001   "Decide dove lavorare/lavora presso il proprio ufficio" 002   "Lavora presso l'azienda/cliente/committente" 997   "Non sa"  
label define  c7_t1_cl196 001   "Decide autonomamente l'orario" 002   "Non decide l'orario" 997   "Non sa"  
label define  c9_t1_cl197 1   "Dirigente" 2   "Quadro" 3   "Impiegato" 4   "Operaio" 5   "Apprendista" 6   "Lavoratore presso il proprio domicilio per conto di un'impresa"  
label define  c10_t1_cl198 001   "Sì 002   "No" 997   "Non sa"  
label define  c14_t1_cl199 001   "Solo una sede" 002   "Più sedi 997   "Non sa"  
label define  c18_t1_cl200 1   "Fino a 10 persone" 2   "Da 11 a 15" 3   "Da 16 a 19" 4   "Da 20 a 49" 5   "Da 50 a 249" 6   "250 persone o più 7   "Non sa ma fino a 10" 8   "Non sa ma più di 10  
label define  c20_t1_cl201 1   "A termine (tempo determinato)" 2   "A tempo indeterminato (senza una scadenza)"  
label define  c22_t1_cl203 001   "Per imparare il lavoro (stage, tirocinio e apprendistato)" 002   "Per svolgere un periodo di prova" 003   "È un lavoro stagionale 004   "Il lavoro è per sua natura occasionale, discontinuo o intermittente 005   "Per realizzare un progetto specifico" 006   "Per occupare un posto vacante (comprese supplenze brevi e incarico a termine nella scuola, nella sanità, etc.) 007   "È l'unico che è stato proposto (compreso eventuale lavoro senza contratto e chi dice non c'è una ragione specific 996   "Altro (specificare)" 997   "Non sa"  
label define  c24_t1_cl204 001   "Sì 002   "No" 997   "Non sa"  
label define  c24bis_t1_cl205 001   "Dall'impresa" 002   "Dall'agenzia di somministrazione" 997   "Non sa"  
label define  c24ter_t1_cl206 001   "Sì 002   "No" 997   "Non sa"  
label define  c25_t1_cl207 001   "Non vuole un lavoro a tempo indeterminato" 002   "Non ha trovato un lavoro a tempo indeterminato" 997   "Non sa"  
label define  c27_t1_cl208 1   "A tempo pieno" 2   "A tempo parziale (part-time)"  
label define  c27b_t1_cl209 001   "Part-time orizzontale: lavora tutti i giorni ma meno ore rispetto all'orario normale giornaliero" 002   "Part-time verticale: lavora a tempo pieno ma solo alcuni giorni della settimana, del mese o dell'anno" 003   "Combinazione di part-time orizzontale e verticale" 004   "Part-time occasionale o saltuario" 997   "Non sa"  
label define  c27d_t1_cl210 001   "Alcuni giorni a settimana" 002   "Alcune settimane al mese" 003   "Alcuni mesi all'anno" 996   "Altro (specificare)" 997   "Non sa"  
label define  c28_t1_cl211 001   "Non vuole un lavoro a tempo pieno" 002   "Non ha trovato un lavoro a tempo pieno/non c'è abbastanza lavoro 003   "Altri motivi" 997   "Non sa"  
label define  c29b_t1_cl212 001   "Sì, sono assenti/inadeguati i servizi per la cura di bambini 002   "Sì, sono assenti/inadeguati i servizi per la cura di persone anziane, malate, disabili 003   "Sì, entrambi i servizi sono assenti/inadeguati 004   "No, lavora part-time per altri motivi" 997   "Non sa"  
label define  c32_t1_cl215 001   "Meno del solito" 002   "Piu' del solito" 003   "Come al solito" 997   "Non sa"  
label define  c33_t1_cl216 001   "Orario variabile, flessibile" 002   "Straordinario retribuito e/o non retribuito" 004   "Maggiori impegni di lavoro" 996   "Altro (specificare)"  
label define  c34_t1_cl217 001   "Cassa Integrazione Guadagni (ordinaria o straordinaria)" 002   "Ridotta attività dell'impresa per motivi economici e/o tecnici (esclusa CIG) 004   "Controversia di lavoro" 005   "Maltempo" 006   "Malattia, problemi di salute personali, infortunio" 007   "Ferie" 008   "Festività nella settimana 009   "Orario variabile o flessibile (ad es. riposo compensativo)" 010   "Part-time verticale" 011   "Studio o formazione riconosciuta nell'orario lavorativo" 012   "Assenza obbligatoria per maternità 013   "Assenza facoltativa fino al dodicesimo anno del bambino (congedo parentale)" 014   "Motivi familiari (esclusa maternità obbligatoria e congedo parentale, compreso allattamento) 015   "Mancanza/scarsità di lavoro 016   "Inizio o cambiamento del lavoro nella settimana" 017   "Ha concluso il lavoro nella settimana" 018   "Studio o formazione non riconosciuta nell¿orario lavorativo 994   "Fa un lavoro occasionale" 995   "Fa un lavoro stagionale ALLE DIPENDENZE (ad es. bagnino, raccoglitore di frutta, cameriere in montagna d'inverno etc.)" 996   "Altro (specificare)"  
label define  c35_t1_cl218 001   "Sì 002   "No" 997   "Non sa"  
label define  c38_t1_cl221 001   "Sì, meno ore 002   "Sì, più or 003   "No (avrebbe voluto lavorare lo stesso numero di ore)" 997   "Non sa"  
label define  c39a_t1_cl223 1   "Aggiungendo un nuovo lavoro a quello che ha già 2   "Cambiando lavoro" 3   "Continuando a fare lo stesso lavoro" 4   "In uno qualunque dei modi precedenti"  
label define  c40_t1_cl224 001   "Sì, nella settimana specificata o entro le due settimane successive 002   "No" 997   "Non sa"  
label define  c42_t1_cl225 001   "Sì, 2 o più volte a settiman 002   "Sì, meno di 2 volte a settimana 003   "No" 997   "Non sa"  
label define  c43_t1_cl226 001   "Sì, 2 o più volte a settiman 002   "Sì, meno di 2 volte a settimana 003   "No" 997   "Non sa"  
label define  c44_t1_cl227 001   "Sì, 2 o più volte (nelle 4 settimane 002   "Sì, meno di 2 volte (nelle 4 settimane) 003   "No" 997   "Non sa"  
label define  c45_t1_cl228 001   "Sì, 2 o più volte (nelle 4 settimane 002   "Sì, meno di 2 volte (nelle 4 settimane) 003   "No" 997   "Non sa"  
label define  c46_t1_cl229 001   "Sì 002   "No" 997   "Non sa"  
label define  c47_t1_cl230 001   "Sì 002   "No" 997   "Non sa"  
label define  c48_t1_cl231 001   "Sì, 2 o più volte a settiman 002   "Sì, meno di 2 volte a settimana 003   "No" 997   "Non sa"  
label define  c59_t1_cl232 001   "Sì 002   "No" 997   "Non sa"  
label define  c59ab_t1_cl233 001   "Ha risposto ad annunci (anche on-line) sui giornali, siti specializzati, bacheche ecc." 002   "Si ¿ rivolto direttamente al datore di lavoro 003   "Contattato direttamente dal datore di lavoro" 004   "Attraverso parenti o familiari (rete familiare)" 005   "Concorso pubblico (comprese le graduatorie per gli insegnanti)" 006   "Struttura di intermediazione pubblica diversa da un Centro pubblico per l'impiego" 007   "Agenzia privata di intermediazione (agenzia di somministrazione, ex interinale)" 008   "Segnalazione di una scuola, dell'universit¿, di centri di formazione 009   "Precedenti esperienze (stage, tirocini, lavori di breve durata) nella stessa impresa dove lavora oggi" 010   "Inizio di un'attivit¿ autonoma 011   "Attraverso amici o conoscenti, colleghi o ex colleghi (rete personale)" 996   "Altro aiuto (specificare)" 997   "Non sa"  
label define  c60_t1_cl234 001   "Sì 002   "No" 997   "Non sa"  
label define  d1_t1_cl235 1   "Sì, un altro lavoro 2   "Sì, più di un 3   "No"  
label define  d3_t1_cl237 001   "Regolarmente" 002   "Solo in alcune stagioni (o in particolari periodi dell'anno)" 003   "Ogni tanto, quando capita" 997   "Non sa"  
label define  d4_t1_cl238 1   "Un lavoro alle dipendenze" 2   "Un lavoro di: Collaborazione coordinata e continuativa (con o senza progetto)" 3   "Un lavoro di: Prestazione d'opera occasionale" 4   "Un lavoro autonomo come: Imprenditore" 5   "Un lavoro autonomo come: Libero professionista" 6   "Un lavoro autonomo come: Lavoratore in proprio" 7   "Un lavoro autonomo come: Coadiuvante nell'azienda di un familiare" 8   "Un lavoro autonomo come: Socio di cooperativa"  
label define  d5_t1_cl239 1   "Si,  Contratto di lavoro alle dipendenze" 2   "Si,  Contratto di collaborazione coordinata e continuativa (con o senza progetto)" 3   "No"  
label define  f1_t1_cl240 1   "Sì 2   "No"  
label define  f2_t1_cl241 1   "Un nuovo lavoro" 2   "Un secondo lavoro (da aggiungere a quello attuale)"  
label define  f3_t1_cl242 001   "Lavoro attuale è a termine (lavoro a tempo determinato) 002   "Teme di perdere l'attuale lavoro" 003   "Considera l'attuale lavoro occasionale" 004   "Guadagnare di più 005   "Raggiungere più facilmente il luogo di lavoro 006   "Orario più adatto a prendersi cura dei figli e/o di altri familiari 007   "Orario diverso per altri motivi" 008   "Cerca un lavoro più qualificante per le proprie  capacità/competenze e con maggiori prospettive di carrier 009   "Cerca un lavoro più adatto alle proprie condizioni di salute 996   "Altri motivi (specificare)"  
label define  f4_t1_cl243 001   "Più ore 002   "Meno ore" 003   "Lo stesso numero di ore" 997   "Non sa"  
label define  f5_t1_cl244 1   "Sì 2   "No"  
label define  f6_01_t1_cl245 0   "No" 1   "Si"  
label define  f6_02_t1_cl246 0   "No" 1   "Si"  
label define  f6_03_t1_cl247 0   "No" 1   "Si"  
label define  f6_04_t1_cl248 0   "No" 1   "Si"  
label define  f6_05_t1_cl249 0   "No" 1   "Si"  
label define  f6_06_t1_cl250 0   "No" 1   "Si"  
label define  f6_07_t1_cl251 0   "No" 1   "Si"  
label define  f6_08_t1_cl252 0   "No" 1   "Si"  
label define  f6_09_t1_cl253 0   "No" 1   "Si"  
label define  f6_10_t1_cl254 0   "No" 1   "Si"  
label define  f6_11_t1_cl255 0   "No" 1   "Si"  
label define  f6_12_t1_cl256 0   "No" 1   "Si"  
label define  f6_96_t1_cl257 0   "No" 1   "Si"  
label define  f6a_01_t1_cl258 0   "No" 1   "Si"  
label define  f6a_02_t1_cl259 0   "No" 1   "Si"  
label define  f6a_03_t1_cl260 0   "No" 1   "Si"  
label define  f6a_96_t1_cl261 0   "No" 1   "Si"  
label define  f7_t1_cl262 1   "Sì 2   "No"  
label define  f8_t1_cl263 1   "Sì 2   "No"  
label define  f10_t1_cl264 001   "Ha già un lavoro che inizierà in futur 002   "Studia o segue corsi di formazione professionale" 003   "Malattia, problemi di salute personali" 004   "Per prendersi cura dei figli, di bambini e/o di altre  persone non autosufficenti" 005   "In attesa di tornare al suo posto di lavoro" 007   "Pensione da lavoro (anzianità o vecchiaia) 008   "Ritiene di non riuscire a trovare lavoro" 009   "Non gli interessa/non ne ha bisogno (anche per motivi di età) 010   "Sta aspettando gli esiti di passate azioni di ricerca" 011   "Permanentemente inabile al lavoro" 012   "Maternità, nascita di un figlio 013   "Altri motivi familiari (compreso fa la casalinga, esclusa maternità, cura dei figli o di altre persone) 014   "È in attesa di iniziare a ricevere la pensione 996   "Altri motivi (specificare)" 997   "Non sa"  
label define  f10a_t1_cl265 001   "Sì, sono assenti/inadeguati i servizi per la cura di bambini 002   "Sì, sono assenti/inadeguati i servizi per la cura di persone anziane, malate, disabili 003   "Sì, entrambi i servizi sono assenti/inadeguati 004   "No, non ha cercato lavoro per altri motivi" 997   "Non sa"  
label define  f12_t1_cl266 1   "Sì 2   "No"  
label define  f13_t1_cl267 1   "Sì 2   "No"  
label define  f14_t1_cl268 001   "Studia o segue corsi di formazione professionale" 002   "Altri motivi personali" 003   "Maternità, nascita di un figlio 004   "Altri motivi familiari (compreso la casalinga, esclusa la maternità, cura dei figli o di altre persone) 005   "Malattia, problemi di salute personali" 006   "Deve dare un preavviso" 007   "Deve o vuole concludere il lavoro già iniziato 008   "Frequenta uno stage o un tirocinio" 009   "Per prendersi cura dei figli, di bambini e/o di altre persone non autosufficienti" 996   "Altri motivi (specificare)" 997   "Non sa" 998   "Non risponde"  
label define  f16_t1_cl269 1   "Sì 2   "No"  
label define  f17_t1_cl270 1   "Sì 2   "No"  
label define  f18_t1_cl271 1   "Sì 2   "No"  
label define  f19_t1_cl272 1   "Sì 2   "No"  
label define  f20_t1_cl273 1   "Sì 2   "No"  
label define  f21_t1_cl274 1   "Sì 2   "No"  
label define  f22_t1_cl275 1   "Sì 2   "No"  
label define  f23_t1_cl276 1   "Sì 2   "No"  
label define  f24_t1_cl277 1   "Sì 2   "No"  
label define  f24a_01_t1_cl278 0   "No" 1   "Si"  
label define  f24a_02_t1_cl279 0   "No" 1   "Si"  
label define  f24a_03_t1_cl280 0   "No" 1   "Si"  
label define  f24a_96_t1_cl281 0   "No" 1   "Si"  
label define  f25_t1_cl282 1   "Sì 2   "No"  
label define  f26_t1_cl283 1   "Sì 2   "No"  
label define  f27_t1_cl284 1   "Sì 2   "No"  
label define  f28_t1_cl285 1   "Si (specificare)" 2   "No"  
label define  f29_01_t1_cl286 0   "No" 1   "Si"  
label define  f29_02_t1_cl287 0   "No" 1   "Si"  
label define  f29_03_t1_cl288 0   "No" 1   "Si"  
label define  f29_04_t1_cl289 0   "No" 1   "Si"  
label define  f29_97_t1_cl290 0   "No" 1   "Si"  
label define  f30_t1_cl291 1   "Sì 2   "No"  
label define  f33_t1_cl292 1   "Sì 2   "No"  
label define  f34_t1_cl293 001   "Studia o segue corsi di formazione professionale" 002   "Altri motivi personali" 003   "Maternità, nascita di un figlio 004   "Altri motivi familiari (compreso la casalinga, esclusa la maternità, cura dei figli o di altre persone) 005   "Malattia, problemi di salute personali" 006   "Deve dare un preavviso" 007   "Deve o vuole concludere il lavoro già iniziato 008   "Frequenta uno stage o un tirocinio" 009   "Per prendersi cura dei figli, di bambini e/o di altre persone non autosufficienti" 996   "Altri motivi (specificare)" 997   "Non sa" 998   "Non risponde"  
label define  f35_t1_cl294 1   "In proprio" 2   "Dipendente" 3   "Senza preferenze"  
label define  f36_t1_cl295 1   "A tempo pieno" 2   "Part-time (a tempo parziale)" 3   "Senza preferenze"  
label define  f37_t1_cl296 1   "Sì 2   "No"  
label define  f38_t1_cl297 1   "Sì 2   "No"  
label define  f40_t1_cl298 001   "Sì 002   "No" 997   "Non sa"  
label define  f41_t1_cl299 001   "Soltanto nel comune di residenza" 002   "In altro comune raggiungibile giornalmente" 003   "Ovunque, in Italia" 004   "Ovunque, anche all'estero" 997   "Non sa"  
label define  f45_t1_cl300 1   "Sì 2   "No"  
label define  f46_t1_cl301 1   "Sì 2   "No"  
label define  f47_t1_cl302 001   "Studia o segue corsi di formazione professionale" 002   "Altri motivi personali" 003   "Maternità, nascita di un figlio 004   "Altri motivi familiari (compreso la casalinga, esclusa la maternità, cura dei figli o di altre persone) 005   "Malattia, problemi di salute personali" 006   "Deve dare un preavviso" 007   "Deve o vuole concludere il lavoro già iniziato 008   "Frequenta uno stage o un tirocinio" 009   "Per prendersi cura dei figli, di bambini e/o di altre persone non autosufficienti" 996   "Altri motivi (specificare)" 997   "Non sa" 998   "Non risponde"  
label define  f48_t1_cl303 1   "In proprio" 2   "Alle dipendenze"  
label define  f49_t1_cl304 001   "Tempo pieno" 002   "Part-time (a tempo parziale)" 997   "Non sa"  
label define  f50_t1_cl305 001   "Sì 002   "No" 997   "Non sa"  
label define  i1_t1_cl306 1   "Occupato" 2   "Disoccupato alla ricerca di NUOVA occupazione" 3   "Disoccupato in cerca di PRIMA occupazione" 4   "Casalinga/o" 5   "Studente" 6   "Ritirato dal lavoro" 7   "Inabile al lavoro" 9   "In altra condizione (specificare)"  
label define  cond3_t1_cl307 1   "occupati" 2   "persone in cerca" 3   "inattivi"  
label define  cond10_t1_cl308 01   "occupati" 02   "persone in cerca, con precedenti esperienze, ex-occupati" 03   "persone in cerca, con precedenti esperienze, ex-inattivi" 04   "persone in cerca, senza precedenti esperienze" 05   "inattivi in età lav., cercano non attivamente ma disponibili 06   "inattivi in età lav., cercano ma non disponibili 07   "inattivi in età lav., non cercano ma disponibili 08   "inattivi in età lav., non cercano e non disponibili (anche militari di leva e inabili al lavoro) 09   "inattivi in età non lav., meno di 15 anni 10   "inattivi in età non lav., più di 64 ann  
label define  dipaut_t1_cl309 1   "dipendente" 2   "collaboratore" 3   "autonomo"  
label define  dipind_t1_cl310 1   "Dipendente" 2   "Indipendente"  
label define  assocc_t1_cl311 1   "Sì 2   "No"  
label define  pospro_t1_cl312 01   "Dirigente" 02   "Quadro" 03   "Impiegato" 04   "Operaio" 05   "Apprendista" 06   "Lavoratore presso il proprio domicilio per conto di un impresa" 07   "Imprenditore" 08   "Libero professionista" 09   "Lavoratore in proprio" 10   "Socio di cooperativa" 11   "Coadiuvante nell azienda di un familiare" 12   "Collaborazione coordinata e continuativa" 13   "Prestazione d opera occasionale"  
label define  detind_t1_cl313 1   "tempo determinato" 2   "tempo indeterminato"  
label define  piepar_t1_cl314 1   "tempo pieno" 2   "tempo parziale"  
label define  prof1_t1_cl316 1   "LEGISLATORI, IMPRENDITORI E ALTA DIRIGENZA" 2   "PROFESSIONI INTELLETTUALI, SCIENTIFICHE E DI ELEVATA SPECIALIZZAZIONE" 3   "PROFESSIONI TECNICHE" 4   "PROFESSIONI ESECUTIVE NEL LAVORO D'UFFICIO" 5   "PROFESSIONI QUALIFICATE NELLE ATTIVITA' COMMERCIALI E NEI SERVIZI" 6   "ARTIGIANI, OPERAI SPECIALIZZATI E AGRICOLTORI" 7   "CONDUTTORI DI IMPIANTI, OPERAI DI MACCHINARI FISSI E MOBILI E CONDUCENTI DI VEICOLI" 8   "PROFESSIONI NON QUALIFICATE" 9   "FORZE ARMATE"  
label define  ate2d_t1_cl318 01   "coltivazioni agricole e produzione di prodotti animali, caccia e servizi connessi" 02   "silvicoltura ed utilizzo di aree forestali" 03   "pesca e acquacoltura" 05   "estrazione di carbone (esclusa torba)" 06   "estrazione di petrolio greggio e di gas naturale" 07   "estrazione di minerali metalliferi" 08   "altre attività di estrazione di minerali da cave e miniere 09   "attività dei servizi di supporto all'estrazione 10   "industrie alimentari" 11   "industria delle bevande" 12   "industria del tabacco" 13   "industrie tessili" 14   "confezione di articoli di abbigliamento; confezione di articoli in pelle e pelliccia" 15   "fabbricazione di articoli in pelle e simili" 16   "industria del legno e dei prodotti in legno e sughero (esclusi i mobili); fabbricazione di articoli in paglia e materiali da intreccio" 17   "fabbricazione di carta e di prodotti di carta" 18   "stampa e riproduzione di supporti registrati" 19   "fabbricazione di coke e prodotti derivanti dalla raffinazione del petrolio" 20   "fabbricazione di prodotti chimici" 21   "fabbricazione di prodotti farmaceutici di base e di preparati farmaceutici" 22   "fabbricazione di articoli in gomma e materie plastiche" 23   "fabbricazione di altri prodotti della lavorazione di minerali non metalliferi" 24   "metallurgia" 25   "fabbricazione di prodotti in metallo (esclusi macchinari e attrezzature)" 26   "fabbricazione di computer e prodotti di elettronica  e ottica; apparecchi elettromedicali, apparecchi di misurazione e di orologi" 27   "fabbricazione di apparecchiature elettriche ed apparecchiature per uso domestico non elettriche" 28   "fabbricazione di macchinari ed apparecchiature nca" 29   "fabbricazione di autoveicoli, rimorchi e semirimorchi" 30   "fabbricazione di altri mezzi di trasporto" 31   "fabbricazione di mobili" 32   "altre industrie manifatturiere" 33   "riparazione, manutenzione ed installazione di macchine ed apparecchiature" 35   "fornitura di energia elettrica, gas, vapore e aria condizionata" 36   "raccolta, trattamento e fornitura di acqua" 37   "gestione delle reti fognarie" 38   "attività di raccolta, trattamento e smaltimento dei rifiuti; recupero dei materiali 39   "attività di risanamento e altri servizi di gestione dei rifiuti 41   "costruzione di edifici" 42   "ingegneria civile" 43   "lavori di costruzione specializzati" 45   "commercio all'ingrosso e al dettaglio e riparazione di autoveicoli e motocicli" 46   "commercio all'ingrosso (escluso quello di autoveicoli e di motocicli)" 47   "commercio al dettaglio (escluso quello di autoveicoli e di motocicli)" 49   "trasporto terrestre e trasporto mediante condotte" 50   "trasporto marittimo e per vie d'acqua" 51   "trasporto aereo" 52   "magazzinaggio e attività di supporto ai trasporti 53   "servizi postali e attività di corriere 55   "alloggio" 56   "attività dei servizi di ristorazione 58   "attività editoriali 59   "attività di produzione cinematografica, di video e di programmi televisivi, di registrazioni musicali e sonore 60   "attività di programmazione e trasmissione 61   "telecomunicazioni" 62   "produzione di software, consulenza informatica e attività connesse 63   "attività dei servizi d'informazione e altri servizi informatici 64   "attività di servizi finanziari (escluse le assicurazioni e i fondi pensione) 65   "assicurazioni, riassicurazioni e fondi pensione (escluse le assicurazioni sociali obbligatorie)" 66   "attività ausiliarie dei servizi finanziari e delle attività assicurativ 68   "attività immobiliari 69   "attività legali e contabilit 70   "attività di direzione aziendale e di consulenza gestionale 71   "attività degli studi di architettura e d'ingegneria; collaudi ed analisi tecniche 72   "ricerca scientifica e sviluppo" 73   "pubblicità e ricerche di mercato 74   "altre attività professionali, scientifiche e tecniche 75   "servizi veterinari" 77   "attività di noleggio e leasing operativo 78   "attività di ricerca, selezione, fornitura di personale 79   "attività dei servizi delle agenzie di viaggio, dei tour operator e servizi di prenotazione e attività conness 80   "servizi di vigilanza e investigazione" 81   "attività di servizi per edifici e paesaggio 82   "attività di supporto per le funzioni d'ufficio e altri servizi di supporto alle imprese 84   "amministrazione pubblica e difesa; assicurazione sociale obbligatoria" 85   "istruzione" 86   "assistenza sanitaria" 87   "servizi di assistenza sociale residenziale" 88   "assistenza sociale non residenziale" 90   "attività creative, artistiche e di intrattenimento 91   "attività di biblioteche, archivi, musei ed altre attività cultural 92   "attività riguardanti le lotterie, le scommesse, le case da gioco 93   "attività sportive, di intrattenimento e di divertimento 94   "attività di organizzazioni associative 95   "riparazione di computer e di beni per uso personale e per la casa" 96   "altre attività di servizi per la persona 97   "attività di famiglie e convivenze come datori di lavoro per personale domestico 98   "produzione di beni e servizi indifferenziati  per uso proprio da parte di  famiglie e convivenze" 99   "organizzazioni ed organismi extraterritoriali"  
label define  cat12_t1_cl319 01   "Agricoltura, silvicoltura e pesca" 02   "Industria in senso stretto" 03   "Costruzioni" 04   "Commercio" 05   "Alberghi e ristoranti" 06   "Trasporto e magazzinaggio" 07   "Servizi di informazione e comunicazione" 08   "Attività finanziarie e assicurative 09   "Attività immobiliari, servizi alle imprese e altre attività professionali e imprenditorial 10   "Amministrazione pubblica e difesa assicurazione sociale obbligatoria" 11   "Istruzione, sanità ed altri servizi sociali 12   "Altri servizi collettivi e personali"  
label define  cat5_t1_cl320 1   "Agricoltura" 2   "Industria in senso stretto" 3   "Costruzioni" 4   "Commercio" 5   "Altre attività dei servizi  
label define  cat3_t1_cl321 1   "Agricoltura" 2   "Industria" 3   "Servizi"  
label define  lavspe_t1_cl322 1   "Nel comune di residenza" 2   "Altro comune della stessa provincia" 3   "Altra provincia nella stessa regione" 4   "Altra regione" 5   "All estero"  
label define  regspe_t1_cl323 01   "Piemonte" 02   "Valle d'Aosta" 03   "Lombardia" 04   "Trentino alto Adige" 05   "Veneto" 06   "Friuli Venezia Giulia" 07   "Liguria" 08   "Emilia Romagna" 09   "Toscana" 10   "Umbria" 11   "Marche" 12   "Lazio" 13   "Abruzzo" 14   "Molise" 15   "Campania" 16   "Puglia" 17   "Basilicata" 18   "Calabria" 19   "Sicilia" 20   "Sardegna"  
label define  dipaus_t1_cl324 1   "dipendente" 2   "collaboratore" 3   "autonomo"  
label define  dipins_t1_cl325 1   "Dipendente" 2   "Indipendente"  
label define  prof1s_t1_cl326 1   "LEGISLATORI, IMPRENDITORI E ALTA DIRIGENZA" 2   "PROFESSIONI INTELLETTUALI, SCIENTIFICHE E DI ELEVATA SPECIALIZZAZIONE" 3   "PROFESSIONI TECNICHE" 4   "PROFESSIONI ESECUTIVE NEL LAVORO D'UFFICIO" 5   "PROFESSIONI QUALIFICATE NELLE ATTIVITA' COMMERCIALI E NEI SERVIZI" 6   "ARTIGIANI, OPERAI SPECIALIZZATI E AGRICOLTORI" 7   "CONDUTTORI DI IMPIANTI, OPERAI DI MACCHINARI FISSI E MOBILI E CONDUCENTI DI VEICOLI" 8   "PROFESSIONI NON QUALIFICATE" 9   "FORZE ARMATE"  
label define  ate2ds_t1_cl328 01   "coltivazioni agricole e produzione di prodotti animali, caccia e servizi connessi" 02   "silvicoltura ed utilizzo di aree forestali" 03   "pesca e acquacoltura" 05   "estrazione di carbone (esclusa torba)" 06   "estrazione di petrolio greggio e di gas naturale" 07   "estrazione di minerali metalliferi" 08   "altre attività di estrazione di minerali da cave e miniere 09   "attività dei servizi di supporto all'estrazione 10   "industrie alimentari" 11   "industria delle bevande" 12   "industria del tabacco" 13   "industrie tessili" 14   "confezione di articoli di abbigliamento; confezione di articoli in pelle e pelliccia" 15   "fabbricazione di articoli in pelle e simili" 16   "industria del legno e dei prodotti in legno e sughero (esclusi i mobili); fabbricazione di articoli in paglia e materiali da intreccio" 17   "fabbricazione di carta e di prodotti di carta" 18   "stampa e riproduzione di supporti registrati" 19   "fabbricazione di coke e prodotti derivanti dalla raffinazione del petrolio" 20   "fabbricazione di prodotti chimici" 21   "fabbricazione di prodotti farmaceutici di base e di preparati farmaceutici" 22   "fabbricazione di articoli in gomma e materie plastiche" 23   "fabbricazione di altri prodotti della lavorazione di minerali non metalliferi" 24   "metallurgia" 25   "fabbricazione di prodotti in metallo (esclusi macchinari e attrezzature)" 26   "fabbricazione di computer e prodotti di elettronica  e ottica; apparecchi elettromedicali, apparecchi di misurazione e di orologi" 27   "fabbricazione di apparecchiature elettriche ed apparecchiature per uso domestico non elettriche" 28   "fabbricazione di macchinari ed apparecchiature nca" 29   "fabbricazione di autoveicoli, rimorchi e semirimorchi" 30   "fabbricazione di altri mezzi di trasporto" 31   "fabbricazione di mobili" 32   "altre industrie manifatturiere" 33   "riparazione, manutenzione ed installazione di macchine ed apparecchiature" 35   "fornitura di energia elettrica, gas, vapore e aria condizionata" 36   "raccolta, trattamento e fornitura di acqua" 37   "gestione delle reti fognarie" 38   "attività di raccolta, trattamento e smaltimento dei rifiuti; recupero dei materiali 39   "attività di risanamento e altri servizi di gestione dei rifiuti 41   "costruzione di edifici" 42   "ingegneria civile" 43   "lavori di costruzione specializzati" 45   "commercio all'ingrosso e al dettaglio e riparazione di autoveicoli e motocicli" 46   "commercio all'ingrosso (escluso quello di autoveicoli e di motocicli)" 47   "commercio al dettaglio (escluso quello di autoveicoli e di motocicli)" 49   "trasporto terrestre e trasporto mediante condotte" 50   "trasporto marittimo e per vie d'acqua" 51   "trasporto aereo" 52   "magazzinaggio e attività di supporto ai trasporti 53   "servizi postali e attività di corriere 55   "alloggio" 56   "attività dei servizi di ristorazione 58   "attività editoriali 59   "attività di produzione cinematografica, di video e di programmi televisivi, di registrazioni musicali e sonore 60   "attività di programmazione e trasmissione 61   "telecomunicazioni" 62   "produzione di software, consulenza informatica e attività connesse 63   "attività dei servizi d'informazione e altri servizi informatici 64   "attività di servizi finanziari (escluse le assicurazioni e i fondi pensione) 65   "assicurazioni, riassicurazioni e fondi pensione (escluse le assicurazioni sociali obbligatorie)" 66   "attività ausiliarie dei servizi finanziari e delle attività assicurativ 68   "attività immobiliari 69   "attività legali e contabilit 70   "attività di direzione aziendale e di consulenza gestionale 71   "attività degli studi di architettura e d'ingegneria; collaudi ed analisi tecniche 72   "ricerca scientifica e sviluppo" 73   "pubblicità e ricerche di mercato 74   "altre attività professionali, scientifiche e tecniche 75   "servizi veterinari" 77   "attività di noleggio e leasing operativo 78   "attività di ricerca, selezione, fornitura di personale 79   "attività dei servizi delle agenzie di viaggio, dei tour operator e servizi di prenotazione e attività conness 80   "servizi di vigilanza e investigazione" 81   "attività di servizi per edifici e paesaggio 82   "attività di supporto per le funzioni d'ufficio e altri servizi di supporto alle imprese 84   "amministrazione pubblica e difesa; assicurazione sociale obbligatoria" 85   "istruzione" 86   "assistenza sanitaria" 87   "servizi di assistenza sociale residenziale" 88   "assistenza sociale non residenziale" 90   "attività creative, artistiche e di intrattenimento 91   "attività di biblioteche, archivi, musei ed altre attività cultural 92   "attività riguardanti le lotterie, le scommesse, le case da gioco 93   "attività sportive, di intrattenimento e di divertimento 94   "attività di organizzazioni associative 95   "riparazione di computer e di beni per uso personale e per la casa" 96   "altre attività di servizi per la persona 97   "attività di famiglie e convivenze come datori di lavoro per personale domestico 98   "produzione di beni e servizi indifferenziati  per uso proprio da parte di  famiglie e convivenze" 99   "organizzazioni ed organismi extraterritoriali"  
label define  cat12s_t1_cl329 01   "Agricoltura, silvicoltura e pesca" 02   "Industria in senso stretto" 03   "Costruzioni" 04   "Commercio" 05   "Alberghi e ristoranti" 06   "Trasporto e magazzinaggio" 07   "Servizi di informazione e comunicazione" 08   "Attività finanziarie e assicurative 09   "Attività immobiliari, servizi alle imprese e altre attività professionali e imprenditorial 10   "Amministrazione pubblica e difesa assicurazione sociale obbligatoria" 11   "Istruzione, sanità ed altri servizi sociali 12   "Altri servizi collettivi e personali"  
label define  cat5s_t1_cl330 1   "Agricoltura" 2   "Industria in senso stretto" 3   "Costruzioni" 4   "Commercio" 5   "Altre attività dei servizi  
label define  cat3s_t1_cl331 1   "Agricoltura" 2   "Industria" 3   "Servizi"  
label define  esplav_t1_cl332 1   "ha precedenti esperienze lavorative" 2   "non ha precedenti esperienze lavorative"  
label define  motipt_t1_cl333 1   "Studia o segue corsi di formazione professionale" 2   "Malattia, problemi di salute personali" 3   "Per prendersi cura dei figli, di bambini e/o di altre persone non autosufficienti" 4   "Svolge un secondo lavoro" 5   "Altri motivi familiari (esclusa cura dei figli o di altre persone)" 6   "Avere a disposizione pi¿ tempo libero 7   "¿ in pensione e svolge qualche attivit 8   "Altri motivi"  
label values  trim_t0 trim_t0_cl1
label values  reg_t0 reg_t0_cl2
label values  sg11_t0 sg11_t0_cl4
label values  sg13_t0 sg13_t0_cl5
label values  sg16_t0 sg16_t0_cl6
label values  sg24_t0 sg24_t0_cl7
label values  sg24a_t0 sg24a_t0_cl8
label values  sg24b_t0 sg24b_t0_cl9
label values  b1_t0 b1_t0_cl10
label values  b2_t0 b2_t0_cl11
label values  b3_t0 b3_t0_cl12
label values  b4_t0 b4_t0_cl13
label values  b4a_t0 b4a_t0_cl14
label values  c1_t0 c1_t0_cl15
label values  c1a_t0 c1a_t0_cl16
label values  c4_t0 c4_t0_cl17
label values  c5_t0 c5_t0_cl18
label values  c6_t0 c6_t0_cl19
label values  c7_t0 c7_t0_cl20
label values  c9_t0 c9_t0_cl21
label values  c10_t0 c10_t0_cl22
label values  c14_t0 c14_t0_cl23
label values  c18_t0 c18_t0_cl24
label values  c20_t0 c20_t0_cl25
label values  c22_t0 c22_t0_cl27
label values  c24_t0 c24_t0_cl28
label values  c24bis_t0 c24bis_t0_cl29
label values  c24ter_t0 c24ter_t0_cl30
label values  c25_t0 c25_t0_cl31
label values  c27_t0 c27_t0_cl32
label values  c27b_t0 c27b_t0_cl33
label values  c27d_t0 c27d_t0_cl34
label values  c28_t0 c28_t0_cl35
label values  c29b_t0 c29b_t0_cl36
label values  c32_t0 c32_t0_cl39
label values  c33_t0 c33_t0_cl40
label values  c34_t0 c34_t0_cl41
label values  c35_t0 c35_t0_cl42
label values  c38_t0 c38_t0_cl45
label values  c39a_t0 c39a_t0_cl47
label values  c40_t0 c40_t0_cl48
label values  c42_t0 c42_t0_cl49
label values  c43_t0 c43_t0_cl50
label values  c44_t0 c44_t0_cl51
label values  c45_t0 c45_t0_cl52
label values  c46_t0 c46_t0_cl53
label values  c47_t0 c47_t0_cl54
label values  c48_t0 c48_t0_cl55
label values  c53_t0 c53_t0_cl56
label values  c59_t0 c59_t0_cl57
label values  c60_t0 c60_t0_cl58
label values  d1_t0 d1_t0_cl59
label values  d3_t0 d3_t0_cl61
label values  d4_t0 d4_t0_cl62
label values  d5_t0 d5_t0_cl63
label values  f1_t0 f1_t0_cl64
label values  f2_t0 f2_t0_cl65
label values  f3_t0 f3_t0_cl66
label values  f4_t0 f4_t0_cl67
label values  f5_t0 f5_t0_cl68
label values  f6_01_t0 f6_01_t0_cl69
label values  f6_02_t0 f6_02_t0_cl70
label values  f6_03_t0 f6_03_t0_cl71
label values  f6_04_t0 f6_04_t0_cl72
label values  f6_05_t0 f6_05_t0_cl73
label values  f6_06_t0 f6_06_t0_cl74
label values  f6_07_t0 f6_07_t0_cl75
label values  f6_08_t0 f6_08_t0_cl76
label values  f6_09_t0 f6_09_t0_cl77
label values  f6_10_t0 f6_10_t0_cl78
label values  f6_11_t0 f6_11_t0_cl79
label values  f6_12_t0 f6_12_t0_cl80
label values  f6_96_t0 f6_96_t0_cl81
label values  f6a_01_t0 f6a_01_t0_cl82
label values  f6a_02_t0 f6a_02_t0_cl83
label values  f6a_03_t0 f6a_03_t0_cl84
label values  f6a_96_t0 f6a_96_t0_cl85
label values  f7_t0 f7_t0_cl86
label values  f8_t0 f8_t0_cl87
label values  f10_t0 f10_t0_cl88
label values  f10a_t0 f10a_t0_cl89
label values  f12_t0 f12_t0_cl90
label values  f13_t0 f13_t0_cl91
label values  f14_t0 f14_t0_cl92
label values  f16_t0 f16_t0_cl93
label values  f17_t0 f17_t0_cl94
label values  f18_t0 f18_t0_cl95
label values  f19_t0 f19_t0_cl96
label values  f20_t0 f20_t0_cl97
label values  f21_t0 f21_t0_cl98
label values  f22_t0 f22_t0_cl99
label values  f23_t0 f23_t0_cl100
label values  f24_t0 f24_t0_cl101
label values  f24a_01_t0 f24a_01_t0_cl102
label values  f24a_02_t0 f24a_02_t0_cl103
label values  f24a_03_t0 f24a_03_t0_cl104
label values  f24a_96_t0 f24a_96_t0_cl105
label values  f25_t0 f25_t0_cl106
label values  f26_t0 f26_t0_cl107
label values  f27_t0 f27_t0_cl108
label values  f28_t0 f28_t0_cl109
label values  f29_01_t0 f29_01_t0_cl110
label values  f29_02_t0 f29_02_t0_cl111
label values  f29_03_t0 f29_03_t0_cl112
label values  f29_04_t0 f29_04_t0_cl113
label values  f29_97_t0 f29_97_t0_cl114
label values  f30_t0 f30_t0_cl115
label values  f32_t0 f32_t0_cl117
label values  f33_t0 f33_t0_cl118
label values  f34_t0 f34_t0_cl119
label values  f35_t0 f35_t0_cl120
label values  f36_t0 f36_t0_cl121
label values  f37_t0 f37_t0_cl122
label values  f38_t0 f38_t0_cl123
label values  f40_t0 f40_t0_cl124
label values  f41_t0 f41_t0_cl125
label values  f44_t0 f44_t0_cl127
label values  f45_t0 f45_t0_cl128
label values  f46_t0 f46_t0_cl129
label values  f47_t0 f47_t0_cl130
label values  f48_t0 f48_t0_cl131
label values  f49_t0 f49_t0_cl132
label values  f50_t0 f50_t0_cl133
label values  i1_t0 i1_t0_cl134
label values  i5_t0 i5_t0_cl135
label values  i6_t0 i6_t0_cl136
label values  i7_t0 i7_t0_cl137
label values  i8_t0 i8_t0_cl138
label values  i9_t0 i9_t0_cl139
label values  rip4_t0 rip4_t0_cl140
label values  rip3_t0 rip3_t0_cl141
label values  cletad_t0 cletad_t0_cl142
label values  cletaq_t0 cletaq_t0_cl143
label values  cittad_t0 cittad_t0_cl144
label values  cond3_t0 cond3_t0_cl145
label values  cond10_t0 cond10_t0_cl146
label values  dipaut_t0 dipaut_t0_cl147
label values  dipind_t0 dipind_t0_cl148
label values  assocc_t0 assocc_t0_cl149
label values  pospro_t0 pospro_t0_cl150
label values  detind_t0 detind_t0_cl151
label values  piepar_t0 piepar_t0_cl152
label values  prof1_t0 prof1_t0_cl154
label values  ate2d_t0 ate2d_t0_cl156
label values  cat12_t0 cat12_t0_cl157
label values  cat5_t0 cat5_t0_cl158
label values  cat3_t0 cat3_t0_cl159
label values  lavspe_t0 lavspe_t0_cl160
label values  regspe_t0 regspe_t0_cl161
label values  tracom_t0 tracom_t0_cl162
label values  regtra_t0 regtra_t0_cl163
label values  dipaus_t0 dipaus_t0_cl164
label values  dipins_t0 dipins_t0_cl165
label values  prof1s_t0 prof1s_t0_cl166
label values  ate2ds_t0 ate2ds_t0_cl168
label values  cat12s_t0 cat12s_t0_cl169
label values  cat5s_t0 cat5s_t0_cl170
label values  cat3s_t0 cat3s_t0_cl171
label values  dipaup_t0 dipaup_t0_cl172
label values  dipinp_t0 dipinp_t0_cl173
label values  ate2dp_t0 ate2dp_t0_cl174
label values  cat12p_t0 cat12p_t0_cl175
label values  cat5p_t0 cat5p_t0_cl176
label values  cat3p_t0 cat3p_t0_cl177
label values  esplav_t0 esplav_t0_cl178
label values  trim_t1 trim_t1_cl181
label values  sg24_t1 sg24_t1_cl183
label values  sg24a_t1 sg24a_t1_cl184
label values  sg24b_t1 sg24b_t1_cl185
label values  b1_t1 b1_t1_cl186
label values  b2_t1 b2_t1_cl187
label values  b3_t1 b3_t1_cl188
label values  b4_t1 b4_t1_cl189
label values  b4a_t1 b4a_t1_cl190
label values  c1_t1 c1_t1_cl191
label values  c1a_t1 c1a_t1_cl192
label values  c4_t1 c4_t1_cl193
label values  c5_t1 c5_t1_cl194
label values  c6_t1 c6_t1_cl195
label values  c7_t1 c7_t1_cl196
label values  c9_t1 c9_t1_cl197
label values  c10_t1 c10_t1_cl198
label values  c14_t1 c14_t1_cl199
label values  c18_t1 c18_t1_cl200
label values  c20_t1 c20_t1_cl201
label values  c22_t1 c22_t1_cl203
label values  c24_t1 c24_t1_cl204
label values  c24bis_t1 c24bis_t1_cl205
label values  c24ter_t1 c24ter_t1_cl206
label values  c25_t1 c25_t1_cl207
label values  c27_t1 c27_t1_cl208
label values  c27b_t1 c27b_t1_cl209
label values  c27d_t1 c27d_t1_cl210
label values  c28_t1 c28_t1_cl211
label values  c29b_t1 c29b_t1_cl212
label values  c32_t1 c32_t1_cl215
label values  c33_t1 c33_t1_cl216
label values  c34_t1 c34_t1_cl217
label values  c35_t1 c35_t1_cl218
label values  c38_t1 c38_t1_cl221
label values  c39a_t1 c39a_t1_cl223
label values  c40_t1 c40_t1_cl224
label values  c42_t1 c42_t1_cl225
label values  c43_t1 c43_t1_cl226
label values  c44_t1 c44_t1_cl227
label values  c45_t1 c45_t1_cl228
label values  c46_t1 c46_t1_cl229
label values  c47_t1 c47_t1_cl230
label values  c48_t1 c48_t1_cl231
label values  c59_t1 c59_t1_cl232
label values  c59ab_t1 c59ab_t1_cl233
label values  c60_t1 c60_t1_cl234
label values  d1_t1 d1_t1_cl235
label values  d3_t1 d3_t1_cl237
label values  d4_t1 d4_t1_cl238
label values  d5_t1 d5_t1_cl239
label values  f1_t1 f1_t1_cl240
label values  f2_t1 f2_t1_cl241
label values  f3_t1 f3_t1_cl242
label values  f4_t1 f4_t1_cl243
label values  f5_t1 f5_t1_cl244
label values  f6_01_t1 f6_01_t1_cl245
label values  f6_02_t1 f6_02_t1_cl246
label values  f6_03_t1 f6_03_t1_cl247
label values  f6_04_t1 f6_04_t1_cl248
label values  f6_05_t1 f6_05_t1_cl249
label values  f6_06_t1 f6_06_t1_cl250
label values  f6_07_t1 f6_07_t1_cl251
label values  f6_08_t1 f6_08_t1_cl252
label values  f6_09_t1 f6_09_t1_cl253
label values  f6_10_t1 f6_10_t1_cl254
label values  f6_11_t1 f6_11_t1_cl255
label values  f6_12_t1 f6_12_t1_cl256
label values  f6_96_t1 f6_96_t1_cl257
label values  f6a_01_t1 f6a_01_t1_cl258
label values  f6a_02_t1 f6a_02_t1_cl259
label values  f6a_03_t1 f6a_03_t1_cl260
label values  f6a_96_t1 f6a_96_t1_cl261
label values  f7_t1 f7_t1_cl262
label values  f8_t1 f8_t1_cl263
label values  f10_t1 f10_t1_cl264
label values  f10a_t1 f10a_t1_cl265
label values  f12_t1 f12_t1_cl266
label values  f13_t1 f13_t1_cl267
label values  f14_t1 f14_t1_cl268
label values  f16_t1 f16_t1_cl269
label values  f17_t1 f17_t1_cl270
label values  f18_t1 f18_t1_cl271
label values  f19_t1 f19_t1_cl272
label values  f20_t1 f20_t1_cl273
label values  f21_t1 f21_t1_cl274
label values  f22_t1 f22_t1_cl275
label values  f23_t1 f23_t1_cl276
label values  f24_t1 f24_t1_cl277
label values  f24a_01_t1 f24a_01_t1_cl278
label values  f24a_02_t1 f24a_02_t1_cl279
label values  f24a_03_t1 f24a_03_t1_cl280
label values  f24a_96_t1 f24a_96_t1_cl281
label values  f25_t1 f25_t1_cl282
label values  f26_t1 f26_t1_cl283
label values  f27_t1 f27_t1_cl284
label values  f28_t1 f28_t1_cl285
label values  f29_01_t1 f29_01_t1_cl286
label values  f29_02_t1 f29_02_t1_cl287
label values  f29_03_t1 f29_03_t1_cl288
label values  f29_04_t1 f29_04_t1_cl289
label values  f29_97_t1 f29_97_t1_cl290
label values  f30_t1 f30_t1_cl291
label values  f33_t1 f33_t1_cl292
label values  f34_t1 f34_t1_cl293
label values  f35_t1 f35_t1_cl294
label values  f36_t1 f36_t1_cl295
label values  f37_t1 f37_t1_cl296
label values  f38_t1 f38_t1_cl297
label values  f40_t1 f40_t1_cl298
label values  f41_t1 f41_t1_cl299
label values  f45_t1 f45_t1_cl300
label values  f46_t1 f46_t1_cl301
label values  f47_t1 f47_t1_cl302
label values  f48_t1 f48_t1_cl303
label values  f49_t1 f49_t1_cl304
label values  f50_t1 f50_t1_cl305
label values  i1_t1 i1_t1_cl306
label values  cond3_t1 cond3_t1_cl307
label values  cond10_t1 cond10_t1_cl308
label values  dipaut_t1 dipaut_t1_cl309
label values  dipind_t1 dipind_t1_cl310
label values  assocc_t1 assocc_t1_cl311
label values  pospro_t1 pospro_t1_cl312
label values  detind_t1 detind_t1_cl313
label values  piepar_t1 piepar_t1_cl314
label values  prof1_t1 prof1_t1_cl316
label values  ate2d_t1 ate2d_t1_cl318
label values  cat12_t1 cat12_t1_cl319
label values  cat5_t1 cat5_t1_cl320
label values  cat3_t1 cat3_t1_cl321
label values  lavspe_t1 lavspe_t1_cl322
label values  regspe_t1 regspe_t1_cl323
label values  dipaus_t1 dipaus_t1_cl324
label values  dipins_t1 dipins_t1_cl325
label values  prof1s_t1 prof1s_t1_cl326
label values  ate2ds_t1 ate2ds_t1_cl328
label values  cat12s_t1 cat12s_t1_cl329
label values  cat5s_t1 cat5s_t1_cl330
label values  cat3s_t1 cat3s_t1_cl331
label values  esplav_t1 esplav_t1_cl332
label values  motipt_t1 motipt_t1_cl333
*/
save  RCFL_Long3_A2018.dta, replace
