/*    LIMITAZIONE DELLA RESPONSABILITA'. 
  Il software  fornito "cos com'", senza garanzie di  sorta.               */
%macro grabpath;
%qsubstr(%sysget(SAS_EXECFILEPATH),1,%length(%sysget(SAS_EXECFILEPATH))-%length(%sysget(SAS_EXECFILEname)))
%mend grabpath;
%let path = %grabpath;
%let nomeFile =ISTAT_MFR_VV_Microdati_2015_Individui_ESEMPIO_STRUTTURA_FILE.txt;
LIBNAME ISTAT "&path";
DATA ISTAT.VV_A2015_Individui;

INFILE "&path&nomeFile" DLM='5E'x  LRECL=32767 TRUNCOVER FIRSTOBS=2 IGNOREDOSEOF;
INPUT 
tr : $2.   /*  tipo record */
mese : $2.   /*  mese di riferimento dei dati */
annrif : $4.   /*  anno di riferimento dei dati */
progind : $5.   /*  Numero d'ordine progressivo individuale sull'anno */
sesso : $1.   /*  sesso */
eta5 : $2.   /*  Classi di et in anni compiuti */
staciv : $1.   /*  stato civile */
citt : $1.   /*  cittadinanza */
reg : $3.   /*  regione di residenza */
rip : $1.   /*  ripartizione geografica di residenza */
istr : $2.   /*  titolo di studio pi alto conseguito */
condogg : $2.   /*  condizione professionale oggettiva */
posiz : $2.   /*  posizione nella professione */
ateco10 : $2.   /*  settore di attivit economica */
cond : $2.   /*  condizione professionale soggettiva */
ORARIO : $1.   /*  tipo di orario di lavoro */
RAPP : $1.   /*  tipo di rapporto di lavoro */
CODPROF : $1.   /*  codifica della professione lavorativa (Grandi gruppi) */
novac : $2.   /*  motivo per cui l'individuo non ha effettuato vacanze nel mese */
lavat :2.   /*  numero totale viaggi di lavoro abituali nel mese */
noxlat :2.   /*  numero totale di notti per viaggi di lavoro abituali nel mese */
vacat :2.   /*  numero totale viaggi di vacanza abituali nel mese */
noxvat :2.   /*  numero totale di notti per viaggi di vacanza abituali nel mese */
IESC : $1.   /*  presenza escursioni effettuate dall'individuo nel mese */
INESC :2.   /*  numero escursioni effettuate dall'individuo nel mese */
ivia : $1.   /*  presenza viaggi effettuati dall'individuo nel mese */
invia :2.   /*  numero viaggi effettuati dall'individuo nel mese */
ilav : $1.   /*  presenza viaggi di lavoro effettuati dall'individuo nel mese */
inlav :2.   /*  numero viaggi di lavoro effettuati dall'individuo nel mese */
ivac : $1.   /*  presenza viaggi di vacanza effettuati dall'individuo nel mese */
invac :2.   /*  numero viaggi di vacanza effettuati dall'individuo nel mese */
ibreve : $1.   /*  presenza viaggi di vacanza di 1-3 notti effettuati dall'individuo nel mese */
inbreve :2.   /*  numero viaggi di vacanza di 1-3 notti effettuati dall'individuo nel mese */
ilunga : $1.   /*  presenza viaggi di vacanza di 4 o pi notti effettuati dall'individuo nel mese */
inlunga :2.   /*  numero viaggi di vacanza di 4 o pi notti effettuati dall'individuo nel mese */
W :19.7   /*  coefficiente di riporto per le stime di viaggi, escursioni e individui (turisti e non turisti) nel mese medio del trimestre */
COEV :19.7   /*  coefficiente di riporto per il calcolo dell'ammontare dei viaggi (abituali e non abituali) ed escursioni nel mese, nel trimestre e nell'anno */
TRIM : $2.   /*  trimestre di riferimento dei dati */
DOMINIO : $1.   /*  tipologia socio-demografica del comune di residenza */
ncomp : $2.   /*  numero componenti della famiglia di fatto dell'intervista iniziale */
pnasc : $1.   /*  se lo stato di nascita  Italia o un paese estero */
;
LABEL 
tr = "tipo record"
mese = "mese di riferimento dei dati"
annrif = "anno di riferimento dei dati"
progind = "Numero d'ordine progressivo individuale sull'anno"
sesso = "sesso"
eta5 = "Classi di et in anni compiuti"
staciv = "stato civile"
citt = "cittadinanza"
reg = "regione di residenza"
rip = "ripartizione geografica di residenza"
istr = "titolo di studio pi alto conseguito"
condogg = "condizione professionale oggettiva"
posiz = "posizione nella professione"
ateco10 = "settore di attivit economica"
cond = "condizione professionale soggettiva"
ORARIO = "tipo di orario di lavoro"
RAPP = "tipo di rapporto di lavoro"
CODPROF = "codifica della professione lavorativa (Grandi gruppi)"
novac = "motivo per cui l'individuo non ha effettuato vacanze nel mese"
lavat = "numero totale viaggi di lavoro abituali nel mese"
noxlat = "numero totale di notti per viaggi di lavoro abituali nel mese"
vacat = "numero totale viaggi di vacanza abituali nel mese"
noxvat = "numero totale di notti per viaggi di vacanza abituali nel mese"
IESC = "presenza escursioni effettuate dall'individuo nel mese"
INESC = "numero escursioni effettuate dall'individuo nel mese"
ivia = "presenza viaggi effettuati dall'individuo nel mese"
invia = "numero viaggi effettuati dall'individuo nel mese"
ilav = "presenza viaggi di lavoro effettuati dall'individuo nel mese"
inlav = "numero viaggi di lavoro effettuati dall'individuo nel mese"
ivac = "presenza viaggi di vacanza effettuati dall'individuo nel mese"
invac = "numero viaggi di vacanza effettuati dall'individuo nel mese"
ibreve = "presenza viaggi di vacanza di 1-3 notti effettuati dall'individuo nel mese"
inbreve = "numero viaggi di vacanza di 1-3 notti effettuati dall'individuo nel mese"
ilunga = "presenza viaggi di vacanza di 4 o pi notti effettuati dall'individuo nel mese"
inlunga = "numero viaggi di vacanza di 4 o pi notti effettuati dall'individuo nel mese"
W = "coefficiente di riporto per le stime di viaggi, escursioni e individui (turisti e non turisti) nel mese medio del trimestre"
COEV = "coefficiente di riporto per il calcolo dell'ammontare dei viaggi (abituali e non abituali) ed escursioni nel mese, nel trimestre e nell'anno"
TRIM = "trimestre di riferimento dei dati"
DOMINIO = "tipologia socio-demografica del comune di residenza"
ncomp = "numero componenti della famiglia di fatto dell'intervista iniziale"
pnasc = "se lo stato di nascita  Italia o un paese estero"
;
RUN;
PROC FORMAT;
VALUE $tr0F /* tr */
"02" = "Record individuale"
"03" = "Record viaggi"
"04" = "Record escursioni"
;
VALUE $ses4F /* sesso */
"1" = "Maschi"
"2" = "Femmine"
;
VALUE $eta5F /* eta5 */
"01" = "<=5 anni"
"02" = "6-14 anni"
"03" = "15-17 anni"
"04" = "18-24 anni"
"05" = "25-29 anni"
"06" = "30-34 anni"
"07" = "35-39 anni"
"08" = "40-44 anni"
"09" = "45-49 anni"
"10" = "50-54 anni"
"11" = "55-59 anni"
"12" = "60-64 anni"
"13" = "65-69 anni"
"14" = "70-74 anni"
"15" = ">=75 anni"
;
VALUE $sta6F /* staciv */
"1" = "Celibe/nubile"
"2" = "Coniugato"
"3" = "Separato di fatto"
"4" = "Separato legalmente"
"5" = "Divorziato"
"6" = "Vedovo"
;
VALUE $cit7F /* citt */
"1" = "Italiana"
"2" = "Estera"
;
VALUE $reg8F /* reg */
"010" = "Piemonte"
"020" = "Valle d'Aosta/Valle d'Aoste"
"030" = "Lombardia"
"040" = "Trentino A.Adige/Sudtirol"
"050" = "Veneto"
"060" = "Friuli-Venezia Giulia"
"070" = "Liguria"
"080" = "Emilia-Romagna"
"090" = "Toscana"
"100" = "Umbria"
"110" = "Marche"
"120" = "Lazio"
"130" = "Abruzzo"
"140" = "Molise"
"150" = "Campania"
"160" = "Puglia"
"170" = "Basilicata"
"180" = "Calabria"
"190" = "Sicilia"
"200" = "Sardegna"
;
VALUE $rip9F /* rip */
"11" = "Nord-ovest"
"12" = "Nord-est"
"23" = "Centro"
"34" = "Sud"
"35" = "Isole"
;
VALUE $ist10F /* istr */
"01" = "Nessun titolo"
"02" = "Licenza elementare"
"03" = "Licenza media (licenza di avviamento professionale)"
"04" = "Titolo di istruzione secondaria superiore che non permette l'accesso all'universit"
"05" = "Diploma di istruzione secondaria superiore che permette l'accesso all'universit"
"06" = "Diploma terziario extra-universitario (AFAM: Accademia di belle arti, Istituto superiore di industrie artistiche,Accademia naz. di arte drammatica, Conservatorio musicale e istituto musicale pareggiat"
"07" = "Diploma universitario (corso di diploma universitario, istituto superiore di educazione fisica, scuola diretta a fini speciali, scuola parauniversitaria)"
"08" = "Laurea di primo livello - nuovo ordinamento (corsi di 3 anni)"
"09" = "Diploma di laurea - vecchio ordinamento (corsi di 4/6 anni)"
"10" = "Laurea specialistica a ciclo unico - nuovo ordinamento (corsi di 5/6 anni)"
"11" = "Laurea specialistica - nuovo ordinamento (corsi di secondo livello di 2 anni)"
"12" = "Titolo di studio post-laurea o post-AFAM (diploma di specializzazione, master universitario di 1 e di 2 livello)"
"13" = "Titolo di dottore di ricerca"
;
VALUE $con11F /* condogg */
"01" = "Occupato"
"02" = "In cerca di occupazione"
"03" = "Inattivo"
;
VALUE $pos12F /* posiz */
"01" = "Dirigente"
"02" = "Quadro"
"03" = "Impiegato"
"04" = "Operaio"
"05" = "Apprendista"
"06" = "Lavorante a domicilio per conto dimprese"
"07" = "Imprenditore"
"08" = "Libero professionista"
"09" = "Lavoratore in proprio"
"10" = "Socio di cooperativa"
"11" = "Coadiuvante nell'azienda di un familiare"
"12" = "Collaboratore coordinato e continuativo (con o senza progetto)"
"13" = "Prestatore d'opera occasionale"
;
VALUE $ate13F /* ateco10 */
"01" = "Agricoltura, caccia e pesca'"
"02" = "Industria'"
"03" = "Costruzioni'"
"04" = "Commercio, trasporto, magazzinaggio, alberghi, ristoranti'"
"05" = "Informazione e comunicazione'"
"06" = "Attivit finanziarie'"
"07" = "Attivit immobiliari'"
"08" = "Attivit professionali, scientifiche, attivit amministrative, servizi di supporto"
"09" = "Pubblica amministrazione, Difesa, Istruzione, Sanit, altri servizi sociali'"
"10" = "Altri servizi'"
;
VALUE $con14F /* cond */
"01" = "Occupato"
"02" = "In cerca di prima occupazione"
"03" = "In cerca di nuova occupazione"
"04" = "Casalinga"
"05" = "Studente"
"06" = "Persona ritirata dal lavoro"
"07" = "In altra condizione"
;
VALUE $ORA15F /* ORARIO */
"1" = "A tempo pieno"
"2" = "A tempo parziale"
;
VALUE $RAP16F /* RAPP */
"1" = "A tempo determinato"
"2" = "A tempo indeterminato"
;
VALUE $COD17F /* CODPROF */
"1" = "LEGISLATORI, IMPRENDITORI E ALTA DIRIGENZA"
"2" = "PROFESSIONI INTELLETTUALI, SCIENTIFICHE E DI ELEVATA SPECIALIZZAZIONE"
"3" = "PROFESSIONI TECNICHE"
"4" = "PROFESSIONI ESECUTIVE NEL LAVORO D'UFFICIO"
"5" = "PROFESSIONI QUALIFICATE NELLE ATTIVITA COMMERCIALI E NEI SERVIZI"
"6" = "ARTIGIANI, OPERAI SPECIALIZZATI E AGRICOLTORI"
"7" = "CONDUTTORI DI IMPIANTI, OPERAI DI MACCHINARI FISSI E MOBILI E CONDUCENTI DI VEICOLI"
"8" = "PROFESSIONI NON QUALIFICATE"
"9" = "FORZE ARMATE"
;
VALUE $nov18F /* novac */
"01" = "Motivi economici"
"02" = "Motivi di lavoro,studio,familiari"
"03" = "Mancanza di abitudine"
"04" = "Altri motivi (inclusi motivi di salute)"
"99" = "Non sa, non risponde"
;
VALUE $IES23F /* IESC */
"0" = "Nessuna escursione dell'individuo"
"1" = "Almeno un'escursione dell'individuo"
;
VALUE $ivi25F /* ivia */
"0" = "Nessun viaggio dell'individuo"
"1" = "Almeno un viaggio dell'individuo"
;
VALUE $ila27F /* ilav */
"0" = "Nessun viaggio di lavoro dell'individuo"
"1" = "Almeno un viaggio di lavoro dell'individuo"
;
VALUE $iva29F /* ivac */
"0" = "Nessun viaggio di vacanza dell'individuo"
"1" = "Almeno un viaggio di vacanza dell'individuo"
;
VALUE $ibr31F /* ibreve */
"0" = "Nessun viaggio di vacanza 1-3 notti dell'individuo"
"1" = "Almeno un viaggio di vacanza 1-3 notti dell'individuo"
;
VALUE $ilu33F /* ilunga */
"0" = "Nessun viaggio di vacanza lunga dell'individuo"
"1" = "Almeno un viaggio di vacanza lunga dell'individuo"
;
VALUE $TRI37F /* TRIM */
"01" = "Gennaio-Marzo"
"02" = "Aprile-Giugno"
"03" = "Luglio-Settembre"
"04" = "Ottobre-Dicembre"
;
VALUE $DOM38F /* DOMINIO */
"1" = "Comuni centro dell'area metropolitana"
"2" = "Comuni periferia dell'area metropolitana e comuni con 50.001 ab. e pi"
"3" = "Altri comuni fino a 50.000 ab."
;
VALUE $nco39F /* ncomp */
"1" = "1 componente"
"2" = "2 componenti"
"3" = "3 componenti"
"4" = "4 componenti"
"5" = "5 componenti"
"6" = "6 o pi componenti"
;
VALUE $pna40F /* pnasc */
"1" = "Italia"
"2" = "Estero"
;
format tr $tr0F.;
format sesso $ses4F.;
format eta5 $eta5F.;
format staciv $sta6F.;
format citt $cit7F.;
format reg $reg8F.;
format rip $rip9F.;
format istr $ist10F.;
format condogg $con11F.;
format posiz $pos12F.;
format ateco10 $ate13F.;
format cond $con14F.;
format ORARIO $ORA15F.;
format RAPP $RAP16F.;
format CODPROF $COD17F.;
format novac $nov18F.;
format IESC $IES23F.;
format ivia $ivi25F.;
format ilav $ila27F.;
format ivac $iva29F.;
format ibreve $ibr31F.;
format ilunga $ilu33F.;
format TRIM $TRI37F.;
format DOMINIO $DOM38F.;
format ncomp $nco39F.;
format pnasc $pna40F.;
RUN;
